<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
class Themento_Video extends Widget_Base {

    public function get_name() {
        return 'themento_video';
    }

    public function get_title() {
        return __( 'Aparat', text_domain );
    }

    public function get_categories() {
        return [ text_domain ];
    }

    public function get_icon() {
        return 'eicon-play';
    }

    public function get_keywords() {
        return [ 'heading', 'header', 'page' ];
    }

    protected function register_controls() {
        $this->register_general_style_controls();
    }

    protected function register_general_style_controls() {
        $this->start_controls_section(
            'section_general_style',
            [
                'label' => __( 'Content', text_domain ),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'aparat_id',
            [
                'label' => __( 'Aparat ID', text_domain ),
                'type' => Controls_Manager::TEXT,
                'default' => __( 'aMt62', text_domain ),
                'description' => __( 'Paste the video ID from the address bar For example the video address https://www.aparat.com/v/aMt62 Just put aMt62 ID', text_domain ),
            ]
        );


			  $this->add_control(
			    'border_radius_video',
			    [
				    'label' => __( 'Border Radius', text_domain ),
				    'type' => Controls_Manager::DIMENSIONS,
				    'size_units' => [ 'px', '%', 'em' ],
						'default' => [
							'top' => '5',
	            'right' => '5',
	            'bottom' => '5',
	            'left' => '5',
	            'unit' => 'px',
	            'isLinked' => false,
						],
				    'selectors' => [
					      '{{WRAPPER}} iframe' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				       ],
			      ]
		      );

			  $this->add_control(
			     'width_veideo',
			     [
				     'label' => __( 'Width', text_domain ),
				     'type' => Controls_Manager::SLIDER,
				     'size_units' => [ 'px', '%' ],
				     'range' => [
					     'px' => [
						     'min' => 0,
						     'max' => 1000,
					      ],
					     '%' => [
						     'min' => 0,
						     'max' => 100,
					     ],
				      ],
				     'default' => [
					      'unit' => '%',
					      'size' => 100,
				      ],
				     'selectors' => [
					      '{{WRAPPER}} .h_iframe-aparat_embed_frame' => 'width: {{SIZE}}{{UNIT}};',
				      ],
			      ]
	     	);
				$this->add_control(
			     'height_veideo',
			     [
				     'label' => __( 'Height', text_domain ),
				     'type' => Controls_Manager::SLIDER,
				     'size_units' => [ 'px', '%' ],
				     'range' => [
					     'px' => [
						     'min' => 0,
						     'max' => 1000,
					      ],
					     '%' => [
						     'min' => 0,
						     'max' => 200,
					     ],
				      ],
				     'default' => [
					      'unit' => '%',
					      'size' => 100,
				      ],
				     'selectors' => [
					      '{{WRAPPER}} .h_iframe-aparat_embed_frame' => 'height: {{SIZE}}{{UNIT}};',
				      ],
			      ]
	     	);

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();
            echo '<div class="h_iframe-aparat_embed_frame"><span class="aparat_embed_frame_span"></span><iframe src="https://www.aparat.com/video/video/embed/videohash/'. $settings['aparat_id'] . '/vt/frame" allowFullScreen="true" webkitallowfullscreen="true" mozallowfullscreen="true"></iframe></div>';
    }
}
Plugin::instance()->widgets_manager->register( new Themento_Video );
