<?php get_header(); ?>

<div class="container">
    <!-- Page Layout here -->
    <div class="row" id="main_row">
        <?php get_sidebar('home'); ?>

        <div class="col l8 m12 s12 do_rtl content" id="content">
            <?php
            if (have_posts()) :
            while (have_posts()) :the_post();
            ?>
            <div class="col s12 m12 l12">
                <div class="card z-depth-0 single_card">
                    <div class="card-image movie_card_cover">
                        <div class="col s3 l3 m3 movie_card_image z-depth-3 no-padding hoverable right">
                            <?php
                            if ( has_post_thumbnail() ) {
                                ?>
                                <img alt="<?php the_title();?>" src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'large');?>">
                                <?php
                            }
                            ?>
                        </div>
                        <span class="card-title movie_card_title right"><?php the_title();?></span>
                        <ul class="right details_info">
                            <li><b>سال ساخت</b> : <span><?php echo get_post_meta(get_the_ID(),"c_year_make",true);?></span></li>
                            <li><b>سال اکران</b> : <span><?php echo get_post_meta(get_the_ID(),"c_year",true);?></span></li>
                            <li><b>کارگردان</b> : <span><?php echo get_post_meta(get_the_ID(),"c_director",true);?></span></li>
                            <li><b>بازیگران</b> : <span><?php echo get_post_meta(get_the_ID(),"c_actors",true);?></span></li>
                        </ul>
                    </div>
                    <div class="card-action single_card_action px_no movie_card_action left">
                        <?php do_action('c_content_footer'); ?>
                    </div>
                    <br>
                    <br>
                    <br>
                    <div class="card-content px_no">
                        <?php the_content(); ?>
                        <div class="row no-padding movie_guide">
                            <!--<div class="col l6 s12 m6">
                                <a class="waves-effect waves-light btn-large movie_guide_news" href=""><i class="fa fa-newspaper-o"></i> خبر مرتبط </a>
                            </div>!-->
                            <div class="col l12 s12 m6">
                                <a class="waves-effect waves-light btn-large movie_guide_video modal-trigger" href="#video_modal1"><i class="fa fa-video-camera"></i> نمایش تریلر</a>
                            </div>
                            <div id="video_modal1" class="modal over_hide">
                            <div class="modal-content no-padding">
                            <div class="video-container responsive-video">

                              <?php echo get_post_meta(get_the_ID(),"video_link",true);?>

                            </div>
                            </div>
                            <div class="modal-footer">
                              <a href="#!" class="modal-action modal-close waves-effect waves-green btn-flat">بستن</a>
                            </div>
                          </div>
                        </div>
                    </div>
                </div>

            </div>
                <?php
            endwhile;
            endif;
            ?>
            <div class="col s12 m12 l12">
                <?php do_action('c_related'); ?>
            </div>

            <diV class="col s12 m12 l12">
                <?php
                    $tags = get_post_meta(get_the_ID(),"c_related",true);
                    $tags = str_replace(" ","-",$tags);
                    $the_query = new WP_Query(array( "post-type" => "post", "tag" => $tags ));?>
                    <br>
                    <h5 class="title_right">اخبار مرتبط</h5>
                    <div class="row z-depth-2">
                        <div class="collection">
                        <?php if ( $the_query->have_posts() ) : ?>
                        <!-- pagination here -->
                        <!-- the loop -->
                        <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
                            <a class="collection-item" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        <?php endwhile; ?>
                        <!-- end of the loop -->
                        <!-- pagination here -->
                        <?php wp_reset_postdata(); ?>
                        </div>
                    <?php else : ?>
                        <p style="padding:15px;"><?php esc_html_e( 'اخبار مرتبط وجود ندارد' ); ?></p>
                    <?php endif; ?>
                    </div>
            </diV>
            
            <diV class="col s12 m12 l12">
                <?php
                
                    ?>
                    <br>
                    <h5 class="title_right">دیدگاه ها</h5>
                    <div class="row z-depth-2">
                        <?php comments_template(); ?>
                    </div>
            </diV>
            
            <diV class="col s12 m12 l12 tags_block">
                <p>برچسب ها</p>
                <?php
                $terms = get_the_terms( get_the_ID() , 'movie-tags' );
                if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
                    foreach ( $terms as $term ) {
                        echo '<a href="/movies-tags/'.$term->slug.'">' . $term->name . '</a>';
                    }
                }
                ?>
            </diV>


        </div>

    </div>
</div>

<?php get_footer(); ?>
