<!DOCTYPE html>
<html <?php language_attributes(); ?>>
  <head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <!-- Favicons -->
  <?php $personaltheme = get_option( 'personaltheme_options' );?>
  <link href="<?php echo $personaltheme['favicon']['url'];?>" rel="icon">
 <?php wp_head();?>
  </head>
  <body>
  <!-- ======= Header ======= -->
<?php
$lang = get_bloginfo("language"); 

if ($lang == 'fa-IR') {	
include( 'sections/header/fa.php' );
} 
else {
include( 'sections/header/en.php' );
}
?>
  <!-- End Header -->
  <!-- ======= About Section ======= -->
  <section id="about" class="about">

    <!-- ======= About Me ======= -->
    <div class="about-me container">

      <div class="section-title">
        <h2><?php echo $personaltheme['onvan-about'];?></h2>
        <p><?php echo $personaltheme['about-p'];?></p>
      </div>

      <div class="row">
        <div class="col-lg-4" data-aos="fade-right">
          <img src="<?php echo $personaltheme['about-aks']['url'];?>" class="img-fluid" alt="">
        </div>
        <div class="col-lg-8 pt-4 pt-lg-0 content" data-aos="fade-left">
          <h3><?php echo $personaltheme['onvan2-about'];?></h3>
          <p class="fst-italic">
<?php echo $personaltheme['about-p2'];?>
          </p>
          <div class="row">
            <div class="col-lg-6">
              <ul>
			  <?php
                  $bio_repeaters = $personaltheme['bio-repeater'];
                  foreach($bio_repeaters as $bio_repeater){
               ?>
                <li><i class="<?php echo $bio_repeater['bio-repeater-icon'];?>"></i> <?php echo $bio_repeater['bio-repeater1'];?><span>&nbsp<?php echo $bio_repeater['bio-repeater2'];?></span></li>
			 <?php
                  }
               ?>
              </ul>
            </div>
            <div class="col-lg-6">
              <ul>
			  	<?php
                  $bio_repeaters = $personaltheme['bio-repeater2'];
                  foreach($bio_repeaters as $bio_repeater){
               ?>
                <li><i class="<?php echo $bio_repeater['bio-repeater-icon2'];?>"></i><?php echo $bio_repeater['bio-repeater3'];?><span>&nbsp<?php echo $bio_repeater['bio-repeater4'];?></span></li>
				<?php
                  }
               ?>
              </ul>
            </div>
          </div>
          <p>
<?php echo $personaltheme['about-p3'];?>
          </p>
        </div>
      </div>

    </div>
	<!-- End About Me -->

    <!-- ======= Counts ======= -->
	<?php if ($personaltheme ['switcher-amar-options']){?>
    <div class="counts container">
      <div class="row">
		  		<?php
                  $amar_repeaters = $personaltheme['amar-repeater'];
                  foreach($amar_repeaters as $amar_repeater){
               ?>
        <div class="col-lg-3 col-md-6 mt-5 mt-lg-0">
          <div class="count-box">
            <i class="<?php echo $amar_repeater['amar-repeater-icon'];?>"></i>
            <span data-purecounter-start="0" data-purecounter-end="<?php echo $amar_repeater['amar-repeater-adad'];?>" data-purecounter-duration="1" class="purecounter"></span>
            <p><?php echo $amar_repeater['amar-repeater-onvan'];?></p>

          </div>
        </div>
			    <?php
                  }
               ?>
      </div>
    </div>
	<?php } ?>
	<!-- End Counts -->

    <!-- ======= Skills  ======= -->
	<?php if ($personaltheme ['switcher-skill-options']){?>
    <div class="skills container">

      <div class="section-title">
        <h2><?php echo $personaltheme['onvan-skill'];?></h2>
      </div>

      <div class="row skills-content">

        <div class="col-lg-6">
				<?php
                  $skill_repeaters = $personaltheme['skill-repeater1'];
                  foreach($skill_repeaters as $skill_repeater){
               ?>
          <div class="progress">
            <span class="skill"><?php echo $skill_repeater['skill-repeater-onvan1'];?><i class="val"><?php echo $skill_repeater['skill-repeater-adad1'];?>%</i></span>
            <div class="progress-bar-wrap">
              <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo $skill_repeater['skill-repeater-adad1'];?>" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
          </div>
		         <?php
                  }
               ?>
        </div>

        <div class="col-lg-6">
         		<?php
                  $skill_repeaters = $personaltheme['skill-repeater2'];
                  foreach($skill_repeaters as $skill_repeater){
               ?>
          <div class="progress">
            <span class="skill"><?php echo $skill_repeater['skill-repeater-onvan2'];?><i class="val"><?php echo $skill_repeater['skill-repeater-adad2'];?>%</i></span>
            <div class="progress-bar-wrap">
              <div class="progress-bar" role="progressbar" aria-valuenow="<?php echo $skill_repeater['skill-repeater-adad2'];?>" aria-valuemin="0" aria-valuemax="100"></div>
            </div>
          </div>
		         <?php
                  }
               ?>
        </div>

      </div>

    </div>
	<?php } ?>
	<!-- End Skills -->

    <!-- ======= Interests ======= -->
	<?php if ($personaltheme ['Interests-options']){?>
    <div class="interests container">
      <div class="section-title">
        <h2><?php echo $personaltheme['onvan-others'];?></h2>
      </div>

      <div class="row">
	  			<?php
                  $interest_repeaters = $personaltheme['icons-repeater'];
                  foreach($interest_repeaters as $interest_repeater){
               ?>
        <div class="col-lg-3 col-md-4 mt-4 mt-lg">
          <div class="icon-box">
            <i class="<?php echo $interest_repeater['icon-icons-repeater'];?>" style="color: <?php echo $interest_repeater['color-icons-repeater'];?>;"></i>
            <h3><?php echo $interest_repeater['onvan-icons-repeater'];?></h3>
          </div>
        </div>
		<?php
		}
		?>
        </div>
      </div>
    </div>
	<?php } ?>
	<!-- End Interests -->

    <!-- ======= Testimonials ======= -->
	<?php if ($personaltheme ['switcher-testimonials-options']){?>
    <div class="testimonials container">

      <div class="section-title">
        <h2><?php echo $personaltheme['onvan-testimonials'];?></h2>
      </div>

      <div class="testimonials-slider swiper-container" data-aos="fade-up" data-aos-delay="100">
        <div class="swiper-wrapper">
		  <?php 
                  $testimonials_repeaters = $personaltheme['testimonials-repeater'];
                  foreach($testimonials_repeaters as $testimonials_repeater){
           ?>
          <div class="swiper-slide">
            <div class="testimonial-item">
              <p>
                <i class="bx bxs-quote-alt-left quote-icon-left"></i>
                <?php echo $testimonials_repeater['testimonials-repeater-p'];?>
                <i class="bx bxs-quote-alt-right quote-icon-right"></i>
              </p>
              <img src="<?php echo $testimonials_repeater['testimonials_repeater_aks']['url']; ?>" class="testimonial-img" alt="">
              <h3><?php echo $testimonials_repeater['testimonials-repeater-onvan'];?></h3>
              <h4><?php echo $testimonials_repeater['testimonials-repeater-samat'];?></h4>
            </div>
          </div><!-- End testimonial item -->
		<?php
		}
		?>
        </div>
        <div class="swiper-pagination"></div>
      </div>

      <div class="owl-carousel testimonials-carousel">

      </div>

    </div>
	<?php } ?>	
	<!-- End Testimonials  -->

  </section><!-- End About Section -->

  <!-- ======= Resume Section ======= -->
  <section id="resume" class="resume">
    <div class="container">

      <div class="section-title">
        <h2><?php echo $personaltheme['onvan-Resume'];?></h2>
        <p><?php echo $personaltheme['Resume-p'];?></p>
      </div>

      <div class="row">
        <div class="col-lg-6">
		    <?php
                  $personaltheme_repeaters = $personaltheme['Resume-repeater1'];
                  foreach($personaltheme_repeaters as $personaltheme_repeater){
           ?>
          <h3 class="resume-title"><?php echo $personaltheme_repeater['Resume-repeater-onvan1'];?></h3>
          <div class="resume-item pb-0">
            <p><?php echo $personaltheme_repeater['Resume-repeater-p1'];?></p>
          </div>
		  		<?php
                  }
               ?>
          </div>
        <div class="col-lg-6">
			<?php
                  $personaltheme_repeaters = $personaltheme['Resume-repeater2'];
                  foreach($personaltheme_repeaters as $personaltheme_repeater){
           ?>
          <h3 class="resume-title"><?php echo $personaltheme_repeater['Resume-repeater-onvan2'];?></h3>
          <div class="resume-item">
            <p><?php echo $personaltheme_repeater['Resume-repeater-p2'];?></p>
          </div>
		  		<?php
                  }
               ?>
        </div>
      </div>

    </div>

  </section><!-- End Resume Section -->

  <!-- ======= Services Section ======= -->
  <section id="services" class="services">
    <div class="container">

      <div class="section-title">
        <h2><?php echo $personaltheme['onvan-services'];?></h2>
        <p><?php echo $personaltheme['services-p'];?></p>
      </div>

      <div class="row">
<?php
                  $service_repeaters = $personaltheme['services-repeater'];
                  foreach($service_repeaters as $service_repeater){
?>

        <div class="col-lg-4 col-md-6 d-flex align-items-stretch mt-4">
          <div class="icon-box">
            <div class="icon"><i class="<?php echo $service_repeater['services-repeater-icon'];?>"></i></div>
            <h4><?php echo $service_repeater['services-repeater-onvan'];?></h4>
            <p><?php echo $service_repeater['services-repeater-p'];?></p>
			<?php if ($service_repeater['services-repeater-link']){?>
			<a href="<?php echo $service_repeater['services-repeater-link'];?>"><?php echo $service_repeater['services-repeater-link-matn'];?></a>
	<?php
}
?>		
          </div>
        </div>
<?php
}
?>
      </div>

    </div>

  </section><!-- End Services Section -->

  <!-- ======= Portfolio Section ======= -->
  <section id="portfolio" class="portfolio">
    <div class="container">

      <div class="section-title">
        <h2><?php echo $personaltheme['onvan-PORTFOLIO'];?></h2>
        <p><?php echo $personaltheme['PORTFOLIO-p'];?></p>
      </div>

        <div class="row">		
          <div class="col-lg-12 d-flex justify-content-center" data-aos="fade-up" data-aos-delay="100">
            <ul id="portfolio-flters">
					 <li data-filter="*" class="filter-active"><?php echo __( 'All', 'personaltheme');?></li>

					<?php
                        $portfolio_menus = get_terms('portfolio-cat');
                        foreach($portfolio_menus as $portfolio_menu){
                     ?>
                        <li data-filter=".filter-<?php echo $portfolio_menu->slug;?>"><?php echo $portfolio_menu->name;?></li>
                     <?php
                        }
                     ?>						
            </ul>
          </div>
        </div>

      <div class="row portfolio-container">
<?php
               $args = array(
                  'post_type' => 'portfolio',
                  'posts_per_page' => -1
               );
               $query = new WP_Query($args);
               while($query->have_posts()){
                  $query->the_post();
?>
        <div class="col-lg-4 col-md-6 portfolio-item filter-<?php
           $portfolio_items = get_the_terms(get_the_ID(), 'portfolio-cat');
           foreach ($portfolio_items as $portfolio_item){
           echo $portfolio_item->slug.' ';
           }
           ?>">
          <div class="portfolio-wrap">
<?php $thumbnail_id = get_post_thumbnail_id( $post->ID );
 $alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true); ?>
            <img src="<?php the_post_thumbnail_url('medium_large');?>" class="img-fluid" alt="<?php echo $alt;?>">
            <div class="portfolio-info">
              <h4><?php the_title();?></h4>
              <p><?php echo $portfolio_item->name;?></p>
              <div class="portfolio-links">
                <a href="<?php the_post_thumbnail_url(); ?>" data-gallery="portfolioGallery" class="portfolio-lightbox" title="<?php the_title();?>"><i class="fas fa-plus"></i></a>
                <a href="<?php the_permalink();?>" data-gallery="portfolioDetailsGallery" data-glightbox="type: external" class="portfolio-details-lightbox" title="<?php echo __( 'Project details', 'personaltheme');?>"><i class="fas fa-link"></i></a>
              </div>
            </div>
          </div>
        </div>
            <?php
               }
               wp_reset_postdata();
            ?>
      </div>

    </div>

  </section><!-- End Portfolio Section -->

  <!-- ======= blog Section ======= -->
  <section id="blog" class="blog">
    <div class="container">

      <div class="section-title">
        <h2><?php echo $personaltheme['onvan-blog'];?></h2>
        <p><?php echo $personaltheme['blog-p'];?></p>
		        <div class="row">

            <?php
               $args = array(
                  'post_type' => 'post',
                  'posts_per_page' => -1
               );
               $query = new WP_Query($args);
               while($query->have_posts()){
                  $query->the_post();
               ?>
          <div class="col-lg-4">
		   <div class="post-box">
<?php $thumbnail_id = get_post_thumbnail_id( $post->ID );
 $alt = get_post_meta($thumbnail_id, '_wp_attachment_image_alt', true); ?>
         <div class="post-img"><img src="<?php the_post_thumbnail_url('medium_large');?>" class="img-fluid" alt="<?php echo $alt;?>" style="width:100%; height:250px;"></div>
              <span class="post-date">
<?php echo the_date(); ?>			  
			  </span>
             <a href="<?php the_permalink();?>" data-glightbox="type: external"><h3 class="post-title"><?php echo the_title();?></h3></a>            
            </div>
			</div>
			<?php
               }
               wp_reset_postdata();
            ?>
          </div>
        </div>
      </div>
	</div>

  </section><!-- End blog Section -->
  <!-- ======= Contact Section ======= -->
  <section id="contact" class="contact">
    <div class="container">

      <div class="section-title">
        <h2><?php echo $personaltheme['onvan-tamas'];?></h2>
        <p><?php echo $personaltheme['tamas-p'];?></p>
      </div>

      <div class="row mt-2">

        <div class="col-md-6 d-flex align-items-stretch">
          <div class="info-box">
            <div class="social-linkstamasicon"><i class="fas fa-map-marker-alt"></i></div>
            <h3><?php echo $personaltheme['onvan-tamas1'];?></h3>
            <p><?php echo $personaltheme['onvan-tamas2'];?></p>
          </div>
        </div>

        <div class="col-md-6 mt-4 mt-md-0 d-flex align-items-stretch">
          <div class="info-box">
            <div class="social-linkstamasicon"><i class="fas fa-share-alt"></i></div>
			
            <h3><?php echo $personaltheme['onvan-tamas7'];?></h3>
      <div class="social-linkstamas">
	           <?php
                  $head_socials = $personaltheme['head_social'];
                  foreach($head_socials as $head_social){
               ?>
        <a href="<?php echo $head_social['head_social_url'];?>"target="<?php echo $personaltheme['head_link_target'];?>"><i class="<?php echo $head_social['head_social_icon'];?>"></i></a>
		       <?php
                  }
               ?>
      </div>
          </div>
        </div>

        <div class="col-md-6 mt-4 d-flex align-items-stretch">
          <div class="info-box">
            <div class="social-linkstamasicon"><i class="far fa-envelope"></i></div>
            <h3><?php echo $personaltheme['onvan-tamas3'];?></h3>
            <p><?php echo $personaltheme['onvan-tamas4'];?></p>
          </div>
        </div>
        <div class="col-md-6 mt-4 d-flex align-items-stretch">
          <div class="info-box">
            <div class="social-linkstamasicon"><i class="fas fa-phone-volume"></i></div>
            <h3><?php echo $personaltheme['onvan-tamas5'];?></h3>
            <p><?php echo $personaltheme['onvan-tamas6'];?></p>
          </div>
        </div>
      </div>

      <div class="php-email-form mt-4">
        <div class="row">
		<div class="contact-form">
		  <?php $content22 = $personaltheme['onvan-tamas9'];?>
		  <?php echo do_shortcode( $content22 );?>
	</div>
		</div>
    </div>

  </section><!-- End Contact Section -->
  </main><!-- End #main -->
	</body>  
<?php get_footer();?>