<?php
$hero_image_v = get_field('hero_image_v', 'option');
$hero_image_h = get_field('hero_image_h1', 'option');
$hero_image_h2 = get_field('hero_image_h2', 'option');
$hero_subtitle = get_field('hero_subtitle', 'option');
$hero_title = get_field('hero_title', 'option');
$hero_text = get_field('hero_desc', 'option');
$telegram = get_field('telegram', 'option');
$whatsapp = get_field('whatsapp', 'option');
$hero_phone = get_field('hero_phone', 'option');
?>
<div class="hero-wrapper position-relative" id="hero">
    <div class="container-lg">
        <div class="row">
            <div class="col-6 col-md-6 col-lg-5">
                <div class="hero-content wow fadeInUp">
                    <?php
                    if ($hero_title != '') {
                        echo '<h1 class="hero-title">' . $hero_title . '</h1>';
                    }
                    if ($hero_subtitle != '') {
                        echo '<h2 class="hero-subtitle">' . $hero_subtitle . '</h2>';
                    }
                    if ($hero_text != '') {
                        echo '<p class="hero-text">' . $hero_text . '</p>';
                    }
                    ?>
                </div>
                <?php if (have_rows('hero_counters', 'option')): ?>
                    <div class="hero-counter d-none d-md-flex">
                        <?php
                        $count = 1;
                        while (have_rows('hero_counters', 'option')) : the_row();
                            $title_c = get_sub_field('title', 'option');
                            $number_c = get_sub_field('number_c', 'option'); ?>
                            <div class="counter-item d-flex flex-column align-items-center justify-content-center">
                                <strong class="counter-num count"
                                        data-number="<?php echo $number_c; ?>"
                                        id="number<?php echo $count; ?>">
                                    <?php echo $number_c; ?>
                                </strong>
                                <span class="counter-title">
                                    <?php echo $title_c; ?>
                                </span>
                            </div>
                            <?php $count++; endwhile; ?>
                    </div>
                <?php endif; ?>
                <div class="hero-cta d-none d-md-flex">
                    <?php if ($telegram) { ?>
                        <a href="<?php echo $telegram; ?>" class="btn btn-hover">
                            <span>
                                <i class="icon-telegram"></i>
                                تلگرام
                            </span>
                        </a>
                    <?php }
                    if ($whatsapp) {
                        ?>
                        <a href="<?php echo $whatsapp; ?>" class="btn btn-hover">
                            <span>
                                <i class="icon-whatsapp"></i>
                                واتس اپ
                            </span>
                        </a>
                    <?php }
                    if ($hero_phone) {
                        ?>
                        <a href="tel:<?php echo $hero_phone; ?>" class="btn btn-hover">
                            <span>
                                <i class="icon-phone"></i>
                                تلفن تماس
                            </span>
                        </a>
                    <?php } ?>
                </div>
            </div>
            <div class="col-6 col-md-6 col-lg-7">
                <div class="d-grid hero-grid">
                    <div class="hero-img vertical">
                        <img src="<?php echo $hero_image_v['url']; ?>"
                             width="<?php echo $hero_image_v['width']; ?>"
                             height="<?php echo $hero_image_v['height']; ?>"
                             alt="<?php echo $hero_image_v['alt']; ?>"/>
                    </div>
                    <div class="hero-img horizontal d-none d-sm-block">
                        <div class="">
                            <img src="<?php echo $hero_image_h['url']; ?>"
                                 width="<?php echo $hero_image_h['width']; ?>"
                                 height="<?php echo $hero_image_h['height']; ?>"
                                 alt="<?php echo $hero_image_h['alt']; ?>"/>
                        </div>

                        <div class="">
                            <img src="<?php echo $hero_image_h2['url']; ?>"
                                 width="<?php echo $hero_image_h2['width']; ?>"
                                 height="<?php echo $hero_image_h2['height']; ?>"
                                 alt="<?php echo $hero_image_h2['alt']; ?>"/>
                        </div>
                    </div>

                </div>
            </div>

            <div class="col-12">
                <div class="hero-cta mobile-hero-cta d-flex d-md-none">
                    <?php if ($telegram) { ?>
                        <a href="<?php echo $telegram; ?>" class="btn btn-hover">
                            <span>
                                <i class="icon-telegram"></i>
                                تلگرام
                            </span>
                        </a>
                    <?php }
                    if ($whatsapp) {
                        ?>
                        <a href="<?php echo $whatsapp; ?>" class="btn btn-hover">
                            <span>
                                <i class="icon-whatsapp"></i>
                                واتس اپ
                            </span>
                        </a>
                    <?php }
                    if ($hero_phone) {
                        ?>
                        <a href="tel:<?php echo $hero_phone; ?>" class="btn btn-hover">
                            <span>
                                <i class="icon-phone"></i>
                                تلفن تماس
                            </span>
                        </a>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>
