<?php $__env->startComponent('backend.layouts.components.main',['title' => 'مدیریت پرداخت ها',
'titleBar'=>true , 'button' => '' , 'route' => 'index']); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('admin.index')); ?>">پیشخوان</a>
        </li>
        <li class="breadcrumb-item active">سفارش شماره <?php echo e($order->id); ?> </li>
        <li class="breadcrumb-item active">لیست پرداخت‌ها</li>
    <?php $__env->endSlot(); ?>

    
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست پرداخت‌ها</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <tbody>
                        <tr>
                            <th>آیدی پرداخت</th>
                            <th>شماره تراکنش</th>
                            <th>وضعیت پرداخت</th>
                            <th>زمان ثبت پرداخت</th>
                        </tr>

                        <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($payment->id); ?></td>
                                <td><?php echo e($payment->resnumber); ?></td>
                                <td>
                                    <?php switch($payment->status):
                                        case ('1'): ?>
                                        <span class="badge badge-success">پرداخت شده</span>
                                        <?php break; ?>
                                        <?php case ('0'): ?>
                                        <span class="badge badge-warning">پرداخت نشده</span>
                                        <?php break; ?>
                                    <?php endswitch; ?>
                                </td>
                                <td><?php echo e(\Hekmatinasser\Verta\Verta::instance($payment->created_at)->formatJalaliDate()); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </tbody>
                    </table>

                </div>
                <?php echo e($payments->appends([ 'search' => request('search') ])->render()); ?>

            </div>
        </div>
    </div>
    
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('/backend/js/search.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/icworldc/core/Modules/Order/Resources/views/backend/payments.blade.php ENDPATH**/ ?>