<?php $__env->startComponent('backend.layouts.components.main',['title' => 'مدیریت محصولات', 'titleBar'=>true , 'button' => 'افزودن محصول' , 'route' => 'admin.products.create']); ?>

    <?php $__env->slot('breadcrumb'); ?>
        <li class="breadcrumb-item active">
            <a href="<?php echo e(route('admin.index')); ?>">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">محصولات</li>
    <?php $__env->endSlot(); ?>

    
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">لیست محصولات</h4>
                <div class="input-group col-md-3">
                    <form action="" id="search">
                        <input type="text" class="form-control"
                               style="height: 45px; border-radius: 0 25px 25px 0"
                               placeholder="جستجو" id="search-key" name="search">
                    </form>
                    <div class="input-group-append">
                        <button class="btn btn-info btn-xs" type="button" id="search-submit">
                            <i class="fa fa-search"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table header-border table-responsive-sm">
                        <thead>
                        <tr>
                            <th>تصویر</th>
                            <th>نام</th>
                            <th>قیمت (تومان)</th>
                            <th>موجودی</th>
                            <th>دسته بندی</th>
                            <th>نحوه نمایش در سایت</th>
                            <th>تاریخ ایجاد</th>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-products')): ?>
                                <th>عملیات</th>
                            <?php endif; ?>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr>
                                <td>
                                    <?php if($product->single_image): ?>
                                        <img src="<?php echo e($product->single_image); ?>" alt="" width="50" height="50">
                                    <?php else: ?>
                                        <img src="/backend/images/no-image.jpg" alt="" width="50" height="50">
                                    <?php endif; ?>
                                </td>
                                <td class="d-flex flex-column">
                                    <span style="font-weight: 600">
                                        <?php echo e($product->title); ?>

                                    </span>
                                    <span style="font-size: .8rem">
                                        برند:
                                        <?php if($product->brand): ?>
                                            <?php echo e($product->brand); ?>

                                        <?php else: ?>
                                            وارد نشده
                                        <?php endif; ?>
                                    </span>
                                    <?php if(!is_null($product->inventory)): ?>
                                        <?php if($product->inventory < $product->min_order_quantity): ?>
                                            <span class="badge badge-xs light badge-warning">موجودی کمتر از حداقل تعداد سفارش</span>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(!$product->is_on_sale()): ?>
                                        <?php echo e(number_format($product->price)); ?>

                                        تومان
                                    <?php else: ?>
                                        <span>
                                            <bdi style="text-decoration: line-through;">
                                               <?php echo e(number_format($product->price)); ?>

                                                تومان
                                            </bdi>
                                        </span>
                                        <?php echo e(number_format($product->sale_price)); ?>

                                        تومان
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(is_null($product->inventory)): ?>
                                        <span class="badge badge-xs light badge-warning">انبار داری غیر فعال</span>
                                    <?php else: ?>
                                        <?php echo e($product->inventory); ?>

                                        عدد
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php $__currentLoopData = $product->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(count($product->categories)>1): ?>
                                            <?php echo e($category->name . ','); ?>

                                        <?php else: ?>
                                            <?php echo e($category->name); ?>

                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td>
                                    <?php if(!is_null($product->inventory)): ?>
                                        <?php if($product->inventory < $product->min_order_quantity): ?>
                                            <span class="badge badge-xs light badge-warning">عدم موجودی</span>
                                        <?php else: ?>
                                            <span class="badge badge-xs light badge-success"> موجود</span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="badge badge-xs light badge-success">موجود</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(\Hekmatinasser\Verta\Verta::instance($product->created_at)->formatJalaliDate()); ?></td>

                                <td>
                                    <form action="<?php echo e(route('admin.products.destroy', $product->id)); ?>" method="post"
                                          id="delete-<?php echo e($product->id); ?>">
                                        <?php echo method_field('delete'); ?>
                                        <?php echo csrf_field(); ?>
                                    </form>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-users')): ?>
                                        <a href="<?php echo e(route('admin.products.edit', $product->id)); ?>" role="button"
                                           class="btn btn-success light sharp" title="ویرایش">
                                            <i class="fa fa-pencil"
                                               onclick="document.getElementById('edit-<?php echo e($product->id); ?>').submit()"></i>
                                        </a>
                                        <button onclick="document.getElementById('delete-<?php echo e($product->id); ?>').submit()"
                                                role="button" class="btn btn-danger light sharp" title="حذف">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    <?php endif; ?>
                                    <a href="<?php echo e(asset('product/' . $product->slug)); ?>" role="button"
                                       class="btn btn-primary light sharp" title="نمایش" target="_blank">
                                        <i class="fa fa-eye"></i>
                                    </a>
                                </td>

                            </tr>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
                <?php echo e($products->links()); ?>

            </div>
        </div>
    </div>
    
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('/backend/js/search.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->renderComponent(); ?>
<?php /**PATH /home/icworldco/core/Modules/Product/Resources/views/backend/all.blade.php ENDPATH**/ ?>