<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use Modules\ACL\Entities\Permission;
use Modules\Address\Entities\Address;
use Modules\Order\Entities\Order;
use Modules\User\Entities\User;
use Modules\User\Policies\AddressPolicy;
use Modules\User\Policies\OrderPolicy;
use Modules\User\Policies\UserPolicy;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
        User::class => UserPolicy::class,
        Order::class => OrderPolicy::class,
        Address::class => AddressPolicy::class,

    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerPolicies();

        foreach (Permission::all() as $permission){
            Gate::define($permission->name , function ($user) use ($permission){
                return $user->hasPermission($permission);
            });
        }
    }
}
