@component('backend.layouts.components.main',['title' => 'افزودن جدید','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">افزودن جدید</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات</h4>
            </div>
            <div class="card-body">
                <form action="{{route('admin.prices.store')}}" method="post" id="store">
                    @csrf
                    @method('post')
                </form>
                <div class="form-group">
                    <input name="label" type="text"
                           class="form-control input-rounded @error('label') is-invalid @enderror" placeholder="عنوان"
                           form="store" required value="{{old('label')}}">
                    @error('label')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>
                <div class="form-group">
                    <input name="price" type="text"
                           class="form-control input-rounded @error('price') is-invalid @enderror" placeholder="قیمت"
                           form="store" required value="{{old('price')}}">
                    @error('price')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>
                <div class="form-group row">
                    <label class="col-sm-3 col-form-label">نوع</label>
                    <div class="col-sm-9">
                        <select name="type"
                                class="form-control default-select input-rounded @error('type') is-invalid @enderror"
                                id="type" tabindex="-98" form="store">
                            <option value="">انتخاب کنید</option>
                            <option value="pin">پین</option>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif


        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.prices.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('store').submit()">
                            <i class="fa fa-save"></i>
                            ساختن
                        </button>
                    </div>

                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}



    {{-- Scripts --}}
@section('script')
    <script src="{{ asset('/vendor/file-manager/js/file-manager.js') }}"></script>

    <script src="{{asset('/backend/js/file-editor.js')}}"></script>
    <script src="{{asset('/backend/js/file-button.js')}}"></script>
    <script>
        let meta_title = document.getElementById('meta-title');
        let meta_desc = document.getElementById('meta-desc');
        let g_link = document.getElementById('g-link');
        let g_desc = document.getElementById('g-desc');
        meta_title.addEventListener('change', function () {
            g_link.innerText = meta_title.value;
        })
        meta_desc.addEventListener('change', function () {
            g_desc.innerText = meta_desc.value;
        })
    </script>
    <script src="/backend/vendor/nestable2/js/jquery.nestable.min.js"></script>

@stop

@section('head')
    <script src="https://cdn.tiny.cloud/1/piqrm2bib3zv8de8a26kklh89gvqb0bhm9a14mjb88jwos8r/tinymce/5/tinymce.min.js"
            referrerpolicy="origin"></script>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link rel="stylesheet" href="{{ asset('/backend/vendor/nestable2/css/jquery.nestable.min.css') }}">
@stop
@endcomponent
