<?php

namespace Modules\Payment\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Modules\Payment\Notifications\channels\NewOrderSmsPanel;

class NewOrderAdminNotification extends Notification
{
    use Queueable;

    public $order_code;

    public $price;

    public $name;

    public $city;

    public $shipping;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct( $phone , $order_code , $price , $name , $city , $shipping)
    {
        $this->order_code = $order_code;
        $this->name = $name;
        $this->price = $price;
        $this->phone = $phone;
        $this->city = $city;
        $this->shipping = $shipping;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return [NewOrderSmsPanel::class];
    }

    public function toNewOrderSmsPanel($notifiable)
    {
        return [
            'phone' => $this->phone,
            'order_code' => $this->order_code,
            'name' => $this->name,
            'city' => $this->city,
            'shipping' => $this->shipping,
            'price' => $this->price,
        ];
    }
}
