@component('backend.layouts.components.main',['title' => 'مدیریت صفحه اصلی','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">افزودن جدید</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">جزئیات</h4>
            </div>
            <div class="card-body">
                <div class="basic-form">
                    <form action="{{route('admin.mains.store')}}" method="post" id="store">
                        @csrf
                        @method('post')
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">عنوان بخش</label>
                            <div class="col-sm-9">
                                <input name="title" type="text"
                                       class="form-control input-rounded @error('title') is-invalid @enderror"
                                       placeholder="مثلا آی سی" value="{{old('title')}}">
                                @error('name')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>

                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">آیکون (اختیاری)</label>
                            <div class="col-sm-9">
                                <input name="icon" type="text"
                                       class="form-control input-rounded @error('icon') is-invalid @enderror"
                                       value="{{old('icon')}}">
                                @error('icon')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">دسته بندی</label>
                            <div class="col-sm-9">
                                <div class="dropdown bootstrap-select form-control default-select dropup">
                                    <select name="category_id"
                                            class="form-control default-select input-rounded @error('category_id') is-invalid @enderror"
                                            id="sel1" tabindex="-98">
                                        <option value="">انتخاب کنید</option>
                                        @include('category::backend.products.partials.categories-dropdown' ,
                           [
                               'categories' => $categories,
                               'level' => 0
                               ])
                                    </select>
                                    @error('category_id')
                                    <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>

                                    @enderror
                                </div>

                            </div>

                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">دارک مود</label>
                            <div class="col-sm-9">
                                <select name="is_dark"
                                        class="form-control default-select input-rounded @error('is_dark') is-invalid @enderror"
                                        id="sel1" tabindex="-98">
                                    <option value="">انتخاب کنید</option>
                                    <option value="1">بله</option>
                                    <option value="0">خیر</option>
                                </select>
                                @error('is_dark')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">ترتیب</label>
                            <div class="col-sm-9">
                                <input name="order" type="text"
                                       class="form-control input-rounded @error('order') is-invalid @enderror"
                                       placeholder="ترتیب" value="{{old('order')}}">
                                @error('order')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.mains.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای ایجاد کاربر جدید، روی دکمه "ساختن" کلیک کنید.
                </p>
                <div class="row">
                    <button class="btn btn-success btn-sm btn-block light"
                            onclick="document.getElementById('store').submit()">
                        <i class="fa fa-save"></i>
                        ساختن
                    </button>
                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}
    <script>

    </script>
@endcomponent
