@component('backend.layouts.components.main',['title' => 'افزودن کد تخفیف','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">افزودن کد تخفیف جدید</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">جزئیات کد تخفیف</h4>
            </div>
            <div class="card-body">
                <div class="basic-form">
                    <form action="{{route('admin.discounts.store')}}" method="post" id="store">
                        @csrf
                        @method('post')
                        <div class="form-group">
                            <label for="inputEmail3" class="control-label">کد تخفیف</label>
                            <input type="text" name="code" class="form-control  @error('code') is-invalid @enderror" id="inputEmail3" placeholder="کد تخفیف را وارد کنید" value="{{ old('code') }}">
                            @error('code')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="precent" class="control-label">میزان تخفیف (درصد)</label>
                            <input type="number" name="percent" class="form-control  @error('percent') is-invalid @enderror" placeholder="درصد تخفیف را وارد کنید" value="{{ old('percent') }}">
                            @error('percent')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label class="control-label">کاربر مربوط - به تخفیف برای اختصاص به همه این فیلد را خالی بگذارید(اختیاری)</label>
                            <select class="form-control  @error('users') is-invalid @enderror" name="users[]" id="users" multiple>
                                @foreach(\Modules\User\Entities\User::all() as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                            @error('users')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="control-label">محصول مربوطه - برای اختصاص به همه این فیلد را خالی بگذارید(اختیاری)</label>
                            <select class="form-control  @error('products') is-invalid @enderror" name="products[]" id="products" multiple>
                                @foreach(\Modules\Product\Entities\Product::all() as $product)
                                    <option value="{{ $product->id }}">{{ $product->title }}</option>
                                @endforeach
                            </select>
                            @error('products')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="inputPassword3" class="control-label">دسته‌بندی مربوطه - برای اختصاص به همه این فیلد را خالی بگذارید(اختیاری)</label>
                            <select class="form-control  @error('categories') is-invalid @enderror" name="categories[]" id="categories" multiple>
                                @foreach(\Modules\Category\Entities\Category::where('category_type' , \Modules\Product\Entities\Product::class)->get() as $category)
                                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                                @endforeach
                            </select>
                            @error('categories')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                        <div class="form-group">
                            <label for="inputEmail3" class=" control-label">مهلت استفاده</label>
                            <input type="datetime-local" name="expired_at" class="form-control  @error('expired_at') is-invalid @enderror" id="inputEmail3" placeholder="ملهت استفاده را وارد کنید" value="{{ old('expired_at') }}">
                            @error('expired_at')
                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                            @enderror
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.discounts.index')}}" role="button" class="btn btn-xs btn-info light"
                   title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای ایجاد کد تخفیف جدید، روی دکمه "ساختن" کلیک کنید.
                </p>
                <div class="row">
                    <button class="btn btn-success btn-sm btn-block light"
                            onclick="document.getElementById('store').submit()">
                        <i class="fa fa-save"></i>
                        ساختن
                    </button>
                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}
@section('head')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
@stop
@section('script')
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>

        $('#users').select2({
            'placeholder' : 'کاربر مورد نظر را انتخاب کنید'
        })

        $('#products').select2({
            'placeholder' : 'محصول مورد نظر را انتخاب کنید'
        })

        $('#categories').select2({
            'placeholder' : 'دسته مورد نظر را انتخاب کنید'
        })
    </script>
@stop
@endcomponent

