@foreach($comments as $comment)
    <div class="comment @if($comment_reply) comment-reply @endif">
        @if($comment->user->avatar)
            <img src="{{asset($comment->user->avatar)}}" alt="" class="comment-avatar">
            @else
            <img src="/images/avatar.png" alt="" class="comment-avatar">
        @endif
        <div class="comment-content w-100">
            <p class="name">{{$comment->user->name}}</p>
            <p class="comment-date">{{\Hekmatinasser\Verta\Verta::instance($comment->created_at)->formatJalaliDate()}}</p>
            <p>
                {{$comment->body}}
            </p>
            <div class="answer text-right">
                <a href="#addcomment" class="@if($comment_reply) kw-btn-orange @else kw-btn-blue @endif "
                   id="{{"comment-$comment->id"}}"
                   onclick="parentId({{$comment->id}})">پاسخ</a>
            </div>
        </div>
    </div>
    @if($comment->children->count())
        @include('comment::frontend.show' , [
    'comments' => $comment->children->where('status' , 1) ,
    'comment_reply' => true
    ])
    @endif
@endforeach
