<?php

namespace Modules\Comment\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Comment\Entities\Comment;

class CommentController extends Controller
{
    use SEOTools;
    public function index()
    {
        $this->seo()->setTitle('همه نظرات');

        $comments = Comment::query();
        if ($key = \request('search')) {
            $comments = $comments->where('body', 'like', "%$key%");
        }
        markAsReadNotifications('newComment');
        $comments = $comments->latest()->simplePaginate(15);
        return view('comment::backend.all' , compact('comments'));
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('comment::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('comment::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        return view('comment::edit');
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        //
    }

    public function destroy(Comment $comment)
    {
        $comment->delete();
        alert()->success('عملیات با موفقیت انجام شد');
        return back();
    }

    public function status(Request $request,Comment $comment)
    {
        if ($comment->status == 0){
            $comment->update([
                'status' => 1
            ]);
        }else{
            $comment->update([
                'status' => 0
            ]);
        }
        alert()->success('عملیات با موفقیت انجام شد.');
        return back();
    }
}
