<?php

namespace WHMCS\Module\Addon\virtualizoraddon\Admin;
use WHMCS\Config\Setting;

/**
 * Sample Admin Area Dispatch Handler
 */
class AdminDispatcher {

    /**
     * Dispatch request.
     *
     * @param string $action
     * @param array $parameters
     *
     * @return string
     */
    public function dispatch($action, $parameters,$state,$version="1.0")
    {
        if (!$action) {
            // Default to index if no action specified
            $action = 'index';
        }
        $parameters["modulelink"]=$parameters["modulelink"]."&action=".$action;
        $controller = new Controller();
        $checkLicense = $this->CheckVirtualizorLicense();
        $currentVersion = str_replace(".","",$parameters["version"]);
        
        $latestVersion =   str_replace(".","",$checkLicense["version"]);
        if($latestVersion>$currentVersion) 
                return $controller->NeedToUpgrade($parameters);
        if($checkLicense["status"]!="active"){
                return $controller->NeedToConfigure($parameters);
            
        }
        // Verify requested action is valid and callable
        if (is_callable(array($controller, $action))) {
            if($state=="needtoconfigure")
                return $controller->NeedToConfigure($parameters);
                
            return $controller->$action($parameters);
        }

        return '<p>Invalid action requested. Please go back and try again.</p>';
    }
    public function ReturnVirtualizorLicenseInfo(){
        $result = full_query("SELECT * from mod_virtualizor_addon_info");
        $output =[];
        while ($data = mysql_fetch_array($result)) {
               $output = $data;
        }
        return $output;
    }
    public function CheckVirtualizorLicense(){
        $WHMCSurl = Setting::getValue('SystemURL');
        $domain = $WHMCSurl;
        if(isset($_SERVER['SERVER_NAME']))
            $domain = $_SERVER['SERVER_NAME'];
        $data = $this->ReturnVirtualizorLicenseInfo();
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://cl.keloncloud.com/licensing/checklicense.php',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => array('licensekey' => $data["licensekey"],'domain' =>  $domain),
          CURLOPT_HTTPHEADER => array(
            'cache-control: no-cache',
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
                      file_put_contents("/home/eserverc/public_html/modules/addons/virtualizoraddon/lib/Admin/l.log",$response. "\n", FILE_APPEND);

        return json_decode($response,true);
        
        
        
    }
    public function RenderedTemplate($tplfile,$arrayValue)
    {
      
        $content = "";
        if(file_exists(__DIR__.'/../../templates/custom_template/'.$tplfile)){
            $content = file_get_contents(__DIR__.'/../templates/custom_template/'.$tplfile);
        }    else if(file_exists(__DIR__.'/../../templates/'.$tplfile)){
            $content = file_get_contents(__DIR__.'/../../templates/'.$tplfile);
        }else{
            return "FILE NOT FOUND";
        }
        foreach($arrayValue as $d=> $k){
            $content= str_replace("{\$".$d."}",$k,$content);
            //  $content.="<h1>".$d."</h1><h2>".$k."</h2>";
        }
        return $content;
    }
}
