<?php

use WHMCS\Database\Capsule;
use WHMCS\Module\Addon\userverification\Admin\AdminDispatcher;
use WHMCS\Module\Addon\userverification\Admin\Controller;
use WHMCS\Module\Addon\userverification\Client\ClientDispatcher;

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}
function userverification_config()
{
    return [
        // Display name for your module
        'name' => 'User Verification Modules ',
        // Description displayed within the admin interface
        'description' => 'With this module you can verify user by shahkar API 
                            and can categorize users by verified level',
        // Module author name
        'author' => '@KelonCloud - Kelon Cloud Developer Team',
        // Default language
        'language' => 'english',
        // Version number
        'version' => '1.0',

    ];
}
function userverification_activate()
{
    try {
        Capsule::schema()
            ->create(
                'mod_userverification_cards',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->integer('userid');
                    $table->integer('cardnumber');
                    $table->text('status');//Approved - Pending - Rejected
                    $table->integer('message');
                    $table->timestamps();
                }
            );
        Capsule::schema()
            ->create(
                'mod_userverification_levels',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->integer('userid');
                    $table->integer('level');//1 - user Mobile Not Authenticated
                    //2 - Mobile Authenticated
                    //3 - National Code and Mobile have the same owner
                    //4 - National ID and Birthday is correct
                    //5 - User information is fetched from api and updated
                    $table->timestamps();
                }
            );
        Capsule::schema()
            ->create(
                'mod_userverification_config',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->text('option');
                    $table->text('value');
                }
            );
        Capsule::schema()
            ->create(
                'mod_userverification_smsverify',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->text('code');
                    $table->text('mobile');
                    $table->text('status');
                    $table->integer('userid');
                    $table->timestamps();
                }
            );
        Capsule::schema()
            ->create(
                'mod_userverification_request',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->text('type');
                    $table->text('request');
                    $table->text('response');
                    $table->integer('userid');
                    $table->timestamps();
                }
            );

        return [
            // Supported values here include: success, error or info
            'status' => 'success',
            'description' => 'Module activated successfully',
        ];
    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            'status' => "error",
            'description' => 'Unable to create some tables: ' . $e->getMessage(),
        ];
    }
}
function userverification_deactivate()
{
    // Undo any database and schema modifications made by your module here
    try {
        Capsule::schema()
            ->dropIfExists('mod_userverification_levels');
        Capsule::schema()
            ->dropIfExists('mod_userverification_config');
        Capsule::schema()
            ->dropIfExists('mod_userverification_smsverify');
        Capsule::schema()
            ->dropIfExists('mod_userverification_request');
        Capsule::schema()
            ->dropIfExists('mod_userverification_cards');

        return [
            // Supported values here include: success, error or info
            'status' => 'success',
            'description' => 'Module Deactivated successfully',
        ];
    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            "status" => "error",
            "description" => "Unable to drop some tables: {$e->getMessage()}",
        ];
    }
}
function userverification_upgrade($vars)
{
}
function userverification_output($vars)
{
    // Get common module parameters
    $modulelink = $vars['modulelink']; // eg. userverifications.php?module=userverification
    $version = $vars['version']; // eg. 1.0
    $_lang = $vars['_lang']; // an array of the currently loaded language variables

    $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : '';

    $dispatcher = new AdminDispatcher();
    $response = $dispatcher->dispatch($action, $vars);
    echo $response;
}
function userverification_clientarea($vars)
{
    $action = isset($_GET['action']) ? $_GET['action'] : '';

    switch ($action) {
        case 'verify':
            return userverification_clientarea_verify($vars);
        default:
            // Your existing default client area code
            return array(
                'pagetitle' => 'User Verification',
                'breadcrumb' => array('index.php?m=userverification' => 'User Verification'),
                'templatefile' => 'clientarea',
                'requirelogin' => true,
                'vars' => array(),
            );
    }
}
function userverification_clientarea_verify($vars)
{
    $modulelink = $vars['modulelink'];
    $clientId = $_SESSION['uid']; // Current logged in user
    $message = '';
    $messageType = '';
    $step = 1; // Default step

    $cooldownActive = false;
    $remainingSeconds = 0;


    $AdminController = new Controller();

    // Get field IDs from config
    $mobileFieldQuery = "SELECT value FROM mod_userverification_config WHERE `option` = 'mobile_field'";
    $nationalCodeFieldQuery = "SELECT value FROM mod_userverification_config WHERE `option` = 'national_code_field'";

    $mobileFieldResult = mysql_query($mobileFieldQuery);
    $nationalCodeFieldResult = mysql_query($nationalCodeFieldQuery);

    $mobileFieldId = mysql_fetch_array($mobileFieldResult)['value'];
    $nationalCodeFieldId = mysql_fetch_array($nationalCodeFieldResult)['value'];

    // Get user's current values
    $mobileQuery = "SELECT value FROM tblcustomfieldsvalues WHERE fieldid = '$mobileFieldId' AND relid = '$clientId'";
    $nationalCodeQuery = "SELECT value FROM tblcustomfieldsvalues WHERE fieldid = '$nationalCodeFieldId' AND relid = '$clientId'";

    $mobileResult = mysql_query($mobileQuery);
    $nationalCodeResult = mysql_query($nationalCodeQuery);

    $mobileNumber = mysql_num_rows($mobileResult) > 0 ? mysql_fetch_array($mobileResult)['value'] : '';
    $nationalCode = mysql_num_rows($nationalCodeResult) > 0 ? mysql_fetch_array($nationalCodeResult)['value'] : '';

    // Check if user is already verified
    $verifiedQuery = "SELECT * FROM mod_userverification_levels WHERE userid = '$clientId'";
    $verifiedResult = mysql_query($verifiedQuery);
    $isVerified = mysql_num_rows($verifiedResult) > 0;
    $lastLevel = mysql_fetch_array($verifiedResult);
    if ($lastLevel["level"] == "4") {
        $step = 4; // Completed all steps
    } elseif (!empty($mobileNumber) && !empty($nationalCode)) {
        // Check if user has a pending verification
        $pendingQuery = "SELECT * FROM mod_userverification_smsverify 
                         WHERE userid = '$clientId' AND status = 'verified' 
                         ORDER BY created_at DESC LIMIT 1";
        $pendingResult = mysql_query($pendingQuery);

        if (mysql_num_rows($pendingResult) > 0) {
            $step = $lastLevel["level"];
            // $step = 2; // Verification code sent, waiting for verification
        } else {
            $step = 1; // Ready to send verification code
        }
    }

    // Handle form submissions
    if (isset($_POST['save_info'])) {
        $newMobile = $_POST['mobile_number'];
        $newNationalCode = $_POST['national_code'];

        if (empty($newMobile) || empty($newNationalCode)) {
            $message = 'Both mobile number and national code are required.';
            $messageType = 'danger';
        } else {
            // Update or insert mobile number
            if (empty($mobileNumber)) {
                $insertMobileQuery = "INSERT INTO tblcustomfieldsvalues (fieldid, relid, value) 
                                     VALUES ('$mobileFieldId', '$clientId', '$newMobile')";
                mysql_query($insertMobileQuery);
            } else {
                $updateMobileQuery = "UPDATE tblcustomfieldsvalues 
                                     SET value = '$newMobile' 
                                     WHERE fieldid = '$mobileFieldId' AND relid = '$clientId'";
                mysql_query($updateMobileQuery);
            }

            // Update or insert national code
            if (empty($nationalCode)) {
                $insertNationalQuery = "INSERT INTO tblcustomfieldsvalues (fieldid, relid, value) 
                                       VALUES ('$nationalCodeFieldId', '$clientId', '$newNationalCode')";
                mysql_query($insertNationalQuery);
            } else {
                $updateNationalQuery = "UPDATE tblcustomfieldsvalues 
                                       SET value = '$newNationalCode' 
                                       WHERE fieldid = '$nationalCodeFieldId' AND relid = '$clientId'";
                mysql_query($updateNationalQuery);
            }

            $mobileNumber = $newMobile;
            $nationalCode = $newNationalCode;
            $step = 2;

            $message = 'Your information has been saved successfully.';
            $messageType = 'success';
        }
    } elseif (isset($_POST['request_code'])) {
        $result = $AdminController->sendSmsToUser($clientId);

        if ($result['success']) {
            $step = 1;
            $message = 'Verification code has been sent to your mobile number.';
            $messageType = 'success';
        } else {
            $message = $result['message'];
            if (isset($result['wait'])) {
                $cooldownActive = true;
                $remainingSeconds = $result['wait'];

                $message .= $result['wait'];
            }
            $messageType = 'danger';
        }
    } elseif (isset($_POST['verify_code'])) {
        $submittedCode = $_POST['verification_code'];

        // Check if code is valid
        $codeQuery = "SELECT * FROM mod_userverification_smsverify 
                      WHERE userid = '$clientId' AND code = '$submittedCode' 
                      ORDER BY created_at DESC LIMIT 1";
        $codeResult = mysql_query($codeQuery);

        if (mysql_num_rows($codeResult) > 0) {
            $codeRow = mysql_fetch_array($codeResult);
            $codeTime = strtotime($codeRow['created_at']);
            $currentTime = time();
            $timeDiff = $currentTime - $codeTime;

            // Check if code is expired (15 minutes)
            if ($timeDiff <= 900) {
                // Update verification status
                $updateQuery = "UPDATE mod_userverification_smsverify 
                               SET status = 'verified', updated_at = NOW() 
                               WHERE  userid = '$clientId' ";
                mysql_query($updateQuery);

                // Update user verification status


                $step = 2;
                $isVerified = true;
                $message = 'Your mobile number has been verified successfully.';
                $AdminController->updateUserVerificationLevel($clientId, 2);
                $messageType = 'success';
            } else {
                $message = 'Verification code has expired. Please request a new code.';
                $messageType = 'danger';
                $step = 1;
            }
        } else {
            $message = 'Invalid verification code. Please try again.';
            $messageType = 'danger';
        }
    } elseif (isset($_POST["verify_national_code"])) {
        $newNationalCode = $_POST['national_code'];
        if (!$AdminController->validateIranianNationalCode(($newNationalCode))) {
            $APIResultShahkar = '<div class="alert alert-danger">
                                            <strong>National Code is invalid</strong> 
                                        </div>';
        } else {
            if (empty($nationalCode)) {
                $insertNationalQuery = "INSERT INTO tblcustomfieldsvalues (fieldid, relid, value) 
                                           VALUES ('$nationalCodeFieldId', '$clientId', '$newNationalCode')";
                mysql_query($insertNationalQuery);
            } else {
                $updateNationalQuery = "UPDATE tblcustomfieldsvalues 
                                           SET value = '$newNationalCode' 
                                           WHERE fieldid = '$nationalCodeFieldId' AND relid = '$clientId'";
                mysql_query($updateNationalQuery);
            }
            $nationalCode = $newNationalCode;
            $VerifyShahkar = $AdminController->verifyShahkar($nationalCode, $mobileNumber, $clientId);
            if (!$VerifyShahkar["data"]["isMatched"]) {
                $APIResultShahkar = '<div class="alert alert-danger">
                                                <strong>National Code and mobile number is not match</strong> 
                                            </div>';
            } else {
                $APIResultShahkar = '<div class="alert alert-success">
                                    <strong>National Code and mobile number is  match</strong> 
                                </div>';
                $step = 3;
                $AdminController->updateUserVerificationLevel($clientId, 3);
            }
        }
    }

    // Build template variables
    $templateVars = array(
        'modulelink' => $modulelink,
        'message' => $message,
        'messageType' => $messageType,
        'step' => $step,
        'userLevel' => $step,
        'isVerified' => $isVerified,
        'mobileNumber' => $mobileNumber,
        'nationalCode' => $nationalCode,
        'cooldownActive' => true,
        'remainingSeconds' => $remainingSeconds,
        'APIResultShahkar' => $APIResultShahkar
    );

    return array(
        'pagetitle' => 'Mobile Verification',
        'breadcrumb' => array('index.php?m=userverification&action=verify' => 'Mobile Verification'),
        'templatefile' => 'clientarea_verify',
        'requirelogin' => true,
        'vars' => $templateVars,
    );
}