<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function webuzo()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $user;
    global $l;
    global $error;
    global $done;
    global $scripts;
    global $i_scripts;
    global $webuzo_apps;
    global $apps;
    global $support_err;
    global $info;
    global $isfree;
    global $iscripts;
    global $webuzo_enabled;
    global $webuzo_templates;
    global $ostemplates;
    global $servers;
    $theme["init_theme"] = "webuzo";
    $theme["init_theme_name"] = "webuzo";
    $theme["init_theme_func"] = ["webuzo_theme"];
    $theme["call_theme_func"] = "webuzo_theme";
    if(!empty($globals["disable_webuzo"])) {
        $error["not_allowed"] = $l["webuzo_disabled"];
        return false;
    }
    if(!empty($user["vps"]["suspended"])) {
        $error[] = $l["vps_is_suspended"];
        return false;
    }
    if(!empty($user["vps"]["admin_managed"])) {
        $error[] = $l["is_managed"];
        return false;
    }
    $support_err = 0;
    $webuzo_enabled = false;
    $premium_apps_plan = 0;
    $vps = getvps($globals["vpsid"]);
    $vps_planid = $vps["plid"];
    if(!empty($vps["pid"])) {
        $res = makequery("SELECT webuzo_prem_apps FROM users \n\t\t\t\t\t\t\t\tWHERE pid = :pid", [":pid" => $vps["pid"]]);
        if(0 < vsql_num_rows($res)) {
            $row = vsql_fetch_assoc($res);
            $premium_apps_plan = $row["webuzo_prem_apps"];
        }
    }
    if(!empty($vps_planid) && !empty($globals["premium_apps"])) {
        $res = makequery("SELECT webuzo_data FROM plans \n\t\t\t\t\t\t\t\tWHERE plid = :plid", [":plid" => $vps_planid]);
        if(0 < vsql_num_rows($res)) {
            $row = vsql_fetch_assoc($res);
            $premium_apps_plan = empty($row["webuzo_data"]) ? 0 : $row["webuzo_data"];
        }
    }
    load_scripts($premium_apps_plan);
    if(!file_exists($globals["path"] . "/apps.json")) {
        $update = $ckernel->update_webuzoapps($globals["vpsid"]);
        if(!$update) {
            $error[] = $l["webuzo_app_err"];
            return NULL;
        }
    }
    $webuzo_apps = load_webuzoapps($premium_apps_plan);
    $res = makequery("SELECT ip FROM `ips` i\n\t\t\t\tWHERE i.vpsid = :vpsid\n\t\t\t\tAND i.primary = 1", [":vpsid" => $vps["vpsid"]]);
    if(0 < vsql_num_rows($res)) {
        $ips = vsql_fetch_assoc($res);
    } else {
        $error[] = $l["webuzo_prim_ip_err"];
    }
    $webuzo_templates = webuzo_os($vps["virt"], $vps["hvm"]);
    $iscripts_allowed = get_web_scripts();
    $info = [];
    $info["dns_nameserver"] = unserialize($vps["dns_nameserver"]);
    $info["webuzo_templates"] = $webuzo_templates;
    $stack = [];
    if(empty($globals["noc_apikey"]) && empty($globals["noc_apipass"]) || empty($premium_apps_plan) && !empty($globals["premium_apps"])) {
        $isfree = 1;
        $stack = [];
        $stack = load_free_webapps();
    }
    if(isset($_POST["webuzosettings"])) {
        $data = [];
        $valid_stacks = ["lamp", "lemp", "llmp"];
        $data["spasswd"] = POST("webuzo_spasswd", $l["webuzo_spasswd_err"]);
        $data["domain"] = POST("webuzo_pd", $l["webuzo_pd_err"]);
        $data["script"] = (int) optREQ("webuzo_script");
        $data["webuzo_stack"] = POST("webuzo_stack", $l["webuzo_stack_err"]);
        $data["webuzo_os"] = (int) POST("webuzo_os", $l["webuzo_os_err"]);
        $data["webserver"] = optREQ("webserver");
        if(!empty($globals["noc_apikey"]) && !empty($globals["noc_apipass"]) && !empty($premium_apps_plan)) {
            $data["mysql"] = POST("mysql", $l["mysql_err"]);
            $data["php"] = POST("php", $l["php_err"]);
        }
        $data["ns1"] = optREQ("webuzo_ns1");
        $data["ns2"] = optREQ("webuzo_ns2");
        if(!empty($error)) {
            return NULL;
        }
        if(!is_valid_domain_name($data["domain"])) {
            $error[] = $l["webuzo_pd_err"];
        } else {
            $domain = $data["domain"];
        }
        if(!in_array($data["webuzo_stack"], $valid_stacks)) {
            $error[] = $l["webuzo_wmp_err"];
        }
        if($isfree) {
            $data["webserver"] = "lamp";
        }
        if($data["webuzo_stack"] == "lamp" && empty($data["webserver"]) && empty($globals["noc_apikey"]) && empty($globals["noc_apipass"])) {
            $data["webserver"] = "lamp";
        }
        if(!empty($data["script"]) && (!in_array($data["script"], $iscripts_allowed) || !array_key_exists($data["script"], $iscripts))) {
            $error[] = $l["webuzo_script_err"];
        }
        if(!empty($data["webuzo_stack"]) && !in_array($data["webuzo_stack"], $valid_stacks)) {
            $error[] = $l["webuzo_stack_err"];
        }
        if(!array_key_exists($data["webuzo_os"], $webuzo_templates)) {
            $error[] = $l["webuzo_stack_err"];
        }
        if(!empty($error)) {
            return NULL;
        }
        if($data["webuzo_stack"] === "lemp") {
            $data["webserver"] = "nginx";
        }
        if($data["webuzo_stack"] === "llmp") {
            $data["webserver"] = "lighttpd";
        }
        $data["primary_ip"] = $ips["ip"];
        $data["admin_email"] = "admin@" . $domain;
        $data["admin_username"] = "admin";
        $data["admin_pass"] = generateRandStr(8);
        $data["rpass"] = $data["spasswd"];
        $data["uname"] = "admin";
        $data["email"] = $user["email"];
        $data["script_name"] = $scripts[$data["script"]]["fullname"];
        if(!empty($SESS["uid"])) {
            $temp_sess_uid = $SESS["uid"];
        }
        if(isset($SESS["og_uid"])) {
            $temp_sess_uid = $SESS["og_uid"];
        }
        $temp_sess_str = generateRandStr(8);
        writefile("/tmp/" . $temp_sess_str . "ISCRIPT", $temp_sess_uid, 1);
        if(!empty($error)) {
            return false;
        }
        $post = ["enduser_iscript" => $temp_sess_str, "ns1" => $data["ns1"], "ns2" => $data["ns2"], "os" => $data["webuzo_os"]];
        $ret = make_api_call($servers[0]["ip"], $globals["pass"], "index.php?act=managevps&install_script=" . $globals["vpsid"] . "&vpsid=" . $globals["vpsid"] . "&changeserid=" . $vps["serid"], $data, $post);
        if(!empty($ret["error"])) {
            $error = $ret["error"];
            return false;
        }
        $webuzo_enabled = true;
        $done["msg"] = $l["webuzo_install_start"] . implode("<br>");
        $done["goto"] = "act=vpsmanage&svs=" . $globals["vpsid"];
    } elseif(optREQ("scriptid")) {
        $sid = (int) optREQ("scriptid");
        if(!array_key_exists($sid, $scripts)) {
            $error[] = $l["webuzo_script_err"];
        } else {
            $script = $scripts[$sid]["name"];
            $req = $ckernel->script_req($sid);
            if(empty($req)) {
                $webuzo_apps = $stack;
            } else {
                foreach ($req as $key => $val) {
                    if($val["type"] === "version") {
                        foreach ($webuzo_apps[$val["check"]] as $appkey => $appval) {
                            if(!version_compare($appval["version"], $val["version"], $val["operator"])) {
                                unset($webuzo_apps[$val["check"]][$appkey]);
                            }
                        }
                    }
                }
                if(empty($webuzo_apps["php"])) {
                    $error[] = $l["webuzo_support_err"];
                    $support_err = 1;
                }
            }
        }
    } else {
        foreach ($iscripts_allowed as $k => $v) {
            if(!array_key_exists($v, $iscripts)) {
                unset($iscripts_allowed[$k]);
            } else {
                $i_scripts[$l["cat_php_" . $scripts[$v]["category"]]][$v]["name"] = $scripts[$v]["name"];
                $i_scripts[$l["cat_php_" . $scripts[$v]["category"]]][$v]["softname"] = $scripts[$v]["softname"];
            }
        }
    }
}
function API_webuzo()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $user;
    global $l;
    global $error;
    global $done;
    global $scripts;
    global $i_scripts;
    global $webuzo_apps;
    global $support_err;
    global $info;
    global $isfree;
    global $webuzo_enabled;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($i_scripts)) {
        $GLOBALS["_api"]["iscripts"] = $i_scripts;
    }
    if(!empty($isfree)) {
        $GLOBALS["_api"]["isfree"] = $isfree;
    }
    if(!empty($support_err)) {
        $GLOBALS["_api"]["support_err"] = $support_err;
    } else {
        $GLOBALS["_api"]["webuzo_apps"] = $webuzo_apps;
    }
    $GLOBALS["_api"]["info"] = $info;
    $GLOBALS["_api"]["webuzo_enabled"] = $webuzo_enabled;
}

?>