<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function vpsmanage()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $cluster;
    global $user;
    global $l;
    global $error;
    global $done;
    global $vs;
    global $servers;
    global $info;
    global $ipv6_subnets;
    global $kernel;
    global $isos;
    global $curr_hostname;
    global $curr_ips;
    global $available;
    global $ostemplates;
    global $ver_done;
    global $load_balancer;
    $theme["init_theme"] = "vpsmanage";
    $theme["init_theme_name"] = "Manage VPS";
    $theme["init_theme_func"] = ["vpsmanage_theme"];
    $theme["call_theme_func"] = "vpsmanage_theme";
    oslist();
    isolist();
    $vps = getvps($globals["vpsid"]);
    $_virt = vps_virt_text() . (!empty($user["vps"]["hvm"]) ? "hvm" : "");
    $info = $ckernel->get_all_vpsmanage($globals["vpsid"]);
    $distro = $info["os"]["distro"];
    if(!empty($vps["iso"])) {
        $info["os"]["name"] = $isos[$vps["iso"]]["name"];
        $distro = distro_find($info["os"]["name"]);
    }
    $info["os"]["distro_logo"] = distro_logo($distro, "", 1);
    $info["ip"] = $ckernel->listips($globals["vpsid"]);
    $info["ip_count"] = count($info["ip"]);
    $info["bw_cal_config"] = !empty($globals["bw_cal_config"]) ? $globals["bw_cal_config"] : 0;
    $info["vps"] = $user["vps"];
    $info["virt"] = vps_virt_text();
    $info["vpsid"] = $user["vps"]["vpsid"];
    if(vps_virt_text() == "openvz" || vps_virt_text() == "proxo" || optGET("stats")) {
        $tmp_vps_stats = $ckernel->vps_usage($globals["vpsid"]);
        foreach (["cpu", "ram", "disk", "inodes", "netspeed"] as $rv) {
            $info[$rv] = isset($tmp_vps_stats[$rv]) ? $tmp_vps_stats[$rv] : [];
        }
        unset($tmp_vps_stats);
        unset($rv);
    }
    if(!empty($info["vps"]["nw_suspended"])) {
        $temp = unserialize($info["vps"]["nw_suspended"]);
        $info["nw_suspended"] = $temp;
        $info["ntw_status"] = $temp["id"];
        if($info["nw_suspended"]["reason"] == "bw") {
            $service_period = get_vps_service_period($vps["vpsid"]);
            $sus_date = date("Y-m-d H:i:s", $info["nw_suspended"]["date"]);
            $unsus_date = date("Y-m-d H:i:s", $service_period["end"]);
            $info["unsupend_time_msg"] = lang_vars_name($l["unsupend_time_msg"], ["sus_date" => $sus_date, "unsus_date" => $unsus_date]);
        }
    }
    if(!empty($globals["show_server"])) {
        $info["serid"] = $user["vps"]["serid"];
        $info["server_name"] = $servers[$info["serid"]]["server_name"];
    }
    $res = makequery("SELECT uid FROM vps WHERE vpsid = :vpsid", [":vpsid" => $globals["vpsid"]]);
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $user["uid"] = $row["uid"];
    }
    if(empty($user["uid"])) {
        $error[] = $l["no_uid_in_vm"];
        return false;
    }
    if(!empty($user["vps"]["locked"]) && (time() - $user["vps"]["locked"]["time"] < 1800 || !empty($user["vps"]["locked"]["manual"]))) {
        $info["disable_power_options"] = $user["vps"]["locked"]["reason"];
        if(!empty($user["vps"]["locked"]["manual"])) {
            $info["manual_locked"] = 1;
        }
    }
    if(!empty($globals["show_vps_active_time"])) {
        $vps_time = getvps($globals["vpsid"]);
        $start = date("Y-m-d H:i:s", $vps_time["time"]);
        $end = date("Y-m-d H:i:s", time());
        $start_date = new DateTime($end);
        $since_start = $start_date->diff(new DateTime($start));
        $uptime[$l["years"]] = $since_start->y;
        $uptime[$l["months"]] = $since_start->m;
        $uptime[$l["days"]] = $since_start->d;
        $uptime[$l["hours"]] = $since_start->h;
        $uptime[$l["minutes"]] = $since_start->i;
        $cout = 0;
        $active = "";
        foreach ($uptime as $k => $v) {
            if(!empty($v)) {
                if($cout < 3) {
                    $active .= $v . " " . $k . " ";
                }
                $cout++;
            }
        }
        $info["show_vps_active_time"] = $active;
    }
    $cur_haproxy_settings = get_slave_settings($user["vps"]["serid"]);
    $info["flags"]["disable_icons_cp"] = $globals["disable_icons_cp"];
    $info["flags"]["disable_recipes"] = $globals["disable_recipes"];
    $info["flags"]["disable_backup_cp"] = $globals["disable_backup_cp"];
    $info["flags"]["has_backuply"] = $ckernel->has_plugin_license($vps["vpsid"], "backuply") && $kernel->features("inc_backup", $vps["virt"]) ? 1 : 0;
    $info["flags"]["disable_icons_monitor"] = $globals["disable_icons_monitor"];
    $info["flags"]["rescue_mode"] = $kernel->features("rescue_support", vps_virt_text()) && empty($globals["disable_rescue"]) ? 1 : 0;
    $info["flags"]["disable_change_hostname"] = $globals["disable_change_hostname"];
    $info["flags"]["disable_change_password"] = $globals["disable_change_password"];
    $info["flags"]["disable_change_vnc_password"] = $globals["disable_change_vnc_password"];
    $info["flags"]["disable_vps_config"] = $globals["disable_vps_config"];
    $info["flags"]["disable_os_reinstall"] = $globals["disable_os_reinstall"];
    $info["flags"]["disable_ssh"] = $globals["disable_ssh"];
    $info["flags"]["disable_self_shutdown"] = $globals["disable_self_shutdown"];
    $info["flags"]["disable_server_location"] = $globals["disable_server_location"];
    $info["flags"]["enable_rdns"] = $globals["enable_rdns"];
    $info["flags"]["haproxy"] = !empty($cur_haproxy_settings["haproxy_enable"]) ? 1 : 0;
    $info["flags"]["services_support"] = $kernel->features("services_support", vps_virt_text()) ? 1 : 0;
    $info["flags"]["proc_support"] = $kernel->features("proc_support", vps_virt_text()) ? 1 : 0;
    $info["flags"]["disable_enduser_sshkeys"] = $globals["disable_enduser_sshkeys"];
    $info["flags"]["disable_domain_forward"] = $globals["disable_domain_forward"];
    $info["flags"]["show_vps_active_time"] = $globals["show_vps_active_time"];
    $info["flags"]["power_only_option"] = $globals["power_only_option"];
    $info["flags"]["disable_logs"] = $globals["disable_logs"];
    $info["flags"]["disable_change_primary_ip"] = $globals["disable_change_primary_ip"];
    $info["flags"]["hide_enduser_vnc_info"] = $globals["hide_enduser_vnc_info"];
    $info["flags"]["disk_caching"] = $kernel->features("kvm_cache", vps_virt_text());
    if(!empty($globals["save_vm_pass"]) && !empty($vps["data"]["crypted_pass"])) {
        $info["flags"]["vm_username"] = "root";
        if(100000 < $vps["osid"] && preg_match("/windows/is", $vps["os_name"])) {
            $info["flags"]["vm_username"] = "Administrator";
        }
        if($ostemplates[$vps["osid"]] && !empty($ostemplates[$vps["osid"]]["template_admin_name"])) {
            $info["flags"]["vm_username"] = $ostemplates[$vps["osid"]]["template_admin_name"];
        }
        if(!empty($vps["data"]["vm_admin_name"])) {
            $info["flags"]["vm_username"] = $vps["data"]["vm_admin_name"];
        }
        $info["flags"]["vm_pass"] = htmlentities(pass_decrypt($vps["data"]["crypted_pass"], $vps["data"]["crypted_salt"]));
        unset($info["data"]["crypted_salt"]);
        unset($info["data"]["crypted_pass"]);
    }
    $_nictypes = $kernel->conf($globals["vpsid"], "nic");
    $_tuntap = $kernel->conf($globals["vpsid"], "tun_tap");
    $_ppp = $kernel->conf($globals["vpsid"], "ppp");
    $info["flags"]["hvmsettings"] = 1;
    $info["flags"]["enable_console"] = $kernel->features("serial_console", $_virt) && !empty($globals["enable_console"]) ? 1 : 0;
    $ipv6_subnets = false;
    foreach ($info["ip"] as $ip) {
        if(0 < strpos($ip, "/")) {
            $ipv6_subnets = true;
        }
    }
    $info["flags"]["ipv6_subnets"] = !empty($ipv6_subnets) ? 1 : 0;
    if(!empty($servers[$info["vps"]["serid"]]["location"]) && empty($globals["disable_server_location"])) {
        $info["flags"]["map_address"] = json_decode($servers[$info["vps"]["serid"]]["location"], 1);
    } else {
        $info["flags"]["disable_server_location"] = 1;
    }
    $info["flags"]["iso_support"] = $kernel->features("iso_support", $_virt) ? 1 : 0;
    if(!empty($user["vps"]["bpid"])) {
        if($user["vps"]["bpid"] == -1) {
            $res = makequery("SELECT bpid FROM plans \n\t\t\t\t\t\t\t\tWHERE plid = :plid", [":plid" => $user["vps"]["plid"]]);
            if(0 < vsql_num_rows($res)) {
                $row = vsql_fetch_assoc($res);
                $info["flags"]["bpid"] = $row["bpid"];
            }
        } else {
            $info["flags"]["bpid"] = $user["vps"]["bpid"];
        }
    }
    if(check_licensepro() && $user["type"] == 2 && !empty($globals["inhouse_billing"]) && !empty($user["inhouse_billing"])) {
        $virt = vps_virt_text($user["vps"]["vpsid"]);
        $vertical_scaling = $kernel->features("vertical_scaling", $virt);
        if(!empty($vertical_scaling) && !empty($globals["enable_ver_scaling"])) {
            $info["vertical_scaling"][$virt] = $vertical_scaling;
        }
        $info["ver_scaling"]["ver_ram_inc_by"] = $globals["ver_ram_inc_by"];
        $info["ver_scaling"]["ver_cpu_inc_by"] = $globals["ver_cpu_inc_by"];
        if(!empty($vps["data"])) {
            if(!empty($vertical_scaling) && !empty($vps["data"]["enable_ver_scaling"])) {
                $info["vertical_scaling"][$virt] = $vertical_scaling;
            }
            if(!empty($vps["data"]["ver_ram_inc_by"])) {
                $info["ver_scaling"]["ver_ram_inc_by"] = $vps["data"]["ver_ram_inc_by"];
            }
            if(!empty($vps["data"]["ver_cpu_inc_by"])) {
                $info["ver_scaling"]["ver_cpu_inc_by"] = $vps["data"]["ver_cpu_inc_by"];
            }
        }
        $ver_data = get_vps_meta($vps["uuid"], ["ver_ram_inc_by", "ver_cpu_inc_by"]);
        foreach ($ver_data as $vv) {
            if(!empty($vv["meta_value"])) {
                $info["ver_data"][$vv["meta_key"]] = $vv["meta_value"];
            }
        }
        $save_ver_data = optPOST("save_ver_data");
        if(!empty($save_ver_data) && !empty($info["vertical_scaling"][$virt])) {
            $vs_ver_ram_inc_by = (int) optPOST("vs_ver_ram_inc_by");
            $vs_ver_cpu_inc_by = (int) optPOST("vs_ver_cpu_inc_by");
            update_vps_meta($vps["uuid"], $vps["serid"], "ver_ram_inc_by", $vs_ver_ram_inc_by);
            update_vps_meta($vps["uuid"], $vps["serid"], "ver_cpu_inc_by", $vs_ver_cpu_inc_by);
            $ver_done = $l["hvm_done"];
        }
        if(empty($globals["disable_lb_enduser"]) && $kernel->features("load_balancer", $virt) && empty($vps["load_balancer"]) && !preg_match("/windows/is", $ostemplates[$vps["osid"]]["name"])) {
            $load_balancer = get_load_balancer(["sgid" => $servers[$vps["serid"]]["sgid"], "uid" => $vps["uid"]]);
        }
    }
    $available = [];
    $cp_file = $globals["path"] . "/cp_supported_os.json";
    if(file_exists($cp_file) && is_safe_file($cp_file)) {
        $json = file_get_contents($cp_file);
        if(empty($json)) {
            $info["nojson"] = 1;
        }
        $vars = json_decode($json, true);
        $currentos = strtolower($info["os"]["name"]);
        if(!empty($json) && is_array($vars)) {
            foreach ($vars as $k => $v) {
                foreach ($v as $os) {
                    if(strpos($os, "|") !== false && preg_match_all("/" . $os . "/", $currentos, $matches)) {
                        if(1 < count($matches[0])) {
                            $available[] = $k;
                        }
                    } elseif(preg_match("/" . $os . "/", $currentos)) {
                        $available[] = $k;
                    }
                }
            }
        }
    }
    if(!empty($globals["hide_eu_tasks"])) {
        $info["hide_eu_tasks"] = $globals["hide_eu_tasks"];
    }
    $res = makequery("SELECT * FROM `user_meta` WHERE uid = :uid AND meta_key LIKE '2fa_type'", [":uid" => $user["uid"]]);
    if(0 < vsql_num_rows($res)) {
        $row = vsql_fetch_assoc($res);
        $info["2fa_type"] = $row["meta_value"];
    }
    $res = makequery("SELECT *  FROM `logs_login` WHERE `username` LIKE '" . $user["email"] . "' ORDER BY `time` DESC LIMIT 1;");
    if(0 < vsql_num_rows($res)) {
        $row = vsql_fetch_assoc($res);
        $info["last_login"] = datify($row["time"], false);
    }
}
function API_vpsmanage()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $user;
    global $l;
    global $info;
    global $available;
    global $ver_done;
    global $load_balancer;
    $GLOBALS["_api"]["info"] = $info;
    $GLOBALS["_api"]["available"] = $available;
    $GLOBALS["_api"]["ver_done"] = $ver_done;
    if(!empty($load_balancer)) {
        $GLOBALS["_api"]["load_balancer"] = $load_balancer;
    }
}

?>