<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function vpsbackups()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $servers;
    global $done;
    global $backup_date;
    global $backups_list;
    global $curr_backup_list;
    global $selected_date;
    global $restore_done;
    global $delete_done;
    global $existing_vps;
    global $storages;
    global $servers_keypass;
    global $restore_details;
    if(!load_lang("admin/vpsbackups")) {
        return false;
    }
    $theme["init_theme"] = "admin/vpsbackups";
    $theme["init_theme_name"] = "VPS Backups";
    $theme["init_theme_func"] = ["vpsbackups_theme"];
    $theme["call_theme_func"] = "vpsbackups_theme";
    if(!is_allowed("vpsbackups")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $backup_array = optREQ("delete");
    if(!empty($backup_array)) {
        if(!is_allowed("deletevpsbackup")) {
            reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
            return false;
        }
        $backup_array = cexplode(",", $backup_array, 1);
        $backup_date = optREQ("date");
        if(!isset($backup_date)) {
            $error[] = $l["no_date"];
            return false;
        }
        foreach ($backup_array as $k => $v) {
            $vpsid = $v;
            if(!isset($vpsid)) {
            } elseif(!$cluster->delete_vps_backup($globals["server"], $vpsid, $backup_date)) {
                $backup_error[] = "VPSID: " . $vpsid . ", Date: " . $backup_date;
            } else {
                logs_admin("delbackup", $backup_date, 1, $vpsid, $user["uid"]);
            }
        }
        if(0 < count($backup_error)) {
            $error[] = $l["err_del_backup"] . "\n" . implode("\n", array_values($backup_error));
        } else {
            $delete_done = 1;
        }
    }
    if(!empty($_REQUEST["restore_details"])) {
        $vpsid = (int) optREQ("restore_details");
        $backup_date = REQUEST("date", $l["no_date"]);
        if(!empty($error)) {
            return false;
        }
        $res = makequery("SELECT bs.*, vbs.bid as backup_server, vbs.dir as backup_dir FROM `backup_servers` bs\n\t\t\t\t\t\t\tRIGHT JOIN `vpsbackup_settings` vbs ON vbs.bid = bs.bid\n\t\t\t\t\t\t\tWHERE vbs.serid = :serid", [":serid" => $globals["server"]]);
        if(vsql_num_rows($res) == 0) {
            $error[] = $l["err_bkup_settings_notfound"];
            return false;
        }
        $backup_settings = vsql_fetch_assoc($res);
        if(!empty($backup_settings["backup_server"])) {
            $backup_settings["password"] = pass_decrypt($backup_settings["password"], $backup_settings["salt"]);
        }
        if(empty($backup_settings["backup_server"])) {
            $inf = $cluster->get_inf_contents($globals["server"], $vpsid, $backup_date);
        } elseif($backup_settings["type"] == "FTP") {
            $inf = @file_get_contents("ftp://" . @urlencode($backup_settings["username"]) . ":" . @urlencode($backup_settings["password"]) . "@" . $backup_settings["hostname"] . ":" . $backup_settings["port"] . $backup_settings["backup_dir"] . "/" . $backup_date . "/" . $vpsid . ".inf");
        } elseif($backup_settings["type"] == "SSH") {
            $inf = @file_get_contents("ssh2.sftp://" . @urlencode($backup_settings["username"]) . ":" . @urlencode($backup_settings["password"]) . "@" . $backup_settings["hostname"] . ":" . $backup_settings["port"] . $backup_settings["backup_dir"] . "/" . $backup_date . "/" . $vpsid . ".inf");
        }
        if(empty($inf)) {
            $error[] = $l["err_inf"];
            return false;
        }
        $post = _unserialize($inf);
        $res = makequery("SELECT uid, email FROM users");
        $users = [];
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $users[$row["uid"]] = $row["email"];
        }
        $restore_details = ["hostname" => "Restored-" . (int) $post["vpsid"], "uid" => (int) $post["uid"], "users" => $users];
        return true;
    }
    if(!empty($_REQUEST["restore"])) {
        if(!is_allowed("restorevpsbackup")) {
            reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
            return false;
        }
        $vpsid = (int) REQUEST("restore", $l["no_vid"]);
        $backup_date = REQUEST("date", $l["no_date"]);
        $new_vps = (int) optREQ("newvps");
        if(!empty($error)) {
            return false;
        }
        if(!empty($new_vps)) {
            $res = makequery("SELECT bs.*, vbs.bid as backup_server, vbs.dir as backup_dir FROM `backup_servers` bs\n\t\t\t\t\t\t\t\tRIGHT JOIN `vpsbackup_settings` vbs ON vbs.bid = bs.bid\n\t\t\t\t\t\t\t\tWHERE vbs.serid = :serid", [":serid" => $globals["server"]]);
            if(vsql_num_rows($res) == 0) {
                $error[] = $l["err_bkup_settings_notfound"];
                return false;
            }
            $backup_settings = vsql_fetch_assoc($res);
            if(!empty($backup_settings["backup_server"])) {
                $backup_settings["password"] = pass_decrypt($backup_settings["password"], $backup_settings["salt"]);
            }
            if(empty($backup_settings["backup_server"])) {
                $inf = $cluster->get_inf_contents($globals["server"], $vpsid, $backup_date);
            } elseif($backup_settings["type"] == "FTP") {
                $inf = @file_get_contents("ftp://" . @urlencode($backup_settings["username"]) . ":" . @urlencode($backup_settings["password"]) . "@" . $backup_settings["hostname"] . ":" . $backup_settings["port"] . $backup_settings["backup_dir"] . "/" . $backup_date . "/" . $vpsid . ".inf");
            } elseif($backup_settings["type"] == "SSH") {
                $inf = @file_get_contents("ssh2.sftp://" . @urlencode($backup_settings["username"]) . ":" . @urlencode($backup_settings["password"]) . "@" . $backup_settings["hostname"] . ":" . $backup_settings["port"] . $backup_settings["backup_dir"] . "/" . $backup_date . "/" . $vpsid . ".inf");
            }
            if(empty($inf)) {
                $error[] = $l["err_inf"];
                return false;
            }
            $post = _unserialize($inf);
            $uid = optREQ("uid");
            if(!empty($uid)) {
                $post["uid"] = $uid;
            }
            if(server_virt($globals["server"], $post["virt"]) != $post["virt"]) {
                $error[] = $l["vps_virt_inv"];
                return false;
            }
            if(!empty($post["dns_nameserver"])) {
                $post["dns"] = _unserialize($post["dns_nameserver"]);
            }
            if(isset($post["io"])) {
                $post["priority"] = $post["io"];
            }
            if(isset($post["swap"])) {
                $post["swapram"] = $post["swap"];
            }
            if(!empty($post["vnc"])) {
                $post["vncpass"] = generateRandStr($kernel->features("vncpasslen", $post["virt"]));
            }
            if(!empty($post["plid"])) {
                unset($post["plid"]);
            }
            $hostname = optREQ("hostname");
            $post["rootpass"] = generateRandStr(16) . "@1aA";
            $post["addvps"] = 1;
            $post["restore"] = 1;
            $post["backup_date"] = $backup_date;
            $post["backup_vpsid"] = $vpsid;
            $post["hostname"] = empty($hostname) ? "Restored-" . $post["hostname"] : $hostname;
            $post["num_ips"] = 1;
            $result = make_api_call("127.0.0.1", $servers_keypass[0]["pass"], "index.php?act=addvs&changeserid=" . $globals["server"], 0, $post);
            if(empty($result["done"])) {
                log_output(implode("\n", $result["error"]));
                $error[] = $l["err_restore"];
                $error = merge_error($error, $result["error"]);
            } else {
                $restore_done = true;
            }
        } elseif($cluster->restore_vps($globals["server"], $vpsid, $backup_date, $vpsid)) {
            logs_admin("startedrestorevps", $vpsid, 1, 0, $user["uid"]);
            $restore_done = true;
        }
    }
    $curr_backup_list = [];
    $selected_date = 0;
    if(!empty($_REQUEST["date"])) {
        $selected_date = optREQ("date");
    }
    $backups_list = $cluster->list_vps_backups($globals["server"], $selected_date);
    ksort($backups_list, SORT_NUMERIC);
    $backups_list = array_reverse($backups_list, true);
    if(empty($selected_date)) {
        $keys = array_keys($backups_list);
        $selected_date = max($keys);
    }
    if(empty($selected_date) || empty($backups_list[$selected_date])) {
        return false;
    }
    $curr_backup_list[$selected_date] = $backups_list[$selected_date];
    $vpsids = [];
    foreach ($curr_backup_list as $k => $backup) {
        if(!empty($backup)) {
            foreach ($backup as $index => $v) {
                $filename = basename($v["abs_path"]);
                $temp = explode(".", $filename);
                $vid = (int) $temp[0];
                if(!empty($vid)) {
                    $vpsids[] = $vid;
                }
            }
        }
    }
    if(empty($vpsids)) {
        $vpsids[] = -1;
    }
    $res = makequery("SELECT vpsid FROM `vps` WHERE vpsid in (" . implode(", ", $vpsids) . ")");
    $existing_vps = [];
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $existing_vps[] = $row["vpsid"];
    }
}
function API_vpsbackups()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $restore_done;
    global $delete_done;
    global $backups_list;
    global $existing_vps;
    global $restore_details;
    $GLOBALS["_api"]["backups_list"] = $backups_list;
    if(!empty($restore_done)) {
        $GLOBALS["_api"]["restore_done"] = $restore_done;
    }
    if(!empty($delete_done)) {
        $GLOBALS["_api"]["delete_done"] = $delete_done;
    }
    if(!empty($existing_vps)) {
        $GLOBALS["_api"]["existing_vps"] = $existing_vps;
    }
    if(!empty($restore_details)) {
        $GLOBALS["_api"]["restore_details"] = $restore_details;
    }
}

?>