<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function vpsbackup_settings()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $servers;
    global $done;
    global $backupservers;
    global $backup_settings;
    global $vpses;
    global $log;
    global $log_len;
    global $backup_now;
    global $unsupported_arch;
    if(!load_lang("admin/vpsbackup_settings")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/vpsbackup_settings";
    $theme["init_theme_name"] = "VPS Backups";
    $theme["init_theme_func"] = ["vpsbackup_settings_theme"];
    $theme["call_theme_func"] = "vpsbackup_settings_theme";
    if(!is_allowed("vpsbackupsettings")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $backupservers = [];
    $res = makequery("SELECT * FROM backup_servers");
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $backupservers[$row["bid"]] = $row;
        $backupservers[$row["bid"]]["password"] = "";
        $backupservers[$row["bid"]]["salt"] = "";
    }
    $res = makequery("SELECT * FROM vps WHERE serid=:serid", [":serid" => $globals["server"]]);
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $vpses[$row["vpsid"]] = $row;
    }
    $unsupported_arch = 0;
    $arch = server_os_arch($globals["server"]);
    if(server_virt($globals["server"], "xcp") == "xcp" && $arch == 32) {
        $unsupported_arch = 1;
    }
    if(isset($_POST["vpsbackups"])) {
        $type = POST("type", $l["no_type"]);
        if(!in_array($type, ["FTP", "LOCAL", "SSH"])) {
            $error[] = $l["inv_backup_type"];
        }
        $bid = 0;
        if($type == "FTP" || $type == "SSH") {
            $bid = (int) POST("id", $l["no_backupserver"]);
            if(!empty($unsupported_arch)) {
                $error[] = $l["unsupported_arch"];
                return false;
            }
        }
        $freq = POST("freq", $l["no_freq"]);
        $hourly_freq = POST("hourly_freq", $l["no_hourly_freq"]);
        $hrs = POST("hrs", $l["no_time"]);
        $min = POST("min", $l["no_time"]);
        $day = optPOST("day");
        $date = optPOST("date");
        $rotation = POST("rotation", $l["no_rotation"]);
        $enabled = (int) checkbox("enabled");
        $newvps = (int) checkbox("newvps");
        $nice = POST("nice", $l["no_nice"]);
        $ionice_prio = POST("ionice_prio", $l["no_ionice_prio"]);
        $ionice_class = POST("ionice_class", $l["no_ionice_class"]);
        $compression = (int) checkbox("compression");
        $dir = POST("dir", $l["no_dir"]);
        $sel_vpses = $_POST["vpses"];
        if($type != "LOCAL" && $type != $backupservers[$bid]["type"]) {
            $error[] = lang_vars($l["ssh_server_error"], [$backupservers[$bid]["type"], $type]);
        }
        if(empty($sel_vpses) && !empty($enabled)) {
            $error[] = $l["no_vps_sel"];
        }
        if(!empty($error)) {
            return false;
        }
        foreach ($sel_vpses as $sk => $sv) {
            $sel_vpses[(int) $sk] = (int) $sv;
        }
        $time = $hrs . ":" . $min;
        $qres = makequery("REPLACE INTO vpsbackup_settings SET\n\t\t\t\t\t\t\tserid = :serid,\n\t\t\t\t\t\t\tbid = :bid,\n\t\t\t\t\t\t\tenabled = :enabled,\n\t\t\t\t\t\t\tnewvps = :newvps,\n\t\t\t\t\t\t\tfrequency = :freq,\n\t\t\t\t\t\t\trun_time = :time,\n\t\t\t\t\t\t\thourly_freq = :hourly_freq,\n\t\t\t\t\t\t\trun_day = :day,\n\t\t\t\t\t\t\trun_date = :date,\n\t\t\t\t\t\t\trotation = :rotation,\n\t\t\t\t\t\t\tvpsids = :sel_vpses,\n\t\t\t\t\t\t\tnice = :nice,\n\t\t\t\t\t\t\tionice_prio = :ionice_prio,\n\t\t\t\t\t\t\tionice_class = :ionice_class,\n\t\t\t\t\t\t\tdisable_compression = :compression,\n\t\t\t\t\t\t\tdir= :dir", [":serid" => $globals["server"], ":bid" => $bid, ":enabled" => $enabled, ":newvps" => $newvps, ":freq" => $freq, ":time" => $time, ":hourly_freq" => $hourly_freq, ":day" => $day, ":date" => $date, ":rotation" => $rotation, ":sel_vpses" => serialize($sel_vpses), ":nice" => $nice, ":ionice_prio" => $ionice_prio, ":ionice_class" => $ionice_class, ":compression" => $compression, ":dir" => $dir]);
        if(!$qres) {
            $error[] = $l["err_saving"];
            return false;
        }
        $sres = $cluster->sync($globals["server"]);
        if(empty($sres)) {
            $error[] = $l["err_save_slave"];
        }
        $data = ["frequency" => $freq, "hrs" => $hrs, "min" => $min, "day" => $day, "date" => $date, "hourly_freq" => $hourly_freq];
        if(!$cluster->set_vpsbackup_cron($globals["server"], $data)) {
            $error[] = $l["err_saving"];
        } else {
            $done = true;
            logs_admin("setbackupsettings", "", 1, $globals["server"], $user["uid"]);
        }
    }
    if(isset($_POST["clearlog"])) {
        $cluster->clear_vpsbackups_log($globals["server"]);
    }
    if(isset($_POST["backupnow"])) {
        $cluster->backupnow($globals["server"]);
        $backup_now = 1;
    }
    $log_len = 50;
    if(isset($_REQUEST["loglen"])) {
        $log_len = (int) optPOST("len");
        if(is_int($log_len)) {
            $log_len = 1000 < $log_len ? 1000 : $log_len;
        }
        if($globals["server"] != 0 && is_master()) {
            $ret = $cluster->reverse_sync($globals["server"]);
        }
    }
    $log = $cluster->get_vpsbackups_log($globals["server"], $log_len);
    $backup_settings = [];
    $res = makequery("SELECT * FROM vpsbackup_settings WHERE serid=:serid", [":serid" => $globals["server"]]);
    $row = vsql_fetch_assoc($res);
    $backup_settings = $row;
    $time = explode(":", $backup_settings["run_time"]);
    list($backup_settings["hrs"], $backup_settings["min"]) = $time;
    $backup_settings["vpsids"] = @unserialize($backup_settings["vpsids"]);
    $backup_settings["log"] = $log;
}
function API_vpsbackup_settings()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $v;
    global $host;
    global $backup_settings;
    global $error;
    global $done;
    global $cluster;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = 1;
    }
    $GLOBALS["_api"]["backupsettings"] = $backup_settings;
}

?>