<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
/**
 * @class TCPDF_STATIC
 * Static methods used by the TCPDF class.
 * @package com.tecnick.tcpdf
 * @brief PHP class for generating PDF documents without requiring external extensions.
 * @version 1.1.1
 * @author Nicola Asuni - info@tecnick.com
 */
class TCPDF_STATIC
{
    /**
     * Array of page formats
     * measures are calculated in this way: (inches * 72) or (millimeters * 72 / 25.4)
     * @public static
     * 
     * @var array<string,float[]>
     */
    public static $page_formats = ["A0" => [2383.937, 3370.394], "A1" => [1683.78, 2383.937], "A2" => [1190.551, 1683.78], "A3" => [841.89, 1190.551], "A4" => [595.276, 841.89], "A5" => [419.528, 595.276], "A6" => [297.638, 419.528], "A7" => [209.764, 297.638], "A8" => [147.402, 209.764], "A9" => [104.882, 147.402], "A10" => [73.70099999999999, 104.882], "A11" => [51.024, 73.70099999999999], "A12" => [36.85, 51.024], "B0" => [2834.646, 4008.189], "B1" => [2004.094, 2834.646], "B2" => [1417.323, 2004.094], "B3" => [1000.63, 1417.323], "B4" => [708.6609999999999, 1000.63], "B5" => [498.898, 708.6609999999999], "B6" => [354.331, 498.898], "B7" => [249.449, 354.331], "B8" => [175.748, 249.449], "B9" => [124.724, 175.748], "B10" => [87.874, 124.724], "B11" => [62.362, 87.874], "B12" => [42.52, 62.362], "C0" => [2599.37, 3676.535], "C1" => [1836.85, 2599.37], "C2" => [1298.268, 1836.85], "C3" => [918.425, 1298.268], "C4" => [649.134, 918.425], "C5" => [459.213, 649.134], "C6" => [323.15, 459.213], "C7" => [229.606, 323.15], "C8" => [161.575, 229.606], "C9" => [113.386, 161.575], "C10" => [79.37, 113.386], "C11" => [56.693, 79.37], "C12" => [39.685, 56.693], "C76" => [229.606, 459.213], "DL" => [311.811, 623.622], "DLE" => [323.15, 637.795], "DLX" => [340.158, 666.1420000000001], "DLP" => [280.63, 595.276], "E0" => [2491.654, 3517.795], "E1" => [1757.48, 2491.654], "E2" => [1247.244, 1757.48], "E3" => [878.74, 1247.244], "E4" => [623.622, 878.74], "E5" => [439.37, 623.622], "E6" => [311.811, 439.37], "E7" => [221.102, 311.811], "E8" => [155.906, 221.102], "E9" => [110.551, 155.906], "E10" => [76.535, 110.551], "E11" => [53.858, 76.535], "E12" => [36.85, 53.858], "G0" => [2715.591, 3838.11], "G1" => [1919.055, 2715.591], "G2" => [1357.795, 1919.055], "G3" => [958.11, 1357.795], "G4" => [677.48, 958.11], "G5" => [479.055, 677.48], "G6" => [337.323, 479.055], "G7" => [238.11, 337.323], "G8" => [167.244, 238.11], "G9" => [119.055, 167.244], "G10" => [82.205, 119.055], "G11" => [59.528, 82.205], "G12" => [39.685, 59.528], "RA0" => [2437.795, 3458.268], "RA1" => [1729.134, 2437.795], "RA2" => [1218.898, 1729.134], "RA3" => [864.567, 1218.898], "RA4" => [609.449, 864.567], "SRA0" => [2551.181, 3628.346], "SRA1" => [1814.173, 2551.181], "SRA2" => [1275.591, 1814.173], "SRA3" => [907.087, 1275.591], "SRA4" => [637.795, 907.087], "4A0" => [4767.874, 6740.787], "2A0" => [3370.394, 4767.874], "A2_EXTRA" => [1261.417, 1754.646], "A3+" => [932.598, 1369.134], "A3_EXTRA" => [912.756, 1261.417], "A3_SUPER" => [864.567, 1440], "SUPER_A3" => [864.567, 1380.472], "A4_EXTRA" => [666.1420000000001, 912.756], "A4_SUPER" => [649.134, 912.756], "SUPER_A4" => [643.465, 1009.134], "A4_LONG" => [595.276, 986.457], "F4" => [595.276, 935.433], "SO_B5_EXTRA" => [572.598, 782.362], "A5_EXTRA" => [490.394, 666.1420000000001], "ANSI_E" => [2448, 3168], "ANSI_D" => [1584, 2448], "ANSI_C" => [1224, 1584], "ANSI_B" => [792, 1224], "ANSI_A" => [612, 792], "USLEDGER" => [1224, 792], "LEDGER" => [1224, 792], "ORGANIZERK" => [792, 1224], "BIBLE" => [792, 1224], "USTABLOID" => [792, 1224], "TABLOID" => [792, 1224], "ORGANIZERM" => [612, 792], "USLETTER" => [612, 792], "LETTER" => [612, 792], "USLEGAL" => [612, 1008], "LEGAL" => [612, 1008], "GOVERNMENTLETTER" => [576, 756], "GLETTER" => [576, 756], "JUNIORLEGAL" => [576, 360], "JLEGAL" => [576, 360], "QUADDEMY" => [2520, 3240], "SUPER_B" => [936, 1368], "QUARTO" => [648, 792], "GOVERNMENTLEGAL" => [612, 936], "FOLIO" => [612, 936], "MONARCH" => [522, 756], "EXECUTIVE" => [522, 756], "ORGANIZERL" => [396, 612], "STATEMENT" => [396, 612], "MEMO" => [396, 612], "FOOLSCAP" => [595.4400000000001, 936], "COMPACT" => [306, 486], "ORGANIZERJ" => [198, 360], "P1" => [1587.402, 2437.795], "P2" => [1218.898, 1587.402], "P3" => [793.701, 1218.898], "P4" => [609.449, 793.701], "P5" => [396.85, 609.449], "P6" => [303.307, 396.85], "ARCH_E" => [2592, 3456], "ARCH_E1" => [2160, 3024], "ARCH_D" => [1728, 2592], "BROADSHEET" => [1296, 1728], "ARCH_C" => [1296, 1728], "ARCH_B" => [864, 1296], "ARCH_A" => [648, 864], "ANNENV_A2" => [314.64, 414], "ANNENV_A6" => [342, 468], "ANNENV_A7" => [378, 522], "ANNENV_A8" => [396, 584.64], "ANNENV_A10" => [450, 692.64], "ANNENV_SLIM" => [278.64, 638.64], "COMMENV_N6_1/4" => [252, 432], "COMMENV_N6_3/4" => [260.64, 468], "COMMENV_N8" => [278.64, 540], "COMMENV_N9" => [278.64, 638.64], "COMMENV_N10" => [296.64, 684], "COMMENV_N11" => [324, 746.64], "COMMENV_N12" => [342, 792], "COMMENV_N14" => [360, 828], "CATENV_N1" => [432, 648], "CATENV_N1_3/4" => [468, 684], "CATENV_N2" => [468, 720], "CATENV_N3" => [504, 720], "CATENV_N6" => [540, 756], "CATENV_N7" => [576, 792], "CATENV_N8" => [594, 810], "CATENV_N9_1/2" => [612, 756], "CATENV_N9_3/4" => [630, 810], "CATENV_N10_1/2" => [648, 864], "CATENV_N12_1/2" => [684, 900], "CATENV_N13_1/2" => [720, 936], "CATENV_N14_1/4" => [810, 882], "CATENV_N14_1/2" => [828, 1044], "JIS_B0" => [2919.685, 4127.244], "JIS_B1" => [2063.622, 2919.685], "JIS_B2" => [1459.843, 2063.622], "JIS_B3" => [1031.811, 1459.843], "JIS_B4" => [728.504, 1031.811], "JIS_B5" => [515.9059999999999, 728.504], "JIS_B6" => [362.835, 515.9059999999999], "JIS_B7" => [257.953, 362.835], "JIS_B8" => [181.417, 257.953], "JIS_B9" => [127.559, 181.417], "JIS_B10" => [90.709, 127.559], "JIS_B11" => [62.362, 90.709], "JIS_B12" => [45.354, 62.362], "PA0" => [2381.102, 3174.803], "PA1" => [1587.402, 2381.102], "PA2" => [1190.551, 1587.402], "PA3" => [793.701, 1190.551], "PA4" => [595.276, 793.701], "PA5" => [396.85, 595.276], "PA6" => [297.638, 396.85], "PA7" => [198.425, 297.638], "PA8" => [147.402, 198.425], "PA9" => [99.21299999999999, 147.402], "PA10" => [73.70099999999999, 99.21299999999999], "PASSPORT_PHOTO" => [99.21299999999999, 127.559], "E" => [233.858, 340.157], "L" => [252.283, 360], "3R" => [252.283, 360], "KG" => [289.134, 430.866], "4R" => [289.134, 430.866], "4D" => [340.157, 430.866], "2L" => [360, 504.567], "5R" => [360, 504.567], "8P" => [430.866, 575.433], "6R" => [430.866, 575.433], "6P" => [575.433, 720], "8R" => [575.433, 720], "6PW" => [575.433, 864.567], "S8R" => [575.433, 864.567], "4P" => [720, 864.567], "10R" => [720, 864.567], "4PW" => [720, 1080], "S10R" => [720, 1080], "11R" => [790.866, 1009.134], "S11R" => [790.866, 1224.567], "12R" => [864.567, 1080], "S12R" => [864.567, 1292.598], "NEWSPAPER_BROADSHEET" => [2125.984, 1700.787], "NEWSPAPER_BERLINER" => [1332.283, 892.913], "NEWSPAPER_TABLOID" => [1218.898, 793.701], "NEWSPAPER_COMPACT" => [1218.898, 793.701], "CREDIT_CARD" => [153.014, 242.646], "BUSINESS_CARD" => [153.014, 242.646], "BUSINESS_CARD_ISO7810" => [153.014, 242.646], "BUSINESS_CARD_ISO216" => [147.402, 209.764], "BUSINESS_CARD_IT" => [155.906, 240.945], "BUSINESS_CARD_UK" => [155.906, 240.945], "BUSINESS_CARD_FR" => [155.906, 240.945], "BUSINESS_CARD_DE" => [155.906, 240.945], "BUSINESS_CARD_ES" => [155.906, 240.945], "BUSINESS_CARD_CA" => [144.567, 252.283], "BUSINESS_CARD_US" => [144.567, 252.283], "BUSINESS_CARD_JP" => [155.906, 257.953], "BUSINESS_CARD_HK" => [153.071, 255.118], "BUSINESS_CARD_AU" => [155.906, 255.118], "BUSINESS_CARD_DK" => [155.906, 255.118], "BUSINESS_CARD_SE" => [155.906, 255.118], "BUSINESS_CARD_RU" => [141.732, 255.118], "BUSINESS_CARD_CZ" => [141.732, 255.118], "BUSINESS_CARD_FI" => [141.732, 255.118], "BUSINESS_CARD_HU" => [141.732, 255.118], "BUSINESS_CARD_IL" => [141.732, 255.118], "4SHEET" => [2880, 4320], "6SHEET" => [3401.575, 5102.362], "12SHEET" => [8640, 4320], "16SHEET" => [5760, 8640], "32SHEET" => [11520, 8640], "48SHEET" => [17280, 8640], "64SHEET" => [23040, 8640], "96SHEET" => [34560, 8640], "EN_EMPEROR" => [3456, 5184], "EN_ANTIQUARIAN" => [2232, 3816], "EN_GRAND_EAGLE" => [2070, 3024], "EN_DOUBLE_ELEPHANT" => [1926, 2880], "EN_ATLAS" => [1872, 2448], "EN_COLOMBIER" => [1692, 2484], "EN_ELEPHANT" => [1656, 2016], "EN_DOUBLE_DEMY" => [1620, 2556], "EN_IMPERIAL" => [1584, 2160], "EN_PRINCESS" => [1548, 2016], "EN_CARTRIDGE" => [1512, 1872], "EN_DOUBLE_LARGE_POST" => [1512, 2376], "EN_ROYAL" => [1440, 1800], "EN_SHEET" => [1404, 1692], "EN_HALF_POST" => [1404, 1692], "EN_SUPER_ROYAL" => [1368, 1944], "EN_DOUBLE_POST" => [1368, 2196], "EN_MEDIUM" => [1260, 1656], "EN_DEMY" => [1260, 1620], "EN_LARGE_POST" => [1188, 1512], "EN_COPY_DRAUGHT" => [1152, 1440], "EN_POST" => [1116, 1386], "EN_CROWN" => [1080, 1440], "EN_PINCHED_POST" => [1062, 1332], "EN_BRIEF" => [972, 1152], "EN_FOOLSCAP" => [972, 1224], "EN_SMALL_FOOLSCAP" => [954, 1188], "EN_POTT" => [900, 1080], "BE_GRAND_AIGLE" => [1984.252, 2948.031], "BE_COLOMBIER" => [1757.48, 2409.449], "BE_DOUBLE_CARRE" => [1757.48, 2607.874], "BE_ELEPHANT" => [1746.142, 2182.677], "BE_PETIT_AIGLE" => [1700.787, 2381.102], "BE_GRAND_JESUS" => [1559.055, 2069.291], "BE_JESUS" => [1530.709, 2069.291], "BE_RAISIN" => [1417.323, 1842.52], "BE_GRAND_MEDIAN" => [1303.937, 1714.961], "BE_DOUBLE_POSTE" => [1233.071, 1601.575], "BE_COQUILLE" => [1218.898, 1587.402], "BE_PETIT_MEDIAN" => [1176.378, 1502.362], "BE_RUCHE" => [1020.472, 1303.937], "BE_PROPATRIA" => [977.953, 1218.898], "BE_LYS" => [898.583, 1125.354], "BE_POT" => [870.236, 1088.504], "BE_ROSETTE" => [765.354, 983.622], "FR_UNIVERS" => [2834.646, 3685.039], "FR_DOUBLE_COLOMBIER" => [2551.181, 3571.654], "FR_GRANDE_MONDE" => [2551.181, 3571.654], "FR_DOUBLE_SOLEIL" => [2267.717, 3401.575], "FR_DOUBLE_JESUS" => [2154.331, 3174.803], "FR_GRAND_AIGLE" => [2125.984, 3004.724], "FR_PETIT_AIGLE" => [1984.252, 2664.567], "FR_DOUBLE_RAISIN" => [1842.52, 2834.646], "FR_JOURNAL" => [1842.52, 2664.567], "FR_COLOMBIER_AFFICHE" => [1785.827, 2551.181], "FR_DOUBLE_CAVALIER" => [1757.48, 2607.874], "FR_CLOCHE" => [1700.787, 2267.717], "FR_SOLEIL" => [1700.787, 2267.717], "FR_DOUBLE_CARRE" => [1587.402, 2551.181], "FR_DOUBLE_COQUILLE" => [1587.402, 2494.488], "FR_JESUS" => [1587.402, 2154.331], "FR_RAISIN" => [1417.323, 1842.52], "FR_CAVALIER" => [1303.937, 1757.48], "FR_DOUBLE_COURONNE" => [1303.937, 2040.945], "FR_CARRE" => [1275.591, 1587.402], "FR_COQUILLE" => [1247.244, 1587.402], "FR_DOUBLE_TELLIERE" => [1247.244, 1927.559], "FR_DOUBLE_CLOCHE" => [1133.858, 1700.787], "FR_DOUBLE_POT" => [1133.858, 1757.48], "FR_ECU" => [1133.858, 1474.016], "FR_COURONNE" => [1020.472, 1303.937], "FR_TELLIERE" => [963.78, 1247.244], "FR_POT" => [878.74, 1133.858]];
    /**
     * Current TCPDF version.
     * @private static
     */
    private static $tcpdf_version = "6.5.0";
    /**
     * String alias for total number of pages.
     * @public static
     */
    public static $alias_tot_pages = "{:ptp:}";
    /**
     * String alias for page number.
     * @public static
     */
    public static $alias_num_page = "{:pnp:}";
    /**
     * String alias for total number of pages in a single group.
     * @public static
     */
    public static $alias_group_tot_pages = "{:ptg:}";
    /**
     * String alias for group page number.
     * @public static
     */
    public static $alias_group_num_page = "{:png:}";
    /**
     * String alias for right shift compensation used to correctly align page numbers on the right.
     * @public static
     */
    public static $alias_right_shift = "{rsc:";
    /**
     * Encryption padding string.
     * @public static
     */
    public static $enc_padding = "(�N^Nu�Ad\0NV��\1\10..\0��h>�/\f��dSiz";
    /**
     * ByteRange placemark used during digital signature process.
     * @since 4.6.028 (2009-08-25)
     * @public static
     */
    public static $byterange_string = "/ByteRange[0 ********** ********** **********]";
    /**
     * Array page boxes names
     * @public static
     */
    public static $pageboxes = ["MediaBox", "CropBox", "BleedBox", "TrimBox", "ArtBox"];
    public static function getTCPDFVersion()
    {
        return self::$tcpdf_version;
    }
    public static function getTCPDFProducer()
    {
        return "TCPDF " . self::getTCPDFVersion() . " (http://www.tcpdf.org)";
    }
    public static function set_mqr($mqr)
    {
        if(!defined("PHP_VERSION_ID")) {
            $version = PHP_VERSION;
            define("PHP_VERSION_ID", $version[0] * 10000 + $version[2] * 100 + $version[4]);
        }
        if(PHP_VERSION_ID < 50300) {
            @set_magic_quotes_runtime($mqr);
        }
    }
    public static function get_mqr()
    {
        if(!defined("PHP_VERSION_ID")) {
            $version = PHP_VERSION;
            define("PHP_VERSION_ID", $version[0] * 10000 + $version[2] * 100 + $version[4]);
        }
        if(PHP_VERSION_ID < 50300) {
            return @get_magic_quotes_runtime();
        }
        return 0;
    }
    public static function isValidURL($url)
    {
        $headers = @get_headers($url);
        if($headers === false) {
            return false;
        }
        return strpos($headers[0], "200") !== false;
    }
    public static function removeSHY($txt = "", $unicode = true)
    {
        $txt = preg_replace("/([\\xc2]{1}[\\xad]{1})/", "", $txt);
        if(!$unicode) {
            $txt = preg_replace("/([\\xad]{1})/", "", $txt);
        }
        return $txt;
    }
    public static function getBorderMode($brd, $position = "start", $opencell = true)
    {
        if(!$opencell || empty($brd)) {
            return $brd;
        }
        if($brd == 1) {
            $brd = "LTRB";
        }
        if(is_string($brd)) {
            $slen = strlen($brd);
            $newbrd = [];
            for ($i = 0; $i < $slen; $i++) {
                $newbrd[$brd[$i]] = ["cap" => "square", "join" => "miter"];
            }
            $brd = $newbrd;
        }
        foreach ($brd as $border => $style) {
            switch ($position) {
                case "start":
                    if(strpos($border, "B") !== false) {
                        $newkey = str_replace("B", "", $border);
                        if(0 < strlen($newkey)) {
                            $brd[$newkey] = $style;
                        }
                        unset($brd[$border]);
                    }
                    break;
                case "middle":
                    if(strpos($border, "B") !== false) {
                        $newkey = str_replace("B", "", $border);
                        if(0 < strlen($newkey)) {
                            $brd[$newkey] = $style;
                        }
                        unset($brd[$border]);
                        $border = $newkey;
                    }
                    if(strpos($border, "T") !== false) {
                        $newkey = str_replace("T", "", $border);
                        if(0 < strlen($newkey)) {
                            $brd[$newkey] = $style;
                        }
                        unset($brd[$border]);
                    }
                    break;
                case "end":
                    if(strpos($border, "T") !== false) {
                        $newkey = str_replace("T", "", $border);
                        if(0 < strlen($newkey)) {
                            $brd[$newkey] = $style;
                        }
                        unset($brd[$border]);
                    }
                    break;
            }
        }
        return $brd;
    }
    public static function empty_string($str)
    {
        return is_null($str) || is_string($str) && strlen($str) == 0;
    }
    public static function getObjFilename($type = "tmp", $file_id = "")
    {
        return tempnam(K_PATH_CACHE, "__tcpdf_" . $file_id . "_" . $type . "_" . md5(TCPDF_STATIC::getRandomSeed()) . "_");
    }
    public static function _escape($s)
    {
        return strtr($s, [")" => "\\)", "(" => "\\(", "\\" => "\\\\", chr(13) => "\\r"]);
    }
    public static function _escapeXML($str)
    {
        $replaceTable = ["\0" => "", "&" => "&amp;", "<" => "&lt;", ">" => "&gt;"];
        $str = strtr($str, $replaceTable);
        return $str;
    }
    public static function objclone($object)
    {
        if($object instanceof Imagick && version_compare(phpversion("imagick"), "3.0.1") !== 1) {
            return @$object->clone();
        }
        return clone $object;
    }
    public static function sendOutputData($data, $length)
    {
        if(!isset($_SERVER["HTTP_ACCEPT_ENCODING"]) || empty($_SERVER["HTTP_ACCEPT_ENCODING"])) {
            header("Content-Length: " . $length);
        }
        echo $data;
    }
    public static function replacePageNumAliases($page, $replace, $diff = 0)
    {
        foreach ($replace as $rep) {
            foreach ($rep[3] as $a) {
                if(strpos($page, $a) !== false) {
                    $page = str_replace($a, $rep[0], $page);
                    $diff += $rep[2] - $rep[1];
                }
            }
        }
        return [$page, $diff];
    }
    public static function getTimestamp($date)
    {
        if($date[0] == "D" && $date[1] == ":") {
            $date = substr($date, 2);
        }
        return strtotime($date);
    }
    public static function getFormattedDate($time)
    {
        return substr_replace(date("YmdHisO", intval($time)), "'", -2, 0) . "'";
    }
    public static function getRandomSeed($seed = "")
    {
        $rnd = uniqid(rand() . microtime(true), true);
        if(function_exists("posix_getpid")) {
            $rnd .= posix_getpid();
        }
        if(function_exists("openssl_random_pseudo_bytes") && strtoupper(substr(PHP_OS, 0, 3)) !== "WIN") {
            $rnd .= openssl_random_pseudo_bytes(512);
        } else {
            for ($i = 0; $i < 23; $i++) {
                $rnd .= uniqid("", true);
            }
        }
        return $rnd . $seed . __FILE__ . serialize($_SERVER) . microtime(true);
    }
    public static function _md5_16($str)
    {
        return pack("H*", md5($str));
    }
    public static function _AES($key, $text)
    {
        $padding = 16 - strlen($text) % 16;
        $text .= str_repeat(chr($padding), $padding);
        if(extension_loaded("openssl")) {
            $algo = "aes-256-cbc";
            if(strlen($key) == 16) {
                $algo = "aes-128-cbc";
            }
            $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length($algo));
            $text = openssl_encrypt($text, $algo, $key, OPENSSL_RAW_DATA, $iv);
            return $iv . substr($text, 0, -16);
        }
        $iv = mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC), MCRYPT_RAND);
        $text = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $text, MCRYPT_MODE_CBC, $iv);
        $text = $iv . $text;
        return $text;
    }
    public static function _AESnopad($key, $text)
    {
        if(extension_loaded("openssl")) {
            $algo = "aes-256-cbc";
            if(strlen($key) == 16) {
                $algo = "aes-128-cbc";
            }
            $iv = str_repeat("\0", openssl_cipher_iv_length($algo));
            $text = openssl_encrypt($text, $algo, $key, OPENSSL_RAW_DATA, $iv);
            return substr($text, 0, -16);
        }
        $iv = str_repeat("\0", mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC));
        $text = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $text, MCRYPT_MODE_CBC, $iv);
        return $text;
    }
    public static function _RC4($key, $text, &$last_enc_key, &$last_enc_key_c)
    {
        if(function_exists("mcrypt_encrypt") && ($out = @mcrypt_encrypt(MCRYPT_ARCFOUR, $key, $text, MCRYPT_MODE_STREAM, ""))) {
            return $out;
        }
        if($last_enc_key != $key) {
            $k = str_repeat($key, (int) (256 / strlen($key) + 1));
            $rc4 = range(0, 255);
            $j = 0;
            for ($i = 0; $i < 256; $i++) {
                $t = $rc4[$i];
                $j = ($j + $t + ord($k[$i])) % 256;
                $rc4[$i] = $rc4[$j];
                $rc4[$j] = $t;
            }
            $last_enc_key = $key;
            $last_enc_key_c = $rc4;
        } else {
            $rc4 = $last_enc_key_c;
        }
        $len = strlen($text);
        $a = 0;
        $b = 0;
        $out = "";
        for ($i = 0; $i < $len; $i++) {
            $a = ($a + 1) % 256;
            $t = $rc4[$a];
            $b = ($b + $t) % 256;
            $rc4[$a] = $rc4[$b];
            $rc4[$b] = $t;
            $k = $rc4[($rc4[$a] + $rc4[$b]) % 256];
            $out .= chr(ord($text[$i]) ^ $k);
        }
        return $out;
    }
    public static function getUserPermissionCode($permissions, $mode = 0)
    {
        $options = ["owner" => 2, "print" => 4, "modify" => 8, "copy" => 16, "annot-forms" => 32, "fill-forms" => 256, "extract" => 512, "assemble" => 1024, "print-high" => 2048];
        $protection = 2147422012;
        foreach ($permissions as $permission) {
            if(isset($options[$permission]) && (0 < $mode || $options[$permission] <= 32)) {
                if($options[$permission] == 2) {
                    $protection += $options[$permission];
                } else {
                    $protection -= $options[$permission];
                }
            }
        }
        return $protection;
    }
    public static function convertHexStringToString($bs)
    {
        $string = "";
        $bslength = strlen($bs);
        if($bslength % 2 != 0) {
            $bs .= "0";
            $bslength++;
        }
        $i = 0;
        while ($i < $bslength) {
            $string .= chr(hexdec($bs[$i] . $bs[$i + 1]));
            $i += 2;
        }
        return $string;
    }
    public static function convertStringToHexString($s)
    {
        $bs = "";
        $chars = preg_split("//", $s, -1, PREG_SPLIT_NO_EMPTY);
        foreach ($chars as $c) {
            $bs .= sprintf("%02s", dechex(ord($c)));
        }
        return $bs;
    }
    public static function getEncPermissionsString($protection)
    {
        $binprot = sprintf("%032b", $protection);
        $str = chr(bindec(substr($binprot, 24, 8)));
        $str .= chr(bindec(substr($binprot, 16, 8)));
        $str .= chr(bindec(substr($binprot, 8, 8)));
        $str .= chr(bindec(substr($binprot, 0, 8)));
        return $str;
    }
    public static function encodeNameObject($name)
    {
        $escname = "";
        $length = strlen($name);
        for ($i = 0; $i < $length; $i++) {
            $chr = $name[$i];
            if(preg_match("/[0-9a-zA-Z#_=-]/", $chr) == 1) {
                $escname .= $chr;
            } else {
                $escname .= sprintf("#%02X", ord($chr));
            }
        }
        return $escname;
    }
    public static function getAnnotOptFromJSProp($prop, &$spot_colors, $rtl = false)
    {
        if(isset($prop["aopt"]) && is_array($prop["aopt"])) {
            return $prop["aopt"];
        }
        $opt = [];
        if(isset($prop["alignment"])) {
            switch ($prop["alignment"]) {
                case "left":
                    $opt["q"] = 0;
                    break;
                case "center":
                    $opt["q"] = 1;
                    break;
                case "right":
                    $opt["q"] = 2;
                    break;
                default:
                    $opt["q"] = $rtl ? 2 : 0;
            }
        }
        if(isset($prop["lineWidth"])) {
            $linewidth = intval($prop["lineWidth"]);
        } else {
            $linewidth = 1;
        }
        if(isset($prop["borderStyle"])) {
            switch ($prop["borderStyle"]) {
                case "border.d":
                case "dashed":
                    $opt["border"] = [0, 0, $linewidth, [3, 2]];
                    $opt["bs"] = ["w" => $linewidth, "s" => "D", "d" => [3, 2]];
                    break;
                case "border.b":
                case "beveled":
                    $opt["border"] = [0, 0, $linewidth];
                    $opt["bs"] = ["w" => $linewidth, "s" => "B"];
                    break;
                case "border.i":
                case "inset":
                    $opt["border"] = [0, 0, $linewidth];
                    $opt["bs"] = ["w" => $linewidth, "s" => "I"];
                    break;
                case "border.u":
                case "underline":
                    $opt["border"] = [0, 0, $linewidth];
                    $opt["bs"] = ["w" => $linewidth, "s" => "U"];
                    break;
                case "border.s":
                case "solid":
                    $opt["border"] = [0, 0, $linewidth];
                    $opt["bs"] = ["w" => $linewidth, "s" => "S"];
                    break;
            }
        }
        if(isset($prop["border"]) && is_array($prop["border"])) {
            $opt["border"] = $prop["border"];
        }
        if(!isset($opt["mk"])) {
            $opt["mk"] = [];
        }
        if(!isset($opt["mk"]["if"])) {
            $opt["mk"]["if"] = [];
        }
        $opt["mk"]["if"]["a"] = [0.5, 0.5];
        if(isset($prop["buttonAlignX"])) {
            $opt["mk"]["if"]["a"][0] = $prop["buttonAlignX"];
        }
        if(isset($prop["buttonAlignY"])) {
            $opt["mk"]["if"]["a"][1] = $prop["buttonAlignY"];
        }
        if(isset($prop["buttonFitBounds"]) && $prop["buttonFitBounds"] == "true") {
            $opt["mk"]["if"]["fb"] = true;
        }
        if(isset($prop["buttonScaleHow"])) {
            switch ($prop["buttonScaleHow"]) {
                case "scaleHow.proportional":
                    $opt["mk"]["if"]["s"] = "P";
                    break;
                case "scaleHow.anamorphic":
                    $opt["mk"]["if"]["s"] = "A";
                    break;
            }
        }
        if(isset($prop["buttonScaleWhen"])) {
            switch ($prop["buttonScaleWhen"]) {
                case "scaleWhen.always":
                    $opt["mk"]["if"]["sw"] = "A";
                    break;
                case "scaleWhen.never":
                    $opt["mk"]["if"]["sw"] = "N";
                    break;
                case "scaleWhen.tooBig":
                    $opt["mk"]["if"]["sw"] = "B";
                    break;
                case "scaleWhen.tooSmall":
                    $opt["mk"]["if"]["sw"] = "S";
                    break;
            }
        }
        if(isset($prop["buttonPosition"])) {
            switch ($prop["buttonPosition"]) {
                case 0:
                case "position.textOnly":
                    $opt["mk"]["tp"] = 0;
                    break;
                case 1:
                case "position.iconOnly":
                    $opt["mk"]["tp"] = 1;
                    break;
                case 2:
                case "position.iconTextV":
                    $opt["mk"]["tp"] = 2;
                    break;
                case 3:
                case "position.textIconV":
                    $opt["mk"]["tp"] = 3;
                    break;
                case 4:
                case "position.iconTextH":
                    $opt["mk"]["tp"] = 4;
                    break;
                case 5:
                case "position.textIconH":
                    $opt["mk"]["tp"] = 5;
                    break;
                case 6:
                case "position.overlay":
                    $opt["mk"]["tp"] = 6;
                    break;
            }
        }
        if(isset($prop["fillColor"])) {
            if(is_array($prop["fillColor"])) {
                $opt["mk"]["bg"] = $prop["fillColor"];
            } else {
                $opt["mk"]["bg"] = TCPDF_COLORS::convertHTMLColorToDec($prop["fillColor"], $spot_colors);
            }
        }
        if(isset($prop["strokeColor"])) {
            if(is_array($prop["strokeColor"])) {
                $opt["mk"]["bc"] = $prop["strokeColor"];
            } else {
                $opt["mk"]["bc"] = TCPDF_COLORS::convertHTMLColorToDec($prop["strokeColor"], $spot_colors);
            }
        }
        if(isset($prop["rotation"])) {
            $opt["mk"]["r"] = $prop["rotation"];
        }
        if(isset($prop["charLimit"])) {
            $opt["maxlen"] = intval($prop["charLimit"]);
        }
        if(!isset($ff)) {
            $ff = 0;
        }
        if(isset($prop["readonly"]) && $prop["readonly"] == "true") {
            $ff += 1;
        }
        if(isset($prop["required"]) && $prop["required"] == "true") {
            $ff += 2;
        }
        if(isset($prop["multiline"]) && $prop["multiline"] == "true") {
            $ff += 4096;
        }
        if(isset($prop["password"]) && $prop["password"] == "true") {
            $ff += 8192;
        }
        if(isset($prop["NoToggleToOff"]) && $prop["NoToggleToOff"] == "true") {
            $ff += 16384;
        }
        if(isset($prop["Radio"]) && $prop["Radio"] == "true") {
            $ff += 32768;
        }
        if(isset($prop["Pushbutton"]) && $prop["Pushbutton"] == "true") {
            $ff += 65536;
        }
        if(isset($prop["Combo"]) && $prop["Combo"] == "true") {
            $ff += 131072;
        }
        if(isset($prop["editable"]) && $prop["editable"] == "true") {
            $ff += 262144;
        }
        if(isset($prop["Sort"]) && $prop["Sort"] == "true") {
            $ff += 524288;
        }
        if(isset($prop["fileSelect"]) && $prop["fileSelect"] == "true") {
            $ff += 1048576;
        }
        if(isset($prop["multipleSelection"]) && $prop["multipleSelection"] == "true") {
            $ff += 2097152;
        }
        if(isset($prop["doNotSpellCheck"]) && $prop["doNotSpellCheck"] == "true") {
            $ff += 4194304;
        }
        if(isset($prop["doNotScroll"]) && $prop["doNotScroll"] == "true") {
            $ff += 8388608;
        }
        if(isset($prop["comb"]) && $prop["comb"] == "true") {
            $ff += 16777216;
        }
        if(isset($prop["radiosInUnison"]) && $prop["radiosInUnison"] == "true") {
            $ff += 33554432;
        }
        if(isset($prop["richText"]) && $prop["richText"] == "true") {
            $ff += 33554432;
        }
        if(isset($prop["commitOnSelChange"]) && $prop["commitOnSelChange"] == "true") {
            $ff += 67108864;
        }
        $opt["ff"] = $ff;
        if(isset($prop["defaultValue"])) {
            $opt["dv"] = $prop["defaultValue"];
        }
        $f = 4;
        if(isset($prop["readonly"]) && $prop["readonly"] == "true") {
            $f += 64;
        }
        if(isset($prop["display"])) {
            if($prop["display"] == "display.visible") {
            } elseif($prop["display"] == "display.hidden") {
                $f += 2;
            } elseif($prop["display"] == "display.noPrint") {
                $f -= 4;
            } elseif($prop["display"] == "display.noView") {
                $f += 32;
            }
        }
        $opt["f"] = $f;
        if(isset($prop["currentValueIndices"]) && is_array($prop["currentValueIndices"])) {
            $opt["i"] = $prop["currentValueIndices"];
        }
        if(isset($prop["value"])) {
            if(is_array($prop["value"])) {
                $opt["opt"] = [];
                foreach ($prop["value"] as $key => $optval) {
                    if(isset($prop["exportValues"][$key])) {
                        $opt["opt"][$key] = [$prop["exportValues"][$key], $prop["value"][$key]];
                    } else {
                        $opt["opt"][$key] = $prop["value"][$key];
                    }
                }
            } else {
                $opt["v"] = $prop["value"];
            }
        }
        if(isset($prop["richValue"])) {
            $opt["rv"] = $prop["richValue"];
        }
        if(isset($prop["submitName"])) {
            $opt["tm"] = $prop["submitName"];
        }
        if(isset($prop["name"])) {
            $opt["t"] = $prop["name"];
        }
        if(isset($prop["userName"])) {
            $opt["tu"] = $prop["userName"];
        }
        if(isset($prop["highlight"])) {
            switch ($prop["highlight"]) {
                case "none":
                case "highlight.n":
                    $opt["h"] = "N";
                    break;
                case "invert":
                case "highlight.i":
                    $opt["h"] = "i";
                    break;
                case "push":
                case "highlight.p":
                    $opt["h"] = "P";
                    break;
                case "outline":
                case "highlight.o":
                    $opt["h"] = "O";
                    break;
            }
        }
        return $opt;
    }
    public static function formatPageNumber($num)
    {
        return number_format((double) $num, 0, "", ".");
    }
    public static function formatTOCPageNumber($num)
    {
        return number_format((double) $num, 0, "", ".");
    }
    public static function extractCSSproperties($cssdata)
    {
        if(empty($cssdata)) {
            return [];
        }
        $cssdata = preg_replace("/\\/\\*[^\\*]*\\*\\//", "", $cssdata);
        $cssdata = preg_replace("/[\\s]+/", " ", $cssdata);
        $cssdata = preg_replace("/[\\s]*([;:\\{\\}]{1})[\\s]*/", "\\1", $cssdata);
        $cssdata = preg_replace("/([^\\}\\{]+)\\{\\}/", "", $cssdata);
        $cssdata = preg_replace("/@media[\\s]+([^\\{]*)\\{/i", "@media \\1§", $cssdata);
        $cssdata = preg_replace("/\\}\\}/si", "}§", $cssdata);
        $cssdata = trim($cssdata);
        $cssblocks = [];
        $matches = [];
        if(0 < preg_match_all("/@media[\\s]+([^\\§]*)§([^§]*)§/i", $cssdata, $matches)) {
            foreach ($matches[1] as $key => $type) {
                $cssblocks[$type] = $matches[2][$key];
            }
            $cssdata = preg_replace("/@media[\\s]+([^\\§]*)§([^§]*)§/i", "", $cssdata);
        }
        if(isset($cssblocks["all"]) && !empty($cssblocks["all"])) {
            $cssdata .= $cssblocks["all"];
        }
        if(isset($cssblocks["print"]) && !empty($cssblocks["print"])) {
            $cssdata .= $cssblocks["print"];
        }
        $cssblocks = [];
        $matches = [];
        if(substr($cssdata, -1) == "}") {
            $cssdata = substr($cssdata, 0, -1);
        }
        $matches = explode("}", $cssdata);
        foreach ($matches as $key => $block) {
            $cssblocks[$key] = explode("{", $block);
            if(!isset($cssblocks[$key][1])) {
                unset($cssblocks[$key]);
            }
        }
        foreach ($cssblocks as $key => $block) {
            if(0 < strpos($block[0], ",")) {
                $selectors = explode(",", $block[0]);
                foreach ($selectors as $sel) {
                    $cssblocks[] = [trim($sel), $block[1]];
                }
                unset($cssblocks[$key]);
            }
        }
        $cssdata = [];
        foreach ($cssblocks as $block) {
            $selector = $block[0];
            $matches = [];
            $a = 0;
            $b = intval(preg_match_all("/[\\#]/", $selector, $matches));
            $c = intval(preg_match_all("/[\\[\\.]/", $selector, $matches));
            $c += intval(preg_match_all("/[\\:]link|visited|hover|active|focus|target|lang|enabled|disabled|checked|indeterminate|root|nth|first|last|only|empty|contains|not/i", $selector, $matches));
            $d = intval(preg_match_all("/[\\>\\+\\~\\s]{1}[a-zA-Z0-9]+/", " " . $selector, $matches));
            $d += intval(preg_match_all("/[\\:][\\:]/", $selector, $matches));
            $specificity = $a . $b . $c . $d;
            $cssdata[$specificity . " " . $selector] = $block[1];
        }
        ksort($cssdata, SORT_STRING);
        return $cssdata;
    }
    public static function fixHTMLCode($html, $default_css, $tagvs, $tidy_options, &$tagvspaces)
    {
        if(TCPDF_STATIC::empty_string($tidy_options)) {
            $tidy_options = ["clean" => 1, "drop-empty-paras" => 0, "drop-proprietary-attributes" => 1, "fix-backslash" => 1, "hide-comments" => 1, "join-styles" => 1, "lower-literals" => 1, "merge-divs" => 1, "merge-spans" => 1, "output-xhtml" => 1, "word-2000" => 1, "wrap" => 0, "output-bom" => 0];
        }
        $tidy = tidy_parse_string($html, $tidy_options);
        $tidy->cleanRepair();
        $tidy_head = tidy_get_head($tidy);
        $css = $tidy_head->value;
        $css = preg_replace("/<style([^>]+)>/ims", "<style>", $css);
        $css = preg_replace("/<\\/style>(.*)<style>/ims", "\n", $css);
        $css = str_replace("/*<![CDATA[*/", "", $css);
        $css = str_replace("/*]]>*/", "", $css);
        preg_match("/<style>(.*)<\\/style>/ims", $css, $matches);
        if(isset($matches[1])) {
            $css = strtolower($matches[1]);
        } else {
            $css = "";
        }
        $css = "<style>" . $default_css . $css . "</style>";
        $tidy_body = tidy_get_body($tidy);
        $html = $tidy_body->value;
        $html = str_replace("<br>", "<br />", $html);
        $html = preg_replace("/<div([^\\>]*)><\\/div>/", "", $html);
        $html = preg_replace("/<p([^\\>]*)><\\/p>/", "", $html);
        if(!TCPDF_STATIC::empty_string($tagvs)) {
            $tagvspaces = $tagvs;
        }
        return $css . $html;
    }
    public static function isValidCSSSelectorForTag($dom, $key, $selector)
    {
        $valid = false;
        $tag = $dom[$key]["value"];
        $class = [];
        if(isset($dom[$key]["attribute"]["class"]) && !empty($dom[$key]["attribute"]["class"])) {
            $class = explode(" ", strtolower($dom[$key]["attribute"]["class"]));
        }
        $id = "";
        if(isset($dom[$key]["attribute"]["id"]) && !empty($dom[$key]["attribute"]["id"])) {
            $id = strtolower($dom[$key]["attribute"]["id"]);
        }
        $selector = preg_replace("/([\\>\\+\\~\\s]{1})([\\.]{1})([^\\>\\+\\~\\s]*)/si", "\\1*.\\3", $selector);
        $matches = [];
        if(0 < preg_match_all("/([\\>\\+\\~\\s]{1})([a-zA-Z0-9\\*]+)([^\\>\\+\\~\\s]*)/si", $selector, $matches, PREG_PATTERN_ORDER | PREG_OFFSET_CAPTURE)) {
            $parentop = array_pop($matches[1]);
            list($operator, $offset) = $parentop;
            $lasttag = array_pop($matches[2]);
            $lasttag = strtolower(trim($lasttag[0]));
            if($lasttag == "*" || $lasttag == $tag) {
                $attrib = array_pop($matches[3]);
                $attrib = strtolower(trim($attrib[0]));
                if(!empty($attrib)) {
                    switch ($attrib[0]) {
                        case ".":
                            if(in_array(substr($attrib, 1), $class)) {
                                $valid = true;
                            }
                            break;
                        case "#":
                            if(substr($attrib, 1) == $id) {
                                $valid = true;
                            }
                            break;
                        case "[":
                            $attrmatch = [];
                            if(0 < preg_match("/\\[([a-zA-Z0-9]*)[\\s]*([\\~\\^\\\$\\*\\|\\=]*)[\\s]*[\"]?([^\"\\]]*)[\"]?\\]/i", $attrib, $attrmatch)) {
                                $att = strtolower($attrmatch[1]);
                                $val = $attrmatch[3];
                                if(isset($dom[$key]["attribute"][$att])) {
                                    switch ($attrmatch[2]) {
                                        case "=":
                                            if($dom[$key]["attribute"][$att] == $val) {
                                                $valid = true;
                                            }
                                            break;
                                        case "~=":
                                            if(in_array($val, explode(" ", $dom[$key]["attribute"][$att]))) {
                                                $valid = true;
                                            }
                                            break;
                                        case "^=":
                                            if($val == substr($dom[$key]["attribute"][$att], 0, strlen($val))) {
                                                $valid = true;
                                            }
                                            break;
                                        case "\$=":
                                            if($val == substr($dom[$key]["attribute"][$att], -1 * strlen($val))) {
                                                $valid = true;
                                            }
                                            break;
                                        case "*=":
                                            if(strpos($dom[$key]["attribute"][$att], $val) !== false) {
                                                $valid = true;
                                            }
                                            break;
                                        case "|=":
                                            if($dom[$key]["attribute"][$att] == $val) {
                                                $valid = true;
                                            } elseif(0 < preg_match("/" . $val . "[\\-]{1}/i", $dom[$key]["attribute"][$att])) {
                                                $valid = true;
                                            }
                                            break;
                                        default:
                                            $valid = true;
                                    }
                                }
                            }
                            break;
                        case ":":
                            if($attrib[1] == ":") {
                            }
                            break;
                    }
                } else {
                    $valid = true;
                }
                if($valid && 0 < $offset) {
                    $valid = false;
                    $selector = substr($selector, 0, $offset);
                    switch ($operator) {
                        case " ":
                            while (0 < $dom[$key]["parent"]) {
                                if(self::isValidCSSSelectorForTag($dom, $dom[$key]["parent"], $selector)) {
                                    $valid = true;
                                    break;
                                }
                                $key = $dom[$key]["parent"];
                            }
                            break;
                        case ">":
                            $valid = self::isValidCSSSelectorForTag($dom, $dom[$key]["parent"], $selector);
                            break;
                        case "+":
                            $i = $key - 1;
                            while ($dom[$key]["parent"] < $i) {
                                if($dom[$i]["tag"] && $dom[$i]["opening"]) {
                                    $valid = self::isValidCSSSelectorForTag($dom, $i, $selector);
                                    break;
                                }
                                --$i;
                            }
                            break;
                        case "~":
                            $i = $key - 1;
                            while ($dom[$key]["parent"] < $i) {
                                if($dom[$i]["tag"] && $dom[$i]["opening"] && self::isValidCSSSelectorForTag($dom, $i, $selector)) {
                                    break;
                                }
                                --$i;
                            }
                            break;
                    }
                }
            }
        }
        return $valid;
    }
    public static function getCSSdataArray($dom, $key, $css)
    {
        $cssarray = [];
        $selectors = [];
        if(isset($dom[$dom[$key]["parent"]]["csssel"])) {
            $selectors = $dom[$dom[$key]["parent"]]["csssel"];
        }
        foreach ($css as $selector => $style) {
            $pos = strpos($selector, " ");
            $specificity = substr($selector, 0, $pos);
            $selector = substr($selector, $pos);
            if(self::isValidCSSSelectorForTag($dom, $key, $selector) && !in_array($selector, $selectors)) {
                $cssarray[] = ["k" => $selector, "s" => $specificity, "c" => $style];
                $selectors[] = $selector;
            }
        }
        if(isset($dom[$key]["attribute"]["style"])) {
            $cssarray[] = ["k" => "", "s" => "1000", "c" => $dom[$key]["attribute"]["style"]];
        }
        $cssordered = [];
        foreach ($cssarray as $key => $val) {
            $skey = sprintf("%04d", $key);
            $cssordered[$val["s"] . "_" . $skey] = $val;
        }
        ksort($cssordered, SORT_STRING);
        return [$selectors, $cssordered];
    }
    public static function getTagStyleFromCSSarray($css)
    {
        $tagstyle = "";
        foreach ($css as $style) {
            $csscmds = explode(";", $style["c"]);
            foreach ($csscmds as $cmd) {
                if(!empty($cmd)) {
                    $pos = strpos($cmd, ":");
                    if($pos !== false) {
                        $cmd = substr($cmd, 0, $pos + 1);
                        if(strpos($tagstyle, $cmd) !== false) {
                            $tagstyle = preg_replace("/" . $cmd . "[^;]+/i", "", $tagstyle);
                        }
                    }
                }
            }
            $tagstyle .= ";" . $style["c"];
        }
        $tagstyle = preg_replace("/[;]+/", ";", $tagstyle);
        return $tagstyle;
    }
    public static function intToRoman($number)
    {
        $roman = "";
        if(4000 <= $number) {
            return strval($number);
        }
        while (1000 <= $number) {
            $roman .= "M";
            $number -= 1000;
        }
        while (900 <= $number) {
            $roman .= "CM";
            $number -= 900;
        }
        while (500 <= $number) {
            $roman .= "D";
            $number -= 500;
        }
        while (400 <= $number) {
            $roman .= "CD";
            $number -= 400;
        }
        while (100 <= $number) {
            $roman .= "C";
            $number -= 100;
        }
        while (90 <= $number) {
            $roman .= "XC";
            $number -= 90;
        }
        while (50 <= $number) {
            $roman .= "L";
            $number -= 50;
        }
        while (40 <= $number) {
            $roman .= "XL";
            $number -= 40;
        }
        while (10 <= $number) {
            $roman .= "X";
            $number -= 10;
        }
        while (9 <= $number) {
            $roman .= "IX";
            $number -= 9;
        }
        while (5 <= $number) {
            $roman .= "V";
            $number -= 5;
        }
        while (4 <= $number) {
            $roman .= "IV";
            $number -= 4;
        }
        while (1 <= $number) {
            $roman .= "I";
            --$number;
        }
        return $roman;
    }
    public static function revstrpos($haystack, $needle, $offset = 0)
    {
        $length = strlen($haystack);
        $offset = 0 < $offset ? $length - $offset : abs($offset);
        $pos = strpos(strrev($haystack), strrev($needle), $offset);
        return $pos === false ? false : $length - $pos - strlen($needle);
    }
    public static function getHyphenPatternsFromTEX($file)
    {
        $data = file_get_contents($file);
        $patterns = [];
        $data = preg_replace("/\\%[^\\n]*/", "", $data);
        preg_match("/\\\\patterns\\{([^\\}]*)\\}/i", $data, $matches);
        $data = trim(substr($matches[0], 10, -1));
        $patterns_array = preg_split("/[\\s]+/", $data);
        $patterns = [];
        foreach ($patterns_array as $val) {
            if(!TCPDF_STATIC::empty_string($val)) {
                $val = trim($val);
                $val = str_replace("'", "\\'", $val);
                $key = preg_replace("/[0-9]+/", "", $val);
                $patterns[$key] = $val;
            }
        }
        return $patterns;
    }
    public static function getPathPaintOperator($style, $default = "S")
    {
        $op = "";
        switch ($style) {
            case "S":
            case "D":
                $op = "S";
                break;
            case "s":
            case "d":
                $op = "s";
                break;
            case "f":
            case "F":
                $op = "f";
                break;
            case "f*":
            case "F*":
                $op = "f*";
                break;
            case "B":
            case "FD":
            case "DF":
                $op = "B";
                break;
            case "B*":
            case "F*D":
            case "DF*":
                $op = "B*";
                break;
            case "b":
            case "fd":
            case "df":
                $op = "b";
                break;
            case "b*":
            case "f*d":
            case "df*":
                $op = "b*";
                break;
            case "CNZ":
                $op = "W n";
                break;
            case "CEO":
                $op = "W* n";
                break;
            case "n":
                $op = "n";
                break;
            default:
                if(!empty($default)) {
                    $op = self::getPathPaintOperator($default, "");
                } else {
                    $op = "";
                }
                return $op;
        }
    }
    public static function getTransformationMatrixProduct($ta, $tb)
    {
        $tm = [];
        $tm[0] = $ta[0] * $tb[0] + $ta[2] * $tb[1];
        $tm[1] = $ta[1] * $tb[0] + $ta[3] * $tb[1];
        $tm[2] = $ta[0] * $tb[2] + $ta[2] * $tb[3];
        $tm[3] = $ta[1] * $tb[2] + $ta[3] * $tb[3];
        $tm[4] = $ta[0] * $tb[4] + $ta[2] * $tb[5] + $ta[4];
        $tm[5] = $ta[1] * $tb[4] + $ta[3] * $tb[5] + $ta[5];
        return $tm;
    }
    public static function getSVGTransformMatrix($attribute)
    {
        $tm = [1, 0, 0, 1, 0, 0];
        $transform = [];
        if(0 < preg_match_all("/(matrix|translate|scale|rotate|skewX|skewY)[\\s]*\\(([^\\)]+)\\)/si", $attribute, $transform, PREG_SET_ORDER)) {
            foreach ($transform as $key => $data) {
                if(!empty($data[2])) {
                    $a = 1;
                    $b = 0;
                    $c = 0;
                    $d = 1;
                    $e = 0;
                    $f = 0;
                    $regs = [];
                    switch ($data[1]) {
                        case "matrix":
                            if(preg_match("/([a-z0-9\\-\\.]+)[\\,\\s]+([a-z0-9\\-\\.]+)[\\,\\s]+([a-z0-9\\-\\.]+)[\\,\\s]+([a-z0-9\\-\\.]+)[\\,\\s]+([a-z0-9\\-\\.]+)[\\,\\s]+([a-z0-9\\-\\.]+)/si", $data[2], $regs)) {
                                list($a, $b, $c, $d, $e, $f) = $regs;
                            }
                            break;
                        case "translate":
                            if(preg_match("/([a-z0-9\\-\\.]+)[\\,\\s]+([a-z0-9\\-\\.]+)/si", $data[2], $regs)) {
                                list($e, $f) = $regs;
                            } elseif(preg_match("/([a-z0-9\\-\\.]+)/si", $data[2], $regs)) {
                                $e = $regs[1];
                            }
                            break;
                        case "scale":
                            if(preg_match("/([a-z0-9\\-\\.]+)[\\,\\s]+([a-z0-9\\-\\.]+)/si", $data[2], $regs)) {
                                list($a, $d) = $regs;
                            } elseif(preg_match("/([a-z0-9\\-\\.]+)/si", $data[2], $regs)) {
                                $a = $regs[1];
                                $d = $a;
                            }
                            break;
                        case "rotate":
                            if(preg_match("/([0-9\\-\\.]+)[\\,\\s]+([a-z0-9\\-\\.]+)[\\,\\s]+([a-z0-9\\-\\.]+)/si", $data[2], $regs)) {
                                $ang = deg2rad($regs[1]);
                                list($x, $y) = $regs;
                                $a = cos($ang);
                                $b = sin($ang);
                                $c = -1 * $b;
                                $d = $a;
                                $e = $x * (1 - $a) - $y * $c;
                                $f = $y * (1 - $d) - $x * $b;
                            } elseif(preg_match("/([0-9\\-\\.]+)/si", $data[2], $regs)) {
                                $ang = deg2rad($regs[1]);
                                $a = cos($ang);
                                $b = sin($ang);
                                $c = -1 * $b;
                                $d = $a;
                                $e = 0;
                                $f = 0;
                            }
                            break;
                        case "skewX":
                            if(preg_match("/([0-9\\-\\.]+)/si", $data[2], $regs)) {
                                $c = tan(deg2rad($regs[1]));
                            }
                            break;
                        case "skewY":
                            if(preg_match("/([0-9\\-\\.]+)/si", $data[2], $regs)) {
                                $b = tan(deg2rad($regs[1]));
                            }
                            break;
                        default:
                            $tm = self::getTransformationMatrixProduct($tm, [$a, $b, $c, $d, $e, $f]);
                    }
                }
            }
        }
        return $tm;
    }
    public static function getVectorsAngle($x1, $y1, $x2, $y2)
    {
        $dprod = $x1 * $x2 + $y1 * $y2;
        $dist1 = sqrt($x1 * $x1 + $y1 * $y1);
        $dist2 = sqrt($x2 * $x2 + $y2 * $y2);
        $angle = acos($dprod / ($dist1 * $dist2));
        if(is_nan($angle)) {
            $angle = M_PI;
        }
        if($x1 * $y2 - $x2 * $y1 < 0) {
            $angle *= -1;
        }
        return $angle;
    }
    public static function pregSplit($pattern, $modifiers, $subject, $limit = NULL, $flags = NULL)
    {
        $limit = $limit === NULL ? -1 : $limit;
        $flags = $flags === NULL ? 0 : $flags;
        if(strpos($modifiers, "u") === false || count(preg_split("//u", "\n\t", -1, PREG_SPLIT_NO_EMPTY)) == 2) {
            return preg_split($pattern . $modifiers, $subject, $limit, $flags);
        }
        $ret = [];
        while (($nl = strpos($subject, "\n")) !== false) {
            $ret = array_merge($ret, preg_split($pattern . $modifiers, substr($subject, 0, $nl), $limit, $flags));
            $ret[] = "\n";
            $subject = substr($subject, $nl + 1);
        }
        if(0 < strlen($subject)) {
            $ret = array_merge($ret, preg_split($pattern . $modifiers, $subject, $limit, $flags));
        }
        return $ret;
    }
    public static function fopenLocal($filename, $mode)
    {
        if(strpos($filename, "://") === false) {
            $filename = "file://" . $filename;
        } elseif(stream_is_local($filename) !== true) {
            return false;
        }
        return fopen($filename, $mode);
    }
    public static function url_exists($url)
    {
        $crs = curl_init();
        $url = self::encodeUrlQuery($url);
        curl_setopt($crs, CURLOPT_URL, $url);
        curl_setopt($crs, CURLOPT_NOBODY, true);
        curl_setopt($crs, CURLOPT_FAILONERROR, true);
        if(ini_get("open_basedir") == "" && !ini_get("safe_mode")) {
            curl_setopt($crs, CURLOPT_FOLLOWLOCATION, true);
        }
        curl_setopt($crs, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($crs, CURLOPT_TIMEOUT, 30);
        curl_setopt($crs, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($crs, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($crs, CURLOPT_USERAGENT, "tc-lib-file");
        curl_setopt($crs, CURLOPT_MAXREDIRS, 5);
        if(defined("CURLOPT_PROTOCOLS")) {
            curl_setopt($crs, CURLOPT_PROTOCOLS, CURLPROTO_HTTPS | CURLPROTO_HTTP | CURLPROTO_FTP | CURLPROTO_FTPS);
        }
        curl_exec($crs);
        $code = curl_getinfo($crs, CURLINFO_HTTP_CODE);
        curl_close($crs);
        return $code == 200;
    }
    public static function encodeUrlQuery($url)
    {
        $urlData = parse_url($url);
        if(isset($urlData["query"]) && $urlData["query"]) {
            $urlQueryData = [];
            parse_str(urldecode($urlData["query"]), $urlQueryData);
            $port = isset($urlData["port"]) ? ":" . $urlData["port"] : "";
            $updatedUrl = $urlData["scheme"] . "://" . $urlData["host"] . $port . $urlData["path"] . "?" . http_build_query($urlQueryData);
        } else {
            $updatedUrl = $url;
        }
        return $updatedUrl;
    }
    public static function file_exists($filename)
    {
        if(preg_match("|^https?://|", $filename) == 1) {
            return self::url_exists($filename);
        }
        if(strpos($filename, "://")) {
            return false;
        }
        return @file_exists($filename);
    }
    public static function fileGetContents($file)
    {
        $alt = [$file];
        if(1 < strlen($file) && $file[0] === "/" && $file[1] !== "/" && !empty($_SERVER["DOCUMENT_ROOT"]) && $_SERVER["DOCUMENT_ROOT"] !== "/") {
            $findroot = strpos($file, $_SERVER["DOCUMENT_ROOT"]);
            if($findroot === false || 1 < $findroot) {
                $alt[] = htmlspecialchars_decode(urldecode($_SERVER["DOCUMENT_ROOT"] . $file));
            }
        }
        $protocol = "http";
        if(!empty($_SERVER["HTTPS"]) && strtolower($_SERVER["HTTPS"]) != "off") {
            $protocol .= "s";
        }
        $url = $file;
        if(preg_match("%^//%", $url) && !empty($_SERVER["HTTP_HOST"])) {
            $url = $protocol . ":" . str_replace(" ", "%20", $url);
        }
        $url = htmlspecialchars_decode($url);
        $alt[] = $url;
        if(preg_match("%^(https?)://%", $url) && empty($_SERVER["HTTP_HOST"]) && empty($_SERVER["DOCUMENT_ROOT"])) {
            $urldata = parse_url($url);
            if(empty($urldata["query"])) {
                $host = $protocol . "://" . $_SERVER["HTTP_HOST"];
                if(strpos($url, $host) === 0) {
                    $tmp = str_replace($host, $_SERVER["DOCUMENT_ROOT"], $url);
                    $alt[] = htmlspecialchars_decode(urldecode($tmp));
                }
            }
        }
        if(isset($_SERVER["SCRIPT_URI"]) && !preg_match("%^(https?|ftp)://%", $file) && !preg_match("%^//%", $file)) {
            $urldata = @parse_url($_SERVER["SCRIPT_URI"]);
            $alt[] = $urldata["scheme"] . "://" . $urldata["host"] . ($file[0] == "/" ? "" : "/") . $file;
        }
        $alt = array_unique($alt);
        foreach ($alt as $path) {
            if(!self::file_exists($path)) {
            } else {
                $ret = @file_get_contents($path);
                if($ret) {
                    return $ret;
                }
                if(!ini_get("allow_url_fopen") && function_exists("curl_init") && preg_match("%^(https?|ftp)://%", $path)) {
                    $crs = curl_init();
                    curl_setopt($crs, CURLOPT_URL, $path);
                    curl_setopt($crs, CURLOPT_BINARYTRANSFER, true);
                    curl_setopt($crs, CURLOPT_FAILONERROR, true);
                    curl_setopt($crs, CURLOPT_RETURNTRANSFER, true);
                    if(ini_get("open_basedir") == "" && !ini_get("safe_mode")) {
                        curl_setopt($crs, CURLOPT_FOLLOWLOCATION, true);
                    }
                    curl_setopt($crs, CURLOPT_CONNECTTIMEOUT, 5);
                    curl_setopt($crs, CURLOPT_TIMEOUT, 30);
                    curl_setopt($crs, CURLOPT_SSL_VERIFYPEER, false);
                    curl_setopt($crs, CURLOPT_SSL_VERIFYHOST, false);
                    curl_setopt($crs, CURLOPT_USERAGENT, "tc-lib-file");
                    curl_setopt($crs, CURLOPT_MAXREDIRS, 5);
                    if(defined("CURLOPT_PROTOCOLS")) {
                        curl_setopt($crs, CURLOPT_PROTOCOLS, CURLPROTO_HTTPS | CURLPROTO_HTTP | CURLPROTO_FTP | CURLPROTO_FTPS);
                    }
                    $ret = curl_exec($crs);
                    curl_close($crs);
                    if($ret !== false) {
                        return $ret;
                    }
                }
            }
        }
        return false;
    }
    public static function _getULONG($str, $offset)
    {
        $v = unpack("Ni", substr($str, $offset, 4));
        return $v["i"];
    }
    public static function _getUSHORT($str, $offset)
    {
        $v = unpack("ni", substr($str, $offset, 2));
        return $v["i"];
    }
    public static function _getSHORT($str, $offset)
    {
        $v = unpack("si", substr($str, $offset, 2));
        return $v["i"];
    }
    public static function _getFWORD($str, $offset)
    {
        $v = self::_getUSHORT($str, $offset);
        if(32767 < $v) {
            $v -= 65536;
        }
        return $v;
    }
    public static function _getUFWORD($str, $offset)
    {
        $v = self::_getUSHORT($str, $offset);
        return $v;
    }
    public static function _getFIXED($str, $offset)
    {
        $m = self::_getFWORD($str, $offset);
        $f = self::_getUSHORT($str, $offset + 2);
        $v = floatval("" . $m . "." . $f . "");
        return $v;
    }
    public static function _getBYTE($str, $offset)
    {
        $v = unpack("Ci", substr($str, $offset, 1));
        return $v["i"];
    }
    public static function rfread($handle, $length)
    {
        $data = fread($handle, $length);
        if($data === false) {
            return false;
        }
        $rest = $length - strlen($data);
        if(0 < $rest && !feof($handle)) {
            $data .= self::rfread($handle, $rest);
        }
        return $data;
    }
    public static function _freadint($f)
    {
        $a = unpack("Ni", fread($f, 4));
        return $a["i"];
    }
    public static function getPageSizeFromFormat($format)
    {
        if(isset(self::$page_formats[$format])) {
            return self::$page_formats[$format];
        }
        return self::$page_formats["A4"];
    }
    public static function setPageBoxes($page, $type, $llx, $lly, $urx, $ury, $points, $k, $pagedim = [])
    {
        if(!isset($pagedim[$page])) {
            $pagedim[$page] = [];
        }
        if(!in_array($type, self::$pageboxes)) {
            return NULL;
        }
        if($points) {
            $k = 1;
        }
        $pagedim[$page][$type]["llx"] = $llx * $k;
        $pagedim[$page][$type]["lly"] = $lly * $k;
        $pagedim[$page][$type]["urx"] = $urx * $k;
        $pagedim[$page][$type]["ury"] = $ury * $k;
        return $pagedim;
    }
    public static function swapPageBoxCoordinates($page, $pagedim)
    {
        foreach (self::$pageboxes as $type) {
            if(isset($pagedim[$page][$type])) {
                $tmp = $pagedim[$page][$type]["llx"];
                $pagedim[$page][$type]["llx"] = $pagedim[$page][$type]["lly"];
                $pagedim[$page][$type]["lly"] = $tmp;
                $tmp = $pagedim[$page][$type]["urx"];
                $pagedim[$page][$type]["urx"] = $pagedim[$page][$type]["ury"];
                $pagedim[$page][$type]["ury"] = $tmp;
            }
        }
        return $pagedim;
    }
    public static function getPageLayoutMode($layout = "SinglePage")
    {
        switch ($layout) {
            case "default":
            case "single":
            case "SinglePage":
                $layout_mode = "SinglePage";
                break;
            case "continuous":
            case "OneColumn":
                $layout_mode = "OneColumn";
                break;
            case "two":
            case "TwoColumnLeft":
                $layout_mode = "TwoColumnLeft";
                break;
            case "TwoColumnRight":
                $layout_mode = "TwoColumnRight";
                break;
            case "TwoPageLeft":
                $layout_mode = "TwoPageLeft";
                break;
            case "TwoPageRight":
                $layout_mode = "TwoPageRight";
                break;
            default:
                $layout_mode = "SinglePage";
                return $layout_mode;
        }
    }
    public static function getPageMode($mode = "UseNone")
    {
        switch ($mode) {
            case "UseNone":
                $page_mode = "UseNone";
                break;
            case "UseOutlines":
                $page_mode = "UseOutlines";
                break;
            case "UseThumbs":
                $page_mode = "UseThumbs";
                break;
            case "FullScreen":
                $page_mode = "FullScreen";
                break;
            case "UseOC":
                $page_mode = "UseOC";
                break;
            case "":
                $page_mode = "UseAttachments";
                break;
            default:
                $page_mode = "UseNone";
                return $page_mode;
        }
    }
}

?>