<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
/**
 * @class TCPDF_FILTERS
 * This is a PHP class for decoding common PDF filters (PDF 32000-2008 - 7.4 Filters).<br>
 * @package com.tecnick.tcpdf
 * @brief This is a PHP class for decoding common PDF filters.
 * @version 1.0.001
 * @author Nicola Asuni - info@tecnick.com
 */
class TCPDF_FILTERS
{
    /**
     * Define a list of available filter decoders.
     * @private static
     */
    private static $available_filters = ["ASCIIHexDecode", "ASCII85Decode", "LZWDecode", "FlateDecode", "RunLengthDecode"];
    public static function getAvailableFilters()
    {
        return self::$available_filters;
    }
    public static function decodeFilter($filter, $data)
    {
        switch ($filter) {
            case "ASCIIHexDecode":
                return self::decodeFilterASCIIHexDecode($data);
                break;
            case "ASCII85Decode":
                return self::decodeFilterASCII85Decode($data);
                break;
            case "LZWDecode":
                return self::decodeFilterLZWDecode($data);
                break;
            case "FlateDecode":
                return self::decodeFilterFlateDecode($data);
                break;
            case "RunLengthDecode":
                return self::decodeFilterRunLengthDecode($data);
                break;
            case "CCITTFaxDecode":
                return self::decodeFilterCCITTFaxDecode($data);
                break;
            case "JBIG2Decode":
                return self::decodeFilterJBIG2Decode($data);
                break;
            case "DCTDecode":
                return self::decodeFilterDCTDecode($data);
                break;
            case "JPXDecode":
                return self::decodeFilterJPXDecode($data);
                break;
            case "Crypt":
                return self::decodeFilterCrypt($data);
                break;
            default:
                return self::decodeFilterStandard($data);
        }
    }
    public static function decodeFilterStandard($data)
    {
        return $data;
    }
    public static function decodeFilterASCIIHexDecode($data)
    {
        $decoded = "";
        $data = preg_replace("/[\\s]/", "", $data);
        $eod = strpos($data, ">");
        if($eod !== false) {
            $data = substr($data, 0, $eod);
            $eod = true;
        }
        $data_length = strlen($data);
        if($data_length % 2 != 0) {
            if($eod) {
                $data = substr($data, 0, -1) . "0" . substr($data, -1);
            } else {
                self::Error("decodeFilterASCIIHexDecode: invalid code");
            }
        }
        if(0 < preg_match("/[^a-fA-F\\d]/", $data)) {
            self::Error("decodeFilterASCIIHexDecode: invalid code");
        }
        $decoded = pack("H*", $data);
        return $decoded;
    }
    public static function decodeFilterASCII85Decode($data)
    {
        $decoded = "";
        $data = preg_replace("/[\\s]/", "", $data);
        if(strpos($data, "<~") !== false) {
            $data = substr($data, 2);
        }
        $eod = strpos($data, "~>");
        if($eod !== false) {
            $data = substr($data, 0, $eod);
        }
        $data_length = strlen($data);
        if(0 < preg_match("/[^\\x21-\\x75,\\x74]/", $data)) {
            self::Error("decodeFilterASCII85Decode: invalid code");
        }
        $zseq = chr(0) . chr(0) . chr(0) . chr(0);
        $group_pos = 0;
        $tuple = 0;
        $pow85 = [52200625, 614125, 7225, 85, 1];
        $last_pos = $data_length - 1;
        for ($i = 0; $i < $data_length; $i++) {
            $char = ord($data[$i]);
            if($char == 122) {
                if($group_pos == 0) {
                    $decoded .= $zseq;
                } else {
                    self::Error("decodeFilterASCII85Decode: invalid code");
                }
            } else {
                $tuple += ($char - 33) * $pow85[$group_pos];
                if($group_pos == 4) {
                    $decoded .= chr($tuple >> 24) . chr($tuple >> 16) . chr($tuple >> 8) . chr($tuple);
                    $tuple = 0;
                    $group_pos = 0;
                } else {
                    $group_pos++;
                }
            }
        }
        if(1 < $group_pos) {
            $tuple += $pow85[$group_pos - 1];
        }
        switch ($group_pos) {
            case 4:
                $decoded .= chr($tuple >> 24) . chr($tuple >> 16) . chr($tuple >> 8);
                break;
            case 3:
                $decoded .= chr($tuple >> 24) . chr($tuple >> 16);
                break;
            case 2:
                $decoded .= chr($tuple >> 24);
                break;
            case 1:
                self::Error("decodeFilterASCII85Decode: invalid code");
                break;
            default:
                return $decoded;
        }
    }
    public static function decodeFilterLZWDecode($data)
    {
        $decoded = "";
        $data_length = strlen($data);
        $bitstring = "";
        for ($i = 0; $i < $data_length; $i++) {
            $bitstring .= sprintf("%08b", ord($data[$i]));
        }
        $data_length = strlen($bitstring);
        $bitlen = 9;
        $dix = 258;
        $dictionary = [];
        for ($i = 0; $i < 256; $i++) {
            $dictionary[$i] = chr($i);
        }
        $prev_index = 0;
        while (0 < $data_length && ($index = bindec(substr($bitstring, 0, $bitlen))) != 257) {
            $bitstring = substr($bitstring, $bitlen);
            $data_length -= $bitlen;
            if($index == 256) {
                $bitlen = 9;
                $dix = 258;
                $prev_index = 256;
                $dictionary = [];
                for ($i = 0; $i < 256; $i++) {
                    $dictionary[$i] = chr($i);
                }
            } elseif($prev_index == 256) {
                $decoded .= $dictionary[$index];
                $prev_index = $index;
            } else {
                if($index < $dix) {
                    $decoded .= $dictionary[$index];
                    $dic_val = $dictionary[$prev_index] . $dictionary[$index][0];
                    $prev_index = $index;
                } else {
                    $dic_val = $dictionary[$prev_index] . $dictionary[$prev_index][0];
                    $decoded .= $dic_val;
                }
                $dictionary[$dix] = $dic_val;
                $dix++;
                if($dix == 2047) {
                    $bitlen = 12;
                } elseif($dix == 1023) {
                    $bitlen = 11;
                } elseif($dix == 511) {
                    $bitlen = 10;
                }
            }
        }
        return $decoded;
    }
    public static function decodeFilterFlateDecode($data)
    {
        $decoded = @gzuncompress($data);
        if($decoded === false) {
            self::Error("decodeFilterFlateDecode: invalid code");
        }
        return $decoded;
    }
    public static function decodeFilterRunLengthDecode($data)
    {
        $decoded = "";
        $data_length = strlen($data);
        $i = 0;
        while ($i < $data_length) {
            $byte = ord($data[$i]);
            if($byte == 128) {
                break;
            }
            if($byte < 128) {
                $decoded .= substr($data, $i + 1, $byte + 1);
                $i += $byte + 2;
            } else {
                $decoded .= str_repeat($data[$i + 1], 257 - $byte);
                $i += 2;
            }
        }
        return $decoded;
    }
    public static function decodeFilterCCITTFaxDecode($data)
    {
        self::Error("~decodeFilterCCITTFaxDecode: this method has not been yet implemented");
    }
    public static function decodeFilterJBIG2Decode($data)
    {
        self::Error("~decodeFilterJBIG2Decode: this method has not been yet implemented");
    }
    public static function decodeFilterDCTDecode($data)
    {
        self::Error("~decodeFilterDCTDecode: this method has not been yet implemented");
    }
    public static function decodeFilterJPXDecode($data)
    {
        self::Error("~decodeFilterJPXDecode: this method has not been yet implemented");
    }
    public static function decodeFilterCrypt($data)
    {
        self::Error("~decodeFilterCrypt: this method has not been yet implemented");
    }
    public static function Error($msg)
    {
        throw new Exception("TCPDF_PARSER ERROR: " . $msg);
    }
}

?>