<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function editbackup_plan()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $backup_plan;
    global $backupservers;
    global $done;
    global $cluster;
    global $servers;
    global $bpid;
    global $vpses;
    global $servergroups;
    if(!load_lang("admin/tasks") || !load_lang("admin/editbackup_plan")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/editbackup_plan";
    $theme["init_theme_name"] = "editbackup_plan";
    $theme["init_theme_func"] = ["editbackup_plan_theme"];
    $theme["call_theme_func"] = "editbackup_plan_theme";
    if(!is_allowed("editbackup_plan")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $bpid = (int) optREQ("bpid");
    $backupservers = [];
    $backupservers_pass = [];
    $res = makequery("SELECT * FROM backup_servers");
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $backupservers_pass[$row["bid"]]["password"] = $row["password"];
        $backupservers_pass[$row["bid"]]["salt"] = $row["salt"];
        $tmp_backup_server[$row["bid"]] = $row;
        unset($row["password"]);
        unset($row["salt"]);
        $backupservers[$row["bid"]] = $row;
    }
    $res = makequery("SELECT * FROM backup_plans WHERE bpid = :bpid", [":bpid" => $bpid]);
    if(vsql_num_rows($res) < 1) {
        redirect("act=backup_plans");
    }
    $backup_plan = vsql_fetch_assoc($res);
    $backup_plan["bs_servergroups"] = _unserialize($backup_plan["bs_servergroups"]);
    $backup_plan_data = json_decode($backup_plan["data"], 1);
    $take_full_backup = 0;
    if(isset($_POST["take_full_backup"]) && $backup_plan["frequency"] == "manual" || isset($_POST["backup_now"]) && $backup_plan_data["backup_scheme"] == "always_full" && $backup_plan["frequency"] != "manual") {
        $take_full_backup = 1;
        $_POST["backup_now"] = 1;
    }
    if(isset($_POST["backup_now"])) {
        vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/backupnow_plan.php " . $bpid . " " . $take_full_backup . " " . $backup_plan_data["enable_legacy_backup"] . " > " . logdir() . "backupnow_plan.log 2>&1 &");
        $done = $l["done_backup_now"];
    }
    if(isset($_POST["editbackup_plan"])) {
        $type = POST("type", $l["no_type"]);
        if(!in_array($type, ["FTP", "LOCAL", "SSH"])) {
            $error[] = $l["inv_backup_type"];
        }
        $bid = 0;
        if($type == "FTP" || $type == "SSH") {
            $bid = (int) POST("id", $l["no_backupserver"]);
        }
        $disabled = (int) checkbox("disabled");
        $plan_name = POST("plan_name", $l["no_plan_name"]);
        $freq = optPOST("freq");
        $hourly_freq = $hrs = $min = $day = $date = "";
        if(!empty($freq) && $freq != "manual") {
            $hourly_freq = (int) optPOST("hourly_freq");
            $hrs = (int) optPOST("hrs");
            $min = (int) optPOST("min");
            $day = (int) optPOST("day");
            $date = (int) optPOST("date");
        }
        $rotation = (int) POST("rotation", $l["no_rotation"]);
        $backup_limit = (int) POST("backup_limit", $l["no_backup_limit"]);
        $restore_limit = (int) POST("restore_limit", $l["no_restore_limit"]);
        $enable_enduser_backup_servers = 0;
        $nice = (int) POST("nice", $l["no_nice"]);
        $ionice_prio = (int) POST("ionice_prio", $l["no_ionice_prio"]);
        $ionice_class = (int) POST("ionice_class", $l["no_ionice_class"]);
        $io_limit = (int) optPOST("io_limit");
        $compression = (int) checkbox("compression");
        $dir = POST("dir", $l["no_dir"]);
        $plan_data = [];
        $plan_data["backup_primary"] = (int) optPOST("backup_primary");
        $plan_data["disable_suspended_vm"] = (int) optPOST("disable_suspended_vm");
        $plan_data["enable_legacy_backup"] = (int) optPOST("enable_legacy_backup");
        $plan_data["backup_scheme"] = "always_full";
        $plan_data["backup_scheme"] = POST("backup_scheme", $l["no_backup_scheme"], 0);
        if($freq != "manual") {
            if(in_array($plan_data["backup_scheme"], ["always_full", "always_incremental", "always_differential"])) {
                $plan_data["always_cronjob"] = POST("always_cronjob", $l["no_always_cronjob"]);
            }
            if($plan_data["backup_scheme"] == "weekly_full_daily_incremental") {
                $plan_data["weekly_full_cronjob"] = POST("weekly_full_cronjob", $l["no_weekly_full_cronjob"]);
                $plan_data["weekly_daily_inc_cronjob"] = POST("weekly_daily_inc_cronjob", $l["no_daily_inc_cronjob"]);
            }
            if($plan_data["backup_scheme"] == "monthly_full_weekly_diff_daily_incremental") {
                $plan_data["monthly_full_cronjob"] = POST("monthly_full_cronjob", $l["no_monthly_full_cronjob"]);
                $plan_data["weekly_diff_cronjob"] = POST("weekly_diff_cronjob", $l["no_weekly_diff_cronjob"]);
                $plan_data["weekly_diff_daily_inc_cronjob"] = POST("weekly_diff_daily_inc_cronjob", $l["no_daily_inc_cronjob"]);
            }
            if($plan_data["backup_scheme"] == "custom") {
                $plan_data["custom_full_cronjob"] = POST("custom_full_cronjob", $l["no_custom_full_cronjob"]);
                $plan_data["custom_inc_cronjob"] = POST("custom_inc_cronjob", $l["no_custom_inc_cronjob"]);
                $plan_data["custom_diff_cronjob"] = POST("custom_diff_cronjob", $l["no_custom_diff_cronjob"]);
            }
            foreach ($plan_data as $k => $v) {
                if(in_array($k, ["backup_scheme", "backup_primary", "disable_suspended_vm", "enable_legacy_backup"])) {
                } else {
                    $tmp = explode(" ", $v);
                    if(!cron_validation($tmp[0], 0, 59)) {
                        $error[] = $l["c_err_invalid_minute"];
                    }
                    if(!cron_validation($tmp[1], 0, 23)) {
                        $error[] = $l["c_err_invalid_hour"];
                    }
                    if(!cron_validation($tmp[2], 1, 31)) {
                        $error[] = $l["c_err_invalid_day"];
                    }
                    if(!cron_validation($tmp[3], 1, 12)) {
                        $error[] = $l["c_err_invalid_month"];
                    }
                    if(!cron_validation($tmp[4], 0, 7)) {
                        $error[] = $l["c_err_invalid_weekday"];
                    }
                }
            }
            if(!empty($_POST["selected_cron_type"])) {
                $plan_data["selected_cron_type"] = json_decode($_POST["selected_cron_type"]);
            }
        }
        if($type != "LOCAL" && $type != $backupservers[$bid]["type"]) {
            $error[] = lang_vars($l["ssh_server_error"], [$backupservers[$bid]["type"], $type]);
        }
        $qres = makequery("SELECT plan_name FROM backup_plans \n\t\t\t\t\t\t\tWHERE plan_name = :plan_name\n\t\t\t\t\t\t\tAND bpid != :bpid", [":plan_name" => $plan_name, ":bpid" => $bpid]);
        $row = vsql_num_rows($qres);
        if(0 < $row) {
            $error[] = $l["plannameexist"];
        }
        $dir = trim(cleanpath($dir));
        if(empty($dir) || $dir == "/") {
            $error[] = $l["err_backup_dir"];
            return false;
        }
        $check_dir_permissions = optREQ("check_dir_permissions");
        if(!empty($check_dir_permissions)) {
            $test_dir = generateRandStr(16);
            if($type == "LOCAL") {
                create_local_backup_folders2($dir, 0, $test_dir);
                rmdir($dir . "/" . $test_dir);
            } elseif($type == "SSH") {
                $connection = connect_ssh($tmp_backup_server[$bid]);
                if(!$connection) {
                    $error[] = $l["err_ssh_conn"];
                } else {
                    create_ssh_backup_folders2($connection, $dir, 0, $test_dir);
                    $sftp = ssh2_sftp($connection);
                    ssh2_sftp_rmdir($sftp, $dir . "/" . $test_dir);
                }
            } elseif($type == "FTP") {
                $ftp_con = connect_ftp($tmp_backup_server[$bid]);
                if(!$ftp_con) {
                    $error[] = $l["err_ftp_connect"];
                } else {
                    create_backup_folders2($ftp_con, $dir, 0, $test_dir);
                    ftp_rmdir($ftp_con, $dir . "/" . $test_dir);
                }
            }
            unset($tmp_backup_server);
        }
        if(!empty($freq) && !in_array($freq, ["hourly", "daily", "weekly", "monthly", "manual"])) {
            $error[] = $l["inv_freq"];
        }
        if(!empty($freq) && $freq != "manual") {
            if($hourly_freq < 0 || 23 < $hourly_freq) {
                $error[] = $l["inv_hourly_freq"];
            }
            if($hrs < 0 || 23 < $hrs || $min < 0 || 59 < $min) {
                $error[] = $l["inv_time"];
            }
            if($day < 1 || 7 < $day) {
                $error[] = $l["inv_day"];
            }
            if($date < 1 || 31 < $date) {
                $error[] = $l["inv_date"];
            }
        }
        if($rotation < 0 || 10 < $rotation) {
            $error[] = $l["inv_rotation"];
        }
        if($backup_limit < -1 || 10 < $backup_limit) {
            $error[] = $l["inv_backup_limit"];
        }
        if($restore_limit < -1 || 10 < $restore_limit) {
            $error[] = $l["inv_restore_limit"];
        }
        if($nice < -20 || 19 < $nice) {
            $error[] = $l["inv_nice"];
        }
        if($ionice_prio < 0 || 7 < $ionice_prio) {
            $error[] = $l["inv_ionice_prio"];
        }
        if($ionice_class < 1 || 3 < $ionice_class) {
            $error[] = $l["inv_ionice_class"];
        }
        if($io_limit < 0) {
            $error[] = $l["inv_io_limit"];
        }
        $bs_groups = [];
        $dir_groups = [];
        foreach ($servergroups as $sgid => $servergroup) {
            $dir_sg = optPOST("dir_sg" . $sgid);
            if(!empty($dir_sg)) {
                $dir_groups[$sgid] = $dir_sg;
            }
            $bs = (int) optPOST("bs_sg" . $sgid);
            if(!empty($bs) && $bs != -1 && empty($backupservers[$bs])) {
                $error[] = lang_vars_name($l["inv_bs_group"], ["server_group" => $servergroup["sg_name"]]);
            } else {
                $bs_groups[$sgid] = $bs;
            }
        }
        $bs_servers = [];
        $dir_servers = [];
        foreach ($servers as $serid => $server) {
            $dir_s = optPOST("dir_s" . $serid);
            if(!empty($dir_s)) {
                $dir_servers[$serid] = $dir_s;
            }
            $bs = (int) optPOST("bs_s" . $serid);
            if(!empty($bs) && $bs != -1 && empty($backupservers[$bs])) {
                $error[] = lang_vars_name($l["inv_bs_server"], ["server" => $server["server_name"] . " (" . $server["ip"] . ")"]);
            } else {
                $bs_servers[$serid] = $bs;
            }
        }
        $bs_servergroups = serialize(["bs_groups" => $bs_groups, "bs_servers" => $bs_servers, "dir_groups" => $dir_groups, "dir_servers" => $dir_servers]);
        if(!empty($error)) {
            return false;
        }
        $time = sprintf("%02d", $hrs) . ":" . sprintf("%02d", $min);
        $data_encode = json_encode($plan_data);
        $qres = update_query("UPDATE backup_plans SET\n\t\t\t\t\t\t\tdisabled = :disabled,\n\t\t\t\t\t\t\tplan_name = :plan_name,\n\t\t\t\t\t\t\tbid = :bid,\n\t\t\t\t\t\t\trun_time = :time,\n\t\t\t\t\t\t\tfrequency = :freq,\n\t\t\t\t\t\t\thourly_freq = :hourly_freq,\n\t\t\t\t\t\t\trun_day = :day,\n\t\t\t\t\t\t\trun_date = :date,\n\t\t\t\t\t\t\trotation = :rotation,\n\t\t\t\t\t\t\tbackup_limit = :backup_limit,\n\t\t\t\t\t\t\trestore_limit = :restore_limit,\n\t\t\t\t\t\t\tenable_enduser_backup_servers = :enable_enduser_backup_servers,\n\t\t\t\t\t\t\tnice = :nice,\n\t\t\t\t\t\t\tionice_prio = :ionice_prio,\n\t\t\t\t\t\t\tionice_class = :ionice_class,\n\t\t\t\t\t\t\tdisable_compression = :compression,\n\t\t\t\t\t\t\tdir = :dir,\n\t\t\t\t\t\t\tbs_servergroups = :bs_servergroups,\n\t\t\t\t\t\t\tio_limit = :io_limit,\n\t\t\t\t\t\t\tdata = :data\n\t\t\t\t\t\t\tWHERE bpid = :bpid", [":disabled" => $disabled, ":plan_name" => $plan_name, ":bid" => $bid, ":freq" => $freq, ":time" => $time, ":hourly_freq" => $hourly_freq, ":day" => $day, ":date" => $date, ":rotation" => $rotation, ":backup_limit" => $backup_limit, ":restore_limit" => $restore_limit, ":enable_enduser_backup_servers" => $enable_enduser_backup_servers, ":nice" => $nice, ":ionice_prio" => $ionice_prio, ":ionice_class" => $ionice_class, ":compression" => $compression, ":dir" => $dir, ":bs_servergroups" => $bs_servergroups, ":io_limit" => $io_limit, ":bpid" => $bpid, ":data" => $data_encode]);
        vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/sync_backup_plans.php >> " . logdir() . "sync_backup_plans.log 2>&1 &");
        $error = array_unique($error);
        if(empty($error)) {
            $done = $l["done"];
            logs_admin("editbackup_plan", $plan_name, 1, $bpid, $user["uid"]);
        }
    }
    $res = makequery("SELECT v.vpsid, v.vps_name, v.serid, v.hostname, v.space FROM vps v\n\t\t\t\t\t\tLEFT JOIN plans p ON p.plid = v.plid\n\t\t\t\t\t\tWHERE v.bpid = :bpid\n\t\t\t\t\t\tOR (v.bpid = -1 AND p.bpid = :bpid)", [":bpid" => $bpid]);
    $vpses = [];
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $vpses[$row["vpsid"]] = $row;
    }
}
function API_editbackup_plan()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $backup_plan;
    global $done;
    global $vpses;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = 1;
    }
    $GLOBALS["_api"]["backup_plan"] = $backup_plan;
    $GLOBALS["_api"]["vpses"] = $vpses;
}

?>