<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function addbackupserver()
{
    global $theme;
    global $globals;
    global $kernel;
    global $cluster;
    global $user;
    global $l;
    global $error;
    global $done;
    global $keys;
    if(!load_lang("admin/addbackupserver")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/addbackupserver";
    $theme["init_theme_name"] = "addbackupserver";
    $theme["init_theme_func"] = ["addbackupserver_theme"];
    $theme["call_theme_func"] = "addbackupserver_theme";
    if(!is_allowed("addbackupserver")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    if(isset($_REQUEST["download_public_key"])) {
        if(is_api_call()) {
            return true;
        }
        $pub_key = str_replace("nextline", "\n", $_REQUEST["pubkey"]);
        if(empty($pub_key)) {
            return false;
        }
        download_file("id_rsa.pub", $pub_key);
    }
    if(isset($_REQUEST["download_private_key"])) {
        if(is_api_call()) {
            return true;
        }
        $pri_key = str_replace("nextline", "\n", $_REQUEST["prikey"]);
        if(empty($pri_key)) {
            return false;
        }
        download_file("id_rsa", $pri_key);
    }
    if(empty($_POST["gen_sshpub_key"]) || empty($_POST["gen_sshpri_key"])) {
        $keys = generatekeys();
    }
    if(isset($_POST["addbackupserver"])) {
        $name = POST("name", $l["no_name"]);
        $hostname = POST("hostname", $l["no_hostname"]);
        $type = POST("type", $l["no_type"]);
        $username = POST("username", $l["no_username"]);
        $password = trim($_POST["password"]);
        $port = (int) POST("port", $l["no_port"]);
        $ssh_key = optPOST("ssh_key");
        $sshpub_key = $sshpri_key = "";
        $gen_key = (int) optPOST("gen_key");
        $ftps = (int) optPOST("ftps");
        if(empty($password) && empty($ssh_key) && empty($gen_key)) {
            $error["password"] = $l["no_password"];
        }
        if(!empty($password)) {
            $salt = generateRandStr(8);
            $password = pass_encrypt($password, $salt);
        }
        if(!empty($error)) {
            return false;
        }
        if($type == "SSH" && !extension_loaded("ssh2")) {
            $error[] = $l["extension_not_found"];
            return false;
        }
        if(!empty($gen_key) && empty($sshpub_key) && empty($sshpri_key)) {
            $sshpub_key = trim($_POST["gen_sshpub_key"]);
            $sshpri_key = trim($_POST["gen_sshpri_key"]);
            if(is_api_call() && !empty($keys)) {
                $sshpub_key = trim($keys["public_key"]);
                $sshpri_key = trim($keys["private_key"]);
            }
            $ssh_key = $gen_key;
            $password = "";
        }
        if(!empty($ssh_key)) {
            if(empty($gen_key) && empty($sshpub_key) && empty($sshpri_key)) {
                $sshpub_key = trim($_POST["sshpub_key"]);
                $sshpri_key = trim($_POST["sshpri_key"]);
                $password = "";
            }
            if(empty($sshpub_key) || empty($sshpri_key)) {
                $error[] = $l["no_ssh_key_err"];
                return false;
            }
            if(!is_api_call()) {
                $ranstr = generateRandStr(8);
                $tmpfile_pub = "/tmp/sshkey-" . $ranstr . ".pub";
                file_put_contents($tmpfile_pub, $sshpub_key);
                $tmpfile_pri = "/tmp/sshkey-" . $ranstr;
                file_put_contents($tmpfile_pri, $sshpri_key);
                vexec("ssh-keygen -lf " . xss($tmpfile_pub), $out, $ret);
                if($ret != 0) {
                    unlink($tmpfile_pub);
                    unlink($tmpfile_pri);
                    $error[] = $l["invalid_pub_key"];
                    return false;
                }
                $tmp_conn = ssh2_connect($hostname, $port);
                $auth_key = ssh2_auth_pubkey_file($tmp_conn, $username, $tmpfile_pub, $tmpfile_pri);
                unlink($tmpfile_pub);
                unlink($tmpfile_pri);
                if(!$auth_key) {
                    $error[] = $l["ssh_key_con_err"];
                    return false;
                }
            }
        }
        $qres = makequery("SELECT * FROM backup_servers WHERE name=:name", [":name" => $name]);
        $row = vsql_num_rows($qres);
        if(0 < $row) {
            $error[] = $l["nameexist"];
            return false;
        }
        $bid = insert_and_id("INSERT INTO backup_servers SET\n\t\t\t\t\t\t\tname = :name,\n\t\t\t\t\t\t\thostname = :hostname,\n\t\t\t\t\t\t\ttype = :type,\n\t\t\t\t\t\t\tusername = :username,\n\t\t\t\t\t\t\tpassword = :password,\n\t\t\t\t\t\t\tsalt = :salt,\n\t\t\t\t\t\t\tport = :port,\n\t\t\t\t\t\t\tssh_key = :ssh_key,\n\t\t\t\t\t\t\tsshpub_key = :sshpub_key,\n\t\t\t\t\t\t\tsshpri_key = :sshpri_key,\n\t\t\t\t\t\t\tftps = :ftps", [":name" => $name, ":hostname" => $hostname, ":type" => $type, ":username" => $username, ":password" => $password, ":salt" => $salt, ":port" => $port, ":ssh_key" => $ssh_key, ":sshpub_key" => base64_encode($sshpub_key), ":sshpri_key" => base64_encode($sshpri_key), ":ftps" => $ftps]);
        if(empty($bid)) {
            $error[] = $l["err_add_backupserver"];
            return false;
        }
        vexec($globals["com"]["php"] . " " . $globals["scriptfiles"] . "/sync_config.php 2>&1", $o, $r);
        $done = $bid;
        logs_admin("addbackupserver", $name, 1, $done, $user["uid"]);
    }
}
function API_addbackupserver()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $done;
    global $error;
    global $keys;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($keys)) {
        $GLOBALS["_api"]["keys"] = $keys;
    }
}

?>