<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function rebuild()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $servers;
    global $oslist;
    global $done;
    global $ostemplates;
    global $vpses;
    global $users;
    global $isos;
    global $virt;
    global $hvm;
    global $newvs;
    global $vps;
    global $vnc;
    global $disks;
    global $flag_rebuildvps;
    global $actid;
    global $done_data;
    global $recipes;
    global $webuzo_apps;
    global $scripts;
    global $iscripts;
    global $allowed_scripts;
    global $webuzo_templates;
    set_time_limit(500);
    if(!load_lang("admin/rebuild")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/rebuild";
    $theme["init_theme_name"] = "Rebuild Virtual Server";
    $theme["init_theme_func"] = ["rebuild_theme"];
    $theme["call_theme_func"] = "rebuild_theme";
    if(!is_allowed("rebuildvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    load_scripts();
    update_webuzoapps();
    $webuzo_apps = load_webuzoapps();
    $iscripts_allowed = get_web_scripts();
    foreach ($iscripts_allowed as $k => $v) {
        if(!array_key_exists($v, $iscripts)) {
            unset($iscripts_allowed[$k]);
        } else {
            $allowed_scripts[$l["cat_php_" . $scripts[$v]["category"]]][$v]["name"] = $scripts[$v]["name"];
            $allowed_scripts[$l["cat_php_" . $scripts[$v]["category"]]][$v]["softname"] = $scripts[$v]["softname"];
        }
    }
    $virt = server_primary_virt($globals["server"]);
    $webuzo_templates = webuzo_os($virt);
    $webuzo_done["allowed_scripts"] = $allowed_scripts;
    $webuzo_done["webuzo_apps"] = $webuzo_apps;
    if(empty($globals["noc_apikey"]) && empty($globals["noc_apipass"])) {
        $webuzo_done["isfree"] = 1;
    }
    $webuzoscriptid = (int) optGET("scriptreqid");
    if(!empty($webuzoscriptid)) {
        if(!array_key_exists($webuzoscriptid, $scripts)) {
            $error[] = $l["webuzo_script_err"];
            return NULL;
        }
        $stack = [];
        $stack = load_free_webapps();
        $req = get_script_req($webuzoscriptid);
        if(empty($req)) {
            $webuzo_apps = $stack;
        } else {
            foreach ($req as $key => $val) {
                if($val["type"] === "version") {
                    foreach ($webuzo_apps[$val["check"]] as $appkey => $appval) {
                        if(!version_compare($appval["version"], $val["version"], $val["operator"])) {
                            unset($webuzo_apps[$val["check"]][$appkey]);
                        }
                    }
                }
            }
            if(empty($webuzo_apps["php"])) {
                $error[] = $l["webuzo_support_err"];
                $support_err = 1;
            }
        }
        $webuzo_done["webuzo_apps"] = $webuzo_apps;
        return NULL;
    }
    if(optREQ("error") || optREQ("done")) {
        $actid = (int) optREQ("actid");
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\t  WHERE actid = :actid\n\t\t\t\t\t\t  AND action = 'rebuildvs'", [":actid" => $actid]);
        if(0 < vsql_num_rows($res)) {
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $tasks[$row["actid"]] = $row;
            }
        }
        if(!empty($tasks)) {
            foreach ($tasks as $k => $v) {
                if(optREQ("error")) {
                    $error[] = $v["status_txt"];
                }
                if(optREQ("done")) {
                    $done_data = unserialize($v["data"]);
                }
            }
        }
        if($globals["server"] != 0 && is_master()) {
            $ret = $cluster->reverse_sync($globals["server"]);
        }
        return true;
    } else {
        oslist();
        sort_media("ostemplates", "name");
        $res = makequery("SELECT rid, name FROM recipes WHERE status <> 0 ORDER BY rid ASC");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $recipes[$row["rid"]] = $row;
        }
        $res = makequery("SELECT * FROM vps\n\t\t\t\t\tWHERE serid = :serid\n\t\t\t\t\tORDER BY vpsid DESC", [":serid" => $globals["server"]]);
        $vpses = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vpses[$row["vpsid"]] = $row;
        }
        $_vps = [];
        $vpsid = (int) optREQ("vpsid");
        if(!empty($vpsid)) {
            $_vps = getvps($vpsid);
            if(empty($_vps)) {
                redirect("act=rebuild");
            }
            $res = makequery("SELECT * FROM ips\n\t\t\t\t\tWHERE vpsid = :vpsid\n\t\t\t\t\tORDER BY `primary` DESC", [":vpsid" => $vpsid]);
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                if(empty($row["ipv6"])) {
                    $_vps["ips"][] = $row["ip"];
                } elseif(!empty($row["ipv6"]) && !empty($row["ipr_netmask"])) {
                    $_vps["ips6_subnet"][] = $row["ip"] . "/" . $row["ipr_netmask"];
                } else {
                    $_vps["ips6"][] = $row["ip"];
                }
            }
        }
        if(isset($_POST["reos"])) {
            $newvs["vpsid"] = (int) POST("vpsid", $l["no_id"], 0);
            $newvs = getvps($newvs["vpsid"]);
            if(!empty($newvs["locked"])) {
                $error[] = $l["err_locked_vps"] . " - " . $newvs["locked"]["reason"];
                return false;
            }
            $install_script = 0;
            if(!empty($_POST["webuzo_pd"]) || !empty($_POST["webuzo_spasswd"])) {
                $webzuo_data["webuzo_os"] = (int) POST("webuzo_os", $l["webuzo_os_err"]);
                $install_script = 1;
            }
            if(empty($install_script)) {
                $newvs["osid"] = (int) POST("osid", $l["no_os"], 0);
            }
            if(!empty($error)) {
                return false;
            }
            if(!empty($install_script)) {
                $params["query"] = "SELECT * FROM plans WHERE plid = " . $newvs["plid"];
                $params["id"] = "plid";
                $plans = select_query($params);
                $valid_stacks = ["lamp", "lemp", "llmp"];
                $webzuo_data["spasswd"] = POST("webuzo_spasswd", $l["webuzo_spasswd_err"]);
                $webzuo_data["domain"] = POST("webuzo_pd", $l["webuzo_pd_err"]);
                $webzuo_data["script"] = (int) optREQ("webuzo_script");
                $webzuo_data["webuzo_stack"] = POST("webuzo_stack", $l["webuzo_stack_err"]);
                $webzuo_data["webuzo_os"] = (int) POST("webuzo_os", $l["webuzo_os_err"]);
                $webzuo_data["webserver"] = optREQ("webserver");
                if(!empty($globals["noc_apikey"]) && !empty($globals["noc_apipass"]) && !empty($globals["premium_apps"]) && (!empty($plans[$newvs["plid"]]) && !empty($plans[$newvs["plid"]]["webuzo_data"]) || isset($_POST["mysql"]) && isset($_POST["php"]))) {
                    $webzuo_data["mysql"] = POST("mysql", $l["mysql_err"]);
                    $webzuo_data["php"] = POST("php", $l["php_err"]);
                }
                $webzuo_data["ns1"] = optREQ("webuzo_ns1");
                $ns1 = $webzuo_data["ns1"];
                $webzuo_data["ns2"] = optREQ("webuzo_ns2");
                $ns2 = $webzuo_data["ns2"];
                $pass_strength = pass_strength($webzuo_data["spasswd"]);
                if($pass_strength < $globals["pass_strength"]) {
                    $error[] = $l["pass_strength_error"] . $globals["pass_strength"];
                }
                if(!empty($error)) {
                    return NULL;
                }
                $domain = $webzuo_data["domain"];
                if(!is_valid_domain_name($webzuo_data["domain"])) {
                    $error[] = $l["webuzo_pd_err"];
                }
                if(!empty($webzuo_data["webuzo_stack"]) && !in_array($webzuo_data["webuzo_stack"], $valid_stacks) || empty($webzuo_data["webserver"]) && empty($globals["noc_apikey"]) && empty($globals["noc_apipass"]) || $webzuo_data["webuzo_stack"] == "lamp" && (!isset($webzuo_data["webserver"]) || !in_array($webzuo_data["webserver"], ["apache", "apache2"]))) {
                    $webzuo_data["webserver"] = "apache";
                }
                if(!empty($webzuo_data["script"]) && (!in_array($webzuo_data["script"], $iscripts_allowed) || !array_key_exists($webzuo_data["script"], $iscripts))) {
                    $error[] = $l["webuzo_script_err"];
                }
                if(!array_key_exists($webzuo_data["webuzo_os"], $webuzo_templates)) {
                    $error[] = $l["webuzo_os_invalid"];
                }
                if(!empty($error)) {
                    return NULL;
                }
                if($webzuo_data["webuzo_stack"] === "lemp") {
                    $webzuo_data["webserver"] = "nginx";
                }
                if($webzuo_data["webuzo_stack"] === "llmp") {
                    $webzuo_data["webserver"] = "lighttpd";
                }
                $webzuo_data["admin_email"] = "admin@" . $domain;
                $webzuo_data["admin_username"] = "admin";
                $webzuo_data["admin_pass"] = generateRandPwd(13);
                $webzuo_data["rpass"] = $webzuo_data["spasswd"];
                $webzuo_data["uname"] = "admin";
                $webzuo_data["email"] = $users[$newvs["uid"]]["email"];
                $webzuo_data["script_name"] = $scripts[$webzuo_data["script"]]["fullname"];
                $webzuo_data["_virt"] = $newvs["virt"];
                $os_template = $webuzo_templates[$webzuo_data["webuzo_os"]]["filename"];
                if(!empty($_dns[0])) {
                    $tmp_dns[] = $_dns[0];
                }
                if(!empty($_dns[1])) {
                    $tmp_dns[] = $_dns[1];
                }
                $_dns = [];
                $_dns = $tmp_dns;
                if(!strcmp($domain, $newvs["hostname"])) {
                    $parts = preg_split("/[.]/", $newvs["hostname"]);
                    $parts[1] = "soft_" . $parts[1];
                    $newvs["hostname"] = implode(".", $parts);
                }
                $webzuo_data["osid"] = $webzuo_data["webuzo_os"];
                $newvs["osid"] = $webzuo_data["osid"];
                $webzuo_data["os_name"] = $os_template;
                $newvs["os_name"] = $webzuo_data["os_name"];
                $newvs["boot"] = "cda";
                $res = makequery("UPDATE `vps`\n\t\t\t\t\t  SET osid = :osid,\n\t\t\t\t\t  os_name = :os_name,\n\t\t\t\t\t  hostname = :hostname\n\t\t\t\t\t  WHERE vpsid = :vpsid", [":osid" => $newvs["osid"], ":hostname" => $newvs["hostname"], ":os_name" => empty($ostemplates[$newvs["osid"]]["name"]) ? "" : $ostemplates[$newvs["osid"]]["name"], ":vpsid" => $newvs["vpsid"]]);
                if(!empty($globals["server"])) {
                    $sres = $cluster->sync($globals["server"]);
                    if(empty($sres)) {
                        return false;
                    }
                }
                $ips = getvpsips($newvs["vpsid"]);
                foreach ($ips as $v) {
                    list($webzuo_data["primary_ip"]) = array_values($v);
                    $data = ["iscript_data" => serialize($webzuo_data), "vpsid" => $vpsid, "newvs" => $newvs];
                    $actid = tasks_admin_process("addvs", serialize($data), 10, $newvs["vpsid"], 0, 0, 0);
                    vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/iscript.php " . $actid . " > " . logdir("install_script") . $vpsid . ".log 2>&1 &");
                    $flag_rebuildvps = 1;
                    $done = 1;
                    return true;
                }
            } else {
                $control_panel = optPOST("control_panel");
                if(!empty($control_panel) && $control_panel != "none") {
                    if(empty($newvs["osid"]) && !empty($newvs["iso"])) {
                        $error[] = $l["cpan_iso"];
                        return false;
                    }
                    if(!in_array($control_panel, ["cpanel", "webuzo", "directadmin", "plesk", "interworx", "kloxo", "webmin", "ispconfig", "cwp", "vesta"])) {
                        $error[] = $l["cpan_wrong_panel"];
                        return false;
                    }
                    $json = file_get_contents($globals["path"] . "/cp_supported_os.json");
                    $vars = json_decode($json, true);
                    $currentos = strtolower($ostemplates[$newvs["osid"]]["name"]);
                    $available = [];
                    if(!empty($json) && is_array($vars)) {
                        foreach ($vars[$control_panel] as $k => $os) {
                            if(strpos($os, "|") !== false && preg_match_all("/" . $os . "/", $currentos, $matches)) {
                                if(1 < count($matches[0])) {
                                    $available[] = $control_panel;
                                }
                            } elseif(preg_match("/" . $os . "/", $currentos)) {
                                $available[] = $control_panel;
                            }
                        }
                    }
                    if(!in_array($control_panel, $available)) {
                        $error[] = ucfirst($control_panel) . " " . $l["cpan_wrong_os"] . ucfirst($currentos);
                        return false;
                    }
                    $parts = count(preg_split("/[.]/", $newvs["hostname"]));
                    if($parts < 3) {
                        $error[] = $l["invalid_hostname"];
                        return false;
                    }
                }
                $newvs["enduser_rebuild"] = optREQ("enduser_rebuild");
                $format_primary = optREQ("format_primary") ? 1 : 0;
                $vps = getvps($newvs["vpsid"]);
                $_virt = $vps["virt"] . (!empty($vps["hvm"]) ? "hvm" : "");
                if(!empty($format_primary) && !$kernel->features("format_primary", $_virt)) {
                    $error[] = $l["format_primary_warn"];
                }
                $vps += $_vps;
                if(!empty($vps["rescue"])) {
                    $error[] = $l["rescue_edit_no_allowed"];
                    return false;
                }
                if(!empty($vps["plid"]) && empty($globals["disable_recipe_reinstall"])) {
                    $res = makequery("SELECT recipe FROM plans\n\t\t\t\tWHERE plid = :plid", [":plid" => $vps["plid"]]);
                    $row = vsql_fetch_assoc($res);
                    $recipe_id = is_numeric($row["recipe"]) ? $row["recipe"] : _unserialize($row["recipe"]);
                }
                if(!empty($_POST["recipe"])) {
                    $recipe_id = $_POST["recipe"];
                    if(is_array($recipe_id)) {
                        foreach ($recipe_id as $rk => $rv) {
                            $recipe_id[$rk] = (int) $rv;
                        }
                    } else {
                        $recipe_id = (int) $recipe_id;
                    }
                }
                $task_uid = $user["uid"];
                if(!empty($newvs["enduser_rebuild"])) {
                    if(file_exists("/tmp/" . $newvs["enduser_rebuild"] . "OSRE") && is_safe_file("/tmp/" . $newvs["enduser_rebuild"] . "OSRE")) {
                        $task_uid = (int) file_get_contents("/tmp/" . $newvs["enduser_rebuild"] . "OSRE");
                        unlink("/tmp/" . $newvs["enduser_rebuild"] . "OSRE");
                    } else {
                        $error[] = $l["inv_var_passed"];
                    }
                }
                $eu_send_rebuild_email = (int) optREQ("eu_send_rebuild_email");
                if(!empty($newvs["enduser_rebuild"]) && !empty($globals["email_update_client"])) {
                    $eu_send_rebuild_email = 0;
                    $newvs["enduser_rebuild"] = "";
                }
                $virt = vps_virt_text($newvs["vpsid"]);
                $newvs["pass"] = rawGPC($_POST["newpass"]);
                $conf = rawGPC($_POST["conf"]);
                if(empty($vpses[$newvs["vpsid"]])) {
                    $error["invalid_vpsid"] = $l["invalid_vpsid"];
                    return false;
                }
                if(empty($newvs["pass"])) {
                    $error[] = $l["no_new"];
                    return false;
                }
                if(empty($conf)) {
                    $error[] = $l["no_conf"];
                    return false;
                }
                if($newvs["pass"] != $conf) {
                    $error["no_match"] = $l["no_match"];
                    return false;
                }
                if(!empty($globals["pass_strength"]) && !empty($newvs["pass"])) {
                    $pass_strength = pass_strength($newvs["pass"]);
                    if($pass_strength < $globals["pass_strength"]) {
                        $error[] = $l["pass_strength_error"] . $globals["pass_strength"];
                    }
                }
                $hvm_pass = "";
                if(($virt == "xcp" || $virt == "xen") && $hvm == 1 || $virt == "kvm") {
                    $hvm_pass = $ostemplates[$newvs["osid"]]["hvm_pass"];
                    if(!empty($hvm_pass)) {
                        $newvs["pass"] = $hvm_pass;
                        $newvs["dont_set_pass"] = 1;
                    }
                }
                if(empty($newvs["dont_set_pass"]) && stripos($ostemplates[$newvs["osid"]]["name"], "windows") !== false) {
                    $allowed_chars = "!@#\$%^&*_-+=?";
                    if(preg_match("/[^a-zA-Z0-9" . preg_quote($allowed_chars) . "]/is", $newvs["pass"])) {
                        $error["inv_winpass_chars"] = $l["inv_winpass_chars"] . " ! @ # \$ % ^ & * _ - + = ?";
                    }
                    $pass_score = win_pass_score($newvs["pass"]);
                    if($pass_score < 3) {
                        $error["weak_pass"] = $l["weak_pass"];
                    }
                }
                if(!empty($error)) {
                    return false;
                }
                if(empty($ostemplates[$newvs["osid"]]) || $ostemplates[$newvs["osid"]]["type"] != $vpses[$newvs["vpsid"]]["virt"] || !empty($vpses[$newvs["vpsid"]]["hvm"]) && empty($ostemplates[$newvs["osid"]]["hvm"]) || empty($vpses[$newvs["vpsid"]]["hvm"]) && !empty($ostemplates[$newvs["osid"]]["hvm"])) {
                    $error[] = $l["invalid_os"];
                }
                if(!empty($newvs["osid"])) {
                    $ostemplate_size = $ostemplates[$newvs["osid"]]["size"] / 1024 / 1024;
                    $vps_size = $newvs["space"] * 1024;
                    if(!empty($newvs["swap"])) {
                        $vps_size = $vps_size - $newvs["swap"];
                    }
                    if($vps_size < $ostemplate_size) {
                        $error[] = $l["err_disksize"];
                    }
                }
                $sshkey = optPOST("sshkey");
                if(!empty($sshkey)) {
                    $sshkey = $_POST["sshkey"];
                    if(strpos($sshkey, "\n") !== false) {
                        $error[] = $l["err_inv_ssh_key"];
                    }
                    $tmpfile = "/tmp/sshkey-" . generateRandStr(8);
                    file_put_contents($tmpfile, $sshkey);
                    vexec("ssh-keygen -lf " . xss($tmpfile), $out, $ret);
                    unlink($tmpfile);
                    if($ret != 0) {
                        $error[] = $l["err_inv_ssh_key"];
                    }
                }
                if(!empty($error)) {
                    return false;
                }
                $res = makequery("UPDATE `vps`\n\t\t\t\t\t  SET osid = :osid,\n\t\t\t\t\t  os_name = :os_name\n\t\t\t\t\t  WHERE vpsid = :vpsid", [":osid" => $newvs["osid"], ":os_name" => empty($ostemplates[$newvs["osid"]]["name"]) ? "" : $ostemplates[$newvs["osid"]]["name"], ":vpsid" => $newvs["vpsid"]]);
                $data = ["progress_msg" => $l["prog_update1"], "newvs" => $newvs, "vps" => $vps, "eu_send_rebuild_email" => $eu_send_rebuild_email, "format_primary" => $format_primary, "recipe" => $recipe_id];
                if(!empty($sshkey)) {
                    $data["sshkey"] = base64_encode($sshkey);
                }
                $remove_old_ssh_keys = optPOST("remove_old_ssh_keys");
                if(!empty($remove_old_ssh_keys)) {
                    $data["remove_old_ssh_keys"] = 1;
                }
                if(!empty($control_panel) && $control_panel != "none") {
                    $data["control_panel"] = $control_panel;
                }
                $actid = tasks_admin_process("rebuildvs", serialize($data), 10, $newvs["vpsid"], $task_uid, 0, 0);
                vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/rebuild.php " . $actid . " > " . logdir("rebuild") . $vpsid . ".log 2>&1 &");
                $flag_rebuildvps = 1;
                $done = 1;
                $vps = getvps($vpsid, 0);
            }
        }
    }
}
function API_rebuild()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $oslist;
    global $done;
    global $vpses;
    global $isos;
    global $virt;
    global $hvm;
    global $newvs;
    global $vps;
    global $vnc;
    global $actid;
    global $ostemplates;
    global $webuzo_apps;
    global $scripts;
    global $iscripts;
    global $allowed_scripts;
    global $webuzo_templates;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = 1;
    }
    $GLOBALS["_api"]["vpses"] = $vpses;
    $GLOBALS["_api"]["ostemplates"] = $ostemplates;
    $GLOBALS["_api"]["vps"] = $vps;
    $GLOBALS["_api"]["webuzo_apps"] = $webuzo_apps;
    $GLOBALS["_api"]["scripts"] = $scripts;
    $GLOBALS["_api"]["iscripts"] = $iscripts;
    $GLOBALS["_api"]["allowed_scripts"] = $allowed_scripts;
    $GLOBALS["_api"]["webuzo_templates"] = $webuzo_templates;
    if(!empty($vnc)) {
        $GLOBALS["_api"]["vnc"] = $vnc;
    }
    if(!empty($actid)) {
        $GLOBALS["_api"]["actid"] = $actid;
    }
}

?>