<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function pdns()
{
    global $theme;
    global $globals;
    global $user;
    global $l;
    global $error;
    global $domains;
    global $add_done;
    global $delete_done;
    global $no_dns;
    global $user_pdns_servers;
    global $default_pdns_id;
    global $done;
    $theme["init_theme"] = "pdns";
    $theme["init_theme_name"] = "pdns";
    $theme["init_theme_func"] = ["pdns_theme"];
    $theme["call_theme_func"] = "pdns_theme";
    if(empty($user["dnsplid"])) {
        $no_dns = true;
        $error[] = $l["pdns_no_dns"];
    } else {
        $default_pdns_id = $plan_pdns_id = $user["dnsplan"]["pdnsid"];
        $pdns = $user_pdns_servers = get_dns_server($plan_pdns_id);
        $con = vsql_connect($pdns["sql_ipaddress"], $pdns["sql_port"], $pdns["sql_username"], $pdns["sql_password"], $pdns["sql_database"], $pdns["use_ssl"]);
        if(!$con) {
            $error[] = $l["pdns_err_connect"];
            return false;
        }
        $globals["remote_conn"] = $con;
        $res_dom = makequery("SHOW COLUMNS FROM `domains` LIKE 'solusvm_cid'", [], 0, $con);
        $column_name = 0 < vsql_num_rows($res_dom) ? "solusvm_cid" : "virtualizor_uid";
        $delete_zone = optREQ("del");
        if(!empty($delete_zone)) {
            if(preg_match("/_/", $delete_zone)) {
                $data = explode("_", $delete_zone);
                $pdns_server = get_dns_server($data[0]);
                $domain_id = (int) $data[1];
                pdns_server_connect($pdns_server, $plan_pdns_id, $con);
            } else {
                $domain_id = (int) $delete_zone;
            }
            $res = makequery("SELECT * FROM domains WHERE " . $column_name . " = :" . $column_name . "", [":" . $column_name => $user["uid"]], 0, $con);
            $domains = [];
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $domains[$row["id"]] = $row;
                $domain_ids[] = $row["id"];
            }
            if(!in_array($domain_id, $domain_ids)) {
                $error[] = $l["pdns_invalid_zone"];
                return false;
            }
            $res = makequery("DELETE FROM records WHERE domain_id = :id", [":id" => $domain_id], 0, $con);
            $res = makequery("DELETE FROM domains WHERE id = :id", [":id" => $domain_id], 0, $con);
            if(!$res) {
                $error[] = $l["pdns_err_delete"];
                return false;
            }
            $delete_done = true;
            $done["msg"] = $l["pdns_delete_done"];
            $done["goto"] = "act=pdns";
        }
        if(isset($_POST["addzone"])) {
            $zone_name = POST("zone_name", $l["pdns_no_name"]);
            $primary_nameserver = optPOST("primary_nameserver");
            $primary_nameserver = empty($primary_nameserver) ? "ns1." . $zone_name : $primary_nameserver;
            $hostmaster_email = optPOST("hostmaster_email");
            $hostmaster_email = empty($hostmaster_email) ? "admin@" . $zone_name : $hostmaster_email;
            $pdns_server_id = (int) optPOST("pdns_server");
            if(empty($pdns_server_id)) {
                $error[] = $l["pdns_no_server"];
                return false;
            }
            if(!empty($pdns_server_id)) {
                $pdns_server = get_dns_server($pdns_server_id);
                pdns_server_connect($pdns_server, $plan_pdns_id, $con);
            }
            $res = makequery("SELECT * FROM domains WHERE virtualizor_uid = :uid", [":uid" => $user["uid"]], 0, $con);
            if($user["dnsplan"]["max_domains"] <= vsql_num_rows($res)) {
                $error[] = $l["pdns_limit_domains"];
                return false;
            }
            $hostmaster_email = str_replace("@", ".", $hostmaster_email);
            if(!is_valid_domain_name($zone_name)) {
                $error[] = $l["pdns_inv_domain"];
                return false;
            }
            if(!is_valid_domain_name($hostmaster_email)) {
                $error[] = $l["pdns_inv_email"];
                return false;
            }
            if(!is_valid_domain_name($primary_nameserver)) {
                $error[] = $l["pdns_inv_ns"];
                return false;
            }
            $res = makequery("SELECT * FROM domains WHERE name = :name", [":name" => $zone_name], 0, $con);
            if(0 < vsql_num_rows($res)) {
                $error[] = $l["pdns_domain_exists"];
                return false;
            }
            $res = makequery("INSERT INTO domains \n\t\t\t\t\t\t\t\t\tSET name = :name, \n\t\t\t\t\t\t\t\t\ttype = :type, \n\t\t\t\t\t\t\t\t\t" . $column_name . " = :" . $column_name . "", [":name" => $zone_name, ":type" => "MASTER", ":" . $column_name => $user["uid"]], 0, $con);
            $now = time();
            $nameserver = "";
            $hm_email = "";
            $ttl = "86400";
            $soa_content = get_soa_content($pdns, "", $primary_nameserver . " " . $hostmaster_email);
            $domain_id = $con->lastInsertId();
            $res = makequery("INSERT INTO records\n\t\t\t\t\t\t\t\t\tSET domain_id = :domain_id, \n\t\t\t\t\t\t\t\t\tname = :name, \n\t\t\t\t\t\t\t\t\tcontent = :content, \n\t\t\t\t\t\t\t\t\ttype = :type, \n\t\t\t\t\t\t\t\t\tttl = :ttl, \n\t\t\t\t\t\t\t\t\tprio = :prio, \n\t\t\t\t\t\t\t\t\tchange_date = :change_date", [":domain_id" => $domain_id, ":name" => $zone_name, ":content" => $soa_content, ":type" => "SOA", ":ttl" => $ttl, ":prio" => "0", ":change_date" => $now], 0, $con);
            if(!$res) {
                $error[] = $l["pdns_err_addzone"];
                return false;
            }
            $add_done = $domain_id;
            $done["msg"] = $l["pdns_add_done"];
            $done["goto"] = "act=pdns";
        }
        $user_ips = [];
        $res = makequery("SELECT i.ip \n\t\t\t\t\t\t\tFROM ips i\n\t\t\t\t\t\t\tINNER JOIN vps v\n\t\t\t\t\t\t\tON v.vpsid = i.vpsid \n\t\t\t\t\t\t\tWHERE v.uid = :uid", [":uid" => $user["uid"]]);
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $user_ips[] = $row["ip"];
        }
        $user_pdns_servers = get_user_pdns_servers($user_ips, $default_pdns_id);
        $domains = [];
        foreach (array_values($user_pdns_servers) as $pv) {
            pdns_server_connect($pv, $plan_pdns_id, $con);
            $res = makequery("SELECT * FROM domains WHERE " . $column_name . " = :" . $column_name . "", [":" . $column_name => $user["uid"]], 0, $con);
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $row["pdns_server"] = $pv["name"];
                $row["id"] = $pv["id"] . "_" . $row["id"];
                $domains[$row["id"]] = $row;
            }
        }
    }
}
function API_pdns()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $user;
    global $l;
    global $info;
    global $domains;
    global $add_done;
    global $delete_done;
    global $no_dns;
    global $done;
    global $user_pdns_servers;
    global $default_pdns_id;
    if(!empty($no_dns)) {
        $GLOBALS["_api"]["no_dns"] = $no_dns;
    }
    if(!empty($add_done)) {
        $GLOBALS["_api"]["add_done"] = $add_done;
    }
    if(!empty($delete_done)) {
        $GLOBALS["_api"]["delete_done"] = $delete_done;
    }
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    $GLOBALS["_api"]["domains"] = $domains;
    $GLOBALS["_api"]["user_pdns_servers"] = $user_pdns_servers;
    $GLOBALS["_api"]["default_pdns_id"] = $default_pdns_id;
}

?>