<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function managevps()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $servers;
    global $oslist;
    global $done;
    global $virt;
    global $done_msg;
    global $error_msg;
    global $pcis;
    global $usbs;
    global $machine_type;
    global $poweroff_vps;
    global $plans;
    global $ips;
    global $ips6;
    global $ips6_subnet;
    global $ips_int;
    global $ipools;
    global $ostemplates;
    global $vps;
    global $users;
    global $isos;
    global $resources;
    global $mgs;
    global $servergroups;
    global $scripts;
    global $iscripts;
    global $editedvs;
    global $storages;
    global $stid;
    global $disk_space;
    global $os_check;
    global $storage_uuids;
    global $disks;
    global $primary_ip;
    global $dnsplans;
    global $ips2;
    global $ipr_ips;
    global $supported_nics;
    global $cpu_modes;
    global $backup_plans;
    global $actid;
    global $bus_driver;
    global $supported_protocols;
    global $haproxydata;
    global $vpses;
    global $server_haconfigs;
    global $arr_haproxy_src_ips;
    global $server_config;
    global $vpsips;
    global $editvs;
    global $cpu_info;
    global $iscripts_allowed;
    global $webuzo_apps;
    global $isfree;
    global $webuzo_templates;
    global $ha_enabled;
    global $vm_backup_plan;
    global $recipes;
    global $ajax_user;
    global $vps_data;
    global $console;
    global $load_balancer;
    global $firewall_plans;
    global $admin_firewall_plans;
    global $enduser_firewall_plans;
    $vpsid = (int) optREQ("vpsid");
    $vps_uuid = optREQ("vps_uuid");
    if(!empty($vps_uuid)) {
        $vpsid = (int) getvpsid($vps_uuid);
    }
    $vps = getvps($vpsid, 0);
    if(empty($vps)) {
        redirect("act=vs");
    }
    set_active_server($vps["serid"]);
    if(!load_lang("admin/managevps")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/managevps";
    $theme["init_theme_name"] = "managevps";
    $theme["init_theme_func"] = ["managevps_theme"];
    $theme["call_theme_func"] = "managevps_theme";
    if(!is_allowed("editvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $cpu_info = prox_cpu_flags();
    if(empty($vps["uuid"])) {
        $res = makequery("UPDATE vps \n\t\t\t\t\t\tSET uuid = SUBSTR(SHA1(RAND()),1,16) \n\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $vpsid]);
        $vps = getvps($vpsid, 0);
    }
    if($kernel->features("boot_order", $vps["virt"])) {
        if(unserialize($vps["boot"])) {
            $vps["boot"] = unserialize($vps["boot"]);
        } else {
            $boot_order = [];
            if($vps["boot"] == "dca" && !empty($vps["iso"])) {
                array_push($boot_order, "cdrom1");
            }
            if($vps["boot"] == "dca" && !empty($vps["sec_iso"])) {
                array_push($boot_order, "cdrom2");
            }
            for ($i = 1; $i < count($vps["disks"]) + 1; $i++) {
                array_push($boot_order, "disk" . $i);
            }
            if(!empty($vps["iso"]) && $vps["boot"] == "cda") {
                array_push($boot_order, "cdrom1");
            }
            if(!empty($vps["sec_iso"]) && $vps["boot"] == "cda") {
                array_push($boot_order, "cdrom2");
            }
            $vps["boot"] = $boot_order;
        }
    }
    $vm_backup_plan = get_backup_plan($vps["vpsid"]);
    $is_centos7 = $cluster->os_check($globals["server"], "centos", ">=", 7);
    $is_ubuntu12 = $cluster->os_check($globals["server"], "ubuntu", ">=", 12);
    $is_ubuntu12 or $os_check = $is_ubuntu12 || $is_centos7;
    $storage_types = $kernel->features("storage_types", $vps["virt"] . (!empty($vps["hvm"]) ? "hvm" : ""));
    foreach ($storages as $k => $v) {
        if(!empty($storage_types) && !in_array($v["type"], $storage_types)) {
            unset($storages[$k]);
        }
    }
    if(!empty($vps["disks"])) {
        $st_uuid = $vps["disks"][0]["st_uuid"];
        foreach ($storages as $sk => $sv) {
            if($sv["st_uuid"] == $st_uuid) {
                $stid = $sk;
                foreach ($vps["disks"] as $k => $v) {
                    if(empty($v["disk_uuid"])) {
                        $vps["disks"][$k]["disk_uuid"] = "d" . $k . $k;
                    }
                }
            }
        }
    }
    if(empty($stid)) {
        $stid = storage_get_primary($vps["virt"]);
    }
    if(empty($stid)) {
        return false;
    }
    if(empty($storages[$stid])) {
        $error[] = $l["inv_storage"];
    }
    if(empty($vps["virt"])) {
        $vps["virt"] = server_primary_virt($vps["serid"]);
    }
    $vs_serid = [$vps["vpsid"] => $vps["serid"]];
    $stats = $cluster->get_vps_stats($vs_serid);
    if(!empty($stats[$vps["vpsid"]]["used_ram"])) {
        $stats[$vps["vpsid"]]["used_ram_per"] = round($stats[$vps["vpsid"]]["used_ram"] / $vps["ram"] * 100, 2);
    }
    $vps["stats"] = $stats[$vps["vpsid"]];
    if(!empty($vps["nw_suspended"])) {
        $vps["stats"]["status"] = 3;
    }
    $virt = $vps["virt"];
    if($kernel->features("load_balancer", $virt) && isset($ostemplates[$vps["osid"]]) && !preg_match("/windows/is", $ostemplates[$vps["osid"]]["name"]) && $cluster->check_licensepro($vps["serid"]) && is_billing_user($vps["uid"], 1)) {
        $load_balancer = get_load_balancer(["sgid" => $servers[$vps["serid"]]["sgid"], "uid" => $vps["uid"]]);
    }
    $vps["_virt"] = $_virt = $vps["virt"] . (!empty($vps["hvm"]) ? "hvm" : "");
    $vps["_cpupin"] = cexplode(",", $vps["cpupin"], 1);
    $vps["ips"] = [];
    $res = makequery("SELECT i.*, ip.*, i.ipv6 FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vpsid\n\t\t\t\t\tORDER BY `primary` DESC", [":vpsid" => $vpsid]);
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        if(!empty($row["internal"])) {
            $vps["ips_int"][$row["ipid"]] = $row["ip"];
        } elseif(empty($row["ipv6"])) {
            $vps["ips"][$row["ipid"]] = $row["ip"];
        } elseif(!empty($row["ipv6"]) && !empty($row["ipr_netmask"])) {
            $vps["ips6_subnet"][$row["ipid"]] = $row["ip"] . "/" . $row["ipr_netmask"];
        } else {
            $vps["ips6"][$row["ipid"]] = $row["ip"];
            $vps["ipv6"][] = $row["ip"];
        }
    }
    $primary_ip = empty($vps["ips"]) ? empty($vps["ips6"]) ? empty($vps["ips_int"]) ? current($vps["ips6_subnet"]) : current($vps["ips_int"]) : current($vps["ips6"]) : current($vps["ips"]);
    if(!empty($vps["dns_nameserver"])) {
        $vps["dns"] = unserialize($vps["dns_nameserver"]);
    }
    if($kernel->features("pci_passthrough", $vps["_virt"]) || $kernel->features("usb_passthrough", $vps["_virt"])) {
        $iommu_grp = [];
        $res2 = makequery("SELECT `pid`, `iommu_grp_num`, `vpsid` FROM `passthrough` WHERE vpsid != 0 AND `serid` = " . $globals["server"] . " AND type = 'pci' ORDER BY `pid` ASC");
        for ($i = 1; $i <= vsql_num_rows($res2); $i++) {
            $row2 = vsql_fetch_assoc($res2);
            $iommu_grp[] = $row2["iommu_grp_num"];
        }
        $pci_devs = get_all_pci_devices($vps["serid"]);
        if(!empty($pci_devs["usbs"])) {
            $usbs = $pci_devs["usbs"];
        }
        if(!empty($pci_devs["pcis"])) {
            $pcis = $pci_devs["pcis"];
        }
        $vps["pci"] = get_passthrough_devs($vps["vpsid"], "pci");
        $vps["usb"] = get_passthrough_devs($vps["vpsid"], "usb");
        if(!empty($iommu_grp) && !empty($pcis)) {
            $iommu_vps = array_keys($vps["pci"]);
            if(!empty($iommu_vps)) {
                foreach ($pcis as $k => $s) {
                    if(in_array($k, $iommu_grp) && !in_array($k, $iommu_vps)) {
                        unset($pcis[$k]);
                    }
                }
            }
        }
    }
    $load_ajax_user = optGET("load_ajax_user");
    if(!empty($load_ajax_user)) {
        $_email = optREQ("email");
        $ajax_user = get_ajax_user($_email);
        return true;
    }
    $consoleserial = optGET("consoleserial");
    if(!empty($consoleserial)) {
        $res = makequery("DELETE FROM console_sessions \n\t\t\t\tWHERE (UNIX_TIMESTAMP() - `duration`) >= `start`");
        $res = makequery("SELECT * FROM console_sessions\n\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $vpsid]);
        if(0 < vsql_num_rows($res)) {
            $console = vsql_fetch_assoc($res);
        }
        if(optGET("create") && empty($console)) {
            $ret = $cluster->console_session_create($vpsid, $duration);
            if(empty($ret)) {
                $error[] = $l["cs_call_failed"];
                return false;
            }
            if(!empty($ret["error"])) {
                $error = merge_error($error, $ret["error"]);
                return false;
            }
            $res = makequery("INSERT INTO console_sessions\n\t\t\t\tSET vpsid = :vpsid,\n\t\t\t\tserid = :serid,\n\t\t\t\tstart = UNIX_TIMESTAMP(),\n\t\t\t\tduration = :duration,\n\t\t\t\tusername = :username,\n\t\t\t\tpassword = :password,\n\t\t\t\tport = :port", [":vpsid" => $vpsid, ":serid" => $user["vps"]["serid"], ":duration" => $ret["duration"], ":username" => $ret["username"], ":password" => $ret["password"], ":port" => $ret["port"]]);
            $cluster->sync($user["vps"]["serid"]);
        }
        if(optREQ("destroy") && !empty($console)) {
            $ret = $cluster->console_session_destroy($vpsid);
            if(empty($ret)) {
                $error[] = $l["cs_call_failed"];
                return false;
            }
            if(!empty($ret["error"])) {
                $error = merge_error($error, $ret["error"]);
                return false;
            }
            $res = makequery("DELETE FROM console_sessions\n\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $vpsid]);
            $cluster->sync($user["vps"]["serid"]);
        }
        $res = makequery("SELECT * FROM console_sessions\n\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $vpsid]);
        if(0 < vsql_num_rows($res)) {
            $console = vsql_fetch_assoc($res);
        } else {
            $console = [];
        }
        if(!empty($console)) {
            $console["time_left"] = $console["start"] + $console["duration"] - time();
        }
        return $console;
    }
    $add_ssh_keys = optGET("add_ssh_keys");
    if(!empty($add_ssh_keys)) {
        $uid = $vps["uid"];
        $sshkeys = $_POST["sshkeys"];
        $sshkeys = array_map("intval", $sshkeys);
        $res = makequery("SELECT value FROM ssh_keys\n\t\t\t\t\t\t\tWHERE keyid IN ('-1', '" . implode("', '", $sshkeys) . "')\n\t\t\t\t\t\t\tAND uid = :uid", [":uid" => $uid]);
        $values = [];
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $values[] = $row["value"];
        }
        if(empty($values)) {
            $error[] = $l["sshkey_no_keys"];
            return false;
        }
        if(!$cluster->addsshkeys($vps["serid"], $vpsid, $values)) {
            $error[] = $l["sshkey_err_add"];
        } else {
            $done["msg"] = $l["sshkey_done"];
        }
    }
    oslist();
    sort_media("ostemplates", "name");
    $res = makequery("SELECT rid, name FROM recipes WHERE status <> 0 ORDER BY rid ASC");
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $recipes[$row["rid"]] = $row;
    }
    $vps["os_name"] = empty($vps["os_name"]) ? empty($vps["osid"]) || empty($ostemplates[$vps["osid"]]["name"]) ? $l["unknown"] : $ostemplates[$vps["osid"]]["name"] : $vps["os_name"];
    $mgs = listmgs();
    $servergroups = server_groups();
    if($kernel->features("iso_support", $vps["_virt"])) {
        useriso($vps["uid"]);
    }
    if($kernel->features("mac_support", $vps["_virt"]) && empty($vps["mac"])) {
        $macaddress = $cluster->getmacaddr($vpsid);
        $vps["mac"] = $macaddress;
    }
    $plans = [[]];
    $res = makequery("SELECT * FROM plans \n\t\t\t\t\tWHERE virt = :virt ORDER BY plan_name ASC", [":virt" => $vps["_virt"]]);
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $plans[$row["plid"]] = $row;
        if(!empty($row["openvz_features"])) {
            $tmp_openvz_features = _unserialize($row["openvz_features"]);
            $plans[$row["plid"]] = array_merge($plans[$row["plid"]], $tmp_openvz_features);
        }
        if(!empty($row["speed_cap"])) {
            $tmp_plan = _unserialize($row["speed_cap"]);
            $plans[$row["plid"]]["speed_cap_down"] = $tmp_plan["down"];
            $plans[$row["plid"]]["speed_cap_up"] = $tmp_plan["up"];
        }
    }
    $plans[0] = end($plans);
    foreach ($plans[0] as $k => $v) {
        $plans[0][$k] = NULL;
    }
    $plans[0]["plid"] = 0;
    $plans[0]["plan_name"] = $l["none_plan"];
    $plid = optREQ("plid");
    $backup_plans = [];
    $res = makequery("SELECT * FROM backup_plans");
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $backup_plans[$row["bpid"]] = $row;
    }
    get_fw_plans_by_user([], 1);
    $admin_firewall_plans = $firewall_plans;
    get_fw_plans_by_user([$vps["uid"]]);
    $enduser_firewall_plans = $firewall_plans;
    if(!array_key_exists($vps["admin_fwid"], $admin_firewall_plans)) {
        $res = makequery("UPDATE vps SET admin_fwid = 0 WHERE vpsid = :vpsid", [":vpsid" => $vps["vpsid"]]);
    }
    if(!array_key_exists($vps["fwid"], $enduser_firewall_plans)) {
        $res = makequery("UPDATE vps SET fwid = 0 WHERE vpsid = :vpsid", [":vpsid" => $vps["vpsid"]]);
    }
    $owner = !empty($users[$vps["uid"]]["pid"]) ? $users[$vps["uid"]]["pid"] : $vps["uid"];
    if(!empty($globals["inhouse_billing"]) && !empty($users[$owner]["inhouse_billing"]) && !empty($plid) && $plid != $vps["plid"]) {
        foreach ($globals["resource_types"] as $resource) {
            $numval = $resource == "ips" ? count($vps["ips"]) : $vps[$resource];
            if($plans[$plid][$resource] < $numval) {
                $_POST[$resource] = $vps[$resource];
                $_REQUEST[$resource] = $vps[$resource];
            }
        }
    }
    $create_inf = (int) optREQ("create_inf");
    if(!empty($create_inf)) {
        $vps_data = getvps($vpsid);
        $vps_data = serialize($vps_data);
        if(is_api_call()) {
            return true;
        }
        download_file($vps["vpsid"] . "_" . parse_backup_hostname($vps["hostname"]) . ".inf", $vps_data);
    }
    $checkbox_plans = ["hvm", "ploop", "ubcsettings", "band_suspend", "tuntap", "ppp", "admin_managed", "virtio", "vnc", "kvm_vga", "acceleration", "pv_on_hvm", "ha", "nested_virt"];
    $skip_callback = optREQ("skip_callback");
    if(!empty($plid) && $plid != $vps["plid"] && (!empty($skip_callback) || is_api_call() && !isset($_POST["apply_plan"]))) {
        $_POST["apply_plan"] = 1;
    }
    $is_plan_pool = 0;
    if(!empty($plid) && $plid != $vps["plid"] && !empty($_POST["apply_plan"])) {
        if(!empty($plans[$plid]["data"])) {
            $data_decode = json_decode($plans[$plid]["data"], 1);
        }
        foreach ($plans[$plid] as $k => $v) {
            if(in_array($k, $checkbox_plans) && empty($v)) {
            } elseif(in_array("num_" . $k, ["num_ips", "num_ips_int", "num_ips6", "num_ips6_subnet"])) {
                if(!isset($_POST["num_" . $k])) {
                    $_POST["num_" . $k] = $v;
                    $_REQUEST["num_" . $k] = $_POST["num_" . $k];
                }
            } else {
                if($k == "mgs" && !isset($_POST["mgs"])) {
                    $_POST["mgs"] = cexplode(",", $v, 1);
                    $_REQUEST["mgs"] = $_POST["mgs"];
                }
                if($k == "ippoolid" && !isset($_POST["ippoolid"]) && !empty($v)) {
                    $is_plan_pool = 1;
                    $tmp_ippoolid = _unserialize($v);
                    $_POST["ippoolid"] = implode(",", $tmp_ippoolid);
                    $_REQUEST["ippoolid"] = $_POST["ippoolid"];
                }
                if($k == "load_balancer" && !isset($_POST["load_balancer"]) && $v == 1 && empty($vps["load_balancer"])) {
                    $_POST["load_balancer"] = 0;
                    $_REQUEST["load_balancer"] = $_POST["load_balancer"];
                }
                if($k == "data" && !empty($v)) {
                    if(empty($data_decode)) {
                    } else {
                        foreach ($data_decode as $key => $val) {
                            if($key == "demo") {
                                if(isset($_POST["demo"])) {
                                } elseif(!empty($val)) {
                                    $_POST["demo_edit"] = 1;
                                    $tmp_expiry_demo = strtotime("+" . $val["duration_days"] . " days");
                                    $_POST["demo_time"] = datify($tmp_expiry_demo, 1, 1, "H:i:s");
                                    $_POST["demo_date"] = datify($tmp_expiry_demo, 1, 1, "d/m/Y");
                                    $_POST["demo_action"] = $val["action"];
                                }
                            }
                            if(!$kernel->features($key, $_virt)) {
                            } elseif(!isset($_POST[$key]) && !empty($val)) {
                                $_POST[$key] = $val;
                                $_REQUEST[$key] = $_POST[$key];
                            }
                        }
                    }
                }
                if(!isset($_POST[$k])) {
                    $_POST[$k] = $v;
                    $_REQUEST[$k] = $_POST[$k];
                }
                if($k == "dns_nameserver" && !isset($_POST["dns"])) {
                    $_POST["dns"] = _unserialize($plans[$plid]["dns_nameserver"]);
                    $_REQUEST["dns"] = $_POST["dns"];
                }
                if($k == "io" && !isset($_POST["priority"])) {
                    $_POST["priority"] = $v;
                    $_REQUEST["priority"] = $_POST["priority"];
                }
                if($k == "swap" && !isset($_POST["swapram"])) {
                    $_POST["swapram"] = $v;
                    $_REQUEST["swapram"] = $_POST["swapram"];
                }
            }
        }
    }
    $server_config = get_slave_settings($vps["serid"]);
    $ip_pid = optREQ("ippoolid");
    $get_plan = optREQ("plan");
    if(empty($ip_pid) && empty($get_plan) && !empty($vps["plid"])) {
        $get_plan = $vps["plid"];
    }
    if(!empty($get_plan) && !empty($plans[$get_plan]["ippoolid"]) && empty($ip_pid)) {
        $ip_pid = implode(",", _unserialize($plans[$get_plan]["ippoolid"]));
        $is_plan_pool = 1;
    }
    if(!empty($vps["plid"]) && !empty($plans[$vps["plid"]]["ippoolid"]) && (empty($plid) || $plid == $vps["plid"]) && empty($ip_pid)) {
        $ip_pid = implode(",", _unserialize($plans[$vps["plid"]]["ippoolid"]));
    }
    if(!empty($ip_pid)) {
        $ip_pid = cexplode(",", $ip_pid, 1);
    }
    $resid = makequery("SELECT ips.ippid FROM ippool_servers ips, ippool ip\n\t\t\t\t\t\t\t\tWHERE ip.ippid = ips.ippid AND \n\t\t\t\t\t\t\t\tip.uid = 0 AND \n\t\t\t\t\t\t\t\t(ips.sgid = :sgid\n\t\t\t\t\t\t\t\tOR ips.serid IN ('-1', :serid))", [":serid" => $vps["serid"], ":sgid" => $servers[$vps["serid"]]["sgid"]]);
    $ippid = [];
    for ($i = 0; $i < vsql_num_rows($resid); $i++) {
        $row = vsql_fetch_assoc($resid);
        $ippid[] = $row["ippid"];
    }
    $tmp_ippid = $ippid;
    $_ippid = [];
    if(!empty($ip_pid)) {
        foreach ($ip_pid as $i) {
            if(!empty($i) && in_array($i, $ippid)) {
                $_ippid[] = $i;
            }
        }
    }
    if(!empty($_ippid)) {
        $ippid = [];
        $ippid = $_ippid;
    }
    $ips = [];
    $ips6 = [];
    $ips6_subnet = [];
    $ips_int = [];
    $res = makequery("SELECT uid, email, pid, inhouse_billing \n\t\t\t\t\tFROM users \n\t\t\t\t\tORDER BY email \n\t\t\t\t\tLIMIT 0, " . (empty($globals["load_user_limit"]) ? 250 : $globals["load_user_limit"]));
    $users = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $users[$row["uid"]] = $row;
    }
    if(empty($users[$vps["uid"]])) {
        $res = makequery("SELECT uid, email, pid, inhouse_billing\n\t\t\t\t\t\tFROM users \n\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $vps["uid"]]);
        $row = vsql_fetch_assoc($res);
        $users[$row["uid"]] = $row;
    }
    if(!empty($users[$vps["uid"]]["pid"]) && empty($users[$users[$vps["uid"]]["pid"]])) {
        $res = makequery("SELECT uid, email, pid, inhouse_billing \n\t\t\t\t\t\tFROM users \n\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $users[$vps["uid"]]["pid"]]);
        $row = vsql_fetch_assoc($res);
        $users[$row["uid"]] = $row;
    }
    $_tmp_user_email = optREQ("user_email");
    if(!empty($_tmp_user_email)) {
        foreach ($users as $k => $v) {
            if(strtolower($v["email"]) == strtolower($_tmp_user_email)) {
                $_POST["uid"] = $v["uid"];
            }
        }
    }
    $uid = (int) optREQ("uid");
    if(empty($uid)) {
        $uid = $vps["uid"];
    }
    if(!empty($_REQUEST["pool_uid"])) {
        $uid = (int) optREQ("pool_uid");
    }
    if(!empty($uid)) {
        $q["query"] = "SELECT uid,pid FROM `users` WHERE uid = :uid";
        $q["token"] = [":uid" => $uid];
        $q["id"] = "uid";
        $r = select_query($q);
        if(!empty($r[$uid]["pid"])) {
            $uid = $r[$uid]["pid"];
        }
        $params["query"] = "SELECT ips.ippid FROM ippool_servers ips, ippool ip\n\t\t\t\t\t\t\tWHERE ip.ippid = ips.ippid AND \n\t\t\t\t\t\t\tip.uid = :uid AND \n\t\t\t\t\t\t\t(ips.sgid = :sgid\n\t\t\t\t\t\t\tOR ips.serid IN ('-1', :serid))";
        $params["token"] = [":serid" => $vps["serid"], ":sgid" => $servers[$vps["serid"]]["sgid"], ":uid" => $uid];
        $params["id"] = "ippid";
        $rows = select_query($params);
        if(!empty($rows)) {
            if(!empty($ippid) && !empty($is_plan_pool)) {
                call_user_func_array("array_unshift", array_merge([$ippid], array_keys($rows)));
            } else {
                $ippid = array_keys($rows);
            }
        }
    }
    $ippid_token["tokens"] = [];
    if(!empty($ippid)) {
        $ippid_token = vsql_in_tokens($ippid);
    }
    $res = makequery("SELECT sum(ipv6) as ipv6_pool, sum(internal) as internal_pool FROM ippool WHERE ippid IN ('-1'" . (!empty($ippid) ? ", " . $ippid_token["query"] : "") . ")", $ippid_token["tokens"]);
    $row = vsql_fetch_assoc($res);
    $is_internal_pool = empty($row["internal_pool"]) ? $tmp_ippid : $ippid;
    $is_ipv6_pool = empty($row["ipv6_pool"]) ? $tmp_ippid : $ippid;
    $res = makequery("SELECT i.* FROM ips i\n\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid)\n\t\t\t\t\t\tWHERE (i.ippid IN (" . (count($ippid) < 1 ? -2 : $ippid_token["query"]) . ")\n\t\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :serid)))\n\t\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\t\tAND i.ipv6 = 0\n\t\t\t\t\t\tAND ip.internal = 0\n\t\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\t\tORDER BY FIELD(ip.ippid , " . (count($ippid) < 1 ? -2 : implode(",", $ippid)) . ")\n\t\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($ippid_token["tokens"], [":serid" => $vps["serid"]]));
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $ips[$row["ipid"]] = $row;
    }
    $int_ippid_token["tokens"] = [];
    if(1 <= count($is_internal_pool)) {
        $int_ippid_token = vsql_in_tokens($is_internal_pool);
    }
    $res = makequery("SELECT i.*, ip.internal FROM ips i\n\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\t\tWHERE (i.ippid IN (" . (count($is_internal_pool) < 1 ? -2 : $int_ippid_token["query"]) . ")\n\t\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :ip_serid)))\n\t\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\t\tAND i.ipv6 = 0\n\t\t\t\t\t\tAND ip.internal = 1\n\t\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\t\tORDER BY FIELD(ip.ippid , " . (count($is_internal_pool) < 1 ? -2 : implode(",", $is_internal_pool)) . ")\n\t\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($int_ippid_token["tokens"], [":ip_serid" => $vps["serid"]]));
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $ips_int[$row["ipid"]] = $row;
    }
    $ipv6_ippid_token["tokens"] = [];
    if(1 <= count($is_ipv6_pool)) {
        $ipv6_ippid_token = vsql_in_tokens($is_ipv6_pool);
    }
    $res = makequery("SELECT i.* FROM ips i\n\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\t\tWHERE (i.ippid IN (" . (count($is_ipv6_pool) < 1 ? -2 : $ipv6_ippid_token["query"]) . ")\n\t\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :ip_serid)))\n\t\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\t\tAND i.ipv6 = 1\n\t\t\t\t\t\tAND ip.internal = 0\n\t\t\t\t\t\tAND i.ipr_netmask = ''\n\t\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\t\tORDER BY FIELD(ip.ippid , " . (count($is_ipv6_pool) < 1 ? -2 : implode(",", $is_ipv6_pool)) . ")\n\t\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($ipv6_ippid_token["tokens"], [":ip_serid" => $vps["serid"]]));
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $ips6[$row["ipid"]] = $row;
    }
    $ipv6_sub_ippid_token["tokens"] = [];
    if(1 <= count($is_ipv6_pool)) {
        $ipv6_sub_ippid_token = vsql_in_tokens($is_ipv6_pool);
    }
    $res = makequery("SELECT i.* FROM ips i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE (i.ippid IN (" . (count($is_ipv6_pool) < 1 ? -2 : $ipv6_sub_ippid_token["query"]) . ")\n\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :ip_serid)))\n\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\tAND i.ipv6 = 1\n\t\t\t\t\tAND i.ipr_netmask != ''\n\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\tORDER BY FIELD(ip.ippid , " . (count($is_ipv6_pool) < 1 ? -2 : implode(",", $is_ipv6_pool)) . ")\n\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($ipv6_sub_ippid_token["tokens"], [":ip_serid" => $vps["serid"]]));
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $ips6_subnet[$row["ipid"]] = $row;
    }
    if(!empty($globals["randomize_ips"])) {
        if(!empty($ips)) {
            shuffle($ips);
        }
        if(!empty($ips_int)) {
            shuffle($ips_int);
        }
        if(!empty($ips6)) {
            shuffle($ips6);
        }
        if(!empty($ips6_subnet)) {
            shuffle($ips6_subnet);
        }
    }
    $ip_details = apply_filters("randomize_ips", $ips, $ips_int, $ips6, $ips6_subnet);
    if(!empty($ip_details)) {
        if(!empty($ip_details["ips"])) {
            $ips = $ip_details["ips"];
        }
        if(!empty($ip_details["ips_int"])) {
            $ips_int = $ip_details["ips_int"];
        }
        if(!empty($ip_details["ips6"])) {
            $ips6 = $ip_details["ips6"];
        }
        if(!empty($ip_details["ips6_subnet"])) {
            $ips6_subnet = $ip_details["ips6_subnet"];
        }
    }
    $res = makequery("SELECT serid, sg_ha FROM servers \n\t\t\t\t\tRIGHT JOIN server_groups\n\t\t\t\t\tON (servers.sgid = server_groups.sgid)\n\t\t\t\t\tWHERE server_groups.sg_ha != ''");
    $ha_enabled = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        if(!empty($row["sg_ha"])) {
            $ha_enabled[$row["serid"]] = $row;
        }
    }
    $resources = $cluster->resources($vps["serid"], $vps["virt"]);
    foreach ($resources["storages"] as $_stid => $v) {
        $storage_uuids[$v["st_uuid"]] = $_stid;
        if(!empty($v["oversell"])) {
            $alloc_space = storage_allocated_space($_stid);
            $storages[$_stid]["disk_space"] = $v["oversell"] - $alloc_space;
        } else {
            $storages[$_stid]["disk_space"] = $v["free"];
        }
    }
    $vps["band_per"] = 0;
    if(!empty($vps["bandwidth"])) {
        $vps["band_per"] = round($vps["used_bandwidth"] / $vps["bandwidth"] * 100, 3);
    }
    $vps["disk_per"] = 0;
    if(!empty($vps["cached_disk"]["disk"]["Use%"])) {
        $vps["disk_per"] = round((double) str_replace("%", "", $vps["cached_disk"]["disk"]["Use%"]), 3);
        $vps["stats"]["used_disk"] = round($vps["cached_disk"]["disk"]["Used"] / 1024 / 1024, 3);
        $vps["stats"]["avaiable_disk"] = round($vps["cached_disk"]["disk"]["Available"] / 1024 / 1024, 3);
    } elseif($kernel->features("openvz", $vps["_virt"])) {
        $vps["disk_per"] = round($vps["stats"]["used_disk"] / $vps["stats"]["disk"] * 100, 2);
        $vps["stats"]["used_disk"] = round($vps["stats"]["used_disk"], 3);
        $vps["stats"]["avaiable_disk"] = round($vps["stats"]["disk"] - $vps["stats"]["used_disk"], 3);
    }
    $vps["vnc_ip"] = server_vncip($vps["serid"]);
    $dnsplans = [[]];
    $res = makequery("SELECT * FROM dnsplans");
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $dnsplans[$row["dnsplid"]] = $row;
    }
    $dnsplans[0] = end($dnsplans);
    foreach ($dnsplans[0] as $k => $v) {
        $dnsplans[0][$k] = NULL;
    }
    $dnsplans[0]["dnsplid"] = 0;
    $dnsplans[0]["plan_name"] = $l["none_plan"];
    $enable_rescue = optREQ("enable_rescue") && $kernel->features("rescue_support", $vps["virt"]) ? 1 : 0;
    if(!empty($enable_rescue)) {
        if(!empty($vps["rescue"])) {
            $error[] = $l["rescue_enabled"];
            return false;
        }
        if(!empty($vps["locked"])) {
            $error[] = $l["err_vps_locked"];
            return false;
        }
        $password = POST("rescue_pass", $l["no_root"]);
        $conf_password = POST("conf_rescue_pass", $l["no_conf"]);
        $enduser_rescue = optREQ("enduser_rescue");
        if(!empty($error)) {
            return false;
        }
        $password = rawGPC($_POST["rescue_pass"]);
        $conf_password = rawGPC($_POST["conf_rescue_pass"]);
        if($password != $conf_password) {
            $error[] = $l["passwords_do_not_match"];
            return false;
        }
        $task_uid = $user["uid"];
        if(!empty($enduser_rescue)) {
            if(file_exists("/tmp/" . $enduser_rescue . "RESCUE_ENABLE") && is_safe_file("/tmp/" . $enduser_rescue . "RESCUE_ENABLE")) {
                $task_uid = (int) file_get_contents("/tmp/" . $enduser_rescue . "RESCUE_ENABLE");
                unlink("/tmp/" . $enduser_rescue . "RESCUE_ENABLE");
            } else {
                $error[] = $l["inv_var_passed"];
                return false;
            }
        }
        $vps = getvps($vps["vpsid"], 0);
        $vps["_virt"] = $_virt = $vps["virt"] . (!empty($vps["hvm"]) ? "hvm" : "");
        if(preg_match("/kvm/is", $vps["_virt"]) && !empty($vps["boot"]) && preg_match("/cda|dca/is", $vps["boot"])) {
            $error[] = $l["resuce_edit_vps_kvm"];
        }
        if(!empty($error)) {
            return false;
        }
        $res = update_query("UPDATE vps SET rescue = 1 WHERE vpsid = '" . $vps["vpsid"] . "'");
        if(!empty($vps["serid"])) {
            $sres = $cluster->sync($vps["serid"]);
            if(empty($sres)) {
                return false;
            }
        }
        $data = ["action" => "enable", "password" => $password];
        $actid = tasks_admin_process("enable_rescuevs", serialize($data), 10, $vps["vpsid"], $task_uid, 0, 0);
        vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/rescuevs.php " . $actid . " > " . logdir("enable_rescuevs") . $vpsid . ".log 2>&1 &");
        $done["rescue_enabled"] = true;
        return true;
    }
    $disable_rescue = optREQ("disable_rescue") && $kernel->features("rescue_support", $vps["virt"]) ? 1 : 0;
    if(!empty($disable_rescue)) {
        $enduser_rescue = optREQ("enduser_rescue");
        if(empty($vps["rescue"])) {
            $error[] = $l["rescue_not_enabled"];
            return false;
        }
        if(!empty($vps["locked"])) {
            $error[] = $l["err_vps_locked"];
            return false;
        }
        $task_uid = $user["uid"];
        if(!empty($enduser_rescue)) {
            if(file_exists("/tmp/" . $enduser_rescue . "RESCUE_DISABLE") && is_safe_file("/tmp/" . $enduser_rescue . "RESCUE_DISABLE")) {
                $task_uid = (int) file_get_contents("/tmp/" . $enduser_rescue . "RESCUE_DISABLE");
                unlink("/tmp/" . $enduser_rescue . "RESCUE_DISABLE");
            } else {
                $error[] = $l["inv_var_passed"];
                return false;
            }
        }
        $data = ["action" => "disable"];
        $actid = tasks_admin_process("disable_rescuevs", $data, 10, $vps["vpsid"], $task_uid, 0, 0);
        vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/rescuevs.php " . $actid . " > " . logdir("disable_rescuevs") . $vpsid . ".log 2>&1 &");
        $done["rescue_disabled"] = true;
        return true;
    }
    load_scripts();
    update_webuzoapps();
    $webuzo_apps = load_webuzoapps();
    $iscripts_allowed = get_web_scripts();
    $webuzo_templates = webuzo_os($vps["virt"], $vps["hvm"]);
    $loadscript = (int) optGET("loadscripts");
    if(!empty($loadscript)) {
        foreach ($iscripts_allowed as $k => $v) {
            if(!array_key_exists($v, $iscripts)) {
                unset($iscripts_allowed[$k]);
            } else {
                $i_scripts[$l["cat_php_" . $scripts[$v]["category"]]][$v]["name"] = $scripts[$v]["name"];
                $i_scripts[$l["cat_php_" . $scripts[$v]["category"]]][$v]["softname"] = $scripts[$v]["softname"];
            }
        }
        $done["allowed_scripts"] = $i_scripts;
        $done["webuzo_apps"] = $webuzo_apps;
        if(empty($globals["noc_apikey"]) && empty($globals["noc_apipass"])) {
            $done["isfree"] = 1;
        }
        return NULL;
    } else {
        $webuzoscriptid = (int) optGET("scriptreqid");
        if(!empty($webuzoscriptid)) {
            if(!array_key_exists($webuzoscriptid, $scripts)) {
                $error[] = $l["webuzo_script_err"];
                return NULL;
            }
            $script = $scripts[$webuzoscriptid]["name"];
            $stack = [];
            $stack = load_free_webapps();
            $req = $kernel->script_req($webuzoscriptid, $script);
            if(empty($req)) {
                $webuzo_apps = $stack;
            } else {
                foreach ($req as $key => $val) {
                    if($val["type"] === "version") {
                        foreach ($webuzo_apps[$val["check"]] as $appkey => $appval) {
                            if(!version_compare($appval["version"], $val["version"], $val["operator"])) {
                                unset($webuzo_apps[$val["check"]][$appkey]);
                            }
                        }
                    }
                }
                if(empty($webuzo_apps["php"])) {
                    $error[] = $l["webuzo_support_err"];
                    $support_err = 1;
                }
            }
            if(empty($globals["noc_apikey"]) && empty($globals["noc_apipass"])) {
                $done["isfree"] = 1;
            }
            $done["webuzo_apps"] = $webuzo_apps;
            return NULL;
        }
        $install_script = optGET("install_script") ? 1 : 0;
        if(!empty($install_script)) {
            if(!empty($vps["rescue"])) {
                $error[] = $l["rescue_enabled"];
                return false;
            }
            if(!empty($vps["locked"])) {
                $error[] = $l["err_vps_locked"];
                return false;
            }
            $enduser_iscript = optREQ("enduser_iscript");
            $os_template = "";
            $task_uid = $user["uid"];
            if(!empty($enduser_iscript)) {
                $iscript_data = GET("apidata", $l["no_iscript_data"]);
                $ns1 = optREQ("ns1");
                $ns2 = optREQ("ns2");
                $data["webuzo_os"] = optREQ("os");
                $iscript_data = base64_decode($iscript_data);
                if(!empty($error)) {
                    return false;
                }
                if(file_exists("/tmp/" . $enduser_iscript . "ISCRIPT") && is_safe_file("/tmp/" . $enduser_iscript . "ISCRIPT")) {
                    $task_uid = (int) file_get_contents("/tmp/" . $enduser_iscript . "ISCRIPT");
                    unlink("/tmp/" . $enduser_iscript . "ISCRIPT");
                } else {
                    $error[] = $l["inv_var_passed"];
                    return false;
                }
            } else {
                $valid_stacks = ["lamp", "lemp", "llmp"];
                $data["spasswd"] = POST("webuzo_spasswd", $l["webuzo_spasswd_err"]);
                $data["domain"] = POST("webuzo_pd", $l["webuzo_pd_err"]);
                $data["script"] = (int) optREQ("webuzo_script");
                $data["webuzo_stack"] = POST("webuzo_stack", $l["webuzo_stack_err"] . "3");
                $data["webuzo_os"] = (int) POST("webuzo_os", $l["webuzo_os_err"]);
                $data["webserver"] = optREQ("webserver");
                if(!empty($globals["noc_apikey"]) && !empty($globals["noc_apipass"])) {
                    $data["mysql"] = POST("mysql", $l["mysql_err"]);
                    $data["php"] = POST("php", $l["php_err"]);
                }
                $data["ns1"] = optREQ("webuzo_ns1");
                $ns1 = $data["ns1"];
                $data["ns2"] = optREQ("webuzo_ns2");
                $ns2 = $data["ns2"];
                $pass_strength = pass_strength($data["spasswd"]);
                if($pass_strength < $globals["pass_strength"]) {
                    $error[] = $l["pass_strength_error"] . $globals["pass_strength"];
                }
                if(!empty($error)) {
                    return NULL;
                }
                $domain = $data["domain"];
                if(!is_valid_domain_name($data["domain"])) {
                    $error[] = $l["webuzo_pd_err"];
                }
                if(!empty($data["webuzo_stack"]) && !in_array($data["webuzo_stack"], $valid_stacks) || empty($data["webserver"]) && empty($globals["noc_apikey"]) && empty($globals["noc_apipass"]) || $data["webuzo_stack"] == "lamp" && (!isset($data["webserver"]) || !in_array($data["webserver"], ["apache", "apache2"]))) {
                    $data["webserver"] = "apache";
                }
                if(!empty($data["script"]) && (!in_array($data["script"], $iscripts_allowed) || !array_key_exists($data["script"], $iscripts))) {
                    $error[] = $l["webuzo_script_err"];
                }
                if(!empty($data["webuzo_stack"]) && !in_array($data["webuzo_stack"], $valid_stacks)) {
                    $error[] = $l["webuzo_stack_err"];
                }
                if(!array_key_exists($data["webuzo_os"], $webuzo_templates)) {
                    $error[] = $l["webuzo_os_invalid"];
                }
                if(!empty($error)) {
                    return NULL;
                }
                if($data["webuzo_stack"] === "lemp") {
                    $data["webserver"] = "nginx";
                }
                if($data["webuzo_stack"] === "llmp") {
                    $data["webserver"] = "lighttpd";
                }
                $data["primary_ip"] = $primary_ip;
                $data["admin_email"] = "admin@" . $domain;
                $data["admin_username"] = "admin";
                $data["admin_pass"] = generateRandPwd(13);
                $data["rpass"] = $data["spasswd"];
                $data["uname"] = "admin";
                $data["email"] = $users[$vps["uid"]]["email"];
                $data["script_name"] = $scripts[$data["script"]]["fullname"];
                $iscript_data = serialize($data);
            }
            $os_template = $webuzo_templates[$data["webuzo_os"]]["filename"];
            $dns = unserialize($vps["dns_nameserver"]);
            if(!empty($ns1) || !empty($ns2)) {
                $dns = [];
                $dns[] = $ns1;
                $dns[] = $ns2;
            }
            $res = update_query("UPDATE `vps` SET\n\t\t\t\tosid = :osid,\n\t\t\t\tos_name = :os_name,\n\t\t\t\tdns_nameserver = :dns,\n\t\t\t\tboot = :boot\n\t\t\t\tWHERE vpsid = :vpsid", [":os_name" => $os_template, ":vpsid" => $vps["vpsid"], ":dns" => serialize(array_filter($dns)), ":boot" => "cda", ":osid" => $data["webuzo_os"]]);
            $vps = getvps($vps["vpsid"], 0);
            if(!empty($vps["serid"])) {
                $sres = $cluster->sync($vps["serid"]);
                if(empty($sres)) {
                    return false;
                }
            }
            $data = ["iscript_data" => $iscript_data, "vpsid" => $vpsid];
            $actid = tasks_admin_process("install_script", serialize($data), 10, $vps["vpsid"], $task_uid, 0, 0);
            vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/iscript.php " . $actid . " > " . logdir("install_script") . $vpsid . ".log 2>&1 &");
            $done["webuzo_enabled"] = true;
        }
        $bwreset = (int) optREQ("bwreset");
        if(!empty($bwreset)) {
            $vps = getvps($bwreset);
            $result = $cluster->bandwidth_reset($vps["vpsid"]);
            $done_msg = $l["done_bwreset"];
            return true;
        }
        $managesubnets = (int) optREQ("managesubnets");
        if(!empty($managesubnets)) {
            $subnet_mask_arr = ["112" => 1, "96" => 2, "80" => 3, "64" => 4, "48" => 5];
            $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\t\tWHERE i.vpsid = '" . $vpsid . "'\n\t\t\t\t\t\tAND i.ipv6 > 0\n\t\t\t\t\t\tAND i.ipr_netmask != ''\n\t\t\t\t\t\tORDER BY i.`primary` DESC");
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                if(!empty($row["ipr_ips"])) {
                    $row["ipr_ips"] = unserialize($row["ipr_ips"]);
                }
                $ips2[$row["ipid"]] = ["ip" => $row["ip"], "ipr_netmask" => $row["ipr_netmask"], $row["ip"] => $row["ipr_ips"]];
            }
            $ipv6_addr = optPOST("ipv6_addr");
            $new_ipv6 = $_POST["new_ipv6"];
            $ipv6_subnet_mask = optPOST("ipv6_subnet_mask");
            $subnet = optPOST("subnet");
            if(!empty($ipv6_subnet_mask) && @in_array($ipv6_subnet_mask, @array_keys($subnet_mask_arr))) {
                foreach ($ips2 as $k => $v) {
                    $allowed_ip[$k] = $v["ip"];
                }
                if(!in_array($ipv6_addr, $allowed_ip)) {
                    $error[] = $l["mng_inv_ipaddress"];
                    return false;
                }
                $ipv6_parts = explode(":", $ipv6_addr);
                $ipv6_parts = array_slice($ipv6_parts, 0, count($ipv6_parts) - $subnet_mask_arr[$ipv6_subnet_mask]);
                $ipv6_to_check = implode(":", $ipv6_parts);
                if(is_array($new_ipv6)) {
                    $new_ipv6 = array_unique($new_ipv6);
                    foreach ($new_ipv6 as $new_ip) {
                        if(!(valid_ipv6($new_ip) && strpos($new_ip, $ipv6_to_check) === 0)) {
                            $error[] = $l["mng_ipv6_invalid"];
                            $new_ipv6_update = serialize($new_ipv6);
                        }
                    }
                } else {
                    $new_ipv6 = NULL;
                    $new_ipv6_update = "";
                }
                if(!isset($error)) {
                    $res = makequery("UPDATE `virtualizor`.`ips` \n\t\t\t\t\t\t\t\t\tSET `ipr_ips` = :ipr_ips \n\t\t\t\t\t\t\t\t\tWHERE `ips`.`ipr_netmask` = :ipr_netmask \n\t\t\t\t\t\t\t\t\tAND `ip`= :ip", [":ipr_ips" => $new_ipv6_update, ":ipr_netmask" => $ipv6_subnet_mask, ":ip" => $ipv6_addr]);
                    $cluster->editvps($vpsid);
                    $done["done"] = $l["mng_done"];
                }
                $ipr_ips["ipv6"] = $new_ipv6;
                $ipr_ips["ipv6_list"] = 1;
                $ipr_ips["ipv6_subnet_mask"] = $ipv6_subnet_mask;
                $ipr_ips["ipv6_subnet_mask_value"] = $subnet_mask_arr[$ipv6_subnet_mask];
                $ipr_ips["ipv6_addr"] = $ipv6_addr;
            } elseif(!empty($subnet) && 0 < strpos($subnet, "/")) {
                list($ipv6, $subnet_mask) = explode("/", $subnet, 2);
                if(valid_ipv6($ipv6) && in_array($subnet_mask, array_keys($subnet_mask_arr))) {
                    $ipr_ips = [];
                    foreach ($ips2 as $k => $v) {
                        if(isset($v[$ipv6])) {
                            $ipr_ips["ipv6"] = $v[$ipv6];
                        }
                    }
                    $ipr_ips["ipv6_list"] = 1;
                    $ipr_ips["ipv6_subnet_mask"] = $subnet_mask;
                    $ipr_ips["ipv6_subnet_mask_value"] = $subnet_mask_arr[$subnet_mask];
                    $ipr_ips["ipv6_addr"] = $ipv6;
                }
            }
            $cluster->sync($vps["serid"]);
            return true;
        }
        $managevdf = (int) optREQ("managevdf");
        if(!empty($managevdf)) {
            $_POST["vpsuuid"] = $vps["uuid"];
            $_POST["serid"] = $vps["serid"];
            $_POST["managevdf"] = 1;
            $resp = $cluster->call(0, "index.php?act=haproxy", 1, [], $_POST);
            $supported_protocols = $resp["supported_protocols"];
            $haproxydata = !empty($resp["haproxydata"]) ? $resp["haproxydata"] : [];
            $arr_haproxy_src_ips = $resp["arr_haproxy_src_ips"];
            $vpses = $resp["vpses"];
            $server_haconfigs = $resp["server_haconfigs"];
            $vpsips = $resp["vpsips"];
            $done = $resp["done"];
            $error = $resp["error"];
            return true;
        }
        if(!empty($_REQUEST["cbackup"])) {
            $vpsid = optREQ("vpsid");
            $res = makequery("SELECT serid FROM vps WHERE vpsid=:vpsid", [":vpsid" => $vpsid]);
            if(vsql_num_rows($res) < 1) {
                $error[] = $l["bak_vps_not_exists"];
                return false;
            }
            $row = vsql_fetch_assoc($res);
            $serid = $row["serid"];
            if($kernel->features("inc_backup", $vps["virt"]) && $cluster->has_plugin_license($vps["serid"], "backuply") && empty($vm_backup_plan["data"]["enable_legacy_backup"])) {
                $type = "inc";
                $take_full_backup = optREQ("take_full_backup");
                if(!empty($take_full_backup) && $vm_backup_plan["frequency"] == "manual" || $vm_backup_plan["data"]["backup_scheme"] == "always_full" && $vm_backup_plan["frequency"] != "manual") {
                    $type = "full";
                }
                $actid = $cluster->backuply_single_backup($vps["vpsid"], $type);
            } else {
                $actid = $cluster->plan_backupvps($serid, $vpsid, $user["uid"], 1);
            }
            if(empty($actid)) {
                $error[] = $l["err_bak_now"];
                return false;
            }
            if($actid == -1) {
                $error[] = $l["err_bak_task_exist"];
                return false;
            }
            $done["msg"] = $l["bak_now_started"];
        }
        $cpu_modes = [];
        $machine_type = [];
        $supported_nics = $kernel->features("nic", $vps["_virt"]);
        $cpu_modes = $kernel->features("cpu_mode_list", $vps["_virt"]);
        $bus_driver = $kernel->features("bus_driver_list", $vps["_virt"]);
        if(!empty($resources["cpu_model"])) {
            $cpu_modes += $resources["cpu_model"];
        }
        if(!empty($resources["machine_type"])) {
            $machine_type = $resources["machine_type"];
        }
        if(isset($_POST["editvps"])) {
            $_POST["theme_edit"] = 1;
            if(!empty($vps["rescue"])) {
                $error[] = $l["rescue_edit_no_allowed"];
                return false;
            }
            if(!empty($vps["locked"])) {
                $error[] = $l["err_vps_locked"];
                return false;
            }
            $editvs = [];
            if(isset($_POST["theme_edit"])) {
                if(!isset($_POST["rootpass"])) {
                    unset($_POST["rootpass"]);
                }
                if(isset($_POST["cpupin"])) {
                    foreach ($_POST["cpupin"] as $k => $v) {
                        if(isset($_POST["cpupin"][$k]) && empty($_POST["cpupin"][$k]) && in_array($k, $vps["_cpupin"]) && ($key = array_search($k, $vps["_cpupin"])) !== false) {
                            unset($vps["_cpupin"][$key]);
                            unset($_POST["cpupin"][$k]);
                        }
                    }
                    if(in_array(-1, $vps["_cpupin"]) && ($key = array_search(-1, $vps["_cpupin"])) !== false) {
                        unset($vps["_cpupin"][$key]);
                    }
                    $_POST["cpupin"] = array_unique(array_merge($_POST["cpupin"], $vps["_cpupin"]), SORT_NUMERIC);
                    $_REQUEST["cpupin"] = $_POST["cpupin"];
                }
                if(isset($_POST["allcores"]) && !empty($_POST["allcores"])) {
                    $_POST["cpupin"] = -1;
                    $_REQUEST["cpupin"] = $_POST["cpupin"];
                }
            }
            isset_post("pass", "rootpass");
            isset_post("plid", "", "int");
            isset_post("hostname", "");
            isset($_POST["space"]);
            isset($_POST["space"]) ? $editvs["space"] : "";
            isset($_POST["bus_driver"]);
            isset($_POST["bus_driver"]) ? $editvs["bus_driver"] : "";
            isset($_POST["bus_driver_num"]);
            isset($_POST["bus_driver_num"]) ? $editvs["bus_driver_num"] : "";
            isset_post("ram", "", "int");
            isset_post("bandwidth", "", "int");
            isset_post("cores", "", "int");
            if(isset($_POST["cpupin"])) {
                $editvs["cpupin"] = -1;
            }
            isset_post("uid", "", "int");
            isset_post("network_speed", "", "int");
            isset_post("upload_speed", "", "int");
            isset_post("speed_cap_down", "", "int");
            isset_post("speed_cap_up", "", "int");
            isset_post("osreinstall_limit", "", "int");
            isset_post("webuzo", "sid", "int");
            isset_post("cpu_mode");
            isset_post("notes");
            isset_post("bpid", "", "int");
            isset_post("fwid", "", "int");
            isset_post("admin_fwid", "", "int");
            isset_post("install_xentools");
            isset_post("band_suspend", "", "int");
            isset_post("admin_managed", "", "int");
            isset_post("rdp", "", "int");
            isset_post("disable_nw_config", "", "int");
            isset_post("sec_iso");
            if(!empty($editvs["uid"])) {
                if(empty($users[$editvs["uid"]])) {
                    $res = makequery("SELECT uid, email, pid, inhouse_billing\n\t\t\t\t\t\t\t\tFROM users \n\t\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $editvs["uid"]]);
                    $row = vsql_fetch_assoc($res);
                    $users[$row["uid"]] = $row;
                }
                if(!empty($users[$editvs["uid"]]["pid"]) && empty($users[$users[$editvs["uid"]]["pid"]])) {
                    $res = makequery("SELECT uid, email, pid, inhouse_billing\n\t\t\t\t\t\t\t\tFROM users \n\t\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $users[$editvs["uid"]]["pid"]]);
                    $row = vsql_fetch_assoc($res);
                    $users[$row["uid"]] = $row;
                }
            }
            if($editvs["bus_driver"] == "ide" && ($editvs["bus_driver_num"] < 2 || 3 < $editvs["bus_driver_num"])) {
                $error[] = $l["ide_bus_num_err"];
            }
            $tmp_data = ["os_type", "rtc", "vnc_auto_port", "nested_virt", "vga_vram", "discard", "vlan_tag", "enable_guest_agent", "ssd_emulation", "machine_type", "enable_tpm", "bios", "vm_admin_name", "crypted_pass", "crypted_salt", "min_ram", "cpu_flags", "scsi_controller", "enable_cpu_threshold", "cpu_threshold", "cpu_threshold_time", "disable_guest_agent"];
            if(check_licensepro()) {
                $tmp_data = array_merge($tmp_data, ["enable_ver_scaling", "ver_max_ram", "ver_ram_threshold", "ver_ram_inc_by", "ver_max_cpu", "ver_cpu_threshold", "ver_cpu_inc_by"]);
            }
            foreach ($tmp_data as $vk => $vv) {
                if(isset($_POST[$vv]) || isset($_REQUEST[$vv])) {
                    $editvs[$vv] = $_REQUEST[$vv];
                } else {
                    $editvs[$vv] = $vps["data"][$vv];
                }
            }
            if($kernel->features("cpu_flags", $vps["virt"]) && $cluster->check_feature($vps["serid"], $vps["virt"], "cpu_flags")) {
                $cpus = prox_cpu_flags($editvs["cpu_mode"]);
                $cpu_flags = [];
                foreach ($cpus["cpu_flags"] as $f) {
                    $cpu_flags = array_merge($cpu_flags, [$f => optREQ($f)]);
                }
                $editvs["cpu_flags"] = $cpu_flags;
            }
            if($kernel->features("os_type", $vps["virt"])) {
                isset_post("os_type");
                if(empty($editvs["os_type"])) {
                    $editvs["os_type"] = "other";
                }
            }
            if($kernel->features("balloon", $virt) && $cluster->check_feature($vps["serid"], $vps["virt"], "min_ram")) {
                $min_ram = (int) optPOST("min_ram");
                if(!empty($min_ram)) {
                    if($editvs["ram"] < $min_ram) {
                        $error[] = $l["min_ram_error"];
                        return false;
                    }
                    $editvs["min_ram"] = $min_ram;
                } else {
                    $editvs["min_ram"] = $editvs["ram"];
                }
            }
            if($kernel->features("machine_type", $vps["virt"])) {
                isset_post("machine_type", "");
            }
            if($kernel->features("scsihw", $vps["virt"])) {
                isset_post("scsi_controller", "");
            }
            if($kernel->features("rtc", $vps["virt"])) {
                isset_post("rtc", "", "int");
            }
            if($kernel->features("nested_virt", $vps["virt"])) {
                isset_post("nested_virt", "", "int");
            }
            if($kernel->features("vga_vram", $vps["virt"])) {
                isset_post("vga_vram", "", "int");
            }
            $editvs["vm_admin_name"] = username_vps($vps["osid"], $vps["data"], "", $vps["os_name"]);
            if($kernel->features("win_support", $vps["virt"])) {
                isset_post("vm_admin_name", "");
            }
            if($kernel->features("discard", $vps["virt"])) {
                isset_post("discard", "", "int");
            }
            if($kernel->features("vlan_tag", $vps["virt"])) {
                isset_post("vlan_tag", "", "int");
            }
            if(!empty($editvs["vlan_tag"]) && ($editvs["vlan_tag"] < 0 || 4094 < $editvs["vlan_tag"])) {
                $error[] = $l["vlan_tag_err"];
                return false;
            }
            if($kernel->features("ssd_emulation", $vps["virt"])) {
                $num_disk = optPOST("num_disks");
                $virtio = (int) optPOST("virtio");
                if($num_disk == 1 && $vps["disks"][0]["bus_driver"] == "virtio" && $_POST["ssd_emulation"] == 1 && $vps["virt"] == "proxk") {
                    $error[] = $l["ssd_does_not_support_" . $vps["virt"]];
                    return false;
                }
                if($_POST["ssd_emulation"] == 1 && $vps["virt"] == "kvm") {
                    if($cluster->os_check($vps["serid"], "centos", "<", 7) || $cluster->os_check($vps["serid"], "ubuntu", "<", 0)) {
                        $error[] = $l["ssd_emulation_not_support_" . $virt];
                        return false;
                    }
                    $qemu_version = $cluster->get_qemu_details($vps["serid"]);
                    $virtio_array = version_compare($qemu_version["libvirt_ver"], "7.3.0", "<") ? ["0", "1"] : ["1"];
                    if(in_array($virtio, $virtio_array)) {
                        $error[] = $l["ssd_does_not_support_" . $vps["virt"]];
                        return false;
                    }
                }
                isset_post("ssd_emulation", "", "int");
            }
            if($kernel->features("vertical_scaling", $virt) && check_licensepro() && is_billing_user($editvs["uid"])) {
                $enable_ver_scaling = (int) optPOST("enable_ver_scaling");
                $arr = ["ver_max_ram", "ver_ram_threshold", "ver_ram_inc_by", "ver_max_cpu", "ver_cpu_threshold", "ver_cpu_inc_by"];
                $from_globals = 0;
                if(empty($enable_ver_scaling) && !empty($globals["enable_ver_scaling"])) {
                    $enable_ver_scaling = 1;
                    $from_globals = 1;
                }
                if(!empty($enable_ver_scaling)) {
                    foreach ($arr as $v) {
                        if(!empty($from_globals)) {
                            $editvs[$v] = (int) optPOST($v);
                        } else {
                            $editvs[$v] = (int) POST($v, $l[$v . "_err"], 0);
                        }
                    }
                    $editvs["enable_ver_scaling"] = $enable_ver_scaling;
                }
            }
            if($kernel->features("bios", $virt)) {
                $editvs["bios"] = optPOST("bios");
                if(empty($editvs["bios"])) {
                    $editvs["bios"] = "seabios";
                }
                if(!empty($editvs["bios"]) && !in_array($editvs["bios"], ["seabios", "uefi"])) {
                    $error[] = $l["err_invalid_bios"];
                    return false;
                }
                $slave_conf = $cluster->config_get($vps["serid"]);
                if(preg_match("/uefi/is", $editvs["bios"]) && empty($slave_conf["globals"]["secure_efi_path"]) && $virt != "proxk") {
                    $error[] = $l["uefi_path_not_found"];
                    return false;
                }
                if(preg_match("/uefi/is", $editvs["bios"])) {
                    $editvs["enable_tpm"] = optREQ("enable_tpm");
                }
                if(preg_match("/" . $virt . "/", "kvm")) {
                    if(preg_match("/uefi/is", $editvs["bios"]) && empty($slave_conf["globals"]["secure_efi_path"])) {
                        $error[] = $l["uefi_path_not_found"];
                        return false;
                    }
                    if(preg_match("/uefi/is", $editvs["bios"]) && !empty($editvs["enable_tpm"]) && empty($resources["is_swtpm_installed"])) {
                        $error[] = $l["swtpm_not_found"];
                        return false;
                    }
                }
            }
            $additional_params = ["space", "ram", "bandwidth", "cores", "num_ips", "num_ips_int", "num_ips6", "num_ips6_subnet"];
            $additional_params = array_unique($additional_params);
            foreach ($additional_params as $ak => $av) {
                $tmp_additional = optREQ("additional_" . $av);
                if(empty($editvs[$av]) && !empty($editvs["plid"]) && !empty($tmp_additional)) {
                    $key = $av;
                    if(preg_match("/num_/is", $av)) {
                        $key = substr($av, 4);
                    }
                    if(!isset($_POST[$av])) {
                        $editvs[$av] = $plans[$editvs["plid"]][$key];
                    }
                    if(!isset($_POST[$av]) && in_array($av, ["num_ips", "num_ips_int", "num_ips6", "num_ips6_subnet"])) {
                        $_POST[$av] = $plans[$editvs["plid"]][$key];
                    }
                }
                if(!empty($tmp_additional)) {
                    $editvs[$av] = $editvs[$av] + $tmp_additional;
                    $_POST[$av] = $_POST[$av] + $tmp_additional;
                }
            }
            if(!empty($editvs["bpid"]) && $editvs["bpid"] != -1 && empty($backup_plans[$editvs["bpid"]])) {
                $error[] = $l["inv_bpid"];
            }
            if(!empty($editvs["admin_fwid"]) && empty($admin_firewall_plans[$editvs["admin_fwid"]])) {
                $error[] = $l["inv_fwid"];
            }
            if(!empty($editvs["fwid"]) && empty($enduser_firewall_plans[$editvs["fwid"]])) {
                $error[] = $l["inv_fwid"];
            }
            $bus_driver_dupes = [];
            if(isset($editvs["space"])) {
                if(json_decode($editvs["space"]) || json_decode($editvs["space"]) != NULL) {
                    $editvs["space"] = json_decode($editvs["space"], 1);
                }
                if(is_array($editvs["space"]) && !empty($editvs["space"])) {
                    foreach ($editvs["space"] as $k => $v) {
                        $v["size"] = (int) $v["size"];
                        if($k == 0 && 2000 <= $v["size"] && empty($globals["disable_2tb_check"]) && $vps["space"] < $v["size"]) {
                            $error[] = $l["err_max_size"];
                        }
                        if($v["size"] < 1 || empty($v["st_uuid"])) {
                            $error[] = $l["inv_space"];
                        }
                        if(empty($storages[$storage_uuids[$v["st_uuid"]]])) {
                            $error[] = $l["inv_storage"];
                        }
                        if($bus_driver) {
                            if(!array_key_exists($v["bus_driver"], $bus_driver)) {
                                $error[] = $l["inv_bus_driver"];
                            }
                            $v["bus_driver_num"] = (int) $v["bus_driver_num"];
                            $bus_driver_type = $v["bus_driver"] . $v["bus_driver_num"];
                            array_push($bus_driver_dupes, $bus_driver_type);
                        }
                    }
                    $editvs["space"] = array_values($editvs["space"]);
                    if($bus_driver) {
                        foreach ($editvs["space"] as $nk => $nv) {
                            if(empty($nv["bus_driver"])) {
                                $editvs["space"][$nk]["bus_driver"] = "sata";
                            }
                        }
                        if(count($bus_driver_dupes) != count(array_count_values($bus_driver_dupes))) {
                            $error[] = $l["inv_bus_driver_num_format"];
                        }
                    }
                } elseif(is_numeric($editvs["space"])) {
                    $tmp_space = $vps["disks"];
                    if(2000 <= $editvs["space"] && empty($globals["disable_2tb_check"]) && $tmp_space[0]["size"] < $editvs["space"]) {
                        $error[] = $l["err_max_size"];
                    }
                    if($kernel->features("multiple_disk_support", $vps["_virt"])) {
                        $tmp_primary = $editvs["space"] - $vps["space"] + $tmp_space[0]["size"];
                        if($tmp_space[0]["size"] < $tmp_primary) {
                            $tmp_space[0]["size"] = $tmp_primary;
                        } else {
                            $tmp_space[0]["size"] = (int) $editvs["space"];
                        }
                    } else {
                        $tmp_space[0]["st_uuid"] = $storages[$stid]["st_uuid"];
                        $tmp_space[0]["size"] = (int) $editvs["space"];
                        $tmp_space[0]["disk_uuid"] = $vps["disks"][0]["disk_uuid"];
                    }
                    if($bus_driver) {
                        $tmp_space[0]["bus_driver"] = $editvs["bus_driver"];
                        $tmp_space[0]["bus_driver_num"] = (int) $editvs["bus_driver_num"];
                    }
                    $editvs["space"] = $tmp_space;
                }
                if(count($editvs["space"]) < 1) {
                    $error[] = $l["no_disk_space"];
                }
                if(1 < count($editvs["space"]) && !$kernel->features("multiple_disk_support", $vps["_virt"])) {
                    $error[] = $l["mul_storage"];
                }
                $disks = $editvs["space"];
                foreach ($disks as $k => $v) {
                    $_stid = $storage_uuids[$v["st_uuid"]];
                    $storage_type = $storages[$_stid]["type"];
                    if(preg_match("/zfs/is", $storage_type)) {
                        if($v["size"] + 0 < 0) {
                        } else {
                            $dec_pos = strpos($v["size"], ".");
                            if($dec_pos++) {
                                $is_decimal = substr($v["size"], $dec_pos) + 0;
                                if(!empty($is_decimal)) {
                                    $error[] = "Error in disk - " . $v["disk_uuid"];
                                    $error[] = lang_vars_name($l["invalid_zfs_disk_size"], ["int_size" => (int) $v["size"], "decimal_size" => $v["size"]]);
                                    return false;
                                }
                            }
                        }
                    }
                }
                if($kernel->features("disks_support", $vps["virt"]) && ($disks[0]["st_uuid"] != $vps["disks"][0]["st_uuid"] || $disks[0]["disk_uuid"] != $vps["disks"][0]["disk_uuid"])) {
                    $error[] = $l["primary_disk_modified"];
                }
                $total_space = 0;
                $space_required = [];
                foreach ($disks as $k => $v) {
                    $space_required[$v["st_uuid"]] = $v["size"] + (int) $space_required[$v["st_uuid"]];
                    $total_space += $v["size"];
                }
                foreach ($vps["disks"] as $ok => $v) {
                    $space_required[$v["st_uuid"]] = (int) $space_required[$v["st_uuid"]] - $v["size"];
                }
                if(!$kernel->features("disks_support", $vps["virt"])) {
                    foreach ($space_required as $ok => $v) {
                        $space_required[$ok] = (int) $v - $vps["space"];
                    }
                }
                $editvs["space"] = $total_space;
                foreach ($space_required as $kk => $_space) {
                    if($_space < 1) {
                    } elseif($storages[$storage_uuids[$kk]]["disk_space"] < $_space) {
                        $error[] = $l["less_space"];
                    }
                }
            }
            if(isset($_POST["upload_speed"]) && (int) $_POST["upload_speed"] < 0) {
                $editvs["upload_speed"] = -1;
            }
            if(isset($editvs["speed_cap_down"]) || isset($editvs["speed_cap_up"])) {
                $_tbwsusp = !isset($editvs["band_suspend"]) ? $vps["band_suspend"] : $editvs["band_suspend"];
                $_tsd = isset($editvs["speed_cap_down"]) ? $editvs["speed_cap_down"] : $vps["speed_cap"]["down"];
                $_tsu = isset($editvs["speed_cap_up"]) ? $editvs["speed_cap_up"] : $vps["speed_cap"]["up"];
                $_tns = isset($editvs["network_speed"]) ? $editvs["network_speed"] : $vps["network_speed"];
                $_tus = isset($editvs["upload_speed"]) ? $editvs["upload_speed"] : $vps["upload_speed"];
                if(empty($_tbwsusp) && (!empty($_tsd) || !empty($_tsu))) {
                    validate_speed_cap($_tsd, $_tsu, $_tns, $_tus);
                    $editvs["speed_cap"]["down"] = $_tsd;
                    $editvs["speed_cap"]["up"] = $_tsu;
                    $editvs["speed_cap"] = serialize($editvs["speed_cap"]);
                } else {
                    $editvs["speed_cap"] = "";
                }
            }
            if(!empty($error)) {
                return false;
            }
            if(isset($_POST["mgs"])) {
                foreach ($_POST["mgs"] as $k => $v) {
                    $v = (int) $v;
                    if(empty($mgs[$v]) || $mgs[$v]["mg_type"] != $vps["_virt"]) {
                    } else {
                        $editvs["mg"][$v] = $v;
                    }
                }
                $editvs["mg"] = implode(",", $editvs["mg"]);
            }
            $demo_check = (int) optREQ("demo_edit");
            if($demo_check == 1) {
                $demo_date = POST("demo_date", $l["no_date"]);
                $demo_time = POST("demo_time", $l["no_time"]);
                $demo_action = (int) optPOST("demo_action", 0);
                if(!empty($demo_date) && !valid_date($demo_date)) {
                    $error["inv_date"] = $l["inv_demodate"];
                    return false;
                }
                $demo["time"] = valid_time($demo_time, $demo_date);
                $demo["action"] = $demo_action;
                if(empty($demo["time"])) {
                    $error["inv_time"] = $l["inv_demotime"];
                    return false;
                }
                if($demo["time"] < time()) {
                    $error["inv_time"] = $l["inv_demodate"];
                    return false;
                }
            }
            $vps["data"]["demo"] = $demo;
            isset_post("nic_type");
            isset_post("vif_type");
            if($kernel->features("mac_support", $vps["_virt"]) && isset($_POST["mac"])) {
                isset_post("mac");
                $maclen = strlen($editvs["mac"]);
                if(!empty($maclen)) {
                    if(!valid_mac($editvs["mac"])) {
                        $error["mac"] = $l["err_mac"];
                    }
                    $editvs["mac_status"] = 1;
                }
            }
            if($kernel->features("vnc_key_map", $vps["virt"]) && isset($_POST["vnc_keymap"])) {
                isset_post("vnc_keymap");
                if(!empty($editvs["vnc_keymap"]) && !in_array($editvs["vnc_keymap"], ["en-us", "de-ch", "ar", "da", "et", "fo", "fr-be", "fr-ch", "hu", "it", "lt", "mk", "nl", "no", "pt", "ru", "sv", "tr", "de", "en-gb", "es", "fi", "fr", "fr-ca", "hr", "is", "ja", "lv", "nl-be", "pl", "pt-br", "sl", "th"])) {
                    $error[] = $l["inv_vnc_keymap"];
                }
            }
            if($kernel->features("cpu_pinning", $vps["virt"]) && isset($_POST["cpupin"]) && is_array($_POST["cpupin"]) && !empty($resources["cpucores"])) {
                $cores = [];
                foreach ($_POST["cpupin"] as $k => $v) {
                    $v = (int) $v;
                    if($v < 0 || $resources["cpucores"] <= $v) {
                    } else {
                        $cores[$v] = $v;
                    }
                }
                $editvs["cpupin"] = implode(",", $cores);
            }
            if($kernel->features("tun_tap", $virt)) {
                isset_req("tuntap", "", "int");
            }
            if($kernel->features("ha", $vps["virt"])) {
                isset_req("ha", "", "int");
            }
            if($kernel->features("virtio", $virt)) {
                if(isset($_POST["virtio"])) {
                    $virtio = (int) optPOST("virtio");
                } else {
                    $virtio = (int) $vps["virtio"];
                }
                $editvs["virtio"] = $virtio;
                if(!empty($editvs["bios"]) && preg_match("/uefi/is", $editvs["bios"]) && empty($editvs["virtio"])) {
                    $error[] = $l["err_ide_not_support"];
                    return false;
                }
            }
            if($kernel->features("openvz_features", $virt)) {
                isset_req("ppp", "", "int");
                $openvz_features["fuse"] = isset($_REQUEST["fuse"]) ? (int) optREQ("fuse") : $vps["openvz_features"]["fuse"];
                $openvz_features["ipip"] = isset($_REQUEST["ipip"]) ? (int) optREQ("ipip") : $vps["openvz_features"]["ipip"];
                $openvz_features["ipgre"] = isset($_REQUEST["ipgre"]) ? (int) optREQ("ipgre") : $vps["openvz_features"]["ipgre"];
                $openvz_features["nfs"] = isset($_REQUEST["nfs"]) ? (int) optREQ("nfs") : $vps["openvz_features"]["nfs"];
                $openvz_features["quotaugidlimit"] = isset($_REQUEST["quotaugidlimit"]) ? (int) optREQ("quotaugidlimit") : $vps["openvz_features"]["quotaugidlimit"];
                $openvz_features["iolimit"] = isset($_REQUEST["iolimit"]) ? (int) optREQ("iolimit") : $vps["openvz_features"]["iolimit"];
                $openvz_features["iopslimit"] = isset($_REQUEST["iopslimit"]) ? (int) optREQ("iopslimit") : $vps["openvz_features"]["iopslimit"];
                $openvz_features["netfilter"] = isset($_REQUEST["netfilter"]) ? optPOST("netfilter") : $vps["openvz_features"]["netfilter"];
                $editvs["openvz_features"] = serialize($openvz_features);
            }
            if($virt == "openvz" || $virt == "proxo") {
                isset_post("io", "priority", "int");
                isset_post("cpu", "", "int");
                isset_post("burst", "", "int");
                isset_post("cpu_percent", "", "int");
                isset_req("ploop", "", "int");
                if(isset($_POST["burst"]) && $editvs["burst"] == 0 && distro_check(1)) {
                    $error["no_burst_ram"] = $l["no_burst_ram"];
                }
            } elseif($vps["virt"] == "xen" && empty($vps["hvm"])) {
                isset_req("vnc", "", "int");
                isset_post("swap", "swapram", "int");
                isset_post("cpu", "", "int");
                isset_post("cpu_percent", "", "int");
            } elseif($vps["virt"] == "xen" && !empty($vps["hvm"]) || $vps["virt"] == "kvm" || $vps["virt"] == "xcp" || $vps["virt"] == "proxk") {
                isset_req("vnc", "", "int");
                isset_post("swap", "swapram", "int");
                isset_req("acpi", "", "int");
                isset_req("apic", "", "int");
                isset_req("pae", "", "int");
                if(isset($_REQUEST["boot"])) {
                    $editvs["boot"] = optPOST("boot") == "dca" ? "dca" : "cda";
                }
                isset_post("cpu_percent", "", "int");
                if(isset($_POST["iso"])) {
                    $editvs["iso"] = optPOST("iso");
                    if(pathinfo($editvs["iso"], PATHINFO_EXTENSION) == "iso") {
                        foreach ($isos as $iok => $iov) {
                            if($iov["filename"] == $editvs["iso"]) {
                                $editvs["iso"] = $iok;
                            }
                        }
                    }
                    if(empty($isos[$editvs["iso"]])) {
                        $editvs["iso"] = "";
                    }
                }
                if($vps["virt"] == "kvm" || $vps["virt"] == "proxk") {
                    isset_post("cpu", "", "int");
                    if($kernel->features("kvm_cache", $vps["virt"]) && isset($_POST["kvm_cache"])) {
                        isset_post("kvm_cache");
                        if(!empty($editvs["kvm_cache"]) && !in_array($editvs["kvm_cache"], ["default", "writeback", "writethrough", "directsync"])) {
                            $error[] = $l["inv_kvm_cache"];
                        }
                    }
                    if($kernel->features("io_mode", $vps["virt"])) {
                        isset_post("io_mode");
                        if(!empty($editvs["io_mode"]) && !in_array($editvs["io_mode"], ["native", "threads", "io_uring"])) {
                            $error[] = $l["inv_io_mode"];
                        }
                        if(!empty($editvs["io_mode"]) && preg_match("/" . $editvs["io_mode"] . "/is", "io_uring") && !$cluster->check_iouring($vps["serid"])) {
                            $error[] = $l["inv_io_uring"];
                        }
                    }
                    if($kernel->features("iops_sec", $virt)) {
                        isset_post("total_iops_sec", "", "int");
                        isset_post("read_bytes_sec", "", "int");
                        isset_post("write_bytes_sec", "", "int");
                    }
                    if(isset($_POST["kvm_vga"])) {
                        isset_req("kvm_vga", "", "int");
                        $editvs["acceleration"] = 0;
                        if(!empty($editvs["kvm_vga"])) {
                            isset_req("acceleration", "", "int");
                        }
                    }
                    if($vps["virt"] == "proxk" && in_array($editvs["cpu_mode"], ["host-model", "host-passthrough"])) {
                        $editvs["cpu_mode"] = "host";
                    }
                    if(!empty($editvs["cpu_mode"]) && empty($cpu_modes[$editvs["cpu_mode"]])) {
                        $error[] = $l["inv_cpu_mode"];
                        return false;
                    }
                    if(4 <= count($disks) && (!empty($editvs["sec_iso"]) || !empty($editvs["iso"])) && (empty($editvs["virtio"]) || $editvs["virtio"] == 3)) {
                        $error[] = $l["kvm_ide_limit"];
                        return false;
                    }
                } elseif($vps["virt"] == "xcp") {
                    isset_post("cpu", "", "int");
                } else {
                    isset_post("cpu", "", "int");
                    isset_post("shadow", "", "int");
                }
                if($kernel->features("cpu_topology", $vps["virt"])) {
                    isset_post("topology_sockets", "", "int");
                    isset_post("topology_cores", "", "int");
                    isset_post("topology_threads", "", "int");
                    if(!empty($editvs["topology_sockets"]) || !empty($editvs["topology_cores"]) || !empty($editvs["topology_threads"])) {
                        if(!$kernel->features("cpu_threads", $vps["virt"])) {
                            $editvs["topology_threads"] = 1;
                        }
                        if(empty($editvs["topology_sockets"]) || empty($editvs["topology_cores"]) || empty($editvs["topology_threads"])) {
                            $error[] = $l["inv_topology"];
                            return false;
                        }
                        $vcpus = $editvs["topology_sockets"] * $editvs["topology_cores"] * $editvs["topology_threads"];
                        if($editvs["cores"] != $vcpus) {
                            $error[] = $l["err_topology_calc"];
                            return false;
                        }
                    }
                }
                if($kernel->features("numa", $vps["_virt"])) {
                    isset_post("numa", "", "int");
                }
                if(isset($editvs["swap"]) && $disks[0]["size"] * 1024 - $editvs["swap"] < $vps["disks"][0]["size"] * 1024 - $vps["swap"]) {
                    $error[] = $l["err_effective_space"];
                }
                if($vps["virt"] == "xen" && !empty($vps["hvm"])) {
                    isset_req("pv_on_hvm", "", "int");
                }
            } elseif($virt == "lxc" || $virt == "proxl") {
                isset_post("cpu", "", "int");
                isset_post("swap", "swapram", "int");
                if($virt == "proxl") {
                    isset_post("cpu_percent", "", "int");
                }
                if(isset($editvs["cores"]) && $resources["cpucores"] < $editvs["cores"]) {
                    $error[] = $l["err_cores_more"] . $resources["cpucores"];
                }
                if(preg_match("/file/is", $storages[$storage_uuids[$disks[0]["st_uuid"]]]["type"]) && $virt != "proxl") {
                    $error[] = $l["lxc_file_support"];
                }
            } elseif($virt == "vzk" || $virt == "vzo") {
                isset_post("io", "priority", "int");
                isset_post("cpu", "", "int");
                isset_post("swap", "swapram", "int");
                isset_post("cpu_percent", "", "int");
                isset_req("vnc", "", "int");
                if(isset($editvs["swap"]) && $disks[0]["size"] * 1024 - $editvs["swap"] < $vps["disks"][0]["size"] * 1024 - $vps["swap"]) {
                    $error[] = $l["err_effective_space"];
                }
                if($virt == "vzk") {
                    isset_post("iso");
                    if(isset($_REQUEST["boot"])) {
                        $editvs["boot"] = optPOST("boot") == "dca" ? "dca" : "cda";
                    }
                }
                if($resources["cpucores"] < $editvs["cores"]) {
                    $error[] = $l["err_cores_more"] . $resources["cpucores"];
                }
            }
            if(isset($editvs["sec_iso"]) && $kernel->features("sec_iso_support", $vps["virt"])) {
                if(pathinfo($editvs["sec_iso"], PATHINFO_EXTENSION) == "iso") {
                    foreach ($isos as $iok => $iov) {
                        if($iov["filename"] == $editvs["sec_iso"]) {
                            $editvs["sec_iso"] = $iok;
                        }
                    }
                }
                if(empty($isos[$editvs["sec_iso"]])) {
                    $editvs["sec_iso"] = "";
                }
            }
            isset_post("disable_ebtables", "", "int");
            if(isset($editvs["webuzo"])) {
                if(!empty($iscripts[$editvs["webuzo"]])) {
                    if($ostemplates[$vps["osid"]]["distro"] != "webuzo") {
                        $error[] = $l["no_webuzo_template"];
                    }
                } else {
                    $editvs["webuzo"] = 0;
                }
            }
            if($kernel->features("boot_order", $vps["_virt"])) {
                $bootorder = optPOST("bootord");
                if(!empty($bootorder)) {
                    $order = cexplode(",", $bootorder);
                    if(!empty($order) && is_array($order)) {
                        $valid_order = preg_grep("/disk\\d|cdrom[1-2]/", $order);
                        if(count($valid_order) != count($order)) {
                            $error[] = $l["invalid_boot_order"];
                            return false;
                        }
                        $editvs["boot"] = serialize($order);
                    }
                }
            }
            if(isset($editvs["ram"])) {
                if(empty($editvs["ram"])) {
                    $error[] = $l["no_ram"];
                }
                if(!empty($resources["overcommit"])) {
                    $editvs_ram = $editvs["ram"] - $vps["ram"];
                } else {
                    $vpsstatus = $cluster->vps_status([$vps["vpsid"] => $vps["serid"]]);
                    $vpsstatus = $vpsstatus[$vps["vpsid"]];
                    $editvs_ram = empty($vpsstatus) ? $editvs["ram"] : $editvs["ram"] - $vps["ram"];
                }
                if((empty($resources["overcommit"]) ? $resources["ram"] : $resources["overcommit"] - $servers[$vps["serid"]]["alloc_ram"]) < $editvs_ram) {
                    $error[] = $l["less_ram"];
                }
            }
            if(!isset($disks) && !empty($vps["swap"]) && isset($editvs["swap"]) && $editvs["swap"] < $vps["swap"]) {
                $error[] = $l["err_shrink_swap"];
                return false;
            }
            if($kernel->features("disks_support", $vps["virt"]) && isset($disks)) {
                $old_disks = [];
                foreach ($vps["disks"] as $k => $v) {
                    $old_disks[$v["disk_uuid"]] = $v;
                }
                $new_disks = [];
                $editvs["disks"] = $disks;
                foreach ($editvs["disks"] as $k => $v) {
                    $this_disk_storage = $storages[$storage_uuids[$v["st_uuid"]]];
                    unset($editvs["disks"][$k]["stid"]);
                    if(!empty($old_disks[$v["disk_uuid"]])) {
                        $editvs["disks"][$k] = $old_disks[$v["disk_uuid"]];
                        if($disks[$k]["size"] < $old_disks[$v["disk_uuid"]]["size"]) {
                            $error[] = $l["err_space"];
                        }
                    }
                    if($disks[0]["size"] == $old_disks[$disks[0]["disk_uuid"]]["size"] && !empty($vps["swap"]) && isset($editvs["swap"]) && $editvs["swap"] < $vps["swap"]) {
                        $error[] = $l["err_shrink_swap"];
                        return false;
                    }
                    $editvs["disks"][$k]["size"] = $disks[$k]["size"];
                    $editvs["disks"][$k]["num"] = $k;
                    if(empty($editvs["disks"][$k]["disk_uuid"])) {
                        $vps["current_disk_num"] = $k;
                        $disk_uuid = "d" . generateRandStr(15);
                        $editvs["disks"][$k] = vps_disk_struct();
                        $editvs["disks"][$k]["primary"] = 0;
                        $editvs["disks"][$k]["path"] = vpsdisk_path_build("-" . $disk_uuid, $this_disk_storage, $vps);
                        $editvs["disks"][$k]["type"] = $this_disk_storage["type"];
                        $editvs["disks"][$k]["format"] = $this_disk_storage["format"];
                        $editvs["disks"][$k]["size"] = $disks[$k]["size"];
                        $editvs["disks"][$k]["vpsid"] = $vps["vpsid"];
                        $editvs["disks"][$k]["st_uuid"] = $this_disk_storage["st_uuid"];
                        $editvs["disks"][$k]["disk_uuid"] = $disk_uuid;
                        $editvs["disks"][$k]["bus_driver"] = $disks[$k]["bus_driver"];
                        $editvs["disks"][$k]["bus_driver_num"] = (int) $disks[$k]["bus_driver_num"];
                        $editvs["disks"][$k]["num"] = $k;
                        $disks_to_create[$disk_uuid] = $disk_uuid;
                    }
                    $new_disks[$editvs["disks"][$k]["disk_uuid"]] = $editvs["disks"][$k];
                }
                if($vps["virt"] == "xen" && empty($vps["hvm"]) && 0 < $editvs["swap"]) {
                    if(empty($vps["disks"][1])) {
                        $_stid = $storage_uuids[$disks[0]["st_uuid"]];
                        $sdisk_uuid = "d" . generateRandStr(15);
                        $editvs["disks"][1]["primary"] = 0;
                        $editvs["disks"][1]["path"] = vpsdisk_path_build("swap-" . $disk_uuid, $storages[$_stid], $vps);
                        $editvs["disks"][1]["type"] = $storages[$_stid]["type"];
                        $editvs["disks"][1]["format"] = $storages[$_stid]["format"];
                        $editvs["disks"][1]["size"] = $editvs["swap"];
                        $editvs["disks"][1]["size_unit"] = "M";
                        $editvs["disks"][1]["vpsid"] = $editvs["vpsid"];
                        $editvs["disks"][1]["st_uuid"] = $storages[$_stid]["st_uuid"];
                        $editvs["disks"][1]["disk_uuid"] = $sdisk_uuid;
                        $editvs["disks"][1]["num"] = 1;
                        $disks_to_create[$disk_uuid] = $disk_uuid;
                    } else {
                        $editvs["disks"][1] = $vps["disks"][1];
                        $editvs["disks"][1]["size"] = $editvs["swap"];
                    }
                    $new_disks[$editvs["disks"][1]["disk_uuid"]] = $editvs["disks"][1];
                }
                foreach ($old_disks as $k => $v) {
                    if(empty($new_disks[$k]) && empty($v["primary"]) && !preg_match("/swap/is", $v["path"]) && empty($v["user_uid"])) {
                        $disks_to_delete[$k] = $v;
                    }
                    if(!empty($v["user_uid"]) && empty($new_disks[$k]) && empty($v["primary"]) && !preg_match("/swap/is", $v["path"])) {
                        $error[] = $l["err_vol_delete"];
                    }
                }
            }
            $sata_disk_count = 0;
            foreach ($disks as $dk => $dv) {
                if(strtolower($dv["bus_driver"]) == "sata") {
                    $sata_disk_count++;
                }
            }
            if($vps["virt"] == "proxk" && 4 < $sata_disk_count) {
                $error[] = "Maximum 4 SATA Disk allowed in ProxMox for now";
            }
            if(!empty($error)) {
                return false;
            }
            if(isset($_POST["uid"])) {
                $editvs["uid"] = (int) optPOST("uid");
                if(0 < $editvs["uid"]) {
                    $qres = makequery("SELECT *\tFROM `users`\n\t\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $editvs["uid"]]);
                    if(vsql_num_rows($qres) < 1) {
                        $error["invalid_uid"] = $l["invalid_uid"];
                        return false;
                    }
                } else {
                    $user_email = optPOST("user_email");
                    $user_pass = optPOST("user_pass");
                    $prefs["fname"] = optPOST("fname");
                    $prefs["lname"] = optPOST("lname");
                    $dnsplid = (int) optPOST("dnsplid");
                    $preferences = serialize($prefs);
                    if(empty($user_email)) {
                        $error["no_user"] = $l["no_user"];
                    }
                    if(empty($user_pass)) {
                        $error["no_user_pass"] = $l["no_user_pass"];
                    }
                    if(!empty($error)) {
                        return false;
                    }
                    if(!emailvalidation($user_email)) {
                        $error["invalid_email"] = $l["invalid_email"];
                        return false;
                    }
                    $qres = makequery("SELECT email \n\t\t\t\t\t\t\t\tFROM users \n\t\t\t\t\t\t\t\tWHERE email = :user_email", [":user_email" => $user_email]);
                    if(0 < vsql_num_rows($qres)) {
                        $error[] = $l["emailexist"];
                        return false;
                    }
                    $editvs["uid"] = insert_and_id("INSERT INTO users \n\t\t\t\t\t\t\t\tSET\ttype = '0',\n\t\t\t\t\t\t\t\tpassword = :password,\n\t\t\t\t\t\t\t\temail = :email,\n\t\t\t\t\t\t\t\tpreferences = :preferences,\n\t\t\t\t\t\t\t\tdnsplid = :dnsplid", [":password" => crypt($user_pass), ":email" => $user_email, ":preferences" => $preferences, ":dnsplid" => empty($dnsplid) ? 0 : $dnsplid]);
                    if(empty($editvs["uid"])) {
                        $error["err_user"] = $l["err_user"];
                        return false;
                    }
                    logs_admin("adduser", $user_email, 1, $editvs["uid"], $editvs["uid"]);
                }
            }
            if(isset($editvs["hostname"]) && preg_match("/[^A-Za-z0-9_\\-\\.]/is", $editvs["hostname"])) {
                $error[] = $l["invalid_hostname"];
                return false;
            }
            $_ips_cnt = optPOST("num_ips");
            if(isset($_POST["num_ips"]) && empty($_POST["ips"][0])) {
                if($_ips_cnt < count($vps["ips"])) {
                    $i = 0;
                    $num_ips = [];
                    foreach ($vps["ips"] as $k => $v) {
                        if($_ips_cnt == $i) {
                            $_POST["ips"] = $num_ips;
                        } else {
                            $num_ips[$k] = $v;
                            $i++;
                        }
                    }
                } elseif(count($vps["ips"]) < $_ips_cnt) {
                    $toadd = $_ips_cnt - count($vps["ips"]);
                    $_POST["ips"] = array_values($vps["ips"]);
                    foreach ($ips as $k => $v) {
                        if(in_array($v["ip"], $vps["ips"])) {
                        } else {
                            $_POST["ips"][] = $v["ip"];
                            if($_ips_cnt == count($_POST["ips"])) {
                            }
                        }
                    }
                } else {
                    $_POST["ips"] = $vps["ips"];
                }
            }
            $_ips_int_cnt = optPOST("num_ips_int");
            if(isset($_POST["num_ips_int"]) && empty($_POST["ips_int"][0])) {
                if($_ips_int_cnt < count($vps["ips_int"])) {
                    $i = 0;
                    $num_ips_int = [];
                    foreach ($vps["ips_int"] as $k => $v) {
                        if($_ips_int_cnt == $i) {
                            $_POST["ips_int"] = $num_ips_int;
                        } else {
                            $num_ips_int[$k] = $v;
                            $i++;
                        }
                    }
                } elseif(count($vps["ips_int"]) < $_ips_int_cnt) {
                    $toadd = $_ips_int_cnt - count($vps["ips_int"]);
                    $_POST["ips_int"] = array_values($vps["ips_int"]);
                    foreach ($ips_int as $k => $v) {
                        if(in_array($v["ip"], $vps["ips_int"])) {
                        } else {
                            $_POST["ips_int"][] = $v["ip"];
                            if($_ips_int_cnt == count($_POST["ips_int"])) {
                            }
                        }
                    }
                } else {
                    $_POST["ips_int"] = $vps["ips_int"];
                }
            }
            $_ips6_cnt = optPOST("num_ips6");
            $tmp_sdk_ips6 = $_POST["ips6"];
            if(is_array($tmp_sdk_ips6) && !empty($tmp_sdk_ips6) && empty($_POST["ipv6"][0])) {
                $_POST["ipv6"] = array_values($tmp_sdk_ips6);
            }
            if(isset($_POST["num_ips6"]) && empty($_POST["ipv6"][0])) {
                if($_ips6_cnt < count($vps["ipv6"])) {
                    $i = 0;
                    $num_ips6 = [];
                    foreach ($vps["ipv6"] as $k => $v) {
                        if($_ips6_cnt == $i) {
                            $_POST["ipv6"] = $num_ips6;
                        } else {
                            $num_ips6[] = $v;
                            $i++;
                        }
                    }
                } elseif(count($vps["ipv6"]) < $_ips6_cnt) {
                    $toadd = $_ips6_cnt - count($vps["ipv6"]);
                    $_POST["ipv6"] = array_values($vps["ipv6"]);
                    foreach ($ips6 as $k => $v) {
                        if(in_array($v["ip"], $vps["ipv6"])) {
                        } else {
                            $_POST["ipv6"][] = $v["ip"];
                            if($_ips6_cnt == count($_POST["ipv6"])) {
                            }
                        }
                    }
                } else {
                    $_POST["ipv6"] = $vps["ipv6"];
                }
            }
            $_ips6_subnet_cnt = optPOST("num_ips6_subnet");
            $tmp_sdk_ips6_subnet = $_POST["ips6_subnet"];
            if(is_array($tmp_sdk_ips6_subnet) && !empty($tmp_sdk_ips6_subnet) && empty($_POST["ipv6_subnet"][0])) {
                $tmp_sdk_ips6_subnet = array_values($tmp_sdk_ips6_subnet);
                foreach ($tmp_sdk_ips6_subnet as $k => $v) {
                    $_tmp_ips6_subnet = explode("/", $v);
                    $tmp_sdk_ips6_subnet[$k] = $_tmp_ips6_subnet[0];
                }
                $_POST["ipv6_subnet"] = $tmp_sdk_ips6_subnet;
            }
            if(isset($_POST["num_ips6_subnet"]) && empty($_POST["ipv6_subnet"][0])) {
                if($_ips6_subnet_cnt < count($vps["ips6_subnet"])) {
                    $i = 0;
                    $num_ips6_subnet = [];
                    foreach ($vps["ips6_subnet"] as $k => $v) {
                        if($_ips6_subnet_cnt == $i) {
                            $_POST["ipv6_subnet"] = $num_ips6_subnet;
                        } else {
                            $tmp = explode("/", $v);
                            $num_ips6_subnet[] = $tmp[0];
                            $i++;
                        }
                    }
                } elseif(count($vps["ips6_subnet"]) < $_ips6_subnet_cnt) {
                    $toadd = $_ips6_subnet_cnt - count($vps["ips6_subnet"]);
                    $_POST["ipv6_subnet"] = array_values($vps["ipv6_subnet"]);
                    foreach ($ips6_subnet as $k => $v) {
                        if(in_array($v["ip"], $vps["ips6_subnet"])) {
                        } else {
                            $_POST["ipv6_subnet"][] = $v["ip"];
                            if($_ips6_subnet_cnt == count($_POST["ipv6_subnet"])) {
                            }
                        }
                    }
                } else {
                    $_POST["ipv6_subnet"] = $tmp_ips6_subnet;
                }
            }
            $locked = [];
            $posted_ips = [];
            $tmp_posted_ips = ["ips", "ipv6", "ips_int", "ipv6_subnet"];
            foreach ($tmp_posted_ips as $pk => $pv) {
                if(is_array($_POST[$pv]) && !empty($_POST[$pv])) {
                    foreach ($_POST[$pv] as $pvv) {
                        $posted_ips[] = $pvv;
                    }
                }
            }
            $res = makequery("SELECT * FROM ips WHERE ip IN ('" . implode("', '", array_values($posted_ips)) . "') AND locked=1");
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $locked[] = $row["ip"];
            }
            if(!empty($locked)) {
                $vps_all_ips = [];
                foreach (["ips", "ips_int", "ips6", "ips6_subnet"] as $k => $v) {
                    if(!empty($vps[$v]) && is_array($vps[$v])) {
                        $vps_temp = $vps[$v];
                        if($v == "ips6_subnet") {
                            foreach ($vps_temp as $kk => $vv) {
                                $tmp_ip = explode("/", $vv);
                                $vps_temp[$kk] = $tmp_ip[0];
                            }
                        }
                        $vps_all_ips = array_merge($vps_all_ips, $vps_temp);
                    }
                }
                if(!empty($vps_all_ips)) {
                    foreach ($locked as $k => $v) {
                        if(in_array($v, $vps_all_ips)) {
                            unset($locked[$k]);
                        }
                    }
                }
                if(!empty($locked)) {
                    $error["locked_ips"] = $l["lockedips"] . ":<br />" . implode(", ", $locked);
                    return false;
                }
            }
            $pips = [];
            if(isset($_POST["ips"])) {
                $_POST["ips"] = !is_array($_POST["ips"]) ? [] : $_POST["ips"];
            }
            $invalid = [];
            foreach ($_POST["ips"] as $value) {
                if(empty($value)) {
                } else {
                    if(!valid_ip($value)) {
                        $invalid[] = $value;
                    }
                    $pips[] = $value;
                }
            }
            if(!empty($globals["max_ipv4s"]) && $globals["max_ipv4s"] < count($pips)) {
                $error["max_ipv4s"] = $l["err_max_ipv4s"] . $globals["max_ipv4s"];
                return false;
            }
            $pips6 = [];
            if(0 < @count($_POST["ipv6"]) && !empty($_POST["ipv6"][0])) {
                $pips6 = $_POST["ipv6"];
                foreach ($pips6 as $value) {
                    if(!valid_ipv6($value)) {
                        $invalid[] = $value;
                    }
                }
            }
            if(!empty($globals["max_ipv6s"]) && $globals["max_ipv6s"] < count($pips6)) {
                $error["max_ipv6s"] = $l["err_max_ipv6s"] . $globals["max_ipv6s"];
                return false;
            }
            $pips_int = [];
            if(!empty($ips_int)) {
                foreach ($ips_int as $kk => $vv) {
                    $_ips_int[$kk] = $vv["ip"];
                }
                foreach ($vps["ips_int"] as $kk => $vv) {
                    $_ips_int[$kk] = $vv;
                }
                if(isset($_POST["ips_int"])) {
                    $_POST["ips_int"] = !is_array($_POST["ips_int"]) ? [] : $_POST["ips_int"];
                    foreach ($_POST["ips_int"] as $value) {
                        if(empty($value)) {
                        } else {
                            if(!valid_ip($value) || !in_array($value, $_ips_int)) {
                                $invalid[] = $value;
                            }
                            $pips_int[] = $value;
                        }
                    }
                }
            }
            if(!empty($globals["max_internal_ips"]) && $globals["max_internal_ips"] < count($pips_int)) {
                $error["max_internal_ips"] = $l["err_max_internal_ips"] . $globals["max_internal_ips"];
                return false;
            }
            if(!empty($invalid)) {
                $error[] = $l["invalid_ip"] . "<br />" . implode(", ", $invalid);
                return false;
            }
            $pips6_subnet = [];
            if(isset($_POST["ipv6_subnet"]) && 0 < @count($_POST["ipv6_subnet"]) && !empty($_POST["ipv6_subnet"][0])) {
                $pips6_subnet = $_POST["ipv6_subnet"];
                foreach ($pips6_subnet as $value) {
                    if(!valid_ipv6($value)) {
                        $invalid[] = $value;
                    }
                }
            }
            if(!empty($globals["max_ipv6_subnets"]) && $globals["max_ipv6_subnets"] < count($pips6_subnet)) {
                $error["max_ipv6_subnets"] = $l["err_max_ipv6_subnets"] . $globals["max_ipv6_subnets"];
                return false;
            }
            if(!empty($invalid)) {
                $error["invalid_ip_subnet"] = $l["invalid_ip_subnet"] . "<br />" . implode(", ", $invalid);
                return false;
            }
            if(isset($pips[0]) && empty($pips[0]) && isset($pips6) && empty($pips6) && isset($pips6_subnet) && empty($pips6_subnet) && isset($pips_int) && empty($pips_int)) {
                $error["no_ip"] = $l["no_ip"];
                return false;
            }
            $sel_query = "";
            $sel_token = [];
            $ippid_chk = vsql_in_tokens($ippid);
            if(!empty($pips_int)) {
                $ippid_chk = vsql_in_tokens(array_merge($ippid, $is_internal_pool));
                $sel_query = " AND ip.ippid IN (0, " . $ippid_chk["query"] . ")";
                $sel_token = $ippid_chk["tokens"];
            }
            $qres = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.ip IN('" . implode("','", array_merge($pips, $pips6, $pips6_subnet, $pips_int)) . "')" . $sel_query . "\n\t\t\t\t\tORDER BY `primary` DESC", $sel_token);
            $usedips = [];
            $unusedip = [];
            $dnsip = [];
            for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
                $dnsip[$i] = $row = vsql_fetch_assoc($qres);
                if(empty($row["vpsid"]) || $row["vpsid"] == $vpsid) {
                    $unusedip[] = $row["ip"];
                } elseif(!empty($row["ipr_netmask"])) {
                    $used_subnets[] = $row["ip"];
                } else {
                    $usedips[] = $row["ip"];
                }
            }
            if(!empty($usedips)) {
                $error[] = $l["used_ip"] . "<br />" . implode(", ", $usedips);
                return false;
            }
            if(!empty($used_subnets)) {
                $error["used_ip_subnet"] = $l["used_ip_subnet"] . "<br />" . implode(", ", $used_subnets);
                return false;
            }
            $old_ips = [];
            $new_ips = [];
            $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid)\n\t\t\t\t\t\t\t\tWHERE i.vpsid = :vpsid\n\t\t\t\t\t\t\t\tORDER BY `primary` DESC", [":vpsid" => $vpsid]);
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $_ips[$i] = vsql_fetch_assoc($res);
                $old_ips[$i] = $_ips[$i]["ip"];
            }
            $new_ips = array_merge($pips, $pips_int);
            $ips_changed = 0;
            if(array_diff($old_ips, $new_ips) || array_diff($new_ips, $old_ips)) {
                $ips_changed = 1;
            }
            if(isset($editvs["admin_fwid"]) || isset($editvs["fwid"]) || !empty($ips_changed) && (!empty($vps["admin_fwid"]) || !empty($vps["fwid"]))) {
                $tmp_rules = [];
                $tmp_policies = [];
                if(!empty($vps["admin_fwid"])) {
                    $tmp_rules = json_decode($admin_firewall_plans[$vps["admin_fwid"]]["rules"], 1);
                    array_push($tmp_policies, $admin_firewall_plans[$vps["admin_fwid"]]["default_policy"]);
                }
                if(!empty($vps["fwid"])) {
                    if(!empty($tmp_rules)) {
                        $tmp_rules = array_merge($tmp_rules, json_decode($enduser_firewall_plans[$vps["fwid"]]["rules"], 1));
                    } else {
                        $tmp_rules = json_decode($enduser_firewall_plans[$vps["fwid"]]["rules"], 1);
                    }
                    array_push($tmp_policies, $enduser_firewall_plans[$vps["fwid"]]["default_policy"]);
                }
                if(!empty($tmp_rules)) {
                    $firewall_data = ["rules" => json_encode($tmp_rules), "policy" => $tmp_policies];
                    $cluster->delete_vpsfirewall_rule($vps["serid"], [$vpsid], $firewall_data);
                }
            }
            if(isset($_POST["dns"])) {
                $dns = $_POST["dns"];
                $_dns = [];
                if(!empty($dns[0])) {
                    foreach ($dns as $key => $value) {
                        if(!empty($value) && (valid_ip($value) || valid_ipv6($value))) {
                            $_dns[] = $value;
                        }
                    }
                }
                $editvs["dns_nameserver"] = serialize($_dns);
            }
            if(isset($editvs["cores"]) && empty($editvs["cores"])) {
                $error["empty_cores"] = $l["inv_cpu_cores"] . " : " . $editvs["cores"];
            }
            $node_global_config = $cluster->config_get($vps["serid"]);
            if(isset($editvs["cores"]) && !empty($node_global_config["globals"]["vcores"])) {
                $res = makequery("SELECT SUM(cores) as used_cores FROM vps \n\t\t\t\t\t\t\tWHERE serid = :serid\n\t\t\t\t\t\t\tAND vpsid != :vpsid ", [":serid" => $vps["serid"], ":vpsid" => $vps["vpsid"]]);
                $row = vsql_fetch_assoc($res);
                if($node_global_config["globals"]["vcores"] < $row["used_cores"] + $editvs["cores"]) {
                    $error[] = $l["vcores_limit_exceeded"];
                    return false;
                }
            }
            if($kernel->features("enable_guest_agent", $vps["virt"])) {
                $editvs["enable_guest_agent"] = empty($node_global_config["globals"]["disable_guest_agent"]) ? 1 : 0;
            }
            $fields = ["ram" => "gram", "space" => "hdd", "burst" => "bram", "swap" => "swap", "cores" => "cores", "cpu" => "cpunit", "cpu_percent" => "percent", "network_speed" => "network_speed", "upload_speed" => "upload_speed", "cpu_threshold" => "cpu_threshold", "cpu_threshold_time" => "cpu_threshold_time"];
            foreach ($fields as $field_k => $field_v) {
                if($editvs[$field_k] == -1 && in_array($field_k, ["upload_speed"])) {
                } elseif(!empty($editvs[$field_k]) && $editvs[$field_k] < 0) {
                    $error[] = $l["err_negative_val"] . " : " . $l[$field_v] . " (" . $editvs[$field_k] . ")";
                }
            }
            $cputhreshold = (int) $editvs["cpu_threshold"];
            if(!empty($editvs["enable_cpu_threshold"])) {
                if(100 < $cputhreshold || empty($cputhreshold)) {
                    $error[] = $l["percent_err_threshold"];
                }
                if($editvs["cpu_threshold_time"] % 5 !== 0 || empty($editvs["cpu_threshold_time"])) {
                    $error[] = $l["time_err_threshold"];
                }
            } else {
                $editvs["cpu_threshold"] = 0;
                $editvs["cpu_threshold_time"] = 0;
            }
            if(!empty($error)) {
                return false;
            }
            if(!empty($globals["openvz7_auto_vnc"]) && $kernel->features("vnc_auto_port", $vps["virt"])) {
                $editvs["vnc_auto_port"] = 1;
            }
            if(!empty($globals["save_vm_pass"]) && !empty($editvs["pass"]) && (empty($_REQUEST["vm_admin_name"]) || in_array($_REQUEST["vm_admin_name"], ["root", "Administrator", "administrator"]))) {
                $salt = generateRandStr(8);
                $pass_crypt = pass_encrypt($editvs["pass"], $salt);
                $editvs["crypted_pass"] = $pass_crypt;
                $editvs["crypted_salt"] = $salt;
            }
            $token_str = "";
            $token_vals = [];
            $data_set = $vps["data"];
            foreach ($tmp_data as $vk => $vv) {
                $data_set[$vv] = $editvs[$vv];
            }
            if($vps["load_balancer"] == -1) {
                $editvs["load_balancer"] = -1;
                $data_set["enable_guest_agent"] = 1;
                $editvs["admin_managed"] = 1;
                if(empty($globals["save_vm_pass"]) && !empty($editvs["pass"])) {
                    $salt = generateRandStr(8);
                    $pass_crypt = pass_encrypt($editvs["pass"], $salt);
                    $editvs["crypted_pass"] = $pass_crypt;
                    $editvs["crypted_salt"] = $salt;
                }
                if(!empty($editvs["iso"])) {
                    $error[] = $l["iso_load_balancer"];
                    return false;
                }
            }
            if($kernel->features("load_balancer", $vps["virt"]) && !preg_match("/windows/is", $ostemplates[$vps["osid"]]["name"]) && $cluster->check_licensepro($vps["serid"]) && empty($vps["load_balancer"]) && is_billing_user($editvs["uid"], 1)) {
                $editvs["load_balancer"] = optPOST("load_balancer");
                if($editvs["load_balancer"] == -1) {
                    $editvs["load_balancer"] = 0;
                }
                if($editvs["load_balancer"] != -1) {
                    $tmp_lb = get_load_balancer(["uid" => $editvs["uid"], "sgid" => $servers[$globals["server"]]["sgid"], "vps_uuid" => $editvs["load_balancer"]]);
                    if(empty($tmp_lb[$editvs["load_balancer"]])) {
                        $editvs["load_balancer"] = 0;
                    }
                }
            }
            $editvs["data"] = json_encode($data_set);
            unset($data_set);
            if(!empty($editvs)) {
                $_res = makequery("SELECT c.column_name cols \n\t\t\t\t\t\t\t\tFROM information_schema.columns c \n\t\t\t\t\t\t\t\tWHERE c.table_schema='virtualizor' \n\t\t\t\t\t\t\t\tAND c.table_name='vps'");
                $vps_cols = [];
                $_res_c = vsql_num_rows($_res);
                if(0 < $_res_c) {
                    for ($i = 1; $i <= $_res_c; $i++) {
                        $row = vsql_fetch_assoc($_res);
                        $vps_cols[$row["cols"]] = $row["cols"];
                    }
                }
                foreach ($editvs as $k => $v) {
                    if(!in_array($k, $vps_cols) || in_array($k, ["disks", "hvm", "install_xentools"])) {
                    } else {
                        $token_str .= $k . " = :" . $k . ",\n";
                        $token_vals[":" . $k] = $v;
                    }
                }
            }
            if(!empty($token_str)) {
                $token_str .= "edittime =:edittime,\nvpsid =:vpsid";
                $token_vals[":edittime"] = time();
                $token_vals[":vpsid"] = $vps["vpsid"];
                $token_query = "UPDATE vps SET\n" . $token_str . "\nWHERE vpsid = :vpsid";
            }
            if(!empty($token_query) && !empty($token_vals)) {
                $res = update_query($token_query, $token_vals);
            }
            if(empty($vps["load_balancer"]) && $kernel->features("load_balancer", $vps["virt"]) && $editvs["load_balancer"] != -1 && !empty($editvs["load_balancer"]) && is_billing_user($editvs["uid"], 1)) {
                lb_refresh_config($editvs["load_balancer"]);
            }
            if(!empty($editvs["disks"])) {
                if(!empty($disks_to_create)) {
                    foreach ($disks_to_create as $k => $v) {
                        vpsdisk_add($vps["uuid"], $new_disks[$k]);
                    }
                }
                foreach ($editvs["disks"] as $k => $v) {
                    vpsdisk_update($vps["uuid"], $v);
                }
                foreach ($editvs["disks"] as $k => $v) {
                    if($vps["virt"] == "xen" && empty($vps["hvm"]) && 0 < $editvs["swap"] && $k == 1) {
                    } else {
                        $disks[$k]["disk_uuid"] = $editvs["disks"][$k]["disk_uuid"];
                    }
                }
            }
            if($kernel->features("vnc_support", $vps["virt"])) {
                if(isset($editvs["vnc"])) {
                    $editvs["vncpass"] = "";
                    if(!empty($editvs["vnc"])) {
                        $editvs["vncpass"] = optPOST("vncpass", generateRandStr($kernel->features("vncpasslen", $vps["virt"])));
                    }
                }
                if(isset($_POST["vncpass"]) && !isset($editvs["vnc"]) && !empty($vps["vnc"])) {
                    $editvs["vncpass"] = optPOST("vncpass", "");
                }
                if(!empty($editvs["vncpass"]) && (isset($editvs["vnc"]) && !empty($editvs["vnc"]) || !isset($editvs["vnc"]) && !empty($vps["vnc"]))) {
                    if(preg_match("/[^A-Za-z0-9]/is", $editvs["vncpass"])) {
                        $error[] = $l["no_nonalphanumeric"];
                        return false;
                    }
                    if($kernel->features("vncpasslen", $vps["virt"]) < strlen($editvs["vncpass"])) {
                        $error[] = $l["vncpass_too_long"] . $kernel->features("vncpasslen", $vps["virt"]);
                        return false;
                    }
                }
            }
            if($kernel->features("vnc_store_pass", $vps["virt"]) && !empty($editvs["vncpass"])) {
                $res = makequery("UPDATE vps\n\t\t\t\t\tSET vnc_passwd = :vnc_passwd\n\t\t\t\t\tWHERE vpsid = :vpsid", [":vnc_passwd" => $editvs["vncpass"], ":vpsid" => $vpsid]);
            }
            $allips = array_merge($pips, $pips6, $pips6_subnet, $pips_int);
            $p_counter = 1;
            foreach ($allips as $k => $v) {
                if(in_array($v, $unusedip)) {
                    $up_tokens = [":vpsid" => $vpsid, ":primary" => -1 * $p_counter, ":ip" => $v];
                    $up_query = "";
                    if(!empty($pips_int)) {
                        $up_query = " AND ippid IN (" . $ippid_chk["query"] . ")";
                        $up_tokens = array_merge($ippid_chk["tokens"], $up_tokens);
                    }
                    $res = update_query("UPDATE ips\n\t\t\t\t\t\t\t\t\tSET vpsid = :vpsid,\n\t\t\t\t\t\t\t\t\t`primary` = :primary\n\t\t\t\t\t\t\t\t\tWHERE ip = :ip" . $up_query, $up_tokens);
                } else {
                    $res = insert_and_id("INSERT INTO ips SET\n\t\t\t\t\t\t\t\t\t ip = '" . $v . "',\n\t\t\t\t\t\t\t\t\t vpsid = '" . $vpsid . "',\n\t\t\t\t\t\t\t\t\t `primary` = '" . -1 * $p_counter . "',\n\t\t\t\t\t\t\t\t\t ip_serid = '" . $vps["serid"] . "',\n\t\t\t\t\t\t\t\t\t ipv6 = '" . (valid_ip($v) ? 0 : 1) . "'");
                }
                $p_counter++;
            }
            $up_pri_tokens = [":primary" => 1, ":ip" => !empty($pips[0]) ? $pips[0] : $allips[0]];
            $up_pri_query = "";
            if(!empty($pips_int)) {
                $up_pri_query = " AND ippid IN (" . $ippid_chk["query"] . ")";
                $up_pri_tokens = array_merge($ippid_chk["tokens"], $up_pri_tokens);
            }
            $res = update_query("UPDATE ips\n\t\t\t\t\t\t\tSET `primary`  = :primary\n\t\t\t\t\t\t\tWHERE ip = :ip" . $up_pri_query, $up_pri_tokens);
            if(isset($_POST["ips"]) && !empty($vps["ips"])) {
                foreach ($vps["ips"] as $k => $v) {
                    if(!in_array($v, $allips)) {
                        $res = update_query("UPDATE ips\n\t\t\t\t\t\t\t\tSET `primary` = :primary,\n\t\t\t\t\t\t\t\tvpsid = :vpsid\n\t\t\t\t\t\t\t\tWHERE ip = :ip", [":primary" => 0, ":vpsid" => 0, ":ip" => $v]);
                    }
                }
            }
            if(isset($_POST["ipv6"]) && !empty($vps["ips6"])) {
                foreach ($vps["ips6"] as $k => $v) {
                    if(!in_array($v, $allips)) {
                        $res = update_query("UPDATE ips\n\t\t\t\t\t\t\tSET `primary` = :primary,\n\t\t\t\t\t\t\tvpsid = :vpsid\n\t\t\t\t\t\t\tWHERE ip = :ip", [":primary" => 0, ":vpsid" => 0, ":ip" => $v]);
                    }
                }
            }
            if(isset($_POST["ipv6_subnet"]) && !empty($vps["ips6_subnet"])) {
                foreach ($vps["ips6_subnet"] as $k => $v) {
                    $tmp = explode("/", $v);
                    if(!in_array($tmp[0], $allips)) {
                        $res = update_query("UPDATE ips\n\t\t\t\t\t\t\t\tSET `primary` = :primary,\n\t\t\t\t\t\t\t\tvpsid = :vpsid,\n\t\t\t\t\t\t\t\tipr_ips = :ipr_ips\n\t\t\t\t\t\t\t\tWHERE ip = :ip", [":primary" => 0, ":vpsid" => 0, ":ipr_ips" => "", ":ip" => $tmp[0]]);
                    }
                }
            }
            if(isset($_POST["ips_int"]) && !empty($vps["ips_int"])) {
                foreach ($vps["ips_int"] as $k => $v) {
                    if(!in_array($v, $allips)) {
                        $res = update_query("UPDATE ips\n\t\t\t\t\t\t\t\tSET `primary` = :primary,\n\t\t\t\t\t\t\t\tvpsid = :vpsid\n\t\t\t\t\t\t\t\tWHERE ip = :ip  AND ippid IN (" . $ippid_chk["query"] . ")", array_merge($ippid_chk["tokens"], [":primary" => 0, ":vpsid" => 0, ":ip" => $v]));
                    }
                }
            }
            $callback = [];
            if((!empty($pips[0]) || !empty($pips_int[0]) || !empty($pips6[0]) || !empty($pips6_subnet[0])) && !empty($globals["enable_cb"]) && !empty($globals["cb_changeips"])) {
                $callback["act"][] = "changeip";
                $ipv4ips = array_merge($pips, $pips_int);
                $ipv6ips = array_merge($pips6, $pips6_subnet);
                if(!empty($ipv4ips)) {
                    $callback["data"]["ipv4"] = implode(",", $ipv4ips);
                }
                if(!empty($ipv6ips)) {
                    $callback["data"]["ipv6"] = implode(",", $ipv6ips);
                }
            }
            if(is_array($disks_to_delete) && !empty($disks_to_delete) && !$cluster->delete_vpsdisks($vpsid, $disks_to_delete)) {
                $error[] = $l["err_del_disks"];
                return false;
            }
            $bw = _unserialize($vps["nw_suspended"]);
            if(isset($editvs["bandwidth"]) && $vps["bandwidth"] < $editvs["bandwidth"] && $bw["reason"] == "bw") {
                $res = makequery("UPDATE vps\n\t\t\t\t\t\t\t\tSET `nw_suspended` = NULL\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $vps["vpsid"]]);
                $cluster->unsuspend_vps_net($vps["vpsid"]);
                logs_admin("nw_unsuspended", $vps["vps_name"], 1, $vpsid, $user["uid"]);
            }
            $sres = $cluster->sync($vps["serid"]);
            if(empty($sres)) {
                $error[] = $l["err_save_slave"];
                return false;
            }
            getvps($vpsid, 0);
            if($kernel->features("pci_passthrough", $vps["_virt"]) && !empty($_POST["pcis"])) {
                $assignedpcis = $pcis_to_delete = [];
                $assignedpcis = $_POST["pcis"];
                $load_balancer = optPOST("load_balancer");
                if(!empty($assignedpcis) && $load_balancer == -1) {
                    $error[] = $l["passthrough_invalid_loadbalancer"];
                    return false;
                }
                $vps_all_pci_pid = [];
                foreach ($vps["pci"] as $k => $v) {
                    foreach ($v as $sv) {
                        if(!in_array($sv["pid"], $assignedpcis)) {
                            $pcis_to_delete[] = $sv["pid"];
                        }
                        $vps_all_pci_pid[] = $sv["pid"];
                    }
                }
                if(!empty($assignedpcis[0])) {
                    $res = makequery("SELECT * FROM `passthrough` WHERE dev_fullname LIKE '%vga%' AND pid IN (" . implode(",", $assignedpcis) . ")");
                    if(1 < vsql_num_rows($res)) {
                        $error[] = $l["single_gpu_only"];
                        return false;
                    }
                }
                $poweroff_vps = 0;
                $intersected_data = array_intersect($vps_all_pci_pid, $assignedpcis);
                if(count($intersected_data) != count($assignedpcis)) {
                    $poweroff_vps = 1;
                }
                if(1 <= count($pcis_to_delete)) {
                    makequery("UPDATE `passthrough` SET `vpsid` = 0 WHERE `pid` IN (" . implode(",", $pcis_to_delete) . ")");
                }
                if(!empty($assignedpcis[0])) {
                    makequery("UPDATE `passthrough` SET `vpsid` = " . $vps["vpsid"] . " WHERE `pid` IN (" . implode(",", $assignedpcis) . ")");
                }
                $sres = $cluster->sync($vps["serid"]);
            }
            if($kernel->features("usb_passthrough", $vps["_virt"]) && isset($_POST["usbs"])) {
                $assignedusbs = $usb_to_delete = [];
                $assignedusbs = $_POST["usbs"];
                $load_balancer = optPOST("load_balancer");
                if(!empty($assignedusbs) && $load_balancer == -1) {
                    $error[] = $l["passthrough_invalid_loadbalancer"];
                    return false;
                }
                foreach ($vps["usb"] as $k => $v) {
                    if(!in_array($k, $assignedusbs)) {
                        $usb_to_delete[$k] = $v["pid"];
                    }
                }
                if(1 <= count($usb_to_delete)) {
                    makequery("UPDATE `passthrough` SET `vpsid` = 0 WHERE `pid` IN (" . implode(",", $usb_to_delete) . ")");
                }
                if(!empty($assignedusbs[0])) {
                    makequery("UPDATE `passthrough` SET `vpsid` = " . $vps["vpsid"] . " WHERE `pid` IN (" . implode(",", $assignedusbs) . ")");
                }
                $sres = $cluster->sync($vps["serid"]);
            }
            $vm_changes = compareArrays($vps, getvps($vpsid, 0));
            if(!$cluster->editvps($vpsid)) {
                $error[] = $l["err_edit"];
                return false;
            }
            if(!empty($vm_changes)) {
                $log_actid = vps_task("edit_logs", "", 0, $vps["vpsid"], $vps["uid"], 1, $l["vm_edit_logs"]);
                _task_update($log_actid, $l["vm_edit_logs"], 50, "group");
                task_update_logs($log_actid, get_log_table($vm_changes));
                _task_update($log_actid, "", 100, "group_end");
            }
            if($kernel->features("change_dns", $vps["virt"])) {
                $changes = array_merge(array_diff($vps["dns"], $_dns), array_diff($_dns, $vps["dns"]));
                if(!empty($changes)) {
                    $done["dns"] = true;
                }
            }
            if(!empty($editvs["mac_status"]) && $kernel->features("mac_support", $vps["_virt"]) && $vps["mac"] != $editvs["mac"]) {
                $ip_res = makequery("SELECT i.mac_addr FROM `ips` i\n\t\t\t\t\t\t\t\tWHERE i.vpsid = :vpsid\n\t\t\t\t\t\t\t\tORDER BY `primary` DESC LIMIT 1", [":vpsid" => $vpsid]);
                $_ips = vsql_fetch_assoc($ip_res);
                if(empty($_ips["mac_addr"])) {
                    $cluster->changemac_address($editvs["mac"], $vpsid);
                    $done["mac"] = true;
                }
            }
            if($kernel->features("win_support", $vps["_virt"]) && isset($editvs["rdp"]) && $editvs["rdp"] != $vps["rdp"]) {
                $cluster->remote_desktop($vpsid, $editvs["rdp"]);
            }
            $res = makequery("SELECT * FROM haproxy \n\t\t\t\t\t\tWHERE vpsuuid = :vpsuuid \n\t\t\t\t\t\tAND serid = :serid", [":vpsuuid" => $vps["uuid"], ":serid" => $vps["serid"]]);
            if(0 < vsql_num_rows($res)) {
                $old_vdf_destips = [];
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $old_vdf_destips[$row["dest_ip"]] = $row["dest_ip"];
                }
                $tmp_ips = [];
                foreach ($old_vdf_destips as $k => $v) {
                    if(!in_array($v, $pips)) {
                        $tmp_ips[$k] = $pips[0];
                    }
                }
                if(!empty($tmp_ips) && !empty($pips)) {
                    foreach ($tmp_ips as $k => $v) {
                        $res = makequery("UPDATE haproxy SET \n\t\t\t\t\t\t\t\t\tdest_ip = :dest_ip_new\n\t\t\t\t\t\t\t\t\tWHERE dest_ip = :dest_ip_old\n\t\t\t\t\t\t\t\t\tAND vpsuuid = :vpsuuid\n\t\t\t\t\t\t\t\t\tAND serid = :serid", [":dest_ip_new" => $v, ":dest_ip_old" => $k, ":vpsuuid" => $vps["uuid"], ":serid" => $vps["serid"]]);
                    }
                    if(!empty($res)) {
                        $cluster->save_haproxy($vps["serid"]);
                    }
                }
            }
            if(isset($editvs["pass"]) && !empty($editvs["pass"])) {
                $editvs["pass"] = rawGPC($_POST["rootpass"]);
                if(!empty($globals["pass_strength"]) && !empty($editvs["pass"])) {
                    $pass_strength = pass_strength($editvs["pass"]);
                    if($pass_strength < $globals["pass_strength"]) {
                        $error[] = $l["pass_strength_error"] . $globals["pass_strength"];
                        return false;
                    }
                }
                if(stripos($ostemplates[$vps["osid"]]["name"], "windows") !== false) {
                    $allowed_chars = "!@#\$%^&*_-+=?";
                    if(preg_match("/[^a-zA-Z0-9" . preg_quote($allowed_chars) . "]/is", $editvs["pass"])) {
                        $error["inv_winpass_chars"] = $l["inv_winpass_chars"] . " ! @ # \$ % ^ & * _ - + = ?";
                    }
                    $pass_score = win_pass_score($editvs["pass"]);
                    if($pass_score < 3) {
                        $error["weak_pass"] = $l["weak_pass"];
                    }
                }
                $vm_username = optREQ("vm_admin_name");
                if(!$cluster->change_vps_pass($vpsid, $editvs["pass"], $vm_username)) {
                    $error[] = $l["err_rootpass"];
                    return false;
                }
                if($kernel->features("onboot_changepass", $vps["virt"]) && empty($vps["data"]["enable_guest_agent"])) {
                    $done["change_pass_msg"] = true;
                    return true;
                }
            }
            if(isset($editvs["hostname"]) && $editvs["hostname"] != $vps["hostname"]) {
                $ret = $cluster->change_vps_hostname($vpsid, $editvs["hostname"]);
                if(!empty($ret) && !empty($globals["enable_cb"]) && !empty($globals["cb_hostname"])) {
                    $callback["act"][] = "changehostname";
                    $callback["data"]["newhostname"] = $editvs["hostname"];
                }
            }
            if($kernel->features("xenserver_tools", $vps["_virt"]) && empty($vps["install_xentools"]) && !empty($editvs["install_xentools"])) {
                $ret = $cluster->install_xentools($vpsid);
            }
            $skip_callback = (int) optREQ("skip_callback");
            if(!empty($callback) && empty($skip_callback)) {
                $actid = vps_task("editvps_callback", serialize($callback), 0, $vpsid, $user["uid"], 0, $l["task_pending"]);
            }
            if($kernel->features("vnc_support", $vps["virt"]) && !empty($editvs["vncpass"]) && !$cluster->change_vnc_pass($vpsid, $editvs["vncpass"])) {
                $error["err_vncpass"] = $l["err_vncpass"];
                return false;
            }
            if($kernel->features("build_dhcp", $vps["_virt"]) && (isset($_POST["ips"]) || isset($_POST["ipv6"]) || isset($_POST["ips_int"]) || isset($_POST["ipv6_subnet"]) || isset($_POST["mac"]))) {
                $cluster->build_dhcp($vps["serid"]);
            }
            $enduser_firewall_changed = isset($editvs["fwid"]) && !empty($editvs["fwid"]);
            $admin_firewall_changed = isset($editvs["admin_fwid"]) && !empty($editvs["admin_fwid"]);
            $enduser_firewall_removed = isset($editvs["fwid"]) && empty($editvs["fwid"]);
            $admin_firewall_removed = isset($editvs["admin_fwid"]) && empty($editvs["admin_fwid"]);
            if(!empty($enduser_firewall_changed) || !empty($admin_firewall_changed) || !empty($enduser_firewall_removed) || !empty($admin_firewall_removed) || !empty($ips_changed)) {
                $temp_fwid = isset($editvs["fwid"]) ? $editvs["fwid"] : $vps["fwid"];
                $temp_admin_fwid = isset($editvs["admin_fwid"]) ? $editvs["admin_fwid"] : $vps["admin_fwid"];
                if(!empty($temp_fwid) || !empty($temp_admin_fwid)) {
                    $cluster->apply_vpsfirewall_rule($vps["serid"], [$vpsid], $temp_admin_fwid, $temp_fwid);
                }
            }
            logs_admin("editvs", $vps["vps_name"], 1, $vpsid, $user["uid"]);
            $done["done"] = true;
            $plan_changed = 0;
            $final_plid = !empty($plid) && $plid != $vps["plid"] ? $plid : $vps["plid"];
            $owner = !empty($users[$editvs["uid"]]["pid"]) ? $users[$editvs["uid"]]["pid"] : $editvs["uid"];
            if(!empty($globals["inhouse_billing"]) && !empty($users[$owner]["inhouse_billing"])) {
                if(!empty($editvs["plid"]) && $vps["plid"] != $editvs["plid"]) {
                    makequery("UPDATE `usage`\n\t\t\t\t\t\t\tSET endtime = " . time() . ",\n\t\t\t\t\t\t\tupdatetime = " . time() . "WHERE vps_uuid = :vps_uuidAND endtime = 0AND (`resource` IS NOT NULL OR `resource` = '')", [":vps_uuid" => $vps["uuid"]]);
                    $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\tSET vps_uuid = :vps_uuid,\n\t\t\t\t\t\t\t\t\tuid  = :owner,\n\t\t\t\t\t\t\t\t\tplid  = :editvs_plid,\n\t\t\t\t\t\t\t\t\tstarttime = " . time(), [":vps_uuid" => $vps["uuid"], ":owner" => $owner, ":editvs_plid" => $editvs["plid"]]);
                    $plan_changed = 1;
                }
                $plan = $plans[$final_plid];
                $vpsips = getvpsips($vpsid);
                $resources_ips = ["ips" => !empty($pips) ? $pips : $vpsips["ips"], "ipv6" => !empty($pips6) ? $pips6 : $vpsips["ips6"], "ipv6subnet" => !empty($pips6_subnet) ? $pips6_subnet : $vpsips["ips6_subnet"], "ipsint" => !empty($pips_int) ? $pips_int : $vpsips["ips_int"]];
                foreach ($globals["resource_types"] as $resource) {
                    if(array_key_exists($resource, $resources_ips)) {
                        $numval = count($resources_ips[$resource]);
                    } else {
                        $numval = !empty($editvs[$resource]) ? $editvs[$resource] : $vps[$resource];
                    }
                    $plan_map = ["ipv6" => "ips6", "ipv6subnet" => "ips6_subnet", "ipsint" => "ips_int"];
                    if($plan[$resource] < $numval) {
                        $new_resource[$resource] = $numval - $plan[$resource];
                    }
                    if(!empty($plan_map[$resource]) && $plan[$plan_map[$resource]] < $numval) {
                        $new_resource[$resource] = $numval - $plan[$resource];
                    }
                }
                $ptoks = vsql_in_tokens($globals["resource_types"]);
                $res = makequery("SELECT * FROM `usage`\n\t\t\t\t\t\t\tWHERE vps_uuid = :vps_uuid\n\t\t\t\t\t\t\tAND endtime = 0\n\t\t\t\t\t\t\tAND `resource` IN (" . $ptoks["query"] . ")", array_merge([":vps_uuid" => $vps["uuid"]], $ptoks["tokens"]));
                unset($ptoks);
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $resource = $row["resource"];
                    if(empty($new_resource[$resource]) || $new_resource[$resource] != $row["resource_val"]) {
                        makequery("UPDATE `usage`\n\t\t\t\t\t\t\tSET endtime = " . time() . ",\n\t\t\t\t\t\t\tupdatetime = " . time() . "\n\t\t\t\t\t\t\tWHERE vps_uuid = :vps_uuid\n\t\t\t\t\t\t\tAND endtime = 0\n\t\t\t\t\t\t\tAND `resource` = :resource", [":vps_uuid" => $vps["uuid"], ":resource" => $resource]);
                    } elseif($new_resource[$resource] == $row["resource_val"]) {
                        unset($new_resource[$resource]);
                    }
                    if(!empty($editvs["hostname"]) && $editvs["hostname"] != $vps["hostname"]) {
                        $tmp_usage_data = serialize(["hostname" => $editvs["hostname"]]);
                        makequery("UPDATE `usage`\n\t\t\t\t\t\t\t\tSET data = :tmp_usage_data\n\t\t\t\t\t\t\t\tWHERE vps_uuid = :vps_uuid", [":tmp_usage_data" => $tmp_usage_data, ":vps_uuid" => $vps["uuid"]]);
                    }
                }
                if(!empty($new_resource)) {
                    foreach ($new_resource as $resource => $resval) {
                        $vals = $set = [];
                        $vals["vps_uuid"] = $vps["uuid"];
                        $vals["uid"] = $owner;
                        $vals["starttime"] = time();
                        $vals["resource"] = $resource;
                        $vals["resource_val"] = $resource == "ram" ? $resval / 1024 : $resval;
                        foreach ($vals as $k => $v) {
                            $set[$k] = "`" . $k . "` = :" . $k;
                        }
                        $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                    }
                }
            }
            if(!empty($globals["inhouse_billing"]) && $editvs["uid"] != $vps["uid"] && (!empty($plid) || !empty($vps["plid"]))) {
                $old_owner = !empty($users[$vps["uid"]]["pid"]) ? $users[$vps["uid"]]["pid"] : $vps["uid"];
                $new_owner = !empty($users[$editvs["uid"]]["pid"]) ? $users[$editvs["uid"]]["pid"] : $editvs["uid"];
                $host = $vps["hostname"];
                if(isset($editvs["hostname"]) && $editvs["hostname"] != $vps["hostname"]) {
                    $host = $editvs["hostname"];
                }
                if(!empty($users[$new_owner]["inhouse_billing"]) && !empty($users[$old_owner]["inhouse_billing"])) {
                    $res = makequery("UPDATE `usage` SET endtime = :endtime, \n\t\t\t\t\t\tupdatetime = :updatetime \n\t\t\t\t\t\tWHERE uid = :uid \n\t\t\t\t\t\tAND endtime = 0", [":endtime" => time(), ":uid" => $old_owner, ":updatetime" => time()]);
                    if(empty($plan_changed)) {
                        $vals = $set = [];
                        $vals["vps_uuid"] = $vps["uuid"];
                        $vals["uid"] = $new_owner;
                        $vals["starttime"] = time();
                        $vals["plid"] = $final_plid;
                        $vals["data"] = serialize(["hostname" => $host]);
                        foreach ($vals as $k => $v) {
                            $set[$k] = "`" . $k . "` = :" . $k;
                        }
                        $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                    }
                    $vals = $set = [];
                    $vals["vps_uuid"] = $vps["uuid"];
                    $vals["uid"] = $new_owner;
                    $vals["starttime"] = time();
                    $vals["resource"] = "bandwidth";
                    $vals["data"] = serialize(["hostname" => $host]);
                    foreach ($vals as $k => $v) {
                        $set[$k] = "`" . $k . "` = :" . $k;
                    }
                    $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                }
                if(!empty($users[$new_owner]["inhouse_billing"]) && empty($users[$old_owner]["inhouse_billing"])) {
                    if(empty($plan_changed)) {
                        $vals = $set = [];
                        $vals["vps_uuid"] = $vps["uuid"];
                        $vals["uid"] = $new_owner;
                        $vals["starttime"] = time();
                        $vals["plid"] = $final_plid;
                        $vals["data"] = serialize(["hostname" => $host]);
                        foreach ($vals as $k => $v) {
                            $set[$k] = "`" . $k . "` = :" . $k;
                        }
                        $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                    }
                    $vals = $set = [];
                    $vals["vps_uuid"] = $vps["uuid"];
                    $vals["uid"] = $new_owner;
                    $vals["starttime"] = time();
                    $vals["resource"] = "bandwidth";
                    $vals["data"] = serialize(["hostname" => $host]);
                    foreach ($vals as $k => $v) {
                        $set[$k] = "`" . $k . "` = :" . $k;
                    }
                    $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                }
                if(empty($users[$new_owner]["inhouse_billing"]) && !empty($users[$old_owner]["inhouse_billing"])) {
                    $res = makequery("UPDATE `usage` SET endtime = :endtime, \n\t\t\t\t\t\tupdatetime = :updatetime \n\t\t\t\t\t\tWHERE uid = :uid \n\t\t\t\t\t\tAND endtime = 0", [":endtime" => time(), ":uid" => $old_owner, ":updatetime" => time()]);
                }
            }
            ip_logs($vpsid);
            $ubcset_tmp = (int) optREQ("ubcsettings");
            if(!empty($ubcset_tmp)) {
                redirect("act=ubc&vpsid=" . $vpsid);
            }
            if(empty($vpsips)) {
                $vpsips = getvpsips($vps["vpsid"]);
            }
            $editedvs = getvps($vps["vpsid"], 0);
            $editedvs["ips"] = !empty($pips) ? $pips : $vpsips["ips"];
            $editedvs["ips6"] = !empty($pips6) ? $pips6 : $vpsips["ips6"];
            $editedvs["ips6_subnet"] = !empty($pips6_subnet) ? $pips6_subnet : $vpsips["ips6_subnet"];
            $editedvs["ips_int"] = !empty($pips_int) ? $pips_int : $vpsips["ips_int"];
            if($vps["serid"] != 0 && is_master()) {
                $ret = $cluster->reverse_sync($vps["serid"]);
            }
            apply_filters("editvs", $vps, $editvs);
            if($poweroff_vps) {
                $state_array = [$vps["vpsid"] => $vps["serid"]];
                $i = 0;
                while ($i < 10) {
                    if($cluster->vps_status_statewise($state_array, 1)[$vps["vpsid"]] != 0) {
                        $cluster->stopvps($vps["serid"], $vps["vpsid"]);
                        sleep(2);
                        $i++;
                        break;
                    }
                }
                if($cluster->vps_status_statewise($state_array, 1)[$vps["vpsid"]] != 0) {
                    $done = $cluster->poweroffvps($vps["serid"], $vps["vpsid"]);
                }
            }
        }
    }
}
function API_managevps()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $servers;
    global $oslist;
    global $done;
    global $done_msg;
    global $error_msg;
    global $plans;
    global $ips;
    global $ips6;
    global $ips6_subnet;
    global $ips_int;
    global $ipools;
    global $vps;
    global $ostemplates;
    global $users;
    global $isos;
    global $mgs;
    global $servergroups;
    global $scripts;
    global $iscripts;
    global $editedvs;
    global $ips2;
    global $ipr_ips;
    global $actid;
    global $backup_plans;
    global $supported_protocols;
    global $haproxydata;
    global $vpses;
    global $server_haconfigs;
    global $arr_haproxy_src_ips;
    global $vpsips;
    global $vm_backup_plan;
    global $iscripts_allowed;
    global $webuzo_apps;
    global $isfree;
    global $ajax_user;
    global $vps_data;
    global $console;
    global $load_balancer;
    global $firewall_plans;
    global $admin_firewall_plans;
    global $enduser_firewall_plans;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($done_msg)) {
        $GLOBALS["_api"]["done_msg"] = $done_msg;
    }
    if(!empty($error_msg)) {
        $GLOBALS["_api"]["error_msg"] = $error_msg;
    }
    if(!empty($actid)) {
        $GLOBALS["_api"]["actid"] = $actid;
    }
    if(!empty($vps_data)) {
        $GLOBALS["_api"]["vps_data"] = $vps_data;
    }
    if(!empty($done["done"])) {
        unset($ips);
        unset($ips6);
        unset($ips6_subnet);
        unset($ips_int);
        unset($plans);
        unset($backup_plans);
        unset($ostemplates);
        unset($isos);
    }
    $GLOBALS["_api"]["ips"] = $ips;
    $GLOBALS["_api"]["ips6"] = $ips6;
    $GLOBALS["_api"]["ips6_subnet"] = $ips6_subnet;
    $GLOBALS["_api"]["ips_int"] = $ips_int;
    $GLOBALS["_api"]["vpsips"] = $vps["ips"];
    if(empty($_REQUEST["get_user_ips"])) {
        $GLOBALS["_api"]["plans"] = $plans;
        $GLOBALS["_api"]["servers"] = $servers;
        $GLOBALS["_api"]["users"] = $users;
        $GLOBALS["_api"]["vps"] = empty($editedvs) ? $vps : $editedvs;
        $GLOBALS["_api"]["ostemplates"] = $ostemplates;
        $GLOBALS["_api"]["isos"] = $isos;
        $GLOBALS["_api"]["mgs"] = $mgs;
        $GLOBALS["_api"]["servergroups"] = $servergroups;
        $GLOBALS["_api"]["scripts"] = $scripts;
        $GLOBALS["_api"]["iscripts"] = $iscripts;
        $GLOBALS["_api"]["backup_plans"] = $backup_plans;
        $GLOBALS["_api"]["ipr_ips"] = $ipr_ips;
        $GLOBALS["_api"]["ips2"] = $ips2;
        $GLOBALS["_api"]["ajax_user"] = $ajax_user;
        $GLOBALS["_api"]["arr_haproxy_src_ips"] = $arr_haproxy_src_ips;
        $GLOBALS["_api"]["supported_protocols"] = $supported_protocols;
        $GLOBALS["_api"]["haproxydata"] = $haproxydata;
        $GLOBALS["_api"]["vpses"] = $vpses;
        $GLOBALS["_api"]["server_haconfigs"] = $server_haconfigs;
        if(!empty($isfree)) {
            $GLOBALS["_api"]["isfree"] = $isfree;
        }
        $GLOBALS["vm_backup_plan"] = $vm_backup_plan;
        $GLOBALS["_api"]["console"] = $console;
        $GLOBALS["_api"]["load_balancer"] = $load_balancer;
    }
}
function isset_post($key, $post_key = "", $type = "")
{
    global $editvs;
    if(!isset($_POST[$key]) && !isset($_POST[$post_key])) {
        return NULL;
    }
    if(isset($_POST[$key])) {
        $editvs[$key] = optPOST($key);
    }
    if(isset($_POST[$post_key])) {
        $editvs[$key] = optPOST($post_key);
    }
    if($type == "int") {
        $editvs[$key] = (int) $editvs[$key];
    }
}
function isset_req($key, $post_key = "", $type = "")
{
    global $editvs;
    if(!isset($_REQUEST[$key]) && !isset($_REQUEST[$post_key])) {
        return NULL;
    }
    if(isset($_REQUEST[$key])) {
        $editvs[$key] = optREQ($key);
    }
    if(isset($_REQUEST[$post_key])) {
        $editvs[$key] = optREQ($post_key);
    }
    if($type == "int") {
        $editvs[$key] = (int) $editvs[$key];
    }
}

?>