<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function managesubnets()
{
    global $theme;
    global $globals;
    global $error;
    global $ckernel;
    global $user;
    global $l;
    global $alerts;
    global $ipv6_subnets;
    global $ips;
    global $done;
    global $ipr_ips;
    $theme["init_theme"] = "managesubnets";
    $theme["init_theme_name"] = "managesubnets";
    $theme["init_theme_func"] = ["managesubnets_theme"];
    $theme["call_theme_func"] = "managesubnets_theme";
    if(!empty($user["vps"]["admin_managed"])) {
        $error[] = $l["is_managed"];
        return false;
    }
    $subnet_mask_arr = ["112" => 1, "96" => 2, "80" => 3, "64" => 4, "48" => 5];
    if(empty($globals["vpsid"])) {
        $error["no_vps"] = $l["mng_no_vps"];
        return false;
    }
    $res = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vpsid\n\t\t\t\t\tAND i.ipv6 > 0\n\t\t\t\t\tAND i.ipr_netmask != ''\n\t\t\t\t\tORDER BY i.`primary` DESC", [":vpsid" => $globals["vpsid"]]);
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        if(!empty($row["ipr_ips"])) {
            $row["ipr_ips"] = unserialize($row["ipr_ips"]);
        }
        $ips[$row["ipid"]] = ["ip" => $row["ip"], "ipr_netmask" => $row["ipr_netmask"], $row["ip"] => $row["ipr_ips"]];
    }
    $ipv6_addr = optPOST("ipv6_addr");
    $new_ipv6 = $_POST["new_ipv6"];
    $ipv6_subnet_mask = optPOST("ipv6_subnet_mask");
    $subnet = optPOST("subnet");
    if(!empty($ipv6_subnet_mask) && @in_array($ipv6_subnet_mask, @array_keys($subnet_mask_arr))) {
        foreach ($ips as $k => $v) {
            $allowed_ip[$k] = $v["ip"];
        }
        if(!in_array($ipv6_addr, $allowed_ip)) {
            $error[] = $l["mng_inv_ipaddress"];
            return false;
        }
        $ipv6_parts = explode(":", $ipv6_addr);
        $ipv6_parts = array_slice($ipv6_parts, 0, count($ipv6_parts) - $subnet_mask_arr[$ipv6_subnet_mask]);
        $ipv6_to_check = implode(":", $ipv6_parts);
        if(is_array($new_ipv6)) {
            $new_ipv6 = array_unique($new_ipv6);
            foreach ($new_ipv6 as $new_ip) {
                if(!(valid_ipv6($new_ip) && strpos($new_ip, $ipv6_to_check) === 0)) {
                    $error[] = $l["mng_ipv6_invalid"];
                    $new_ipv6_update = serialize($new_ipv6);
                }
            }
        } else {
            $new_ipv6 = NULL;
            $new_ipv6_update = "";
        }
        if(!isset($error)) {
            $res = makequery("UPDATE `virtualizor`.`ips` \n\t\t\t\t\t\t\t\tSET `ipr_ips` = :ipr_ips \n\t\t\t\t\t\t\t\tWHERE `ips`.`ipr_netmask` = :ipr_netmask \n\t\t\t\t\t\t\t\tAND `ip`= :ip", [":ipr_ips" => $new_ipv6_update, ":ipr_netmask" => $ipv6_subnet_mask, ":ip" => $ipv6_addr]);
            $ckernel->editvps($globals["vpsid"]);
            $done["done"] = $l["mng_done"];
        }
        $ipr_ips["ipv6"] = $new_ipv6;
        $ipr_ips["ipv6_list"] = 1;
        $ipr_ips["ipv6_subnet_mask"] = $ipv6_subnet_mask;
        $ipr_ips["ipv6_subnet_mask_value"] = $subnet_mask_arr[$ipv6_subnet_mask];
        $ipr_ips["ipv6_addr"] = $ipv6_addr;
    } elseif(!empty($subnet) && 0 < strpos($subnet, "/")) {
        list($ipv6, $subnet_mask) = explode("/", $subnet, 2);
        if(valid_ipv6($ipv6) && in_array($subnet_mask, array_keys($subnet_mask_arr))) {
            $ipr_ips = [];
            foreach ($ips as $k => $v) {
                if(isset($v[$ipv6])) {
                    $ipr_ips["ipv6"] = $v[$ipv6];
                }
            }
            $ipr_ips["ipv6_list"] = 1;
            $ipr_ips["ipv6_subnet_mask"] = $subnet_mask;
            $ipr_ips["ipv6_subnet_mask_value"] = $subnet_mask_arr[$subnet_mask];
            $ipr_ips["ipv6_addr"] = $ipv6;
        }
    }
}
function API_managesubnets()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $user;
    global $l;
    global $ipv6_subnets;
    global $ips;
    global $done;
    global $ipr_ips;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    $GLOBALS["_api"]["ipr_ips"] = $ipr_ips;
    $GLOBALS["_api"]["ips"] = $ips;
}

?>