<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
include_once $globals["kernelfiles"] . "/openvz.php";
$openvz_kernel = new openvz();
include_once $globals["kernelfiles"] . "/xen.php";
$xen_kernel = new xen();
include_once $globals["kernelfiles"] . "/xcp.php";
$xcp_kernel = new xcp();
include_once $globals["kernelfiles"] . "/kvm.php";
$kvm_kernel = new kvm();
include_once $globals["kernelfiles"] . "/lxc.php";
$lxc_kernel = new lxc();
include_once $globals["kernelfiles"] . "/vzo.php";
$vzo_kernel = new vzo();
include_once $globals["kernelfiles"] . "/vzk.php";
$vzk_kernel = new vzk();
include_once $globals["kernelfiles"] . "/proxo.php";
$proxo_kernel = new proxo();
include_once $globals["kernelfiles"] . "/proxk.php";
$proxk_kernel = new proxk();
include_once $globals["kernelfiles"] . "/proxl.php";
$proxl_kernel = new proxl();
include_once $globals["mainfiles"] . "/cluster.php";
$cluster_kernel = new cluster_kernel();
class kernel
{
    public function __call($function, $args)
    {
        global $servers;
        global $globals;
        if(empty($servers)) {
            list_servers();
        }
        if(!is_numeric($args[0])) {
            echo "WRONG FUNCTION CALLED :" . $function;
        } else {
            $vps = getvps($args[0]);
            $virt = $vps["virt"];
            if(empty($args[0])) {
                return NULL;
            }
            $ret = call_user_func_array([$GLOBALS[$virt . "_kernel"], $function], $args);
            return $ret;
        }
    }
    public function features($feature, $virt = "")
    {
        if(empty($virt)) {
            $virt = server_primary_virt(0);
        }
        $_virt = $virt;
        if(substr_count($virt, "hvm")) {
            $virt = str_replace("hvm", "", $virt);
        }
        return $GLOBALS[$virt . "_kernel"]->conf(0, $feature, $_virt);
    }
    public function new_vps_name($virt, $vps_name = "")
    {
        return $GLOBALS[$virt . "_kernel"]->new_vps_name($vps_name);
    }
    public function status($vids, $live = false)
    {
        global $servers;
        global $globals;
        if(empty($vids)) {
            return 0;
        }
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $res = makequery("SELECT vpsid, virt FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($vids) ? 0 : implode(",", $vids)) . ")");
        $virt_vise = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $virt_vise[$row["virt"]][] = $row["vpsid"];
        }
        $ret = [];
        foreach ($virt_vise as $virt => $VPSIDs) {
            $ret += $GLOBALS[$virt . "_kernel"]->status($VPSIDs, $live);
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function vps_status_statewise($vids, $live = false)
    {
        global $servers;
        global $globals;
        if(empty($vids)) {
            return 0;
        }
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $res = makequery("SELECT vpsid, virt FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($vids) ? 0 : implode(",", $vids)) . ")");
        $virt_vise = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $virt_vise[$row["virt"]][] = $row["vpsid"];
        }
        $ret = [];
        foreach ($virt_vise as $virt => $VPSIDs) {
            $ret += $GLOBALS[$virt . "_kernel"]->vps_status_statewise($VPSIDs, $live);
        }
        if(!empty($notarray)) {
            return current($ret);
        }
        return $ret;
    }
    public function serverloads($vids)
    {
        $ret = [];
        foreach ($vids as $_virt => $ids) {
            $virt = server_virt(0, $_virt);
            if(empty($virt)) {
            } elseif(method_exists($GLOBALS[$virt . "_kernel"], "serverloads")) {
                $_ret = $GLOBALS[$virt . "_kernel"]->serverloads($ids);
                if(is_array($_ret)) {
                    $ret += $_ret;
                }
            }
        }
        return $ret;
    }
    public function dom0mem($mb = 768)
    {
        $virt = server_primary_virt(0);
        if($virt == "xen" || $virt == "xcp") {
            return $GLOBALS[$virt . "_kernel"]->dom0mem($mb);
        }
        return true;
    }
    public function vscpu($vids, $speed = 100000, $times = 2)
    {
        global $servers;
        global $globals;
        $res = makequery("SELECT vpsid, virt FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($vids) ? 0 : implode(",", $vids)) . ")");
        $virt_vise = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $virt_vise[$row["virt"]][] = $row["vpsid"];
        }
        $ret = [];
        foreach ($virt_vise as $virt => $VPSIDs) {
            $ret += $GLOBALS[$virt . "_kernel"]->vscpu($VPSIDs, $speed, $times);
        }
        return $ret;
    }
    public function vsram($vids)
    {
        global $servers;
        global $globals;
        $res = makequery("SELECT vpsid, virt FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . (empty($vids) ? 0 : implode(",", $vids)) . ")");
        $virt_vise = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $virt_vise[$row["virt"]][] = $row["vpsid"];
        }
        $ret = [];
        foreach ($virt_vise as $virt => $VPSIDs) {
            $ret += $GLOBALS[$virt . "_kernel"]->vsram($VPSIDs);
        }
        return $ret;
    }
    public function check_kernel()
    {
        global $servers;
        global $globals;
        $virts = explode(" ", $globals["kernel"]);
        $ret = "";
        foreach ($virts as $virt) {
            $tmp_ret = $GLOBALS[$virt . "_kernel"]->check_kernel();
            if(1 < strlen($tmp_ret)) {
                $ret .= $tmp_ret;
            }
        }
        if(!empty($ret)) {
            return $ret;
        }
        return true;
    }
    public function resources($virt = "")
    {
        if(empty($virt) || preg_match("/\\s/", $virt)) {
            $virt = server_primary_virt(0);
        }
        return $GLOBALS[$virt . "_kernel"]->resources();
    }
    public function cron()
    {
        global $servers;
        global $globals;
        $virts = explode(" ", $globals["kernel"]);
        foreach ($virts as $virt) {
            $GLOBALS[$virt . "_kernel"]->cron();
        }
    }
    public function backuply_delete_backup($time, $chain, $dir, $bid, $vps)
    {
        return $GLOBALS[$vps["virt"] . "_kernel"]->backuply_delete($time, $chain, $dir, $bid, $vps);
    }
    public function calculate_vps_bandwidth()
    {
        global $servers;
        global $globals;
        $virts = explode(" ", $globals["kernel"]);
        foreach ($virts as $virt) {
            $vpses = get_bw_vps($virt);
            foreach ($vpses as $k => $v) {
                $vpses[$k]["net_status"] = $GLOBALS[$virt . "_kernel"]->vps_net_status($k);
                if($vpses[$k]["status"] != 2 && $vpses[$k]["net_status"]) {
                    $value = $GLOBALS[$virt . "_kernel"]->_network_usage($k);
                    insert_vps_bw($v, $value);
                }
            }
        }
        vps_used_bandwidth();
    }
    public function monthly_vps_statistics($vpsid, $from = 0, $to = 0)
    {
        if(!empty($from) && !empty($to)) {
            $start = datetime_to_time($from);
            $end = datetime_to_time($to);
        } else {
            $start = strtotime(date("Y-m-1"));
            $end = time();
        }
        $query = "SELECT * FROM `status`\n\t\t\t\t\t  WHERE `vpsid` = :vpsid\n\t\t\t\t\t  AND time >= :start\n\t\t\t\t\t  AND time <= :end\n\t\t\t\t\t  ORDER BY `time` DESC";
        $token_val = [":vpsid" => $vpsid, ":start" => $start, ":end" => $end];
        $ret = [];
        $result = makequery($query, $token_val);
        if(0 < vsql_num_rows($result)) {
            while ($row = vsql_fetch_array($result)) {
                $ret[] = $row;
            }
        }
        return $ret;
    }
    public function cronh()
    {
        global $servers;
        global $globals;
        $virts = explode(" ", $globals["kernel"]);
        foreach ($virts as $virt) {
            $GLOBALS[$virt . "_kernel"]->cronh();
        }
    }
    public function backup($vps, $temp_backup_dir, $disable_compress, $disk_num, $io_limit)
    {
        $virt = $vps["virt"];
        return $GLOBALS[$virt . "_kernel"]->backup($vps, $temp_backup_dir, $disable_compress, $disk_num, $io_limit);
    }
    public function restore($vps, $temp_restore_dir, $backup_filename, $disk_num, $io_limit = 0, $storagename = "")
    {
        $virt = $vps["virt"];
        return $GLOBALS[$virt . "_kernel"]->restore($vps, $temp_restore_dir, $backup_filename, $disk_num, $io_limit, $storagename);
    }
    public function bandwidth_device($virt = "")
    {
        if(empty($virt)) {
            $virt = server_primary_virt(0);
        }
        if(!empty($GLOBALS[$virt . "_kernel"]->bandwidth_device)) {
            return $GLOBALS[$virt . "_kernel"]->bandwidth_device;
        }
        return false;
    }
    public function vm_location($vids, $live = false)
    {
        $virt = server_primary_virt(0);
        return $GLOBALS[$virt . "_kernel"]->vm_location($vids, $live);
    }
    public function storage_check($data)
    {
        if(!empty($data["virt"])) {
            $virt = $data["virt"];
        }
        if(empty($virt)) {
            $virt = server_primary_virt(0);
        }
        return $GLOBALS[$virt . "_kernel"]->storage_check($data);
    }
    public function get_vps_stats($vids, $live = 0, $show = "")
    {
        global $globals;
        global $cluster;
        $live_status = $this->vps_status_statewise($vids, true);
        $vps_data = [];
        if(empty($vids)) {
            return false;
        }
        if(!is_array($vids)) {
            $vids = [$vids];
            $notarray = true;
        }
        $res = makequery("SELECT * FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . implode(",", $vids) . ")");
        if(vsql_num_rows($res) < 1) {
            return false;
        }
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $vps_data[$row["vpsid"]] = $row;
            if(!empty($row["suspended"]) && $live_status[$row["vpsid"]] == 0) {
                $live_status[$row["vpsid"]] = 2;
            }
        }
        if($live) {
            $raw["status"] = $live_status;
            $raw["bandwidth"] = $cluster->vsbandwidth(0, $vids, $show);
            $raw["network_speed"] = $this->vs_ntw_speed($vids);
            $raw["cpu"] = $this->vscpu($vids);
            $raw["ram"] = $this->vsram($vids);
            $raw["disk"] = $this->vs_disk_usage($vids);
            $raw["io"] = $this->vs_io_usage($vids);
            foreach ($vids as $k => $v) {
                $ret[$v]["status"] = $live_status[$v];
                $ret[$v]["net_in"] = empty($raw["network_speed"][$v]["download"]) ? 0 : $raw["network_speed"][$v]["download"];
                $ret[$v]["net_out"] = empty($raw["network_speed"][$v]["upload"]) ? 0 : $raw["network_speed"][$v]["upload"];
                $ret[$v]["used_cpu"] = empty($raw["cpu"][$v]) ? 0 : $raw["cpu"][$v];
                $ret[$v]["used_ram"] = empty($raw["ram"][$v]["used"]) ? 0 : $raw["ram"][$v]["used"];
                $ret[$v]["ram"] = empty($raw["ram"][$v]["ram"]) ? 0 : $raw["ram"][$v]["ram"];
                $ret[$v]["used_disk"] = empty($raw["disk"][$v]["disk"]["used"]) ? 0 : $raw["disk"][$v]["disk"]["used"];
                $ret[$v]["disk"] = empty($raw["disk"][$v]["disk"]["allocated"]) ? 0 : $raw["disk"][$v]["disk"]["allocated"];
                $ret[$v]["used_inode"] = empty($raw["disk"][$v]["inode"]["used"]) ? 0 : $raw["disk"][$v]["inode"]["used"];
                $ret[$v]["inode"] = empty($raw["disk"][$v]["inode"]["allocated"]) ? 0 : $raw["disk"][$v]["inode"]["allocated"];
                $ret[$v]["used_bandwidth"] = empty($raw["bandwidth"][$v]["used_gb"]) ? 0 : $raw["bandwidth"][$v]["used_gb"];
                $ret[$v]["bandwidth"] = empty($raw["bandwidth"][$v]["limit_gb"]) ? 0 : $raw["bandwidth"][$v]["limit_gb"];
                $ret[$v]["virt"] = $vps_data[$v]["virt"];
                $ret[$v]["io_read"] = empty($raw["io"][$v]["io_read"]) ? 0 : $raw["io"][$v]["io_read"];
                $ret[$v]["io_write"] = empty($raw["io"][$v]["io_write"]) ? 0 : $raw["io"][$v]["io_write"];
            }
            $ret[0]["used_ram"] = empty($raw["ram"][0]["used"]) ? 0 : $raw["ram"][0]["used"];
            $ret[0]["ram"] = empty($raw["ram"][0]["ram"]) ? 0 : $raw["ram"][0]["ram"];
            $ret[-1]["used_ram"] = empty($raw["ram"][-1]["used"]) ? 0 : $raw["ram"][-1]["used"];
            $ret[-1]["ram"] = empty($raw["ram"][-1]["ram"]) ? 0 : $raw["ram"][-1]["ram"];
            return $ret;
        } else {
            $res = makequery("SELECT * FROM status \n\t\t\t\t\tWHERE `vpsid` IN (" . implode(",", $vids) . ") \n\t\t\t\t\tAND `time` = (SELECT MAX(time) FROM `status`)");
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $details[$row["vpsid"]] = $row;
            }
            foreach ($vids as $key => $val) {
                $ret[$val]["status"] = $live_status[$val];
                if(!empty($details[$val])) {
                    $ret[$val]["used_cpu"] = empty($details[$val]["actual_cpu"]) ? 0 : $details[$val]["actual_cpu"];
                    $ret[$val]["used_ram"] = empty($details[$val]["ram"]) ? 0 : $details[$val]["ram"];
                    $ret[$val]["used_disk"] = empty($details[$val]["disk"]) ? 0 : $details[$val]["disk"] / 1024;
                    $ret[$val]["net_in"] = empty($details[$val]["net_in"]) ? 0 : $details[$val]["net_in"];
                    $ret[$val]["net_out"] = empty($details[$val]["net_out"]) ? 0 : $details[$val]["net_out"];
                    $ret[$val]["used_inode"] = empty($details[$val]["inode"]) ? 0 : $details[$val]["inode"];
                    $ret[$val]["io_read"] = empty($details[$val]["io_read"]) ? 0 : $details[$val]["io_read"];
                    $ret[$val]["io_write"] = empty($details[$val]["io_write"]) ? 0 : $details[$val]["io_write"];
                } else {
                    $ret[$val]["used_cpu"] = 0;
                    $ret[$val]["used_ram"] = 0;
                    $ret[$val]["used_disk"] = 0;
                    $ret[$val]["net_in"] = 0;
                    $ret[$val]["net_out"] = 0;
                    $ret[$val]["used_inode"] = 0;
                    $ret[$val]["io_read"] = 0;
                    $ret[$val]["io_write"] = 0;
                }
                $ret[$val]["inode"] = empty($vps_data[$val]["inodes"]) ? 0 : $vps_data[$val]["inodes"];
                $ret[$val]["ram"] = empty($vps_data[$val]["ram"]) ? 0 : $vps_data[$val]["ram"];
                $ret[$val]["disk"] = empty($vps_data[$val]["space"]) ? 0 : $vps_data[$val]["space"];
                $ret[$val]["used_bandwidth"] = empty($vps_data[$val]["used_bandwidth"]) ? 0 : $vps_data[$val]["used_bandwidth"];
                $ret[$val]["bandwidth"] = empty($vps_data[$val]["bandwidth"]) ? 0 : $vps_data[$val]["bandwidth"];
                $ret[$val]["virt"] = $vps_data[$val]["virt"];
            }
            if(!empty($notarray)) {
                return current($ret);
            }
            return $ret;
        }
    }
    public function vs_ntw_speed($vids)
    {
        global $globals;
        if(empty($vids)) {
            return false;
        }
        $res = makequery("SELECT vpsid, virt FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . implode(",", $vids) . ")");
        if(vsql_num_rows($res) < 1) {
            return false;
        }
        $virt_vise = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $virt_vise[$row["virt"]][] = $row["vpsid"];
        }
        $ret = [];
        foreach ($virt_vise as $virt => $VPSIDs) {
            $ret += $GLOBALS[$virt . "_kernel"]->vs_ntw_speed($VPSIDs);
        }
        return $ret;
    }
    public function vs_disk_usage($vids)
    {
        global $globals;
        if(empty($vids)) {
            return false;
        }
        $res = makequery("SELECT vpsid, virt FROM `vps`\n\t\t\t\t\t\tWHERE vpsid IN (" . implode(",", $vids) . ")");
        if(vsql_num_rows($res) < 1) {
            return false;
        }
        $virt_vise = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $virt_vise[$row["virt"]][] = $row["vpsid"];
        }
        $ret = [];
        foreach ($virt_vise as $virt => $VPSIDs) {
            $ret += $GLOBALS[$virt . "_kernel"]->vs_disk_usage($VPSIDs);
        }
        return $ret;
    }
    public function vs_io_usage($vids)
    {
        global $globals;
        if(empty($vids)) {
            return false;
        }
        $res = makequery("SELECT vpsid, io_read, io_write FROM `status`WHERE `time` = (SELECT MAX(`time`) FROM `status`)AND vpsid IN ('" . implode("', '", $vids) . "')");
        $ret = [];
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $ret[$row["vpsid"]] = $row;
        }
        return $ret;
    }
    public function start($vpsid, &$s_ret = "")
    {
        global $globals;
        $vps = getvps($vpsid);
        $virt = $vps["virt"];
        return $GLOBALS[$virt . "_kernel"]->start($vpsid, $s_ret);
    }
    public function lb_save_config($lb_uuid, $config)
    {
        global $kernel;
        $vpsid = getvpsid($lb_uuid);
        $vps = getvps($vpsid);
        if(empty($vps)) {
            return false;
        }
        if(!$kernel->features("load_balancer", $vps["virt"])) {
            return false;
        }
        return $GLOBALS[$vps["virt"] . "_kernel"]->lb_save_config($lb_uuid, $config);
    }
    public function lb_self_signed_cert($lb_uuid, $filename)
    {
        global $kernel;
        $vpsid = getvpsid($lb_uuid);
        $vps = getvps($vpsid);
        if(empty($vps)) {
            return false;
        }
        if(!$kernel->features("load_balancer", $vps["virt"])) {
            return false;
        }
        return $GLOBALS[$vps["virt"] . "_kernel"]->lb_self_signed_cert($lb_uuid, $filename);
    }
    public function lb_use_own_cert($lb_uuid, $keys, $filename)
    {
        global $kernel;
        $vpsid = getvpsid($lb_uuid);
        $vps = getvps($vpsid);
        if(empty($vps)) {
            return false;
        }
        if(!$kernel->features("load_balancer", $vps["virt"])) {
            return false;
        }
        return $GLOBALS[$vps["virt"] . "_kernel"]->lb_use_own_cert($lb_uuid, $keys, $filename);
    }
    public function lb_get_logs($lb_uuid)
    {
        global $kernel;
        $vpsid = getvpsid($lb_uuid);
        $vps = getvps($vpsid);
        if(empty($vps)) {
            return false;
        }
        if(!$kernel->features("load_balancer", $vps["virt"])) {
            return false;
        }
        return $GLOBALS[$vps["virt"] . "_kernel"]->lb_get_logs($lb_uuid);
    }
    public function lb_get_status($lb_uuid)
    {
        global $kernel;
        $vpsid = getvpsid($lb_uuid);
        $vps = getvps($vpsid);
        if(empty($vps)) {
            return false;
        }
        if(!$kernel->features("load_balancer", $vps["virt"])) {
            return false;
        }
        return $GLOBALS[$vps["virt"] . "_kernel"]->lb_get_status($lb_uuid);
    }
    public function lb_get_stats($lb_uuid, $ip)
    {
        global $kernel;
        $vpsid = getvpsid($lb_uuid);
        $vps = getvps($vpsid);
        if(empty($vps)) {
            return false;
        }
        if(!$kernel->features("load_balancer", $vps["virt"])) {
            return false;
        }
        return $GLOBALS[$vps["virt"] . "_kernel"]->lb_get_stats($lb_uuid, $ip);
    }
    public function plan_backupvps($vpsid, $userid = -1, $force = 0)
    {
        global $globals;
        $vps = getvps($vpsid);
        $userid = $userid == -1 ? $vps["uid"] : $userid;
        if(empty($vps)) {
            return false;
        }
        $running = get_running_tasks(0, ["vpsbackups_plan", "restorevps_plan"], $vpsid);
        if(0 < $running) {
            return -1;
        }
        $actid = tasks_admin_process("vpsbackups_plan", "", 0, $vpsid, $userid, 0, 0);
        $force_bckp = "";
        if(!empty($force)) {
            $force_bckp = " -f";
        }
        vexec($globals["com"]["php"] . " /usr/local/virtualizor/scripts/vpsbackups_plan.php -a" . $actid . $force_bckp . "  > " . logdir("backup") . $vpsid . ".log 2>&1 &");
        return $actid;
    }
    public function backuply_eu_restore($vpsid, $backup_file, $backup_date, $old_vps = [])
    {
        global $globals;
        global $servers;
        $vps = getvps($vpsid);
        if(empty($vps)) {
            return false;
        }
        $running = get_running_tasks(0, ["backuply_vpsbackups_plan", "backuply_restorevps_plan"], $vpsid);
        if(0 < $running) {
            return -1;
        }
        $backup_plan = get_backup_plan($vpsid);
        if(empty($backup_plan)) {
            return false;
        }
        $bid = $backup_plan["bid"];
        $dir = $backup_plan["dir"];
        $backup_plan["bs_servergroups"] = _unserialize($backup_plan["bs_servergroups"]);
        $sgid = $servers[$vps["serid"]]["sgid"];
        if(!empty($backup_plan["bs_servergroups"]["bs_groups"][$sgid])) {
            $bid = $backup_plan["bs_servergroups"]["bs_groups"][$sgid];
        }
        if(!empty($backup_plan["bs_servergroups"]["dir_groups"][$sgid])) {
            $dir = $backup_plan["bs_servergroups"]["dir_groups"][$sgid];
        }
        if(!empty($backup_plan["bs_servergroups"]["bs_servers"][$globals["slave"]])) {
            $bid = $backup_plan["bs_servergroups"]["bs_servers"][$globals["slave"]];
        }
        if(!empty($backup_plan["bs_servergroups"]["dir_servers"][$globals["slave"]])) {
            $dir = $backup_plan["bs_servergroups"]["dir_servers"][$globals["slave"]];
        }
        $_vpsid = $vpsid;
        if(!empty($old_vps["vpsid"])) {
            $_vpsid = $old_vps["vpsid"];
        }
        $_dir = $dir . "/" . (!empty($old_vps) ? $old_vps["uuid"] : $vps["uuid"]);
        $temp_backuply_path = "";
        if($old_vps["from_serverid"] != $old_vps["to_serverid"]) {
            $temp_backuply_path = $globals["var"] . "/backuply/" . $old_vps["from_serverid"] . "/backuply.sqlite";
        }
        $disk_json = get_disk_json($_vpsid, 0, $temp_backuply_path);
        if(!empty($disk_json[$backup_date]["folder_format"])) {
            $_dir = $dir . "/" . $disk_json[$backup_date]["folder_format"];
        }
        $data = ["bid" => $bid, "dir" => $_dir, "backup_file" => $backup_file, "date" => $backup_date, "old_vpsid" => $old_vps["vpsid"], "from_serverid" => $old_vps["from_serverid"], "to_serverid" => $old_vps["to_serverid"]];
        if(!empty($backup_plan["enable_enduser_backup_servers"])) {
            $res = makequery("SELECT v.bserid, ebsr.dir FROM vps v\n\t\t\t\t\t\t\t\tINNER JOIN enduser_backup_servers ebsr ON ebsr.bserid = v.bserid\n\t\t\t\t\t\t\t\tWHERE v.vpsid = :vpsid", [":vpsid" => $vpsid]);
            if(0 < vsql_num_rows($res)) {
                $row = vsql_fetch_assoc($res);
                $data["bserid"] = $row["bserid"];
                $data["dir"] = $row["dir"];
            }
        }
        $actid = tasks_admin_process("backuply_restorevps_plan", $data, 0, $vpsid, $vps["uid"], 0, 0);
        vexec($globals["com"]["php"] . " " . $globals["scriptfiles"] . "/backuply_restorevps_plan.php -a" . $actid . " > " . logdir("restore") . $vpsid . ".log 2>&1 &");
        return $actid;
    }
    public function backuply_single_backup($vpsid, $type)
    {
        global $globals;
        $vps = getvps($vpsid);
        if(empty($vps)) {
            return false;
        }
        $running = get_running_tasks(0, ["backuply_vpsbackups_plan", "backuply_restorevps_plan"], $vpsid);
        if(0 < $running) {
            return -1;
        }
        $actid = tasks_admin_process("backuply_vpsbackups_plan", "", 0, $vpsid, $vps["uid"], 0, 0);
        vexec($globals["com"]["php"] . " " . $globals["scriptfiles"] . "/backuply_vpsbackups_plan.php -a" . $actid . " -t" . $type . " > " . logdir("backuply") . $vpsid . ".log 2>&1 &");
        return $actid;
    }
    public function plan_restorevps($vpsid, $date, $file)
    {
        global $globals;
        global $servers;
        $vps = getvps($vpsid);
        if(empty($vps) || !is_valid_backup_folder($date)) {
            return false;
        }
        $running = get_running_tasks(0, ["vpsbackups_plan", "restorevps_plan"], $vpsid);
        if(0 < $running) {
            return -1;
        }
        $backup_plan = get_backup_plan($vpsid);
        if(empty($backup_plan)) {
            return false;
        }
        $bid = $backup_plan["bid"];
        $dir = $backup_plan["dir"];
        $backup_plan["bs_servergroups"] = _unserialize($backup_plan["bs_servergroups"]);
        $sgid = $servers[$vps["serid"]]["sgid"];
        if(!empty($backup_plan["bs_servergroups"]["bs_groups"][$sgid])) {
            $bid = $backup_plan["bs_servergroups"]["bs_groups"][$sgid];
        }
        if(!empty($backup_plan["bs_servergroups"]["dir_groups"][$sgid])) {
            $dir = $backup_plan["bs_servergroups"]["dir_groups"][$sgid];
        }
        if(!empty($backup_plan["bs_servergroups"]["bs_servers"][$globals["slave"]])) {
            $bid = $backup_plan["bs_servergroups"]["bs_servers"][$globals["slave"]];
        }
        if(!empty($backup_plan["bs_servergroups"]["dir_servers"][$globals["slave"]])) {
            $dir = $backup_plan["bs_servergroups"]["dir_servers"][$globals["slave"]];
        }
        $data = ["backup_date" => $date, "bid" => $bid, "dir" => $dir, "backup_file" => $file];
        if(!empty($backup_plan["enable_enduser_backup_servers"])) {
            $res = makequery("SELECT v.bserid, ebsr.dir FROM vps v\n\t\t\t\t\t\t\t\tINNER JOIN enduser_backup_servers ebsr ON ebsr.bserid = v.bserid\n\t\t\t\t\t\t\t\tWHERE v.vpsid = :vpsid", [":vpsid" => $vpsid]);
            if(0 < vsql_num_rows($res)) {
                $row = vsql_fetch_assoc($res);
                $data["bserid"] = $row["bserid"];
                $data["dir"] = $row["dir"];
            }
        }
        $actid = tasks_admin_process("restorevps_plan", $data, 0, $vpsid, $vps["uid"], 0, 0);
        vexec($globals["com"]["php"] . " /usr/local/virtualizor/scripts/restorevps_plan.php -a" . $actid . " > " . logdir("restore") . $vpsid . ".log 2>&1 &");
        return $actid;
    }
    public function plan_listvpsbackups($vpsid)
    {
        global $globals;
        global $servers;
        $backup_plan = get_backup_plan($vpsid);
        if(empty($backup_plan)) {
            return false;
        }
        $dir = $backup_plan["dir"];
        $vps = getvps($vpsid);
        $sgid = $servers[$vps["serid"]]["sgid"];
        $bid = $backup_plan["bid"];
        $backup_plan["bs_servergroups"] = _unserialize($backup_plan["bs_servergroups"]);
        if(!empty($backup_plan["bs_servergroups"]["bs_groups"][$sgid])) {
            $bid = $backup_plan["bs_servergroups"]["bs_groups"][$sgid];
        }
        if(!empty($backup_plan["bs_servergroups"]["bs_servers"][$globals["slave"]])) {
            $bid = $backup_plan["bs_servergroups"]["bs_servers"][$globals["slave"]];
        }
        if(!empty($backup_plan["bs_servergroups"]["dir_groups"][$sgid])) {
            $dir = $backup_plan["bs_servergroups"]["dir_groups"][$sgid];
        }
        if(!empty($backup_plan["bs_servergroups"]["dir_servers"][$globals["slave"]])) {
            $dir = $backup_plan["bs_servergroups"]["dir_servers"][$globals["slave"]];
        }
        if($bid == -1) {
            $bid = 0;
        }
        $backup_server = [];
        if(!empty($bid)) {
            $res = makequery("SELECT * FROM backup_servers WHERE bid = :bid", [":bid" => $bid]);
            if(vsql_num_rows($res) == 0) {
                return false;
            }
            $backup_server = vsql_fetch_assoc($res);
        }
        if(!empty($backup_plan["enable_enduser_backup_servers"])) {
            $res = makequery("SELECT * FROM enduser_backup_servers WHERE bserid = :bserid", [":bserid" => $vps["bserid"]]);
            if(0 < vsql_num_rows($res)) {
                $row = vsql_fetch_assoc($res);
                $backup_server = array_replace($backup_server, $row);
                $dir = $backup_server["dir"];
            }
        }
        $bkup_regex = get_backup_regex($vpsid);
        $extensions = get_backup_extensions($vps["virt"]);
        $backups = [];
        $folders = [];
        if(empty($backup_server)) {
            $files = glob($dir . "/*/" . $vpsid . "*.*", GLOB_BRACE);
            $files2 = glob($dir . "/*/vzdump-*" . $vpsid . "*.*", GLOB_BRACE);
            foreach ($files as $file) {
                $date = basename(dirname($file));
                $name = basename($file);
                if(!is_valid_backup_folder($date)) {
                } else {
                    $folders[$date][] = $name;
                }
            }
            if(!empty($files2)) {
                foreach ($files2 as $file) {
                    $date = basename(dirname($file));
                    $name = basename($file);
                    if(!is_valid_backup_folder($date)) {
                    } else {
                        $folders[$date][] = $name;
                    }
                }
            }
        } elseif($backup_server["type"] == "FTP") {
            $ftp_con = connect_ftp($backup_server);
            if(!$ftp_con) {
                return false;
            }
            $list = _ftp_nlist($ftp_con, $dir);
            if(!empty($list)) {
                foreach ($list as $f) {
                    $fname = basename($f);
                    if(!is_valid_backup_folder($fname)) {
                    } else {
                        $rem_files = _ftp_nlist($ftp_con, $f);
                        $rem_files = array_map("basename", $rem_files);
                        $folders[$fname] = $rem_files;
                    }
                }
            }
        } elseif($backup_server["type"] == "SSH") {
            $connection = connect_ssh($backup_server);
            if(!$connection) {
                return false;
            }
            $sftp = ssh2_sftp($connection);
            $list = @scandir("ssh2.sftp://" . @intval($sftp) . $dir, SCANDIR_SORT_DESCENDING);
            if(!empty($list)) {
                foreach ($list as $f) {
                    if(!is_valid_backup_folder($f)) {
                    } else {
                        $rem_files = @scandir("ssh2.sftp://" . @intval($sftp) . $dir . "/" . $f);
                        $folders[$f] = $rem_files;
                    }
                }
            }
        }
        foreach ($folders as $folder => $files) {
            foreach ($files as $file) {
                if(preg_match($bkup_regex[1], $file, $matches) && empty($matches[4]) && in_array($matches[7], $extensions)) {
                    $backups[$folder][] = (string) $file;
                }
                if(preg_match($bkup_regex[2], $file, $matches2)) {
                    $matches3 = !empty($matches2[11]) ? $matches2[10] . "." . $matches2[11] : $matches2[10];
                    if($matches2[1] == "vzdump" && in_array($matches3, $extensions)) {
                        $backups[$folder][] = (string) $file;
                    }
                }
            }
        }
        return $backups;
    }
    public function plan_deletevpsbackup($vpsid, $date, $file)
    {
        global $globals;
        global $servers;
        $vpsid = (int) $vpsid;
        $date = (int) $date;
        if(!is_valid_backup_folder($date)) {
            return false;
        }
        $tasks_backup = tasks_running("vpsbackups_plan", $vpsid);
        $tasks_restore = tasks_running("restorevps_plan", $vpsid);
        $tasks = array_merge($tasks_backup, $tasks_restore);
        foreach ($tasks as $task) {
            $task_date = datify($task["started"], 0, 1, "Ymd");
            if($task_date == $date) {
                return false;
            }
        }
        $backup_plan = get_backup_plan($vpsid);
        if(empty($backup_plan)) {
            return false;
        }
        $dir = $backup_plan["dir"];
        $bid = $backup_plan["bid"];
        $vps = getvps($vpsid);
        $backup_plan["bs_servergroups"] = _unserialize($backup_plan["bs_servergroups"]);
        $sgid = $servers[$vps["serid"]]["sgid"];
        if(!empty($backup_plan["bs_servergroups"]["bs_groups"][$sgid])) {
            $bid = $backup_plan["bs_servergroups"]["bs_groups"][$sgid];
        }
        if(!empty($backup_plan["bs_servergroups"]["dir_groups"][$sgid])) {
            $dir = $backup_plan["bs_servergroups"]["dir_groups"][$sgid];
        }
        if(!empty($backup_plan["bs_servergroups"]["bs_servers"][$globals["slave"]])) {
            $bid = $backup_plan["bs_servergroups"]["bs_servers"][$globals["slave"]];
        }
        if(!empty($backup_plan["bs_servergroups"]["dir_servers"][$globals["slave"]])) {
            $dir = $backup_plan["bs_servergroups"]["dir_servers"][$globals["slave"]];
        }
        $backup_server = [];
        if(0 < $bid) {
            $res = makequery("SELECT * FROM backup_servers WHERE bid = :bid", [":bid" => $bid]);
            if(vsql_num_rows($res) == 0) {
                return false;
            }
            $backup_server = vsql_fetch_assoc($res);
        }
        if(!empty($backup_plan["enable_enduser_backup_servers"])) {
            $res = makequery("SELECT * FROM enduser_backup_servers WHERE bserid = :bserid", [":bserid" => $vps["bserid"]]);
            if(0 < vsql_num_rows($res)) {
                $row = vsql_fetch_assoc($res);
                $backup_server = array_replace($backup_server, $row);
                $dir = $backup_server["dir"];
            }
        }
        $bkup_regex = get_backup_regex($vpsid);
        $bkup_regex_inf = "/^(" . $vpsid . ")((_(\\d+))?(_([^.]+))?)?\\.inf\$/is";
        $extensions = get_backup_extensions($vps["virt"]);
        if(!empty($file)) {
            $files = backup_disk_list($vpsid, $file, $dir, $date, $backup_server, 1);
            if(empty($files)) {
                return false;
            }
        }
        if(!is_valid_backup_folder($date)) {
            return false;
        }
        if(empty($backup_server)) {
            if(!empty($files)) {
                foreach ($files as $_file) {
                    if(file_exists($dir . "/" . $date . "/" . $_file) && !@unlink($dir . "/" . $date . "/" . $_file)) {
                        return false;
                    }
                }
                return true;
            } else {
                $files = scandir($dir . "/" . $date);
                rsort($files);
                foreach ($files as $file) {
                    if(preg_match($bkup_regex[1], $file, $matches) && in_array($matches[7], $extensions) && !@unlink($dir . "/" . $date . "/" . $file)) {
                        return false;
                    }
                    if(in_array($vps["virt"], ["proxk", "proxl"]) && empty($matches) && preg_match($bkup_regex[2], $file, $matches2) && $matches2[1] == "vzdump") {
                        $matches3 = !empty($matches2[11]) ? $matches2[10] . "." . $matches2[11] : $matches2[10];
                        if(in_array($matches3, $extensions) && !@unlink($dir . "/" . $date . "/" . $file)) {
                            return false;
                        }
                    }
                    if(preg_match($bkup_regex_inf, $file) && !@unlink($dir . "/" . $date . "/" . $file)) {
                        return false;
                    }
                }
                return true;
            }
        } elseif($backup_server["type"] == "FTP") {
            $ftp_con = connect_ftp($backup_server);
            if(!$ftp_con) {
                return false;
            }
            if(!empty($files)) {
                foreach ($files as $_file) {
                    $ftp_size = ftp_size($ftp_con, $dir . "/" . $date . "/" . $_file);
                    if(0 < $ftp_size && !@ftp_delete($ftp_con, $dir . "/" . $date . "/" . $_file)) {
                        return false;
                    }
                }
                return true;
            } else {
                $files = _ftp_nlist($ftp_con, $dir . "/" . $date);
                rsort($files);
                foreach ($files as $file) {
                    $filename = basename($file);
                    if(preg_match($bkup_regex[1], $filename, $matches) && in_array($matches[7], $extensions) && !ftp_delete($ftp_con, $dir . "/" . $date . "/" . $filename)) {
                        return false;
                    }
                    if(in_array($vps["virt"], ["proxk", "proxl"]) && empty($matches) && preg_match($bkup_regex[2], $file, $matches2) && $matches2[1] == "vzdump") {
                        $matches3 = !empty($matches2[11]) ? $matches2[10] . "." . $matches2[11] : $matches2[10];
                        if(in_array($matches3, $extensions) && !ftp_delete($ftp_con, $dir . "/" . $date . "/" . $filename)) {
                            return false;
                        }
                    }
                    if(preg_match($bkup_regex_inf, $filename) && !ftp_delete($ftp_con, $dir . "/" . $date . "/" . $filename)) {
                        return false;
                    }
                }
                return true;
            }
        } elseif($backup_server["type"] == "SSH") {
            $connection = connect_ssh($backup_server);
            if(!$connection) {
                return false;
            }
            $sftp = ssh2_sftp($connection);
            if(!empty($file)) {
                foreach ($files as $_file) {
                    $statinfo = ssh2_sftp_stat($sftp, $dir . "/" . $date . "/" . $_file);
                    if(!empty($statinfo["size"]) && !@ssh2_sftp_unlink($sftp, $dir . "/" . $date . "/" . $_file)) {
                        return false;
                    }
                }
                return true;
            } else {
                $files = scandir("ssh2.sftp://" . intval($sftp) . $dir . "/" . $date);
                rsort($files);
                foreach ($files as $file) {
                    if(preg_match($bkup_regex[1], $file, $matches)) {
                        if(in_array($matches[7], $extensions) && !ssh2_sftp_unlink($sftp, $dir . "/" . $date . "/" . $file)) {
                            return false;
                        }
                        if(in_array($vps["virt"], ["proxk", "proxl"]) && empty($matches) && preg_match($bkup_regex[2], $file, $matches2) && $matches2[1] == "vzdump") {
                            $matches3 = !empty($matches2[11]) ? $matches2[10] . "." . $matches2[11] : $matches2[10];
                            if(in_array($matches3, $extensions) && !ssh2_sftp_unlink($sftp, $dir . "/" . $date . "/" . $file)) {
                                return false;
                            }
                        }
                        if(preg_match($bkup_regex_inf, $file) && !ssh2_sftp_unlink($sftp, $dir . "/" . $date . "/" . $file)) {
                            return false;
                        }
                    }
                }
                return true;
            }
        } else {
            return false;
        }
    }
    public function saveiso($actid, $isoid)
    {
        global $globals;
        if(empty($actid) || empty($isoid)) {
            return false;
        }
        vexec($globals["com"]["php"] . " /usr/local/virtualizor/scripts/saveiso.php " . $actid . " > " . logdir("saveiso") . $isoid . ".log 2>&1 &");
        return true;
    }
    public function deleuiso($actid)
    {
        global $globals;
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t  WHERE actid = :actid\n\t\t\t\t\t  AND action = 'delete_euiso'", [":actid" => $actid]);
        $data = [];
        if(vsql_num_rows($res) < 1) {
            return false;
        }
        $task = vsql_fetch_assoc($res);
        $data = unserialize($task["data"]);
        task_start($actid);
        $uid = $data["uid"];
        $isos = $data["iso"];
        if(empty($isos)) {
            return false;
        }
        foreach ($isos as $k => $v) {
            $file = $globals["euisos"] . "/" . $uid . "/" . $v["uuid"] . ".iso";
            $symlink = $globals["euisos"] . "/" . $v["uuid"] . ".iso";
            $proxk_symlink = $globals["isos"] . "/" . $v["uuid"] . ".iso";
            if(file_exists($file) && is_safe_file($file)) {
                @unlink($file);
            }
            if(is_link($symlink)) {
                @unlink($symlink);
            }
            if(is_link($proxk_symlink)) {
                @unlink($proxk_symlink);
            }
        }
        return true;
    }
    public function bandwidth($vid, $show = 0, $cusomDate = "")
    {
        global $user;
        global $globals;
        $vps = getvps($vid);
        $ret = [];
        $ret["limit"] = $vps["bandwidth"] * 1024;
        $ret["used"] = 0;
        $ret["usage"] = [];
        $ret["in"] = [];
        $ret["out"] = [];
        $vps_date = get_vps_service_period($vid, $show);
        $start = date("Ymd", $vps_date["start"]);
        $end = date("Ymd", $vps_date["end"]);
        $start1 = date("Y-m-d", $vps_date["start"]);
        $end1 = date("Y-m-d", $vps_date["end"]);
        if(!empty($cusomDate)) {
            function separateDates($dateString)
            {
                $dates = explode(",", $dateString);
                $separatedDates = [];
                foreach ($dates as $date) {
                    $dateParts = explode("/", $date);
                    $year = $dateParts[2];
                    $month = str_pad($dateParts[1], 2, "0", STR_PAD_LEFT);
                    $day = str_pad($dateParts[0], 2, "0", STR_PAD_LEFT);
                    $separatedDates[] = $year . $month . $day;
                }
                return $separatedDates;
            }
            function convertDateToUnixTimestamp($date)
            {
                $timestamp = strtotime($date);
                return $timestamp;
            }
            $result = separateDates($cusomDate);
            $separatedDate1 = convertDateToUnixTimestamp($result[0]);
            $separatedDate2 = convertDateToUnixTimestamp($result[1]);
            list($ret["custom_date"]["from"], $ret["custom_date"]["to"]) = $result;
            $start = date("Ymd", $separatedDate1);
            $end = date("Ymd", $separatedDate2);
            $start1 = date("Y-m-d", $separatedDate1);
            $end1 = date("Y-m-d", $separatedDate2);
        }
        $begin = new DateTime($start1);
        $ending = new DateTime($end1);
        $ending = $ending->modify("+1 day");
        $interval = new DateInterval("P1D");
        $daterange = new DatePeriod($begin, $interval, $ending);
        $ret["usage"] = [];
        foreach ($daterange as $date) {
            $i = $date->format("Ymd");
            $ret["usage"][$i] = 0;
            $ret["in"][$i] = 0;
            $ret["out"][$i] = 0;
        }
        $end = $date->format("Ymd");
        $res = makequery("SELECT * FROM bandwidth\n\t\t\t\t\t\tWHERE vpsid = :vid\n\t\t\t\t\t\tAND date >= :start\n\t\t\t\t\t\tAND date <= :end\n\t\t\t\t\t\tAND `time` = 0", [":vid" => $vid, ":start" => $start, ":end" => $end]);
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $dt = (int) $row["date"];
            $ret["usage"][$dt] = round(($row["in"] + $row["out"]) / 1024 / 1024, 2);
            $ret["in"][$dt] = empty($row["in"]) ? 0 : round($row["in"] / 1024 / 1024, 2);
            $ret["out"][$dt] = empty($row["out"]) ? 0 : round($row["out"] / 1024 / 1024, 2);
            if($globals["bw_cal_config"] == 1) {
                $ret["usage"][$dt] = $ret["in"][$dt];
            } elseif($globals["bw_cal_config"] == 2) {
                $ret["usage"][$dt] = $ret["out"][$dt];
            }
        }
        $ret["used"] = array_sum($ret["usage"]);
        $ret["free"] = empty($ret["limit"]) ? 0 : $ret["limit"] - $ret["used"];
        $ret["limit_gb"] = $ret["limit"] / 1024;
        $ret["used_gb"] = $ret["used"] / 1024;
        $ret["free_gb"] = empty($ret["limit"]) ? 0 : $ret["limit_gb"] - $ret["used_gb"];
        $ret["percent"] = $ret["limit"] ? $ret["used"] / $ret["limit"] * 100 : 0;
        $ret["percent_free"] = 100 - $ret["percent"];
        foreach ($ret as $k => $v) {
            if(is_numeric($ret[$k])) {
                $ret[$k] = round($v, 2);
            }
        }
        $res = makequery("SELECT (sum(`in`)/1024/1024) as 'in', (sum(`out`)/1024/1024) as 'out', vpsid, substr(`date`, 1, 6)  as 'date'FROM `bandwidth` WHERE vpsid = :vidAND `date` >= :gte_date AND `date` <= :lte_dateAND `time` = 0GROUP BY SUBSTR(`date`, 1, 6)", [":vid" => $vid, ":gte_date" => datify(time(), 0, 1, "Y") . "0101", ":lte_date" => datify(time(), 0, 1, "Ymd")]);
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $ret["yr_bandwidth"][(int) substr($row["date"], -2) - 1] = $row;
        }
        for ($i = 0; $i <= 11; $i++) {
            $j = $i;
            if($i < 10) {
                $j = "0" . $i;
            }
            if(empty($ret["yr_bandwidth"][(int) $j])) {
                $ret["yr_bandwidth"][(int) $j]["in"] = 0;
                $ret["yr_bandwidth"][(int) $j]["out"] = 0;
            }
        }
        asort($ret["yr_bandwidth"]);
        return $ret;
    }
    public function get_free_vncport($virt)
    {
        if(method_exists($GLOBALS[$virt . "_kernel"], "_newVncPort")) {
            return $GLOBALS[$virt . "_kernel"]->_newVncPort();
        }
        return false;
    }
    public function check_feature($virt, $feature)
    {
        if(method_exists($GLOBALS[$virt . "_kernel"], "has_feature")) {
            return $GLOBALS[$virt . "_kernel"]->has_feature($feature);
        }
        return false;
    }
    public function check_iommu_support()
    {
        global $globals;
        vexec("find /sys/kernel/iommu_groups/ -type l", $o, $r);
        return empty($o) ? false : true;
    }
    public function check_interruptremapping_support($data)
    {
        if($data["manu"] == "intel") {
            vexec("dmesg | grep ecap", $o1, $r1);
            foreach ($o1 as $v) {
                if(preg_match("/\\becap\\s[0-9a-f]{5}[a-f]/", $v)) {
                    return true;
                }
                return false;
            }
        } else {
            vexec("dmesg | grep AMD-Vi", $o1, $r1);
            foreach ($o1 as $v) {
                if(preg_match("/\\benabled\\sirq\\sremapping/i", $v)) {
                    return true;
                }
                return false;
            }
        }
    }
    public function get_iommugroup_members($data)
    {
        foreach ($data["pci"] as $k => $device_id) {
            vexec("ls /sys/bus/pci/devices/" . $device_id . "/iommu_group/devices/", $o, $r);
            if(empty($r)) {
                $return[$k] = $o;
            } else {
                $return["err"][] = $k;
            }
        }
        return $return;
    }
    public function node_pci_devices()
    {
        global $globals;
        $virts = explode(" ", $globals["kernel"]);
        foreach ($virts as $virt) {
            if(method_exists($GLOBALS[$virt . "_kernel"], "node_pci_devices")) {
                return $GLOBALS[$virt . "_kernel"]->node_pci_devices();
            }
        }
    }
    public function node_usb_devices()
    {
        global $globals;
        $virts = explode(" ", $globals["kernel"]);
        foreach ($virts as $virt) {
            if(method_exists($GLOBALS[$virt . "_kernel"], "node_usb_devices")) {
                return $GLOBALS[$virt . "_kernel"]->node_usb_devices();
            }
        }
    }
    public function node_gpuroms()
    {
        global $globals;
        $virts = explode(" ", $globals["kernel"]);
        foreach ($virts as $virt) {
            if(method_exists($GLOBALS[$virt . "_kernel"], "node_gpuroms")) {
                return $GLOBALS[$virt . "_kernel"]->node_gpuroms();
            }
        }
    }
    public function updatefirewall_plans($actid)
    {
        global $globals;
        vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/update_vpsfirewall.php " . $actid . " 2>&1 &");
        return true;
    }
}
function handle_speed_cap($v, &$kernel_obj, $bw = [])
{
    global $globals;
    global $l;
    $speed_cap_chk = "";
    $speed_cap_states = ["removed_speed_capped", "speed_capped"];
    if(!empty($v["speed_cap"]["reason"])) {
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\tWHERE vpsid = :vpsid\n\t\t\t\tAND action = :speed_cap_states\n\t\t\t\tAND started = 0 \n\t\t\t\tAND updated = 0 \n\t\t\t\tAND ended = 0", [":vpsid" => $v["vpsid"], ":speed_cap_states" => $speed_cap_states[0]]);
        $tmp_uvps = [];
        if(0 < vsql_num_rows($res)) {
            $tmp_uvps = vsql_fetch_assoc($res);
        }
        $day_to_unsus = "01";
        if(!empty($globals["band_calc_creation"])) {
            $day_to_unsus = datify($v["time"], 0, 1, "d");
            $date_to_unsus = datify($v["time"], 0, 1, "Ymd");
        }
        if(!empty($tmp_uvps) && datify(time(), 1, 0, "d") == $day_to_unsus && $bw["usage"][$date_to_unsus] < $bw["limit"] || $bw["used_gb"] < $v["bandwidth"]) {
            $v["speed_cap"]["bw"] = 0;
            $res = makequery("UPDATE vps\n\t\t\t\t\tSET speed_cap = :speed_cap\n\t\t\t\t\tWHERE vpsid = :vpsid", [":speed_cap" => serialize($v["speed_cap"]), ":vpsid" => $v["vpsid"]]);
            $reason = "";
            $speed_cap_chk = $speed_cap_states[0];
        }
    } elseif(empty($globals["speed_cap_disable"]) && !empty($v["speed_cap"]) && is_array($v["speed_cap"]) && (!empty($v["speed_cap"]["down"]) || !empty($v["speed_cap"]["up"])) && empty($v["nw_suspended"]) && empty($v["speed_cap"]["reason"]) && 0 < $bw["used_gb"] && !empty($bw["limit_gb"]) && $bw["limit_gb"] <= $bw["used_gb"]) {
        $v["speed_cap"]["bw"] = round($bw["used_gb"], 2);
        $res = makequery("UPDATE vps\n\t\t\t\t\tSET speed_cap = :speed_cap\n\t\t\t\t\tWHERE vpsid = :vpsid", [":speed_cap" => serialize($v["speed_cap"]), ":vpsid" => $v["vpsid"]]);
        $reason = serialize(["id" => "3", "reason" => "bw"]);
        $speed_cap_chk = $speed_cap_states[1];
    }
    if(!empty($speed_cap_chk)) {
        $kernel_obj->tc_destroy($v["vpsid"]);
        $ret = $kernel_obj->tc_create($v["vpsid"]);
        if(empty($GLOBALS["DONT_ECHO"])) {
            echo ($speed_cap_chk == $speed_cap_states[1] ? "Capping" : "Restoring") . " network speed of VPSID " . $v["vpsid"] . ". Bandwidth Used : " . $bw["used_gb"] . " Allowed : " . $bw["limit_gb"] . "\n";
        }
        if($speed_cap_chk == $speed_cap_states[1]) {
            vps_task($speed_cap_states[0], $v["vps_name"], 0, $v["vpsid"], $v["uid"], 1);
        } elseif($speed_cap_chk == $speed_cap_states[0]) {
            task_start($tmp_uvps["actid"]);
            task_update($tmp_uvps["actid"], $l["completed"], 100);
        }
        if(!empty($v["uid"]) && empty($globals["disable_speed_cap_email"])) {
            $res_email = makequery("SELECT `email` FROM `users` WHERE `uid`=:uid", [":uid" => $v["uid"]]);
            if(0 < vsql_num_rows($res_email)) {
                $tmp = vsql_fetch_assoc($res_email);
                if($speed_cap_chk == "speed_capped") {
                    $email_temp = "vps_net_speed_capped";
                } elseif($speed_cap_chk == "removed_speed_capped") {
                    $email_temp = "vps_net_speed_capped_restore";
                }
                $email_vars = ["hostname" => $v["hostname"], "used_gb" => $bw["used_gb"], "vpsid" => $v["vpsid"], "vps_name" => $v["vps_name"], "limit_gb" => $bw["limit_gb"], "sn" => $globals["sn"]];
                send_emailtemp_mail($email_temp, $tmp["email"], $email_vars);
                $data["title"] = $l[$speed_cap_chk . "_mail_sub"];
                $data["body"] = lang_vars_name($l[$speed_cap_chk . "_mail_notify"], $email_vars);
                save_notification("vps_band_suspended", $data);
            }
            $v = getvps($v["vpsid"], 0);
            $v["speed_cap"]["reason"] = $reason;
            $v["speed_cap"] = serialize($v["speed_cap"]);
            $res = makequery("UPDATE vps\n\t\t\t\t\tSET speed_cap = :speed_cap\n\t\t\t\t\tWHERE vpsid = :vpsid", [":speed_cap" => $v["speed_cap"], ":vpsid" => $v["vpsid"]]);
            logs_vps($speed_cap_chk, $v["vps_name"], 1, $v["vpsid"], $v["uid"]);
            to_master("vps", "speed_cap", $v["vpsid"], "vpsid", $v["speed_cap"]);
        }
    }
}
function no_log_status($vids, $live = false, &$kernel_obj = NULL)
{
    global $globals;
    if(is_null($kernel_obj)) {
        return false;
    }
    $GLOBALS["DONT_LOG"] = 1;
    $status = $kernel_obj->status($vids, $live);
    unset($GLOBALS["DONT_LOG"]);
    return $status;
}

?>