<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function invoices()
{
    global $theme;
    global $globals;
    global $user;
    global $l;
    global $error;
    global $done;
    global $invoices;
    if(!load_lang("admin/invoices")) {
        return false;
    }
    $theme["init_theme"] = "admin/invoices";
    $theme["init_theme_name"] = "invoices";
    $theme["init_theme_func"] = ["invoices_theme"];
    $theme["call_theme_func"] = "invoices_theme";
    if(empty($globals["inhouse_billing"])) {
        return false;
    }
    if(!is_allowed("invoices")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $del = optPOST("delete");
    if(!empty($del)) {
        $keyids = cexplode(",", $del, 1);
        $res = makequery("DELETE FROM invoices\n\t\t\t\t\t\t\tWHERE invoid IN ('-1', '" . implode("','", $keyids) . "')");
        if(vsql_affected_rows($res) == 0) {
            $error[] = $l["err_delete"];
            return false;
        }
        $done = true;
    }
    $where = [];
    $invoid = (int) optREQ("invoid");
    if(!empty($invoid)) {
        $where["invoid"] = "i.invoid = '" . $invoid . "'";
    }
    $email = optREQ("email");
    if(!empty($email)) {
        $where["email"] = "u.email LIKE '" . wildsearch($email) . "'";
    }
    $uid = optREQ("uid");
    if(!empty($uid)) {
        $where["uid"] = "u.uid = '" . $uid . "'";
    }
    $item = optREQ("item");
    if(!empty($item)) {
        $where["item"] = "i.item LIKE '" . wildsearch($item) . "'";
    }
    $invodate = optREQ("invodate");
    if(!empty($invodate) && strlen($invodate) == 10) {
        $tmp = explode("/", $invodate);
        $invodate = implode("", array_reverse($tmp));
        $where["invodate"] = "i.invodate = '" . $invodate . "'";
    }
    $duedate = optREQ("duedate");
    if(!empty($duedate) && strlen($duedate) == 10) {
        $tmp = explode("/", $duedate);
        $duedate = implode("", array_reverse($tmp));
        $where["duedate"] = "i.duedate = '" . $duedate . "'";
    }
    $paydate = optREQ("paydate");
    if(!empty($paydate) && strlen($paydate) == 10) {
        $tmp = explode("/", $paydate);
        $paydate = implode("", array_reverse($tmp));
        $where["paydate"] = "i.paydate = '" . $paydate . "'";
    }
    $res = makequery("SELECT COUNT(invoid) AS num FROM invoices i\n\t\t\t\tLEFT JOIN users u ON (u.uid = i.uid)\n\t\t\t\t" . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)));
    $globals["cur_page"] = get_page();
    $globals["reslen"] = (int) optREQ("reslen");
    $globals["reslen"] = $globals["reslen"] <= 0 ? 50 : $globals["reslen"];
    $tmp = vsql_fetch_assoc($res);
    $globals["num_res"] = $tmp["num"];
    $invoices = [];
    $res = makequery("SELECT i.*, u.email FROM invoices i\n\t\t\t\t\tLEFT JOIN users u ON (u.uid = i.uid)\n\t\t\t\t\t" . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)) . "\n\t\t\t\t\tORDER BY invoid DESC\n\t\t\t\t\tLIMIT " . $globals["cur_page"] . ", " . $globals["reslen"]);
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $row["status"] = bill_status($row);
        $row["status_txt"] = $l["bill_" . $row["status"]];
        $invoices[$row["invoid"]] = $row;
    }
}
function API_invoices()
{
    global $theme;
    global $globals;
    global $ckernel;
    global $user;
    global $l;
    global $error;
    global $done;
    global $invoices;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    $GLOBALS["_api"]["invoices"] = $invoices;
}

?>