<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function haproxy()
{
    global $theme;
    global $globals;
    global $user;
    global $cluster;
    global $servergroups;
    global $servers;
    global $arr_haproxy_src_ips;
    global $server_old_src_ips;
    global $supported_protocols;
    global $sshpkey;
    global $haproxydata;
    global $vpses;
    global $l;
    global $error;
    global $done;
    global $server_haconfigs;
    global $vpsips;
    if(!load_lang("admin/haproxy")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant_manage"], $l["slave_cant_exp"], $l["slave_cant_manage"]);
        return false;
    }
    $theme["init_theme"] = "admin/haproxy";
    $theme["init_theme_name"] = "haproxy";
    $theme["init_theme_func"] = ["haproxy_theme"];
    $theme["call_theme_func"] = "haproxy_theme";
    if(!is_allowed("haproxy")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    foreach ($servers as $k => $v) {
        $val = get_slave_settings($k);
        $servers[$k]["haproxy_enable"] = $val["haproxy_enable"];
        $servers[$k]["arr_haproxy_src_ips"] = !empty($val["haproxy_src_ips"]) ? preg_split("/\\s*\\,\\s*/", trim($val["haproxy_src_ips"])) : [server_publicip($k)];
        $servers[$k]["globals"] = $val;
        $server_haconfigs[$k] = ["haproxy_src_ips" => $val["haproxy_src_ips"], "haproxy_reservedports" => $val["haproxy_reservedports"], "haproxy_reservedports_http" => $val["haproxy_reservedports_http"], "haproxy_allowedports" => $val["haproxy_allowedports"]];
    }
    $haproxydata = [];
    $haproxydata = gethaproxylist();
    $supported_protocols = ["HTTP", "HTTPS", "TCP"];
    if(!empty($_POST)) {
        $action = optPOST("action");
        $serid = (int) optPOST("serid");
        $vpsuuid = optPOST("vpsuuid");
        $protocol = optPOST("protocol");
        $src_port = (int) optPOST("src_port");
        $dest_port = (int) optPOST("dest_port");
        $src_hostname = optPOST("src_hostname");
        $dest_ip = optPOST("dest_ip");
        $id = (int) optPOST("id");
        $ids = optPOST("ids");
        if(empty($servers[$serid])) {
            $error["invalid_server"] = $l["vdf_invalid_server"];
        }
        if($action == "getvps") {
            $vpses = [];
            $res = makequery("SELECT vpsid, vps_name, serid, uuid, uid, hostname \n\t\t\t\t\t\t\t FROM vps \n\t\t\t\t\t\t\t WHERE serid= :serid", [":serid" => $serid]);
            if(0 < vsql_num_rows($res)) {
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $vpses[$row["uuid"]] = $row;
                }
            }
            $done = 1;
            return NULL;
        }
        if(!empty($vpsuuid)) {
            $res = makequery("SELECT vpsid, vps_name, serid, uuid, uid, hostname \n\t\t\t\t\t\t\tFROM vps \n\t\t\t\t\t\t\tWHERE uuid = :vpsuuid", [":vpsuuid" => $vpsuuid]);
            if(0 < vsql_num_rows($res)) {
                $vps = vsql_fetch_assoc($res);
            }
        }
        if($action == "getvpsips" && !empty($vps)) {
            $res = makequery("SELECT ipid, ip, vpsid FROM ips\n\t\t\t\t\t\t\t\t  WHERE vpsid=:vpsid AND ipv6=0", [":vpsid" => $vps["vpsid"]]);
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $vpsips[$row["ip"]] = $row;
            }
            $done = 1;
            return NULL;
        }
        $server_page = (int) optPOST("server_page");
        if(!empty($server_page)) {
            foreach ($servers as $k => $v) {
                $o = "";
                $r = "";
                $cluster->cexec($k, 2, $o, $r);
                $servers[$k]["haproxy_status"] = $r;
                $servers[$k]["haproxy_status_out"] = $o;
            }
            $GLOBALS["_api"]["servers"] = $servers;
            $reload = (int) optPOST("reload");
            $get_server_old_src_ips = (int) optPOST("get_server_old_src_ips");
            $update_server_src_ips = (int) optPOST("update_server_src_ips");
            if($reload == 1) {
                if(!$cluster->save_haproxy($serid)) {
                    $error[] = lang_vars_name($l["err_reload_ha_service"], ["serid" => $serid]);
                    return false;
                }
                $cluster->cexec($serid, 2, $o, $r);
                $servers[$serid]["haproxy_status"] = $r;
                $servers[$serid]["haproxy_status_out"] = $o;
                $GLOBALS["_api"]["servers"][$serid] = $servers[$serid];
                $done["success"] = 1;
            } elseif($get_server_old_src_ips == 1) {
                $server_old_src_ips = [];
                $res = makequery("SELECT DISTINCT src_hostname FROM haproxy \n\t\t\t\t\t\t\tWHERE serid=:serid \n\t\t\t\t\t\t\tAND protocol='TCP'", [":serid" => $serid]);
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $server_old_src_ips[$serid][] = $row["src_hostname"];
                }
                $done["success"] = 1;
            } elseif($update_server_src_ips == 1) {
                $src_ips = $_POST["src_ips"];
                if(empty($src_ips) || !is_array($src_ips)) {
                    $error["update_server_src_ips"] = $l["empty_old_src_ips"];
                    return false;
                }
                $ip_ports = [];
                foreach ($haproxydata as $k => $v) {
                    if($v["protocol"] == "TCP" && $serid == $v["serid"]) {
                        $ip_ports[$v["src_hostname"]][$v["src_port"]][] = $v["src_port"];
                    }
                }
                $map_ips = [];
                $err_map_ips = "";
                foreach ($src_ips as $k => $v) {
                    $err_ports = [];
                    if($v == "-1" || !in_array($v, $servers[$serid]["arr_haproxy_src_ips"])) {
                    } else {
                        foreach ($ip_ports[$k] as $kk => $vv) {
                            $ip_ports[$v][$kk][] = $kk;
                            if(1 < count($ip_ports[$v][$kk])) {
                                $err_ports[] = $kk;
                            }
                        }
                        if(!empty($err_ports)) {
                            $err_map_ips[$k] = lang_vars_name($l["err_map_src_ips"], ["old_srcip" => $k, "new_scrip" => $v, "src_ports" => implode(", ", $err_ports)]);
                            if(1 < count($src_ips) && $v == $src_ips[$k] && $k == $src_ips[$v]) {
                                unset($err_map_ips[$k]);
                            }
                        }
                        $map_ips[] = [$k, $v];
                    }
                }
                unset($ip_ports);
                if(!empty($err_map_ips)) {
                    $error["update_server_src_ips"] = lang_vars_name($l["err_update_server_src_ips"], ["ip_ports" => implode("\n", $err_map_ips)]);
                    return false;
                }
                if(!empty($map_ips)) {
                    $query = "";
                    foreach ($map_ips as $k => $v) {
                        $query[0] .= "UPDATE haproxy SET \n\t\t\t\t\t\t\t\t\tsrc_hostname = '" . $k . "' \n\t\t\t\t\t\t\t\t\tWHERE src_hostname = '" . $v[0] . "'\n\t\t\t\t\t\t\t\t\tAND serid='" . $serid . "';";
                        $query[1] .= "UPDATE haproxy SET \n\t\t\t\t\t\t\t\t\tsrc_hostname = '" . $v[1] . "' \n\t\t\t\t\t\t\t\t\tWHERE src_hostname = '" . $k . "' \n\t\t\t\t\t\t\t\t\tAND serid = '" . $serid . "';";
                    }
                    $query = implode(" ", $query);
                    $res = update_query($query);
                    unset($query);
                }
                $cluster->save_haproxy($serid);
                $haproxydata = gethaproxylist();
                $done["success"] = 1;
                return true;
            }
            return true;
        } else {
            $is_managevdf = optPOST("managevdf");
            if(empty($action) && empty($is_managevdf)) {
                $error["action"] = $l["no_action"];
                return false;
            }
            $res = makequery("SELECT ipid, ip, vpsid FROM ips\n\t\t\t\t\tWHERE vpsid=:vpsid\n\t\t\t\t\tAND ipv6=0", [":vpsid" => $vps["vpsid"]]);
            if(0 < vsql_num_rows($res)) {
                for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $vps["ips"][$row["ip"]] = $row;
                }
            }
            $log_str = "";
            if($action == "addvdf" || $action == "editvdf") {
                if($action == "editvdf" && !empty($id)) {
                    $res = makequery("SELECT * FROM haproxy WHERE id=:id", [":id" => (int) $id]);
                    if(vsql_num_rows($res) == 1) {
                        $row = vsql_fetch_assoc($res);
                        $haproxydata[$row["id"]] = $row;
                    }
                }
                $log_str = $l["vdf_source"] . " (" . $src_hostname . ":" . $src_port . ") " . $l["vdf_destination"] . " (" . $dest_ip . ":" . $dest_port . ") " . $l["vdf_proto"] . ": " . $protocol;
                if(empty($servers[$serid]) || $serid == -1) {
                    $error["serid"] = $l["vdf_ser_not_found"];
                    return false;
                }
                if(empty($vps) || $vpsuuid == -1) {
                    $error["vpsid"] = lang_vars_name($l["vdf_vps_not_found"], ["vpsid" => $vps["vpsid"] . " - " . $vps["hostname"], "server" => $servers[$serid]["server_name"]]);
                    return false;
                }
                if(!in_array($protocol, $supported_protocols)) {
                    $error["proto"] = lang_vars_name($l["vdf_proto_no_support"], ["protocolid" => $protocol]);
                    return false;
                }
                if(!valid_ip($dest_ip) || !array_key_exists($dest_ip, $vps["ips"])) {
                    $error["dest_ip"] = lang_vars_name($l["vdf_inv_dest_ip"], ["dest_ip" => $dest_ip]);
                    return false;
                }
                if(!validate_ports_list($dest_port)) {
                    unset($error["validate_ports_list"]);
                    $error["dest_port"] = lang_vars_name($l["vdf_inv_dest_port"], ["dest_port" => $dest_port]);
                    return false;
                }
                if(!validate_ports_list($src_port)) {
                    unset($error["validate_ports_list"]);
                    $error["src_port"] = lang_vars_name($l["vdf_inv_src_port"], ["src_port" => $src_port]);
                    return false;
                }
                if($protocol == "TCP" && empty($servers[$serid]["globals"]["haproxy_src_ips"])) {
                    $error["empty_allowed_src_ips"] = $l["vdf_empty_allowed_src_ips"];
                    return false;
                }
                if(!validate_ports_list($src_port, $servers[$serid]["globals"]["haproxy_allowedports"], 1)) {
                    unset($error["validate_ports_list"]);
                    $error["src_port"] = lang_vars_name($l["vdf_notin_haproxy_allowedports"], ["src_port" => $src_port]);
                    return false;
                }
                if(!validate_ports_list($src_port, $servers[$serid]["globals"]["haproxy_reservedports"])) {
                    unset($error["validate_ports_list"]);
                    $error["src_port"] = lang_vars_name($l["vdf_in_haproxy_reservedports"], ["src_port" => $src_port]);
                    return false;
                }
                $update = true;
                if(!empty($id)) {
                    $update = false;
                    if($haproxydata[$id]["serid"] != $serid || $haproxydata[$id]["src_hostname"] != $src_hostname || $haproxydata[$id]["src_port"] != $src_port) {
                        $update = true;
                    }
                }
                $new = ["serid" => $serid, "src_hostname" => $src_hostname, "src_port" => $src_port];
                if($update && !vdf_no_duplicates($new, $serid)) {
                    $error["err_exist_src_hostname_and_port"] = lang_vars_name($l["vdf_err_exist_src_hostname_and_port"], ["src_hostname" => $src_hostname, "src_port" => $src_port]);
                    return false;
                }
                if($protocol == "TCP") {
                    if(empty($src_hostname) || !valid_ip($src_hostname) || $src_hostname == -1) {
                        $error["src_hname"] = lang_vars_name($l["vdf_inv_src_ip"], ["src_ip" => $src_hostname]);
                    } else {
                        $found = false;
                        foreach ($servers[$serid]["arr_haproxy_src_ips"] as $k => $v) {
                            if($v == $src_hostname) {
                                $found = true;
                            }
                        }
                        if(!$found) {
                            $error["src_hname"] = lang_vars_name($l["vdf_not_available_src_ip"], ["src_ip" => $src_hostname]);
                            return false;
                        }
                    }
                    if(!validate_ports_list($src_port, $servers[$serid]["globals"]["haproxy_reservedports_http"])) {
                        unset($error["validate_ports_list"]);
                        $error["src_port"] = lang_vars_name($l["vdf_in_haproxy_reservedports_http"], ["src_port" => $src_port]);
                        return false;
                    }
                } elseif(($protocol == "HTTP" || $protocol == "HTTPS") && (!is_valid_domain_name($src_hostname) || valid_ip($src_hostname))) {
                    $error["src_hname"] = lang_vars_name($l["vdf_inv_src_hostname"], ["src_hostname" => $src_hostname]);
                    return false;
                }
                if(($src_port == 80 || $src_port == 443) && $protocol == "TCP") {
                    $error["dest_port"] = lang_vars_name($l["vdf_port_not_supported_tcp"], ["src_port" => $src_port]);
                }
                if(empty($error) && (empty($haproxydata[$id]) || $src_port != $haproxydata[$id]["src_port"])) {
                    $where_tcp = "AND protocol='TCP'";
                    if($protocol == "TCP") {
                        $where_tcp = "AND ((protocol='TCP' AND src_hostname='" . $src_hostname . "') OR (protocol != 'TCP'))";
                    }
                    $tokens = [];
                    $tokens[":serid"] = $serid;
                    $tokens[":src_port"] = $src_port;
                    $res = makequery("SELECT id, protocol FROM haproxy \n\t\t\t\t\t\t\tWHERE serid=:serid \n\t\t\t\t\t\t\t" . $where_tcp . " \n\t\t\t\t\t\t\tAND src_port=:src_port", $tokens);
                    if(0 < vsql_num_rows($res)) {
                        $error["src_port"] = lang_vars_name($l["vdf_in_use_src_port"], ["src_port" => $src_port]);
                    }
                }
                if(!empty($error)) {
                    return false;
                }
                $tokens = [];
                $tokens[":vpsuuid"] = $vpsuuid;
                $tokens[":serid"] = $serid;
                $tokens[":protocol"] = $protocol;
                $tokens[":src_hostname"] = $src_hostname;
                $tokens[":src_port"] = $src_port;
                $tokens[":dest_ip"] = $dest_ip;
                $tokens[":dest_port"] = $dest_port;
                if($action == "addvdf") {
                    $tokens[":timeadded"] = time();
                    $query = "INSERT INTO haproxy SET \n\t\t\t\t\t\t\tvpsuuid = :vpsuuid, \n\t\t\t\t\t\t\tserid = :serid, \n\t\t\t\t\t\t\tprotocol = :protocol, \n\t\t\t\t\t\t\tsrc_hostname = :src_hostname, \n\t\t\t\t\t\t\tsrc_port = :src_port, \n\t\t\t\t\t\t\tdest_ip = :dest_ip, \n\t\t\t\t\t\t\tdest_port = :dest_port, \n\t\t\t\t\t\t\ttimeadded = :timeadded";
                    $res = insert_and_id($query, $tokens);
                    $done["msg"] = $l["vdf_success_add"] . "\n" . ($protocol != "TCP" ? lang_vars_name($l["vdf_note_point_domain"], ["src_hostname" => $src_hostname, "ips_list" => implode("\n", $servers[$serid]["arr_haproxy_src_ips"])]) : "");
                    $done["id"] = $res;
                    logs_vps($l["vdf_domain_forwarding"], $l["added"] . ":<br />" . $res . ": " . $log_str, 1, $vpses[$vpsuuid]["vpsid"], 0);
                } elseif($action == "editvdf") {
                    $tokens[":id"] = $id;
                    $tokens[":timeupdated"] = time();
                    $query = "UPDATE `haproxy` SET\n\t\t\t\t\t\tvpsuuid=:vpsuuid,\n\t\t\t\t\t\tserid=:serid,\n\t\t\t\t\t\tprotocol=:protocol,\n\t\t\t\t\t\tsrc_hostname=:src_hostname,\n\t\t\t\t\t\tsrc_port=:src_port,\n\t\t\t\t\t\tdest_ip=:dest_ip,\n\t\t\t\t\t\tdest_port=:dest_port,\n\t\t\t\t\t\ttimeupdated=:timeupdated\n\t\t\t\t\t\t\tWHERE id=:id\n\t\t\t\t\t\t\tAND vpsuuid=:vpsuuid \n\t\t\t\t\t\t\tAND serid=:serid";
                    $res = update_query($query, $tokens);
                    if(empty($res)) {
                        $error["query"] = "Update query failed";
                    } else {
                        $done["msg"] = $l["vdf_success_save"];
                    }
                    logs_vps($l["vdf_domain_forwarding"], $l["vdf_updated"] . ":<br />" . $id . ": " . $log_str, 1, $vpses[$vpsuuid]["vpsid"], 0);
                }
                if(!empty($done) && $protocol != "TCP") {
                    $done["note"] = lang_vars_name($l["vdf_note_point_domain"], ["src_hostname" => $src_hostname, "ips_list" => implode("\n", $servers[$serid]["arr_haproxy_src_ips"])]);
                }
            }
            if($action == "delvdf") {
                $log_str = "";
                if(empty($ids) && isset($id)) {
                    $ids = [$id];
                } else {
                    $ids = explode(",", trim($ids));
                }
                foreach ($ids as $k => $v) {
                    $log_str .= $v . ": " . $l["vdf_source"] . " (" . $haproxydata[$v]["src_hostname"] . ":" . $haproxydata[$v]["src_port"] . ") " . $l["vdf_destination"] . " (" . $haproxydata[$v]["dest_ip"] . ":" . $haproxydata[$v]["dest_port"] . ") " . $l["vdf_proto"] . ": " . $haproxydata[$v]["protocol"] . "<br />";
                    if(!in_array($v, array_keys($haproxydata))) {
                        $error["vdfids"] .= lang_vars_name($l["vdf_no_id_found"], ["id" => $v]) . "\n";
                    }
                }
                if(!empty($error)) {
                    return false;
                }
                $query = "DELETE FROM `haproxy` WHERE id IN (" . implode(",", $ids) . ")";
                $res = makequery($query);
                $done["msg"] = $l["vdf_success_del_entries"];
                logs_vps($l["vdf_domain_forwarding"], $l["vdf_removed" . (!isset($id) ? "_multiple" : "") . ""] . ":<br />" . $log_str, 1, $vpses[$vpsuuid]["vpsid"], 0);
            }
            if(!empty($done)) {
                $cluster->save_haproxy($serid);
            }
            if($is_managevdf) {
                if(empty($vps) && empty($id) && empty($ids)) {
                    $error["novps"] = lang_vars_name("vpsid: " . $vps["vpsid"] . ": " . $l["vdf_no_vps_id_found"], ["vpsid" => $vps["vpsid"] . " - " . $vps["hostname"]]);
                    return false;
                }
                $vpses = [$vpsuuid => $vps];
                $server_haconfigs = [$vps["serid"] => $server_haconfigs[$vps["serid"]]];
                $arr_haproxy_src_ips = $servers[$vps["serid"]]["arr_haproxy_src_ips"];
                $haproxydata = gethaproxylist(["h.vpsuuid='" . $vpsuuid . "'"]);
            } else {
                $haproxydata = gethaproxylist();
            }
        }
    }
    if(!empty($error)) {
        return false;
    }
    $haproxysearch = $_REQUEST["haproxysearch"];
    if(!empty($haproxysearch)) {
        $where = [];
        $s_id = (int) optREQ("s_id");
        if(!empty($s_id)) {
            $where["id"] = "id = '" . $s_id . "'";
        }
        $s_serid = (int) optREQ("s_serid");
        if(isset($_REQUEST["s_serid"]) && -1 < $s_serid) {
            $where["s_serid"] = "v.serid = '" . $s_serid . "'";
        }
        $s_vpsid = (int) optREQ("s_vpsid");
        if(!empty($s_vpsid)) {
            $where["s_vpsid"] = "v.vpsid = '" . $s_vpsid . "'";
        }
        $s_protocol = optREQ("s_protocol");
        if(isset($_REQUEST["haproxysearch"]) && -1 < $s_protocol) {
            $where["s_protocol"] = "h.protocol = '" . $s_protocol . "'";
        }
        $s_src_hostname = optREQ("s_src_hostname");
        if(!empty($s_src_hostname)) {
            $where["s_src_hostname"] = "h.src_hostname LIKE '" . wildsearch($s_src_hostname) . "'";
        }
        $s_src_port = (int) optREQ("s_src_port");
        if(!empty($s_src_port)) {
            $where["s_src_port"] = "h.src_port = '" . $s_src_port . "'";
        }
        $s_dest_ip = optREQ("s_dest_ip");
        if(!empty($s_dest_ip)) {
            $where["s_dest_ip"] = "h.dest_ip LIKE '" . wildsearch($s_dest_ip) . "'";
        }
        $s_dest_port = (int) optREQ("s_dest_port");
        if(!empty($s_dest_port)) {
            $where["s_dest_port"] = "h.dest_port = '" . $s_dest_port . "'";
        }
        $res = makequery("SELECT COUNT(id) AS num FROM haproxy h join vps v on(v.uuid=h.vpsuuid) \n\t\t\t\t\t\t" . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)));
        $globals["cur_page"] = get_page();
        $globals["reslen"] = (int) optREQ("reslen");
        $globals["reslen"] = $globals["reslen"] <= 0 ? 50 : $globals["reslen"];
        $tmp = vsql_fetch_assoc($res);
        $globals["num_res"] = $tmp["num"];
        $haproxydata = gethaproxylist($where);
    }
    return true;
}
function gethaproxylist($where = [])
{
    global $globals;
    if(!empty($where) && !is_array($where)) {
        $where = [$where];
    }
    $is_mangevdf = optPOST("managevdf");
    if(empty($is_mangevdf)) {
        $res = makequery("SELECT COUNT(id) AS num \n\t\t\t\t\tFROM haproxy h \n\t\t\t\t\tJOIN vps v ON (v.uuid = h.vpsuuid) \n\t\t\t\t\t" . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)));
        $globals["cur_page"] = get_page();
        $globals["reslen"] = (int) optREQ("reslen");
        $globals["reslen"] = $globals["reslen"] <= 0 ? 50 : $globals["reslen"];
        $tmp = vsql_fetch_assoc($res);
        $globals["num_res"] = $tmp["num"];
    }
    $haproxydata = [];
    $res = makequery("SELECT h.*, v.vpsid, v.vps_name, v.hostname\n\t\t\t\tFROM haproxy h \n\t\t\t\tJOIN vps v ON (v.uuid = h.vpsuuid)\n\t\t\t\t" . (empty($where) ? "" : "WHERE " . implode(" AND ", $where)) . (empty($is_mangevdf) ? "\n\t\t\t\tORDER BY id LIMIT " . $globals["cur_page"] . ", " . $globals["reslen"] : ""));
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        if($row["skipped"] != "") {
            $row["skipped"] = _unserialize($row["skipped"]);
            $row["skipped_json"] = json_encode($row["skipped"]);
        } else {
            $row["skipped"] = "";
        }
        $haproxydata[$row["id"]] = $row;
    }
    return $haproxydata;
}
function API_haproxy()
{
    global $theme;
    global $globals;
    global $user;
    global $servergroups;
    global $servers;
    global $haproxydata;
    global $arr_haproxy_src_ips;
    global $server_old_src_ips;
    global $supported_protocols;
    global $vpses;
    global $l;
    global $error;
    global $done;
    global $server_haconfigs;
    global $vpsips;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($haproxydata)) {
        $GLOBALS["_api"]["haproxydata"] = $haproxydata;
    }
    if(!empty($vpses)) {
        $GLOBALS["_api"]["vpses"] = $vpses;
    }
    if(!empty($arr_haproxy_src_ips)) {
        $GLOBALS["_api"]["arr_haproxy_src_ips"] = $arr_haproxy_src_ips;
    }
    if(!empty($supported_protocols)) {
        $GLOBALS["_api"]["supported_protocols"] = $supported_protocols;
    }
    if(!empty($server_old_src_ips)) {
        $GLOBALS["_api"]["server_old_src_ips"] = $server_old_src_ips;
    }
    $GLOBALS["_api"]["server_haconfigs"] = $server_haconfigs;
    $GLOBALS["_api"]["vpsips"] = $vpsips;
}

?>