<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function firewall()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $cluster;
    global $getservices;
    global $do;
    global $done;
    global $output;
    global $error;
    global $protocol_array;
    global $refined_ports;
    global $refined_ips;
    global $view_rule;
    global $firewall_info;
    global $no_service_found;
    global $action_ret;
    if(!load_lang("admin/firewall")) {
        return false;
    }
    $theme["init_theme"] = "admin/firewall";
    $theme["init_theme_name"] = "firewall";
    $theme["init_theme_func"] = ["firewall_theme"];
    $theme["call_theme_func"] = "firewall_theme";
    if(!is_allowed("firewall")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $cluster->configure_firewall($globals["server"]);
    $protocol_array = ["tcp" => "TCP", "udp" => "UDP"];
    $refined_ports = $cluster->get_iptables_ports($globals["server"]);
    $refined_ips = $cluster->get_iptables_ips($globals["server"]);
    if(optREQ("start")) {
        $action_ret = $cluster->onfirewall($globals["server"]);
        if(!empty($action_ret)) {
            $output[] = $l["firewall_start_success"];
        } else {
            $output[] = $l["firewall_start_error"];
        }
        return true;
    }
    if(optREQ("stop")) {
        $action_ret = $cluster->stopfirewall($globals["server"]);
        if(!empty($action_ret)) {
            $output[] = $l["firewall_stop_success"];
        } else {
            $output[] = $l["firewall_stop_error"];
        }
        return true;
    }
    if(optREQ("status")) {
        $output = $cluster->statusfirewall($globals["server"]);
        return true;
    }
    if(optREQ("restart")) {
        $action_ret = $cluster->restartfirewall($globals["server"]);
        if(!empty($action_ret)) {
            $output[] = $l["firewall_restart_success"];
        } else {
            $output[] = $l["firewall_restart_error"];
        }
        return true;
    }
    if(optREQ("version")) {
        $output = $cluster->versionfirewall($globals["server"]);
        return true;
    }
    if(optREQ("view")) {
        $output = $cluster->viewfirewall($globals["server"]);
        $view_rule = 1;
        return true;
    }
    $id = (int) optREQ("delete_rule");
    if(!empty($id)) {
        $output = $cluster->delete_firewall_rule($globals["server"], $id);
        $output = $cluster->viewfirewall($globals["server"]);
        $view_rule = 1;
        return true;
    }
    if(optREQ("setpolicy")) {
        $output = $cluster->setFirewallpolicy($globals["server"]);
        return true;
    }
    $firewall_info = $cluster->get_firewall_info($globals["server"]);
    $firewall_testing = optREQ("firewall_testing");
    if(!empty($firewall_testing)) {
        $ret = $cluster->enable_disable_firewall_testing($globals["server"], $firewall_testing);
        if(!empty($ret)) {
            $output[] = $l[$firewall_testing . "_testing"];
        }
        return true;
    }
    $testing_interval = (int) optREQ("testing_interval");
    if(isset($_REQUEST["testing_interval"]) && (empty($testing_interval) || $testing_interval < 0)) {
        $error[] = $l["invalid_min"];
        return false;
    }
    if(!empty($testing_interval)) {
        $ret = $cluster->enable_disable_firewall_testing($globals["server"], "", $testing_interval);
        if(!empty($ret)) {
            $output[] = $l["testing_interval_set"];
        }
        return true;
    }
    $port_action = "";
    if(optREQ("block")) {
        $port_action = "block";
    } elseif(optREQ("allow")) {
        $port_action = "allow";
    }
    if(!empty($port_action)) {
        $port = optREQ("port");
        $option = $port_action;
        if(!empty($port) && !preg_match("/^(?:\\d+[:,-])*\\d+\$/", $port)) {
            $error[] = $l["port_error"];
            return false;
        }
        $tmp_port = cexplode(",", $port, 0, 1);
        foreach ($tmp_port as $k => $v) {
            if(1 < preg_match_all("/(?:[:|-]{1})/", $v)) {
                $error[] = $l["port_error"];
                return false;
            }
            $tmp_port[$k] = trim($v);
        }
        $port = implode(",", $tmp_port);
        $action_ret = $cluster->allow_block_portfirewall($globals["server"], $port, $option);
        if(empty($action_ret)) {
            $output[] = $l["action_completed"];
        } elseif(!empty($action_ret["err_ports"])) {
            $output[] = $l["action_completed"] . $l["err_ports"] . explode(",", $ret["err_ports"]);
        } elseif(!empty($action_ret["firewall_disabled"])) {
            $error[] = $l["firewall_disabled"];
        } else {
            $error["port_error"] = $l["port_error"];
        }
        return true;
    } else {
        $ip_action = "";
        if(optREQ("ip_block")) {
            $ip_action = "block";
        } elseif(optREQ("ip_allow")) {
            $ip_action = "allow";
        }
        if(!empty($ip_action)) {
            $ip = optREQ("ip");
            $ip_protocol = optREQ("ip_protocol");
            $ip_port = optREQ("ip_port");
            $is_temp = optREQ("is_temp");
            $option = $ip_action;
            $tmp_ip = cexplode(",", $ip, 0, 1);
            foreach ($tmp_ip as $k => $_ip) {
                if(!empty($ip) && !valid_ip(trim($_ip))) {
                    $error["error"] = $l["ip_error"];
                } else {
                    $tmp_ip[$k] = trim($_ip);
                }
            }
            if(!empty($error)) {
                return false;
            }
            $ip = implode(",", $tmp_ip);
            if(!empty($ip_port)) {
                if(!preg_match("/^(?:\\d+[:,-])*\\d+\$/", $ip_port)) {
                    $error[] = $l["port_error"];
                    return false;
                }
                $tmp_port = cexplode(",", $ip_port, 0, 1);
                foreach ($tmp_port as $k => $v) {
                    if(1 < preg_match_all("/(?:[:|-]{1})/", $v)) {
                        $error[] = $l["port_error"];
                        return false;
                    }
                    $tmp_port[$k] = trim($v);
                }
                $ip_port = implode(",", $tmp_port);
            }
            $action_ret = $cluster->ip_allow_block_firewall($globals["server"], $ip, $option, $ip_protocol, $ip_port, $is_temp);
            if(empty($action_ret)) {
                $output[] = $l["action_completed"];
            } elseif(!empty($action_ret["err_ips"])) {
                $output[] = $l["action_completed"] . $l["err_ips"] . explode(",", $ret["err_ips"]);
            } elseif(!empty($action_ret["firewall_disabled"])) {
                $error[] = $l["firewall_disabled"];
            } else {
                $error["port_error"] = $l["port_error"];
            }
            return true;
        } elseif(optREQ("search")) {
            $ip = optREQ("ip");
            if(!valid_ip($ip)) {
                $error["error"] = $l["ip_error"];
            } else {
                $output = $cluster->searchip($globals["server"], $ip);
                if(empty($output)) {
                    $error["ip_not_found"] = $l["ip_not_found"];
                }
            }
            return true;
        }
    }
}
function API_firewall()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $cluster;
    global $getservices;
    global $do;
    global $done;
    global $output;
    global $error;
    global $refined_ports;
    global $refined_ips;
    global $view_rule;
    global $firewall_info;
    global $action_ret;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    $GLOBALS["_api"]["output"] = $output;
    $GLOBALS["_api"]["firewall_info"] = $firewall_info;
    $GLOBALS["_api"]["view_rule"] = $view_rule;
    $GLOBALS["_api"]["refined_ports"] = $refined_ports;
    $GLOBALS["_api"]["refined_ips"] = $refined_ips;
    $GLOBALS["_api"]["action_ret"] = $action_ret;
}

?>