<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function editvs()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $servers;
    global $oslist;
    global $done;
    global $virt;
    global $plans;
    global $ips;
    global $ips6;
    global $ips6_subnet;
    global $ips_int;
    global $ipools;
    global $ostemplates;
    global $vps;
    global $users;
    global $isos;
    global $resources;
    global $mgs;
    global $servergroups;
    global $scripts;
    global $iscripts;
    global $editedvs;
    global $storages;
    global $stid;
    global $disk_space;
    global $os_check;
    global $storage_uuids;
    global $disks;
    global $supported_nics;
    global $cpu_modes;
    global $backup_plans;
    global $bus_driver;
    global $ha_enabled;
    global $ajax_user;
    if(!load_lang("admin/editvs")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/editvs";
    $theme["init_theme_name"] = "editvs";
    $theme["init_theme_func"] = ["editvs_theme"];
    $theme["call_theme_func"] = "editvs_theme";
    if(!is_allowed("editvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $vpsid = optREQ("vpsid");
    $vps = getvps($vpsid, 0);
    if(empty($vps)) {
        redirect("act=vs");
    }
    if(empty($vps["uuid"])) {
        $res = makequery("UPDATE vps \n\t\t\t\t\t\tSET uuid = SUBSTR(SHA1(RAND()),1,16) \n\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $vpsid]);
        $vps = getvps($vpsid, 0);
    }
    set_active_server($vps["serid"]);
    $is_centos7 = $cluster->os_check($globals["server"], "centos", ">=", 7);
    $is_ubuntu12 = $cluster->os_check($globals["server"], "ubuntu", ">=", 12);
    $is_ubuntu12 or $os_check = $is_ubuntu12 || $is_centos7;
    $storage_types = $kernel->features("storage_types", $vps["virt"] . (!empty($vps["hvm"]) ? "hvm" : ""));
    foreach ($storages as $k => $v) {
        if(!empty($storage_types) && !in_array($v["type"], $storage_types)) {
            unset($storages[$k]);
        }
    }
    if(!empty($vps["disks"])) {
        $st_uuid = $vps["disks"][0]["st_uuid"];
        foreach ($storages as $sk => $sv) {
            if($sv["st_uuid"] == $st_uuid) {
                $stid = $sk;
                foreach ($vps["disks"] as $k => $v) {
                    if(empty($v["disk_uuid"])) {
                        $vps["disks"][$k]["disk_uuid"] = "d" . $k . $k;
                    }
                }
            }
        }
    }
    if(empty($stid)) {
        $stid = storage_get_primary($vps["virt"]);
    }
    if(empty($stid)) {
        $error["no_storage"] = $l["no_storage"];
        return false;
    }
    if(empty($storages[$stid])) {
        $error[] = $l["inv_storage"];
    }
    if(!empty($vps["rescue"])) {
        $error[] = $l["rescue_edit_no_allowed"];
        return false;
    }
    if(empty($vps["virt"])) {
        $vps["virt"] = server_primary_virt($vps["serid"]);
    }
    $virt = $vps["virt"];
    $vps["_virt"] = $vps["virt"] . (!empty($vps["hvm"]) ? "hvm" : "");
    $vps["_cpupin"] = cexplode(",", $vps["cpupin"], 1);
    $vps["ips"] = [];
    $res = makequery("SELECT i.*, ip.*, i.ipv6 FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.vpsid = :vpsid\n\t\t\t\t\tORDER BY `primary` DESC", [":vpsid" => $vpsid]);
    for ($i = 0; $i < vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        if(!empty($row["internal"])) {
            $vps["ips_int"][$row["ipid"]] = $row["ip"];
        } elseif(empty($row["ipv6"])) {
            $vps["ips"][$row["ipid"]] = $row["ip"];
        } elseif(!empty($row["ipv6"]) && !empty($row["ipr_netmask"])) {
            $vps["ips6_subnet"][$row["ipid"]] = $row["ip"] . "/" . $row["ipr_netmask"];
        } else {
            $vps["ips6"][$row["ipid"]] = $row["ip"];
        }
    }
    if(!empty($vps["dns_nameserver"])) {
        $vps["dns"] = unserialize($vps["dns_nameserver"]);
    }
    $load_ajax_user = optGET("load_ajax_user");
    if(!empty($load_ajax_user)) {
        $_email = optREQ("email");
        $ajax_user = get_ajax_user($_email);
        return true;
    }
    oslist();
    $vps["os_name"] = empty($vps["os_name"]) ? empty($vps["osid"]) || empty($ostemplates[$vps["osid"]]["name"]) ? $l["unknown"] : $ostemplates[$vps["osid"]]["name"] : $vps["os_name"];
    $mgs = listmgs();
    $servergroups = server_groups();
    if($kernel->features("iso_support", $vps["_virt"])) {
        useriso($vps["uid"]);
    }
    if($kernel->features("mac_support", $vps["_virt"])) {
        $macaddress = $cluster->getmacaddr($vpsid);
        if(!empty($macaddress)) {
            $vps["mac"] = $macaddress;
        }
    }
    $plans = [[]];
    $res = makequery("SELECT * FROM plans \n\t\t\t\t\tWHERE virt = :virt", [":virt" => $vps["_virt"]]);
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $plans[$row["plid"]] = $row;
        if(!empty($row["openvz_features"])) {
            $tmp_openvz_features = _unserialize($row["openvz_features"]);
            $plans[$row["plid"]] = array_merge($plans[$row["plid"]], $tmp_openvz_features);
        }
        if(!empty($row["speed_cap"])) {
            $tmp_plan = _unserialize($row["speed_cap"]);
            $plans[$row["plid"]]["speed_cap_down"] = $tmp_plan["down"];
            $plans[$row["plid"]]["speed_cap_up"] = $tmp_plan["up"];
        }
    }
    $plans[0] = end($plans);
    foreach ($plans[0] as $k => $v) {
        $plans[0][$k] = NULL;
    }
    $plans[0]["plid"] = 0;
    $plans[0]["plan_name"] = $l["none_plan"];
    $plid = optREQ("plid");
    $checkbox_plans = ["hvm", "ploop", "ubcsettings", "band_suspend", "tuntap", "ppp", "admin_managed", "virtio", "vnc", "kvm_vga", "acceleration", "pv_on_hvm", "disable_nw_config", "ha"];
    if(!empty($plid)) {
        foreach ($plans[$plid] as $k => $v) {
            if(in_array($k, $checkbox_plans) && empty($v)) {
            } elseif(in_array("num_" . $k, ["num_ips", "num_ips_int", "num_ips6", "num_ips6_subnet"])) {
                if(!isset($_POST["num_" . $k])) {
                    $_POST["num_" . $k] = $v;
                    $_REQUEST["num_" . $k] = $_POST["num_" . $k];
                }
            } else {
                if($k == "mgs" && !isset($_POST["mgs"])) {
                    $_POST["mgs"] = cexplode(",", $v, 1);
                    $_REQUEST["mgs"] = $_POST["mgs"];
                }
                if($k == "ippoolid" && !isset($_POST["ippoolid"]) && !empty($v)) {
                    $tmp_ippoolid = _unserialize($v);
                    $_POST["ippoolid"] = implode(",", $tmp_ippoolid);
                    $_REQUEST["ippoolid"] = $_POST["ippoolid"];
                }
                if(!isset($_POST[$k])) {
                    $_POST[$k] = $v;
                    $_REQUEST[$k] = $_POST[$k];
                }
                if($k == "dns_nameserver" && !isset($_POST["dns"])) {
                    $_POST["dns"] = _unserialize($plans[$plid]["dns_nameserver"]);
                    $_REQUEST["dns"] = $_POST["dns"];
                }
                if($k == "io" && !isset($_POST["priority"])) {
                    $_POST["priority"] = $v;
                    $_REQUEST["priority"] = $_POST["priority"];
                }
                if($k == "swap" && !isset($_POST["swapram"])) {
                    $_POST["swapram"] = $v;
                    $_REQUEST["swapram"] = $_POST["swapram"];
                }
            }
        }
    }
    $ip_pid = optREQ("ippoolid");
    if(!empty($plans[$vps["plid"]]["ippoolid"]) && empty($plid) && empty($ip_pid)) {
        $ip_pid = implode(",", _unserialize($plans[$vps["plid"]]["ippoolid"]));
    }
    if(!empty($ip_pid)) {
        $ip_pid = cexplode(",", $ip_pid, 1);
    }
    $resid = makequery("SELECT ippid FROM ippool_servers\n\t\t\t\t\t\tWHERE sgid = :sgid\n\t\t\t\t\t\tOR serid IN ('-1', :serid)", [":serid" => $vps["serid"], ":sgid" => $servers[$vps["serid"]]["sgid"]]);
    $ippid = [];
    for ($i = 0; $i < vsql_num_rows($resid); $i++) {
        $row = vsql_fetch_assoc($resid);
        $ippid[] = $row["ippid"];
    }
    $tmp_ippid = $ippid;
    $_ippid = [];
    if(!empty($ip_pid)) {
        foreach ($ip_pid as $i) {
            if(!empty($i) && in_array($i, $ippid)) {
                $_ippid[] = $i;
            }
        }
    }
    if(!empty($_ippid)) {
        $ippid = $_ippid;
    }
    $ips = [];
    $ips6 = [];
    $ips6_subnet = [];
    $ips_int = [];
    $ippid_token["tokens"] = [];
    if(!empty($ippid)) {
        $ippid_token = vsql_in_tokens($ippid);
    }
    $res = makequery("SELECT sum(ipv6) as ipv6_pool, sum(internal) as internal_pool FROM ippool WHERE ippid IN ('-1'" . (!empty($ippid) ? ", " . $ippid_token["query"] : "") . ")", $ippid_token["tokens"]);
    $row = vsql_fetch_assoc($res);
    $is_internal_pool = empty($row["internal_pool"]) ? $tmp_ippid : $ippid;
    $is_ipv6_pool = empty($row["ipv6_pool"]) ? $tmp_ippid : $ippid;
    $res = makequery("SELECT i.* FROM ips i\n\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid)\n\t\t\t\t\t\tWHERE (i.ippid IN (" . (count($ippid) < 1 ? -2 : $ippid_token["query"]) . ")\n\t\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :serid)))\n\t\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\t\tAND i.ipv6 = 0\n\t\t\t\t\t\tAND ip.internal = 0\n\t\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\t\tORDER BY i.ip\n\t\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($ippid_token["tokens"], [":serid" => $vps["serid"]]));
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $ips[$row["ipid"]] = $row;
    }
    $int_ippid_token["tokens"] = [];
    if(1 <= count($is_internal_pool)) {
        $int_ippid_token = vsql_in_tokens($is_internal_pool);
    }
    $res = makequery("SELECT i.*, ip.internal FROM ips i\n\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\t\tWHERE (i.ippid IN (" . (count($is_internal_pool) < 1 ? -2 : $int_ippid_token["query"]) . ")\n\t\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :ip_serid)))\n\t\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\t\tAND i.ipv6 = 0\n\t\t\t\t\t\tAND ip.internal = 1\n\t\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\t\tORDER BY i.ip\n\t\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($int_ippid_token["tokens"], [":ip_serid" => $vps["serid"]]));
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $ips_int[$row["ipid"]] = $row;
    }
    $ipv6_ippid_token["tokens"] = [];
    if(1 <= count($is_ipv6_pool)) {
        $ipv6_ippid_token = vsql_in_tokens($is_ipv6_pool);
    }
    $res = makequery("SELECT i.* FROM ips i\n\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\t\tWHERE (i.ippid IN (" . (count($is_ipv6_pool) < 1 ? -2 : $ipv6_ippid_token["query"]) . ")\n\t\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :ip_serid)))\n\t\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\t\tAND i.ipv6 = 1\n\t\t\t\t\t\tAND ip.internal = 0\n\t\t\t\t\t\tAND i.ipr_netmask = ''\n\t\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\t\tORDER BY i.ip\n\t\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($ipv6_ippid_token["tokens"], [":ip_serid" => $vps["serid"]]));
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $ips6[$row["ipid"]] = $row;
    }
    $ipv6_sub_ippid_token["tokens"] = [];
    if(1 <= count($is_ipv6_pool)) {
        $ipv6_sub_ippid_token = vsql_in_tokens($is_ipv6_pool);
    }
    $res = makequery("SELECT i.* FROM ips i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE (i.ippid IN (" . (count($is_ipv6_pool) < 1 ? -2 : $ipv6_sub_ippid_token["query"]) . ")\n\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :ip_serid)))\n\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\tAND i.ipv6 = 1\n\t\t\t\t\tAND i.ipr_netmask != ''\n\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\tORDER BY i.ip\n\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($ipv6_sub_ippid_token["tokens"], [":ip_serid" => $vps["serid"]]));
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $ips6_subnet[$row["ipid"]] = $row;
    }
    $res = makequery("SELECT uid, email, pid, inhouse_billing \n\t\t\t\t\tFROM users \n\t\t\t\t\tORDER BY email \n\t\t\t\t\tLIMIT 0, " . (empty($globals["load_user_limit"]) ? 250 : $globals["load_user_limit"]));
    $users = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $users[$row["uid"]] = $row;
    }
    if(empty($users[$vps["uid"]])) {
        $res = makequery("SELECT uid, email, pid, inhouse_billing\n\t\t\t\t\t\tFROM users \n\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $vps["uid"]]);
        $row = vsql_fetch_assoc($res);
        $users[$row["uid"]] = $row;
    }
    if(!empty($users[$vps["uid"]]["pid"]) && empty($users[$users[$vps["uid"]]["pid"]])) {
        $res = makequery("SELECT uid, email, pid, inhouse_billing \n\t\t\t\t\t\tFROM users \n\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $users[$vps["uid"]]["pid"]]);
        $row = vsql_fetch_assoc($res);
        $users[$row["uid"]] = $row;
    }
    $_tmp_user_email = optREQ("user_email");
    if(!empty($_tmp_user_email)) {
        foreach ($users as $k => $v) {
            if(strtolower($v["email"]) == strtolower($_tmp_user_email)) {
                $_POST["uid"] = $v["uid"];
            }
        }
    }
    $res = makequery("SELECT serid, sg_ha FROM servers \n\t\t\t\t\tRIGHT JOIN server_groups\n\t\t\t\t\tON (servers.sgid = server_groups.sgid)\n\t\t\t\t\tWHERE server_groups.sg_ha != ''");
    $ha_enabled = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        if(!empty($row["sg_ha"])) {
            $ha_enabled[$row["serid"]] = $row;
        }
    }
    $resources = $cluster->resources($vps["serid"], $vps["virt"]);
    foreach ($resources["storages"] as $_stid => $v) {
        $storage_uuids[$v["st_uuid"]] = $_stid;
        if(!empty($v["oversell"])) {
            $alloc_space = storage_allocated_space($_stid);
            $storages[$_stid]["disk_space"] = $v["oversell"] - $alloc_space;
        } else {
            $storages[$_stid]["disk_space"] = $v["free"];
        }
    }
    $supported_nics = $kernel->features("nic", $vps["_virt"]);
    $cpu_modes = $kernel->features("cpu_mode_list", $vps["_virt"]);
    $bus_driver = $kernel->features("bus_driver_list", $vps["_virt"]);
    $backup_plans = [];
    $res = makequery("SELECT * FROM backup_plans");
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $backup_plans[$row["bpid"]] = $row;
    }
    $owner = !empty($users[$vps["uid"]]["pid"]) ? $users[$vps["uid"]]["pid"] : $vps["uid"];
    if(!empty($globals["inhouse_billing"]) && !empty($users[$owner]["inhouse_billing"]) && !empty($plid) && $plid != $vps["plid"]) {
        foreach ($globals["resource_types"] as $resource) {
            $numval = $resource == "ips" ? count($vps["ips"]) : $vps[$resource];
            if($plans[$plid][$resource] < $numval) {
                $_POST[$resource] = $vps[$resource];
                $_REQUEST[$resource] = $vps[$resource];
            }
        }
    }
    if(isset($_POST["editvps"])) {
        $editvs = [];
        $editvs["pass"] = optPOST("rootpass");
        $editvs["plid"] = (int) optPOST("plid");
        $editvs["hostname"] = POST("hostname", $l["no_hname"]);
        $editvs["space"] = $_POST["space"];
        $editvs["bus_driver"] = optPOST("bus_driver");
        $editvs["bus_driver_num"] = (int) optPOST("bus_driver_num");
        $editvs["ram"] = (int) POST("ram", $l["no_ram"], 0);
        $editvs["bandwidth"] = (int) POST("bandwidth", $l["no_bandwidth"]);
        $editvs["cores"] = (int) POST("cores", $l["no_cpu_cores"]);
        $editvs["cpupin"] = -1;
        $editvs["uid"] = (int) POST("uid", $l["no_uid"]);
        $editvs["network_speed"] = (int) optPOST("network_speed");
        $editvs["upload_speed"] = (int) optPOST("upload_speed");
        $editvs["virt"] = $vps["virt"];
        $editvs["hvm"] = $vps["hvm"];
        $editvs["io"] = 0;
        $editvs["burst"] = 0;
        $editvs["cpu_percent"] = 0;
        $editvs["swap"] = 0;
        $editvs["acpi"] = 0;
        $editvs["apic"] = 0;
        $editvs["pae"] = 0;
        $editvs["vnc"] = 0;
        $editvs["shadow"] = 0;
        $editvs["iso"] = "";
        $editvs["boot"] = "";
        $editvs["band_suspend"] = (int) optREQ("band_suspend") ? 1 : 0;
        $editvs["speed_cap_down"] = (int) optPOST("speed_cap_down");
        $editvs["speed_cap_up"] = (int) optPOST("speed_cap_up");
        $editvs["pv_on_hvm"] = 0;
        $editvs["tuntap"] = 0;
        $editvs["ppp"] = 0;
        $editvs["mac_status"] = 0;
        $editvs["osreinstall_limit"] = (int) optPOST("osreinstall_limit");
        $editvs["mg"] = [];
        $editvs["webuzo"] = (int) optPOST("sid");
        $editvs["numa"] = 0;
        $editvs["cpu_mode"] = optPOST("cpu_mode");
        $editvs["admin_managed"] = (int) optREQ("admin_managed") ? 1 : 0;
        $editvs["rdp"] = (int) optREQ("rdp") ? 1 : 0;
        $editvs["disable_nw_config"] = (int) optREQ("disable_nw_config") ? 1 : 0;
        $editvs["topology_sockets"] = 0;
        $editvs["topology_cores"] = 0;
        $editvs["topology_threads"] = 0;
        $editvs["openvz_features"] = "";
        $editvs["bpid"] = (int) optPOST("bpid");
        $editvs["install_xentools"] = (int) optPOST("install_xentools");
        $editvs["sec_iso"] = optPOST("sec_iso");
        if($kernel->features("os_type", $vps["virt"])) {
            $editvs["os_type"] = optPOST("os_type");
            if(empty($editvs["os_type"])) {
                $editvs["os_type"] = "other";
            }
        }
        if($kernel->features("rtc", $vps["virt"])) {
            $editvs["rtc"] = optPOST("rtc");
        }
        $additional_params = ["ram", "bandwidth", "cores", "num_ips", "num_ips_int", "num_ips6", "num_ips6_subnet"];
        $additional_params = array_unique($additional_params);
        foreach ($additional_params as $ak => $av) {
            $tmp_additional = optREQ("additional_" . $av);
            if(!empty($tmp_additional)) {
                $editvs[$av] = $editvs[$av] + $tmp_additional;
                $_POST[$av] = $_POST[$av] + $tmp_additional;
            }
        }
        if(!empty($editvs["bpid"]) && $editvs["bpid"] != -1 && empty($backup_plans[$editvs["bpid"]])) {
            $error[] = $l["inv_bpid"];
        }
        if(json_decode($editvs["space"]) || json_decode($editvs["space"]) != NULL) {
            $editvs["space"] = json_decode($editvs["space"], 1);
        }
        $bus_driver_dupes = [];
        if(is_array($editvs["space"]) && !empty($editvs["space"])) {
            foreach ($editvs["space"] as $k => $v) {
                $v["size"] = (int) $v["size"];
                if($k == 0 && 2000 <= $v["size"] && empty($globals["disable_2tb_check"]) && $vps["space"] < $v["size"]) {
                    $error[] = $l["err_max_size"];
                }
                if($v["size"] < 1 || empty($v["st_uuid"])) {
                    $error[] = $l["inv_space"];
                }
                if(empty($storages[$storage_uuids[$v["st_uuid"]]])) {
                    $error[] = $l["inv_storage"];
                }
                if($bus_driver) {
                    if(!array_key_exists($v["bus_driver"], $bus_driver)) {
                        $error[] = $l["inv_bus_driver"];
                    }
                    $v["bus_driver_num"] = (int) $v["bus_driver_num"];
                    $bus_driver_type = $v["bus_driver"] . $v["bus_driver_num"];
                    array_push($bus_driver_dupes, $bus_driver_type);
                }
            }
            $editvs["space"] = array_values($editvs["space"]);
            if($bus_driver && count($bus_driver_dupes) != count(array_count_values($bus_driver_dupes))) {
                $error[] = $l["inv_bus_driver_num_format"];
            }
        } elseif(is_numeric($editvs["space"])) {
            $additional_space = (int) optREQ("additional_space");
            if(!empty($additional_space)) {
                $editvs["space"] = $editvs["space"] + $additional_space;
            }
            $tmp_space = $vps["disks"];
            if(2000 <= $editvs["space"] && empty($globals["disable_2tb_check"]) && $tmp_space[0]["size"] < $editvs["space"]) {
                $error[] = $l["err_max_size"];
            }
            if($kernel->features("multiple_disk_support", $vps["_virt"])) {
                $tmp_primary = $editvs["space"] - $vps["space"] + $tmp_space[0]["size"];
                if($tmp_space[0]["size"] < $tmp_primary) {
                    $tmp_space[0]["size"] = $tmp_primary;
                } else {
                    $tmp_space[0]["size"] = (int) $editvs["space"];
                }
            } else {
                $tmp_space[0]["st_uuid"] = $storages[$stid]["st_uuid"];
                $tmp_space[0]["size"] = (int) $editvs["space"];
                $tmp_space[0]["disk_uuid"] = $vps["disks"][0]["disk_uuid"];
            }
            if($bus_driver) {
                $tmp_space[0]["bus_driver"] = $editvs["bus_driver"];
                $tmp_space[0]["bus_driver_num"] = (int) $editvs["bus_driver_num"];
            }
            $editvs["space"] = $tmp_space;
        }
        if(count($editvs["space"]) < 1) {
            $error[] = $l["no_disk_space"];
        }
        if(1 < count($editvs["space"]) && !$kernel->features("multiple_disk_support", $vps["_virt"])) {
            $error[] = $l["mul_storage"];
        }
        $disks = $editvs["space"];
        if($kernel->features("disks_support", $vps["virt"]) && ($disks[0]["st_uuid"] != $vps["disks"][0]["st_uuid"] || $disks[0]["disk_uuid"] != $vps["disks"][0]["disk_uuid"])) {
            $error[] = $l["primary_disk_modified"];
        }
        $total_space = 0;
        $space_required = [];
        foreach ($disks as $k => $v) {
            $space_required[$v["st_uuid"]] = $v["size"] + (int) $space_required[$v["st_uuid"]];
            $total_space += $v["size"];
        }
        foreach ($vps["disks"] as $ok => $v) {
            $space_required[$v["st_uuid"]] = (int) $space_required[$v["st_uuid"]] - $v["size"];
        }
        if(!$kernel->features("disks_support", $vps["virt"])) {
            foreach ($space_required as $ok => $v) {
                $space_required[$ok] = (int) $v - $vps["space"];
            }
        }
        if($kernel->features("ha", $vps["virt"])) {
            $editvs["ha"] = (int) optPOST("ha");
        }
        $editvs["space"] = $total_space;
        foreach ($space_required as $kk => $_space) {
            if($_space < 1) {
            } elseif($storages[$storage_uuids[$kk]]["disk_space"] < $_space) {
                $error[] = $l["less_space"];
            }
        }
        if(!isset($_POST["upload_speed"]) || strlen($_POST["upload_speed"]) < 1) {
            $editvs["upload_speed"] = -1;
        }
        if(empty($editvs["band_suspend"]) && (!empty($editvs["speed_cap_down"]) || !empty($editvs["speed_cap_up"]))) {
            validate_speed_cap($editvs["speed_cap_down"], $editvs["speed_cap_up"], $editvs["network_speed"], $editvs["upload_speed"]);
            $editvs["speed_cap"]["down"] = $editvs["speed_cap_down"];
            $editvs["speed_cap"]["up"] = $editvs["speed_cap_up"];
        } else {
            $editvs["speed_cap"] = "";
        }
        if(empty($editvs["cores"])) {
            $error["cores"] = $l["inv_cpu_cores"] . " : " . $editvs["cores"];
        }
        if(!empty($error)) {
            return false;
        }
        if(isset($_POST["mgs"])) {
            foreach ($_POST["mgs"] as $k => $v) {
                $v = (int) $v;
                if(empty($mgs[$v]) || $mgs[$v]["mg_type"] != $vps["_virt"]) {
                } else {
                    $editvs["mg"][$v] = $v;
                }
            }
        }
        $nic_type = optPOST("nic_type");
        if(!empty($nic_type)) {
            $editvs["nic_type"] = $nic_type;
        }
        $vif_type = optPOST("vif_type");
        if(!empty($vif_type)) {
            $editvs["vif_type"] = $vif_type;
        }
        if($kernel->features("mac_support", $vps["_virt"])) {
            $editvs["mac"] = optPOST("mac");
            $maclen = strlen($editvs["mac"]);
            if(!empty($maclen)) {
                if(!valid_mac($editvs["mac"])) {
                    $error["mac"] = $l["err_mac"];
                }
                $editvs["mac_status"] = 1;
            }
        }
        if($kernel->features("vnc_key_map", $vps["virt"])) {
            $editvs["vnc_keymap"] = optPOST("vnc_keymap");
            if(!empty($editvs["vnc_keymap"]) && !in_array($editvs["vnc_keymap"], ["en-us", "de-ch", "ar", "da", "et", "fo", "fr-be", "fr-ch", "hu", "it", "lt", "mk", "nl", "no", "pt", "ru", "sv", "tr", "de", "en-gb", "es", "fi", "fr", "fr-ca", "hr", "is", "ja", "lv", "nl-be", "pl", "pt-br", "sl", "th"])) {
                $error[] = $l["inv_vnc_keymap"];
            }
        }
        if($kernel->features("cpu_pinning", $vps["virt"]) && is_array($_POST["cpupin"]) && !empty($resources["cpucores"])) {
            $cores = [];
            foreach ($_POST["cpupin"] as $k => $v) {
                $v = (int) $v;
                if($v < 0 || $resources["cpucores"] <= $v) {
                } else {
                    $cores[$v] = $v;
                }
            }
            $editvs["cpupin"] = implode(",", $cores);
        }
        if($kernel->features("tun_tap", $virt)) {
            $editvs["tuntap"] = (int) optREQ("tuntap") ? 1 : 0;
        }
        if($vps["virt"] == "openvz" || $vps["virt"] == "vzo" || $vps["virt"] == "proxo") {
            $editvs["ppp"] = (int) optREQ("ppp") ? 1 : 0;
            $editvs["ploop"] = !empty($vps["ploop"]) ? 1 : ((int) optREQ("ploop") ? 1 : 0);
            $openvz_features["fuse"] = (int) optREQ("fuse");
            $openvz_features["ipip"] = (int) optREQ("ipip");
            $openvz_features["ipgre"] = (int) optREQ("ipgre");
            $openvz_features["nfs"] = (int) optREQ("nfs");
            $openvz_features["quotaugidlimit"] = (int) optREQ("quotaugidlimit");
            $openvz_features["iolimit"] = (int) optREQ("iolimit");
            $openvz_features["iopslimit"] = (int) optREQ("iopslimit");
            $editvs["openvz_features"] = serialize($openvz_features);
        }
        if($vps["virt"] == "openvz" || $vps["virt"] == "proxo") {
            $editvs["io"] = (int) POST("priority", $l["no_io"]);
            $editvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
            $editvs["burst"] = (int) POST("burst", $l["no_burst_ram"]);
            $editvs["cpu_percent"] = (int) POST("cpu_percent", $l["no_percent_cpu"]);
            if($editvs["burst"] == 0 && distro_check(1)) {
                $error["no_burst_ram"] = $l["no_burst_ram"];
            }
        } elseif($vps["virt"] == "xen" && empty($vps["hvm"])) {
            $editvs["vnc"] = (int) optREQ("vnc") ? 1 : 0;
            $editvs["swap"] = (int) optPOST("swapram");
            $editvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
            $editvs["cpu_percent"] = (int) optPOST("cpu_percent");
            if(!empty($editvs["vnc"])) {
                $editvs["vncpass"] = optPOST("vncpass");
                if(preg_match("/[^A-Za-z0-9]/is", $editvs["vncpass"])) {
                    $error[] = $l["no_nonalphanumeric"];
                }
            }
        } elseif($vps["virt"] == "xen" && !empty($vps["hvm"]) || $vps["virt"] == "kvm" || $vps["virt"] == "xcp" || $vps["virt"] == "proxk") {
            $editvs["vnc"] = (int) optREQ("vnc") ? 1 : 0;
            $editvs["swap"] = (int) optPOST("swapram");
            $editvs["acpi"] = (int) optREQ("acpi") ? 1 : 0;
            $editvs["apic"] = (int) optREQ("apic") ? 1 : 0;
            $editvs["pae"] = (int) optREQ("pae") ? 1 : 0;
            if(isset($_REQUEST["boot"])) {
                $editvs["boot"] = optPOST("boot") == "dca" ? "dca" : "cda";
                if(empty($vps["osid"]) && (!empty($vps["iso"]) || !empty($vps["sec_iso"]))) {
                    $editvs["boot"] = "dca";
                }
            }
            $editvs["cpu_percent"] = (int) optPOST("cpu_percent");
            $editvs["iso"] = optPOST("iso");
            if(pathinfo($editvs["iso"], PATHINFO_EXTENSION) == "iso") {
                foreach ($isos as $iok => $iov) {
                    if($iov["filename"] == $editvs["iso"]) {
                        $editvs["iso"] = $iok;
                    }
                }
            }
            if(empty($isos[$editvs["iso"]])) {
                $editvs["iso"] = "";
            }
            if($vps["virt"] == "kvm" || $vps["virt"] == "proxk") {
                $editvs["cpu"] = (int) optPOST("cpu");
                if($kernel->features("kvm_cache", $vps["virt"])) {
                    $editvs["kvm_cache"] = optPOST("kvm_cache");
                    if(!empty($editvs["kvm_cache"]) && !in_array($editvs["kvm_cache"], ["default", "writeback", "writethrough", "directsync"])) {
                        $error[] = $l["inv_kvm_cache"];
                    }
                }
                if($kernel->features("io_mode", $vps["virt"])) {
                    $editvs["io_mode"] = optPOST("io_mode");
                    if(!empty($editvs["io_mode"]) && !in_array($editvs["io_mode"], ["native", "threads"])) {
                        $error[] = $l["inv_io_mode"];
                    }
                }
                if(!empty($os_check) || $kernel->features("iops_sec", $virt)) {
                    $editvs["total_iops_sec"] = (int) optPOST("total_iops_sec");
                    $editvs["read_bytes_sec"] = (int) optPOST("read_bytes_sec");
                    $editvs["write_bytes_sec"] = (int) optPOST("write_bytes_sec");
                }
                if(isset($_POST["virtio"])) {
                    $virtio = (int) optPOST("virtio");
                } else {
                    $virtio = (int) $vps["virtio"];
                }
                $editvs["virtio"] = $virtio;
                $editvs["kvm_vga"] = (int) optREQ("kvm_vga") ? 1 : 0;
                $editvs["acceleration"] = 0;
                if(!empty($editvs["kvm_vga"])) {
                    $editvs["acceleration"] = (int) optREQ("acceleration") ? 1 : 0;
                }
                if(!empty($editvs["cpu_mode"]) && empty($cpu_modes[$editvs["cpu_mode"]])) {
                    $error[] = $l["inv_cpu_mode"];
                    return false;
                }
                if(4 <= count($disks) && (!empty($editvs["sec_iso"]) || !empty($editvs["iso"])) && (empty($editvs["virtio"]) || $editvs["virtio"] == 3)) {
                    $error[] = $l["kvm_ide_limit"];
                    return false;
                }
            } elseif($vps["virt"] == "xcp") {
                $editvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
            } else {
                $editvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
                $editvs["shadow"] = (int) POST("shadow", $l["no_shadow"]);
            }
            if($kernel->features("cpu_topology", $vps["virt"])) {
                $editvs["topology_sockets"] = (int) optPOST("topology_sockets");
                $editvs["topology_cores"] = (int) optPOST("topology_cores");
                $editvs["topology_threads"] = (int) optPOST("topology_threads");
                if(!empty($editvs["topology_sockets"]) || !empty($editvs["topology_cores"]) || !empty($editvs["topology_threads"])) {
                    if(!$kernel->features("cpu_threads", $vps["virt"])) {
                        $editvs["topology_threads"] = 1;
                    }
                    if(empty($editvs["topology_sockets"]) || empty($editvs["topology_cores"]) || empty($editvs["topology_threads"])) {
                        $error[] = $l["inv_topology"];
                        return false;
                    }
                    $vcpus = $editvs["topology_sockets"] * $editvs["topology_cores"] * $editvs["topology_threads"];
                    if($editvs["cores"] != $vcpus) {
                        $error[] = $l["err_topology_calc"];
                        return false;
                    }
                }
            }
            if($kernel->features("numa", $vps["virt"])) {
                $editvs["numa"] = (int) optPOST("numa");
            }
            if(!empty($editvs["vnc"])) {
                $editvs["vncpass"] = optPOST("vncpass");
                if(preg_match("/[^A-Za-z0-9]/is", $editvs["vncpass"])) {
                    $error[] = $l["no_nonalphanumeric"];
                }
            }
            if($disks[0]["size"] * 1024 - $editvs["swap"] < $vps["disks"][0]["size"] * 1024 - $vps["swap"]) {
                $error[] = $l["err_effective_space"];
            }
            if($vps["virt"] == "xen" && !empty($vps["hvm"])) {
                $editvs["pv_on_hvm"] = (int) optREQ("pv_on_hvm") ? 1 : 0;
            }
        } elseif($virt == "lxc" || $virt == "proxl") {
            $editvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
            $editvs["swap"] = (int) POST("swapram", $l["no_swap_ram"]);
            if($virt == "proxl") {
                $editvs["cpu_percent"] = (int) POST("cpu_percent", $l["no_percent_cpu"]);
            }
            if($resources["cpucores"] < $editvs["cores"]) {
                $error[] = $l["err_cores_more"] . $resources["cpucores"];
            }
            if(preg_match("/file/is", $storages[$storage_uuids[$disks[0]["st_uuid"]]]["type"]) && $virt != "proxl") {
                $error[] = $l["lxc_file_support"];
            }
        } elseif($virt == "vzk" || $virt == "vzo") {
            $editvs["io"] = (int) POST("priority", $l["no_io"]);
            $editvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
            $editvs["swap"] = (int) optPOST("swapram");
            $editvs["cpu_percent"] = (int) POST("cpu_percent", $l["no_percent_cpu"]);
            $editvs["vnc"] = (int) (optREQ("vnc") ? 1 : 0);
            if(empty($editvs["cpu"])) {
                $error[] = $l["no_cpu_units"];
            }
            if($virt == "vzk") {
                $editvs["iso"] = optPOST("iso");
                if(pathinfo($editvs["iso"], PATHINFO_EXTENSION) == "iso") {
                    foreach ($isos as $iok => $iov) {
                        if($iov["filename"] == $editvs["iso"]) {
                            $editvs["iso"] = $iok;
                        }
                    }
                }
                if(isset($_REQUEST["boot"])) {
                    $editvs["boot"] = optPOST("boot") == "dca" ? "dca" : "cda";
                    if(empty($vps["osid"]) && (!empty($vps["iso"]) || !empty($vps["sec_iso"]))) {
                        $editvs["boot"] = "dca";
                    }
                }
            } elseif($virt == "vzo") {
                $editvs["tuntap"] = (int) optREQ("tuntap") ? 1 : 0;
                $editvs["ppp"] = (int) optREQ("ppp") ? 1 : 0;
            }
            if(!empty($editvs["vnc"])) {
                $editvs["vncpass"] = optPOST("vncpass");
                if(!empty($editvs["vncpass"])) {
                    if(preg_match("/[^A-Za-z0-9]/is", $editvs["vncpass"])) {
                        $error[] = $l["no_nonalphanumeric"];
                    }
                    if($kernel->features("vncpasslen", $editvs["virt"]) < strlen($editvs["vncpass"])) {
                        $error[] = $l["vncpass_too_long"];
                    }
                }
            }
            if($resources["cpucores"] < $editvs["cores"]) {
                $error[] = $l["err_cores_more"] . $resources["cpucores"];
            }
            if($disks[0]["size"] * 1024 - $editvs["swap"] < $vps["disks"][0]["size"] * 1024 - $vps["swap"]) {
                $error[] = $l["err_effective_space"];
            }
        }
        if($kernel->features("sec_iso_support", $vps["virt"])) {
            if(pathinfo($editvs["iso"], PATHINFO_EXTENSION) == "iso") {
                foreach ($isos as $iok => $iov) {
                    if($iov["filename"] == $editvs["iso"]) {
                        $editvs["iso"] = $iok;
                    }
                }
            }
            if(empty($isos[$editvs["sec_iso"]])) {
                $editvs["sec_iso"] = "";
            }
        }
        $editvs["disable_ebtables"] = (int) optREQ("disable_ebtables") ? 1 : 0;
        if(!empty($iscripts[$editvs["webuzo"]])) {
            if($ostemplates[$vps["osid"]]["distro"] != "webuzo") {
                $error[] = $l["no_webuzo_template"];
            }
        } else {
            $editvs["webuzo"] = 0;
        }
        if(!empty($resources["overcommit"])) {
            $editvs_ram = $editvs["ram"] - $vps["ram"];
        } else {
            $vpsstatus = $cluster->vps_status([$vps["vpsid"] => $vps["serid"]]);
            $vpsstatus = $vpsstatus[$vps["vpsid"]];
            $editvs_ram = empty($vpsstatus) ? $editvs["ram"] : $editvs["ram"] - $vps["ram"];
        }
        if((empty($resources["overcommit"]) ? $resources["ram"] : $resources["overcommit"] - $servers[$vps["serid"]]["alloc_ram"]) < $editvs_ram) {
            $error[] = $l["less_ram"];
        }
        if($kernel->features("disks_support", $vps["virt"])) {
            $old_disks = [];
            foreach ($vps["disks"] as $k => $v) {
                $old_disks[$v["disk_uuid"]] = $v;
            }
            $new_disks = [];
            $editvs["disks"] = $disks;
            $primary_disk_storage = $vps["disks"][0]["st_uuid"];
            foreach ($editvs["disks"] as $k => $v) {
                $this_disk_storage = $storages[$storage_uuids[$v["st_uuid"]]];
                unset($editvs["disks"][$k]["stid"]);
                if($virt == "vzk" && $primary_disk_storage != $v["st_uuid"]) {
                    $error[] = $l["err_vzk_storage"];
                }
                if(!empty($old_disks[$v["disk_uuid"]])) {
                    $editvs["disks"][$k] = $old_disks[$v["disk_uuid"]];
                    if($disks[$k]["size"] < $old_disks[$v["disk_uuid"]]["size"]) {
                        $error[] = $l["err_space"];
                    }
                }
                $editvs["disks"][$k]["size"] = $disks[$k]["size"];
                $editvs["disks"][$k]["num"] = $k;
                if(empty($editvs["disks"][$k]["disk_uuid"])) {
                    $disk_uuid = "d" . generateRandStr(15);
                    $editvs["disks"][$k] = vps_disk_struct();
                    $editvs["disks"][$k]["primary"] = 0;
                    $editvs["disks"][$k]["path"] = vpsdisk_path_build("-" . $disk_uuid, $this_disk_storage, $vps);
                    $editvs["disks"][$k]["type"] = $this_disk_storage["type"];
                    $editvs["disks"][$k]["format"] = $this_disk_storage["format"];
                    $editvs["disks"][$k]["size"] = $disks[$k]["size"];
                    $editvs["disks"][$k]["vpsid"] = $vps["vpsid"];
                    $editvs["disks"][$k]["st_uuid"] = $this_disk_storage["st_uuid"];
                    $editvs["disks"][$k]["disk_uuid"] = $disk_uuid;
                    $editvs["disks"][$k]["num"] = $k;
                    $editvs["disks"][$k]["bus_driver"] = $disks[$k]["bus_driver"];
                    $editvs["disks"][$k]["bus_driver_num"] = (int) $disks[$k]["bus_driver_num"];
                    $disks_to_create[$disk_uuid] = $disk_uuid;
                }
                $new_disks[$editvs["disks"][$k]["disk_uuid"]] = $editvs["disks"][$k];
            }
            if($editvs["virt"] == "xen" && empty($editvs["hvm"]) && 0 < $editvs["swap"]) {
                if(empty($vps["disks"][1])) {
                    $_stid = $storage_uuids[$disks[0]["st_uuid"]];
                    $sdisk_uuid = "d" . generateRandStr(15);
                    $editvs["disks"][1]["primary"] = 0;
                    $editvs["disks"][1]["path"] = vpsdisk_path_build("swap-" . $disk_uuid, $storages[$_stid], $vps);
                    $editvs["disks"][1]["type"] = $storages[$_stid]["type"];
                    $editvs["disks"][1]["format"] = $storages[$_stid]["format"];
                    $editvs["disks"][1]["size"] = $editvs["swap"];
                    $editvs["disks"][1]["size_unit"] = "M";
                    $editvs["disks"][1]["vpsid"] = $editvs["vpsid"];
                    $editvs["disks"][1]["st_uuid"] = $storages[$_stid]["st_uuid"];
                    $editvs["disks"][1]["disk_uuid"] = $sdisk_uuid;
                    $editvs["disks"][1]["num"] = 1;
                    $disks_to_create[$disk_uuid] = $disk_uuid;
                } else {
                    $editvs["disks"][1] = $vps["disks"][1];
                    $editvs["disks"][1]["size"] = $editvs["swap"];
                }
                $new_disks[$editvs["disks"][1]["disk_uuid"]] = $editvs["disks"][1];
            }
            foreach ($old_disks as $k => $v) {
                if(empty($new_disks[$k]) && empty($v["primary"]) && !preg_match("/swap/is", $v["path"])) {
                    $disks_to_delete[$k] = $v;
                }
            }
        }
        if($editvs["virt"] == "xcp" && 1 < count($editvs["disks"])) {
            $error[] = "Multi Disk support is disabled in XenServer for now";
        }
        if($editvs["virt"] == "proxk" && 4 < count($editvs["disks"])) {
            $error[] = "Maximum 4 Disk allowed in ProxMox for now";
        }
        if(!empty($error)) {
            return false;
        }
        $qres = makequery("SELECT * FROM `users`\n\t\t\t\t\t\tWHERE uid = :editvs", [":editvs" => $editvs["uid"]]);
        if(vsql_num_rows($qres) < 1) {
            $error["invalid_uid"] = $l["invalid_uid"];
            return false;
        }
        if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $editvs["hostname"])) {
            $error[] = $l["invalid_hostname"];
            return false;
        }
        $_ips_cnt = optPOST("num_ips");
        if(!empty($_ips_cnt) && empty($_POST["ips"][0])) {
            if($_ips_cnt < count($vps["ips"])) {
                $i = 0;
                $num_ips = [];
                foreach ($vps["ips"] as $k => $v) {
                    $num_ips[$k] = $v;
                    $i++;
                    if($_ips_cnt == $i) {
                        $_POST["ips"] = $num_ips;
                    }
                }
            } elseif(count($vps["ips"]) < $_ips_cnt) {
                $toadd = $_ips_cnt - count($vps["ips"]);
                $_POST["ips"] = array_values($vps["ips"]);
                foreach ($ips as $k => $v) {
                    if(in_array($v["ip"], $vps["ips"])) {
                    } else {
                        $_POST["ips"][] = $v["ip"];
                        if($_ips_cnt == count($_POST["ips"])) {
                        }
                    }
                }
            } else {
                $_POST["ips"] = $vps["ips"];
            }
        }
        $_ips_int_cnt = optPOST("num_ips_int");
        if(!empty($_ips_int_cnt) && empty($_POST["ips_int"][0])) {
            if($_ips_int_cnt < count($vps["ips_int"])) {
                $i = 0;
                $num_ips_int = [];
                foreach ($vps["ips_int"] as $k => $v) {
                    $num_ips_int[$k] = $v;
                    $i++;
                    if($_ips_int_cnt == $i) {
                        $_POST["ips_int"] = $num_ips_int;
                    }
                }
            } elseif(count($vps["ips_int"]) < $_ips_int_cnt) {
                $toadd = $_ips_int_cnt - count($vps["ips_int"]);
                $_POST["ips_int"] = array_values($vps["ips_int"]);
                foreach ($ips_int as $k => $v) {
                    if(in_array($v["ip"], $vps["ips_int"])) {
                    } else {
                        $_POST["ips_int"][] = $v["ip"];
                        if($_ips_int_cnt == count($_POST["ips_int"])) {
                        }
                    }
                }
            } else {
                $_POST["ips_int"] = $vps["ips_int"];
            }
        }
        $_ips6_cnt = optPOST("num_ips6");
        $tmp_sdk_ips6 = $_POST["ips6"];
        if(is_array($tmp_sdk_ips6) && !empty($tmp_sdk_ips6) && empty($_POST["ipv6"][0])) {
            $_POST["ipv6"] = array_values($tmp_sdk_ips6);
        }
        if(!empty($_ips6_cnt) && empty($_POST["ipv6"][0])) {
            if($_ips6_cnt < count($vps["ipv6"])) {
                $i = 0;
                $num_ips6 = [];
                foreach ($vps["ipv6"] as $k => $v) {
                    $num_ips6[$k] = $v;
                    $i++;
                    if($_ips6_cnt == $i) {
                        $_POST["ipv6"] = $num_ips6;
                    }
                }
            } elseif(count($vps["ipv6"]) < $_ips6_cnt) {
                $toadd = $_ips6_cnt - count($vps["ipv6"]);
                $_POST["ipv6"] = array_values($vps["ipv6"]);
                foreach ($ips6 as $k => $v) {
                    if(in_array($v["ip"], $vps["ipv6"])) {
                    } else {
                        $_POST["ipv6"][] = $v["ip"];
                        if($_ips6_cnt == count($_POST["ipv6"])) {
                        }
                    }
                }
            } else {
                $_POST["ipv6"] = $vps["ipv6"];
            }
        }
        $_ips6_subnet_cnt = optPOST("num_ips6_subnet");
        $tmp_sdk_ips6_subnet = $_POST["ips6_subnet"];
        if(is_array($tmp_sdk_ips6_subnet) && !empty($tmp_sdk_ips6_subnet) && empty($_POST["ipv6_subnet"][0])) {
            $tmp_sdk_ips6_subnet = array_values($tmp_sdk_ips6_subnet);
            foreach ($tmp_sdk_ips6_subnet as $k => $v) {
                $_tmp_ips6_subnet = explode("/", $v);
                $tmp_sdk_ips6_subnet[$k] = $_tmp_ips6_subnet[0];
            }
            $_POST["ipv6_subnet"] = $tmp_sdk_ips6_subnet;
        }
        if(!empty($_ips6_subnet_cnt) && empty($_POST["ipv6_subnet"][0])) {
            if($_ips6_subnet_cnt < count($vps["ips6_subnet"])) {
                $i = 0;
                $num_ips6_subnet = [];
                foreach ($vps["ips6_subnet"] as $k => $v) {
                    $tmp = explode("/", $v);
                    $num_ips6_subnet[] = $tmp[0];
                    $i++;
                    if($_ips6_subnet_cnt == $i) {
                        $_POST["ipv6_subnet"] = $num_ips6_subnet;
                    }
                }
            } elseif(count($vps["ips6_subnet"]) < $_ips6_subnet_cnt) {
                $toadd = $_ips6_subnet_cnt - count($vps["ips6_subnet"]);
                $_POST["ipv6_subnet"] = array_values($vps["ipv6_subnet"]);
                foreach ($ips6_subnet as $k => $v) {
                    if(in_array($v["ip"], $vps["ips6_subnet"])) {
                    } else {
                        $_POST["ipv6_subnet"][] = $v["ip"];
                        if($_ips6_subnet_cnt == count($_POST["ipv6_subnet"])) {
                        }
                    }
                }
            } else {
                $tmp_ips6_subnet = [];
                foreach ($vps["ips6_subnet"] as $k => $v) {
                    $tmp = explode("/", $v);
                    $tmp_ips6_subnet[$k] = $tmp[0];
                }
                $_POST["ipv6_subnet"] = $tmp_ips6_subnet;
            }
        }
        $locked = [];
        $posted_ips = [];
        $tmp_posted_ips = ["ips", "ipv6", "ips_int", "ipv6_subnet"];
        foreach ($tmp_posted_ips as $pk => $pv) {
            if(is_array($_POST[$pv]) && !empty($_POST[$pv])) {
                foreach ($_POST[$pv] as $pvv) {
                    $posted_ips[] = $pvv;
                }
            }
        }
        $posted_ips_tokens = vsql_in_tokens(array_values($posted_ips));
        $res = makequery("SELECT * FROM ips WHERE ip IN (" . $posted_ips_tokens["query"] . ") AND locked=1", $posted_ips_tokens["tokens"]);
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $locked[] = $row["ip"];
        }
        if(!empty($locked)) {
            $vps_all_ips = [];
            foreach (["ips", "ips_int", "ips6", "ips6_subnet"] as $k => $v) {
                if(!empty($vps[$v]) && is_array($vps[$v])) {
                    $vps_temp = $vps[$v];
                    if($v == "ips6_subnet") {
                        foreach ($vps_temp as $kk => $vv) {
                            $tmp_ip = explode("/", $vv);
                            $vps_temp[$kk] = $tmp_ip[0];
                        }
                    }
                    $vps_all_ips = array_merge($vps_all_ips, $vps_temp);
                }
            }
            if(!empty($vps_all_ips)) {
                foreach ($locked as $k => $v) {
                    if(in_array($v, $vps_all_ips)) {
                        unset($locked[$k]);
                    }
                }
            }
            if(!empty($locked)) {
                $error["locked_ips"] = $l["lockedips"] . ":<br />" . implode(", ", $locked);
                return false;
            }
        }
        $pips = [];
        $_POST["ips"] = !is_array($_POST["ips"]) ? [] : $_POST["ips"];
        $invalid = [];
        foreach ($_POST["ips"] as $value) {
            if(empty($value)) {
            } else {
                if(!valid_ip($value)) {
                    $invalid[] = $value;
                }
                $pips[] = $value;
            }
        }
        if(!empty($globals["max_ipv4s"]) && $globals["max_ipv4s"] < count($pips)) {
            $error["max_ipv4s"] = $l["err_max_ipv4s"] . $globals["max_ipv4s"];
            return false;
        }
        $pips6 = [];
        if(0 < @count($_POST["ipv6"])) {
            $pips6 = $_POST["ipv6"];
            foreach ($pips6 as $value) {
                if(!valid_ipv6($value)) {
                    $invalid[] = $value;
                }
            }
        }
        if(!empty($globals["max_ipv6s"]) && $globals["max_ipv6s"] < count($pips6)) {
            $error["max_ipv6s"] = $l["err_max_ipv6s"] . $globals["max_ipv6s"];
            return false;
        }
        $pips_int = [];
        if(!empty($ips_int)) {
            foreach ($ips_int as $kk => $vv) {
                $_ips_int[$kk] = $vv["ip"];
            }
            foreach ($vps["ips_int"] as $kk => $vv) {
                $_ips_int[$kk] = $vv;
            }
            $_POST["ips_int"] = !is_array($_POST["ips_int"]) ? [] : $_POST["ips_int"];
            foreach ($_POST["ips_int"] as $value) {
                if(empty($value)) {
                } else {
                    if(!valid_ip($value) || !in_array($value, $_ips_int)) {
                        $invalid[] = $value;
                    }
                    $pips_int[] = $value;
                }
            }
        }
        if(!empty($globals["max_internal_ips"]) && $globals["max_internal_ips"] < count($pips_int)) {
            $error["max_internal_ips"] = $l["err_max_internal_ips"] . $globals["max_internal_ips"];
            return false;
        }
        if(!empty($invalid)) {
            $error[] = $l["invalid_ip"] . "<br />" . implode(", ", $invalid);
            return false;
        }
        $pips6_subnet = [];
        if(isset($_POST["ipv6_subnet"]) && 0 < @count($_POST["ipv6_subnet"])) {
            $pips6_subnet = $_POST["ipv6_subnet"];
            foreach ($pips6_subnet as $value) {
                if(!valid_ipv6($value)) {
                    $invalid[] = $value;
                }
            }
        }
        if(!empty($globals["max_ipv6_subnets"]) && $globals["max_ipv6_subnets"] < count($pips6_subnet)) {
            $error["max_ipv6_subnets"] = $l["err_max_ipv6_subnets"] . $globals["max_ipv6_subnets"];
            return false;
        }
        if(!empty($invalid)) {
            $error["invalid_ip_subnet"] = $l["invalid_ip_subnet"] . "<br />" . implode(", ", $invalid);
            return false;
        }
        if(empty($pips[0]) && empty($pips6) && empty($pips6_subnet) && empty($pips_int)) {
            $error["no_ip"] = $l["no_ip"];
            return false;
        }
        $qres = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.ip IN('" . implode("','", array_merge($pips, $pips6, $pips6_subnet, $pips_int)) . "')\n\t\t\t\t\tORDER BY `primary` DESC");
        $usedips = [];
        $unusedip = [];
        $dnsip = [];
        for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
            $dnsip[$i] = $row = vsql_fetch_assoc($qres);
            if(empty($row["vpsid"]) || $row["vpsid"] == $vpsid) {
                $unusedip[] = $row["ip"];
            } elseif(!empty($row["ipr_netmask"])) {
                $used_subnets[] = $row["ip"];
            } else {
                $usedips[] = $row["ip"];
            }
        }
        if(!empty($usedips)) {
            $error[] = $l["used_ip"] . "<br />" . implode(", ", $usedips);
            return false;
        }
        if(!empty($used_subnets)) {
            $error["used_ip_subnet"] = $l["used_ip_subnet"] . "<br />" . implode(", ", $used_subnets);
            return false;
        }
        $dns = $_POST["dns"];
        $_dns = [];
        if(!empty($dns[0])) {
            foreach ($dns as $key => $value) {
                if(!empty($value) && (valid_ip($value) || valid_ipv6($value))) {
                    $_dns[] = $value;
                }
            }
        }
        $cluster->check_vps_data($vps["serid"], $editvs, 1);
        $fields = ["ram" => "gram", "space" => "hdd", "burst" => "bram", "swap" => "swap", "cores" => "cores", "cpu" => "cpunit", "cpu_percent" => "percent", "network_speed" => "network_speed", "upload_speed" => "upload_speed"];
        foreach ($fields as $field_k => $field_v) {
            if($editvs[$field_k] == -1 && in_array($field_k, ["upload_speed"])) {
            } elseif(!empty($editvs[$field_k]) && $editvs[$field_k] < 0) {
                $error[] = $l["err_negative_val"] . " : " . $l[$field_v] . " (" . $editvs[$field_k] . ")";
            }
        }
        if(!empty($error)) {
            return false;
        }
        $data_set["rtc"] = $editvs["rtc"];
        $data_set["os_type"] = $editvs["os_type"];
        $data_set["unprivileged"] = $editvs["unprivileged"];
        $data_encode = json_encode($data_set);
        $token_vals = [":edittime" => time(), ":uid" => $editvs["uid"], ":plid" => $editvs["plid"], ":hostname" => $editvs["hostname"], ":iso" => $editvs["iso"], ":sec_iso" => $editvs["sec_iso"], ":boot" => $editvs["boot"], ":space" => $editvs["space"], ":ram" => $editvs["ram"], ":burst" => $editvs["burst"], ":swap" => $editvs["swap"], ":cpu" => $editvs["cpu"], ":cores" => $editvs["cores"], ":cpupin" => $editvs["cpupin"], ":cpu_percent" => $editvs["cpu_percent"], ":bandwidth" => $editvs["bandwidth"], ":network_speed" => $editvs["network_speed"], ":upload_speed" => $editvs["upload_speed"], ":io" => $editvs["io"], ":acpi" => $editvs["acpi"], ":apic" => $editvs["apic"], ":pae" => $editvs["pae"], ":shadow" => $editvs["shadow"], ":vnc" => $editvs["vnc"], ":band_suspend" => $editvs["band_suspend"], ":tuntap" => $editvs["tuntap"], ":ppp" => $editvs["ppp"], ":ploop" => $editvs["ploop"], ":dns_nameserver" => serialize($_dns), ":osreinstall_limit" => $editvs["osreinstall_limit"], ":nic_type" => $editvs["nic_type"], ":vif_type" => $editvs["vif_type"], ":virtio" => $editvs["virtio"], ":pv_on_hvm" => $editvs["pv_on_hvm"], ":mg" => implode(",", $editvs["mg"]), ":webuzo" => $editvs["webuzo"], ":kvm_cache" => $editvs["kvm_cache"], ":io_mode" => $editvs["io_mode"], ":total_iops_sec" => $editvs["total_iops_sec"], ":read_bytes_sec" => $editvs["read_bytes_sec"], ":write_bytes_sec" => $editvs["write_bytes_sec"], ":vnc_keymap" => $editvs["vnc_keymap"], ":kvm_vga" => $editvs["kvm_vga"], ":acceleration" => $editvs["acceleration"], ":vpsid" => $vpsid, ":disable_ebtables" => $editvs["disable_ebtables"], ":numa" => $editvs["numa"], ":cpu_mode" => $editvs["cpu_mode"], ":admin_managed" => $editvs["admin_managed"], ":rdp" => $editvs["rdp"], ":disable_nw_config" => $editvs["disable_nw_config"], ":topology_sockets" => $editvs["topology_sockets"], ":topology_cores" => $editvs["topology_cores"], ":topology_threads" => $editvs["topology_threads"], ":openvz_features" => $editvs["openvz_features"], ":speed_cap" => !empty($editvs["speed_cap"]) && is_array($editvs["speed_cap"]) ? serialize($editvs["speed_cap"]) : "", ":bpid" => $editvs["bpid"], ":ha" => $editvs["ha"], ":data" => $data_encode];
        $res = update_query("UPDATE vps SET \t\n\t\t\t\t\tedittime = :edittime,\n\t\t\t\t\tuid = :uid,\n\t\t\t\t\tplid = :plid,\n\t\t\t\t\thostname = :hostname,\n\t\t\t\t\tiso = :iso,\n\t\t\t\t\tsec_iso = :sec_iso,\n\t\t\t\t\tboot = :boot,\n\t\t\t\t\tspace = :space,\n\t\t\t\t\tram = :ram,\n\t\t\t\t\tburst = :burst,\n\t\t\t\t\tswap = :swap,\n\t\t\t\t\tcpu = :cpu,\n\t\t\t\t\tcores = :cores,\n\t\t\t\t\tcpupin = :cpupin,\n\t\t\t\t\tcpu_percent = :cpu_percent,\n\t\t\t\t\tbandwidth = :bandwidth,\n\t\t\t\t\tnetwork_speed = :network_speed,\n\t\t\t\t\tupload_speed = :upload_speed,\n\t\t\t\t\tio = :io,\n\t\t\t\t\tacpi = :acpi,\n\t\t\t\t\tapic = :apic,\n\t\t\t\t\tpae = :pae,\n\t\t\t\t\tshadow = :shadow,\n\t\t\t\t\tvnc = :vnc,\n\t\t\t\t\tband_suspend = :band_suspend,\n\t\t\t\t\ttuntap = :tuntap,\n\t\t\t\t\tppp = :ppp,\n\t\t\t\t\tploop = :ploop,\n\t\t\t\t\tdns_nameserver = :dns_nameserver,\n\t\t\t\t\tosreinstall_limit = :osreinstall_limit,\n\t\t\t\t\tnic_type = :nic_type,\n\t\t\t\t\tvif_type = :vif_type,\n\t\t\t\t\tvirtio = :virtio,\n\t\t\t\t\tpv_on_hvm = :pv_on_hvm,\n\t\t\t\t\tmg = :mg,\n\t\t\t\t\twebuzo = :webuzo,\n\t\t\t\t\tkvm_cache = :kvm_cache,\n\t\t\t\t\tio_mode = :io_mode,\n\t\t\t\t\ttotal_iops_sec = :total_iops_sec,\n\t\t\t\t\tread_bytes_sec = :read_bytes_sec,\n\t\t\t\t\twrite_bytes_sec = :write_bytes_sec,\n\t\t\t\t\tvnc_keymap = :vnc_keymap,\n\t\t\t\t\tkvm_vga = :kvm_vga,\n\t\t\t\t\tacceleration = :acceleration,\n\t\t\t\t\tdisable_ebtables = :disable_ebtables,\n\t\t\t\t\tcpu_mode = :cpu_mode,\n\t\t\t\t\tadmin_managed = :admin_managed,\n\t\t\t\t\trdp = :rdp,\n\t\t\t\t\tdisable_nw_config = :disable_nw_config,\n\t\t\t\t\tnuma = :numa,\n\t\t\t\t\ttopology_sockets = :topology_sockets,\n\t\t\t\t\ttopology_cores = :topology_cores,\n\t\t\t\t\ttopology_threads = :topology_threads,\n\t\t\t\t\topenvz_features = :openvz_features,\n\t\t\t\t\tspeed_cap = :speed_cap,\n\t\t\t\t\tbpid = :bpid,\n\t\t\t\t\tha = :ha,\n\t\t\t\t\tdata = :data\n\t\t\t\t\tWHERE vpsid = :vpsid", $token_vals);
        if(!empty($editvs["disks"])) {
            if(!empty($disks_to_create)) {
                foreach ($disks_to_create as $k => $v) {
                    vpsdisk_add($vps["uuid"], $new_disks[$k]);
                }
            }
            foreach ($editvs["disks"] as $k => $v) {
                vpsdisk_update($vps["uuid"], $v);
            }
        }
        foreach ($editvs["disks"] as $k => $v) {
            if($editvs["virt"] == "xen" && empty($editvs["hvm"]) && 0 < $editvs["swap"] && $k == 1) {
            } else {
                $disks[$k]["disk_uuid"] = $editvs["disks"][$k]["disk_uuid"];
            }
        }
        if($kernel->features("vnc_store_pass", $vps["virt"]) && !empty($editvs["vncpass"])) {
            $res = makequery("UPDATE vps\n\t\t\t\t\tSET vnc_passwd = :vnc_passwd\n\t\t\t\t\tWHERE vpsid = :vpsid", [":vnc_passwd" => $editvs["vncpass"], ":vpsid" => $vpsid]);
        }
        $allips = array_merge($pips, $pips6, $pips6_subnet, $pips_int);
        $p_counter = 1;
        $ippid_chk = vsql_in_tokens($ippid);
        foreach ($allips as $k => $v) {
            $up_tokens = [":vpsid" => $vpsid, ":primary" => -1 * $p_counter, ":ip" => $v];
            $up_query = "";
            if(!empty($pips_int)) {
                $up_query = " AND ippid IN (" . $ippid_chk["query"] . ")";
                $up_tokens = array_merge($ippid_chk["tokens"], $up_tokens);
            }
            if(in_array($v, $unusedip)) {
                $res = update_query("UPDATE ips\n\t\t\t\t\t\t\t\t\tSET vpsid = :vpsid,\n\t\t\t\t\t\t\t\t\t`primary` = :primary\n\t\t\t\t\t\t\t\t\tWHERE ip = :ip" . $up_query, $up_tokens);
            } else {
                $res = insert_and_id("INSERT INTO ips SET\n\t\t\t\t\t\t\t\t\t ip = '" . $v . "',\n\t\t\t\t\t\t\t\t\t vpsid = '" . $vpsid . "',\n\t\t\t\t\t\t\t\t\t `primary` = '" . -1 * $p_counter . "',\n\t\t\t\t\t\t\t\t\t ip_serid = '" . $vps["serid"] . "',\n\t\t\t\t\t\t\t\t\t ipv6 = '" . (valid_ip($v) ? 0 : 1) . "'");
            }
            $p_counter++;
        }
        $up_pri_tokens = [":primary" => 1, ":ip" => !empty($pips[0]) ? $pips[0] : $allips[0]];
        $up_pri_query = "";
        if(!empty($pips_int)) {
            $up_pri_query = " AND ippid IN (" . $ippid_chk["query"] . ")";
            $up_pri_tokens = array_merge($ippid_chk["tokens"], $up_pri_tokens);
        }
        $res = update_query("UPDATE ips\n\t\t\t\t\t\t\tSET `primary`  = :primary\n\t\t\t\t\t\t\tWHERE ip = :ip" . $up_pri_query, $up_pri_tokens);
        foreach ($vps["ips"] as $k => $v) {
            if(!in_array($v, $allips)) {
                $res = update_query("UPDATE ips\n\t\t\t\t\t\t\tSET `primary` = :primary,\n\t\t\t\t\t\t\tvpsid = :vpsid\n\t\t\t\t\t\t\tWHERE ip = :ip", [":primary" => 0, ":vpsid" => 0, ":ip" => $v]);
            }
        }
        if(!empty($vps["ips6"])) {
            foreach ($vps["ips6"] as $k => $v) {
                if(!in_array($v, $allips)) {
                    $res = update_query("UPDATE ips\n\t\t\t\t\t\t\tSET `primary` = :primary,\n\t\t\t\t\t\t\tvpsid = :vpsid\n\t\t\t\t\t\t\tWHERE ip = :ip", [":primary" => 0, ":vpsid" => 0, ":ip" => $v]);
                }
            }
        }
        if(!empty($vps["ips6_subnet"])) {
            foreach ($vps["ips6_subnet"] as $k => $v) {
                $tmp = explode("/", $v);
                if(!in_array($tmp[0], $allips)) {
                    $res = update_query("UPDATE ips\n\t\t\t\t\t\t\t\tSET `primary` = :primary,\n\t\t\t\t\t\t\t\tvpsid = :vpsid,\n\t\t\t\t\t\t\t\tipr_ips = :ipr_ips\n\t\t\t\t\t\t\t\tWHERE ip = :ip", [":primary" => 0, ":vpsid" => 0, ":ipr_ips" => "", ":ip" => $tmp[0]]);
                }
            }
        }
        if(!empty($vps["ips_int"])) {
            foreach ($vps["ips_int"] as $k => $v) {
                if(!in_array($v, $allips)) {
                    $res = update_query("UPDATE ips\n\t\t\t\t\t\t\t\tSET `primary` = :primary,\n\t\t\t\t\t\t\t\tvpsid = :vpsid\n\t\t\t\t\t\t\t\tWHERE ip = :ip  AND ippid IN (" . $ippid_chk["query"] . ")", array_merge($ippid_chk["tokens"], [":primary" => 0, ":vpsid" => 0, ":ip" => $v]));
                }
            }
        }
        $callback = [];
        if((!empty($pips[0]) || !empty($pips_int[0]) || !empty($pips6[0]) || !empty($pips6_subnet[0])) && !empty($globals["enable_cb"]) && !empty($globals["cb_changeips"])) {
            $callback["act"][] = "changeip";
            $ipv4ips = array_merge($pips, $pips_int);
            $ipv6ips = array_merge($pips6, $pips6_subnet);
            if(!empty($ipv4ips)) {
                $callback["data"]["ipv4"] = implode(",", $ipv4ips);
            }
            if(!empty($ipv6ips)) {
                $callback["data"]["ipv6"] = implode(",", $ipv6ips);
            }
        }
        if(is_array($disks_to_delete) && !empty($disks_to_delete) && !$cluster->delete_vpsdisks($vpsid, $disks_to_delete)) {
            $error[] = $l["err_del_disks"];
            return false;
        }
        $bw = _unserialize($vps["nw_suspended"]);
        if($vps["bandwidth"] < $editvs["bandwidth"] && $bw["reason"] == "bw") {
            $res = makequery("UPDATE vps\n\t\t\t\t\t\t\t\tSET `nw_suspended` = NULL\n\t\t\t\t\t\t\t\tWHERE vpsid = :vpsid", [":vpsid" => $vps["vpsid"]]);
            $cluster->unsuspend_vps_net($vps["vpsid"]);
            logs_admin("nw_unsuspended", $vps["vps_name"], 1, $vpsid, $user["uid"]);
        }
        $sres = $cluster->sync($vps["serid"]);
        if(empty($sres)) {
            $error[] = $l["err_save_slave"];
            return false;
        }
        getvps($vpsid, 0);
        if(!$cluster->editvps($vpsid)) {
            $error[] = $l["err_edit"];
            return false;
        }
        if($kernel->features("change_dns", $vps["virt"])) {
            $changes = array_merge(array_diff($vps["dns"], $_dns), array_diff($_dns, $vps["dns"]));
            if(!empty($changes)) {
                $done["dns"] = true;
            }
        }
        if(!empty($editvs["mac_status"]) && $kernel->features("mac_support", $vps["_virt"]) && $vps["mac"] != $editvs["mac"]) {
            $ip_res = makequery("SELECT i.mac_addr FROM `ips` i\n\t\t\t\t\t\t\t\tWHERE i.vpsid = :vpsid\n\t\t\t\t\t\t\t\tORDER BY `primary` DESC LIMIT 1", [":vpsid" => $vpsid]);
            $_ips = vsql_fetch_assoc($ip_res);
            if(empty($_ips["mac_addr"])) {
                $cluster->changemac_address($editvs["mac"], $vpsid);
                $done["mac"] = true;
            }
        }
        if($kernel->features("win_support", $vps["_virt"]) && $editvs["rdp"] != $vps["rdp"]) {
            $cluster->remote_desktop($vpsid, $editvs["rdp"]);
        }
        $res = makequery("SELECT * FROM haproxy \n\t\t\t\t\t\tWHERE vpsuuid = :vpsuuid \n\t\t\t\t\t\tAND serid = :serid", [":vpsuuid" => $vps["uuid"], ":serid" => $vps["serid"]]);
        if(0 < vsql_num_rows($res)) {
            $old_vdf_destips = [];
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $old_vdf_destips[$row["dest_ip"]] = $row["dest_ip"];
            }
            $tmp_ips = [];
            foreach ($old_vdf_destips as $k => $v) {
                if(!in_array($v, $pips)) {
                    $tmp_ips[$k] = $pips[0];
                }
            }
            if(!empty($tmp_ips)) {
                foreach ($tmp_ips as $k => $v) {
                    $res = makequery("UPDATE haproxy SET \n\t\t\t\t\t\t\t\t\tdest_ip = :dest_ip_new\n\t\t\t\t\t\t\t\t\tWHERE dest_ip = :dest_ip_old\n\t\t\t\t\t\t\t\t\tAND vpsuuid = :vpsuuid\n\t\t\t\t\t\t\t\t\tAND serid = :serid", [":dest_ip_new" => $v, ":dest_ip_old" => $k, ":vpsuuid" => $vps["uuid"], ":serid" => $vps["serid"]]);
                }
                if(!empty($res)) {
                    $cluster->save_haproxy($vps["serid"]);
                }
            }
        }
        if(!empty($editvs["pass"])) {
            $editvs["pass"] = rawGPC($_POST["rootpass"]);
            if(stripos($ostemplates[$vps["osid"]]["name"], "windows") !== false) {
                $allowed_chars = "!@#\$%^&*_-+=?";
                if(preg_match("/[^a-zA-Z0-9" . preg_quote($allowed_chars) . "]/is", $editvs["pass"])) {
                    $error["inv_winpass_chars"] = $l["inv_winpass_chars"] . " ! @ # \$ % ^ & * _ - + = ?";
                }
                $pass_score = win_pass_score($editvs["pass"]);
                if($pass_score < 3) {
                    $error["weak_pass"] = $l["weak_pass"];
                }
            }
            if(!empty($globals["pass_strength"]) && !empty($editvs["pass"])) {
                $pass_strength = pass_strength($editvs["pass"]);
                if($pass_strength < $globals["pass_strength"]) {
                    $error[] = $l["pass_strength_error"] . $globals["pass_strength"];
                }
            }
            if(!empty($error)) {
                return false;
            }
            if(!$cluster->change_vps_pass($vpsid, $editvs["pass"])) {
                $error[] = $l["err_rootpass"];
                return false;
            }
        }
        if($editvs["hostname"] != $vps["hostname"]) {
            $ret = $cluster->change_vps_hostname($vpsid, $editvs["hostname"]);
            if(!empty($ret) && !empty($globals["enable_cb"]) && !empty($globals["cb_hostname"])) {
                $callback["act"][] = "changehostname";
                $callback["data"]["newhostname"] = $editvs["hostname"];
            }
        }
        if($kernel->features("xenserver_tools", $vps["_virt"]) && empty($vps["install_xentools"]) && !empty($editvs["install_xentools"])) {
            $ret = $cluster->install_xentools($vpsid);
        }
        $skip_callback = optREQ("skip_callback");
        if(!empty($callback) && empty($skip_callback)) {
            $actid = vps_task("editvps_callback", serialize($callback), 0, $vpsid, $user["uid"], 0, $l["task_pending"]);
        }
        if($kernel->features("vnc_support", $vps["virt"]) && !empty($editvs["vncpass"]) && !$cluster->change_vnc_pass($vpsid, $editvs["vncpass"])) {
            $error["err_vncpass"] = $l["err_vncpass"];
            return false;
        }
        if($kernel->features("build_dhcp", $vps["_virt"]) && (isset($_POST["ips"]) || isset($_POST["ipv6"]) || isset($_POST["ips_int"]) || isset($_POST["ipv6_subnet"]) || isset($_POST["mac"]))) {
            $cluster->build_dhcp($vps["serid"]);
        }
        logs_admin("editvs", $vps["vps_name"], 1, $vpsid, $user["uid"]);
        $done["done"] = true;
        $owner = !empty($users[$editvs["uid"]]["pid"]) ? $users[$editvs["uid"]]["pid"] : $editvs["uid"];
        if(!empty($globals["inhouse_billing"]) && !empty($users[$owner]["inhouse_billing"])) {
            if($vps["plid"] != $editvs["plid"]) {
                makequery("UPDATE `usage`\n\t\t\t\t\t\t\tSET endtime = " . time() . ",\n\t\t\t\t\t\t\tupdatetime = " . time() . "WHERE vps_uuid = :vps_uuidAND endtime = 0AND (`resource` IS NOT NULL OR `resource` = '')", [":vps_uuid" => $vps["uuid"]]);
                $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\tSET vps_uuid = :vps_uuid,\n\t\t\t\t\t\t\t\t\tuid  = :owner,\n\t\t\t\t\t\t\t\t\tplid  = :plid,\n\t\t\t\t\t\t\t\t\tstarttime = " . time(), [":vps_uuid" => $vps["uuid"], ":owner" => $owner, ":plid" => $editvs["plid"]]);
            }
            $plan = $plans[$editvs["plid"]];
            foreach ($globals["resource_types"] as $resource) {
                $numval = $resource == "ips" ? count($pips) : $editvs[$resource];
                if($plan[$resource] < $numval) {
                    $new_resource[$resource] = $numval - $plan[$resource];
                }
            }
            $resource_types_tokens = vsql_in_tokens($globals["resource_types"]);
            $res = makequery("SELECT * FROM `usage`\n\t\t\t\t\t\t\tWHERE vps_uuid = :vps_uuid\n\t\t\t\t\t\t\tAND endtime = 0\n\t\t\t\t\t\t\tAND `resource` IN (" . $resource_types_tokens["query"] . ")", array_merge($resource_types_tokens["tokens"], [":vps_uuid" => $vps["uuid"]]));
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $resource = $row["resource"];
                if(empty($new_resource[$resource]) || $new_resource[$resource] != $row["resource_val"]) {
                    makequery("UPDATE `usage`\n\t\t\t\t\t\t\tSET endtime = " . time() . ",\n\t\t\t\t\t\t\tupdatetime = " . time() . "\n\t\t\t\t\t\t\tWHERE vps_uuid = :vps_uuid\n\t\t\t\t\t\t\tAND endtime = 0\n\t\t\t\t\t\t\tAND `resource` = :resource", [":vps_uuid" => $vps["uuid"], ":resource" => $resource]);
                } elseif($new_resource[$resource] == $row["resource_val"]) {
                    unset($new_resource[$resource]);
                }
            }
            foreach ($new_resource as $resource => $resval) {
                $vals = [];
                $vals["vps_uuid"] = $vps["uuid"];
                $vals["uid"] = $owner;
                $vals["starttime"] = time();
                $vals["resource"] = $resource;
                $vals["resource_val"] = $resource == "ram" ? $resval / 1024 : $resval;
                foreach ($vals as $k => $v) {
                    $set[$k] = "`" . $k . "` = :" . $k;
                }
                $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
            }
            if($editvs["hostname"] != $vps["hostname"]) {
                $tmp_usage_data = serialize(["hostname" => $editvs["hostname"]]);
                makequery("UPDATE `usage`\n\t\t\t\t\t\t\tSET data = :tmp_data_usage\n\t\t\t\t\t\t\tWHERE vps_uuid = :vps_uuid", [":tmp_data_usage" => $tmp_usage_data, ":vps_uuid" => $vps["uuid"]]);
            }
        }
        ip_logs($vpsid);
        $ubcset_tmp = (int) optREQ("ubcsettings");
        if(!empty($ubcset_tmp)) {
            redirect("act=ubc&vpsid=" . $vpsid);
        }
        $editedvs = getvps($vps["vpsid"], 0);
        $editedvs["ips"] = $pips;
        $editedvs["ips6"] = $pips6;
        $editedvs["ips6_subnet"] = $pips6_subnet;
        $editedvs["ips_int"] = $pips_int;
        if($vps["serid"] != 0 && is_master()) {
            $ret = $cluster->reverse_sync($vps["serid"]);
        }
        apply_filters("editvs", $vps, $editvs);
    }
}
function API_editvs()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $servers;
    global $oslist;
    global $done;
    global $plans;
    global $ips;
    global $ips6;
    global $ips6_subnet;
    global $ips_int;
    global $ipools;
    global $vps;
    global $ostemplates;
    global $users;
    global $isos;
    global $mgs;
    global $servergroups;
    global $scripts;
    global $iscripts;
    global $editedvs;
    global $backup_plans;
    global $ajax_user;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = 1;
    }
    $GLOBALS["_api"]["plans"] = $plans;
    $GLOBALS["_api"]["ips"] = $ips;
    $GLOBALS["_api"]["ips6"] = $ips6;
    $GLOBALS["_api"]["ips6_subnet"] = $ips6_subnet;
    $GLOBALS["_api"]["ips_int"] = $ips_int;
    $GLOBALS["_api"]["servers"] = $servers;
    $GLOBALS["_api"]["users"] = $users;
    $GLOBALS["_api"]["vps"] = empty($editedvs) ? $vps : $editedvs;
    $GLOBALS["_api"]["ostemplates"] = $ostemplates;
    $GLOBALS["_api"]["isos"] = $isos;
    $GLOBALS["_api"]["mgs"] = $mgs;
    $GLOBALS["_api"]["servergroups"] = $servergroups;
    $GLOBALS["_api"]["backup_plans"] = $backup_plans;
    $GLOBALS["_api"]["ajax_user"] = $ajax_user;
}

?>