<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function addvs()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $servers;
    global $oslist;
    global $node_selected;
    global $ns_server_filtered;
    global $done;
    global $loop_device;
    global $pcis;
    global $usbs;
    global $plans;
    global $ips;
    global $ips6;
    global $ips6_subnet;
    global $ips_int;
    global $ipools;
    global $ostemplates;
    global $users;
    global $isos;
    global $_virt;
    global $virt;
    global $hvm;
    global $newvs;
    global $resources;
    global $cpu_info;
    global $actid;
    global $flag_createvps;
    global $flag_ubcsettings;
    global $done_data;
    global $mgs;
    global $servergroups;
    global $scripts;
    global $iscripts;
    global $storages;
    global $stid;
    global $disk_space;
    global $os_check;
    global $disks;
    global $dnsplans;
    global $recipes;
    global $supported_nics;
    global $cpu_modes;
    global $backup_plans;
    global $bus_driver;
    global $firewall_plans;
    global $firewall_users;
    global $iscripts_allowed;
    global $webuzo_apps;
    global $isfree;
    global $webuzo_templates;
    global $allowed_scripts;
    global $webuzo_done;
    global $ha_enabled;
    global $ajax_user;
    global $machine_type;
    global $new_keys;
    global $load_balancer;
    global $gpu_roms;
    global $pro_lic;
    set_time_limit(500);
    if(!load_lang("admin/addvs")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/addvs";
    $theme["init_theme_name"] = "Add Virtual Server";
    $theme["init_theme_func"] = ["addvs_theme"];
    $theme["call_theme_func"] = "addvs_theme";
    if(!is_allowed("addvs")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $plans = [[]];
    $res = makequery("SELECT * FROM plans ORDER BY plan_name ASC");
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $plans[$row["plid"]] = $row;
        if(!empty($row["openvz_features"])) {
            $plans[$row["plid"]] += _unserialize($row["openvz_features"]);
        }
        if(!empty($row["speed_cap"])) {
            $tmp_plan = _unserialize($row["speed_cap"]);
            $plans[$row["plid"]]["speed_cap_down"] = $tmp_plan["down"];
            $plans[$row["plid"]]["speed_cap_up"] = $tmp_plan["up"];
        }
    }
    $cpu_info = prox_cpu_flags();
    $plans[0] = end($plans);
    foreach ($plans[0] as $k => $v) {
        $plans[0][$k] = NULL;
    }
    $plans[0]["plid"] = 0;
    $plans[0]["plan_name"] = $l["none_plan"];
    $req_virt = optREQ("req_virt");
    if(empty($req_virt) && optREQ("virt")) {
        $req_virt = optREQ("virt") . (optREQ("hvm") ? "hvm" : "");
    }
    $plid = optREQ("plid");
    if(!empty($globals["is_master_only"]) && empty($globals["server"])) {
        foreach ($servers as $sk => $sv) {
            if(!empty($sk) && !empty($sv["status"])) {
                $globals["server"] = $sk;
                set_active_server($globals["server"]);
            }
        }
    }
    $checkbox_plans = ["hvm", "ploop", "ubcsettings", "band_suspend", "tuntap", "ppp", "admin_managed", "virtio", "vnc", "kvm_vga", "acceleration", "pv_on_hvm", "disable_nw_config", "install_xentools", "nested_virt", "ssd_emulation"];
    $is_plan_pool = 0;
    if(!empty($plid)) {
        if(!empty($plans[$plid]["data"])) {
            $data_decode = json_decode($plans[$plid]["data"], 1);
        }
        foreach ($plans[$plid] as $k => $v) {
            if($k == "virt") {
            } elseif(in_array($k, $checkbox_plans) && empty($v)) {
            } elseif(in_array("num_" . $k, ["num_ips", "num_ips_int", "num_ips6", "num_ips6_subnet"])) {
                if(!isset($_POST["num_" . $k])) {
                    $_POST["num_" . $k] = $v;
                    $_REQUEST["num_" . $k] = $_POST["num_" . $k];
                }
            } else {
                if($k == "mgs" && !isset($_POST["mgs"])) {
                    $_POST["mgs"] = cexplode(",", $v, 1);
                    $_REQUEST["mgs"] = $_POST["mgs"];
                }
                if($k == "ippoolid" && !isset($_POST["ippoolid"]) && !empty($v)) {
                    $is_plan_pool = 1;
                    $tmp_ippoolid = _unserialize($v);
                    $_POST["ippoolid"] = implode(",", $tmp_ippoolid);
                    $_REQUEST["ippoolid"] = $_POST["ippoolid"];
                }
                if($k == "load_balancer" && !isset($_POST["load_balancer"]) && $v == 1) {
                    $_POST["load_balancer"] = -1;
                    $_REQUEST["load_balancer"] = $_POST["load_balancer"];
                }
                if($k == "data" && !empty($v)) {
                    if(empty($data_decode)) {
                    } else {
                        if(!empty($data_decode["custom_cpu_model"])) {
                            $_POST["cpu_mode"] = $data_decode["custom_cpu_model"];
                            $_REQUEST["cpu_mode"] = $_POST["cpu_mode"];
                        }
                        foreach ($data_decode as $key => $val) {
                            if($key == "demo") {
                                if(isset($_POST["demo"])) {
                                } elseif(!empty($val)) {
                                    $_POST["demo"] = 1;
                                    $tmp_expiry_demo = strtotime("+" . $val["duration_days"] . " days");
                                    $_POST["demo_time"] = datify($tmp_expiry_demo, 1, 1, "H:i:s");
                                    $_POST["demo_date"] = datify($tmp_expiry_demo, 1, 1, "d/m/Y");
                                    $_POST["demo_action"] = $val["action"];
                                }
                            }
                            if(!isset($_POST[$key]) && !empty($val)) {
                                $_POST[$key] = $val;
                                $_REQUEST[$key] = $_POST[$key];
                            }
                        }
                    }
                }
                if($k == "fwid") {
                    if(!isset($_POST["admin_fwid"])) {
                        $_POST["admin_fwid"] = $v;
                        $_REQUEST["admin_fwid"] = $_POST["admin_fwid"];
                    }
                } else {
                    if($k == "recipe" && !is_numeric($v)) {
                        $v = !is_array($v) ? _unserialize($v) : $v;
                    }
                    if(!isset($_POST[$k])) {
                        $_POST[$k] = $v;
                        $_REQUEST[$k] = $_POST[$k];
                    }
                    if($k == "vnc" && !isset($_POST["vncpass"])) {
                        $_POST["vncpass"] = generateRandStr($kernel->features("vncpasslen", $plans[$plid]["virt"]));
                        $_REQUEST["vncpass"] = $_POST["vncpass"];
                    }
                    if($k == "dns_nameserver" && !isset($_POST["dns"])) {
                        $_POST["dns"] = _unserialize($plans[$plid]["dns_nameserver"]);
                        $_REQUEST["dns"] = $_POST["dns"];
                    }
                    if($k == "io" && !isset($_POST["priority"])) {
                        $_POST["priority"] = $v;
                        $_REQUEST["priority"] = $_POST["priority"];
                    }
                    if($k == "swap" && !isset($_POST["swapram"])) {
                        $_POST["swapram"] = $v;
                        $_REQUEST["swapram"] = $_POST["swapram"];
                    }
                }
            }
        }
    }
    $servergroups = server_groups();
    $additional_params = ["ram", "bandwidth", "cores", "num_ips", "num_ips_int", "num_ips6", "num_ips6_subnet"];
    $additional_params = array_unique($additional_params);
    foreach ($additional_params as $ak => $av) {
        $tmp_additional = optREQ("additional_" . $av);
        if(!empty($tmp_additional)) {
            $_POST[$av] = $_POST[$av] + $tmp_additional;
        }
    }
    if(!empty($_POST["space"]) && is_numeric($_POST["space"])) {
        $additional_space = (double) optREQ("additional_space");
        if(!empty($additional_space)) {
            $_POST["space"] = $_POST["space"] + $additional_space;
        }
    }
    $demo_check = (int) optREQ("demo");
    if($demo_check == 1) {
        $demo = [];
        $demo_date = POST("demo_date", $l["no_date"]);
        $demo_time = POST("demo_time", $l["no_time"]);
        $demo_action = (int) optPOST("demo_action", 0);
        if(!empty($demo_date) && !valid_date($demo_date)) {
            $error["inv_date"] = $l["inv_demodate"];
            return false;
        }
        $demo["time"] = valid_time($demo_time, $demo_date);
        $demo["action"] = $demo_action;
        if(empty($demo["time"])) {
            $error["inv_time"] = $l["inv_demotime"];
            return false;
        }
        if($demo["time"] < time()) {
            $error["inv_time"] = $l["inv_demodate"];
            return false;
        }
    }
    $createAsLB = $_REQUEST["load_balancer"] == -1 ? true : false;
    if(isset($_REQUEST["node_select"])) {
        $node_selected = -1;
        $server_group = $_REQUEST["server_group"];
        $slave_server = strtolower($_REQUEST["slave_server"]);
        $ns_ram = (int) $_REQUEST["ram"];
        $ns_cores = (int) $_REQUEST["cores"];
        $ns_space = (int) $_REQUEST["space"];
        $ns_ips = (int) $_REQUEST["num_ips"];
        $ns_ipv6_subnets = (int) $_REQUEST["num_ips6_subnet"];
        $ns_ipv6 = (int) $_REQUEST["num_ips6"];
        $ns_ips_int = (int) $_REQUEST["num_ips_int"];
        $ns_bandwidth = (int) $_REQUEST["bandwidth"];
        $_hvm = optREQ("hvm") ? 1 : 0;
        $__virt = optREQ("virt");
        $ha = optREQ("ha");
        $tmp_servers = $servers;
        if(!empty($ha)) {
            $sgids = [];
            foreach ($servers as $k => $v) {
                if(empty($v["ha_master"])) {
                } else {
                    $sgids[] = $v["ha_master"];
                }
            }
            if(!empty($sgids)) {
                $tmp_servers = [];
                foreach ($servers as $k => $v) {
                    if(!in_array($v["sgid"], $sgids)) {
                    } else {
                        $tmp_servers[$k] = $v;
                    }
                }
            }
        }
        foreach ($tmp_servers as $k => $v) {
            $tmp_servers[$k]["_ram"] = !empty($v["overcommit"]) ? $v["overcommit"] - $v["alloc_ram"] : $v["ram"];
        }
        $stid = (int) optREQ("stid");
        list_all_storages();
        $_storage_types = $kernel->features("storage_types", $__virt . (!empty($_hvm) ? "hvm" : ""));
        foreach ($storages as $k => $v) {
            if(!empty($_storage_types) && !in_array($v["type"], $_storage_types)) {
                unset($storages[$k]);
            }
        }
        $_storages = $storages;
        foreach ($tmp_servers as $k => $v) {
            $server_name = $v["server_name"];
            if(empty($v["status"])) {
                $ns_server_filtered[$k] = $server_name . " | I am offline !";
                unset($tmp_servers[$k]);
            } elseif($v["status"] == 2) {
                $ns_server_filtered[$k] = $server_name . " | My license has expired !";
                unset($tmp_servers[$k]);
            } elseif(!empty($v["locked"])) {
                $ns_server_filtered[$k] = $server_name . " | I am locked !";
                unset($tmp_servers[$k]);
            } elseif(empty($k) && !empty($globals["is_master_only"])) {
                $ns_server_filtered[$k] = $server_name . " | I am Master Only !";
                unset($tmp_servers[$k]);
            } elseif(!in_array($__virt, $v["virts"])) {
                $ns_server_filtered[$k] = $server_name . " | Virt Required : " . $__virt . " and I support : " . implode($v["virts"]);
                unset($tmp_servers[$k]);
            } elseif(!empty($_hvm) && empty($v["hvm"])) {
                $ns_server_filtered[$k] = $server_name . " | HVM Required : " . $_hvm . " and I support : " . $v["hvm"];
                unset($tmp_servers[$k]);
            } else {
                $tmp_disk_space = 0;
                $_stid = -1;
                if(empty($stid)) {
                    foreach ($_storages as $sk => $sv) {
                        if(empty($sv["primary_storage"])) {
                        } elseif(array_key_exists($k, $_storages[$sk]["servers"]) || array_key_exists($v["sgid"], $_storages[$sk]["server_groups"]) || array_key_exists(-1, $_storages[$sk]["servers"])) {
                            $_stid = $sk;
                        }
                    }
                } elseif(array_key_exists($k, $_storages[$stid]["servers"]) || array_key_exists($v["sgid"], $_storages[$stid]["server_groups"]) || array_key_exists(-1, $_storages[$stid]["servers"])) {
                    $_stid = $stid;
                }
                if(!empty($_storages[$_stid])) {
                    $sv = $_storages[$_stid];
                    if(!empty($sv["oversell"])) {
                        $alloc_space = storage_allocated_space($_stid);
                        $tmp_disk_space = $sv["oversell"] - $alloc_space;
                    } else {
                        $tmp_disk_space = $sv["free"];
                    }
                }
                if($tmp_disk_space < $ns_space) {
                    $ns_server_filtered[$k] = $server_name . " | Space Required : " . $ns_space . " and I support : " . $tmp_disk_space;
                    unset($tmp_servers[$k]);
                } else {
                    $tmp_servers[$k]["space"] = $tmp_disk_space;
                    $ser_setting = unserialize($v["settings"]);
                    if(!empty($ser_setting["vpslimit"]) && $ser_setting["vpslimit"] <= $v["numvps"]) {
                        $ns_server_filtered[$k] = $server_name . " | I have reached the max VPS limit of " . $ser_setting["vpslimit"] . " set by the Admin";
                        unset($tmp_servers[$k]);
                    } else {
                        if(!empty($ser_setting["vcores"])) {
                            $res = makequery("SELECT SUM(cores) as used_cores FROM vps WHERE serid = :serid", [":serid" => $k]);
                            $row = vsql_fetch_assoc($res);
                            if($ser_setting["vcores"] <= $row["used_cores"]) {
                                $ns_server_filtered[$k] = $server_name . " | I have reached the max Virtual Core limit of " . $ser_setting["vcores"] . " set by the Admin";
                                unset($tmp_servers[$k]);
                            } else {
                                $tmp_servers[$k]["vcores"] = $row["used_cores"];
                            }
                        }
                        if(!empty($v["licnumvs"]) && $v["licnumvs"] <= $v["numvps"]) {
                            $ns_server_filtered[$k] = $server_name . " | I am not licensed to create more than " . $v["licnumvs"] . " VPS. Please upgrade my license !";
                            unset($tmp_servers[$k]);
                        } elseif($v["_ram"] < $ns_ram) {
                            $ns_server_filtered[$k] = $server_name . " | Ram Required : " . $ns_ram . " and I support : " . $v["_ram"];
                            unset($tmp_servers[$k]);
                        } elseif($v["ips"] < $ns_ips) {
                            $ns_server_filtered[$k] = $server_name . " | Required number of IPv4 : " . $ns_ips . " and I support : " . $v["ips"];
                            unset($tmp_servers[$k]);
                        } elseif($v["ipv6"] < $ns_ipv6) {
                            $ns_server_filtered[$k] = $server_name . " | Required number of IPv6 : " . $ns_ipv6 . " and I support : " . $v["ipv6"];
                            unset($tmp_servers[$k]);
                        } elseif($v["ipv6_subnet"] < $ns_ipv6_subnets) {
                            $ns_server_filtered[$k] = $server_name . " | Required number of IPv6 Subnet : " . $ns_ipv6_subnets . " and I support : " . $v["ipv6_subnet"];
                            unset($tmp_servers[$k]);
                        } elseif($v["ips_int"] < $ns_ips_int) {
                            $ns_server_filtered[$k] = $server_name . " | Required number of Internal IPs : " . $ns_ips_int . " and I support : " . $v["int_ips"];
                            unset($tmp_servers[$k]);
                        }
                    }
                }
            }
        }
        $tmp_resource_preference = !empty($servergroups[$server_group]["sg_select"]) ? $servergroups[$server_group]["sg_select"] : $globals["resource_preference"];
        $tmp_resource_preference = 0 < strlen($server_group) && $server_group != 0 ? $tmp_resource_preference : $globals["resource_preference"];
        if(!empty($tmp_resource_preference) && $tmp_resource_preference < 9 && 0 < $tmp_resource_preference) {
            $resource_map = ["1" => "space", "2" => "_ram", "3" => "vcores", "4" => "ips", "5" => "ipv6", "6" => "ipv6_subnet", "7" => "numvps", "8" => "sys_load"];
            foreach ($tmp_servers as $tk => $tv) {
                $sort_resource[$tk] = $tv[$resource_map[$tmp_resource_preference]];
            }
            if(in_array($resource_map[$tmp_resource_preference], ["numvps", "vcores", "sys_load"])) {
                array_multisort($sort_resource, SORT_ASC, $tmp_servers);
            } else {
                array_multisort($sort_resource, SORT_DESC, $tmp_servers);
            }
        }
        if(empty($tmp_servers)) {
            $error[] = $l["no_serverfound"];
        }
        if(!empty($ns_server_filtered) && empty($tmp_servers)) {
            $error[] = $l["exclude_server"];
            foreach ($ns_server_filtered as $ek => $ev) {
                $error[] = $l["serid"] . ": " . $servers[$ek]["serid"] . ", " . $l["reason"] . ": " . $ev;
            }
            return false;
        } else {
            $tmp_servers = apply_filters("server_selection", $tmp_servers);
            if(0 < strlen($slave_server)) {
                if($slave_server == "auto") {
                    foreach ($tmp_servers as $k => $v) {
                        if($createAsLB && !$cluster->check_licensepro($v["serid"])) {
                        } else {
                            $newserid = $v["serid"];
                        }
                    }
                } else {
                    $newserid = (int) $slave_server;
                    if($createAsLB && !$cluster->check_licensepro($newserid)) {
                        $error[] = $l["lb_no_pro_serv"];
                        return false;
                    }
                }
                if($createAsLB && (strlen($newserid) < 1 || empty($servers[$newserid]))) {
                    $error[] = $l["lb_no_pro_serv_grp"];
                    return false;
                }
                if(strlen($newserid) < 1 || empty($servers[$newserid])) {
                    $error["node_select"] = $l["no_slaveserver"] . " - " . $slave_server;
                }
            } elseif(0 < strlen($server_group)) {
                $sgid = (int) $server_group;
                if(strlen($sgid) < 1 || empty($servergroups[$sgid])) {
                    $error["node_select"] = $l["sg_notfound"] . " - " . $server_group;
                }
                foreach ($tmp_servers as $k => $v) {
                    if($v["sgid"] != $sgid) {
                    } elseif($createAsLB && !$cluster->check_licensepro($v["serid"])) {
                    } else {
                        $newserid = $v["serid"];
                        if($createAsLB && (strlen($newserid) < 1 || empty($servers[$newserid]))) {
                            $error[] = $l["lb_no_pro_serv_reg"];
                            return false;
                        }
                        if(strlen($newserid) < 1 || empty($servers[$newserid])) {
                            $error[] = $l["virtserver_notfound"] . " - " . $__virt;
                        }
                    }
                }
            }
        }
    }
    if(!empty($error)) {
        return false;
    }
    if(isset($newserid)) {
        $node_selected = $newserid;
        set_active_server((int) $newserid);
    }
    $pro_lic = $cluster->check_licensepro($globals["server"]);
    if($createAsLB && !$pro_lic) {
        $error[] = $l["lb_no_pro_serv"];
        return false;
    }
    $virt = server_primary_virt($globals["server"]);
    $loop_device = $cluster->check_loop_device($globals["server"]);
    if(in_array(optREQ("virt"), ["openvz", "xen", "kvm", "xcp", "lxc", "vzo", "vzk", "proxo", "proxk", "proxl"]) && server_virt($globals["server"], optREQ("virt")) == optREQ("virt")) {
        $virt = $_virt = optREQ("virt");
        $hvm = (int) optREQ("hvm");
        $hvm = 0 < $hvm ? 1 : 0;
    }
    if($cluster->virt(0, 1, 1, 0, 1)) {
        $hvm = $servers[$globals["server"]]["hvm"];
    }
    $_virt = $virt . (!empty($hvm) ? "hvm" : "");
    $is_centos7 = $cluster->os_check($globals["server"], "centos", ">=", 7);
    $is_ubuntu12 = $cluster->os_check($globals["server"], "ubuntu", ">=", 12);
    $is_ubuntu12 or $os_check = $is_ubuntu12 || $is_centos7;
    if(optREQ("error") || optREQ("done")) {
        $actid = (int) optGET("actid");
        $res = makequery("SELECT * FROM `tasks`\n\t\t\t\t\t\t  WHERE actid = :actid\n\t\t\t\t\t\t  AND action = 'addvs'", [":actid" => $actid]);
        if(0 < vsql_num_rows($res)) {
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $tasks[$row["actid"]] = $row;
            }
        }
        if(!empty($tasks)) {
            foreach ($tasks as $k => $v) {
                if(optREQ("done")) {
                    $done_data = unserialize($v["data"]);
                }
                if(optREQ("error")) {
                    $error[] = $v["status_txt"];
                }
            }
        }
        if(is_master()) {
            $ret = $cluster->reverse_sync($globals["server"]);
        }
        return true;
    } else {
        $load_ajax_user = optGET("load_ajax_user");
        if(!empty($load_ajax_user)) {
            $_email = optREQ("email");
            $ajax_user = get_ajax_user($_email);
            return true;
        }
        $generate_keys = optGET("generate_keys");
        if(!empty($generate_keys)) {
            $new_keys = generatekeys();
            return true;
        }
        oslist();
        sort_media("ostemplates", "name");
        load_scripts();
        update_webuzoapps();
        $webuzo_apps = load_webuzoapps();
        $iscripts_allowed = get_web_scripts();
        $webuzo_templates = webuzo_os($virt);
        foreach ($iscripts_allowed as $k => $v) {
            if(!array_key_exists($v, $iscripts)) {
                unset($iscripts_allowed[$k]);
            } else {
                $allowed_scripts[$l["cat_php_" . $scripts[$v]["category"]]][$v]["name"] = $scripts[$v]["name"];
                $allowed_scripts[$l["cat_php_" . $scripts[$v]["category"]]][$v]["softname"] = $scripts[$v]["softname"];
            }
        }
        $webuzo_done["allowed_scripts"] = $allowed_scripts;
        $webuzo_done["webuzo_apps"] = $webuzo_apps;
        if(empty($globals["noc_apikey"]) && empty($globals["noc_apipass"])) {
            $webuzo_done["isfree"] = 1;
        }
        $webuzoscriptid = (int) optGET("scriptreqid");
        if(!empty($webuzoscriptid)) {
            if(!array_key_exists($webuzoscriptid, $scripts)) {
                $error[] = $l["webuzo_script_err"];
                return NULL;
            }
            $stack = [];
            $stack = load_free_webapps();
            $req = get_script_req($webuzoscriptid);
            if(empty($req)) {
                $webuzo_apps = $stack;
            } else {
                foreach ($req as $key => $val) {
                    if($val["type"] === "version") {
                        foreach ($webuzo_apps[$val["check"]] as $appkey => $appval) {
                            if(!version_compare($appval["version"], $val["version"], $val["operator"])) {
                                unset($webuzo_apps[$val["check"]][$appkey]);
                            }
                        }
                    }
                }
                if(empty($webuzo_apps["php"])) {
                    $error[] = $l["webuzo_support_err"];
                    $support_err = 1;
                }
            }
            $webuzo_done["webuzo_apps"] = $webuzo_apps;
            return NULL;
        }
        $mgs = listmgs();
        if($kernel->features("iso_support", $_virt)) {
            isolist();
        }
        $dnsplans = [[]];
        $res = makequery("SELECT * FROM dnsplans");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $dnsplans[$row["dnsplid"]] = $row;
        }
        $dnsplans[0] = end($dnsplans);
        foreach ($dnsplans[0] as $k => $v) {
            $dnsplans[0][$k] = NULL;
        }
        $dnsplans[0]["dnsplid"] = 0;
        $dnsplans[0]["plan_name"] = $l["none_plan"];
        $ip_pid = optREQ("ippoolid");
        if(!empty($ip_pid)) {
            $ip_pids = cexplode(",", $ip_pid, 1);
        }
        $ip_pids = filter_ippool_ipid($ip_pids, 0);
        $backup_plans = [];
        $res = makequery("SELECT * FROM backup_plans");
        for ($i = 0; $i < vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $backup_plans[$row["bpid"]] = $row;
        }
        get_fw_plans_by_user([], 1);
        $resid = makequery("SELECT ips.ippid FROM ippool_servers ips, ippool ip\n\t\t\t\t\t\tWHERE ip.ippid = ips.ippid AND \n\t\t\t\t\t\tip.uid = 0 AND \n\t\t\t\t\t\t(ips.sgid = :sgid\n\t\t\t\t\t\tOR ips.serid IN ('-1', :serid))", [":serid" => $globals["server"], ":sgid" => $servers[$globals["server"]]["sgid"]]);
        $ippid = [];
        for ($i = 0; $i < vsql_num_rows($resid); $i++) {
            $row = vsql_fetch_assoc($resid);
            $ippid[] = $row["ippid"];
        }
        $tmp_ippid = $ippid;
        if(!empty($ip_pids)) {
            $ippids = [];
            foreach ($ip_pids as $_ippid) {
                if(!in_array($_ippid, $ippid)) {
                    $noippool[] = $_ippid;
                } else {
                    $ippids[] = $_ippid;
                }
            }
            if(empty($ippids)) {
                $error[] = $l["err_noippool"] . implode(", ", $noippool);
            } else {
                $ippid = [];
                $ippid = $ippids;
            }
        }
        $ips = [];
        $ips6 = [];
        $ips6_subnet = [];
        $ips_int = [];
        $uid = (int) optREQ("uid");
        if(!empty($_REQUEST["pool_uid"])) {
            $uid = (int) optREQ("pool_uid");
        }
        if(!empty($uid)) {
            $q["query"] = "SELECT uid,pid FROM `users` WHERE uid = :uid";
            $q["token"] = [":uid" => $uid];
            $q["id"] = "uid";
            $r = select_query($q);
            if(!empty($r[$uid]["pid"])) {
                $uid = $r[$uid]["pid"];
            }
            $params["query"] = "SELECT ips.ippid FROM ippool_servers ips, ippool ip\n\t\t\t\t\t\t\tWHERE ip.ippid = ips.ippid AND \n\t\t\t\t\t\t\tip.uid = :uid AND \n\t\t\t\t\t\t\t(ips.sgid = :sgid\n\t\t\t\t\t\t\tOR ips.serid IN ('-1', :serid))";
            $params["token"] = [":serid" => $globals["server"], ":sgid" => $servers[$globals["server"]]["sgid"], ":uid" => $uid];
            $params["id"] = "ippid";
            $rows = select_query($params);
            if(!empty($rows)) {
                if(!empty($ippid)) {
                    call_user_func_array("array_unshift", array_merge([$ippid], array_keys($rows)));
                } else {
                    $ippid = array_keys($rows);
                }
            }
        }
        $ippid = filter_ippool_ipid($ippid, $uid);
        $ippid_token["tokens"] = [];
        if(!empty($ippid)) {
            $ippid_token = vsql_in_tokens($ippid);
        }
        $res = makequery("SELECT sum(ipv6) as ipv6_pool, sum(internal) as internal_pool FROM ippool WHERE ippid IN ('-1'" . (!empty($ippid) ? ", " . $ippid_token["query"] : "") . ")", $ippid_token["tokens"]);
        $row = vsql_fetch_assoc($res);
        $is_internal_pool = empty($row["internal_pool"]) ? $tmp_ippid : $ippid;
        $is_ipv6_pool = empty($row["ipv6_pool"]) ? $tmp_ippid : $ippid;
        $res = makequery("SELECT i.* FROM ips i\n\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid)\n\t\t\t\t\t\tWHERE (i.ippid IN (" . (count($ippid) < 1 ? -2 : $ippid_token["query"]) . ")\n\t\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :serid)))\n\t\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\t\tAND i.ipv6 = 0\n\t\t\t\t\t\tAND ip.internal = 0\n\t\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\t\tORDER BY FIELD(ip.ippid , " . (count($ippid) < 1 ? -2 : implode(",", $ippid)) . ")\n\t\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($ippid_token["tokens"], [":serid" => $globals["server"]]));
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $ips[$row["ipid"]] = $row;
        }
        $int_ippid_token["tokens"] = [];
        if(1 <= count($is_internal_pool)) {
            $int_ippid_token = vsql_in_tokens($is_internal_pool);
        }
        $res = makequery("SELECT i.*, ip.internal FROM ips i\n\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\t\tWHERE (i.ippid IN (" . (count($is_internal_pool) < 1 ? -2 : $int_ippid_token["query"]) . ")\n\t\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :ip_serid)))\n\t\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\t\tAND i.ipv6 = 0\n\t\t\t\t\t\tAND ip.internal = 1\n\t\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\t\tORDER BY FIELD(ip.ippid , " . (count($is_internal_pool) < 1 ? -2 : implode(",", $is_internal_pool)) . "), ip.uid DESC\n\t\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($int_ippid_token["tokens"], [":ip_serid" => $globals["server"]]));
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $ips_int[$row["ipid"]] = $row;
        }
        $ipv6_ippid_token["tokens"] = [];
        if(1 <= count($is_ipv6_pool)) {
            $ipv6_ippid_token = vsql_in_tokens($is_ipv6_pool);
        }
        $res = makequery("SELECT i.* FROM ips i\n\t\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\t\tWHERE (i.ippid IN (" . (count($is_ipv6_pool) < 1 ? -2 : $ipv6_ippid_token["query"]) . ")\n\t\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :ip_serid)))\n\t\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\t\tAND i.ipv6 = 1\n\t\t\t\t\t\tAND ip.internal = 0\n\t\t\t\t\t\tAND i.ipr_netmask = ''\n\t\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\t\tORDER BY FIELD(ip.ippid , " . (count($is_ipv6_pool) < 1 ? -2 : implode(",", $is_ipv6_pool)) . ")\n\t\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($ipv6_ippid_token["tokens"], [":ip_serid" => $globals["server"]]));
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $ips6[$row["ipid"]] = $row;
        }
        $ipv6_sub_ippid_token["tokens"] = [];
        if(1 <= count($is_ipv6_pool)) {
            $ipv6_sub_ippid_token = vsql_in_tokens($is_ipv6_pool);
        }
        $res = makequery("SELECT i.* FROM ips i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE (i.ippid IN (" . (count($is_ipv6_pool) < 1 ? -2 : $ipv6_sub_ippid_token["query"]) . ")\n\t\t\t\t\tOR (i.ippid = 0 AND i.ip_serid IN (-1, :ip_serid)))\n\t\t\t\t\tAND i.vpsid = 0\n\t\t\t\t\tAND i.ipv6 = 1\n\t\t\t\t\tAND i.ipr_netmask != ''\n\t\t\t\t\tAND i.locked = 0\n\t\t\t\t\tORDER BY FIELD(ip.ippid , " . (count($is_ipv6_pool) < 1 ? -2 : implode(",", $is_ipv6_pool)) . ")\n\t\t\t\t\tLIMIT 0, " . $globals["max_ips"], array_merge($ipv6_sub_ippid_token["tokens"], [":ip_serid" => $globals["server"]]));
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $ips6_subnet[$row["ipid"]] = $row;
        }
        if(!empty($globals["randomize_ips"])) {
            if(!empty($ips)) {
                shuffle($ips);
            }
            if(!empty($ips_int)) {
                shuffle($ips_int);
            }
            if(!empty($ips6)) {
                shuffle($ips6);
            }
            if(!empty($ips6_subnet)) {
                shuffle($ips6_subnet);
            }
        }
        $ip_details = apply_filters("randomize_ips", $ips, $ips_int, $ips6, $ips6_subnet);
        if(!empty($ip_details)) {
            if(!empty($ip_details["ips"])) {
                $ips = $ip_details["ips"];
            }
            if(!empty($ip_details["ips_int"])) {
                $ips_int = $ip_details["ips_int"];
            }
            if(!empty($ip_details["ips6"])) {
                $ips6 = $ip_details["ips6"];
            }
            if(!empty($ip_details["ips6_subnet"])) {
                $ips6_subnet = $ip_details["ips6_subnet"];
            }
        }
        $res = makequery("SELECT uid, email, pid, inhouse_billing \n\t\t\t\t\tFROM users \n\t\t\t\t\tORDER BY email \n\t\t\t\t\tLIMIT 0, " . (empty($globals["load_user_limit"]) ? 250 : $globals["load_user_limit"]));
        $users = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(!empty($_REQUEST["load_balancer"]) && empty($row["inhouse_billing"])) {
            } else {
                $users[$row["uid"]] = $row;
            }
        }
        $res = makequery("SELECT serid, sg_ha FROM servers \n\t\t\t\t\tRIGHT JOIN server_groups \n\t\t\t\t\tON (servers.sgid = server_groups.sgid)\n\t\t\t\t\tWHERE server_groups.sg_ha != ''");
        $ha_enabled = [];
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            if(!empty($row["sg_ha"])) {
                $ha_enabled[$row["serid"]] = $row;
            }
        }
        $resources = $cluster->resources($globals["server"], $virt);
        $stid = (int) optREQ("stid");
        if(empty($stid)) {
            $stid = storage_get_primary($virt);
        }
        if(empty($stid)) {
            $error["no_storage"] = $l["no_storage"];
            return false;
        }
        if(empty($storages[$stid])) {
            $error[] = $l["inv_storage"];
        }
        $storage_types = $kernel->features("storage_types", $_virt);
        foreach ($resources["storages"] as $_stid => $v) {
            if(!empty($storage_types) && !in_array($v["type"], $storage_types)) {
                unset($storages[$_stid]);
            } else {
                $storage_uuids[$v["st_uuid"]] = $_stid;
                if(!empty($v["oversell"])) {
                    $alloc_space = storage_allocated_space($_stid);
                    $storages[$_stid]["disk_space"] = $v["oversell"] - $alloc_space;
                } else {
                    $storages[$_stid]["disk_space"] = $v["free"];
                }
                $resources["storages"][$_stid]["disk_space"] = $storages[$_stid]["disk_space"];
            }
        }
        $res = makequery("SELECT `stid`, `serid`, `sgid` FROM `storage_servers` ORDER BY `stid`");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $resources["storages"][$row["stid"]]["serids"][$row["serid"]] = $row["serid"];
            $resources["storages"][$row["stid"]]["sgids"][$row["sgid"]] = $row["sgid"];
        }
        $res = makequery("SELECT rid, name FROM recipes WHERE status <> 0 ORDER BY rid ASC");
        for ($i = 1; $i <= vsql_num_rows($res); $i++) {
            $row = vsql_fetch_assoc($res);
            $recipes[$row["rid"]] = $row;
        }
        if($kernel->features("pci_passthrough", $virt)) {
            $iommu_grp = [];
            $res2 = makequery("SELECT `pid`, `iommu_grp_num`, `vpsid` FROM `passthrough` WHERE vpsid != 0 AND `serid` = " . $globals["server"] . " AND type = 'pci' ORDER BY `pid` ASC");
            for ($i = 1; $i <= vsql_num_rows($res2); $i++) {
                $row2 = vsql_fetch_assoc($res2);
                $iommu_grp[] = $row2["iommu_grp_num"];
            }
            $res = makequery("SELECT `pid`, `name`, `type`, `iommu_grp_num`, `status`, `vpsid` FROM `passthrough` WHERE (vpsid IS NULL OR vpsid = 0) AND `serid` = " . $globals["server"] . " ORDER BY `pid` ASC");
            for ($i = 1; $i <= vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                if($row["type"] == "pci" && !is_null($row["iommu_grp_num"])) {
                    if(!empty($iommu_grp) && in_array($row["iommu_grp_num"], $iommu_grp)) {
                    } else {
                        $pcis[$row["iommu_grp_num"]][$row["pid"]] = "(" . $row["pid"] . " - " . $row["name"] . "), ";
                        if($row["status"] < 1) {
                            $pci_disabled[$row["iommu_grp_num"]] = 0;
                        }
                    }
                } elseif($row["type"] == "usb" && 0 < $row["status"]) {
                    $usbs[$row["pid"]] = $row;
                }
            }
            if(!empty($pci_disabled)) {
                foreach ($pci_disabled as $k => $p) {
                    if($p == 0) {
                        unset($pcis[$k]);
                    }
                }
            }
            $gpu_roms = $cluster->pci_manager($globals["server"], [], "node_gpuroms");
        }
        if($globals["is_master_only"] == 1 && empty($globals["server"])) {
            $error[] = $l["masteronly_cant_exp"];
            return false;
        }
        if($globals["version"] != $resources["version"]) {
            $error[] = $l["ms_ver_mismatch"];
            return false;
        }
        $cpu_modes = [];
        $machine_type = [];
        $supported_nics = $kernel->features("nic", $virt);
        $cpu_modes = $kernel->features("cpu_mode_list", $virt);
        $bus_driver = $kernel->features("bus_driver_list", $virt);
        if(!empty($resources["cpu_model"])) {
            $cpu_modes += $resources["cpu_model"];
        }
        if(!empty($resources["machine_type"])) {
            $machine_type = $resources["machine_type"];
        }
        if(isset($_POST["addvps"])) {
            if(!empty($servers[$globals["server"]]["locked"])) {
                $error[] = $l["server_locked"];
                return false;
            }
            $newvs = [];
            $newvs["uuid"] = generateRandStr(16);
            $newvs["pass"] = POST("rootpass", $l["no_rootpass"]);
            $newvs["plid"] = (int) optPOST("plid");
            $newvs["hostname"] = POST("hostname", $l["no_hname"]);
            $newvs["space"] = $_POST["space"];
            $newvs["bus_driver"] = optPOST("bus_driver");
            $newvs["bus_driver_num"] = (int) optPOST("bus_driver_num");
            $newvs["ram"] = (int) POST("ram", $l["no_ram"], 0);
            $newvs["bandwidth"] = (int) POST("bandwidth", $l["no_bandwidth"]);
            $newvs["network_speed"] = (int) optPOST("network_speed");
            $newvs["upload_speed"] = (int) optPOST("upload_speed");
            $newvs["cores"] = (int) POST("cores", $l["no_cpu_cores"]);
            $newvs["cpupin"] = -1;
            $newvs["uid"] = (int) optPOST("uid");
            $newvs["io"] = 0;
            $newvs["burst"] = 0;
            $newvs["cpu_percent"] = 0;
            $newvs["swap"] = 0;
            $newvs["acpi"] = 0;
            $newvs["apic"] = 0;
            $newvs["pae"] = 0;
            $newvs["vnc"] = 0;
            $newvs["vncport"] = 0;
            $newvs["shadow"] = 0;
            $newvs["virt"] = $virt;
            $newvs["hvm"] = ((int) optREQ("hvm") ? 1 : 0) && !empty($hvm) && ($virt == "xcp" || $virt == "xen") ? 1 : 0;
            $newvs["iso"] = "";
            $newvs["boot"] = "";
            $newvs["band_suspend"] = (int) optREQ("band_suspend") ? 1 : 0;
            $newvs["speed_cap_down"] = (int) optPOST("speed_cap_down");
            $newvs["speed_cap_up"] = (int) optPOST("speed_cap_up");
            $newvs["tuntap"] = 0;
            $newvs["ppp"] = 0;
            $newvs["mac_status"] = 0;
            $newvs["osreinstall_limit"] = (int) optPOST("osreinstall_limit");
            $newvs["mg"] = [];
            $newvs["kvm_cache"] = "";
            $newvs["io_mode"] = "";
            $newvs["vnc_keymap"] = "";
            $newvs["virtio"] = 0;
            $newvs["numa"] = 0;
            $newvs["cpu_mode"] = optPOST("cpu_mode");
            $newvs["admin_managed"] = (int) optREQ("admin_managed") ? 1 : 0;
            $newvs["rdp"] = (int) optREQ("rdp") ? 1 : 0;
            $newvs["disable_nw_config"] = (int) optREQ("disable_nw_config") ? 1 : 0;
            $newvs["topology_sockets"] = 0;
            $newvs["topology_cores"] = 0;
            $newvs["topology_threads"] = 0;
            $newvs["openvz_features"] = "";
            $newvs["bpid"] = (int) optPOST("bpid");
            $newvs["install_xentools"] = (int) optPOST("install_xentools");
            $newvs["sec_iso"] = optPOST("sec_iso");
            $newvs["ha"] = 0;
            $newvs["unprivileged"] = 0;
            $newvs["demo"] = 0;
            $newvs["dont_add_ptr"] = (int) optREQ("dont_add_ptr") ? 1 : 0;
            $dont_dd_os_temp = (int) optPOST("DONT_DD_OS_TEMPLATE");
            $newvs["fwid"] = (int) optPOST("fwid");
            $newvs["admin_fwid"] = (int) optPOST("admin_fwid");
            if($newvs["bus_driver"] == "ide" && ($newvs["bus_driver_num"] < 2 || 3 < $newvs["bus_driver_num"])) {
                $error[] = $l["ide_bus_num_err"];
            }
            $vps_data = ["os_type", "rtc", "unprivileged", "vnc_auto_port", "nested_virt", "vga_vram", "discard", "vlan_tag", "enable_guest_agent", "ssd_emulation", "machine_type", "bios", "enable_tpm", "disable_password", "ssh_options", "added_keys", "io_uring", "min_ram", "cpu_flags", "scsi_controller", "demo", "enable_cpu_threshold", "cpu_threshold", "cpu_threshold_time", "disable_guest_agent"];
            if(check_licensepro()) {
                $vps_data = array_merge($vps_data, ["enable_ver_scaling", "ver_max_ram", "ver_ram_threshold", "ver_ram_inc_by", "ver_max_cpu", "ver_cpu_threshold", "ver_cpu_inc_by"]);
            }
            foreach ($vps_data as $vk => $vv) {
                $newvs[$vv] = 0;
            }
            if($kernel->features("balloon", $virt) && $cluster->check_feature($globals["server"], $virt, "min_ram")) {
                $min_ram = (int) optPOST("min_ram");
                if(!empty($min_ram)) {
                    if($newvs["ram"] < $min_ram) {
                        $error[] = $l["min_ram_error"];
                        return false;
                    }
                    $newvs["min_ram"] = $min_ram;
                } else {
                    $newvs["min_ram"] = $newvs["ram"];
                }
            }
            if($kernel->features("cpu_flags", $virt) && $cluster->check_feature($globals["server"], $virt, "cpu_flags")) {
                $cpus = prox_cpu_flags($newvs["cpu_mode"]);
                $cpu_flags = [];
                foreach ($cpus["cpu_flags"] as $f) {
                    $cpu_flags = array_merge($cpu_flags, [$f => optREQ($f)]);
                }
                $newvs["cpu_flags"] = $cpu_flags;
            }
            if($kernel->features("machine_type", $virt)) {
                $newvs["machine_type"] = optREQ("machine_type");
            }
            if($newvs["ssh_options"] == "generate_keys" && empty($_POST["sshkey"])) {
                $new_keys = generatekeys();
                $_POST["sshkey"] = $new_keys["public_key"];
                $_POST["private_key"] = $new_keys["private_key"];
            }
            if($kernel->features("scsihw", $virt)) {
                $newvs["scsi_controller"] = optREQ("scsi_controller");
            }
            $newvs["added_keys"] = [];
            $newvs["ssh_options"] = optPOST("ssh_options");
            if(!empty($_POST["restore"]) && !empty($_POST["added_keys"])) {
                $newvs["ssh_options"] = "add_ssh_keys";
                $_POST["sshkey"] = $_POST["added_keys"][0];
            }
            if($newvs["ssh_options"] == "add_ssh_keys" || $newvs["ssh_options"] == "generate_keys") {
                $sshkey = POST("sshkey", $l["no_key_provided"]);
                if($newvs["ssh_options"] == "generate_keys") {
                    $private_key = POST("private_key", $l["no_key_provided"]);
                }
                if(!empty($sshkey)) {
                    $sshkey = trim($_POST["sshkey"]);
                    if(strpos($sshkey, "\n") !== false) {
                        $error[] = $l["err_inv_ssh_key"];
                    }
                    $tmpfile = "/tmp/sshkey-" . generateRandStr(8);
                    file_put_contents($tmpfile, $sshkey);
                    vexec("ssh-keygen -lf " . xss($tmpfile), $out, $ret);
                    unlink($tmpfile);
                    if($ret != 0) {
                        $error[] = $l["err_inv_ssh_key"];
                    }
                    $newvs["added_keys"] = [$sshkey];
                }
            }
            if($newvs["ssh_options"] == "use_ssh_keys") {
                if(!empty($_POST["existing_key"])) {
                    $newvs["added_keys"] = $_POST["existing_key"];
                } else {
                    $error[] = $l["no_key_provided"];
                }
            }
            $newvs["disable_password"] = optPOST("disable_password");
            if(!empty($newvs["disable_password"]) && empty($newvs["ssh_options"])) {
                $error[] = $l["no_ssh_option"];
            }
            if(!empty($error)) {
                return false;
            }
            if($kernel->features("ssd_emulation", $virt)) {
                $ssd_emulation = (int) optREQ("ssd_emulation") ? 1 : 0;
                $virtio = (int) optPOST("virtio");
                if($virt == "kvm" && ($cluster->os_check($globals["server"], "centos", "<", 7) || $cluster->os_check($globals["server"], "ubuntu", "<", 0)) && !empty($ssd_emulation)) {
                    $error[] = $l["ssd_emulation_not_support_" . $virt];
                    return false;
                }
                if($virt == "kvm" && !empty($ssd_emulation)) {
                    $qemu_verison = $cluster->get_qemu_details($globals["server"]);
                    $virtio_array = version_compare($qemu_verison["libvirt_ver"], "7.3.0", "<") ? ["0", "1"] : ["1"];
                }
                if(!empty($ssd_emulation) && (!empty($newvs["bus_driver"]) && $newvs["bus_driver"] == "virtio" || in_array($virtio, $virtio_array))) {
                    $error[] = $l["ssd_does_not_support_" . $virt];
                    return false;
                }
                $newvs["ssd_emulation"] = $ssd_emulation;
            }
            if($kernel->features("os_type", $virt)) {
                $newvs["os_type"] = optPOST("os_type");
                if(empty($newvs["os_type"])) {
                    $newvs["os_type"] = "other";
                }
            }
            if($kernel->features("rtc", $virt)) {
                $newvs["rtc"] = (int) optPOST("rtc");
            }
            if($kernel->features("vga_vram", $virt)) {
                $newvs["vga_vram"] = (int) optPOST("vga_vram");
            }
            if($kernel->features("nested_virt", $virt)) {
                $newvs["nested_virt"] = (int) optPOST("nested_virt");
            }
            if($kernel->features("unprivileged", $virt)) {
                $newvs["unprivileged"] = (int) optPOST("unprivileged");
            }
            if($kernel->features("discard", $virt)) {
                $newvs["discard"] = (int) optPOST("discard");
            }
            if($kernel->features("vlan_tag", $virt)) {
                $newvs["vlan_tag"] = (int) optPOST("vlan_tag");
            }
            if(!empty($newvs["vlan_tag"]) && ($newvs["vlan_tag"] < 0 || 4094 < $newvs["vlan_tag"])) {
                $error[] = $l["vlan_tag_err"];
                return false;
            }
            if(!empty($globals["openvz7_auto_vnc"]) && $kernel->features("vnc_auto_port", $virt)) {
                $newvs["vnc_auto_port"] = 1;
            }
            if($kernel->features("vertical_scaling", $virt) && check_licensepro() && is_billing_user($newvs["uid"])) {
                $enable_ver_scaling = (int) optPOST("enable_ver_scaling");
                $arr = ["ver_max_ram", "ver_ram_threshold", "ver_ram_inc_by", "ver_max_cpu", "ver_cpu_threshold", "ver_cpu_inc_by"];
                $from_globals = 0;
                if(empty($enable_ver_scaling) && !empty($globals["enable_ver_scaling"])) {
                    $enable_ver_scaling = 1;
                    $from_globals = 1;
                }
                if(!empty($enable_ver_scaling)) {
                    foreach ($arr as $v) {
                        if(!empty($from_globals)) {
                            $newvs[$v] = (int) optPOST($v);
                        } else {
                            $newvs[$v] = (int) POST($v, $l[$v . "_err"], 0);
                        }
                    }
                    $newvs["enable_ver_scaling"] = $enable_ver_scaling;
                }
            }
            if(!empty($bus_driver) && empty($newvs["bus_driver"])) {
                $newvs["bus_driver"] = "sata";
            }
            if(empty($newvs["cores"])) {
                $error[] = $l["inv_cpu_cores"];
            }
            if($kernel->features("ha", $newvs["virt"])) {
                $newvs["ha"] = (int) optPOST("ha");
            }
            if(!empty($newvs["bpid"]) && $newvs["bpid"] != -1 && empty($backup_plans[$newvs["bpid"]])) {
                $error[] = $l["inv_bpid"];
            }
            if(!empty($newvs["admin_fwid"]) && empty($firewall_plans[$newvs["admin_fwid"]])) {
                $error[] = $l["inv_fwid"];
            }
            if(!empty($newvs["fwid"])) {
                get_fw_plans_by_user([$newvs["uid"]]);
            }
            if(!empty($newvs["fwid"]) && empty($firewall_plans[$newvs["fwid"]])) {
                $error[] = $l["inv_fwid"];
            }
            $req_virt = $newvs["virt"] . (!empty($newvs["hvm"]) ? "hvm" : "");
            $_tmp_osname = optREQ("os_name");
            if(!empty($_tmp_osname)) {
                foreach ($ostemplates as $k => $v) {
                    if($v["Nvirt"] != $req_virt) {
                    } elseif(strtolower($v["name"]) == $_tmp_osname) {
                        $_POST["osid"] = $k;
                    }
                }
                if(empty($_POST["osid"])) {
                    $error[] = $l["no_os"] . " " . $_tmp_osname;
                }
            }
            if(isset($_POST["webuzo_os"]) && isset($ostemplates[$_POST["webuzo_os"]])) {
                $_POST["osid"] = $_POST["webuzo_os"];
            }
            $_tmp_user_email = optREQ("user_email");
            if(!empty($_tmp_user_email)) {
                $res = makequery("SELECT uid, email, pid, inhouse_billing \n\t\t\t\t\tFROM users WHERE email = :email", [":email" => strtolower($_tmp_user_email)]);
                if(0 < vsql_num_rows($res)) {
                    $row = vsql_fetch_assoc($res);
                    $newvs["uid"] = $row["uid"];
                    $users[$row["uid"]] = $row;
                }
            }
            if(empty($users[$newvs["uid"]])) {
                $res = makequery("SELECT uid, email, pid, inhouse_billing\n\t\t\t\t\t\t\tFROM users \n\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $newvs["uid"]]);
                $row = vsql_fetch_assoc($res);
                $users[$row["uid"]] = $row;
            }
            if(!empty($users[$newvs["uid"]]["pid"]) && empty($users[$users[$newvs["uid"]]["pid"]])) {
                $res = makequery("SELECT uid, email, pid, inhouse_billing \n\t\t\t\t\t\t\tFROM users \n\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $users[$newvs["uid"]]["pid"]]);
                $row = vsql_fetch_assoc($res);
                $users[$row["uid"]] = $row;
            }
            if(json_decode($newvs["space"]) || json_decode($newvs["space"]) != NULL) {
                $newvs["space"] = json_decode($newvs["space"], 1);
            }
            useriso($newvs["uid"]);
            $selected_storage = [];
            $bus_driver_dupes = [];
            if(is_array($newvs["space"]) && !empty($newvs["space"])) {
                foreach ($newvs["space"] as $k => $disk_spec) {
                    $disk_spec["size"] = (int) $disk_spec["size"];
                    if($k == 0 && 2000 <= $disk_spec["size"] && empty($globals["disable_2tb_check"])) {
                        $error[] = $l["err_max_size"];
                    }
                    if($disk_spec["size"] < 1 || empty($disk_spec["st_uuid"])) {
                        $error[] = $l["inv_space"];
                    }
                    if(empty($storages[$storage_uuids[$disk_spec["st_uuid"]]])) {
                        $error[] = $l["inv_storage"];
                    }
                    if(!empty($newvs["ha"]) && 0 <= key($resources["storages"][$storage_uuids[$disk_spec["st_uuid"]]]["serids"])) {
                        $error[] = $l["inv_storage_ha"];
                    }
                    if($bus_driver) {
                        if(empty($disk_spec["bus_driver"]) && !empty($newvs["bus_driver"])) {
                            $disk_spec["bus_driver"] = $newvs["bus_driver"];
                        }
                        if(!array_key_exists($disk_spec["bus_driver"], $bus_driver)) {
                            $error[] = $l["inv_bus_driver"];
                        }
                        $disk_spec["bus_driver_num"] = (int) $disk_spec["bus_driver_num"];
                        $bus_driver_type = $disk_spec["bus_driver"] . $disk_spec["bus_driver_num"];
                        array_push($bus_driver_dupes, $bus_driver_type);
                    }
                    $selected_storage[$disk_spec["st_uuid"]] = $disk_spec["st_uuid"];
                }
                $newvs["space"] = array_values($newvs["space"]);
                if($bus_driver) {
                    foreach ($newvs["space"] as $nk => $nv) {
                        if(empty($nv["bus_driver"])) {
                            $newvs["space"][$nk]["bus_driver"] = "sata";
                        }
                    }
                    if(count($bus_driver_dupes) != count(array_count_values($bus_driver_dupes))) {
                        $error[] = $l["inv_bus_driver_num_format"];
                        return false;
                    }
                }
            } elseif(is_numeric($newvs["space"])) {
                if(2000 <= $newvs["space"] && empty($globals["disable_2tb_check"])) {
                    $error[] = $l["err_max_size"];
                }
                $tmp_space[0] = ["st_uuid" => $storages[$stid]["st_uuid"], "size" => (int) $newvs["space"]];
                if($bus_driver) {
                    $tmp_space[0]["bus_driver"] = "sata";
                    $tmp_space[0]["bus_driver_num"] = 0;
                    if(!empty($newvs["bus_driver"])) {
                        $tmp_space[0]["bus_driver"] = $newvs["bus_driver"];
                    }
                    if(!empty($newvs["bus_driver_num"])) {
                        $tmp_space[0]["bus_driver_num"] = $newvs["bus_driver_num"];
                    }
                }
                $newvs["space"] = $tmp_space;
            }
            if(count($newvs["space"]) < 1) {
                $error[] = $l["no_disk_space"];
            }
            if(1 < count($newvs["space"]) && !$kernel->features("multiple_disk_support", $req_virt)) {
                $error[] = $l["mul_storage"];
            }
            $disks = $newvs["space"];
            foreach ($disks as $k => $v) {
                $_stid = $storage_uuids[$v["st_uuid"]];
                $storage_type = $storages[$_stid]["type"];
                if(preg_match("/zfs/is", $storage_type)) {
                    if($v["size"] + 0 < 0) {
                    } else {
                        $dec_pos = strpos($v["size"], ".");
                        if($dec_pos++) {
                            $is_decimal = substr($v["size"], $dec_pos) + 0;
                            if(!empty($is_decimal)) {
                                $error[] = "Error in disk - " . $storages[$_stid]["name"];
                                $error[] = lang_vars_name($l["invalid_zfs_disk_size"], ["int_size" => (int) $v["size"], "decimal_size" => $v["size"]]);
                                return false;
                            }
                        }
                    }
                }
                $storage_format = $storages[$_stid]["format"];
                if($newvs["virt"] == "proxl" && preg_match("/qcow/is", $storage_format)) {
                    $error[] = $l["proxl_qcow_not_supported"];
                    return false;
                }
            }
            $total_space = 0;
            $space_required = [];
            foreach ($disks as $k => $v) {
                $space_required[$v["st_uuid"]] = $v["size"] + (int) $space_required[$v["st_uuid"]];
                $total_space += $v["size"];
            }
            $newvs["space"] = $total_space;
            foreach ($space_required as $kk => $_space) {
                if($_space < 1) {
                } elseif($storages[$storage_uuids[$kk]]["disk_space"] < $_space) {
                    $error[] = $l["less_space"];
                }
            }
            if(!empty($error)) {
                return false;
            }
            if(!isset($_POST["upload_speed"]) || strlen($_POST["upload_speed"]) < 1) {
                $newvs["upload_speed"] = -1;
            }
            if(empty($newvs["band_suspend"]) && (!empty($newvs["speed_cap_down"]) || !empty($newvs["speed_cap_up"]))) {
                validate_speed_cap($newvs["speed_cap_down"], $newvs["speed_cap_up"], $newvs["network_speed"], $newvs["upload_speed"]);
                $newvs["speed_cap"] = ["down" => $newvs["speed_cap_down"], "up" => $newvs["speed_cap_up"], "reason" => "", "bw" => 0];
            }
            if(!empty($error)) {
                return false;
            }
            if(isset($_POST["mgs"])) {
                $_POST["mgs"] = is_array($_POST["mgs"]) ? $_POST["mgs"] : [$_POST["mgs"]];
                foreach ($_POST["mgs"] as $k => $v) {
                    $v = (int) $v;
                    if(empty($mgs[$v]) || strpos($_virt, $mgs[$v]["mg_type"]) === false) {
                    } else {
                        $newvs["mg"][$v] = $v;
                    }
                }
            }
            if($kernel->features("vnc_key_map", $newvs["virt"])) {
                $newvs["vnc_keymap"] = optPOST("vnc_keymap");
                if(!empty($newvs["vnc_keymap"]) && !in_array($newvs["vnc_keymap"], ["en-us", "de-ch", "ar", "da", "et", "fo", "fr-be", "fr-ch", "hu", "it", "lt", "mk", "nl", "no", "pt", "ru", "sv", "tr", "de", "en-gb", "es", "fi", "fr", "fr-ca", "hr", "is", "ja", "lv", "nl-be", "pl", "pt-br", "sl", "th"])) {
                    $error[] = $l["inv_vnc_keymap"];
                }
            }
            if($kernel->features("mac_support", $newvs["virt"])) {
                $newvs["mac"] = optPOST("mac");
                $maclen = strlen($newvs["mac"]);
                if(!empty($maclen)) {
                    if(!valid_mac($newvs["mac"])) {
                        $error["mac"] = $l["err_mac"];
                    }
                    $newvs["mac_status"] = 1;
                }
            }
            if($kernel->features("cpu_pinning", $newvs["virt"]) && is_array($_POST["cpupin"]) && !empty($resources["cpucores"])) {
                $cores = [];
                foreach ($_POST["cpupin"] as $k => $v) {
                    $v = (int) $v;
                    if($v < 0 || $resources["cpucores"] <= $v) {
                    } else {
                        $cores[$v] = $v;
                    }
                }
                $newvs["cpupin"] = implode(",", $cores);
            }
            if($globals["ploop"] || $virt == "vzo") {
                $newvs["ploop"] = 1;
            }
            if($kernel->features("tun_tap", $virt)) {
                $newvs["tuntap"] = (int) optREQ("tuntap") ? 1 : 0;
            }
            if($kernel->features("virtio", $virt)) {
                if(!isset($_POST["virtio"]) && !empty($globals["enable_virtio"])) {
                    $_POST["virtio"] = 1;
                }
                $newvs["virtio"] = (int) optPOST("virtio");
            }
            if($kernel->features("openvz_features", $virt)) {
                $openvz_features["fuse"] = (int) optREQ("fuse");
                $openvz_features["ipip"] = (int) optREQ("ipip");
                $openvz_features["ipgre"] = (int) optREQ("ipgre");
                $openvz_features["nfs"] = (int) optREQ("nfs");
                $openvz_features["quotaugidlimit"] = (int) optREQ("quotaugidlimit");
                $openvz_features["iolimit"] = (int) optREQ("iolimit");
                $openvz_features["iopslimit"] = (int) optREQ("iopslimit");
                $openvz_features["netfilter"] = optPOST("netfilter");
                $newvs["openvz_features"] = serialize($openvz_features);
                $newvs["ppp"] = (int) optREQ("ppp") ? 1 : 0;
            }
            if($virt == "openvz" || $virt == "proxo") {
                $newvs["io"] = (int) POST("priority", $l["no_io"]);
                $newvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
                $newvs["burst"] = (int) POST("burst", $l["no_burst_ram"]);
                $newvs["cpu_percent"] = (int) POST("cpu_percent", $l["no_percent_cpu"]);
                $newvs["osid"] = (int) POST("osid", $l["no_os"]);
                $newvs["ploop"] = (int) optREQ("ploop") ? 1 : 0;
                if($newvs["burst"] == 0 && distro_check(1) && empty($error["burst"])) {
                    $error["no_burst_ram"] = $l["no_burst_ram"];
                }
                if(empty($newvs["osid"])) {
                    $error["no_os"] = $l["no_os"];
                } elseif(empty($ostemplates[$newvs["osid"]])) {
                    $error["invalid_os"] = $l["invalid_os"];
                }
            } elseif($virt == "xen" && empty($newvs["hvm"])) {
                $newvs["vnc"] = (int) optREQ("vnc") ? 1 : 0;
                $newvs["swap"] = (int) optPOST("swapram");
                $newvs["osid"] = (int) POST("osid", $l["no_os"]);
                $newvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
                $newvs["cpu_percent"] = (int) optPOST("cpu_percent");
                if(empty($dont_dd_os_temp)) {
                    if(empty($newvs["osid"])) {
                        $error["no_os"] = $l["no_os"];
                    } elseif(empty($ostemplates[$newvs["osid"]]) || !empty($ostemplates[$newvs["osid"]]["hvm"])) {
                        $error["invalid_os"] = $l["invalid_os"];
                    }
                }
                if(preg_match("/file/is", $storages[$storage_uuids[$disks[0]["st_uuid"]]]["type"])) {
                    $error[] = $l["xen_pv_file_support"];
                }
            } elseif($virt == "xen" && !empty($newvs["hvm"]) || $virt == "kvm" || $virt == "xcp" || $virt == "proxk") {
                $newvs["vnc"] = (int) optREQ("vnc") ? 1 : 0;
                $newvs["swap"] = (int) optPOST("swapram");
                $newvs["acpi"] = 1;
                $newvs["apic"] = 1;
                $newvs["pae"] = isset($_REQUEST["pae"]) ? $_REQUEST["pae"] : 1;
                if((int) $disks[0]["size"] * 1024 <= $newvs["swap"]) {
                    $error[] = $l["err_swapsize"];
                }
                $newvs["cpu_percent"] = (int) optPOST("cpu_percent");
                $newvs["iso"] = optPOST("iso");
                if(pathinfo($newvs["iso"], PATHINFO_EXTENSION) == "iso") {
                    foreach ($isos as $iok => $iov) {
                        if($iov["filename"] == $newvs["iso"]) {
                            $newvs["iso"] = $iok;
                        }
                    }
                }
                if(empty($isos[$newvs["iso"]])) {
                    $newvs["iso"] = "";
                }
                $newvs["boot"] = !empty($newvs["iso"]) ? "dca" : "cda";
                $boot = optPOST("boot");
                if(!empty($boot)) {
                    $newvs["boot"] = $boot;
                }
                $newvs["osid"] = (int) optPOST("osid");
                if(!empty($newvs["osid"]) && empty($dont_dd_os_temp)) {
                    if($virt == "xen" && ($ostemplates[$newvs["osid"]]["type"] != "xen" || empty($ostemplates[$newvs["osid"]]["hvm"]))) {
                        $error["invalid_os"] = $l["invalid_os"];
                    } elseif($virt == "kvm" && $ostemplates[$newvs["osid"]]["type"] != "kvm" || $virt == "proxk" && $ostemplates[$newvs["osid"]]["type"] != "proxk") {
                        $error["invalid_os"] = $l["invalid_os"];
                    }
                }
                if(empty($newvs["iso"]) && empty($newvs["osid"])) {
                    $error["no_os"] = $l["no_os"];
                }
                if($virt == "kvm" || $virt == "proxk") {
                    $newvs["cpu"] = (int) optPOST("cpu");
                    if($kernel->features("kvm_cache", $virt)) {
                        $newvs["kvm_cache"] = optPOST("kvm_cache");
                        if(!empty($newvs["kvm_cache"]) && !in_array($newvs["kvm_cache"], ["default", "writeback", "writethrough", "directsync"])) {
                            $error[] = $l["inv_kvm_cache"];
                        }
                    }
                    if($kernel->features("io_mode", $virt)) {
                        $newvs["io_mode"] = optPOST("io_mode");
                        if(!empty($newvs["io_mode"]) && !in_array($newvs["io_mode"], ["native", "threads", "io_uring"])) {
                            $error[] = $l["inv_io_mode"];
                        }
                        if(!empty($newvs["io_mode"]) && preg_match("/" . $newvs["io_mode"] . "/is", "io_uring") && !$cluster->check_iouring($globals["server"])) {
                            $error[] = $l["inv_io_uring"];
                        }
                    }
                    if($kernel->features("iops_sec", $virt)) {
                        $newvs["total_iops_sec"] = (int) optPOST("total_iops_sec");
                        $newvs["read_bytes_sec"] = (int) optPOST("read_bytes_sec");
                        $newvs["write_bytes_sec"] = (int) optPOST("write_bytes_sec");
                    }
                    $newvs["kvm_vga"] = (int) optREQ("kvm_vga") ? 1 : 0;
                    $newvs["acceleration"] = 0;
                    if(!empty($newvs["kvm_vga"])) {
                        $newvs["acceleration"] = (int) optREQ("acceleration") ? 1 : 0;
                    }
                    if($virt == "proxk" && in_array($newvs["cpu_mode"], ["host-model", "host-passthrough"])) {
                        $newvs["cpu_mode"] = "host";
                    }
                    if(!empty($newvs["cpu_mode"]) && empty($cpu_modes[$newvs["cpu_mode"]])) {
                        $error[] = $l["inv_cpu_mode"];
                        return false;
                    }
                    if(4 <= count($disks) && (!empty($newvs["sec_iso"]) || !empty($newvs["iso"])) && empty($newvs["virtio"])) {
                        $error[] = $l["kvm_ide_limit"];
                    }
                } elseif($virt == "xcp") {
                    $newvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
                } else {
                    $newvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
                    $newvs["shadow"] = (int) POST("shadow", $l["no_shadow"]);
                }
                if($kernel->features("cpu_topology", $_virt)) {
                    $newvs["topology_sockets"] = (int) optPOST("topology_sockets");
                    $newvs["topology_cores"] = (int) optPOST("topology_cores");
                    $newvs["topology_threads"] = (int) optPOST("topology_threads");
                    if(!empty($newvs["topology_sockets"]) || !empty($newvs["topology_cores"]) || !empty($newvs["topology_threads"])) {
                        if(!$kernel->features("cpu_threads", $virt)) {
                            $newvs["topology_threads"] = 1;
                        }
                        if(empty($newvs["topology_sockets"]) || empty($newvs["topology_cores"]) || empty($newvs["topology_threads"])) {
                            $error[] = $l["inv_topology"];
                            return false;
                        }
                        $vcpus = $newvs["topology_sockets"] * $newvs["topology_cores"] * $newvs["topology_threads"];
                        if($newvs["cores"] != $vcpus) {
                            $error[] = $l["err_topology_calc"];
                            return false;
                        }
                    }
                }
                if($kernel->features("numa", $_virt)) {
                    $newvs["numa"] = (int) optPOST("numa");
                }
                if($virt == "xen" && !empty($newvs["hvm"])) {
                    $newvs["pv_on_hvm"] = (int) (isset($_POST["pv_on_hvm"]) ? (int) optREQ("pv_on_hvm") ? 1 : 0 : (!empty($globals["pv_on_hvm"]) ? 1 : ""));
                }
            } elseif($virt == "lxc" || $virt == "proxl") {
                $newvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
                $newvs["osid"] = (int) POST("osid", $l["no_os"]);
                $newvs["swap"] = (int) POST("swapram", $l["no_swap_ram"]);
                if($virt == "proxl") {
                    $newvs["cpu_percent"] = (int) POST("cpu_percent", $l["no_percent_cpu"]);
                }
                if(empty($dont_dd_os_temp) || $virt == "proxl") {
                    if(empty($newvs["osid"])) {
                        $error["no_os"] = $l["no_os"];
                    } elseif(empty($ostemplates[$newvs["osid"]])) {
                        $error["invalid_os"] = $l["invalid_os"];
                    }
                }
                if($resources["cpucores"] < $newvs["cores"]) {
                    $error[] = $l["err_cores_more"] . $resources["cpucores"];
                }
                if(preg_match("/file/is", $storages[$storage_uuids[$disks[0]["st_uuid"]]]["type"]) && $virt != "proxl") {
                    $error[] = $l["lxc_file_support"];
                }
            } elseif($virt == "vzk" || $virt == "vzo") {
                $newvs["io"] = (int) POST("priority", $l["no_io"]);
                $newvs["cpu"] = (int) POST("cpu", $l["no_cpu_units"]);
                if(empty($newvs["cpu"])) {
                    $error[] = $l["no_cpu_units"];
                }
                $newvs["swap"] = (int) optPOST("swapram");
                $newvs["cpu_percent"] = (int) POST("cpu_percent", $l["no_percent_cpu"]);
                $newvs["vnc"] = (int) (optREQ("vnc") ? 1 : 0);
                if($virt == "vzk") {
                    $newvs["osid"] = (int) optPOST("osid");
                    $newvs["iso"] = optPOST("iso");
                    if(pathinfo($newvs["iso"], PATHINFO_EXTENSION) == "iso") {
                        foreach ($isos as $iok => $iov) {
                            if($iov["filename"] == $newvs["iso"]) {
                                $newvs["iso"] = $iok;
                            }
                        }
                    }
                    if(empty($newvs["iso"]) && empty($newvs["osid"])) {
                        $error["no_os"] = $l["no_os"];
                    }
                    $newvs["boot"] = !empty($newvs["iso"]) ? "dca" : "cda";
                    $boot = optPOST("boot");
                    if(!empty($boot)) {
                        $newvs["boot"] = $boot;
                    }
                } elseif($virt == "vzo") {
                    $newvs["osid"] = (int) POST("osid", $l["no_os"]);
                    $newvs["tuntap"] = (int) optREQ("tuntap") ? 1 : 0;
                    $newvs["ppp"] = (int) optREQ("ppp") ? 1 : 0;
                }
                if($resources["cpucores"] < $newvs["cores"]) {
                    $error[] = $l["err_cores_more"] . $resources["cpucores"];
                }
                if((int) $disks[0]["size"] * 1024 <= $newvs["swap"]) {
                    $error[] = $l["err_swapsize"];
                }
            }
            if(!empty($newvs["osid"])) {
                $ostemplate_size = $ostemplates[$newvs["osid"]]["size"] / 1024 / 1024;
                $vps_size = $disks[0]["size"] * 1024;
                if(!empty($newvs["swap"])) {
                    $vps_size = $vps_size - $newvs["swap"];
                }
                if($vps_size < $ostemplate_size) {
                    $error[] = $l["err_disksize"];
                }
            }
            if($kernel->features("sec_iso_support", $_virt)) {
                if(pathinfo($newvs["sec_iso"], PATHINFO_EXTENSION) == "iso") {
                    foreach ($isos as $iok => $iov) {
                        if($iov["filename"] == $newvs["sec_iso"]) {
                            $newvs["sec_iso"] = $iok;
                        }
                    }
                }
                if(empty($isos[$newvs["sec_iso"]])) {
                    $newvs["sec_iso"] = "";
                }
            }
            $newvs["disable_ebtables"] = (int) optREQ("disable_ebtables") ? 1 : 0;
            if(!empty($iscripts[$newvs["webuzo"]])) {
                if($ostemplates[$newvs["osid"]]["distro"] != "webuzo") {
                    $error[] = $l["no_webuzo_template"];
                }
            } else {
                $newvs["webuzo"] = 0;
            }
            if($kernel->features("vnc_support", $virt) && !empty($newvs["vnc"])) {
                $newvs["vncpass"] = optPOST("vncpass");
                if(empty($newvs["vncpass"])) {
                    $newvs["vncpass"] = generateRandStr($kernel->features("vncpasslen", $virt));
                }
                if(!empty($newvs["vncpass"])) {
                    if(preg_match("/[^A-Za-z0-9]/is", $newvs["vncpass"])) {
                        $error[] = $l["no_nonalphanumeric"];
                        return false;
                    }
                    if($kernel->features("vncpasslen", $_virt) < strlen($newvs["vncpass"])) {
                        $error[] = $l["vncpass_too_long"];
                        return false;
                    }
                }
            }
            if((empty($resources["overcommit"]) ? $resources["ram"] : $resources["overcommit"] - $servers[$globals["server"]]["alloc_ram"]) < $newvs["ram"]) {
                $error[] = $l["less_ram"];
            }
            $newvs["pass"] = rawGPC($_POST["rootpass"]);
            if(stripos($ostemplates[$newvs["osid"]]["name"], "windows") !== false) {
                $allowed_chars = "!@#\$%^&*_-+=?";
                if(preg_match("/[^a-zA-Z0-9" . preg_quote($allowed_chars) . "]/is", $newvs["pass"])) {
                    $error["inv_winpass_chars"] = $l["inv_winpass_chars"] . " ! @ # \$ % ^ & * _ - + = ?";
                }
                $pass_score = win_pass_score($newvs["pass"]);
                if($pass_score < 3) {
                    $error["weak_pass"] = $l["weak_pass"];
                }
            }
            if(!empty($globals["pass_strength"]) && !empty($newvs["pass"])) {
                $pass_strength = pass_strength($newvs["pass"]);
                if($pass_strength < $globals["pass_strength"]) {
                    $error[] = $l["pass_strength_error"] . $globals["pass_strength"];
                }
            }
            if(!empty($error)) {
                return false;
            }
            $hvm_pass = "";
            if(($virt == "xcp" || $virt == "xen") && $hvm == 1 || $virt == "kvm" || $virt == "proxk") {
                $hvm_pass = $ostemplates[$newvs["osid"]]["hvm_pass"];
                if(isset($hvm_pass)) {
                    $newvs["pass"] = $hvm_pass;
                }
            }
            $nic_type = optPOST("nic_type");
            if(!empty($nic_type)) {
                $newvs["nic_type"] = $nic_type;
            }
            $vif_type = optPOST("vif_type");
            if(!empty($vif_type)) {
                $newvs["vif_type"] = $vif_type;
            }
            if(!numvs($globals["server"])) {
                $error["err_numvs"] = $l["err_numvs"];
                return false;
            }
            $val = $cluster->config_get($globals["server"]);
            if(!empty($val["globals"]["vpslimit"])) {
                $qres = makequery("SELECT *\tFROM `vps`\n\t\t\t\t\t\t\t\tWHERE serid = :server", [":server" => $globals["server"]]);
                if($val["globals"]["vpslimit"] <= vsql_num_rows($qres)) {
                    $error["err_vpslimit"] = $l["err_vpslimit"];
                    return false;
                }
            }
            if($kernel->features("enable_guest_agent", $virt)) {
                $newvs["enable_guest_agent"] = empty($val["globals"]["disable_guest_agent"]) ? 1 : 0;
            }
            $bios = $kernel->features("bios", $virt);
            if(!empty($bios)) {
                $newvs["bios"] = optREQ("bios");
                if(empty($newvs["bios"])) {
                    $newvs["bios"] = "seabios";
                }
                if(!in_array($newvs["bios"], array_keys($bios))) {
                    $error[] = $l["err_invalid_bios"];
                    return false;
                }
                if(preg_match("/uefi/is", $newvs["bios"])) {
                    $newvs["enable_tpm"] = optREQ("enable_tpm");
                }
                if(preg_match("/" . $virt . "/", "kvm")) {
                    if(preg_match("/uefi/is", $newvs["bios"]) && empty($val["globals"]["secure_efi_path"])) {
                        $error[] = $l["uefi_path_not_found"];
                        return false;
                    }
                    if(preg_match("/uefi/is", $newvs["bios"]) && !empty($newvs["enable_tpm"]) && empty($resources["is_swtpm_installed"])) {
                        $error[] = $l["swtpm_not_found"];
                        return false;
                    }
                }
                if(!empty($newvs["bios"]) && preg_match("/uefi/is", $newvs["bios"]) && empty($newvs["virtio"])) {
                    $error[] = $l["err_ide_not_support"];
                    return false;
                }
            }
            if(!empty($val["globals"]["vcores"])) {
                $res = makequery("SELECT SUM(cores) as used_cores FROM vps WHERE serid = :serid", [":serid" => $globals["server"]]);
                $row = vsql_fetch_assoc($res);
                if($val["globals"]["vcores"] < $row["used_cores"] + $newvs["cores"]) {
                    $error["err_vcores"] = $l["err_vcores"];
                }
                if(!isset($row["used_cores"]) && $val["globals"]["vcores"] < $newvs["cores"]) {
                    $error["err_vcores"] = $l["err_vcores"];
                }
            }
            if(0 < $newvs["uid"]) {
                $qres = makequery("SELECT *\tFROM `users`\n\t\t\t\t\t\t\tWHERE uid = :uid", [":uid" => $newvs["uid"]]);
                if(vsql_num_rows($qres) < 1) {
                    $error["invalid_uid"] = $l["invalid_uid"];
                    return false;
                }
                $tmp = vsql_fetch_assoc($qres);
                $user_email = $tmp["email"];
            } else {
                $user_email = optPOST("user_email");
                $user_pass = optPOST("user_pass");
                $prefs["fname"] = optPOST("fname");
                $prefs["lname"] = optPOST("lname");
                $dnsplid = (int) optPOST("dnsplid");
                $preferences = serialize($prefs);
                if(empty($user_email)) {
                    $error["no_user"] = $l["no_user"];
                }
                if(empty($user_pass)) {
                    $error["no_user_pass"] = $l["no_user_pass"];
                }
                if(!empty($error)) {
                    return false;
                }
                if(!emailvalidation($user_email)) {
                    $error["invalid_email"] = $l["invalid_email"];
                    return false;
                }
                $qres = makequery("SELECT email\n\t\t\t\t\t\t\tFROM users\n\t\t\t\t\t\t\tWHERE email = :email", [":email" => $user_email]);
                if(0 < vsql_num_rows($qres)) {
                    $error[] = $l["emailexist"];
                    return false;
                }
            }
            if(preg_match("/[^A-Za-z0-9_\\-\\.]/is", $newvs["hostname"])) {
                $error[] = $l["invalid_hostname"];
                return false;
            }
            $_ips_cnt = optPOST("num_ips");
            $server_name = $servers[$globals["server"]]["server_name"];
            if(0 < $_ips_cnt && empty($_POST["ips"][0])) {
                $_POST["ips"] = [];
                if(count($ips) < $_ips_cnt) {
                    $error[] = $server_name . " : " . $l["no_ipv4"];
                }
                $i = 0;
                foreach ($ips as $k => $v) {
                    $_POST["ips"][] = $v["ip"];
                    $i++;
                    if($i == $_ips_cnt) {
                    }
                }
            }
            $_ips_int_cnt = optPOST("num_ips_int");
            if(0 < $_ips_int_cnt && empty($_POST["ips_int"][0])) {
                $_POST["ips_int"] = [];
                if(count($ips_int) < $_ips_int_cnt) {
                    $error[] = $server_name . " : " . $l["no_int_ips"];
                }
                $i = 0;
                foreach ($ips_int as $k => $v) {
                    $_POST["ips_int"][] = $v["ip"];
                    $i++;
                    if($i == $_ips_int_cnt) {
                    }
                }
            }
            $_ips6_cnt = optPOST("num_ips6");
            $_ips6_subnet_cnt = optPOST("num_ips6_subnet");
            if(!empty($_POST["ips"][0]) && (0 < $_ips6_cnt || 0 < $_ips6_subnet_cnt)) {
                $selected_ipv4 = $_POST["ips"][0];
                $selected_vlan_ipv6 = 0;
                foreach ($ips as $k => $v) {
                    if(preg_match("/" . $v["ip"] . "/is", $selected_ipv4) && !empty($v["vlan"]) && !empty($v["bridge"])) {
                        $res = makequery("SELECT * FROM ippool where \n\t\t\t\t\t\t\t\t\t(ippid IN (" . (count($is_ipv6_pool) < 1 ? -2 : $ipv6_ippid_token["query"]) . ")\n\t\t\t\t\t\t\t\t\tOR (ippid = 0 AND ipp_serid IN (-1, :serid))) \n\t\t\t\t\t\t\t\t\tAnd ipv6 = 1 \n\t\t\t\t\t\t\t\t\tAnd vlan = 1 \n\t\t\t\t\t\t\t\t\tAnd bridge = :bridge", array_merge($ipv6_ippid_token["tokens"], [":serid" => $globals["server"], ":bridge" => $v["bridge"]]));
                        $i = 1;
                        if($i <= vsql_num_rows($res)) {
                        } else {
                            $row = vsql_fetch_assoc($res);
                            $sel_ippid[] = $row["ippid"];
                        }
                        if(!empty($sel_ippid[0]) && in_array($sel_ippid[0], $is_ipv6_pool)) {
                            $selected_vlan_ipv6 = $sel_ippid[0];
                            if(current($ips6)["ippid"] != $sel_ippid[0]) {
                                $ippid_unset = array_search($sel_ippid[0], $is_ipv6_pool);
                                if($ippid_unset != "") {
                                    unset($is_ipv6_pool[$ippid_unset]);
                                }
                                array_unshift($is_ipv6_pool, $sel_ippid[0]);
                                $data_ips = get_free_ips($globals["server"], $is_ipv6_pool, [], ["ipv6", "ipv6_sub"]);
                                if(!empty($data_ips["ips6"]) && 0 < $_ips6_cnt && $_ips6_cnt <= count($data_ips["ips6"])) {
                                    $ips6 = $data_ips["ips6"];
                                } elseif(!empty($data_ips["ips6_subnet"]) && 0 < $_ips6_subnet_cnt && $_ips6_cnt <= count($data_ips["ips6_subnet"])) {
                                    $ips6_subnet = $data_ips["ips6_subnet"];
                                }
                            }
                        }
                    }
                }
            }
            if(0 < $_ips6_cnt) {
                $_POST["ipv6"] = [];
                if(count($ips6) < $_ips6_cnt) {
                    $error[] = $server_name . " : " . $l["no_ipv6"];
                }
                $i = 0;
                foreach ($ips6 as $k => $v) {
                    if(!empty($selected_vlan_ipv6) && $selected_vlan_ipv6 == $v["ippid"]) {
                        $_POST["ipv6"][] = $v["ip"];
                    } else {
                        $_POST["ipv6"][] = $v["ip"];
                    }
                    $i++;
                    if($i == $_ips6_cnt) {
                    }
                }
            }
            $_ips6_subnet_cnt = optPOST("num_ips6_subnet");
            $ipv6_subnet_w_prefix = [];
            if(0 < $_ips6_subnet_cnt) {
                $_POST["ipv6_subnet"] = [];
                if(count($ips6_subnet) < $_ips6_subnet_cnt) {
                    $error[] = $server_name . " : " . $l["no_ipv6_subnet"];
                }
                $i = 0;
                foreach ($ips6_subnet as $k => $v) {
                    if(!empty($selected_vlan_ipv6) && $selected_vlan_ipv6 == $v["ippid"]) {
                        $_POST["ipv6_subnet"][] = $v["ip"];
                        $ipv6_subnet_w_prefix[] = $v["ip"] . "/" . $v["ipr_netmask"];
                    } else {
                        $_POST["ipv6_subnet"][] = $v["ip"];
                        $ipv6_subnet_w_prefix[] = $v["ip"] . "/" . $v["ipr_netmask"];
                    }
                    $i++;
                    if($i == $_ips6_subnet_cnt) {
                    }
                }
            }
            if(!empty($error)) {
                return false;
            }
            $lockedIPs = [];
            $lockipsused = [];
            $res = makequery("SELECT * FROM ips WHERE locked=1");
            for ($i = 0; $i < vsql_num_rows($res); $i++) {
                $row = vsql_fetch_assoc($res);
                $lockedIPs[] = $row["ip"];
            }
            $pips = [];
            $_POST["ips"] = !is_array($_POST["ips"]) ? [] : $_POST["ips"];
            $invalid = [];
            foreach ($_POST["ips"] as $value) {
                if(empty($value)) {
                } else {
                    if(!valid_ip($value)) {
                        $invalid[] = $value;
                    }
                    $pips[] = $value;
                }
            }
            foreach ($_POST["ips"] as $k => $v) {
                if(in_array($_POST["ips"][$k], $lockedIPs)) {
                    $lockipsused[] = $_POST["ips"][$k];
                }
            }
            if(!empty($globals["max_ipv4s"]) && $globals["max_ipv4s"] < count($pips)) {
                $error["max_ipv4s"] = $l["err_max_ipv4s"] . $globals["max_ipv4s"];
                return false;
            }
            $pips6 = [];
            if(isset($_POST["ipv6"]) && 0 < @count($_POST["ipv6"])) {
                $pips6 = $_POST["ipv6"];
                foreach ($pips6 as $value) {
                    if(!valid_ipv6($value)) {
                        $invalid[] = $value;
                    }
                }
                foreach ($_POST["ipv6"] as $k => $v) {
                    if(in_array($_POST["ipv6"][$k], $lockedIPs)) {
                        $lockipsused[] = $_POST["ipv6"][$k];
                    }
                }
            }
            if(!empty($globals["max_ipv6s"]) && $globals["max_ipv6s"] < count($pips6)) {
                $error["max_ipv6s"] = $l["err_max_ipv6s"] . $globals["max_ipv6s"];
                return false;
            }
            $pips_int = [];
            if(!empty($ips_int)) {
                foreach ($ips_int as $kk => $vv) {
                    $_ips_int[$kk] = $vv["ip"];
                }
                $_POST["ips_int"] = !is_array($_POST["ips_int"]) ? [] : $_POST["ips_int"];
                foreach ($_POST["ips_int"] as $value) {
                    if(empty($value)) {
                    } else {
                        if(!valid_ip($value) || !in_array($value, $_ips_int)) {
                            $invalid[] = $value;
                        }
                        $pips_int[] = $value;
                    }
                }
                foreach ($_POST["ips_int"] as $k => $v) {
                    if(in_array($_POST["ips_int"][$k], $lockedIPs)) {
                        $lockipsused[] = $_POST["ips_int"][$k];
                    }
                }
            }
            if(!empty($globals["max_internal_ips"]) && $globals["max_internal_ips"] < count($pips_int)) {
                $error["max_internal_ips"] = $l["err_max_internal_ips"] . $globals["max_internal_ips"];
                return false;
            }
            if(!empty($invalid)) {
                $error["invalid_ip"] = $l["invalid_ip"] . "<br />" . implode(", ", $invalid);
                return false;
            }
            $pips6_subnet = [];
            if(isset($_POST["ipv6_subnet"]) && 0 < @count($_POST["ipv6_subnet"])) {
                $pips6_subnet = $_POST["ipv6_subnet"];
                foreach ($pips6_subnet as $value) {
                    if(!valid_ipv6($value)) {
                        $invalid[] = $value;
                    }
                }
                foreach ($_POST["ipv6_subnet"] as $k => $v) {
                    if(in_array($_POST["ipv6_subnet"][$k], $lockedIPs)) {
                        $lockipsused[] = $_POST["ipv6_subnet"][$k];
                    }
                }
            }
            if(!empty($globals["max_ipv6_subnets"]) && $globals["max_ipv6_subnets"] < count($pips6_subnet)) {
                $error["max_ipv6_subnets"] = $l["err_max_ipv6_subnets"] . $globals["max_ipv6_subnets"];
                return false;
            }
            if(!empty($invalid)) {
                $error["invalid_ip_subnet"] = $l["invalid_ip_subnet"] . "<br />" . implode(", ", $invalid);
                return false;
            }
            if(!empty($lockipsused)) {
                $error["locked_ips"] = $l["lockedips"] . ":<br />" . implode(", ", $lockipsused);
                return false;
            }
            if(empty($pips[0]) && empty($pips6) && empty($pips6_subnet) && empty($pips_int)) {
                $error["no_ip"] = $l["no_ip"];
                return false;
            }
            $ippid_chk = vsql_in_tokens($ippid);
            $sel_query = "";
            $sel_token = [];
            if(!empty($pips_int)) {
                $ippid_chk = vsql_in_tokens(array_merge($ippid, $is_internal_pool));
                $sel_query = " AND ip.ippid IN (0, " . $ippid_chk["query"] . ")";
                $sel_token = $ippid_chk["tokens"];
            }
            $qres = makequery("SELECT i.*, ip.* FROM `ips` i\n\t\t\t\t\tLEFT JOIN ippool ip ON (ip.ippid = i.ippid) \n\t\t\t\t\tWHERE i.ip IN('" . implode("','", array_merge($pips, $pips6, $pips6_subnet, $pips_int)) . "')" . $sel_query . "\n\t\t\t\t\tORDER BY `primary` DESC", $sel_token);
            $usedips = [];
            $unusedip = [];
            for ($i = 1; $i <= vsql_num_rows($qres); $i++) {
                $dnsip[$i] = $row = vsql_fetch_assoc($qres);
                if(empty($row["vpsid"])) {
                    $unusedip[] = $row["ip"];
                } elseif(!empty($row["ipr_netmask"])) {
                    $used_subnets[] = $row["ip"];
                } else {
                    $usedips[] = $row["ip"];
                }
            }
            if(!empty($usedips)) {
                $error["used_ip"] = $l["used_ip"] . "<br />" . implode(", ", $usedips);
                return false;
            }
            if(!empty($used_subnets)) {
                $error["used_ip_subnet"] = $l["used_ip_subnet"] . "<br />" . implode(", ", $used_subnets);
                return false;
            }
            $dns = $_POST["dns"];
            $_dns = [];
            if(!empty($dns[0])) {
                foreach ($dns as $key => $value) {
                    if(!empty($value) && (valid_ip($value) || valid_ipv6($value))) {
                        $_dns[] = $value;
                    }
                }
            }
            $newvs["vps_name"] = new_vps_name($virt);
            $newvs["vps_name"] = $cluster->check_vps_data($globals["server"], $newvs);
            $res = makequery("INSERT INTO vps_name \n\t\t\t\tSET vpsname = :vpsname,\n\t\t\t\tvirt = :virt,\n\t\t\t\tserid= :serid,\n\t\t\t\ttime = :time", [":vpsname" => $newvs["vps_name"], ":virt" => $virt, ":serid" => $globals["server"], ":time" => time()]);
            if(!empty($error)) {
                return false;
            }
            if(!empty($newvs["plid"])) {
                $newvs["ubc"] = $plans[$newvs["plid"]]["ubc"];
            } else {
                $newvs["ubc"] = "";
            }
            $fields = ["ram" => "gram", "space" => "hdd", "burst" => "bram", "swap" => "swap", "cores" => "cores", "cpu" => "cpunit", "cpu_percent" => "percent", "network_speed" => "network_speed", "upload_speed" => "upload_speed", "enable_cpu_threshold" => "enable_cpu_threshold", "cpu_threshold" => "cpu_threshold", "cpu_threshold_time" => "cpu_threshold_time"];
            foreach ($fields as $field_k => $field_v) {
                if($newvs[$field_k] == -1 && in_array($field_k, ["upload_speed"])) {
                } elseif(!empty($newvs[$field_k]) && $newvs[$field_k] < 0) {
                    $error[] = $l["err_negative_val"] . " : " . $l[$field_v] . " (" . $newvs[$field_k] . ")";
                }
            }
            if(!empty($error)) {
                return false;
            }
            if(empty($newvs["uid"])) {
                $newvs["uid"] = insert_and_id("INSERT INTO users\n\t\t\t\t\t\t\tSET\ttype = '0',\n\t\t\t\t\t\t\tpassword = :password,\n\t\t\t\t\t\t\temail = :email,\n\t\t\t\t\t\t\tpreferences = :preferences,\n\t\t\t\t\t\t\tdnsplid = :dnsplid", [":password" => crypt($user_pass), ":email" => $user_email, ":preferences" => $preferences, ":dnsplid" => empty($dnsplid) ? 0 : $dnsplid]);
                if(empty($newvs["uid"])) {
                    $error["err_user"] = $l["err_user"];
                    return false;
                }
                logs_admin("adduser", $user_email, 1, $newvs["uid"], $user["uid"]);
            }
            $install_script = 0;
            if(!empty($_POST["webuzo_pd"]) || !empty($_POST["webuzo_spasswd"])) {
                $webzuo_data["webuzo_os"] = (int) POST("webuzo_os", $l["webuzo_os_err"]);
                if(!empty($error)) {
                    return false;
                }
                $install_script = 1;
            }
            if(!empty($install_script)) {
                $valid_stacks = ["lamp", "lemp", "llmp"];
                $webzuo_data["spasswd"] = POST("webuzo_spasswd", $l["webuzo_spasswd_err"]);
                $webzuo_data["domain"] = POST("webuzo_pd", $l["webuzo_pd_err"]);
                $webzuo_data["script"] = (int) optREQ("webuzo_script");
                $webzuo_data["webuzo_stack"] = POST("webuzo_stack", $l["webuzo_stack_err"]);
                $webzuo_data["webuzo_os"] = (int) POST("webuzo_os", $l["webuzo_os_err"]);
                $webzuo_data["webserver"] = optREQ("webserver");
                if(!empty($globals["noc_apikey"]) && !empty($globals["noc_apipass"]) && !empty($globals["premium_apps"]) && (!empty($plans[$newvs["plid"]]) && !empty($plans[$newvs["plid"]]["webuzo_data"]) || isset($_POST["mysql"]) && isset($_POST["php"]))) {
                    $webzuo_data["mysql"] = POST("mysql", $l["mysql_err"]);
                    $webzuo_data["php"] = POST("php", $l["php_err"]);
                }
                $webzuo_data["ns1"] = optREQ("webuzo_ns1");
                $ns1 = $webzuo_data["ns1"];
                $webzuo_data["ns2"] = optREQ("webuzo_ns2");
                $ns2 = $webzuo_data["ns2"];
                $pass_strength = pass_strength($webzuo_data["spasswd"]);
                if($pass_strength < $globals["pass_strength"]) {
                    $error[] = $l["pass_strength_error"] . $globals["pass_strength"];
                }
                if(!empty($error)) {
                    return NULL;
                }
                $domain = $webzuo_data["domain"];
                if(!is_valid_domain_name($webzuo_data["domain"])) {
                    $error[] = $l["webuzo_pd_err"];
                }
                if(!empty($webzuo_data["webuzo_stack"]) && !in_array($webzuo_data["webuzo_stack"], $valid_stacks) || empty($webzuo_data["webserver"]) && empty($globals["noc_apikey"]) && empty($globals["noc_apipass"]) || $webzuo_data["webuzo_stack"] == "lamp" && (!isset($webzuo_data["webserver"]) || !in_array($webzuo_data["webserver"], ["apache", "apache2"]))) {
                    $webzuo_data["webserver"] = "apache";
                }
                if(!empty($webzuo_data["script"]) && (!in_array($webzuo_data["script"], $iscripts_allowed) || !array_key_exists($webzuo_data["script"], $iscripts))) {
                    $error[] = $l["webuzo_script_err"];
                }
                if(!array_key_exists($webzuo_data["webuzo_os"], $webuzo_templates)) {
                    $error[] = $l["webuzo_os_invalid"];
                }
                if(!empty($error)) {
                    return NULL;
                }
                if($webzuo_data["webuzo_stack"] === "lemp") {
                    $webzuo_data["webserver"] = "nginx";
                }
                if($webzuo_data["webuzo_stack"] === "llmp") {
                    $webzuo_data["webserver"] = "lighttpd";
                }
                $webzuo_data["admin_email"] = "admin@" . $domain;
                $webzuo_data["admin_username"] = "admin";
                $webzuo_data["admin_pass"] = generateRandPwd(13);
                $webzuo_data["rpass"] = $webzuo_data["spasswd"];
                $webzuo_data["uname"] = "admin";
                $webzuo_data["email"] = $users[$newvs["uid"]]["email"];
                $webzuo_data["script_name"] = $scripts[$webzuo_data["script"]]["fullname"];
                $webzuo_data["_virt"] = $newvs["virt"];
                $webzuo_data["from_addvs"] = 1;
                $os_template = $webuzo_templates[$webzuo_data["webuzo_os"]]["filename"];
                if(!empty($_dns[0])) {
                    $tmp_dns[] = $_dns[0];
                }
                if(!empty($_dns[1])) {
                    $tmp_dns[] = $_dns[1];
                }
                $_dns = [];
                $_dns = $tmp_dns;
                $webzuo_data["osid"] = $webzuo_data["webuzo_os"];
                $newvs["osid"] = $webzuo_data["osid"];
                $webzuo_data["os_name"] = $os_template;
                $newvs["os_name"] = $webzuo_data["os_name"];
                $newvs["boot"] = "cda";
            }
            $control_panel = optPOST("control_panel");
            if(!empty($control_panel) && $control_panel != "none") {
                if(empty($newvs["osid"]) && !empty($newvs["iso"])) {
                    $error[] = $l["cpan_iso"];
                    return false;
                }
                if(!in_array($control_panel, ["cpanel", "webuzo", "directadmin", "plesk", "interworx", "kloxo", "webmin", "ispconfig", "cwp", "vesta"])) {
                    $error[] = $l["cpan_wrong_panel"];
                    return false;
                }
                $json = file_get_contents($globals["path"] . "/cp_supported_os.json");
                $vars = json_decode($json, true);
                $currentos = strtolower($ostemplates[$newvs["osid"]]["name"]);
                $available = [];
                if(!empty($json) && is_array($vars)) {
                    foreach ($vars[$control_panel] as $k => $os) {
                        if(strpos($os, "|") !== false && preg_match_all("/" . $os . "/", $currentos, $matches)) {
                            if(1 < count($matches[0])) {
                                $available[] = $control_panel;
                            }
                        } elseif(preg_match("/" . $os . "/", $currentos)) {
                            $available[] = $control_panel;
                        }
                    }
                }
                if(!in_array($control_panel, $available)) {
                    $error[] = ucfirst($control_panel) . " " . $l["cpan_wrong_os"] . ucfirst($currentos);
                    return false;
                }
                $parts = count(preg_split("/[.]/", $newvs["hostname"]));
                if($parts < 3) {
                    $error[] = $l["invalid_hostname"];
                    return false;
                }
                if(!strcmp($domain, $newvs["hostname"]) && !strcmp($control_panel, "webuzo")) {
                    $parts = preg_split("/[.]/", $newvs["hostname"]);
                    $parts[1] = "soft_" . $parts[1];
                    $newvs["hostname"] = implode(".", $parts);
                }
            }
            if($kernel->features("boot_order", $newvs["virt"])) {
                $bootorder = optPOST("bootord");
                if(!empty($bootorder)) {
                    $order = cexplode(",", $bootorder);
                    if(!empty($order) && is_array($order)) {
                        $valid_order = preg_grep("/disk\\d|cdrom[1-2]/", $order);
                        if(count($valid_order) != count($order)) {
                            $error[] = $l["invalid_boot_order"];
                            return false;
                        }
                        if(!empty($install_script)) {
                            $position_order = array_search("disk1", $order);
                            if(!empty($position_order)) {
                                unset($order[$position_order]);
                                array_unshift($order, "disk1");
                            }
                        }
                        $newvs["boot"] = serialize($order);
                    }
                }
            }
            $data_set = [];
            if(!empty($demo)) {
                $newvs["demo"] = $demo;
            }
            foreach ($vps_data as $vk => $vv) {
                $data_set[$vv] = $newvs[$vv];
            }
            $newvs["data"] = $data_set;
            if(!empty($globals["save_vm_pass"])) {
                $salt = generateRandStr(8);
                $pass_crypt = pass_encrypt($newvs["pass"], $salt);
                $newvs["data"]["crypted_pass"] = $pass_crypt;
                $newvs["data"]["crypted_salt"] = $salt;
            }
            $newvs["data"]["enable_cpu_threshold"] = (int) optPOST("enable_cpu_threshold");
            if(!empty($newvs["data"]["enable_cpu_threshold"])) {
                $newvs["data"]["cpu_threshold"] = (int) optPOST("cpu_threshold");
                $newvs["data"]["cpu_threshold_time"] = (int) optPOST("cpu_threshold_time");
                $cputhreshold = $newvs["data"]["cpu_threshold"];
                if(100 < $cputhreshold || empty($cputhreshold)) {
                    $error[] = $l["percent_err_threshold"];
                }
                if($newvs["data"]["cpu_threshold_time"] % 5 !== 0 || empty($newvs["data"]["cpu_threshold_time"])) {
                    $error[] = $l["time_err_threshold"];
                }
            }
            $newvs = apply_filters("before_addvs", $newvs);
            $lb = 0;
            if(!preg_match("/windows/is", $ostemplates[$newvs["osid"]]["name"]) && $kernel->features("load_balancer", $_virt) && is_billing_user($newvs["uid"], 1) && $pro_lic) {
                $lb = optPOST("load_balancer");
                if($lb == -1) {
                    if(!empty($newvs["iso"])) {
                        $error[] = $l["iso_load_balancer"];
                        return false;
                    }
                    if(!empty($_POST["pcis"]) || !empty($_POST["usbs"])) {
                        $error[] = $l["passthrough_invalid_loadbalancer"];
                        return false;
                    }
                    $newvs["data"]["enable_guest_agent"] = 1;
                    $newvs["data"]["disable_password"] = 1;
                    $newvs["admin_managed"] = 1;
                    $check_os = check_os_load_balancer($ostemplates[$newvs["osid"]]["name"]);
                    if(empty($check_os)) {
                        $error[] = $l["lb_os_not_supported"];
                        return false;
                    }
                    if(!empty($newvs["bandwidth"])) {
                        $error[] = $l["lb_must_have_unlimited_bw"];
                        return false;
                    }
                    if(empty($globals["save_vm_pass"])) {
                        $salt = generateRandStr(8);
                        $pass_crypt = pass_encrypt($newvs["pass"], $salt);
                        $newvs["data"]["crypted_pass"] = $pass_crypt;
                        $newvs["data"]["crypted_salt"] = $salt;
                    }
                }
                if($lb != -1) {
                    $tmp_lb = get_load_balancer(["uid" => $newvs["uid"], "sgid" => $servers[$globals["server"]]["sgid"], "vps_uuid" => $lb]);
                    if(empty($tmp_lb[$lb])) {
                        $lb = 0;
                    }
                }
            }
            if(!empty($error)) {
                return false;
            }
            $data_encode = json_encode($newvs["data"]);
            unset($data_set);
            $vpsid = insert_and_id("INSERT INTO vps SET\n\t\t\t\t\t\t\t\t\tserid = :serid,\n\t\t\t\t\t\t\t\t\ttime = :time,\n\t\t\t\t\t\t\t\t\tvirt = :virt,\n\t\t\t\t\t\t\t\t\tuid = :uid,\n\t\t\t\t\t\t\t\t\tvps_name = :vps_name,\n\t\t\t\t\t\t\t\t\t`uuid` = :uuid,\n\t\t\t\t\t\t\t\t\tplid = :plid,\n\t\t\t\t\t\t\t\t\thostname = :hostname,\n\t\t\t\t\t\t\t\t\tosid = :osid,\n\t\t\t\t\t\t\t\t\tos_name = :os_name,\n\t\t\t\t\t\t\t\t\tiso = :iso,\n\t\t\t\t\t\t\t\t\tsec_iso = :sec_iso,\n\t\t\t\t\t\t\t\t\tboot = :boot,\n\t\t\t\t\t\t\t\t\tspace = :space,\n\t\t\t\t\t\t\t\t\tram = :ram,\n\t\t\t\t\t\t\t\t\tburst = :burst,\n\t\t\t\t\t\t\t\t\tswap = :swap,\n\t\t\t\t\t\t\t\t\tcpu = :cpu,\n\t\t\t\t\t\t\t\t\tcores = :cores,\n\t\t\t\t\t\t\t\t\tcpupin = :cpupin,\n\t\t\t\t\t\t\t\t\tcpu_percent = :cpu_percent,\n\t\t\t\t\t\t\t\t\tbandwidth = :bandwidth,\n\t\t\t\t\t\t\t\t\tnetwork_speed = :network_speed,\n\t\t\t\t\t\t\t\t\tupload_speed = :upload_speed,\n\t\t\t\t\t\t\t\t\tio = :io,\n\t\t\t\t\t\t\t\t\tubc = :ubc,\n\t\t\t\t\t\t\t\t\tacpi = :acpi,\n\t\t\t\t\t\t\t\t\tapic = :apic,\n\t\t\t\t\t\t\t\t\tpae = :pae,\n\t\t\t\t\t\t\t\t\tshadow = :shadow,\n\t\t\t\t\t\t\t\t\tvnc = :vnc,\n\t\t\t\t\t\t\t\t\thvm = :hvm,\n\t\t\t\t\t\t\t\t\tband_suspend = :band_suspend,\n\t\t\t\t\t\t\t\t\ttuntap = :tuntap,\n\t\t\t\t\t\t\t\t\tppp = :ppp,\n\t\t\t\t\t\t\t\t\tploop = :ploop,\n\t\t\t\t\t\t\t\t\tdns_nameserver = :dns_nameserver,\n\t\t\t\t\t\t\t\t\tosreinstall_limit = :osreinstall_limit,\n\t\t\t\t\t\t\t\t\tnic_type = :nic_type,\n\t\t\t\t\t\t\t\t\tvif_type = :vif_type,\n\t\t\t\t\t\t\t\t\tvirtio = :virtio,\n\t\t\t\t\t\t\t\t\tpv_on_hvm = :pv_on_hvm,\n\t\t\t\t\t\t\t\t\tmg = :mg,\n\t\t\t\t\t\t\t\t\twebuzo = :webuzo,\n\t\t\t\t\t\t\t\t\tkvm_cache = :kvm_cache,\n\t\t\t\t\t\t\t\t\tio_mode = :io_mode,\n\t\t\t\t\t\t\t\t\ttotal_iops_sec = :total_iops_sec,\n\t\t\t\t\t\t\t\t\tread_bytes_sec = :read_bytes_sec,\n\t\t\t\t\t\t\t\t\twrite_bytes_sec = :write_bytes_sec,\n\t\t\t\t\t\t\t\t\tvnc_keymap = :vnc_keymap,\n\t\t\t\t\t\t\t\t\tkvm_vga = :kvm_vga,\n\t\t\t\t\t\t\t\t\tacceleration = :acceleration,\n\t\t\t\t\t\t\t\t\tdisable_ebtables = :disable_ebtables,\n\t\t\t\t\t\t\t\t\tcpu_mode = :cpu_mode,\n\t\t\t\t\t\t\t\t\tnuma = :numa,\n\t\t\t\t\t\t\t\t\tadmin_managed = :admin_managed,\n\t\t\t\t\t\t\t\t\trdp = :rdp,\n\t\t\t\t\t\t\t\t\tdisable_nw_config = :disable_nw_config,\n\t\t\t\t\t\t\t\t\ttopology_sockets = :topology_sockets,\n\t\t\t\t\t\t\t\t\ttopology_cores = :topology_cores,\n\t\t\t\t\t\t\t\t\ttopology_threads = :topology_threads,\n\t\t\t\t\t\t\t\t\topenvz_features = :openvz_features,\n\t\t\t\t\t\t\t\t\tspeed_cap = :speed_cap,\n\t\t\t\t\t\t\t\t\tbpid = :bpid,\n\t\t\t\t\t\t\t\t\tha = :ha,\n\t\t\t\t\t\t\t\t\tload_balancer = :load_balancer,\n\t\t\t\t\t\t\t\t\tdata = :data,\n\t\t\t\t\t\t\t\t\tfwid = :fwid,\n\t\t\t\t\t\t\t\t\tadmin_fwid = :admin_fwid", [":serid" => $globals["server"], ":time" => time(), ":virt" => $newvs["virt"], ":uid" => $newvs["uid"], ":vps_name" => $newvs["vps_name"], ":uuid" => $newvs["uuid"], ":plid" => $newvs["plid"], ":hostname" => $newvs["hostname"], ":osid" => $newvs["osid"], ":os_name" => empty($ostemplates[$newvs["osid"]]["name"]) ? "" : $ostemplates[$newvs["osid"]]["name"], ":iso" => $newvs["iso"], ":sec_iso" => $newvs["sec_iso"], ":boot" => $newvs["boot"], ":space" => $total_space, ":ram" => $newvs["ram"], ":burst" => $newvs["burst"], ":swap" => $newvs["swap"], ":cpu" => $newvs["cpu"], ":cores" => $newvs["cores"], ":cpupin" => $newvs["cpupin"], ":cpu_percent" => $newvs["cpu_percent"], ":bandwidth" => $newvs["bandwidth"], ":network_speed" => $newvs["network_speed"], ":upload_speed" => $newvs["upload_speed"], ":io" => $newvs["io"], ":ubc" => $newvs["ubc"], ":acpi" => $newvs["acpi"], ":apic" => $newvs["apic"], ":pae" => $newvs["pae"], ":shadow" => $newvs["shadow"], ":vnc" => $newvs["vnc"], ":hvm" => $newvs["hvm"], ":band_suspend" => $newvs["band_suspend"], ":tuntap" => $newvs["tuntap"], ":ppp" => $newvs["ppp"], ":ploop" => $newvs["ploop"], ":dns_nameserver" => serialize($_dns), ":osreinstall_limit" => $newvs["osreinstall_limit"], ":nic_type" => $newvs["nic_type"], ":vif_type" => $newvs["vif_type"], ":virtio" => $newvs["virtio"], ":pv_on_hvm" => $newvs["pv_on_hvm"], ":mg" => implode(",", $newvs["mg"]), ":webuzo" => $newvs["webuzo"], ":kvm_cache" => $newvs["kvm_cache"], ":io_mode" => $newvs["io_mode"], ":total_iops_sec" => $newvs["total_iops_sec"], ":read_bytes_sec" => $newvs["read_bytes_sec"], ":write_bytes_sec" => $newvs["write_bytes_sec"], ":vnc_keymap" => $newvs["vnc_keymap"], ":kvm_vga" => $newvs["kvm_vga"], ":acceleration" => $newvs["acceleration"], ":disable_ebtables" => $newvs["disable_ebtables"], ":cpu_mode" => $newvs["cpu_mode"], ":numa" => $newvs["numa"], ":admin_managed" => $newvs["admin_managed"], ":rdp" => $newvs["rdp"], ":disable_nw_config" => $newvs["disable_nw_config"], ":topology_sockets" => $newvs["topology_sockets"], ":topology_cores" => $newvs["topology_cores"], ":topology_threads" => $newvs["topology_threads"], ":openvz_features" => $newvs["openvz_features"], ":speed_cap" => !empty($newvs["speed_cap"]) && is_array($newvs["speed_cap"]) ? serialize($newvs["speed_cap"]) : "", ":bpid" => $newvs["bpid"], ":ha" => $newvs["ha"], ":load_balancer" => $lb, ":data" => $data_encode, ":fwid" => $newvs["fwid"], ":admin_fwid" => $newvs["admin_fwid"]]);
            if(empty($vpsid)) {
                $error["err_insert"] = $l["err_insert"];
                return false;
            }
            $newvs["vpsid"] = $vpsid;
            $eu_sshkeys = optREQ("eu_sshkeys");
            if(!empty($eu_sshkeys)) {
                $ssh_keys = $_POST["create_addsshkeys"];
                $ssh_keys = array_map("intval", $ssh_keys);
                $res = makequery("SELECT value FROM ssh_keys\n\t\t\t\t\t\t\t\tWHERE keyid IN ('-1', '" . implode("', '", $ssh_keys) . "')\n\t\t\t\t\t\t\t\tAND uid = :uid", [":uid" => $newvs["uid"]]);
                $values = [];
                for ($i = 0; $i < vsql_num_rows($res); $i++) {
                    $row = vsql_fetch_assoc($res);
                    $values[] = $row["value"];
                }
                if(!$kernel->addsshkeys($vpsid, $values)) {
                    $error[] = $l["sshkey_err_add"];
                } else {
                    $done["msg"] = $l["sshkey_done_addvps"];
                }
            }
            if($kernel->features("disks_support", $newvs["virt"])) {
                foreach ($disks as $k => $v) {
                    $_stid = $storage_uuids[$v["st_uuid"]];
                    $disk_uuid = "d" . generateRandStr(15);
                    $newvs["disks"][$k] = vps_disk_struct();
                    $newvs["disks"][$k]["primary"] = $k == 0 ? 1 : 0;
                    $newvs["disks"][$k]["path"] = vpsdisk_path_build("-" . $disk_uuid, $storages[$_stid], $newvs);
                    $newvs["disks"][$k]["type"] = $storages[$_stid]["type"];
                    $newvs["disks"][$k]["format"] = $storages[$_stid]["format"];
                    $newvs["disks"][$k]["size"] = $v["size"];
                    $newvs["disks"][$k]["vpsid"] = $newvs["vpsid"];
                    $newvs["disks"][$k]["st_uuid"] = $storages[$_stid]["st_uuid"];
                    $newvs["disks"][$k]["disk_uuid"] = $disk_uuid;
                    $newvs["disks"][$k]["num"] = !empty($v["num"]) ? $v["num"] : $k;
                    $newvs["disks"][$k]["bus_driver"] = $v["bus_driver"];
                    $newvs["disks"][$k]["bus_driver_num"] = $v["bus_driver_num"];
                    vpsdisk_add($newvs["uuid"], $newvs["disks"][$k]);
                }
                if($newvs["virt"] == "xen" && empty($newvs["hvm"]) && 0 < $newvs["swap"]) {
                    $_stid = $storage_uuids[$disks[0]["st_uuid"]];
                    $sdisk_uuid = "d" . generateRandStr(15);
                    $newvs["disks"][1]["primary"] = 0;
                    $newvs["disks"][1]["path"] = vpsdisk_path_build("swap-" . $disk_uuid, $storages[$_stid], $newvs);
                    $newvs["disks"][1]["type"] = $storages[$_stid]["type"];
                    $newvs["disks"][1]["format"] = $storages[$_stid]["format"];
                    $newvs["disks"][1]["size"] = $newvs["swap"];
                    $newvs["disks"][1]["size_unit"] = "M";
                    $newvs["disks"][1]["vpsid"] = $newvs["vpsid"];
                    $newvs["disks"][1]["st_uuid"] = $storages[$_stid]["st_uuid"];
                    $newvs["disks"][1]["disk_uuid"] = $sdisk_uuid;
                    $newvs["disks"][1]["num"] = 1;
                    vpsdisk_add($newvs["uuid"], $newvs["disks"][1]);
                }
            }
            if($kernel->features("vnc_store_pass", $_virt) && !empty($newvs["vncpass"])) {
                $res = makequery("UPDATE vps\n\t\t\t\t\tSET vnc_passwd = :vnc_passwd\n\t\t\t\t\tWHERE vpsid = :vpsid", [":vnc_passwd" => $newvs["vncpass"], ":vpsid" => $vpsid]);
            }
            $allips = array_merge($pips, $pips6, $pips6_subnet, $pips_int);
            $p_counter = 1;
            foreach ($allips as $k => $v) {
                $up_tokens = [":vpsid" => $vpsid, ":primary" => -1 * $p_counter, ":ip" => $v];
                $up_query = "";
                if(!empty($pips_int)) {
                    $up_query = " AND ippid IN (" . $ippid_chk["query"] . ")";
                    $up_tokens = array_merge($ippid_chk["tokens"], $up_tokens);
                }
                if(in_array($v, $unusedip)) {
                    $res = update_query("UPDATE ips\n\t\t\t\t\t\t\t\t\tSET vpsid = :vpsid,\n\t\t\t\t\t\t\t\t\t`primary` = :primary\n\t\t\t\t\t\t\t\t\tWHERE ip = :ip" . $up_query, $up_tokens);
                } else {
                    $res = insert_and_id("INSERT INTO ips SET\n\t\t\t\t\t\t\t\t\t ip = :ip,\n\t\t\t\t\t\t\t\t\t vpsid = :vpsid,\n\t\t\t\t\t\t\t\t\t `primary` = :primary,\n\t\t\t\t\t\t\t\t\t ip_serid = :ip_serid,\n\t\t\t\t\t\t\t\t\t ipv6 = :ipv6", [":ip" => $v, ":vpsid" => $vpsid, ":primary" => -1 * $p_counter, ":ip_serid" => $globals["server"], ":ipv6" => valid_ip($v) ? 0 : 1]);
                }
                $p_counter++;
            }
            $up_pri_tokens = [":primary" => 1, ":ip" => !empty($pips[0]) ? $pips[0] : $allips[0]];
            $up_pri_query = "";
            if(!empty($pips_int)) {
                $up_pri_query = " AND ippid IN (" . $ippid_chk["query"] . ")";
                $up_pri_tokens = array_merge($ippid_chk["tokens"], $up_pri_tokens);
            }
            $res = update_query("UPDATE ips\n\t\t\t\t\t\t\tSET `primary`  = :primary\n\t\t\t\t\t\t\tWHERE ip = :ip" . $up_pri_query, $up_pri_tokens);
            $newvs["ips"] = $pips;
            $newvs["ipv6"] = $pips6;
            $newvs["ipv6_subnet"] = $pips6_subnet;
            $newvs["ipv6_subnet_w_prefix"] = $ipv6_subnet_w_prefix;
            $newvs["ips_int"] = $pips_int;
            if($kernel->features("pci_passthrough", $_virt) && isset($_POST["pcis"]) && $pro_lic) {
                if($cluster->pci_manager($globals["server"], [], "iommu_support")) {
                    $pcis_to_assign = implode(", ", $_POST["pcis"]);
                    $res = makequery("SELECT * FROM `passthrough` WHERE dev_fullname LIKE '%vga%' AND pid IN (" . $pcis_to_assign . ")");
                    if(1 < vsql_num_rows($res)) {
                        $error[] = $l["single_gpu_only"];
                        return false;
                    }
                    makequery("UPDATE passthrough set vpsid = :vpsid WHERE `pid` IN (" . $pcis_to_assign . ")", [":vpsid" => $vpsid]);
                } else {
                    $error[] = $l["passthrough_not_sup"];
                }
            }
            if($kernel->features("usb_passthrough", $_virt) && isset($_POST["usbs"]) && !empty($_POST["usbs"]) && $pro_lic) {
                $u = (string) implode(", ", $_POST["usbs"]);
                makequery("UPDATE passthrough set vpsid = :vpsid where pid in (" . $u . ")", [":vpsid" => $vpsid]);
            }
            if(!empty($_POST["recipe"])) {
                $recipe_id = $_POST["recipe"];
                if(is_array($recipe_id)) {
                    foreach ($recipe_id as $rk => $rv) {
                        $recipe_id[$rk] = (int) $rv;
                    }
                } else {
                    $recipe_id = (int) $recipe_id;
                }
            }
            if(!empty($install_script)) {
                $vps = getvps($newvs["vpsid"], 0);
                if(!empty($globals["server"])) {
                    $sres = $cluster->sync($globals["server"]);
                    if(empty($sres)) {
                        return false;
                    }
                }
                $webzuo_data["primary_ip"] = !empty($pips[0]) ? $pips[0] : $allips[0];
                $data = ["iscript_data" => serialize($webzuo_data), "vpsid" => $vpsid, "newvs" => $newvs];
                $actid = tasks_admin_process("addvs", serialize($data), 10, $newvs["vpsid"], 0, 0, 0);
                vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/iscript.php " . $actid . " > " . logdir("install_script") . $vpsid . ".log 2>&1 &");
                $done["webuzo_enabled"] = true;
            }
            if(!empty($globals["add_ptr_record"]) && empty($newvs["dont_add_ptr"])) {
                $post = [];
                $post["add_dnsrecord"] = 1;
                $post["dns_type"] = "type_rdns";
                $post["dns_ip"] = !empty($newvs["ips"]) ? $newvs["ips"][0] : $newvs["ipv6"][0];
                $post["domain"] = $newvs["hostname"];
                $post["rdns_user_id"] = $newvs["uid"];
                $res = makequery("SELECT p.id, p.name, p.sql_ipaddress\n\t\t\t\t\t\t\t\tFROM pdns p \n\t\t\t\t\t\t\t\tJOIN dnsplans d ON d.pdnsid = p.id \n\t\t\t\t\t\t\t\tJOIN users u ON u.dnsplid = d.dnsplid \n\t\t\t\t\t\t\t\tWHERE u.email = :user_email", [":user_email" => $user_email]);
                if(0 < vsql_num_rows($res)) {
                    $row = vsql_fetch_assoc($res);
                    $pdnsid = $row["id"];
                    $pdns_ser_name = $row["name"];
                    $post["user_rdns_soa_record"] = $row["sql_ipaddress"] . " " . $user_email;
                }
                unset($res);
                if(empty($pdnsid) && empty($pdns_ser_name)) {
                    $res = makequery("SELECT id, name FROM pdns\n\t\t\t\t\t\t\t\t\tINNER JOIN ippool \n\t\t\t\t\t\t\t\t\tON pdns.id = ippool.pdns_id \n\t\t\t\t\t\t\t\t\tINNER JOIN ips \n\t\t\t\t\t\t\t\t\tON ips.ippid = ippool.ippid \n\t\t\t\t\t\t\t\t\tWHERE ips.ip = :ip", [":ip" => $post["dns_ip"]]);
                    if(0 < vsql_num_rows($res)) {
                        $row = vsql_fetch_assoc($res);
                        $pdnsid = $row["id"];
                        $pdns_ser_name = $row["name"];
                    }
                }
                unset($res);
                if(empty($pdnsid) && empty($pdns_ser_name)) {
                    $res = makequery("SELECT * FROM pdns");
                    $row = vsql_fetch_assoc($res);
                    $pdnsid = $row["id"];
                    $pdns_ser_name = $row["name"];
                }
                $ret_data = $cluster->call(0, "index.php?act=add_dnsrecord&pdnsid=" . $pdnsid, 1, [], $post);
                if($ret_data["done"]) {
                    $newvs["ptr_record_added"] = ["pdns_ser_name" => $pdns_ser_name, "hostname" => $post["domain"], "ip" => $post["dns_ip"]];
                }
                if(!empty($ret_data["error"])) {
                    $newvs["ptr_record_error"] = $ret_data["error"];
                }
            }
            $data = ["progress_msg" => $l["checking_data"], "newvs" => $newvs, "dns" => $_dns, "serid" => $globals["server"], "user_email" => $user_email, "user_pass" => $user_pass, "noemail" => optREQ("noemail"), "add_to_backup" => optREQ("add_to_backup"), "recipe" => $recipe_id];
            if(!empty($control_panel) && $control_panel != "none") {
                $data["control_panel"] = $control_panel;
            }
            if(!empty($_POST["restore"])) {
                $action = "addvs_restore";
                $data["bid"] = optPOST("bid");
                $data["dir"] = optPOST("dir");
                $data["backup_date"] = optPOST("backup_date");
                $data["backup_file"] = optPOST("backup_file");
                $data["backup_file_htime"] = optPOST("backup_file_htime");
                $data["backuply_time"] = optPOST("backuply_time");
                $data["old_vps"] = optPOST("old_vps");
                $data["use_backuply"] = optPOST("use_backuply");
                $data["backup_vpsid"] = optPOST("backup_vpsid");
                $data["newserid"] = optPOST("newserid");
                $data["from_server"] = optPOST("from_server");
                $data["storage_name"] = optPOST("storage_name");
            } else {
                $action = "addvs";
            }
            $data["server_selection"] = "";
            if(!empty($globals["show_server_selection_logs"])) {
                $data["server_selection"] = $ns_server_filtered;
            }
            $dont_dd_os_temp = (int) optPOST("DONT_DD_OS_TEMPLATE");
            if(!empty($dont_dd_os_temp)) {
                $data["DONT_DD_OS_TEMPLATE"] = 1;
            }
            if(!empty($private_key)) {
                $data["private_key"] = $private_key;
            }
            if(empty($done["webuzo_enabled"])) {
                $actid = tasks_admin_process($action, serialize($data), 10, $vpsid, $user["uid"], 0, 0);
                vexec($globals["com"]["php"] . " " . $globals["path"] . "/scripts/addvs.php " . $actid . " > " . logdir("addvs") . $vpsid . ".log 2>&1 &");
            }
            ip_logs($vpsid);
            $flag_createvps = 1;
            $flag_ubcsettings = 0;
            $tmp_ubcsettings = (int) optREQ("ubcsettings") ? 1 : 0;
            if(!empty($tmp_ubcsettings)) {
                $flag_ubcsettings = 1;
            }
            $done = $vpsid;
            $owner = !empty($users[$newvs["uid"]]["pid"]) ? $users[$newvs["uid"]]["pid"] : $newvs["uid"];
            if(!empty($globals["inhouse_billing"]) && !empty($users[$owner]["inhouse_billing"]) && 0 < $newvs["plid"]) {
                $vals = $set = [];
                $vals["vps_uuid"] = $newvs["uuid"];
                $vals["uid"] = $owner;
                $vals["starttime"] = time();
                $vals["plid"] = $newvs["plid"];
                $vals["data"] = serialize(["hostname" => $newvs["hostname"]]);
                foreach ($vals as $k => $v) {
                    $set[$k] = "`" . $k . "` = :" . $k;
                }
                $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                $vals = $set = [];
                $vals["vps_uuid"] = $newvs["uuid"];
                $vals["uid"] = $owner;
                $vals["starttime"] = time();
                $vals["resource"] = "bandwidth";
                $vals["data"] = serialize(["hostname" => $newvs["hostname"]]);
                foreach ($vals as $k => $v) {
                    $set[$k] = "`" . $k . "` = :" . $k;
                }
                $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                $plan = $plans[$newvs["plid"]];
                foreach ($globals["resource_types"] as $resource) {
                    $resources_ips = ["ips" => $pips, "ipv6" => $pips6, "ipv6subnet" => $pips6_subnet, "ipsint" => $pips_int];
                    $plan_map = ["ipv6" => "ips6", "ipv6subnet" => "ips6_subnet", "ipsint" => "ips_int"];
                    if(array_key_exists($resource, $resources_ips)) {
                        $numval = count($resources_ips[$resource]);
                    } else {
                        $numval = $newvs[$resource];
                    }
                    $plan_map = ["ipv6" => "ips6", "ipv6subnet" => "ips6_subnet", "ipsint" => "ips_int"];
                    if($plan[$resource] < $numval) {
                        $new_resource[$resource] = $numval - $plan[$resource];
                    }
                    if(!empty($plan_map[$resource]) && $plan[$plan_map[$resource]] < $numval) {
                        $new_resource[$resource] = $numval - $plan[$resource];
                    }
                }
                if(!empty($new_resource)) {
                    $vps = getvps($vpsid);
                    foreach ($new_resource as $resource => $resval) {
                        $vals = $set = [];
                        $vals["vps_uuid"] = $vps["uuid"];
                        $vals["uid"] = $owner;
                        $vals["starttime"] = time();
                        $vals["resource"] = $resource;
                        $vals["resource_val"] = $resource == "ram" ? $resval / 1024 : $resval;
                        foreach ($vals as $k => $v) {
                            $set[$k] = "`" . $k . "` = :" . $k;
                        }
                        $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                    }
                }
                $min_charge = get_billing_min_charge($plid, $server_group);
                if(!empty($min_charge)) {
                    $vals = $set = [];
                    $vals["vps_uuid"] = $newvs["uuid"];
                    $vals["uid"] = $owner;
                    $vals["updatetime"] = time();
                    $vals["endtime"] = $vals["updatetime"];
                    $vals["starttime"] = $vals["endtime"];
                    $vals["resource"] = "advance_payment";
                    $vals["h_used"] = $min_charge;
                    $vals["data"] = serialize(["hostname" => $newvs["hostname"]]);
                    foreach ($vals as $k => $v) {
                        $set[$k] = "`" . $k . "` = :" . $k;
                    }
                    $usid = insert_and_id("INSERT INTO `usage` \n\t\t\t\t\t\t\t\t\tSET " . implode(", ", $set), $vals);
                    $balance = billing_balance($owner);
                    insert_and_id("INSERT INTO transactions\n\t\t\t\t\t\t\t\t\t\tSET uid = :uid,\n\t\t\t\t\t\t\t\t\t\tdate = '" . datify(time(), 0, 1, "Ymd") . "',\n\t\t\t\t\t\t\t\t\t\tunixtime = '" . time() . "',\n\t\t\t\t\t\t\t\t\t\tinvoid = :invoid,\n\t\t\t\t\t\t\t\t\t\tgateway = 'advance_payment',\n\t\t\t\t\t\t\t\t\t\tamt = :amt,\n\t\t\t\t\t\t\t\t\t\tfees = :fees,\n\t\t\t\t\t\t\t\t\t\tnet = amt - fees,\n\t\t\t\t\t\t\t\t\t\tbal = :bal", ["uid" => $owner, "invoid" => 0, "amt" => 0 - $min_charge, "fees" => 0, "bal" => $balance - $min_charge]);
                    billing_update_all();
                }
            }
            if($lb == -1) {
                $res = makequery("INSERT INTO `load_balancer` SET\n\t\t\t\t\t\t\t\t\t`vps_uuid` = :vps_uuid,\n\t\t\t\t\t\t\t\t\t`uid` = :uid,\n\t\t\t\t\t\t\t\t\t`sgid` = :sgid\n\t\t\t\t\t\t\t\t\t", [":vps_uuid" => $newvs["uuid"], ":uid" => $newvs["uid"], ":sgid" => $servers[$globals["server"]]["sgid"]]);
            }
        }
    }
}
function API_addvs()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $cluster;
    global $oslist;
    global $node_selected;
    global $ns_server_filtered;
    global $done;
    global $loop_device;
    global $pcis;
    global $usbs;
    global $plans;
    global $ips;
    global $ips6;
    global $ips6_subnet;
    global $ips_int;
    global $ipools;
    global $servers;
    global $users;
    global $isos;
    global $_virt;
    global $virt;
    global $hvm;
    global $newvs;
    global $oses;
    global $ostemplates;
    global $resources;
    global $mgs;
    global $servergroups;
    global $scripts;
    global $iscripts;
    global $actid;
    global $backup_plans;
    global $webuzo_done;
    global $bus_driver;
    global $ajax_user;
    global $new_keys;
    global $load_balancer;
    global $firewall_plans;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    $GLOBALS["_api"]["ips"] = $ips;
    $GLOBALS["_api"]["ips6"] = $ips6;
    $GLOBALS["_api"]["ips6_subnet"] = $ips6_subnet;
    $GLOBALS["_api"]["ips_int"] = $ips_int;
    if(empty($_REQUEST["get_user_ips"])) {
        $GLOBALS["_api"]["globals"]["cookie_name"] = $globals["cookie_name"];
        $GLOBALS["_api"]["servers"] = $servers;
        $GLOBALS["_api"]["plans"] = $plans;
        $GLOBALS["_api"]["ipools"] = $ipools;
        $GLOBALS["_api"]["users"] = $users;
        $GLOBALS["_api"]["isos"] = $isos;
        $GLOBALS["_api"]["_virt"] = $_virt;
        $GLOBALS["_api"]["virt"] = $virt;
        $GLOBALS["_api"]["hvm"] = $hvm;
        $GLOBALS["_api"]["node_selected"] = $node_selected;
        $GLOBALS["_api"]["ns_server_filtered"] = $ns_server_filtered;
        $GLOBALS["_api"]["newvs"] = $newvs;
        $GLOBALS["_api"]["oses"] = $oses;
        $GLOBALS["_api"]["oslist"] = $oslist;
        $GLOBALS["_api"]["ostemplates"] = $ostemplates;
        $GLOBALS["_api"]["resources"] = $resources;
        $GLOBALS["_api"]["mgs"] = $mgs;
        $GLOBALS["_api"]["servergroups"] = $servergroups;
        $GLOBALS["_api"]["scripts"] = $scripts;
        $GLOBALS["_api"]["iscripts"] = $iscripts;
        $GLOBALS["_api"]["ajax_user"] = $ajax_user;
        $GLOBALS["_api"]["new_keys"] = $new_keys;
        $GLOBALS["_api"]["loop_device"] = $loop_device;
        $GLOBALS["_api"]["load_balancer"] = $load_balancer;
        if(!empty($pcis)) {
            $GLOBALS["_api"]["pcis"] = $pcis;
        }
        if(!empty($pcis)) {
            $GLOBALS["_api"]["usbs"] = $usbs;
        }
    }
    $GLOBALS["_api"]["firewall_plans"] = $firewall_plans;
    if(!empty($gpu_roms)) {
        $GLOBALS["_api"]["gpu_roms"] = $gpu_roms;
    }
    if(!empty($webuzo_done)) {
        $GLOBALS["_api"]["webuzo_done"] = $webuzo_done;
    }
    if(!empty($actid)) {
        $GLOBALS["_api"]["actid"] = $actid;
    }
}

?>