<?php
/*
 * @ https://EasyToYou.eu - IonCube v11 Decoder Online
 * @ PHP 7.4
 * @ Decoder version: 1.0.2
 * @ Release: 10/08/2022
 */

// Decoded file for php version 71.
if(!defined("VIRTUALIZOR")) {
    exit("Hacking Attempt");
}
function add_dnsrecord()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $done;
    global $vps_name;
    global $vpslist;
    global $pdns;
    global $pdnsid;
    global $zones;
    global $editrecord;
    if(!load_lang("admin/add_dnsrecord")) {
        return false;
    }
    if(allow_slave_action()) {
        reporterror($l["slave_cant"], $l["slave_cant_exp"], $l["slave_cant"]);
        return false;
    }
    $theme["init_theme"] = "admin/add_dnsrecord";
    $theme["init_theme_name"] = "add_dnsrecord";
    $theme["init_theme_func"] = ["add_dnsrecord_theme"];
    $theme["call_theme_func"] = "add_dnsrecord_theme";
    if(!is_allowed("add_dnsrecord")) {
        reporterror($l["not_allowed_title"], $l["err_acl_no_allowed"]);
        return false;
    }
    $pdnsid = (int) optGET("pdnsid");
    if(empty($pdnsid)) {
        redirect("act=pdns");
    }
    $pdns = get_dns_server($pdnsid);
    $con = vsql_connect($pdns["sql_ipaddress"], $pdns["sql_port"], $pdns["sql_username"], $pdns["sql_password"], $pdns["sql_database"], $pdns["use_ssl"]);
    if(!$con) {
        $error[] = $l["err_connect"];
        return false;
    }
    $globals["remote_conn"] = $con;
    $res = makequery("SELECT * FROM records", [], 0, $con);
    $records = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $records[$row["id"]] = $row;
    }
    $res = makequery("SELECT * from domains", [], 0, $con);
    $domains = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $domains[$row["id"]] = $row;
    }
    $res = makequery("SELECT * FROM records WHERE type= :type", [":type" => "SOA"], 0, $con);
    $zones = [];
    for ($i = 1; $i <= vsql_num_rows($res); $i++) {
        $row = vsql_fetch_assoc($res);
        $tmp_name = $row["name"];
        $dom_name = explode(".", $tmp_name);
        $len = (int) count($dom_name) - 1;
        if($dom_name[$len] != "arpa") {
            $zones[$row["id"]] = $row;
        }
    }
    $recordid = (int) optGET("edit");
    if(!empty($recordid)) {
        $res = makequery("SELECT * from records WHERE id= :id", [":id" => $recordid], 0, $con);
        $editrecord = vsql_fetch_assoc($res);
        if($editrecord["type"] == "PTR") {
            $editrecord["dns_type"] = "type_rdns";
        } else {
            $editrecord["dns_type"] = "type_dns";
            $type = $editrecord["type"];
        }
    }
    if(isset($_POST["add_dnsrecord"])) {
        $dns_type = empty($editrecord["dns_type"]) ? POST("dns_type", $l["no_zone_type"]) : $editrecord["dns_type"];
        if($dns_type == "type_rdns") {
            $dns_ip = POST("dns_ip", $l["no_dns_ip"]);
            $rdns_domain = POST("domain", $l["no_domain"]);
            $user["uid"] = optPOST("rdns_user_id", $user["uid"]);
            if(!valid_ip($dns_ip) && !valid_ipv6($dns_ip)) {
                $error[] = $l["inv_ip"];
            }
            if(!empty($error)) {
                return false;
            }
            if(!is_valid_domain_name($rdns_domain)) {
                $error[] = $l["inv_revzone"];
                return false;
            }
            $rdns_entry = rdns_ip($dns_ip, $zone);
            if(is_array($rdns_entry)) {
                foreach ($rdns_entry as $k => $v) {
                    $res = makequery("SELECT `id`, `name` FROM `records` WHERE `name` = :nameAND `type` = 'ptr'", [":name" => $v], 0, $con);
                    if(0 < vsql_num_rows($res)) {
                        $row = vsql_fetch_assoc($res);
                        if(empty($editrecord) || $editrecord["id"] != $row["id"]) {
                            $error[] = $l["is_rdns"];
                            return false;
                        }
                    }
                    if(is_array($zone)) {
                        $res = makequery("SELECT `id`, `name`FROM `domains`WHERE `name` = :name", [":name" => $zone[$k]], 0, $con);
                        $res_num = vsql_num_rows($res);
                        if(0 < $res_num) {
                            $rdns_entry = $v;
                            $zone = $zone[$k];
                        }
                    }
                }
                if(is_array($zone)) {
                    $rdns_entry = $rdns_entry[count($rdns_entry) - 1];
                    $zone = $zone[count($zone) - 1];
                }
            } else {
                $res = makequery("SELECT `id`, `name`FROM `records`WHERE `name` = :name,AND `type` = 'ptr'", [":name" => $rdns_entry], 0, $con);
                if(0 < vsql_num_rows($res)) {
                    $row = vsql_fetch_assoc($res);
                    if(empty($editrecord) || $editrecord["id"] != $row["id"]) {
                        $error[] = $l["is_rdns"];
                        return false;
                    }
                }
            }
            $zone64 = substr($zone, 16);
            $zone48 = substr($zone64, 8);
            $res = makequery("SELECT id, name FROM domains WHERE name = :name", [":name" => $zone], 0, $con);
            if(vsql_num_rows($res) < 1) {
                $_res = makequery("SELECT id, name FROM domains WHERE name = :name", [":name" => $zone64], 0, $con);
                if(vsql_num_rows($_res) < 1) {
                    $res48 = makequery("SELECT id, name FROM domains WHERE name = :name", [":name" => $zone48], 0, $con);
                    if(vsql_num_rows($res48) < 1) {
                        if(empty($globals["auto_add_zone"])) {
                            $error[] = $l["err_zone"];
                            return false;
                        }
                        $res_dom = makequery("SHOW COLUMNS FROM `domains` LIKE 'solusvm_cid'", [], 0, $con);
                        $column_name = 0 < vsql_num_rows($res_dom) ? "solusvm_cid" : "virtualizor_uid";
                        $res = insert_and_id("INSERT INTO domains \n\t\t\t\t\t\t\t\t\tSET name = :name, \n\t\t\t\t\t\t\t\t\ttype = :type, \n\t\t\t\t\t\t\t\t\t" . $column_name . " = :" . $column_name . "", [":name" => $zone, ":type" => "MASTER", ":" . $column_name => $user["uid"]], $con);
                        if(!$res) {
                            $error[] = $l["err_save"];
                            return false;
                        }
                        $domainid = $res;
                        $now = time();
                        $user_rdns_soa_record = !empty($_POST["user_rdns_soa_record"]) ? $_POST["user_rdns_soa_record"] : "";
                        $soa_content = get_soa_content($pdns, "", $user_rdns_soa_record);
                        $res = makequery("INSERT INTO records\n\t\t\t\t\t\t\t\t\tSET domain_id = :domain_id, \n\t\t\t\t\t\t\t\t\tname = :name, \n\t\t\t\t\t\t\t\t\tcontent = :content, \n\t\t\t\t\t\t\t\t\ttype = :type, \n\t\t\t\t\t\t\t\t\tttl = :ttl, \n\t\t\t\t\t\t\t\t\tprio = :prio, \n\t\t\t\t\t\t\t\t\tchange_date = :change_date", [":domain_id" => $domainid, ":name" => $zone, ":content" => $soa_content, ":type" => "SOA", ":ttl" => "86400", ":prio" => "0", ":change_date" => $now], 0, $con);
                        if(!$res) {
                            $error[] = $l["err_save"];
                            return false;
                        }
                        $soa_added = 1;
                        $res = makequery("INSERT INTO records\n\t\t\t\t\t\t\tSET domain_id = :domain_id, \n\t\t\t\t\t\t\tname = :name,  \n\t\t\t\t\t\t\ttype = :type,\n\t\t\t\t\t\t\tcontent = :content,\n\t\t\t\t\t\t\tttl = :ttl, \n\t\t\t\t\t\t\tprio = :prio, \n\t\t\t\t\t\t\tchange_date = :change_date", [":domain_id" => $domainid, ":name" => $zone, ":type" => "NS", ":content" => $pdns["sql_ipaddress"], ":ttl" => "86400", ":prio" => "0", ":change_date" => $now], 0, $con);
                    } else {
                        $row48 = vsql_fetch_assoc($res48);
                        $domainid = $row48["id"];
                    }
                } else {
                    $_row = vsql_fetch_assoc($_res);
                    $domainid = $_row["id"];
                }
            } else {
                $row = vsql_fetch_assoc($res);
                $domainid = $row["id"];
            }
            if(!isset($soa_added)) {
                verify_soa_entry($domainid, $con, $pdns);
            }
            $now = time();
            if(empty($editrecord)) {
                $res = makequery("SELECT id, name FROM records WHERE name = :name AND type = 'ptr'", [":name" => $rdns_entry], 0, $con);
                if(0 < vsql_num_rows($res)) {
                    $error[] = $l["is_rdns"];
                    return false;
                }
                $res = makequery("INSERT INTO records\n\t\t\t\t\t\t\t\t\tSET domain_id = :domain_id, \n\t\t\t\t\t\t\t\t\tname = :name, \n\t\t\t\t\t\t\t\t\tcontent = :content, \n\t\t\t\t\t\t\t\t\ttype = :type, \n\t\t\t\t\t\t\t\t\tttl = :ttl, \n\t\t\t\t\t\t\t\t\tprio = :prio, \n\t\t\t\t\t\t\t\t\tchange_date = :change_date", [":domain_id" => $domainid, ":name" => $rdns_entry, ":content" => $rdns_domain, ":type" => "PTR", ":ttl" => "86400", ":prio" => "0", ":change_date" => $now], 0, $con);
                if(!$res) {
                    $error[] = $l["err_save"];
                    return false;
                }
                update_soa_serial($domainid, $con, $pdns);
                $done = true;
            } elseif(!empty($editrecord)) {
                $res = makequery("UPDATE records SET \n\t\t\t\t\t\t\t\t\tdomain_id = :domain_id, \n\t\t\t\t\t\t\t\t\tname = :name, \n\t\t\t\t\t\t\t\t\tcontent = :content, \n\t\t\t\t\t\t\t\t\ttype = :type, \n\t\t\t\t\t\t\t\t\tttl = :ttl, \n\t\t\t\t\t\t\t\t\tprio = :prio, \n\t\t\t\t\t\t\t\t\tchange_date = :change_date\n\t\t\t\t\t\t\t\t\tWHERE id = :id", [":domain_id" => $domainid, ":name" => $rdns_entry, ":content" => $rdns_domain, ":type" => "PTR", ":ttl" => "86400", ":prio" => "0", ":change_date" => $now, ":id" => $editrecord["id"]], 0, $con);
                if(!$res) {
                    $error[] = $l["err_save"];
                    return false;
                }
                update_soa_serial($domainid, $con, $pdns);
                $done = true;
            }
        } elseif($dns_type == "type_dns") {
            $domain_id = empty($editrecord) ? optPOST("zone_name") : $editrecord["domain_id"];
            $name = optPOST("host");
            $type = empty($editrecord) ? POST("record_type", $l["no_record_type"]) : $editrecord["type"];
            $content = POST("content", $l["no_content"]);
            $prio = optPOST("prio");
            $ttl = POST("ttl", $l["no_ttl"]);
            if(empty($name) && $type != "TXT") {
                $error[] = $l["no_host"];
            }
            if(!empty($name) && !is_valid_domain_name($name, 1)) {
                $error["name"] = $l["inv_name"];
            }
            if(empty($prio)) {
                $prio = 0;
            } elseif(!preg_match("/^\\d+\$/", $prio)) {
                $error["prio"] = $l["inv_int"];
            }
            if(!preg_match("/^\\d+\$/", $ttl)) {
                $error["ttl"] = $l["inv_int"];
            }
            switch ($type) {
                case "A":
                    if(!valid_ip($content)) {
                        $error[] = $l["inv_ip"];
                    }
                    break;
                case "CNAME":
                    if(!is_valid_domain_name($content)) {
                        $error[] = $l["inv_tld"];
                    }
                    break;
                case "MX":
                    if(!is_valid_domain_name($content)) {
                        $error[] = $l["inv_tld"];
                    }
                    break;
                case "NS":
                    if(!is_valid_domain_name($content)) {
                        $error[] = $l["inv_tld"];
                    }
                    break;
                case "AAAA":
                    if(!valid_ipv6($content)) {
                        $error[] = $l["inv_ipv6"];
                    }
                    break;
                case "SRV":
                    if(!is_valid_srv($content)) {
                        $error[] = $l["inv_srv"];
                    }
                    break;
                case "TXT":
                default:
                    if(!empty($error)) {
                        return false;
                    }
                    $change = time();
                    if(empty($editrecord)) {
                        $res = makequery("INSERT INTO records\n\t\t\t\t\t\t\t\t\tSET domain_id = :domain_id, \n\t\t\t\t\t\t\t\t\tname = :name,  \n\t\t\t\t\t\t\t\t\ttype = :type,\n\t\t\t\t\t\t\t\t\tcontent = :content,\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\tttl = :ttl, \n\t\t\t\t\t\t\t\t\tprio = :prio, \n\t\t\t\t\t\t\t\t\tchange_date = :change_date", [":domain_id" => $domain_id, ":name" => $name . (!empty($name) ? "." : "") . $domains[$domain_id]["name"], ":type" => $type, ":content" => $content, ":ttl" => $ttl, ":prio" => $prio, ":change_date" => $change], 0, $con);
                        if(!$res) {
                            $error["err_msg"] = $l["err_add"];
                            return false;
                        }
                    } elseif(!empty($editrecord)) {
                        if($type == "SOA") {
                            $content = get_soa_content($pdns, $content);
                        }
                        $res = makequery("UPDATE records SET \n\t\t\t\t\t\t\t\t\tdomain_id = :domain_id, \n\t\t\t\t\t\t\t\t\tname = :name, \n\t\t\t\t\t\t\t\t\ttype = :type,\n\t\t\t\t\t\t\t\t\tcontent = :content,  \n\t\t\t\t\t\t\t\t\tttl = :ttl, \n\t\t\t\t\t\t\t\t\tprio = :prio, \n\t\t\t\t\t\t\t\t\tchange_date = :change_date\n\t\t\t\t\t\t\t\t\tWHERE id = :id", [":domain_id" => $domain_id, ":name" => $name, ":type" => $type, ":content" => $content, ":ttl" => $ttl, ":prio" => $prio, ":change_date" => $change, ":id" => $editrecord["id"]], 0, $con);
                        if(!$res) {
                            $error["err_msg"] = $l["err_add"];
                            return false;
                        }
                    }
                    if($type != "SOA" && !update_soa_serial($domain_id, $con, $pdns)) {
                        $error["err_msg"] = $l["err_soa"];
                        return false;
                    }
                    $done = true;
            }
        }
    }
}
function API_add_dnsrecord()
{
    global $theme;
    global $globals;
    global $kernel;
    global $user;
    global $l;
    global $error;
    global $done;
    global $vps_name;
    global $vpslist;
    global $pdns;
    global $pdnsid;
    global $zones;
    global $editrecord;
    if(!empty($done)) {
        $GLOBALS["_api"]["done"] = $done;
    }
    if(!empty($error)) {
        $GLOBALS["_api"]["error"] = $error;
    }
}

?>