<?php
/**
 * Fix for license function name conflict
 * 
 * Run this script once to update the prtgmonitoring.php file
 */

// Get the main file content
$mainFile = file_get_contents(dirname(__FILE__) . '/prtgmonitoring.php');

// Replace all occurrences of getLicenseForm with renderLicenseForm
$mainFile = str_replace('getLicenseForm($modulelink)', 'renderLicenseForm($modulelink)', $mainFile);

// Replace the function declaration
$mainFile = str_replace('function getLicenseForm($modulelink)', 'function renderLicenseForm($modulelink)', $mainFile);

// Save the updated file
file_put_contents(dirname(__FILE__) . '/prtgmonitoring.php', $mainFile);

echo "License function name conflict fixed successfully!";