<?php
/**
 * Modify the license form to always show regardless of license status
 */

// Get the main file path
$mainFilePath = dirname(__FILE__) . '/prtgmonitoring.php';

// Read the file content
$content = file_get_contents($mainFilePath);

// Find the switch statement for the license case
if (preg_match('/case\s+\'license\':(.*?)break;/s', $content, $matches)) {
    $originalCase = $matches[0];
    
    // Create the replacement that always shows the form
    $replacement = "case 'license':
            \$content = renderLicenseForm(\$modulelink);
            break;";
    
    // Replace in the content
    $content = str_replace($originalCase, $replacement, $content);
    
    // Save the modified file
    file_put_contents($mainFilePath, $content);
    
    echo "License form will now always be displayed regardless of license status.";
} else {
    echo "Could not find the license case in the switch statement.";
}