<?php

namespace WHMCS\Module\Addon\HourlyAddonSeller\Admin;
use WHMCS\Config\Setting;

/**
 * Sample Admin Area Dispatch Handler
 */
class AdminDispatcher
{


    public function dispatch($action, $parameters)
    {
        $version = "1.0.0";
        
        // Handle form submissions - preserve the original action
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['originalAction'])) {
            $action = $_POST['originalAction'];
        }
        
        if (!$action) {
            $action = 'apikey';
        }
        
        // Store original action for form submissions
        $originalAction = $action;
        $parameters["originalAction"] = $originalAction;
        $parameters["modulelink"] = $parameters["modulelink"] . "&action=" . $action;
        
        $controller = new Controller();
        $checkLicense = $this->CheckHourlyAddonSellerLicense();

        $currentVersion = str_replace(".", "", $version);

        $latestVersion = str_replace(".", "", $checkLicense["version"]);
        if ($latestVersion > $currentVersion) {
            return $controller->apikey($parameters);
        }
        if ($checkLicense["status"] != "active") {
            return $controller->apikey($parameters);
        }
        
        if (is_callable(array($controller, $action))) {
            return $controller->$action($parameters);
        }

        return '<p>Invalid action requested: ' . htmlspecialchars($action) . '. Please go back and try again.</p>';
    }
    public function ReturnHourlyAddonSellerLicenseInfo()
    {
        $result = full_query("SELECT * from mod_HourlyAddonSeller");
        $output = [];
        while ($data = mysql_fetch_array($result)) {
            $output = $data;
        }
        return $output;
    }
    public function CheckHourlyAddonSellerLicense()
    {
        $WHMCSurl = Setting::getValue('SystemURL');
        $domain = $WHMCSurl;
        if (isset($_SERVER['SERVER_NAME']))
            $domain = $_SERVER['SERVER_NAME'];
        $data = $this->ReturnHourlyAddonSellerLicenseInfo();
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://cl.keloncloud.com/licensing/checklicense.php',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('licensekey' => $data["apikey"], 'domain' => $domain),
            CURLOPT_HTTPHEADER => array(
                'cache-control: no-cache',
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        return json_decode($response, true);
    }
    public function RenderedTemplate($tplfile, $arrayValue)
    {
        $content = "";
        if (file_exists(__DIR__ . '/../../templates/custom_template/' . $tplfile)) {
            $content = file_get_contents(__DIR__ . '/../templates/custom_template/' . $tplfile);
        } else if (file_exists(__DIR__ . '/../../templates/' . $tplfile)) {
            $content = file_get_contents(__DIR__ . '/../../templates/' . $tplfile);
        } else {
            return "FILE NOT FOUND";
        }
        foreach ($arrayValue as $d => $k) {
            $content = str_replace("{\$" . $d . "}", $k, $content);
        }
        return $content;
    }
}