<?php
/**
 * Example script to get user credit from external API
 */

// Include WHMCS initialization file
require_once(dirname(__FILE__) . '/../../../../../init.php');
require_once(dirname(__FILE__) . '/../HourlyAddonSeller.php');

// Check if user is logged in and has admin access
if (!defined("WHMCS") || !isset($_SESSION['adminid'])) {
    die("This script can only be run from the WHMCS admin area");
}

// User ID to check
$userId = isset($_GET['userid']) ? (int)$_GET['userid'] : 0;

if (!$userId) {
    echo "Please provide a user ID using the 'userid' parameter";
    exit;
}

// Get user details to verify the user exists
$command = 'GetClientsDetails';
$postData = array(
    'clientid' => $userId,
    'stats' => false,
);
$userDetails = localAPI($command, $postData);

if ($userDetails['result'] !== 'success') {
    echo "Error: User ID {$userId} not found";
    exit;
}

// Get credit from external API
$creditInfo = HourlyAddonSeller_getUserCreditFromApi($userId);

// Display results
echo "<h2>Credit Information for User: {$userDetails['firstname']} {$userDetails['lastname']} (ID: {$userId})</h2>";

if ($creditInfo['success']) {
    echo "<p>Credit Balance: " . number_format($creditInfo['credit']) . "</p>";
    echo "<p>Last Updated: " . $creditInfo['last_updated'] . "</p>";
    
    // Update local balance if needed
    if (isset($_GET['update']) && $_GET['update'] == '1') {
        try {
            Capsule::table('mod_HourlyAddonSeller_balance')
                ->updateOrInsert(
                    ['userid' => $userId],
                    [
                        'balance' => $creditInfo['credit'],
                        'updated_at' => date('Y-m-d H:i:s')
                    ]
                );
            echo "<p style='color: green;'>Local balance updated successfully!</p>";
        } catch (Exception $e) {
            echo "<p style='color: red;'>Error updating local balance: " . $e->getMessage() . "</p>";
        }
    } else {
        echo "<p><a href='?userid={$userId}&update=1' class='btn btn-primary'>Update Local Balance</a></p>";
    }
} else {
    echo "<p style='color: red;'>Error: " . $creditInfo['error'] . "</p>";
}