<?php
/**
 * Cron job entry point for the HourlyAddonSeller module
 * 
 * This file should be called by the WHMCS cron job
 * It starts the queue processor script
 */

// Initialize WHMCS
require_once(__DIR__ . '/../../../init.php');
require_once(__DIR__ . '/hooks.php');

// Log cron job start
hourlyLog("HourlyAddonSeller cron job started");

// Start the queue processor in the background
$queueProcessorPath = __DIR__ . '/process_queue.php';
$command = "php " . escapeshellarg($queueProcessorPath) . " > /dev/null 2>&1 &";
exec($command);

hourlyLog("Queue processor started in background");

// Add any other periodic tasks here
// ...

hourlyLog("HourlyAddonSeller cron job completed");