#!/bin/bash
VPS_NAME=$1
TO_IP=$2
TO_SSH_PORT=$3
LOGFILE=$4

echo Virtuzzo Live Migration
echo 1 VPS_NAME $VPS_NAME
echo 2 TO_IP $TO_IP
echo 3 TO_SSH_PORT $TO_SSH_PORT
echo 4 LOGFILE $LOGFILE

# Start live migration

prlctl migrate $VPS_NAME $TO_IP --clone --ssh "-p  $TO_SSH_PORT -oStrictHostKeyChecking=no -i /var/virtualizor/ssh-keys/id_rsa"

# Get return code
RET=$?

echo $RET >>$LOGFILE
echo "mig_completed" >>$LOGFILE
exit $RET