<?php

//////////////////////////////////////////////////////////////
//===========================================================
// vpsretore_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 2.1.9
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Suyash
// Date:       25th July 2017
// Time:       15:42 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function vpsrestore_theme(){

global $theme, $globals, $kernel, $user, $l, $error, $cluster, $backup_servers, $vpses, $storages, $servers;
	
softheader($l['<title>']);


echo '
<div class="bg">
<div class="row my-3 mx-auto">
	<div class="col-12">
		<h4 class="text-dark"><i class="icon icon-databackup "></i> '.$l['<title>'].'</h4>
	</div>
</div>
';

error_handle($error);

// Is it offline ?
$hypervisor_status = $cluster->statewise($globals['server']);
if($hypervisor_status == 0 || $hypervisor_status == 2){

	echo '<div class="e_notice"><b>'.$l['note'].' : </b> &nbsp; '.$l['server_status_'.$hypervisor_status].'</div>';

}else{
	echo ' <script type="text/javascript" charset="utf8" src="'.$theme['url'].'/js2/jquery.dataTables.min.js"></script>
	<script type="text/javascript" charset="utf8" src="'.$theme['url'].'/js2/jquery-simple-tree-table.js"></script>
	';
	echo '<script language="javascript" type="text/javascript">

	$(document).ready(function() {
		
		$("#vps").change(function() {
			$("#row_dir, #row_other_dir, #row_date, #no_backups, #backup_list, #backuply_div").hide();
			
			$("#bid").val(-1);
			
			if($(this).val() == 0) {
				return;
			}
			
			$("#op").val("get_vps");
			$("#restore_form").trigger("submit");
		});

		$("input[type=radio][name=backup_type]").change(function() {
			$("#row_dir, #row_other_dir, #row_date, #no_backups, #backup_list, #backuply_div").hide();
			$("#vps").val(0);
			$("#bid").val(-1);
		});
		
		$("#bid").change(function() {
			$("#row_dir, #row_other_dir, #row_date, #no_backups, #backup_list, #backuply_div").hide();
			
			$("#vps").val(0);
			
			if($(this).val() == -1) {
				return;
			}
			
			$("#op").val("get_dirs");
			$("#restore_form").trigger("submit");
		});
		
		$("#dir").change(function() {
			$("#row_other_dir, #row_date, #no_backups, #backup_list, #backuply_div").hide();
			
			$("#vps").val(0);
			
			if($(this).val() == 0) {
				return;
			}
			
			if($(this).val() == "other") {
				$("#row_other_dir").show();
				return;
			}
			
			$("#op").val("get_backups");
			$("#restore_form").trigger("submit");
		});
		
		$("#scan").click(function() {
			$("#row_date, #no_backups, #backup_list, #backuply_div").hide();
			
			$("#vps").val(0);
			
			if(!$("#other_dir:visible").val()) {
				showalert("'.$l['err_invalid_dir'].'" ,"1");
				return false;
			}
			
			$("#op").val("get_backups");
			$("#restore_form").trigger("submit");
		});
		
		$("#other_dir").keyup(function (e) {
			// Enter key pressed
			if (e.which == 13) {
				$("#scan").trigger("click");
				return false;
			}
		});
		
		$("#date").change(function() {
			$("#no_backups, #backup_list, #backuply_div").hide();
			
			$("#op").val("get_backups");
			$("#restore_form").trigger("submit");
		});
		
		$("#restore_form").submit(function(event) {
			$("#progress_bar").show();
			
			// Set the directory
			var dir = $("#other_dir:visible").val() || $("#dir:visible").val();
			$("#dir_input").val(dir);
			var backup_type = $("input[name=\"backup_type\"]:checked").val();
			$.ajax({
				type: "POST",
				url: "'.$globals['index'].'act=vpsrestore&api=json"+(backup_type == "use_backuply" ? "&use_backuply=1" : ""),
				data: $(this).serialize(),
				dataType : "json",
				success: function(data){
					
					if("error" in data) {
						var err = "";
						$.each(data["error"], function(key, value) {
							err += value + "<br>";
						});
						showalert(err ,"1");
						return false;
					}
					
					var op = $("#op").val();
					
					if(op == "get_dirs" || op == "get_vps") {
						$("#dir").empty();
						
						$("<option />")
								.val(0)
								.text("'.$l['select'].'")
								.appendTo("#dir");
						
						if(!empty(data["vps_backup_dir"]) && !data["directories"].includes(data["vps_backup_dir"])){
							data["directories"].push(data["vps_backup_dir"]);
						}
						
						$.each(data["directories"], function(key, dir) {
							$("<option />")
								.val(dir)
								.text(dir)
								.appendTo("#dir");
						});
						
						$("<option />")
								.val("other")
								.text("'.$l['other'].'")
								.appendTo("#dir");
								
						if($("#dir option").length == 2) {
							$("#dir").val("other").trigger("change");
						}
						
						$("#row_dir").show();
					}
					
					if(op == "get_backups" || op == "get_vps") {
						var selected = $("#date").val();
						
						$("#date").empty();
						
						var backups_list = [];
						if(empty(data["has_backuply"])){
							if(!empty(data["backup_list"])) {
								$.each(data["backup_list"], function(key, value) {
									var date_str = key.substr(0, 4) + "/" + key.substr(4, 2) + "/" + key.substr(6, 2);
									
									$("<option />")
										.val(key)
										.text(date_str)
										.appendTo("#date");
									
									if(!empty(value)) {
										selected = key;
										backups_list = value;
									}
								});
							}
							
							// Sort by date desc
							var sorted = $("#date option").sort(function(a, b) { return b.value - a.value });
							$("#date").html(sorted);
							
							if(!empty(selected)) {
								$("#date").val(selected);
							}
							
							if($("#date option").length > 0) {
								$("#row_date").show();
							}
						}
						
						$("#table_backup_list tbody").empty();
						
						if(empty(data["has_backuply"])){
							if(!empty(backups_list)) {
								populate_table(backups_list);
							}
							refresh_note();
						}else{
							backuply_set_backup(data["backup_list"]);
						}

					}
					
					if(op == "get_vps") {
						if(data["vps_backup_server"] == -1){
							data["vps_backup_server"] = 0;
						}
						$("#bid").val(data["vps_backup_server"]);
						$("#dir").val(data["vps_backup_dir"]);
					}
					
				},
				complete: function(data) {
					$("#progress_bar").hide();
				}
			});
			
			return false;
		});
		
		refresh_tasks();
		
		// Refresh tasks every 10 secs
		setInterval(refresh_tasks, 10000);
		
	});
		
	function populate_table(backups) {
		$.each(backups, function(key, value) {
			
			var file = value["abs_path"].split("/").pop();
			
			var matches = file.match(/^(\d+)/i);
			if(empty(matches)){
				var tmp_m1 = file.split(".");
				var tmp_m2 = tmp_m1[0].split("-");
				var vpsid = tmp_m2[2];
			}else{
				var vpsid = matches[1];
			}
			// var vpsid = file.substr(0, file.indexOf("."));
			
			var size = Math.round(value["size"] / 1024 / 1024) + " M";
			
			$temp = $(\'<tr><td align="center" class="td_name"></td> \
				<td align="center" class="td_size"></td> \
				<td align="center"><a href="#" onclick="return restore(this, 0)" title="'.$l['restore'].'"><h6><i class="fas fa-undo text-warning"></i></h6></a></td> \
				<td align="center"><a href="#" onclick="return restore_details(this)" title="'.$l['restore'].'"><h6><i class="fas fa-undo text-warning"></i></h6></a></td> \
				<td align="center"><a href="#" onclick="return Delbackup(this)" title="'.$l['delete'].'"><h6><i class="fas fa-trash text-danger"></i></h6></a></td> \
				<td width="20" valign="middle" align="center"> \
					<div class="custom-control custom-checkbox"> \
						<input type="checkbox" class="ios custom-control-input" id="vpsbackup_list\'+key+\'" name="vpsbackup_list[]"> \
						<label class="custom-control-label" for="vpsbackup_list\'+key+\'"></label> \
					</div> \
				</td> \
			</tr>\');
			
			$temp.attr("data-file", file);
			$temp.attr("data-vpsid", vpsid);
			$temp.find(".td_name").text(file);
			$temp.find(".td_size").text(size);
			
			$temp.appendTo("#table_backup_list tbody");
			
		});
	}

	function backuply_set_backup(data, i = 0){

		if(empty(data)){
			$("#backuply_div").hide();
			$("#no_backups").show();
			return false;
		}
		$("#backuply_div").show();
		$("#no_backups").hide();
		var table = `<table class="table table-hover border-0 backuply_table" width="100%" id="backuply_table_list`+i+`">
				<thead>
					<tr>
						<th style="width:220px;" data-orderable="false"></th>
						<th>'.VM_SHORT.'</th>
						<th>'.$l['files'].'</th>
						<th width="3%"></th>
						<th>'.$l['size'].'</th>
						<th>'.$l['backup_time'].'</th>
						<th>'.$l['api_actions'].'</th>
					</tr>
				</thead>
				<tbody>`;
		if(!empty(data)){

			$.each(data, (date, files) => {
				var size = parseFloat((files[\'size\']/1024/1024));
				var childrens_count = 1;
				if(!empty(files[\'children\'])){
					childrens_count = Object.keys(files[\'children\']).length + childrens_count;
				}
		
				var formattedTime = timeConverter(date)
				
				var formated_htime = files[\'htime\'].split(\'-\')
				formated_htime = formated_htime[0].replace(/_/g, \'/\')+\' \'+formated_htime[1].replace(/_/g, \':\');
				
				table += `<tr data-node-id="`+date+`" data-node-pid="`+date+`" data-vpsid="`+files[\'vpsid\']+`" data-file="`+basename(files[\'filepath\'])+`" data-time="`+date+`" data-htime="`+files[\'htime\']+`">
							<td>`+formattedTime+`<span class="badge p-1 badge-pill blue_btn ml-2">`+childrens_count+`</span></td>
							<td>`+files[\'vpsid\']+` (`+files[\'hostname\']+`)</td>
							<td>`+basename(files[\'filepath\'])+`</td>
							<td class="text-center"><span class="badge p-1 badge-pill blue_btn">full</span></td>
							<td>`+size.toFixed(2)+` MB</td>
							<td>`+formated_htime+`</td>
							<td class="text-center">
								<div class="row">
									<div class="col-4 px-1">
										<a href="javascript:void(0);" tooltip="'.$l['restore'].'" onclick="backuply_restore_bkup(\'`+files[\'htime\']+`\', \'`+date+`\')"><i class="fas fa-history restore-icon"></i></a>
									</div>
									<div class="col-4 px-1">
										<a href="javascript:void(0);" tooltip="'.$l['restore_new'].'" onclick="restore_details(this)"><i class="fas fa-history text-warning restore-icon"></i></a>
									</div>
									<div class="col-4 px-1">
										<a href="javascript:void(0);" tooltip="'.$l['delete'].'" onclick="backuply_delete_bkup(\'`+files[\'htime\']+`\', \'`+date+`\')"><i class="fas fa-trash text-danger"></i></a>
									</div>
								</div>
							</td>
						</tr>`;
				if(!empty(files[\'children\'])){
					$.each(files[\'children\'], (k, file) => {
						var size = parseFloat((file[\'size\']/1024/1024));
						var matches = basename(file[\'filepath\']).match(/^(\d+)/i);
						if(empty(matches)){
							var tmp_m1 = basename(file[\'filepath\']).split(".");
							var tmp_m2 = tmp_m1[0].split("-");
							var vpsid = tmp_m2[2];
						}else{
							var vpsid = matches[1];
						}
						var formated_htime = file[\'htime\'].split(\'-\')
						formated_htime = formated_htime[0].replace(/_/g, \'/\')+\' \'+formated_htime[1].replace(/_/g, \':\');
						table += `<tr data-node-pid="`+date+`" data-time="`+date+`" data-htime="`+file[\'htime\']+`" data-vpsid="`+files[\'vpsid\']+`" data-file="`+basename(file[\'filepath\'])+`">
									<td>`+formattedTime+`<span class="badge p-1 badge-pill blue_btn ml-2">`+childrens_count+`</span></td>
									<td>`+files[\'vpsid\']+` (`+files[\'hostname\']+`)</td>
									<td class="pl-4">`+basename(file[\'filepath\'])+`</td>
									<td class="text-center"><span class="badge p-1 badge-pill blue_btn">`+file[\'type\']+`</span></td>
									<td>`+size.toFixed(2)+` MB</td>
									<td>`+formated_htime+`</td>
									<td class="text-center">
										<div class="row">
											<div class="col-4 px-1">
												<a href="javascript:void(0);" tooltip="'.$l['restore'].'" onclick="backuply_restore_bkup(\'`+file[\'htime\']+`\', \'`+date+`\')"><i class="fas fa-history restore-icon"></i></a>
											</div>
											<div class="col-4 px-1">
												<a href="javascript:void(0);" tooltip="'.$l['restore_new'].'" onclick="restore_details(this)"><i class="fas fa-history text-warning restore-icon"></i></a>
											</div>
											<div class="col-4 px-1">
												<a href="javascript:void(0);" tooltip="'.$l['delete'].'" onclick="backuply_delete_bkup(\'`+file[\'htime\']+`\', \'`+date+`\')"><i class="fas fa-trash text-danger"></i></a>
											</div>
										</div>
									</td>
								</tr>`;
					})
				}
			})

		}
		table += `</tbody></table>`;
		$("#backuply_table_div").html(table);
		
		show_tooltip();
		var groupColumn = 0;
		var table_obj = $("#backuply_table_list"+i).DataTable({
			"columnDefs": [
				{ "visible": false, "targets": groupColumn },
				{ "orderable": false, "targets": -1 }
			],
			"order": [[ groupColumn, "desc" ]],
			"displayLength": 25,
			"drawCallback": function ( settings ) {
				let api = this.api();
				var rows = api.rows( {page:"current"} ).nodes();
				var last=null;
	
				api.column(groupColumn, {page:"current"} ).data().each( function ( group, i ) {
					
					if ( last !== group && !empty(group)) {
						
						$(rows).eq( i ).before(
							"<tr class=\"group\" data-node-id=\""+$(rows).eq( i ).attr(\'data-node-id\')+"\"><td colspan=\"6\">"+group+"</td></tr>"
						);
	
						if($(rows).eq( i ).prev().attr(\'data-node-id\') == $(rows).eq( i ).attr(\'data-node-id\')){
							$(rows).eq( i ).removeAttr(\'data-node-id\')
						}
						
						last = group;
					}
					
				});
			}
		});

		$(\'#backuply_table_list\'+i).simpleTreeTable({
			store: \'session\',
			storeKey: \'backuply_table_list\'+i
		});
		$(".backuply_table").parent().addClass("sticky scrollbar-virt").scrollbar();
	
	}

	function backuply_delete_bkup(time, chain){
		var backup_type = $("input[name=\"backup_type\"]:checked").val();
		if(backup_type != "use_backuply"){
			return false;
		}
		showalert("'.$l['del_conf'].'" ,"3" ,function(confirm){
			if(!confirm){
				return false;
			}else{
				var data = new Object();
				data["time"] = time;
				data["chain"] = chain;
				data["bid"] = $("#bid").val();
				data["dir"] = $("#other_dir:visible").val() || $("#dir:visible").val();
				
				$("#progress_bar").show();
				$.ajax({
					type: "POST",
					url: "'.$globals['index'].'act=vpsrestore&api=json&backuply_delete=1&use_backuply=1",
					dataType : "json",
					data: data,
					success:function(res){
						$("#progress_bar").hide();

						if("delete_done" in res){
							setTimeout(function(){
								// Remove all deleted rows
								$.each(backup_list, function(key, value) {
									$("tr[data-time=\'" + time + "\']").remove();
								});
								refresh_tasks();
								showalert("'.$l['done_delete'].'");
								$("#restore_form").trigger("submit");
							} ,200);
						}
						
						if("error" in res) {
							setTimeout(function(){
								var err = "";
								$.each(res["error"], function(key, value) {
									err += value + "<br>";
								});
								showalert(err ,"1");
								return false;
							} ,200);
						}
					}
				});
			}
		})
		
	
	}

	function backuply_restore_bkup(htime, chain){
		var backup_type = $("input[name=\"backup_type\"]:checked").val();
		if(backup_type != "use_backuply"){
			return false;
		}
		showalert("'.$l['conf_res'].'" ,"3" ,function(confirm){
			if(confirm == false){
				return false;
			}else{
				$("#progress_bar").show();
				var data = new Object();
				data["backup_file"] = htime;
				data["backup_date"] = chain;
				data["bid"] = $("#bid").val();
				data["dir"] = $("#other_dir:visible").val() || $("#dir:visible").val();
				$.ajax({
					type: "POST",
					url: "'.$globals['index'].'act=vpsrestore&api=json&backuply_restore=1&use_backuply=1",
					data: data,
					dataType : "json",
					success: function(data){
						$("#progress_bar").hide();
						if("restore_done" in data){
							animate_task("'.$l['restore_new_task'].'");
							setTimeout(function(){showalert("'.$l['done_restore'].'")}, 100);
							refresh_tasks();
						}
						if("error" in data) {
							setTimeout(function(){
								var err = "";
								$.each(data["error"], function(key, value) {
									err += value + "<br>";
								});
								showalert(err ,"1");
								return false;
							} ,200);
						}
					}
				});
			}
		})
	}
	
	function restore_new() {
		
		if(empty($("#hostname").val())) {
			showalert("'.$l['no_hostname'].'" ,"1");
			return false;
		}
		
		if(empty($("#uid").val())) {
			showalert("'.$l['no_uid'].'" ,"1");
			return false;
		}
		
		$("#progress_bar2").show();

		$.ajax({
			type: "POST",
			url: "'.$globals['index'].'act=vpsrestore&api=json",
			data: $("#restore_new_form").serialize(),
			dataType : "json",
			success: function(data){
				if("restore_done" in data) {
					animate_task("'.$l['restore_new_task'].'");
					showalert("'.$l['done_restore'].'");
					refresh_tasks();
				}
				
				if("error" in data) {
					var err = "";
					$.each(data["error"], function(key, value) {
						err += value + "<br>";
					});
					showalert(err ,"1");
					return false;
				}
				
				$("#common_modal").modal("hide");
			},
			complete: function(data) {
				$("#progress_bar2").hide();
			}
		});
		
		return false;
		
	}


	function update_ips(el){
		var serid = $(el).val();
		$("#ips_loader").show();
		$.ajax({
			type: "POST",
			url: "'.$globals['index'].'act=vpsrestore&api=json",
			data: {
				update_ips: serid,
			},
			dataType : "json",
			success: function(data){
				
				$("#ips_loader").hide();

				if("error" in data) {
					var err = "";
					$.each(data["error"], function(key, value) {
						err += value + "<br>";
					});
					showalert(err ,"1");
					return false;
				}

				ip_arr_list = new Array("ips", "ips_int", "ips6", "ips6_subnet");
				//ip_arr = new Array("ips", "ips6", "ips6_subnet", "ips_int");
				ips_opt_html = "";

				$.each(ip_arr_list, function(k, ip_key){

					if(ip_key == "ips" || ip_key == "ips_int"){ 
						$.each(data["updated_ips"]["ips_list"][ip_key], function(ipid, val){
							ips_opt_html += \'<option value="\'+data["updated_ips"]["ips_list"][ip_key][ipid]["ip"]+\'">\'+data["updated_ips"]["ips_list"][ip_key][ipid]["ip"]+\'</option>\';
							
						});
						
						$("."+ip_key+"_sel").empty().append(ips_opt_html);
					
						ips_opt_html = "";										
					}

					if(data["updated_ips"]["free_ips"][ip_key] < $("#"+ip_key+"_count").val() || empty(data["updated_ips"]["free_ips"][ip_key])){
						$("#"+ip_key+"_count").removeClass("text-muted");
						$("#"+ip_key+"_count").addClass("text-danger");
					}else{
						$("#"+ip_key+"_count").addClass("text-muted");
						$("#"+ip_key+"_count").removeClass("text-danger");
					}
					
					$("#"+ip_key+"_count").html(data["updated_ips"]["free_ips"][ip_key]+" '.$l['free'].'");

				});	
			
			}
		});
	}

	function restore_details(el){
		$("#progress_bar").show();
		
		var vpsid = $(el).closest("tr").data("vpsid");
		var file = $(el).closest("tr").data("file");
		var bid = $("#bid").val();
		var dir = $("#other_dir:visible").val() || $("#dir:visible").val();
		var date = $("#date").val();
		var htime = $(el).closest("tr").data("htime");
		var time = $(el).closest("tr").data("time");
		var use_backuply = ($("input[name=\"backup_type\"]:checked").val() == "use_backuply" ? 1 : 0);
		
		$.ajax({
			type: "POST",
			url: "'.$globals['index'].'act=vpsrestore&api=json",
			data: {
				restore_details: vpsid,
				bid: bid,
				dir: dir,
				date: date,
				htime: htime,
				use_backuply: use_backuply,
			},
			dataType : "json",
			success: function(data){
				if("error" in data) {
					var err = "";
					$.each(data["error"], function(key, value) {
						err += value + "<br>";
					});
					showalert(err ,"1");
					return false;
				}
				
				var restore_details = data["restore_details"];
				
				// Show the restore dialog
				var $modal_form = $(\'<form id="restore_new_form" action="" method="post" onsubmit="return restore_new()"> \
									<input type="hidden" id="restore" name="restore" value="1" /> \
									<input type="hidden" id="vpsid" name="vpsid" /> \
									<input type="hidden" id="bid2" name="bid" /> \
									<input type="hidden" id="dir2" name="dir" /> \
									<input type="hidden" id="file_name" name="file" /> \
									<input type="hidden" id="date2" name="date" /> \
									<input type="hidden" id="time" name="time" /> \
									<input type="hidden" id="htime" name="htime" /> \
									<input type="hidden" id="use_backuply" name="use_backuply" /> \
									<input type="hidden" id="newvps" name="newvps" value="1" /> \
									<div class="row mx-auto w-100 my-3"> \
										<div class="col-sm-3"> \
											<label class="control-label">'.$l['hostname'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['hostname_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label> \
										</div> \
										<div class="col-sm-9"> \
											<input type="text" class="form-control" name="hostname" id="hostname" size="30" value=""> \
										</div> \
									</div> \
									<div class="row mx-auto w-100 my-3"> \
										<div class="col-sm-3"> \
											<div class="d-flex align-items-center">\
												<label class="control-label">'.$l['select_user'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['select_user_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label>\
												<div class="loader ml-2" style="display:none;" id="ajax_user_loader"></div> \
											</div>\
										</div> \
										<div class="col-sm-9"> \
											<select class="virt-select" id="uid" name="uid"> \
												<option value="0">'.$l['select'].'</option> \
											</select> \
										</div> \
									</div> \
									<div class="row mx-auto w-100 my-3" id="os_div" style="display:none"> \
										<div class="col-sm-3"> \
											<label class="control-label">'.$l['select_os'].' &nbsp;<a class="info" data-placement="right" tooltip="'.$l['select_os_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label> \
										</div> \
										<div class="col-sm-9"> \
											<select class="virt-select" id="osid" name="osid"> \
												<option value="0">'.$l['select'].'</option> \
											</select> \
										</div> \
									</div> \
									<div class="row mx-auto w-100 my-3" id="iso_div" style="display:none"> \
										<div class="col-sm-3"> \
											<label class="control-label">'.$l['select_iso'].' &nbsp;<a class="info" data-placement="right" tooltip="'.$l['select_iso_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label> \
										</div> \
										<div class="col-sm-9"> \
											<select class="virt-select" id="iso" name="iso"> \
												<option value="0">'.$l['select'].'</option> \
											</select> \
										</div> \
									</div> \
									<div class="row mx-auto w-100 my-3" id="newserid_div"> \
										<div class="col-sm-3"> \
											<label class="control-label">'.$l['select_server'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['select_server_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label> \
										</div> \
										<div class="col-sm-9" id="newserid">\
											<select name="newserid" class="virt-select newserid" onchange="update_storage(this);update_ips(this);">\
												';
												foreach($servers as $k => $v){
													if($globals['server'] == $servers[$k]['serid']){
														$selected = 'selected="selected"';
													}else{
														$selected = '';
													}
													$multi_virt = str_replace(' ', '_', $servers[$k]['virt']);
													echo '<option class="'.(empty($selected) ? 'hide_option' : '').'" value = '.$servers[$k]['serid'].' data-virt='.$multi_virt.'  '.$selected.'>'.$servers[$k]['server_name'].' ('.$servers[$k]['ip'].')</option>\\';
												}
												echo'
											</select>\
										</div> \
										<div class="loader ml-2" style="display:none;" id="ips_loader"></div> \
									</div> \
									<div class="row mx-auto w-100 my-3" id="main_disk" style="display:none;"> \
										<div class="col-sm-3"> \
											<label class="control-label">'.$l['select_storage'].'&nbsp;<a class="info" data-placement="right" tooltip="'.$l['select_storage_exp'].'"><i class="fas text-primary fa-info-circle"></i></a></label> \
										</div> \
										<div class="col-sm-9" id="disks"></div> \
									</div> \
									<div id="ips_row"> \
									</div> \
									<div id="ips_list_row"> \
									</div> \
									<div class="row mx-auto w-100 my-3" id="os_check_note"> \
										<div class="col-sm-12 notice"> \
										<b> '.$l['note'].' : </b> \
										<span id="os_err_note"></span> \
										</div> \
									</div> \
									<div class="row mx-auto w-100"> \
										<div class="col-sm-12 text-center mb-3"> \
											<input class="go_btn" value="'.$l['restore'].'" type="submit"> \
										</div> \
									</div> \
									<div id="progress_bar2" style="display:none;"> \
										<br /> \
										<center> \
											<font id="progress_txt" size="4">'.$l['action_msg'].'</font> \
										</center> \
										<div class="my-2" align="center"> \
											<div class="progress w-50"> \
												<div class="progress-bar bg-primary progress-bar-striped progress-bar-animated w-100"> \
												</div> \
											</div> \
										</div> \
										<center> \
											'.$l['notify_msg'].' \
										</center> \
										<br>\
									</div> \
									<div class="row mx-auto w-100" id="os_notice" style="display:none;"> \
										<div class="col-sm-12 text-center mb-3"> \
											<div class="notice">'.$l['os_note'].'</div>\
										</div> \
									</div> \
								</form> \');
				
				// Set form date
				$modal_form.find("#vpsid").val(vpsid);
				$modal_form.find("#file_name").val(file);
				$modal_form.find("#bid2").val(bid);
				$modal_form.find("#dir2").val(dir);
				$modal_form.find("#date2").val(date);
				$modal_form.find("#htime").val(htime);
				$modal_form.find("#use_backuply").val(use_backuply);
				$modal_form.find("#time").val(time);
				$modal_form.find("#hostname").val(restore_details["hostname"]);
				if(restore_details["ignore_os_check"] != ""){
					$modal_form.find("#os_check_note").addClass("d-flex");
					$modal_form.find("#os_err_note").text(restore_details["ignore_os_check"]);
				}else{
					$modal_form.find("#os_check_note").addClass("d-none");
				}
				$modal_form.find(".newserid option").each(function(){
					if(!$(this).data("virt").includes(restore_details["vps_virt"])){
						$(this).remove();
					}
				});
				
				var storages_row = "";

				if(!empty(restore_details["disks"])){
					$modal_form.find("#main_disk").css("display", "");
				}
				
				if(!restore_details["bus_driver"]){

					storages_row += \'<div class="row mx-auto w-100 disk_row"> \
											<div class="col-sm-3 p-2"> \
												<label class="control-label disk-number"></label><br> \
												<span class="help-block disk-size"></span> \
											</div> \
											<div class="col-sm-2 p-2" id="size_div"> \
												<input class="form-control size" type="number" id="hdd_0" step="0.001" size="30"/> \
											</div> \
											<div class="col-sm-7 p-2" id="disk_div"> \
												<select class="custom-select st_uuid"> \ ';
													foreach($storages as $storage) {
														echo '<option value="'.$storage['st_uuid'].'">'.$storage['name'].'&nbsp;('.$storage['free'].' GB '.(empty($storage['oversell']) ? $l['free'] : $l['oversell_free']).')</option>';
													}
												echo '</select> \ ';
						
											echo '</div> \
										</div>\'; 
				}else{
					
					storages_row += \'<div class="row mx-auto w-100 disk_row"> \
						<div class="col-sm-3 p-0"> \
							<label class="control-label disk-number"></label><br> \
								<span class="help-block disk-size"></span> \
						</div> \
						<div class="col-sm-2 p-0" id="bus_driver_div"> \
							<span class="help-block bus_driver"></span> \
							</div> \
							<div class="col-sm-2 p-0" id="bus_driver_num_div">\
							<span class="help-block bus_driver_num"></span> \
							</div> \
								<div class="col-sm-2 p-1" id="size_div"> \
									<input class="form-control size" type="number" id="hdd_0" step="0.001" size="30"/> \
									</div> \
								<div class="col-sm-3 p-1"  id="disk_div"> \
								<select class="custom-select st_uuid"> \ ';
									foreach($storages as $storage) {
										echo '<option value="'.$storage['st_uuid'].'">'.$storage['name'].'&nbsp;('.$storage['free'].' GB '.(empty($storage['oversell']) ? $l['free'] : $l['oversell_free']).')</option>';
									}
								echo '</select> \
								</div> \
					</div> \
					</div>\'; 
				}
				
				$.each(restore_details["disks"], function(did, disk) {
					$row = $(storages_row).clone();
				
					$row.find(".disk-number").text("DISK "+(did+1));
					$row.find(".disk-size").text(disk["size"] + " GB");
					$row.find(".st_uuid").val(disk["st_uuid"]).attr("name", "st_uuid_" + did);
					$row.find(".size").val(disk["size"]).attr("name", "size_" + did);
					$row.find(".bus_driver").html("'.$l['bus_driver'].'<br>"+(disk["bus_driver"]));
					$row.find(".bus_driver_num").html("'.$l['bus_driver_num'].'<br>"+(disk["bus_driver_num"]));
					
					$modal_form.find("#disks").append($row);
				});

				var ip_lang = new Array();
				var ip_lang_ind = new Array();
				';
				
				$ip_arr = array('ips_int','ips','ips6_subnet','ips6');
				foreach($ip_arr as $ip_key){
					echo 'ip_lang["'.$ip_key.'"] = "'.$l[$ip_key].'";';
					echo 'ip_lang["'.$ip_key.'_exp"] = "'.$l[$ip_key.'_exp'].'";';
					if(in_array($ip_key, array('ips_int','ips'))){
						echo 'ip_lang_ind["'.$ip_key.'"] = "'.$l[$ip_key.'_ind'].'";';
						echo 'ip_lang_ind["'.$ip_key.'_exp"] = "'.$l[$ip_key.'_ind_exp'].'";';
					}
				}
				
				echo'
				ip_arr = new Array("ips", "ips_int", "ips6", "ips6_subnet");
				ip_html = "";
				$.each(ip_arr, function(k, ip_key){
					var txt_color = "text-muted";
					if(restore_details["free_ips"][ip_key] < restore_details["vps_ips"][ip_key] || empty(restore_details["free_ips"][ip_key])){
						txt_color = "text-danger";
					}
					ip_html += \'<div class="row mx-auto w-100 my-3">\
									<div class="col-sm-3"> \
										<label class="control-label">\'+ip_lang[ip_key]+\'&nbsp;<a class="info" data-placement="right" tooltip="\'+ip_lang[ip_key+"_exp"]+\'"><i class="fas text-primary fa-info-circle"></i></a></label> \
									</div> \
									<div class="col-sm-9" id="ips_div"> \
										<input type="text" name="num_\'+ip_key+\'" class="form-control" value="\'+restore_details["vps_ips"][ip_key]+\'"><span id="\'+ip_key+\'_count" class="\'+txt_color+\'">\'+restore_details["free_ips"][ip_key]+\' '.$l['free'].'</span>\
									</div>\
								</div>\';
					
				});	
				$modal_form.find("#ips_row").html(ip_html);

				ip_arr_list = new Array("ips", "ips_int");
				ips_list_html = "";
				ips_opt_html = "";

				$.each(ip_arr_list, function(k, ip_key){
					
					if(!empty(restore_details["ips_list"][ip_key])){


						$.each(restore_details["ips_list"][ip_key], function(ipid, val){
							ips_opt_html += \'<option value="\'+restore_details["ips_list"][ip_key][ipid]["ip"]+\'">\'+restore_details["ips_list"][ip_key][ipid]["ip"]+\'</option>\';
								
						});

						ips_list_html += \'<div class="row mx-auto w-100 my-3">\
												<div class="col-sm-3"> \
													<label class="control-label">\'+ip_lang_ind[ip_key]+\'&nbsp;<a class="info" data-placement="right" tooltip="\'+ip_lang_ind[ip_key+"_exp"]+\'"><i class="fas text-primary fa-info-circle"></i></a></label> \
												</div> \
												<div class="col-sm-9" id="disk_div"> \
													<select class="\'+ip_key+"_sel"+\' custom-select"  name="\'+ip_key+"[]"+\'" multiple="multiple"> \'+ips_opt_html+\' </select> \
												</div>\
											</div>\';

								
						
						ips_opt_html = "";										
					}

				});	

				$modal_form.find("#ips_list_row").html(ips_list_html);

				var $select = $modal_form.find("#uid");
				
				$.each(restore_details["users"], function(uid, email) {
					var $option = $("<option />").val(uid)
						.text(email);
					
					if(uid == restore_details["uid"]) {
						$option.attr("selected", true);
					}
					
					$option.appendTo($select);
				});

				if(!empty(restore_details["os"])){
					$modal_form.find("#os_div").css("display", "");
					$modal_form.find("#os_notice").css("display", "");
					var $select = $modal_form.find("#osid");
				
					$.each(restore_details["os"], function(distro, oses) {
							$.each(oses, function(k, v){
								var $option = $("<option />").val(k)
								.text(v["name"]);
							
							$option.appendTo($select);
						});
					});
				}

				if(!empty(restore_details["iso"])){
					$modal_form.find("#iso_div").css("display", "");
					$modal_form.find("#os_notice").css("display", "");
					var $select = $modal_form.find("#iso");
					
					$.each(restore_details["iso"], function(k, v){
						var $option = $("<option />").val(k)
						.text(v["name"]);
					
						$option.appendTo($select);
					});
				}
				
				// Show dialog for user select
				$("#common_modal").modal("show");
				$("#common_modal .fhead").text("'.$l['restore_new'].'");
				$("#common_modal_body").css("padding", "10px");
				$("#common_modal_body").html($modal_form);
				
				update_storage($modal_form.find(".newserid"));
				$(".virt-select, .ips_sel, .ips_int_sel").select2({
					width:"100%"
				});
				show_tooltip();
				//ajax user handling 
				load_ajax_user("uid", "'.$globals['index'].'act=vpsrestore&api=json&load_ajax_user=1");
			},
			complete: function(data) {
				$("#progress_bar").hide();
			}
		});
		
		return false;
	}

	function update_storage(el){
		var serid = $(el).val();
		var ui_new_storage = "";
		$.ajax({
			type: "POST",
			url: "'.$globals['index'].'act=vpsrestore&api=json",
			data: {
				update_storage: serid,
			},
			dataType : "json",
			success: function(data){
				var newstorage = data["newstorage"];
				ui_new_storage = "<select class=\"custom-select st_uuid\">";
				$.each(newstorage, function(k, v) {
					$.each(v, function(k, v){
						var label = "";
						if(empty(v["oversell"])){
							label="'.$l['free'].'";
						}else{
							label="";
						}
						ui_new_storage +="<option value="+v["st_uuid"]+">"+v["name"]+"&nbsp;("+v["free"]+" GB "+label+")";
					});
				});
				ui_new_storage += "</select>";
				var i = -1;
				$(".disk_row").each(function(){
					i++;
					$(this).find("#disk_div").html(ui_new_storage);
					$(this).find("#disk_div").find(".st_uuid").attr("name","st_uuid_"+i);
				});
			}
		});
	}
	
	function restore(el) {
		var vpsid = $(el).closest("tr").data("vpsid");
		var file = $(el).closest("tr").data("file");
		var bid = $("#bid").val();
		var dir = $("#other_dir:visible").val() || $("#dir:visible").val();
		var date = $("#date").val();
		
		showalert("'.$l['conf_res'].'" ,"3" ,function(confirm){
			if(confirm == false){
				return false;
			}else{
				$("#progress_bar").show();
		
		
				$.ajax({
					type: "POST",
					url: "'.$globals['index'].'act=vpsrestore&api=json",
					data: {
						restore: 1,
						vpsid: vpsid,
						file: file,
						bid: bid,
						dir: dir,
						date: date
					},
					dataType : "json",
					success: function(data){
						if("restore_done" in data) {
							animate_task("'.$l['restore_task'].'");
							setTimeout(function(){showalert("'.$l['done_restore'].'");
							refresh_tasks();} ,200);
						}
						
						if("error" in data) {
							
							setTimeout(function(){
								var err = "";
								$.each(data["error"], function(key, value) {
									err += value + "<br>";
								});
								showalert(err ,"1");
								return false;} ,200);
						}
					},
					complete: function(data) {
						$("#progress_bar").hide();
					}
				});
			}
		});
		
		return false;
	}
	
	function Delbackup(el){
		
		// List of ids to delete
		var backup_list = new Array();
		
		if(!el){
			
			if($("#backup_task_select").val() != 1){
				showalert("'.$l['no_action'].'" ,"1");
				return false;
			}
			
			$(".ios:checked").each(function() {
				backup_list.push($(this).closest("tr").data("file"));
			});
			
		}else{
			
			backup_list.push($(el).closest("tr").data("file"));
			
		}
		
		if(backup_list.length < 1){
			showalert("'.$l['nothing_selected'].'" ,"1");
			return false;
		}
		
		showalert("'.$l['del_conf'].'" ,"3" ,function(confirm){
			if(confirm == false){
				return false;
			}else{
				$("#progress_bar").show();
		
				$.ajax({
					type: "POST",
					url: "'.$globals['index'].'act=vpsrestore&api=json",
					data : {
						delete: backup_list.join(","),
						bid: $("#bid").val(),
						dir: $("#other_dir:visible").val() || $("#dir:visible").val(),
						date: $("#date").val(),
					},
					dataType : "json",
					success: function(data){
						if("delete_done" in data){
							
							
							setTimeout(function(){
								// Remove all deleted rows
								$.each(backup_list, function(key, value) {
									$("tr[data-file=\'" + value + "\']").remove();
								});
							refresh_tasks();
							showalert("'.$l['done_delete'].'");} ,200);
						}
						
						if("error" in data) {
							
							setTimeout(function(){
								var err = "";
								$.each(data["error"], function(key, value) {
									err += value + "<br>";
								});
								showalert(err ,"1");
								return false;} ,200);
						}
					},
					complete: function() {
						$("#progress_bar").hide();
					}
				});
			}
		});

		return false;
	}
	
	function refresh_note() {
		// Show note if no backups found
		if($("#table_backup_list tbody tr").length > 0) {
			$("#backup_list").show();
			$(".notice").hide();
		} else {
			$("#backup_list").hide();
			
			$(".notice span").text("'.$l['no_backup_found'].'");
			$(".notice").show();
		}
	}
	
	function refresh_tasks() {
		var cols = new Object();
		cols["actid"] = {"l" : "'.$l['actid'].'", width: 60 ,"centered" : true};
		cols["vpsid"] = {"l" : "'.$l['vpsid'].'", width: 60, "centered" : true};
		cols["user"] = {"l" : "'.$l['user'].'", "centered" : true};
		cols["server"] = {"l" : "'.$l['server'].' '.'('.$l['id'].')", "centered" : true};
		cols["started"] = {"l" : "'.$l['started'].'", width: 100, "centered" : true};
		cols["updated"] = {"l" : "'.$l['updated'].'", width: 100, "centered" : true};
		cols["ended"] = {"l" : "'.$l['ended'].'", width: 100, "centered" : true};
		cols["action_txt"] = {"l" : "'.$l['action'].'", width: 100};
		cols["status_txt"] = {"l" : "'.$l['status'].'", width: 200};
		cols["progress"] = {"l" : "'.$l['progress'].'"};
		cols["logs"] = {"l" : "'.$l['logs'].'", width: 80, "centered" : true};
		
		$.ajax({
			type: "GET",
			url: "'.$globals['index'].'act=tasks&action=restorevps_plan,backuply_restorevps_plan&api=json&page=0&reslen=20",
			dataType : "json",
			success: function(data){
				
				if(empty(data["tasks"])) {
					// Show no tasks note if table empty
					$("#table_tasks_container").html("<div class=\"notice\"><b>'.$l['note'].' : </b> &nbsp; '.$l['no_tasks'].'</div>");
					return;
				}
				
				var rows = Array();
				
				$.each(data["tasks"], function(k, task) {
					
					rows[k] = new Object();
					rows[k]["actid"] = task["actid"];
					rows[k]["vpsid"] = task["vpsid"];
					rows[k]["user"] = empty(task["uid"]) ? "root" : task["email"];
					rows[k]["server"] = task["server_name"] + "(" + task["serid"] + ")";
					rows[k]["started"] = task["started"];
					rows[k]["updated"] = task["updated"];
					rows[k]["ended"] = task["ended"];
					rows[k]["action_txt"] = task["action_txt"];
					rows[k]["status_txt"] = task["status_txt"];
					rows[k]["progress"] = "<div class=\"progress-cont\" id=\"progress-cont"+task["actid"]+"\"><center><div class\"text-center h6\" id=\"pbar"+task["actid"]+"\">"+task["progress"]+"%</center><div class=\"progress\"><div class=\"progress-bar bg-primary progress-bar-striped progress-bar-animated\" id=\"progressbar"+task["actid"]+"\"></div></div>";
					rows[k]["logs"] = "<button class=\"btn px-2 py-1\" onclick=\"loadlogs("+task["actid"]+");\">'.$l['show'].'</button>";
					
				});
				
				rows.sort(function(a, b){
					a = parseInt(a["actid"]);
					b = parseInt(b["actid"]);
					if(a < b) return 1;
					if(a > b) return -1;
					return 0;
				});
				
				table({"id" : "table_tasks_container", "tid" : "table_tasks", "width" : "100%"}, cols, rows);
				
				$.each(data["tasks"], function(index, task) {
					
					if(task["progress"] == 100){
						$("#status"+index).text("'.$l['completed'].'");
						$("#pbar"+index).text("100% '.$l['completed'].' !");
						$("#progressbar"+index).hide();
						$("#progressbar"+index).parent().css("border", "0px");
						$("#progressbar"+index).parent().removeClass("progress");
					}else if(task["status"] == -1){
						$("#status"+index).html(task["status_txt"]);
						$("#pbar"+index).text("'.$l['task_notcomplete'].'");
						$("#progressbar"+index).hide();
						$("#progressbar"+index).parent().css("border", "0px");
						$("#progressbar"+index).parent().removeClass("progress");
					}else {
						if(isNaN(task["progress"])){
							$("#pbar"+index).text(task["progress"]);
							$("#progressbar"+index).hide();
						}else{
							make_progress(index, Number(task["progress"]));
							$("#progressbar"+index).show();
						}
					}
					
				});
				
			}
		});
		
	}

	function make_progress(index, progress){
		var steps = 20;
		var start = $("#pbar"+index).text();
		start = (start.slice(0, -1));
		if(isNaN(start)){
			start = 0;
		}
		var step = (progress - start)/steps;
		if(step < 0){ step = 0;}
		var increment = function(){
			var val = $("#pbar"+index).text();
			val = Number(val.slice(0, - 1));
			prog = parseInt(val + Math.round(step));
			//alert("progr"+prog);
			if(prog > progress){ prog = progress;}
			if(prog < parseInt("100")){
				$("#pbar"+index).text(prog + "%");
				$("#progressbar"+index).width(prog + "%");
			}else{
				$("#progressbar"+index).width(100 + "%");
			}
			if (prog < progress){setTimeout(increment, 500);}
		};
		increment();
	}

	</script>
	
	<style type="text/css">

	.panel {
		min-height: 120px;
	}
	.panel-content {
		max-height: 400px;
		overflow: hidden;
	}
	.panel.panel-blue-grey {
		border-color: #607D8B;
	}
	.panel.panel-blue-grey .panel-heading {
		background-color: #607D8B;
		border-color: #607D8B;
		color: #fff;
	}
	.table-dash {
		margin-bottom: 4px;
	}
	.table-dash tbody tr td {
		vertical-align: middle;
	}
	.table-dash tr td:first-child, .table-dash tr th:first-child {
		padding-left: 16px;
	}
	.table-dash tr td:last-child, .table-dash tr th:last-child {
		padding-right: 16px;
	}
	.btn-logs {
		margin: 0;
		padding: 4px 8px;
		font-size: 12px;
	}
	#table_tasks_container table thead th{
		position:sticky;
		top:0px;
		padding:10px 5px !important;
	}

	</style>';

	echo '

	<form id="restore_form" name="restore_form">
	<div class="card p-5 m-3">
		<input type="hidden" id="op" name="op" value="" />
		<input type="hidden" id="dir_input" name="dir" value="" />
		<div class="row mx-auto w-100">
			<div class="col-sm-6 p-0">';		
			server_select();
			echo'
			</div>
			<div class="col-sm-1 my-0 d-flex align-items-center justify-content-center">
			</div>
				<div class="col-sm-5 d-flex align-items-center">
					<div class="row mx-auto w-100">
						<div class="col-sm-6 p-0">
							<label class="custom-control custom-radio">
								<input type="radio" class="custom-control-input" name="backup_type" id="backup_type" value="use_backuply" '.(has_plugin_license('backuply') ? 'checked="checked"' : '').'>
								<span class="custom-control-label">Use Backuply Backups</span>
							</label>
						</div>
						<div class="col-sm-6 p-0">
							<label class="custom-control custom-radio">
								<input type="radio" class="custom-control-input" name="backup_type" id="backup_type" value="use_normal_backup">
								<span class="custom-control-label">Use Normal Backups</span>
							</label>
						</div>
					</div>
				</div>
		</div>
		<div class="row mx-auto w-100 my-0 mb-3">
			<div class="col-sm-6">		
				<label class="control-label">'.$l['select_vps'].'</label><br><select class="virt-select" name="vpsid" id="vps">
					<option value="0" selected="selected">'.$l['select'].'</option>';
					foreach($vpses as $vpsid => $vps) {
						echo '<option value="'.$vpsid.'">[VID: '.$vps['vps_name'].'] [ID: '.$vpsid.'] ['.$vps['hostname'].']</option>';
					}
				echo '</select>
			</div>
			<div class="col-sm-1 my-0 d-flex align-items-center justify-content-center">
				<label class="control-label mt-3">'.$l['or'].'</label>
			</div>
			<div class="col-sm-5">		
				<label class="control-label my-0">'.$l['select_bkp_server'].'</label><br><select class="virt-select" name="bid" id="bid">
					<option value="-1" selected="selected">'.$l['select'].'</option>
					<option value="0">'.$l['local'].'</option>';
						
					foreach($backup_servers as $bid => $bs) {
						echo '<option value="'.$bid.'">'.$bs['name'].' ('.$bs['hostname'].')</option>';
					}
					
				echo '</select>
			</div>
		</div>
			
		<div class="row mx-auto w-100 my-0 mb-3" id="row_dir" style="display:none">
			<div class="col-sm-12">		
				<label class="control-label">'.$l['select_dir'].'</label><br><select class="custom-select" id="dir">
					<option value="0" selected="selected">'.$l['select'].'</option>
				</select>
			</div>
		</div>

		<div class="row mx-auto w-100 my-3 mt-4" id="row_other_dir" style="display:none">
			<div class="col-sm-12">
				<div class="input-group">
					<input id="other_dir" type="text" class="form-control rounded">&nbsp;
					<span class="input-group-btn">
						<button id="scan" class="btn btn-default px-2 py-1" type="button">'.$l['scan'].'</button>
					</span>
				</div>
			</div>
		</div>
		
		<div class="row mx-auto w-100 my-3" id="row_date" style="display:none">
			<div class="col-sm-12">		
				<label class="control-label">'.$l['select_date'].'</label><br><select class="custom-select" name="date" id="date"></select>
			</div>
		</div>
	</form>
	
	<div id="backup_list" style="display:none;">
		<div class="w-100 mx-auto sticky">
			<table id="table_backup_list" class="table table-hover tablesorter" width="90%" cellspacing="1" cellpadding="8" border="0" align="center">
				<thead>
					<tr>
						<th align="center">'.$l['name'].'</th>
						<th width="100px" align="center">'.$l['size'].'</th>
						<th class="min_width" align="center">'.$l['restore'].'</th>
						<th width="140" align="center">'.$l['restore_new'].'</th>
						<th class="min_width" align="center">'.$l['delete'].'</th>
						<th class="z-index-1 min_width" align="center">
							'.get_checkbox('select_all', '', 'select_all', array('chk_it' => 0), '', 'select_all').'
						</th>
					</tr>
				</thead>
				<tbody></tbody>
			</table>
		</div>
		<div class="row mx-auto w-100 mt-5">
			<div class="col-sm-8 col-lg-8 col-md-6 mb-3 p-0">
			</div>
			<div class="col-sm-4 col-lg-4 col-md-6 text-right mb-3">
				<div class="bottom-menu float-right w-100">
					<div class="row my-auto">
						<div class="p-0">
							<label>'.$l['with_selected'].'</label>
						</div>
						<div class="col p-0">
							<select name="backup_task_select" class="custom-select" id="backup_task_select">
								<option value="0">---</option>
								<option value="1">'.$l['ms_delete'].'</option>
							</select>
						</div>
						<div class="pl-2">
							<button type="submit" class="go_btn" id="backup_submit" name="backup_submit" onclick="Delbackup(); return false;">'.$l['go'].'</button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>	
	<div class="row mx-auto w-100 " id="backuply_div" style="display:none;">
		<div class="col-sm-12" id="backuply_table_div">
		</div>
	</div>
	<div id="no_backups" class="notice" style="display:none"><b>NOTE : </b>&nbsp;<span>'.$l['no_backup_found'].'</span></div>

	<div id="progress_bar" style="display:none;">
		<br />
		<center>
			<font id="progress_txt" size="4">'.$l['action_msg'].'</font>
		</center>
		<div class="my-2" align="center">
			<div class="progress w-50">
				<div class="progress-bar bg-primary progress-bar-striped progress-bar-animated w-100">
				</div>
			</div>
		</div>
		<center>
			'.$l['notify_msg'].'
		</center>
	</div>
</div>
	<div class="row mx-auto w-100 px-3">
		<div class="col-sm-12 p-0">
			<div id="panel-tasks" class="">
				<div class="panel-heading p-3">
					<span class="h5">'.$l['list_tasks'].'</span>
					<i class="icon icon-tasks float-left h5 m-0"></i>
				</div>
				<div class="panel-content scrollbar-virt">
					<div id="table_tasks_container"><center><br><br><div class="loader-lg"></div></center></div>
				</div>
			</div>
		</div>
	</div>
	';

}// End of Server Offline if	

echo '</div>';
softfooter();

}

?>