<?php

//////////////////////////////////////////////////////////////
//===========================================================
// performance_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function performance_theme(){

global $theme, $globals, $cluster, $user, $l, $perfomance, $disk_health, $hypervisor, $servers, $disks, $supported, $binary_count, $binaries_not_found, $filter_ps_cpu, $filter_ps_ram, $crons, $disk_io, $interfaces_speeds, $ram_specs, $cpu_specs, $disks_df, $disks_inodes, $month;
$show_no_table = 0;
$no_data = 0;


// Is AJAX mode on
if(optGET('ajax')){	
	echo 'cpu_plot('.$perfomance['cpu'].'); ram_plot('.$perfomance['ram'].'); load_process_list('.json_encode($filter_ps_ram).',"ram"); load_process_list('.json_encode($filter_ps_cpu).',"cpu");load_binary_list('.json_encode($binaries_not_found).', '.$binary_count.'); load_cron_list('.json_encode($crons).'); load_diskio_list('.json_encode($disk_io).'); show_the_name("'.$perfomance['cpu_model'].'","'.$perfomance['cpu'].'","'.$perfomance['ram'].'");';
	return true;
}

if(optGET('network_stats')){
	echo'actual_plot('.$interfaces_speeds.',"'.$globals['interface'].'" )'; ;
	return true;
}
// AJAX mode End
softheader($l['<title>']."  BETA");

//Server_monitoring css start
echo '
<style type="text/css">
.skeleton-loader-background {
width: 70%;
height: 15px;
display: block;
background:2rgb(219,215,210);
border-radius: 3px;
margin-bottom:3px;
}

.skeleton-loader-gradient {
width: 20%;
border-radius: 3px;
height: 15px;
margin-bottom:3px;
display: block;
background: linear-gradient(
to right,
rgba(255, 255, 255, 0),
rgba(255, 255, 255, 0.5) 50%,
rgba(255, 255, 255, 0) 80%
),
rgb(219,215,210);
background-repeat: repeat-y;
background-size: 50px 200px;
background-position: 0 0;
}

.skeleton-loader {
width: 80%;
height: 15px;
border-radius: 3px;
display: block;
margin-bottom:3px;
background: linear-gradient(
to right,
rgba(255, 255, 255, 0),
rgba(255, 255, 255, 0.5) 50%,
rgba(255, 255, 255, 0) 80%
),
rgb(219,215,210);
background-repeat: repeat-y;
background-size: 50px 500px;
background-position: 0 0;
animation: shine 1s infinite;
}

.txt-overflow {
white-space: nowrap; 
width: 300; 
overflow: hidden;
text-overflow: ellipsis;
}
@keyframes shine {
to {
background-position: 100% 0, 0 0;
}
}
.card-footer {
padding: 0.85rem 1.25rem;
background-color: rgb(255,255,255);
border-top: 1px solid rgba(0,0,0,.125);
}

</style>
<script src="'.$theme['url'].'/js/chart.js"> </script>
<div class="bg">
	<div class="row my-3 mx-auto">
		<div class="col-10">
			<h4 class="text-dark"><i class="fas fa-heartbeat"></i> '.$l['<title>'].' [BETA]</h4>
		</div>
		<div class="col-2 text-right d-flex align-items-center justify-content-end">
			<span class="icon-fix d-flex align-items-center justify-content-center"><a href="'.$globals['docs'].'Performance" target="_blank" tooltip="'.$l['wiki_help'].'"><i class="fas fa-question text-always-white" ></i></a></span>
		</div>
	</div>';
	// Tittle ends

	//smartmontool support start
	if(empty($supported)){
		$show_no_table = 1;
		echo '
	<form id="performanceform"  accept-charset="'.$globals['charset'].'" action="" method="post" name="performance" class="form-horizontal">
		<div class="col-sm-12 notice">
			Oops! Looks like your OS does not support smartmontool utility or smartmontools utility is missing.
		</div>
	</form>';
	}
	//smartmontool support ends

	// Is it offline ?
	$hypervisor_status = $cluster->statewise($globals['server']);
	if($hypervisor_status == 0 || $hypervisor_status == 2){
		show_alert($l['server_status_'.$hypervisor_status] ,"1");
		echo '
	<div class="e_notice"><b>NOTE: </b>&nbsp; '.$l['server_status_'.$hypervisor_status].'</div>';
	}else{
	//Procced with page
		echo'
	<script> 
		var hddtable 	= ``;
		var ssdtable 	= ``;
		var nvmetable 	= ``;
		var fdisktable 	= ``;
	</script>

	<!-- Big 3 Cards Start here -->

	<div class="card-deck row mx-auto w-100">
		<div class="card border-light mb-3 col-sm-4 ">
			<div class="card-body px-0">
				<div class="row">
					<div class="col-sm-8">
						<h5 class="text-dark"><i class="fas fa-microchip"></i>&nbsp;'.$l['cpu'].'</h5>
					</div>
					<div class="col-sm-4 text-right">
						<h5 class="skeleton-loader text-right text-admin" id="cpu_percentage"></h5>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-8">
						<div class="skeleton-loader mb-1 txt-overflow" id="cpu_id"></div>
					</div>
					<div class="col-sm-4 text-right cursor-pointer" onclick="$(\'#process_cpuspec_modal\').modal();"><span class="text-primary">'.$l['data'].'</span>
						 <i class="text-primary fas fa-info-circle"></i>
					</div>
				</div>
					<hr>
					<canvas id="cpuholder" width="359" height="300"></canvas>
			</div>
			<div class="card-footer">
			<p class="px-3 cursor-pointer" id="list_process_cpu"> <span class="text-admin" >'.$l['list_process'].' :</span>'.$l['consuming'].' '.$l['cpu'].'</p>		
			</div>
		</div>
		<div class="card border-light mb-3 col-sm-4 ">
			<div class="card-body px-0">
				<h5 class="text-dark"><i class="fas fa-server"></i>&nbsp;'.$l['node_info'].'</h5>
				<div class="mb-4" id="server_info" style="width: 300px; height: 343px;">
					<div>&nbsp;</div>
					<hr>
					<p class="px-3"><span class="text-admin">'.$l['os'].'</span>: '.$servers[$globals['server']]['os'].'</p>
					<p class="px-3 cursor-pointer" id ="list_binary"> <span class="text-admin" >'.$l['binaries'].' </span>: <span id="binary_count">'.(!empty($binary_count) ?  $binary_count.' " " '.$l['binaries_miss'].' <span style="color:red"><i class="fas 	fa-exclamation-triangle"></i></span>' : ''.$l['binaries_no_miss'].' <span style="color:green"><i class="fas fa-check-circle"></i></span>').'</p>
					<p class="px-3 cursor-pointer" id="cron_list"> <span class="text-admin" >'.$l['scripts'].': </span>'.$l['active_cron_process'].'</p>
					<p class="px-3 cursor-pointer" id="diskio_list"> <span class="text-admin" >'.$l['diskio'] .': </span>'.$l['diskio_exp'].'</p>
					<p class="px-3 cursor-pointer" id="graph_list"><span class="text-admin">'.$l['ntw_graphs'].': </span>'.$l['ntw_graphs_exp'].'</p>
				</div>
			</div>
			<div class="card-footer">
			<p class="px-3 text-black"><span class="text-admin" >'.$l['hostname'].' : </span>'.$servers[$globals['server']]['server_name'].'</p>
			</div>
		</div>

		<div class="card border-light mb-3 col-sm-4 ">
			<div class="card-body px-0">
				
				<div class="row">
					<div class="col-sm-8">
						<h5 class="text-dark"><i class="fas fa-memory"></i>&nbsp;'.$l['ram'].'</h5>
					</div>
					<div class="col-sm-4">
						<h5 class="skeleton-loader text-right text-admin" id="ram_percentage"></h5>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-8">
						<p class="text-muted">
						'.$l['total_ram'].' : '.round(($servers[$globals['server']]['total_ram']) / 1024).'GB
						</p>
					</div>
					<div class="col-sm-4 text-right cursor-pointer"><span class="text-primary" onclick="$(\'#process_ramspec_modal\').modal();">'.$l['data'].'</span>
						<i class="px-1 text-primary fas fa-info-circle"></i>
					</div>
				</div>
				<hr>
				<canvas id="ramholder" width="359" height="300"></canvas>
			</div>
			<div class="card-footer style="background-color: white;">
			<p class="px-3 cursor-pointer" id="list_process_ram"> <span class="text-admin" >'.$l['list_process'].' :</span>'.$l['consuming'].' '.$l['ram'].'</p>
			</div>
		</div>
	</div>

	<!-- Big 3 Cards ends here -->

	<hr>';
 
	echo '
	<!-- Storage size cards start here -->

	<h5 class="px-3 mt-4 text-dark"><i class="fas fa-hdd"></i>&nbsp;Storage Size</h5>
	<div class="row w-100 mt-2 mx-2">';
		foreach($disks_df as $k => $v){
			if(!empty($k)){
				echo '
				<div class="col-sm-3">
					<div class="card border-light  mb-4">
						<div class="card-body">
							<h6 class="text-monospace card-title txt-overflow" tooltip="'.$k.'">'.$k.'</h6>
							<div class="row">
								<div class="col-6">
									<p class="card-text">Size : '.$v['limit_gb'].' GB</p>
									<p class="card-text">Utilized : '.$v['used_gb'].' GB</p>
								</div>
								<div class="col-6 text-right">
									<h3 class="text-primary">'.$v['percent'].'%</h3>
								</div>
							</div>
							<div class="progress mt-1"  style="height: 5px;">
								<div class="progress-bar bg-admin" role="progressbar" style="width: '.$v['percent'].'%;" aria-valuenow="'.$v['percent'].'" aria-valuemin="0" aria-valuemax="100">
								</div>
							</div>
						</div>
					</div>
				</div>
				';
			}
		}

	echo'
	</div>
	<!-- Storage size cards ends here -->

	<hr>
	';
	// Disk Panel Ends

	// Disk Ionodes
	echo '
	<!-- Storage Ionodes cards start here -->

	<h5 class="px-3  mt-4 text-dark"><i class="fas fa-hdd"></i>&nbsp;Storage Inodes</h5>
	<div class="row w-100 mt-2 mx-2">';
		foreach($disks_inodes as $k => $v){
			if(!empty($k)){
				echo '
				<div class="col-sm-3">
					<div class="card border-light  mb-4">
						<div class="card-body">
							<h6 class="text-monospace card-title txt-overflow tooltip="'.$k.'" ">'.$k.'</h6>
							<div class="row">
								<div class="col-6">
									<p class="card-text">Limit : '.$v['limit'].'</p>
									<p class="card-text">Used : '.$v['used'].'</p>
								</div>
								<div class="col-6 text-right">
									<h3 class="text-primary">'.$v['percent'].'%</h3>
								</div>
							</div>
							<div class="progress mt-1"  style="height: 5px;">
								<div class="progress-bar bg-admin" role="progressbar" style="width: '.$v['percent'].'%;" aria-valuenow="'.$v['percent'].'" aria-valuemin="0" aria-valuemax="100">
								</div>
							</div>
						</div>
					</div>
				</div>	
				';
			}
		}

	echo'
	</div>
	<!-- Storage Ionodes cards ends here -->

	<hr>
	';
	// Disk Inodes Ends

	////Disk health creator 
	if(empty($show_no_table)){
		echo '
		<!-- Smartmontool header starts here -->

		<div class="mt-4 mb-4" id="hddmain" style="display:none">
			<h5 class="px-3 text-dark"><i class="fas fa-hdd"></i>&nbsp;'.$l['hdd_header'].'</h5>  
			<div class ="px-2 w-100 mx-auto sticky">
				<table class="table table-hover tablesorter  border-light" id="hddtable"> </table>
			</div>
		</div>
		<div class="mt-4 mb-4" id="ssdmain" style="display:none">
			<h5 class="px-3 text-dark"><i class="fas fa-hdd"></i>&nbsp;'.$l['ssd_header'].'</h5>  
			<div class ="px-2 w-100 mx-auto sticky">
				<table class="table table-hover tablesorter  border-light" id="ssdtable"> </table>
			</div>
		</div>
		<div class="mt-4 mb-4" id="nvmemain" style="display:none">
			<h5 class="px-3 text-dark"><i class="fas fa-hdd"></i>&nbsp;'.$l['nvme_header'].'</h5>  
			<div class ="px-2 w-100 mx-auto sticky">
				<table class="table table-hover tablesorter  border-light" id="nvmetable"> </table>
			</div>
		</div>
		<div class="mt-4 mb-4" id="fdiskmain" style="display:none">
			<h5 class="px-3 text-dark"><i class="fas fa-hdd"></i>&nbsp;'.$l['virtual_header'].'</h5>  
			<div class ="px-2 w-100 mx-auto sticky">
				<table class="table table-hover tablesorter  border-light" id="fdisktable"> </table>
			</div>
		</div>

		<!-- SSmartmontool header ends here -->
		';
		
		//Disk health creator 
		foreach($disk_health as $disk_numer => $smartctl_values){
			if(array_key_exists("ata_smart_attributes", $disk_health[$disk_numer]) & !empty($smartctl_values['rotation_rate'])){
				echo '
		<script>
			hddtable += `
					<tr>
						<td>Smartctl</td>
						<td>'.(!empty($hypervisor) ? $hypervisor : $smartctl_values['model_family']).'</td>
						<td>'.(empty($smartctl_values['serial_number']) ? "NA" : $smartctl_values['serial_number']).'</td>
						<td>'.$smartctl_values['logical_block_size'].'</td>
						<td>'.(empty($smartctl_values['rotation_rate']) ? "NA" : $smartctl_values['rotation_rate']).'</td>
						<td>'.(empty($smartctl_values['sata_version']['string']) ? "NA" : $smartctl_values['sata_version']['string']).'</td>
						<td>'.(empty($smartctl_values['interface_speed']['current']['string']) ? "NA" : $smartctl_values['interface_speed']['current']['string']).'</td>
						<td>'.(empty($smartctl_values['user_capacity']['bytes']) ? "NA" : round(($smartctl_values['user_capacity']['bytes']/1000000000000),2)).' TB</td><td>`;
					';
				foreach($smartctl_values['ata_smart_attributes']['table'] as $k => $v){
					if($v['name'] == 'Temperature_Celsius'){
						if(strlen($v['raw']['value']) > 3){
							echo ' 
			hddtable += ` '.$v['raw']['string'].'°C ` ';
								
						}else{
							echo ' 
			hddtable += ` '.$v['raw']['value'].'°C ` ';
						}
							break;
					}
				}
			echo '
			hddtable += `</td>
					<td>'.(empty($smartctl_values['smart_status']['passed']) ? "NA" : (($smartctl_values['smart_status']['passed'] == 1) ? '<span style="color:green"><i class="fas fa-check-circle"></i></span>' : '<span style="color:red"><i class="fas fa-exclamation-triangle"></i></span>' )).'</td>
					</tr>`;
		</script>
					';
			}
			else if(array_key_exists("nvme_smart_health_information_log", $disk_health[$disk_numer])){
				echo '
		<script>
		
			nvmetable += `
					<tr>
						<td>Smartctl</td>
						<td>'.(!empty($smartctl_values['model_name']) ? $smartctl_values['model_name'] : 'NA').'</td>
						<td>'.(empty($smartctl_values['serial_number']) ? "NA" : $smartctl_values['serial_number']).'</td>
						<td>'.(!empty($smartctl_values['logical_block_size']) ? $smartctl_values['logical_block_size'] : 'NA').'</td>
						<td>'.(!empty($smartctl_values['firmware_version']) ? $smartctl_values['firmware_version'] : 'NA').'</td>
						<td>'.(empty($smartctl_values['user_capacity']['bytes']) ? "NA" : round(($smartctl_values['user_capacity']['bytes']/1000000000000),2)).' TB</td>
						<td>'.(empty($smartctl_values['temperature']) ? "NA" : $smartctl_values['temperature']['current'].' °C').'</td>
						<td>'.(empty($smartctl_values['smart_status']['passed']) ? "NA" : (($smartctl_values['smart_status']['passed'] == 1) ? '<span style="color:green"><i class="fas fa-check-circle"></i></span>' : '<span style="color:red"><i class="fas fa-exclamation-triangle"></i></span>' )).'</td>
					</tr>`;
		</script>';	
			}
			else if(array_key_exists("ata_smart_attributes", $disk_health[$disk_numer]) && !empty($smartctl_values['firmware_version']) && !empty($smartctl_values['sata_version']['string'])){
				echo '
		<script>
			ssdtable += `
					<tr>
						<td>Smartctl</td>
						<td>'.(!empty($hypervisor) ? $hypervisor : $smartctl_values['model_name']).'</td>
						<td>'.(empty($smartctl_values['serial_number']) ? "NA" : $smartctl_values['serial_number']).'</td>
						<td>'.$smartctl_values['logical_block_size'].'</td>
						<td>'.(empty($smartctl_values['firmware_version']) ? "NA" : $smartctl_values['firmware_version']).'</td>
						<td>'.(empty($smartctl_values['sata_version']['string']) ? "NA" : $smartctl_values['sata_version']['string']).'</td>
						<td>'.(empty($smartctl_values['interface_speed']['current']['string']) ? "NA" : $smartctl_values['interface_speed']['current']['string']).'</td>
						<td>'.(empty($smartctl_values['user_capacity']['bytes']) ? "NA" : round(($smartctl_values['user_capacity']['bytes']/1000000000000),2)).' TB</td>
						<td>'.(empty($smartctl_values['temperature']['current']) ? "NA" : $smartctl_values['temperature']['current'].' °C').'</td>
						<td>'.(empty($smartctl_values['smart_status']['passed']) ? "NA" : (($smartctl_values['smart_status']['passed'] == 1) ? '<span style="color:green"><i class="fas fa-check-circle"></i></span>' : '<span style="color:red"><i class="fas fa-exclamation-triangle"></i></span>' )).'</td>
					</tr>`;
		</script>
				';
			}
			else{
				$no_data = 1;
				break;
			}
		}
	}
	//Disk health creator ends

	//Disk creator for non smartctl and non hypervisor
	if(!empty($no_data)){
		foreach($disks as $disk_num => $disk_info){
			echo '
			<script>
			fdisktable +=`
				<tr>
					<td>Fdisk</td>
					<td>'.(!empty($hypervisor) ? $hypervisor : "Virtual").'</td>
					<td>'.(!empty($disk_info['1']) ? substr($disk_info['1'],0,strlen($disk_info['1'])-1) : "NA").'</td>
					<td>NA</td>
					<td>NA</td>
					<td>NA</td>
					<td>NA</td>
					<td>'.round(($disk_info['4']/1000000000000),2).' TB</td>
					<td>NA</td>
					<td>NA</td>
				</tr> `;
			</script>
			';
		}
	}
	//Disk creator for non smartctl and non hypervisor ends

    echo '
	<!-- Binary modal initializor -->

	<div class="modal fade" id="binaries_modal">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.$l['binaries'].'</span>
					<span class="spinner-grow spinner-grow-sm"></span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
					<strong>'.$l['note'].': </strong>'.$l['missing_binary_note'].'
					</div>
					<div id="binary_display"></div>
				</div>
			</div>
		</div>
	</div>

	<!-- Binary modal ends -->

	<!-- Ram modal initializor -->
	<div class="modal fade" id="process_ram_modal">
		<div class="modal-dialog modal-xl">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title"> '.$l['consuming'] ." ".$l['ram'].' </span>
					<span class="spinner-grow spinner-grow-sm"></span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
						<strong>'.$l['note'].': </strong>'.$l['ram_note'] .'
					</div>
					<div id="process_ram_display"></div>
				</div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="process_ramspec_modal">
		<div class="modal-dialog modal-xl">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.$l['ram_details'].'</span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div id="ramspec_display"></div>
				</div>
			</div>
		</div>
	</div>

	<!-- Ram modal ends -->

	<!-- Cpu modal initializor -->

	<div class="modal fade" id="process_cpu_modal">
		<div class="modal-dialog modal-xl">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.$l['consuming'] ." ". $l['cpu'].' </span>
					<span class="spinner-grow spinner-grow-sm"></span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
						<strong>'.$l['note'].': </strong>'.$l['cpu_note'].'
					</div>
					<div id="process_cpu_display"></div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="process_cpuspec_modal">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.$l['cpu_details_exp'].'</span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div id="cpuspec_display"></div>
				</div>
			</div>
		</div>
	</div>

	<!-- Cpu modal ends -->

	<!-- DiskIO modal initializor -->

	<div class="modal fade" id="diskio_modal">
		<div class="modal-dialog modal-xl">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.$l['diskio'].'</span>
					<span class="spinner-grow spinner-grow-sm"></span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
						<strong>'.$l['note'].': </strong>'.$l['disk_note'].'
					</div>
					<div id="diskio_display"></div>
					<div id="diskio_help"></div>
				</div>
			</div>
		</div>
	</div>
	
	<!-- DiskIO modal ends -->

	<!-- Script modal initializor -->

	<div class="modal fade" id="cron_modal">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.$l['scripts'].'</span>
					<span class="spinner-grow spinner-grow-sm"></span>
						<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
						<strong>'.$l['note'].': </strong>'.$l['script_note'].'
					</div>
					<div id="cron_display"></div>
				</div>
			</div>
		</div>
	</div>

	<!-- Script modal ends -->

	<!-- Graph modal initializor -->

	<div class="modal fade" id="graph_modal">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header d-flex align-items-center">
					<span class="modal-title">'.$l['ntw_graphs'].'</span>
					<span class="spinner-grow spinner-grow-sm"></span>
					<button type="button" class="close text-always-white" data-dismiss="modal">&times;</button>
				</div>
				<div class="modal-body">
					<div class="alert alert-info alert-dismissible fade show">
						<strong>'.$l['note'].': </strong>'.$l['graph_note'].'
					</div>
					<div id="graph_display">
						<div class="card border-light  text-center">
							<div class="card-body">
								<h5 class="card-title">'.(empty($globals['interface']) ? "eth0" : $globals['interface']).'</h5>
								<h6 class="card-subtitle mb-2 text-muted">Network Speed : <span id="nw_speed_live"></span></h6>
							</div>
							<div id="nw_speed_chartLegend"></div>
							<canvas id="network_speed_holder1" class="p-3" width="350" height="300"></canvas>
						</div>
						<hr>
						<div id="table_interface"></div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<!-- Graph modal ends -->
	';

	// Javascript Functions Starts
echo '
	<script language="javascript" type="text/javascript">
    
	function makedata(data,time=""){
		
		var fdata = [];
		i = 0;
		
		if(!empty(time)){
			for(i = 1; i < 13; i++){
				fdata.push(i*5);
			}
			return fdata.reverse();
		}else{
			for (x in data){
				fdata.push([data[x]][0]);
			}	
			return fdata;
		}	

	}
	
	//DiskIO more info div

	var diskio_help = `<div class="card border-light ">
	<div class="card-header">
	  	'.$l['info'].'
	</div>
	<div class="card-body">
	  	<p>'.$l['devices'].'<br>
	  		<span>'.$l['devices_exp'].'</span></br></p>
		<p>'.$l['tps'].'<br>
			<span>'.$l['tps_exp'].'</span><br></p>
		<p>'.$l['mbs'].'<br> 
			<span>'.$l['mbs_exp'].'</span></br></p>
		<p>'.$l['mbws'].'<br>
			<span>'.$l['mbws_exp'].'</span></br></p>
		<p>'.$l['read'].'<br>
			<span>'.$l['read_exp'].'</span></br></p>
		<p>'.$l['mbw'].'<br>
			<span>'.$l['mbw_exp'].'</span></br></p>
	</div>`;

	//DiskIO more info div ends
	
	//Ajax Calls
	getusagebandwidth();
	
    function _update(re) {
		if(re.length > 0){
			try{
				eval(re);
			}catch(e){ }
		}
    }
	
	function _update_network(re){
		
		if(re.length > 0){
			try{
				eval(re);
			}catch(e){ }
		}
	}
	function getusage(){
		if(AJAX("'.$globals['index'].'act=performance&ajax=true", "_update(re)")){
			return false;
		}else{
			return true;	
		}
	};

	function getnetworkinterface(){
		
		var act1 = "'.$globals['index'].'act=performance&network_stats=true";
		if(AJAX(act1, "_update_network(re)")){
			return false;
		}else{
			return true;
		}
	};

	function getusagebandwidth(selected_data=""){
		
		var act = "'.$globals['index'].'act=bandwidth&show="+selected_data+"&api=json";
		if(AJAX(act, "_updatebw(re)")){
			return false;
		}else{
			return true;	
		}
	};

	function startusage(){
		ajaxtimer = setInterval("getusage()", 5000);
		ajaxtimer = setInterval("getnetworkinterface()", 5000);
		_update("");
		getnetworkinterface();
	};

	var bwdays = [];
	var bw_usage = [];
	var bw_in = [];
	var bw_out = [];

	function _updatebw(re){
		var bw_ajax = JSON.parse(re);
		bwdays = bw_ajax["bandwidth"]["mdays"];
		bw_usage = makedata(bw_ajax["bandwidth"]["usage"]);
		bw_in = makedata(bw_ajax["bandwidth"]["in"]["usage"]);
		bw_out = makedata(bw_ajax["bandwidth"]["out"]["usage"]);
		plot_bandwidth_data(bw_usage,bwdays,bw_in,bw_out);
		
	}

	function plot_bandwidth_data(bw_usage,bwdays,bw_in,bw_out){
		var bwc = document.getElementById("bwholder");
		var bwctx = bwc.getContext("2d");

		var bwgradient = bwctx.createLinearGradient(0, 0, 0, 400);
		var bwgradient1 = bwctx.createLinearGradient(0, 0, 0, 400);

		bwgradient.addColorStop(0, "rgba(250,174,50,1)");   
		bwgradient.addColorStop(1, "rgba(250,174,50,0)");

		bwgradient1.addColorStop(0, "rgba(103,119,239,1)");
		bwgradient1.addColorStop(1, "rgba(250,174,50,0)");

		/* Bandwidth initialize starts */

		const bw_data = {
			labels: bwdays,
			datasets: [{
			label: "Bandwidth Total",
			data: bw_usage,
			fill: false,
			borderWidth: "2",
			borderColor: "black",
			tension: 0.1
			},			
			{type: "line",
					label: "Bandwidth IN",
					fill: true,
					borderWidth: "2",
					backgroundColor: bwgradient1,
					borderColor: "#515dbc",
					strokeColor : "#515dbc",
					pointColor : "#fff",
					pointStrokeColor : "#515dbc",
					pointHighlightFill: "#fff",
					pointHighlightStroke: "#515dbc",
					data: bw_in},
			{type: "line",
					label: "Bandwidth OUT",
					borderWidth: "2",
					backgroundColor: bwgradient,
					borderColor: "#ff6c23",
					strokeColor : "#ff6c23",
					pointColor : "#fff",
					pointStrokeColor : "#ff6c23",
					pointHighlightFill: "#fff",
					pointHighlightStroke: "#ff6c23",
					data: bw_out}
			]
			
		};

		const bw_config = {
			type: "line",
			data: bw_data,
			options : {
				scales: {
					x: {
						title: {
							display: true,
							text: "Days"
						}
					},
					y: {
						display: true,
						min:0,
						ticks: {
							beginAtZero: true,
							callback: function(value, index, values) {
								return (value/1024).toFixed(2) + \'GB\';
							}
						},
					}
				},
				plugins: {
					tooltip: {
						callbacks: {
							label: function(tooltipItem) {
								return tooltipItem.dataset.label+" : "+ ((tooltipItem.parsed.y)/1024).toFixed(2) + "GB";
							},
							title: function(tooltipItem) {
								console.log(tooltipItem[0].label);
								return "Day : "+ tooltipItem[0].label;
							}
						}
					}
				}
			}
		};

		const bw_ctx = document.getElementById("bwholder");
		const bwChart = new Chart(bw_ctx, bw_config );
		/* Bandwidth initialize ends */

	}
	
	function ram_info_plotter(rams){
		var ram_plot = "";
		ram_plot += `<div class="row mx-auto w-100">`;
		if(!empty(rams)){
			$.each(rams, function(dimm, dimmval){
				ram_plot += `
					
					<div class="col-sm-3 mb-2">
						<div class="card border-light " style="width-100">
							<div class="card-body">
								<h5 class="card-title text-admin">${dimmval["Manufacturer"]}</h5>
								<p class="card-text text-muted font-weight-bold">${dimmval["Type"]}</p>
							</div>
							<ul class="list-group list-group-flush">
								<li class="list-group-item">
									<div class="row">
										<div class="col-12">
										Speed : 
										</div>
										<div class="col-12">
										${dimmval["Speed"]}
										</div>
									</div>
								</li>
								<li class="list-group-item">
									<div class="row">
										<div class="col-12">
										Size : 
										</div>
										<div class="col-12">
										${dimmval["Size"]}
										</div>
									</div>
								</li>
								<li class="list-group-item">
									<div class="row">
										<div class="col-12">
										Location : 
									</div>
									<div class="col-12">
									${dimmval["Bank Locator"]}
									</div>
									</div>
								</li>
							</ul>
							<div class="card-body">
								<div class=row>
									<div class="col-6">
										Voltage:
									</div>
									<div class="col-6">
										Serial Number:
									</div>
									<div class="col-6">
										${dimmval["Configured Voltage"]}
									</div>
									<div class="col-6">
										${dimmval["Serial Number"]}
									</div>
								</div>
							</div>
						</div>
					</div>
				`;
			})
			ram_plot += `</div>`;
		}else{
			ram_plot = `<div class="alert alert-danger alert-dismissible fade show">
			'.$l['error_message'].'
			</div>`;
		}
		$("#ramspec_display").html(ram_plot);
	}

	function show_the_name(val,cpercent,rpercent){
		if(!empty(val)){
			$("#cpu_id").html(val);
			$("#cpu_id").removeClass("skeleton-loader");
			$("#cpu_id").addClass("text-muted");
			$("#cpu_percentage").html(cpercent+"%");
			$("#cpu_percentage").removeClass("skeleton-loader");
			$("#ram_percentage").html(rpercent+"%");
			$("#ram_percentage").removeClass("skeleton-loader");
			

		}else{
			$("#cpu_id").html("NA");
			$("#cpu_id").removeClass("skeleton-loader");
		}
	}

    startusage();
	show_cpu_spec('.json_encode($cpu_specs).');
	ram_info_plotter('.json_encode($ram_specs).');
	
	//Ajax Call ends


	//binary list

	function load_binary_list(binary_not_found, binary_count){
		if(!empty(binary_count)){
			var display_binary = `<table class= "table table-hover tablesorter ">`;
			var count_msg = (!empty(binary_count) ?  binary_count+\' '.$l['binaries_miss'].'<span style="color:red"><i class="fas fa-exclamation-triangle"></i></span>\' : 
			\' '.$l['binaries_no_miss'].' <span style="color:green"><i class="fas fa-check-circle"></i></span>\');
			$("#binary_count").html(count_msg);
			$.each(binary_not_found, function(k, val){
				display_binary += `<tr> 
					<td> ${val} </td>
					</tr>
					`;
			})
			display_binary += `</table>`;
		}else{
			var display_binary = `<p align="center"> No binaries are missing </p>`
		}
		
		$("#binary_display").html(display_binary);
	}

	// binary lsit ends

	//cpu modal

	function show_cpu_spec(cpuarr){
		if(!empty(cpuarr)){
			const cpucards = ["Architecture", "Model name", "L1i cache", "L2 cache","L3 cache","Thread(s) per core"];
			var cpu_image = "";
			if("Model name" in cpuarr){
				if(cpuarr["Model name"].match(/Intel/)){
					cpu_image = "'.$theme['images'].'/svgset/intel.svg";
				}else{
					cpu_image = "'.$theme['images'].'/svgset/amd.svg";
				}
			}else{
				cpuarr["Model name"] = "NA";
			}

			var cpucard = "";
			cpucard += `<div class="row">`; 
			cpucard += `
			<div class="col-sm-6 mb-2">
				<div class="card border-light ">
					<div class="card-body">
			`;


			$.each(cpuarr, function(cpuparam , cpuval){
				cpucard += `		
					<h6 class="card-title">${cpuparam}</h6>
					<p class="card-text">${cpuval}</p>
					`;
			})

			if(!("CPU MHz" in cpuarr)){
				cpuarr["CPU MHz"] = "NA";
			}
			
			cpucard += `</div>
					</div>
				</div>`;

			cpucard += `
						<div class="col-sm-6 mb-2">
							<div class="card border-light ">
								<div class="card-body col-sm-8">
									<img class="card-img-top" src="${cpu_image}">
								</div>
								<div class="card-body">
									<h5 class="card-title">${cpuarr["Model name"]}</h5>
									<p class="card-text">Architecture : ${cpuarr["Architecture"]}</p>
								</div>
								<ul class="list-group list-group-flush">
									<li class="list-group-item">CPU Frequency : ${cpuarr["CPU MHz"].substring(0, 4)} MHz</li>
									<li class="list-group-item">L1 Cache : ${cpuarr["L1i cache"]}</li>
									<li class="list-group-item">L2 Cache : ${cpuarr["L2 cache"]}</li>
									<li class="list-group-item">L3 Cache : ${cpuarr["L3 cache"]}</li>
								</ul>
								<div class="card-body">
									<span class="text-admin">Cores : ${cpuarr["Core(s) per socket"]}</a>
									<span class="px-3 text-admin">Thread : ${cpuarr["CPU(s)"]}</a>
								</div>
							</div>
						</div>
			`;
			$("#cpuspec_display").html(cpucard);
		}else{
			cpucard = `<div class="alert alert-danger alert-dismissible fade show">
			'.$l['error_message'].'
			</div>`;
			$("#cpuspec_display").html(cpucard);
		}
	}

	//cpu modal ends

	//process list modal

	function load_process_list(filter_ps, hardware){

			var display_process = `<table class= "table table-hover tablesorter ">
			<tr>
			<th>'.$l['pid'].'</th>
			<th>'.$l['ppid'].'</th>
			<th>'.$l['mem'].'</th>
			<th>'.$l['cpu'].'</th>
			<th>'.$l['cmd'].'</th>
			</tr>
			`;
		
			$.each(filter_ps, function(k, val){
				display_process += `<tr> 
					<td> ${val["1"]} </td>
					<td> ${val["2"]} </td>
					<td> ${val["3"]}% </td>
					<td> ${val["4"]}%</td>
					<td><span class="text-monospace">${val["5"]} </span></td>
					</tr>
					`;
			})
			if(hardware == "ram"){
				display_process += `</table>`;
				$("#process_ram_display").html(display_process);
			}else{
				display_process += `</table>`;
				$("#process_cpu_display").html(display_process);
			}
		
	}
	//process list modal ends

	//script load stats

	function load_cron_list(crons){
		var display_cron = `<table class= "table table-hover tablesorter ">
		<tr>
		<th>'.$l['cronname'].'</th>
		<th>'.$l['elapsedtime'].'</th>
		<th>'.$l['pid'].'</th>
		</tr>
		`;
		
		$.each(crons, function(k, val){
			display_cron += `<tr> 
				<td> ${k} </td>
				<td> ${val["active"]} </td>
				<td> ${val["pid"]} </td>
				</tr>
				`;
		})
		display_cron += `</table>`;
		$("#cron_display").html(display_cron);
	}

	// Script load stats ends

	//defined variable for network graph plot
	var max_height = 10;

	//Graph plot code starts here

	function cpu_plot(cpu_data){
		cpu_used_data = cpu_used_data.slice(1);
		cpu_used_data.push(cpu_data);
		CpuChart.data.datasets[0].data = cpu_used_data;
		CpuChart.update();  
	}

	function ram_plot(ram_data){
		ram_used_data = ram_used_data.slice(1);
		ram_used_data.push(ram_data);
		ramChart.data.datasets[0].data = ram_used_data;
		ramChart.update();  
	}

	function actual_plot(speed_data, ginterface){

		var plot_table = `<table class= "table table-hover tablesorter ">
		<tr>
		<th>'.$l['interfacename'].'</th>
		<th>'.$l['interfaceup'].'</th>
		<th>'.$l['interfacedwn'].'</th>
		</tr>`;
		// Slice the top
		
		if(empty(ginterface)){
			ginterface = "eth0";
		}
		
		$.each(speed_data, function(interface , speed){
			
			if(interface == ginterface){
				
				down_speed = down_speed.slice(1);
				up_speed = up_speed.slice(1);
				total_speed = (speed["download"] + speed["upload"]);
				down_speed.push(speed["download"] * 8);
				up_speed.push(speed["upload"] * 8);
				down_speed_data = makedata(down_speed);
				up_speed_data = makedata(up_speed);
				if(total_speed > max_height){
					max_height = total_speed;
					myChart.options.scales.y[0].ticks.max = (total_speed * 8);
				}
				myChart.data.datasets[0].data = down_speed_data;
				myChart.data.datasets[1].data = up_speed_data;
				myChart.update();

				$("#nw_speed_live").html(((speed["download"] * 8) + (speed["upload"] * 8)).toFixed(2)+" MB/s");
			}else{

				plot_table += `<tr> 
								<td> ${interface} </td>
								<td> ${speed["upload"]} MB/s </td>
								<td> ${speed["download"]} MB/s </td>
								</tr>`;
				
			}
		})
		
			plot_table += `</table>`;
			$("#table_interface").html(plot_table);
	}
	
	var total_speed = [];
	var down_speed = [];
	var up_speed = [];
	var cpu_used = [];
	var ram_used = [];

	var totalPoints = 12;
	for (var i = 0; i < totalPoints; ++i) {
		down_speed.push(0);
		up_speed.push(0);
		cpu_used.push(0);
		ram_used.push(0);
	}

	var down_speed_data = makedata(down_speed);
	var up_speed_data = makedata(up_speed);
	var cpu_used_data = makedata(cpu_used);
	var ram_used_data = makedata(ram_used);
	var timescale = makedata(total_speed,"time");

	/* Network speed initialize starts */
	var netc = document.getElementById("network_speed_holder1");
	var netctx = netc.getContext("2d");
	
	var gradient = netctx.createLinearGradient(0, 0, 0, 400);
	var gradient1 = netctx.createLinearGradient(0, 0, 0, 400);
	
	gradient.addColorStop(0, "rgba(250,174,50,1)");   
	gradient.addColorStop(1, "rgba(250,174,50,0)");
	
	gradient1.addColorStop(0, "rgba(103,119,239,1)");
	gradient1.addColorStop(1, "rgba(250,174,50,0)");

	const data = {
	labels: timescale,
  	datasets: [{
		
		label: "Bandwidth IN",
		data: down_speed_data,
		fill: true,
		borderWidth: "2",
		backgroundColor: gradient1,
		borderColor: "#515dbc",
		strokeColor : "#515dbc",
		pointColor : "#fff",
		pointStrokeColor : "#515dbc",
		pointHighlightFill: "#fff",
		pointHighlightStroke: "#515dbc",
		tension: 0.3
		},{
		label: "Bandwidth OUT",
		data: up_speed_data,
		fill: true,
		borderWidth: "2",
		backgroundColor: gradient,
		borderColor: "#ff6c23",
		strokeColor : "#ff6c23",
		pointColor : "#fff",
		pointStrokeColor : "#ff6c23",
		pointHighlightFill: "#fff",
		pointHighlightStroke: "#ff6c23",
		tension: 0.3
	}]
};

const config = {
	type: "line",
	data: data,
	options:{
		scales:{
			x: {
				title:{
					display: true,
					text: "In Seconds"
				}
			},
			y: {
				display: true,
				min:0,
				ticks: {
					callback: function(value, index, values) {
						return  value.toFixed(2) + \'MB/s\';
					}
				},
			}
		}
  	}
};

const ctx = document.getElementById("network_speed_holder1");
const myChart = new Chart(ctx, config );

/* Network speed initialize ends */

/* CPU initialize starts */
var cpuc = document.getElementById("cpuholder");
var cpuctx = cpuc.getContext("2d");

var cpugradient = cpuctx.createLinearGradient(0, 0, 0, 400);

cpugradient.addColorStop(0, "rgba(103,119,239,1)");
cpugradient.addColorStop(1, "rgba(250,174,50,0)");

const cpu_data = {
	labels: timescale,
	datasets: [{
		label: "CPU Usage in %",
		data: cpu_used_data,
		fill: true,
		borderWidth: "2",
		backgroundColor: cpugradient,
		borderColor: "#515dbc",
		strokeColor : "#515dbc",
		pointColor : "#fff",
		pointStrokeColor : "#515dbc",
		pointHighlightFill: "#fff",
		pointHighlightStroke: "#515dbc",
		tension: 0.3
	}]
};

const cpu_config = {
	type: "line",
	data: cpu_data,
	options : {
		scales: {
		  x: {
			title: {
			  display: true,
			  text: "In Seconds"
			}
		  },
		  y: {
			display: true,
			min:0,
			ticks: {
				beginAtZero: true,
				steps: 10,
				callback: function(value, index, values) {
					return  value + \'%\';
				}
			}
		  }
		} 
	}
  };

const cpu_ctx = document.getElementById("cpuholder");
const CpuChart = new Chart(cpu_ctx, cpu_config );

/* CPU initialize ends */

/* RAM initialize starts */
var ramc = document.getElementById("ramholder");
var ramctx = ramc.getContext("2d");

var ramgradient = ramctx.createLinearGradient(0, 0, 0, 400);

ramgradient.addColorStop(0, "rgba(250,174,50,1)");   
ramgradient.addColorStop(1, "rgba(250,174,50,0)");

const ram_data = {
	labels: timescale,
	datasets: [{
		label: "RAM Usage in %",
		data: ram_used_data,
		fill: true,
		borderWidth: "2",
		backgroundColor: ramgradient,
		borderColor: "#ff6c23",
		strokeColor : "#ff6c23",
		pointColor : "#fff",
		pointStrokeColor : "#ff6c23",
		pointHighlightFill: "#fff",
		pointHighlightStroke: "#ff6c23",
		tension: 0.3
	}],
	
};

const ram_config = {
	type: "line",
	data: ram_data,
	options : {
		scales: {
			x: {
				title: {
					display: true,
					text: "In Seconds"
				}
			},
			y: {
				display: true,
				min:0,
				ticks: {
					beginAtZero: true,
					steps: 10,
					callback: function(value, index, values) {
						return  value + \'%\';
					}
				}
			}
		}
	}
  };
 
const ram_ctx = document.getElementById("ramholder");
const ramChart = new Chart(ram_ctx, ram_config );

/* RAM initialize ends */	
	function load_diskio_list(diskio){
		var display_diskio = `<table class= "table table-hover tablesorter ">
		<tr>
		<th>'.$l['devices'].'</th>
		<th>'.$l['tps'].'</th>
		<th>'.$l['mbs'].'</th>
		<th>'.$l['mbws'].'</th>
		<th>'.$l['read'].'</th>
		<th>'.$l['mbw'].'</th>
		</tr>
		`;
		$.each(diskio, function(k, val){
			display_diskio += `<tr> 
				<td> ${(empty(val["0"]) ? 0 : val["0"])} </td>
				<td> ${(empty(val["1"]) ? 0 : val["1"])} </td>
				<td> ${(empty(val["2"]) ? 0 : val["2"])}mbps </td>
				<td> ${(empty(val["3"]) ? 0 : val["3"])}mbps </td>
				<td> ${(empty(val["4"]) ? 0 : val["4"])} MB </td>
				<td> ${(empty(val["5"]) ? 0 : val["5"])} MB </td>
				</tr>
				`;
		})
		display_diskio += `</table>`;
		$("#diskio_display").html(display_diskio);
	}

	$(document).ready(function(){
		$("#list_process_ram").click(function(){
			$("#process_ram_modal").modal();
		})
		$("#list_process_cpu").click(function(){
			$("#process_cpu_modal").modal();
		})
		$("#list_binary").click(function(){
			$("#binaries_modal").modal();
		})
		$("#cron_list").click(function(){
			$("#cron_modal").modal();
		})
		$("#graph_list").click(function(){
			$("#graph_modal").modal();
		})
		$("#diskio_list").click(function(){
			$("#diskio_modal").modal();
		})

		$("#diskio_help").html(diskio_help);
		$("#hddmain").hide();
		$("#ssdmain").hide();
		$("#nvmemain").hide();
		$("#fdiskmain").hide();

		if(!empty(fdisktable) && empty(hddtable) &&  empty(nvmetable) &&  empty(ssdtable)){
			fdisktable = `
				<thead>
				<tr>
					<th>'.$l['utility'].'</th>
					<th>'.$l['model_family'].'</th>
					<th>'.$l['serial_number'].'</th>
					<th>'.$l['lblock'].'</th>
					<th>'.$l['rrate'].'</th>
					<th>'.$l['satav'].'</th>
					<th>'.$l['interfacespeed'].'</th>
					<th>'.$l['size'].'</th>
					<th>'.$l['temp'].'</th>
					<th>'.$l['pass'].'</th>
				</tr>
			</thead>
		<tbody>`+fdisktable;

			fdisktable += `</tbody>` ;

			$("#fdisktable").html(fdisktable);
			$("#fdiskmain").show();
		}

		if(!empty(hddtable)){
			hddtable = `
					<thead>
					<tr>
						<th>'.$l['utility'].'</th>
						<th>'.$l['model_family'].'</th>
						<th>'.$l['serial_number'].'</th>
						<th>'.$l['lblock'].'</th>
						<th>'.$l['rrate'].'</th>
						<th>'.$l['satav'].'</th>
						<th>'.$l['interfacespeed'].'</th>
						<th>'.$l['size'].'</th>
						<th>'.$l['temp'].'</th>
						<th>'.$l['pass'].'</th>
					</tr>
				</thead>
				<tbody>
			`+hddtable;
			hddtable += `</tbody>` ;
			$("#hddtable").html(hddtable);
			$("#hddmain").show();
		}

		if(!empty(nvmetable)){
			nvmetable = `
			<thead>
			<tr>
				<th>'.$l['utility'].'</th>
				<th>'.$l['model_family'].'</th>
				<th>'.$l['serial_number'].'</th>
				<th>'.$l['lblock'].'</th>
				<th>'.$l['firmwarev'].'</th>
				<th>'.$l['size'].'</th>
				<th>'.$l['temp'].'</th>
				<th>'.$l['pass'].'</th>
			</tr>
		</thead>
		<tbody>
			`+nvmetable;
			nvmetable += `</tbody>`;
			$("#nvmetable").html(nvmetable);
			$("#nvmemain").show();
		}
		if(!empty(ssdtable)){
			ssdtable = `
						<thead>
							<tr>
								<th>'.$l['utility'].'</th>
								<th>'.$l['model_family'].'</th>
								<th>'.$l['serial_number'].'</th>
								<th>'.$l['lblock'].'</th>
								<th>'.$l['firmwarev'].'</th>
								<th>'.$l['satav'].'</th>
								<th>'.$l['interfacespeed'].'</th>
								<th>'.$l['size'].'</th>
								<th>'.$l['temp'].'</th>
								<th>'.$l['pass'].'</th>
							</tr>
						</thead>
						<tbody>`+ssdtable;
						ssdtable += `</tbody>`;
						$("#ssdtable").html(ssdtable);
						$("#ssdmain").show();
		}

	})
</script>';

// Script ends here

//On click Ajax Call on basis of time 

$years = array("January" => '01',
			   "Febuary" => '02',
			   "March" => '03',
			   "April" => '04',
			   "May" => '05',
			   "June" => '06',
			   "July" => '07',
			   "August" => '08',
			   "September" => '09',
			   "October" => '10',
			   "November" => '11',
			   "December" => '12'
			);
$current_year = date("Y");
$tmp = $current_month = date("m");
echo '<hr>
<script language="javascript" type="text/javascript">
	function fetch_details(){
		let chartbandwidth = Chart.getChart("bwholder");
		if (chartbandwidth != undefined) {
			chartbandwidth.destroy();
		} 
		var select_month = document.getElementById("cmonth");
		var selected_month = select_month.options[select_month.selectedIndex].value;
		var select_year = document.getElementById("cyear");
		var selected_year = select_year.options[select_year.selectedIndex].value;
		var selected_combine = selected_year+selected_month;
		getusagebandwidth(selected_combine);
	}
	Chart.defaults.color="#939393";
</script>
<div class ="card m-3 p-4 row w-100 mx-auto">
	<h5 class="px-3 text-dark"><i class="fas fa-tachometer-alt"></i>&nbsp;'.$l['bw_header'].'</h5>
	<div class="row mx-auto w-100 my-3">
		<div class="col-sm-2">
			<label class="control-label">Select Year</label>
			<select class="custom-select chosen" name="cmonth" id="cmonth">';
			foreach($years as $month => $mvalues){
				echo '<option value="'.$mvalues.'" '.(($current_month == $mvalues) ? 'selected = "selected"' : '').'>'.$month.'</option>';
			}
			echo '
			</select>
		</div>';
		echo '
		<div class="col-sm-2">
			<label class="control-label">Select Year</label>
			<select class="custom-select chosen" name="cyear" id="cyear">
			';
			for($i = 5; $i > 0; $i--){
				echo '<option value="'.$current_year.'" '.(($tmp == $current_year) ? 'selected = "selected"' : '').'>'.$current_year.'</option>';
				$current_year --;
			}
echo '
			</select>
		</div>
			<div class="col-sm-2 text-left">
				</br>
				<input type="button" onclick="fetch_details();" class="btn px-4 link_btn" value="Fetch">
			</div>
		</div>
		<div class ="px-1 row w-100 mx-auto">
			<canvas id="bwholder" width="1200" height="500"></canvas>
		</div>
		
	</div>
';
}
//on click ajax ends
echo '</div>';
softfooter();

}

?>
