<?php

//////////////////////////////////////////////////////////////
//===========================================================
// dashboard_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function manageserver_theme(){

global $theme, $error, $globals, $cluster, $user, $l, $usage, $info;

softheader($l['<title>']);

echo '
<div class="bg" >
<div class="row mx-auto my-3">
	<div class="col-12 d-flex align-items-center">
		<h4 class="text-dark"><i class="icon icon-servers"></i>&nbsp; '.$l['<title>'].'</h4>
	</div>
</div>'.get_breadcrumb([
	['act' => 'servers'],
	['act' => 'manageserver']
]);

error_handle($error); 

// Is it offline ?
$hypervisor_status = $cluster->statewise($globals['server']);
if($hypervisor_status == 0 || $hypervisor_status == 2){

	echo '<div class="e_notice"><b>'.$l['note'].' : </b> &nbsp; '.$l['server_status_'.$hypervisor_status].'</div>';
	
}else{

// Is it loaded into the correct kernel
if(strlen($info['check_kernel']) > 1){
	show_alert($info['check_kernel'] ,"1");
	echo '<div class="e_notice"><b>'.$l['note'].' : </b> &nbsp; '.$info['check_kernel'].'</div>';
}

if(!empty($GLOBALS['rebooted'])){
	show_alert($info['check_kernel'] ,"2");
	echo '<div class="notice"><b>'.$l['note'].' : </b> &nbsp; '.$l['server_rebooting'].'</div>';
}
echo '<style type="text/css">
.card {
	border: none;
	box-shadow: 0px 1px 15px 1px rgba(69, 65, 78, 0.08);
  }
.card-footer{
	border: none;
}
.card-header{
	border: none;
	height: 45px !important;
}

</style>';
echo '
<script src="'.$theme['url'].'/js/chart.js"> </script>
<script language="javascript" type="text/javascript">';

if(is_allowed('server_statistics')){

echo '

function conf_reboot(){
	showalert("'.$l['conf_reboot'].'" ,"3" ,function(confirm){
		if(confirm == false){
			return false;
		}else{
			$("#progress_bar").show();
	
			$.ajax({
				type: "POST",
				url: "'.$globals['index'].'act=manageserver&reboot=1",
				success: function(data){
						setTimeout(function(){showalert(\''.$l['server_rebooting'].'\');
						$("#alert-modal").on("hidden.bs.modal", function (e) {
						location.reload(true);
						});} ,200);
				},
				error: function(data) {
					$("#progress_bar").hide();
					return false;
				}
			});
		}
	});
};

// ]]></script>';

if(is_allowed('server_statistics')){
	echo '
	<div class= "row w-100 mx-auto d-flex justify-content-center">
		<div col-sm-12>
			<div class="card w-100 text-center">
				<div class="card-header text-muted">
					<h6>'.$info['hostname'].' | <img src="'.$theme['images'].'/svgset/'.$info['os']['distro'].'.svg" width="30" />&nbsp;&nbsp;'.$info['os']['name'].'</span></h6>
				</div>
				<div class="card-body">
					<h5 class="text-admin"><img src="'.$theme['images'].'/svgset/'.$usage['cpu']['manu'].'.svg"  height="100px"/></h5>
					<h5 class="card-title">'.$l['ipaddr'].'&nbsp;'.$info['ips'][0].'</h5>
					<div class="row px-4">
						<div class="col-sm-6">
							<ul class="list-group list-group-flush">
								<li class="list-group-item text-left">'.$l['numvps'].'&nbsp;'.$info['details']['numvps'].'</li>
								<li class="list-group-item text-left">'.$l['alloc_cpu'].'&nbsp;'.$info['details']['alloc_cpu'].'</li>
								<li class="list-group-item text-left">'.$l['alloc_space'].'&nbsp;'.$info['details']['alloc_space'].' GB</li>
								<li class="list-group-item text-left">'.$l['alloc_ram'].'&nbsp;'.$info['details']['alloc_ram'].' MB</li>
							</ul>
						</div>
						<div class="col-sm-6">
							<ul class="list-group list-group-flush">
								<li class="list-group-item text-left">'.$l['cpumodel'].'&nbsp;'.$usage['cpu']['cpumodel'].'</li>
								<li class="list-group-item text-left">'.$l['servstatus'].'&nbsp;'.($info['status'] == 1 ? '<i class="fas fa-running fa-2x text-success"></i>&nbsp;&nbsp;'.$l['online'].'' : '<i class="fas fa-times-circle fa-2x text-danger"></i>&nbsp;&nbsp;'.$l['offline'].'').'</li>
								<li class="list-group-item text-left" id="uptime_data">'.$l['uptime'].'&nbsp;'.$info['uptime'].'</li>
								<li class="list-group-item text-left">'.$l['kernel'].'&nbsp;'.$info['kernel_name'].'</li>
							</ul>
						</div>
					</div>
					</br>
					<hr>
					<h5>'.$l['server_resources'].'</h5>
					</br>
					<div class="row w-100 mx-auto">
						<div class="col-sm-6 col-md-4 col-lg-2">
							<div class="card text-center">
								<div class="card-header text-muted">
								<h6>'._strtoupper($l['cpuinfo']).'</h6>
								</div>
								<div class="card-body">
								<h5 class="card-title" id="cpu_percent"></h5>
								<div class="row mx-auto w-100">
									<div class="col-sm-12 d-flex justify-content-center">
										<canvas id="cpuholder" style="width:100px; height:100px;"></canvas>
									</div>
								</div>
									</div>
								<div class="card-footer text-muted" id="cpu_model">
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-4 col-lg-2">
							<div class="card text-center">
								<div class="card-header text-muted">
								<h6>'._strtoupper($l['raminfo']).'</h6>
								</div>
								<div class="card-body">
								<h5 class="card-title" id="ram_percent"></h5>
								<div class="row w-100 mx-auto">
									<div class="col-sm-12 d-flex justify-content-center">
										<canvas id="ramholder" style="width:100px; height:100px;"></canvas>
									</div>
								</div>
									</div>
								<div class="card-footer text-muted" id="ram_model">
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-4 col-lg-2">
							<div class="card text-center">
								<div class="card-header text-muted">
								<h6>'._strtoupper($l['diskinfo']).'</h6>
								</div>
								<div class="card-body">
								<h5 class="card-title" id="disk_percent"></h5>
								<div class="row mx-auto">
									<div class="col-sm-12 d-flex justify-content-center">
										<canvas id="diskholder" style="width:100px; height:100px;"></canvas>
									</div>
								</div>
									</div>
								<div class="card-footer text-muted" id="disk_model">
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-4 col-lg-2">
							<div class="card text-center">
								<div class="card-header text-muted">
								<h6>'._strtoupper($l['storageinfo']).'</h6>
								</div>
								<div class="card-body">
								<h5 class="card-title" id="storage_percent"></h5>
								<div class="row mx-auto">
									<div class="col-sm-12 d-flex justify-content-center">
										<canvas id="storageholder" style="width:100px; height:100px;"></canvas>
									</div>
								</div>
									</div>
								<div class="card-footer text-muted" id="storage_model">
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-4 col-lg-2">
							<div class="card text-center">
								<div class="card-header text-muted">
								<h6>'._strtoupper($l['bandwidthinfo']).'</h6>
								</div>
								<div class="card-body">
								<h5 class="card-title" id="bandwidth_percent"></h5>
								<div class="row mx-auto">
									<div class="col-sm-12 d-flex justify-content-center">
										<canvas id="bandwidthholder" style="width:100px; height:100px;"></canvas>
									</div>
								</div>
									</div>
								<div class="card-footer text-muted" id="bandwidth_model">
								</div>
							</div>
						</div>
						<div class="col-sm-6 col-md-4 col-lg-2">
							<div class="card text-center">
								<div class="card-header text-muted">
								<h6>'._strtoupper($l['iowait']).'</h6>
								</div>
								<div class="card-body">
								<h5 class="card-title" id="iowait_percent"></h5>
								<div class="row mx-auto">
									<div class="col-sm-12 d-flex justify-content-center">
										<canvas id="iowaitholder" style="width:100px; height:100px;"></canvas>
									</div>
								</div>
									</div>
								<div class="card-footer text-muted" id="iowait_model">
								</div>
							</div>
						</div>
					</div>
					</br>
					<hr>
					<h5>'.$l['server_options'].'</h5>
					</br>
					<div class="row mx-auto w-100 text-center">
						<div class="col-sm-12  d-flex justify-content-center">
							<div class="serv_op p-4 pan-button">
								<a href="'.$globals['index'].'act=config" class="micons">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
									<path d="m2 8.654 2.813 2.822 6.332-6.35-2.814-2.823-6.332 6.35zm4.441 8.128 2.11-2.117a.993.993 0 0 1 1.408 0 1 1 0 0 1 0 1.411l-2.11 2.117a1 1 0 0 1 0 1.411L6.44 21.015a.993.993 0 0 1-1.407 0l-1.407-1.41a1 1 0 0 1 0-1.412l1.407-1.411a.993.993 0 0 1 1.407 0zm9.146-6.35 6.331-6.35-1.407-1.412-6.331 6.35c-.777-.78-.912-1.907-.302-2.52L19.406.956c.61-.612 1.735-.477 2.512.303l1.407 1.41c.778.78.913 1.909.302 2.52l-5.528 5.545c-.61.612-1.735.477-2.512-.303zm-.924 3.866L9.738 9.36l-.704.706 4.925 4.939.704-.706zm1.407 1.412-.704.705 1.759 1.764c.194.195.51.195.703 0a.5.5 0 0 0 0-.705L16.07 15.71zM2.06 5.77a1.5 1.5 0 0 1 .291-1.704l1.407-1.41a1.49 1.49 0 0 1 1.699-.293L6.924.892a1.986 1.986 0 0 1 2.814 0l2.814 2.823a2 2 0 0 1 0 2.822l-1.407 1.411 8.09 8.114a2.5 2.5 0 0 1 0 3.528 2.482 2.482 0 0 1-3.517 0l-8.09-8.114-1.408 1.411c-.777.78-2.037.78-2.814 0L.592 10.065a2 2 0 0 1 0-2.823l1.467-1.47z"/>
								</svg>
								<br />
								<div class="pt-2">'.$l['settings'].'</div>
								</a>
							</div>
							<div class="serv_op p-4 pan-button">
								<a href="'.$globals['index'].'act=vscpu" class="micons">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
								<path d="M6 3h8a3 3 0 0 1 3 3v8a3 3 0 0 1-3 3H6a3 3 0 0 1-3-3V6a3 3 0 0 1 3-3zm0 2a1 1 0 0 0-1 1v8a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1V6a1 1 0 0 0-1-1H6zm2 2h4a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1V8a1 1 0 0 1 1-1zm1 2v2h2V9H9zM6 0a1 1 0 0 1 1 1v2a1 1 0 1 1-2 0V1a1 1 0 0 1 1-1zM1 5h2a1 1 0 1 1 0 2H1a1 1 0 1 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM1 9h2a1 1 0 1 1 0 2H1a1 1 0 0 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM1 13h2a1 1 0 0 1 0 2H1a1 1 0 0 1 0-2zm16 0h2a1 1 0 0 1 0 2h-2a1 1 0 0 1 0-2zM6 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1zm8-16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0V1a1 1 0 0 1 1-1zm0 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1zM10 0a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0V1a1 1 0 0 1 1-1zm0 16a1 1 0 0 1 1 1v2a1 1 0 0 1-2 0v-2a1 1 0 0 1 1-1z"/>
								</svg><br />
								<div class="pt-2">'.$l['cpu_usage'].'</div>
								</a>
							</div>
							<div class="serv_op p-4 pan-button">
								<a href="'.$globals['index'].'act=vsram" class="micons">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
								<path d="m14.95 7.879-.707-.707a1 1 0 0 1 1.414-1.415l.707.707 1.414-1.414-2.828-2.828L2.222 14.95l2.828 2.828 1.414-1.414L5.05 14.95a1 1 0 0 1 1.414-1.414L7.88 14.95l1.414-1.414-.707-.708A1 1 0 0 1 10 11.414l.707.707 1.414-1.414-1.414-1.414a1 1 0 0 1 1.414-1.414l1.415 1.414 1.414-1.414zM.808 13.536 13.536.808a2 2 0 0 1 2.828 0l2.828 2.828a2 2 0 0 1 0 2.828L6.464 19.192a2 2 0 0 1-2.828 0L.808 16.364a2 2 0 0 1 0-2.828z"/>
								</svg><br />
								<div class="pt-2">'.$l['ram_usage'].'</div>
								</a>
							</div>
							<div class="serv_op p-4 pan-button">
								<a href="'.$globals['index'].'act=vsbandwidth" class="micons">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
									<path d="M10 18a8 8 0 1 0 0-16 8 8 0 0 0 0 16zm0 2C4.477 20 0 15.523 0 10S4.477 0 10 0s10 4.477 10 10-4.477 10-10 10zM9 1h2v10H9V1zm0 8h10v2H9V9z"/>
								</svg><br />
								<div class="pt-2">'.$l['bandwidth_usage'].'</div>
								</a>
							</div>
							<div class="serv_op p-4 pan-button">
								<a href="javascript:void(0);" class="micons" onclick="conf_reboot();">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
									<path d="m5.308 7.612 1.352-.923a.981.981 0 0 1 1.372.27 1.008 1.008 0 0 1-.266 1.388l-3.277 2.237a.981.981 0 0 1-1.372-.27L.907 6.998a1.007 1.007 0 0 1 .266-1.389.981.981 0 0 1 1.372.27l.839 1.259C4.6 3.01 8.38 0 12.855 0c5.458 0 9.882 4.477 9.882 10s-4.424 10-9.882 10a.994.994 0 0 1-.988-1c0-.552.443-1 .988-1 4.366 0 7.906-3.582 7.906-8s-3.54-8-7.906-8C9.311 2 6.312 4.36 5.308 7.612z"/>
								</svg><br />
								<div class="pt-2">'.$l['reboot'].'</div>
								</a>
							</div>
							<div class="serv_op p-4 pan-button">
								<a href="'.$globals['index'].'act=backup_plans" class="micons">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
								<defs>
									<image width="24" height="25" id="img1" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9Ii01IC00LjUgMjQgMjQiIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgZmlsbD0iY3VycmVudENvbG9yIj48cGF0aCBkPSJtNiA0LjA3MS0zLjk1IDMuOTVBMSAxIDAgMCAxIC42MzYgNi42MDdMNi4yOTMuOTVhLjk5Ny45OTcgMCAwIDEgMS40MTQgMGw1LjY1NyA1LjY1N0ExIDEgMCAwIDEgMTEuOTUgOC4wMkw4IDQuMDd2OS41ODZhMSAxIDAgMSAxLTIgMFY0LjA3eiIvPjwvc3ZnPg=="/>
								</defs>
								<style>
									.s0 { fill: currentColor } 
									#arrow-up {
										filter: invert(50%);
									}
								</style>
								<path id="Layer" fill-rule="evenodd" class="s0" d="m7 19c-1.5 0-2.9-0.6-3.8-1.8-1-1.1-1.4-2.5-1.1-4 0.2-1.4 1.1-2.7 2.3-3.5 1.2-0.7 2.8-0.9 4.2-0.5 0.6-1.4 1.7-2.7 3.2-3.4 1.4-0.7 3-1 4.6-0.7 1.6 0.4 3 1.2 4 2.5 1 1.2 1.6 2.8 1.6 4.4q0 1.4-0.5 2.7-0.6 1.3-1.6 2.2-0.9 1-2.2 1.6-1.3 0.5-2.7 0.5zm0-2h8c1.8 0 3.5-1 4.4-2.6 0.9-1.7 0.8-3.6-0.2-5.2-1-1.5-2.8-2.3-4.7-2.2-1.8 0.2-3.4 1.3-4.1 3l-0.7 1.7-1.8-0.6c-0.8-0.2-1.7-0.1-2.5 0.3-0.7 0.5-1.2 1.3-1.4 2.1-0.1 0.9 0.2 1.8 0.7 2.4 0.6 0.7 1.4 1.1 2.3 1.1z"/>
								<use id="arrow-up" href="#img1" transform="matrix(.458,0,0,.459,8,7)"/>
								</svg><br />
								<div class="pt-2">'.$l['backups'].'</div>
								</a>
							</div>
							<div class="serv_op p-4 pan-button">
								<a href="'.$globals['index'].'act=vpsrestore" class="micons">
								<svg xmlns="http://www.w3.org/2000/svg" viewBox="-1,-3,22,28" width="60" height="60" fill="currentColor">
									<path d="M13.106 9h3.953c.546 0 .988.448.988 1s-.442 1-.988 1h-4.941a.994.994 0 0 1-.988-1V4c0-.552.442-1 .988-1s.988.448.988 1v5zm6-6.071A10.029 10.029 0 0 1 22 10c0 5.523-4.424 10-9.882 10v-2c4.366 0 7.906-3.582 7.906-8a8.02 8.02 0 0 0-2.316-5.657A7.834 7.834 0 0 0 12.118 2C8.574 2 5.574 4.36 4.571 7.612l1.352-.923a.981.981 0 0 1 1.372.27 1.007 1.007 0 0 1-.267 1.388l-3.277 2.237a.981.981 0 0 1-1.372-.27L.17 6.998a1.007 1.007 0 0 1 .267-1.389.981.981 0 0 1 1.372.27l.839 1.259C3.863 3.01 7.643 0 12.118 0c2.729 0 5.2 1.12 6.988 2.929z"/>
								</svg><br />
								<div class="pt-2">'.$l['list_backups'].'</div>
								</a>
							</div>
						</div>					
					
					</div>
				</div>
			</div>
		</div>
	</div>';
	echo '';
}

echo '
<script>
$(document).ready(function(){

	var xValues = ["Used","Free"];
	var yValues = ["0","100"];
	var barColors = ["#515dbc","#eaa32f"];
	const cpu_config = {
			type: "doughnut",
			data: {
			labels: xValues,
			datasets: [{
				backgroundColor: barColors,
				data: yValues,
				hoverOffset: 4
			}]
		},
		options: {
			responsive: false,
			maintainAspectRatio: false,
			plugins: { legend: { display: false, }, }
		}
	};

	var cpu_pie = document.getElementById("cpuholder");
	cpuchart = new Chart(cpu_pie, cpu_config );

	const ram_config = {
			type: "doughnut",
			data: {
			labels: xValues,
			datasets: [{
				backgroundColor: barColors,
				data: yValues,
				hoverOffset: 4
			}]
		},
		options: {
			responsive: false,
			maintainAspectRatio: false,
			plugins: { legend: { display: false, }, }
		}
	};

	var ram_pie = document.getElementById("ramholder");
	ramchart = new Chart(ram_pie, ram_config );

	const disk_config = {
			type: "doughnut",
			data: {
			labels: xValues,
			datasets: [{
				backgroundColor: barColors,
				data: yValues,
				hoverOffset: 4
			}]
		},
		options: {
			responsive: false,
			maintainAspectRatio: false,
			plugins: { legend: { display: false, }, }
		}
	};

	var disk_pie = document.getElementById("diskholder");
	diskchart = new Chart(disk_pie, disk_config );

	const storage_config = {
			type: "doughnut",
			data: {
			labels: xValues,
			datasets: [{
				backgroundColor: barColors,
				data: yValues,
				hoverOffset: 4
			}]
		},
		options: {
			responsive: false,
			maintainAspectRatio: false,
			plugins: { legend: { display: false, }, }
		}
	};

	var storage_pie = document.getElementById("storageholder");
	storagechart = new Chart(storage_pie, storage_config );

	const bandwidth_config = {
			type: "doughnut",
			data: {
			labels: xValues,
			datasets: [{
				backgroundColor: barColors,
				data: yValues,
				hoverOffset: 4
			}]
		},
		options: {
			responsive: false,
			maintainAspectRatio: false,
			plugins: { legend: { display: false, }, }
		}
	};

	var bandwidth_pie = document.getElementById("bandwidthholder");
	bandwidthchart = new Chart(bandwidth_pie, bandwidth_config );

	const iowait_config = {
			type: "doughnut",
			data: {
			labels: xValues,
			datasets: [{
				backgroundColor: barColors,
				data: yValues,
				hoverOffset: 4
			}]
		},
		options: {
			responsive: false,
			maintainAspectRatio: false,
			plugins: { legend: { display: false, }, }
		},
		centerText: {
			display: true,
			text: "280"
		}
	};

	var iowait_pie = document.getElementById("iowaitholder");
	iowaitchart = new Chart(iowait_pie, iowait_config );


	getserverstats('.$globals['server'].');
	startusage();
});
</script>';

}

echo '
</br>
<p class="notice">'.$l['trademarks'].'</p>
</div>';


echo '
	<script>
	
	function startusage(){
		ajaxtimer = setInterval("getserverstats('.$globals['server'].')", 5000);
	};

	function card_graph(percent_name,model_name,progress_name,percent,bottom_text){
		percent = percent.toFixed(2);
		$("#"+percent_name).html(percent+"%");
		$("#"+model_name).html(bottom_text);
	}

	function getserverstats(serid){
		
		serid = serid || 0;
		
		$.getJSON("'.$globals['index'].'act=manageserver&changeserid="+serid+"&api=json", function(data) {
			card_graph("cpu_percent","cpu_model","cpu_progress",data["usage"]["cpu"]["percent"],"'.$l['free'].': "+data["usage"]["cpu"]["percent_free"]+"%");
			card_graph("ram_percent","ram_model","ram_progress",data["usage"]["ram"]["percent"],"'.$l['free'].': "+data["usage"]["ram"]["percent_free"]+"%");
			card_graph("disk_percent","disk_model","disk_progress",data["usage"]["disk"]["/"]["percent"],"'.$l['free'].': "+data["usage"]["disk"]["/"]["percent_free"]+"%");
			var sto_total = data["info"]["resources"]["total_space"];
			var sto_used = (sto_total - data["info"]["resources"]["space"]).toFixed(2);
			var sto_per = (sto_used / sto_total)*100;
			
			card_graph("storage_percent","storage_model","storage_progress",sto_per,"'.$l['free'].': "+ (100 - sto_per).toFixed(2)+"%");
			card_graph("bandwidth_percent","bandwidth_model","bandwidth_progress",(data["usage"]["bandwidth"]["percent"] == 0)? 0.1 : data["usage"]["bandwidth"]["percent"],"'.$l['free'].': "+data["usage"]["bandwidth"]["percent_free"]+"%");

			if(!empty(data["usage"]["io"])){
				var iowait = data["usage"]["io"]["avg_cpu"]["iowait"];
				var iowait_f = 100 - iowait;
			}else{
				var iowait = "NA";
				var iowait_f = "NA";
			}
			card_graph("iowait_percent","iowait_model","iowait_progress",iowait,"'.$l['free'].': "+iowait_f+"%");

			// Check if chart exist
			let chartcpu = Chart.getChart("cpuholder");
			let chartram = Chart.getChart("ramholder");
			let chartdisk = Chart.getChart("diskholder");
			let chartstorage = Chart.getChart("storageholder");
			let chartbandwidth = Chart.getChart("bandwidthholder");
			let chartiowait = Chart.getChart("iowaitholder");

			if (chartcpu != undefined) {
				cpuchart.data.datasets[0].data = [data["usage"]["cpu"]["percent"] ,data["usage"]["cpu"]["percent_free"]];
				cpuchart.update();
			}
			if (chartram != undefined) {
				ramchart.data.datasets[0].data = [data["usage"]["ram"]["percent"] ,data["usage"]["ram"]["percent_free"]];
				ramchart.update();
			}
			if (chartdisk != undefined) {
				diskchart.data.datasets[0].data = [data["usage"]["disk"]["/"]["percent"] ,data["usage"]["disk"]["/"]["percent_free"]];
				diskchart.update();
			}
			if (chartstorage != undefined) {
				storagechart.data.datasets[0].data = [sto_per ,100 - sto_per.toFixed(2)];
				storagechart.update();
			}
			if (chartbandwidth != undefined) {
				bandwidthchart.data.datasets[0].data = [(data["usage"]["bandwidth"]["percent"] == 0)? 0.1 : data["usage"]["bandwidth"]["percent"] ,data["usage"]["bandwidth"]["percent_free"]];
				bandwidthchart.update();
			}
			if (chartiowait != undefined) {
				iowaitchart.data.datasets[0].data = [iowait,iowait_f];
				iowaitchart.update();
			}

			// Update Server Load Average
			$("#uptime_data").html(data["info"]["uptime"]);
			
		});
	}
	</script>';
}
softfooter();

}

?>