<?php

//////////////////////////////////////////////////////////////
//===========================================================
// dashboard_theme.php
//===========================================================
// SOFTACULOUS VIRTUALIZOR
// Version : 1.0
// Inspired by the DESIRE to be the BEST OF ALL
// ----------------------------------------------------------
// Started by: Alons
// Date:       8th Mar 2010
// Time:       23:00 hrs
// Site:       https://www.virtualizor.com/ (SOFTACULOUS VIRTUALIZOR)
// ----------------------------------------------------------
// Please Read the Terms of use at https://www.virtualizor.com
// ----------------------------------------------------------
//===========================================================
// (c)Softaculous Ltd.
//===========================================================
//////////////////////////////////////////////////////////////

if(!defined('VIRTUALIZOR')){

	die('Hacking Attempt');

}

function adminindex_theme(){

global $theme, $globals, $cluster, $user, $l, $stats, $servers, $users, $bandwidth;

$acl_cluster_statistics = is_allowed("cluster_statistics");
$acl_server_statistics = is_allowed("server_statistics");

softheader($l['<title>']);
$num_virts = array('openvz', 'kvm', 'xen', 'xenhvm', 'xcp', 'xcphvm', 'lxc', 'vzo', 'vzk', 'proxl', 'proxk');
if(!empty($stats['num_vps'])) {
	$table_vps = '';
	foreach($num_virts as $v){
		if(!empty($stats['num_'.$v])){
			$table_vps .= '<div class="row text-left mx-auto w_100_tp_vps"><div class="col-9 p-0" ><small>'.$l['num_'.$v].'</small></div><div class="col-3 p-0"><small>'.$stats['num_'.$v].'</small></div></div>';
		}
	}
} else {
	$table_vps = '';
}
if(!empty($stats['num_total_users'])) {
	$table_users = ''.
	(!empty($stats['num_admins']) ? '<div class="row text-left mx-auto w_100_tp"><div class="col-8 p-0"><small>'.$l['num_admins'].'</small></div><div class=" p-0 text-left"><small>'.$stats['num_admins'].'</small></div></div>' : '').
	(!empty($stats['num_clouds']) ? '<div class="row text-left mx-auto w_100_tp"><div class="col-8 p-0"><small>'.$l['num_clouds'].'</small></div><div class=" p-0 text-left"><small>'.$stats['num_clouds'].'</small></div></div>' : '').
	(!empty($stats['num_users']) ? '<div class="row text-left mx-auto w_100_tp"><div class="col-8 p-0"><small>'.$l['num_users'].'</small></div><div class=" p-0 text-left"><small>'.$stats['num_users'].'</small></div></div>' : '').
	'</table>';
} else {
	$table_users = '';
}

echo '<script src="'.$theme['url'].'/js/jquery.easypiechart.min.js"></script>';

echo '<style type="text/css">

	.select2-selection{
		border: none !important;
		font-size: 15px;
		box-shadow: rgba(0, 0, 0, 0.1) 0px 3px 5px;
	}
	.resource_gr {
		border-radius: 4px;
		color: #FFFFFF;
		height:95%;
	}
	.resource_header {
		font-weight: 300;
		padding: 8px;
		font-size: 16px;
		text-align: center;
	}
	.resource_content {
		font-size: 16px;
		padding: 14px 16px 8px 16px;
		text-align: center;
	}
	.resource_container {
		display: inline-block;
		text-align: center;
		height: 80px;
		width: 80px;
		position: relative;
	}
	.resource_container .text {
		line-height: 80px;
		height: 100%;
	}
	.resource_container .chart-2 {
		position: absolute;
		top: 0;
		left: 0;
	}
	.resource_value {
		font-size: 12px;
		margin-top: 8px;
	}
	
	#search-input {
		transition: all 0.5s;
		float: right;
		width: 100%;
	}
	#search-input.collapsed {
		width: 0;
		padding: 0;
		border: 0;
	}
	
	#cluster_stats [class*=col] {
		margin-bottom: 8px;
	}
	
	.dash {
		border-radius: 0px;
		height: 80px;
		position: relative;
	}
	.dash-text {
		position: absolute;
		left: 12px;
		top: 12px;
	}
	.dash-title {
		position: absolute;
		left: 12px;
		bottom: 12px;
	}
	.dash .badge {
		background-color:rgba(0,0,0,0.5);
		font-size: 14px !important;
		color:#fff;
	}
	.dash i {
		position: absolute;
		right: 12px;
		top: 12px;
		font-size: 48px;
		opacity: 0.4;
	}
	.dash.compact .badge {
		font-size: 18px;
	}
	.dash.compact i {
		font-size: 36px;
	}
	.dash.compact .dash-title {
		font-size: 11px;
	}
	
	.server_gr {
		text-align: center;
	}
	.server_gr .title {
		font-size: 16px;
		font-weight: bold;
		margin: 20px 0 16px 0;
		text-transform: uppercase;
	}
	.server_gr .content {
		display: inline-block;
		position: relative;
		height: 140px;
		width: 140px;
	}
	.server_gr .content .text {
		display: table-cell;
		vertical-align: middle;
		width: 140px;
		height: 140px;
	}
	.server_gr .content .text div {
		margin-left: auto;
		margin-right: auto;
	}
	.server_gr .content .value {
		font-size: 16px;
	}
	.server_gr .chart {
		position: absolute;
		top: 0;
		left: 0;
		display: inline-block;
	}
	.server_gr .bottom-text {
		margin: 12px 0;
	}
	
	table.tool {
		width: 150px;
		margin: 4px;
	}
	table.tool td {
		padding: 4px;
	}
	
	.panel {
		min-height: 120px;
	}
	.panel-content {
		max-height: 200px;
		overflow: hidden;
	}
	.panel.panel-red {
		border-color: #EF5350;
	}
	.panel.panel-red .panel-heading {
		background-color: #EF5350;
		border-color: #EF5350;
		color: #fff;
	}
	.panel.panel-red1 .table-dash thead tr {
		background-color: #EF5350CC;
		color: #fff;
	}
	.panel.panel-blue {
		border-color: #3083FF;
	}
	.panel.panel-blue .panel-heading {
		background-color: #3083FF;
		border-color: #3083FF;
		color: #fff;
	}
	.panel.panel-blue1 .table-dash thead tr {
		background-color: #3083FFCC;
		color: #fff;
	}
	.panel.panel-blue-grey {
		border-color: #607D8B;
	}
	.panel.panel-blue-grey .panel-heading {
		background-color: #607D8B;
		border-color: #607D8B;
		color: #fff;
	}
	.panel.panel-blue-grey1 .table-dash thead tr {
		background-color: #607D8BCC;
		color: #fff;
	}
	
	.table-dash {
		margin-bottom: 4px;
	}
	.table-dash tbody tr td {
		vertical-align: middle;
	}
	.table-dash tr td:first-child, .table-dash tr th:first-child {
		padding-left: 16px;
	}
	.table-dash tr td:last-child, .table-dash tr th:last-child {
		padding-right: 16px;
	}
	
	.btn-logs {
		
		margin : 0;
		padding : 4px 8px;
		font-size : 12px;

	}


</style>
<script>
$(function () {
	get_live_resource($("#band_ser").val());
	setInterval(function(){get_live_resource($("#band_ser").val());}, 20000);
});

function get_live_resource(serid){
	var load_once_flag = $("#load_once_flag").val();
	if(empty(load_once_flag)){
		$(".show-loading").show();
	}
	$.getJSON("'.$globals['index'].'act=adminindex&serid="+serid+"&api=json", function(data) {
		$("#load_once_flag").val("1");
		$(".show-loading").hide();
		
		var ser_status = data["servers"][serid]["status"];
		if(empty(ser_status)){
			var server_name = $("#band_ser").find(":selected").text();
			show_toast("'.$l['fetch_server_stats'].' "+"<b>"+server_name+"</b>"+" '.$l['offline'].'", 5);
			return;
		}
		d1 = [];
		$.each(data["stats"]["bandwidth_in"],function(k,v){
			d1.push(v);
		});

		d2 = [];
		$.each(data["stats"]["bandwidth_out"],function(k,v){
			d2.push(v);
		});	
	
		// Check if chart exist
		let chartbandwidth = Chart.getChart("bandwidth_graph");

		if (chartbandwidth != undefined) {
			bwChart.data.datasets[0].data = d1;
			bwChart.data.datasets[1].data = d2;
			bwChart.update();
		}
		
		if(!empty(data) && ("node_ram" in data["stats"])){
			card_graph("cpu_percent","cpu_model","cpu_progress",data["stats"]["cpu_percent"],data["stats"]["cpu_model"]);

			card_graph("ram_percent","ram_stat","ram_progress",data["stats"]["node_ram"]["percent"],data["stats"]["node_ram"]["used"]+" / "+data["stats"]["node_ram"]["limit"]+" MB Used");
	
			card_graph("disk_percent","disk_model","disk_progress",data["stats"]["root_percent"],"Remaining space on /root: "+data["stats"]["root_free"]+" GB");
	
			card_graph("storage_percent","storage_model","storage_progress",(data["stats"]["vps_per"]).toFixed(2),data["stats"]["vps_bottom"]);
	
			card_graph("bandwidth_percent","bandwidth_model","bandwidth_progress",data["stats"]["band_per"],data["stats"]["band_bottom"]);
	
			card_graph("iowait_percent","iowait_model","iowait_progress",data["stats"]["iowait"],"'.$l['iowait'].' in percentage");
			
			//last card
			$("#cpu_name").html(wordwrapper(28,data["stats"]["cpu_model"]));
			$("#cpu_name").attr("tooltip",data["stats"]["cpu_model"]);
			show_tooltip();
			$("#server_uptime").html(data["stats"]["uptime"]);
			$("#kernelname").html(data["stats"]["kernel_name"]);
			$("#virt_type").html(data["stats"]["virt"]);
			$("#arch").html(data["stats"]["arch_type"]);
			$("#osname").html(data["stats"]["osname"]);
			$("#image_cpu").html(\'<img src="'.$theme['svg'].'\'+data["stats"]["cpu_manu"]+\'.svg" style="height:40px"/>\');
		}

	});
};

function makedata(data="",time_count=""){
	
	var fdata = [];
	if(!empty(time_count)){
		for(i = 1; i <= time_count; i++){
			fdata.push(i);
		}
	}else{
		for (x in data){
			fdata.push([(data[x]/1024)]);
		}
	}

	return fdata;
	
}

function card_graph(percent_name, model_name, progress_name, percent, bottom_text){
	$("#"+percent_name).html(percent+"%");
	$("#"+model_name).html(bottom_text);
	$("#"+progress_name).css("width", percent+"%");

	$("#"+progress_name).removeClass("bg-success bg-warning bg-danger");
	
	if(percent < 40){
		$("#"+progress_name).addClass("bg-success");	
	}else if(percent < 80){
		$("#"+progress_name).addClass("bg-warning");
	}else{
		$("#"+progress_name).addClass("bg-danger");
	}

}
</script>
<script src="'.$theme['url'].'/js/chart.js"> </script>';

echo '<div class="bg">
';

//ACL Validation
if(!$acl_cluster_statistics && !$acl_server_statistics){
	$error[] = $l['err_acl_no_allowed'];
	error_handle($error);
	softfooter();
	return false;
}
//ACL Validation
if($acl_cluster_statistics){
	$disk_percent = round($stats['space_used'] / $stats['total_space'] * 100);
	$ram_percent = round($stats['ram_used'] / $stats['total_ram'] * 100);

	$disk_use_percent = 0;
	$ram_use_percent = 0;
	
	if($disk_percent > 0){
		$disk_use_percent = $disk_percent;
	}
	
	if($ram_percent > 0){
		$ram_use_percent = $ram_percent;
	}
	
	echo '
	<br>
	<div class="row mx-auto w-100">
		<div class="col-lg-3 col-sm-6 col-md-6 mb-3 res_card h-25">
			<div class="card cluster-card1 res_card h-25">
				<a href="'.$globals['ind'].'act=vs" '.(!empty($table_vps) ? 'tooltip="'.htmlizer($table_vps).'"' : '').'">
				<div class="row">
					<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
						<i class="fas fa-2x fa-server"></i>
					</div>
					<div class="col-lg-8 col-8 col-md-8 pr-4">
						<div class="text-right text-muted h6 m-0">
							'._strtoupper($l['vps']).'
						</div>
						<div class="text-right">
							<h3 class="mb-1">'.$stats['num_vps'].'</h3>
						</div>
					</div>
				</div>
				</a>
				<p class="text-muted  mt-1 mb-0 pt-1">'.$stats['num_vps_suspended'].'/'.$stats['num_vps'].' '.$l['suspended'].'
				</p>
			</div>
		</div>
		<div class="col-lg-3 col-sm-6 col-md-6 mb-3 res_card h-25">
			<div class="card cluster-card1 res_card h-25">
				<a href="'.$globals['ind'].'act=users" '.(!empty($table_users) ? 'tooltip="'.htmlizer($table_users).'"' : '').'>
				<div class="row">
					<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
						<i class="fas fa-2x fa-users"></i>
					</div>
					<div class="col-lg-8 col-8 col-md-8 pr-4">
						<div class="text-right text-muted h6 m-0">
							'._strtoupper($l['users']).'
						</div>
						<div class="text-right">
							<h3 class="mb-1">'.$stats['num_total_users'].'</h3>
						</div>
					</div>
				</div>
				</a>
				<p class="text-muted  mt-1 mb-0 pt-1">'.$stats['num_suspended_users'].' / '.$stats['num_total_users'].' '.$l['suspended'].'</p>
			</div>
		</div>	
		<div class="col-lg-3 col-sm-6 col-md-6 mb-3 res_card h-25">
			<div class="card cluster-card1 res_card h-25">
				<a href="'.$globals['ind'].'act=ippool">
				<div class="row">
					<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
						<i class="icon fa-2x icon-ippool"></i>
					</div>
					<div class="col-lg-8 col-8 col-md-8 pr-4">
						<div class="text-right text-muted h6 m-0">
							'.$l['free_ipv4'].'
						</div>
						<div class="text-right">
							<h3 class="mb-1">'.$stats['free_ipv4'].'</h3>
						</div>
					</div>
				</div>
				</a>
				<p class="text-muted  mt-1 mb-0 pt-1">'.$stats['ipv4'].' / '.$stats['total_ipv4'].' '.$l['used_ipv4'].'</p>
			</div>
		</div>
		<div class="col-lg-3 col-sm-6 col-md-6 mb-3 res_card h-25">
			<div class="card cluster-card1 res_card h-25">
				<a href="'.$globals['ind'].'act=ippool">
				<div class="row">
					<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
						<i class="icon fa-2x icon-ippool"></i>
					</div>
					<div class="col-lg-8 col-8 col-md-8 pr-4">
						<div class="text-right text-muted h6 m-0">
							'.$l['free_ipv6'].'
						</div>
						<div class="text-right">
							<h3 class="mb-1">'.$stats['free_ipv6'].'</h3>
						</div>
					</div>
				</div>
				</a>
				<p class="text-muted  mt-1 mb-0 pt-1">'.$stats['ipv6'].' / '.$stats['total_ipv6'].' '.$l['used_ipv6'].'</p>
			</div>
		</div>
	</div>
	<div class="row mx-auto w-100">
		<div class="col-lg-6 col-sm-12 col-md-12 mb-0 text-center">
			<div class="mb-3 card cluster-card1  p-2 h-auto">
				<input type="hidden" id="load_once_flag" value="0">
				<div style="display:none;" class="loader band-loading position-absolute show-loading"></div>
				<h6 class="mb-0 text-muted">'.$l['bandwidth'].'</h6>
				<div class="overflow-hidden p-0 position-relative mt-2" id="bandwidth_graph1">
					<canvas  style="height:290px;" id="bandwidth_graph"></canvas>
				</div>
			</div>
		</div>
		<div class="col-lg-6 col-sm-12 col-md-12 mb-0 p-0">
			<div class="row w-100 mx-auto">
				<div class="col-lg-6 col-sm-6 col-md-6 mb-3">
					<div class="card cluster-card1 row w-100 mx-auto">
						<div class="col-sm-12 p-0">
							<div class="row">
								<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
									<i class="fas fa-2x fa-memory"></i>
								</div>
								<div class="col-lg-8 col-8 col-md-8 pr-4">
									<div class="text-right text-muted h6 m-0">
										'._strtoupper($l['cluster_ram']).'
									</div>
									<div class="text-right">
										<h3 class="mb-1">'.$ram_use_percent.'%</h3>
									</div>
								</div>
							</div>
							<div class="progress mt-2">
								<div class="progress-bar '.($ram_use_percent < 40 ? 'bg-success' : ($ram_use_percent < 80 ? 'bg-warning' : 'bg-danger')).'" style="width:'.$ram_use_percent.'%;"></div>
							</div>
							<div class="text-muted  mt-3 mb-0 pt-3">
								<span>'.$stats['ram_used'].' / '.$stats['total_ram'].' MB Used</span>
							</div>
						</div>
						
					</div>
				</div>
				<div class="col-lg-6 col-sm-6 col-md-6 mb-3">
					<div class="card cluster-card1 row w-100 mx-auto">
						<div class="col-sm-12 p-0">
							<div class="row">
								<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
									<i class="fa fa-2x fa-hdd"></i>
								</div>
								<div class="col-lg-8 col-8 col-md-8 pr-4">
									<div class="text-right text-muted h6 m-0">
										'._strtoupper($l['cluster_storage']).'
									</div>
									<div class="text-right">
										<h3 class="mb-1">'.$disk_use_percent.'%</h3>
									</div>
								</div>
							</div>
							<div class="progress mt-2">
								<div class="progress-bar '.($disk_use_percent < 40 ? 'bg-success' : ($disk_use_percent > 40 && $disk_use_percent < 80 ? 'bg-warning' : 'bg-danger')).'" style="width:'.$disk_use_percent.'%;"></div>
							</div>
							<div class="text-muted  mt-3 mb-0 pt-3">
								<span>'.$stats['space_used'].' / '.$stats['total_space'].' GB Used</span>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-6 col-sm-6 col-md-6 mb-3">
					<div class="card cluster-card1 row w-100 mx-auto">
						<div class="col-sm-12 p-0">
							<div class="row">
								<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
									<i class="fas fa-2x fa-microchip"></i>
								</div>
								<div class="col-lg-8 col-8 col-md-8 pr-4">
									<div class="text-right text-muted h6 m-0">
										Node '._strtoupper($l['cpu']).'
									</div>
									<div class="text-right">
										<h3 class="mb-1" id="cpu_percent"></h3>
									</div>
								</div>
							</div>
							<div class="progress mt-2">
								<div id="cpu_progress" class="progress-bar"></div>
							</div>
							<div class="text-muted  mt-3 mb-0 pt-3">
								<span id="cpu_model"></span>
								<div style="display:none;" class="loader stat-loading position-absolute show-loading"></div>
							</div>
							
						</div>
					</div>
				</div>
				<div class="col-lg-6 col-sm-6 col-md-6 mb-3">
					<div class="card cluster-card1 row w-100 mx-auto">
						<div class="col-sm-12 p-0">
							<div class="row">
								<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
									<i class="fas fa-2x fa-memory"></i>
								</div>
								<div class="col-lg-8 col-8 col-md-8 pr-4">
									<div class="text-right text-muted h6 m-0">
										Node '._strtoupper($l['ram']).'
									</div>
									<div class="text-right">
										<h3 class="mb-1" id="ram_percent"></h3>
									</div>
								</div>
							</div>
							<div class="progress mt-2">
								<div id="ram_progress" class="progress-bar "></div>
							</div>
							<div class="text-muted  mt-3 mb-0 pt-3">
								<span id="ram_stat"></span>
								<div style="display:none;" class="loader stat-loading position-absolute show-loading"></div>
							</div>
							
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<! -- exp ROw -->
		<div class="row mx-auto w-100">
			<div class="col-lg-6 col-sm-12 col-md-12 mb-0 p-0">
				<div class="row w-100 mx-auto">
					<div class="col-lg-6 col-sm-6 col-md-6 mb-3">
						<div class="card cluster-card1 row w-100 mx-auto">
							<div class="col-sm-12 p-0">
								<div class="row">
									<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
										<i class="fas fa-2x fa-hdd"></i>
									</div>
									<div class="col-lg-8 col-8 col-md-8 pr-4">
										<div class="text-right text-muted h6 m-0">
										Node '._strtoupper($l['disk']).'
										</div>
										<div class="text-right">
											<h3 class="mb-1" id="disk_percent"></h3>
										</div>
									</div>
								</div>
								<div class="progress mt-2">
									<div id="disk_progress" class="progress-bar"></div>
								</div>
								<div class="text-muted  mt-3 mb-0 pt-3">
									<span id="disk_model">Root Partition: </span>
									<div style="display:none;" class="loader stat-loading position-absolute show-loading"></div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-6 col-sm-6 col-md-6 mb-3">
						<div class="card cluster-card1 row w-100 mx-auto">
							<div class="col-sm-12 p-0">
								<div class="row">
									<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
										<i class="fas fa-2x fa-layer-group"></i>
									</div>
									<div class="col-lg-8 col-8 col-md-8 pr-4">
										<div class="text-right text-muted h6 m-0">
										Node '._strtoupper($l['storage']).'
										</div>
										<div class="text-right">
											<h3 class="mb-1" id="storage_percent"></h3>
										</div>
									</div>
								</div>
								<div class="progress mt-2">
									<div id="storage_progress" class="progress-bar"></div>
								</div>
								<div class="text-muted  mt-3 mb-0 pt-3">
									<span id="storage_model"></span>
									<div style="display:none;" class="loader stat-loading position-absolute show-loading"></div>
								</div>	
							</div>
						</div>
					</div>
					<div class="col-lg-6 col-sm-6 col-md-6 mb-3">
						<div class="card cluster-card1 row w-100 mx-auto">
							<div class="col-sm-12 p-0">
								<div class="row">
									<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
										<i class="icon fas fa-2x fa-chart-pie"></i>
									</div>
									<div class="col-lg-8 col-8 col-md-8 pr-4">
										<div class="text-right text-muted h6 m-0">
										Node '._strtoupper($l['bandwidth']).'
										</div>
										<div class="text-right">
											<h3 class="mb-1" id="bandwidth_percent"></h3>
										</div>
									</div>
								</div>
								<div class="progress mt-2">
									<div id="bandwidth_progress" class="progress-bar"></div>
								</div>
								<div class="text-muted  mt-3 mb-0 pt-3">
									<span id="bandwidth_model"></span>
									<div style="display:none;" class="loader stat-loading position-absolute show-loading"></div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-6 col-sm-6 col-md-6 mb-3">
						<div class="card cluster-card1 row w-100 mx-auto">
							<div class="col-sm-12 p-0">
								<div class="row">
									<div class="col-lg-4 col-4 col-md-4 pt-3 pl-4">
										<i class="fas fa-2x fa-clock"></i>
									</div>
									<div class="col-lg-8 col-8 col-md-8 pr-4">
										<div class="text-right text-muted h6 m-0">
										Node '._strtoupper($l['iowait']).'
										</div>
										<div class="text-right">
											<h3 class="mb-1" id="iowait_percent"></h3>
										</div>
									</div>
								</div>
								<div class="progress mt-2">
									<div id="iowait_progress" class="progress-bar"></div>
								</div>
								<div class="text-muted  mt-3 mb-0 pt-3">
									<span id="iowait_model"></span>
									<div style="display:none;" class="loader stat-loading position-absolute show-loading"></div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="col-lg-6 col-sm-12 col-md-12 mb-0 text-center">
				<div class="card cluster-card1" style="height: 333px;">
					<div class="pt-2" id="image_cpu"></div>
					<div class="card-body">
						<h5 class="card-title" id="cpu_name"></h5>
						<p class="card-text">'.$l['uptime'].' <span id="server_uptime"></span></p>
					</div>
					<ul class="list-group list-group-flush text-left">
						<li class="list-group-item " >Architecture: &nbsp <span class="font-weight-light text-admin" id="arch"></span></li> 
						<li class="list-group-item " >'.$l['os'].' &nbsp <span class="font-weight-light text-admin" id="osname"></span></li> 
						<li class="list-group-item " >'.$l['kernel'].' &nbsp <span class="font-weight-light text-admin" id="kernelname"></span></li>
						<li class="list-group-item ">Virtualization: &nbsp <span class="font-weight-light text-admin" id="virt_type"></span></li>
					</ul>
				</div>
			</div>
		</div>
	<! -- exp ROw -->';
}

//modals

//VPS INFO

echo '
	<div class="row mx-auto w-100">
		<div class="col-sm-12 p-1">
			<div class="divroundshad">
				<div class="row mx-auto w-100">
					<div class="col-sm-6">
						<div class="card ser-info  mb-2">
							<div class="card-header roundheader">
								<span>'.$l['server_status'].' ('.($stats['online_servers'].'/'.$stats['servers']).' '.$l['online'].')</span>
								<i class="icon icon-servers float-right h6 m-0 mt-1"></i>
							</div>
							<div class="card-body p-0 scrollbar-virt">
								<table class="table table-hover table-dash shadow-none">
									<thead>
										<tr>
											<th align="center" class="admin_panel_table">#</th>
											<th class="admin_panel_table">'.$l['server'].'</th>
											<th class="admin_panel_table">'.$l['vps'].'</th>
											<th class="admin_panel_table">'.$l['version'].'</th>
											<th class="admin_panel_table">'.$l['licence_expires'].'</th>
											<th class="admin_panel_table">'.$l['status'].'</th>
										</tr>
									</thead>
									<tbody>'; 
									
									foreach($servers as $s) {
										if($s['status'] == 0) {
											$status_txt = $l['offline'];
										} else if($s['status'] == 1) {
											$status_txt = $l['online'];
										} else {
											$status_txt = $l['licence_expired'];
										}

										if(($s['serid'] == 0) && !empty($globals['is_master_only'])){
											$s['virt'] = 'msonly';
										}
										
										echo '<tr>
											<td class="border-0">'.show_virt_type($s['virt']).'</td>
											<td class="border-0">'.$s['server_name'].' ('.$s['ip'].')</td>
											<td class="border-0">'.(empty($s['numvps']) ? '0' : $s['numvps']).'</td>
											<td class="border-0">'.(empty($s['version']) ? '-' : $s['version'].' ('.$s['patch'].')').'</td>
											<td class="border-0">'.(empty($s['lic_expires']) ? '-' : $s['lic_expires']).'</td>
											<td class="border-0" align="center">
											<i class="fas fa-circle h6 m-0 server-status '.($s['status'] == 1 ? 'fa-circle-green' : 'fa-circle-red').'" tooltip="'.$status_txt.'"></i>
											</td>
										</tr>';
									}
									
									echo '</tbody>
								</table>
							</div>
						</div>
					</div>
					<div class="col-sm-6">
						<div class="card ser-info ">
							<div class="card-header roundheader">
								<span>'.$l['vps_info'].'</span>
								<i class="fas fa-server float-right h6 m-0 mt-1"></i>
							</div>
							<div class="card-body p-0 scrollbar-virt">
								<table class="table table-hover table-dash shadow-none">
									<tbody>';
									foreach($num_virts as $v){
										if(!empty($stats['num_'.$v])){
											echo '<tr>
												<td class="border-0">'.$l[$v.'_vm'].'</td>
												<td class="border-0 min_width"><span>'.$stats['num_'.$v].'</span></td>
											</tr>';
										}
									}
									echo '</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
				
			</div>
		</div>
	</div>
';

echo '
	<div class="row mx-auto w-100">
		<div class="col-sm-12 p-1">
			<div class="divroundshad">
				<div class="row mx-auto w-100">
					<div class="col-sm-6">
						<div id="panel-tasks" class="card recent  mb-2">
							<div class="card-header roundheader">
								<span>'.$l['recent_tasks'].'</span>
								<i class="fas fa-tasks float-right h6 m-0 mt-1"></i>
							</div>
							<div class="card-body p-0 scrollbar-virt">
								<table class="table table-hover table-dash shadow-none">
									<thead>
										<tr>
											<th class="admin_panel_table">'.$l['user'].'</th>
											<th class="admin_panel_table">'.$l['action'].'</th>
											<th class="admin_panel_table min_width text-center">'.$l['logs'].'</th>
										</tr>
									</thead>
									<tbody>';
									
									foreach($stats['tasks'] as $task) {
										echo '<tr>
											<td  class="border-0">'.(empty($task['uid']) ? 'root' : $task['email']).'</td>
											<td  class="border-0">'.$l[$task['action']].'</td>
											<td  class="border-0 text-center"><button class="btn btn-logs" onclick="loadlogs('.$task['actid'].');">'.$l['show'].'</button></td>
										</tr>';
									}
									
									echo '</tbody>
								</table>
							</div>
						</div>
					</div>
					<div class="col-sm-6">
						<div id="panel-logins" class="card recent  mb-2">
							<div class="card-header roundheader">
								<span>'.$l['recent_logins'].'</span>
								<i class="fas fa-users float-right h6 m-0 mt-1"></i>
							</div>
							<div class="card-body p-0 scrollbar-virt">
								<table class="table table-hover table-dash shadow-none">
									<tbody>';
									
									foreach($stats['logins'] as $login) {
										// If it's not today's date then include date in string
										$time_text = datify($login['time'], 1, 1);
										
										echo '<tr>
											<td class="border-0">
												'.(empty($login['name']) ? '' : '<div>'.$login['name'].'</div>').'
												<div>'.(empty($login['name']) ? $login['username'] : '<span style="color: rgba(0,0,0,0.54)">'.$login['username'].'</span>').'</div>
											</td>
											<td class="border-0" align="right">'.$time_text.'</td>
										</tr>';
									}
									echo '</tbody>
								</table>
							</div>
						</div>
					</div>
				</div>
				
			</div>
		</div>
	</div>
';

echo '<div class="row mx-auto w-100 my-3">
		<div class="col-sm-12">
			<div class="card">
				<div class="card-header roundheader">
				'.$l['server_stats'].'
				</div>
				<div class="card-body bgaddv p-0">
					<div class="row mx-auto w-100 mb-2">
						<div class="hidden-xs col-md-3"></div>
						<div class="col-xs-12 col-md-6"><br>
							<select id="cserver" class="custom-select virt-select" onchange="callserverstats(this.value)" disabled>';		
							foreach($servers as $k => $v){
								echo '<option value="'.$k.'" '.($globals['server'] == $k ? 'selected="selected"' : '').'>'.$v['server_name'].'</option>';
							}
							echo '<option value="-1">'.$l['all_servers'].'</option></select>
						</div>
						<div class="hidden-xs col-md-3"></div>
					</div>';
					
					foreach($servers as $k => $v){
							
						echo '
							<div class="card" id="server-stats'.$k.'">
								<div class="card-body p-0">
								<div id="row_server_loading'.$k.'" class="row mx-auto w-100 my-5 py-5" style="display:none;">
								<div class="col-sm-12 text-center my-5">
									<center><div class="loader-lg"></div></center>
								</div>
							</div>
								<div class="e_notice mx-0" style="display:none;" id="server_error'.$k.'"></div>
								<div id="row_server_graphs'.$k.'" class="row mx-auto w-100 mb-3" style="display:none;">
								<div class="pl-4 row w-100 mx-auto text-dark">
									'.$l['server'].' : '.ucwords($v['server_name']).'
								</div>				
								<div class="hidden-xs col-lg-1"></div>
								<div id="server_cpu'.$k.'" class="server_gr col-xs-6 col-sm-6 col-md-4 col-lg-2">
									<div class="title">'.$l['cpu'].'</div>
									<div class="content">
										<div class="text">
											<div class="value">0</div>
											<div>'.$l['used'].'</div>
										</div>
										<div class="chart" data-percent="0"></div>
									</div>
									<div class="bottom-text">0</div>
								</div>
								<div id="server_ram'.$k.'" class="server_gr col-xs-6 col-sm-6 col-md-4 col-lg-2">
									<div class="title">'.$l['ram'].'</div>
									<div class="content">
										<div class="text">
											<div class="value">0</div>
											<div>'.$l['used'].'</div>
										</div>
										<div class="chart" data-percent="0"></div>
									</div>
									<div class="bottom-text">0</div>
								</div>
								<div id="server_disk'.$k.'" class="server_gr col-xs-6 col-sm-6 col-md-4 col-lg-2">
									<div class="title">'.$l['disk'].'</div>
									<div class="content">
										<div class="text">
											<div class="value">0</div>
											<div>'.$l['used'].'</div>
										</div>
										<div class="chart" data-percent="0"></div>
									</div>
									<div class="bottom-text">0</div>
								</div>
								<div id="server_storage'.$k.'" class="server_gr col-xs-6 col-sm-6 col-md-6 col-lg-2">
									<div class="title">'.$l['storage'].'</div>
									<div class="content">
										<div class="text">
											<div class="value">0</div>
											<div>'.$l['used'].'</div>
										</div>
										<div class="chart" data-percent="0"></div>
									</div>
									<div class="bottom-text">0</div>
								</div>
								<div id="server_band'.$k.'" class="server_gr col-xs-12 col-sm-12 col-md-6 col-lg-2">
									<div class="title">'.$l['bandwidth'].'</div>
									<div class="content">
										<div class="text">
											<div class="value">0</div>
											<div>'.$l['used'].'</div>
										</div>
										<div class="chart" data-percent="0"></div>
									</div>
									<div class="bottom-text">0</div>
								</div>
								<div class="hidden-xs col-lg-1"></div>
							</div>
							
							<div id="row_server_table'.$k.'" class="row mx-auto w-100" style="display:none;">
								<div class="col-xs-12 col-md-12">
									<div>
										<table class="table table-hover shadow-none" width="100%" cellspacing="1" cellpadding="6" border="0" align="center">
											<tbody>
											<tr>
												<td rowspan="5" class="text-center" valign="middle">
													<div>'.$l['poweredby'].'</div><br />
													<div id="server_poweredby'.$k.'"></div>
												</td>
												<td>'.$l['uptime'].'</td>
												<td id="server_uptime'.$k.'"></td>
											</tr>
											<tr>
												<td>'.$l['os'].'</td>
												<td class="font-weight-bold" id="server_os'.$k.'"></td>
											</tr>
											<tr>
												<td>'.$l['cpumodel'].'</td>
												<td id="cpumodel'.$k.'"></td>
											</tr>
											<tr>
												<td>'.$l['kernel'].'</td>
												<td id="server_kernel'.$k.'"></td>
											</tr>
											<tr>
												<td>'.$l['numvps'].'</td>
												<td id="server_vps'.$k.'"></td>
											</tr>
											</tbody>
										</table>
									</div>
								</div>
							</div>
							</div>
						</div>
						';
					}
				echo '
					</div>
				</div>
			</div>
	</div>';

echo '
<script language="javascript" type="text/javascript" src="https://a.softaculous.com/virtualizor/latestinfo.php"></script>
<script type="text/javascript">
Chart.defaults.color="#939393";
let d1 = [];
let d2 = [];
var c = document.getElementById("bandwidth_graph");
var ctx = c.getContext("2d");

var gradient = ctx.createLinearGradient(0, 0, 0, 400);
var gradient1 = ctx.createLinearGradient(0, 0, 0, 400);

gradient.addColorStop(0, "rgba(250,174,50,1)");   
gradient.addColorStop(1, "rgba(250,174,50,0)");

gradient1.addColorStop(0, "rgba(103,119,239,1)");
gradient1.addColorStop(1, "rgba(250,174,50,0)");


let dayScale = makedata("", 31);
const bw_data = {
	labels: dayScale,
	datasets: [{
	label: "Bandwidth In",
	data: d1,
	color:"#110000",
	fill: true,
	borderWidth: "2",
	backgroundColor: gradient1,
	borderColor: "#515dbc",
	strokeColor : "#515dbc",
	pointColor : "#fff",
	pointStrokeColor : "#515dbc",
	pointHighlightFill: "#fff",
	pointHighlightStroke: "#515dbc",
	tension: 0.3
	},
	{type: "line",
			label: "Bandwidth OUT",
			borderWidth: "2",
			backgroundColor: gradient,
			borderColor: "#ff6c23",
			strokeColor : "#ff6c23",
			pointColor : "#fff",
			pointStrokeColor : "#ff6c23",
			pointHighlightFill: "#fff",
			pointHighlightStroke: "#ff6c23",
			fill: true,
			tension: 0.3,
			data: d2}
	]
};

const bw_config = {
	type: "line",
	data: bw_data,
	options : {
		responsive: true,
		maintainAspectRatio: false,
		scales: {
			x: {
				title: {
					display: true,
					text: "Days"
				}
			},
			y: {
				display: true,
				min:0,
				ticks: {
					beginAtZero: true,
					callback: function(value, index, values) {
						return (value/1024).toFixed(2) + \'GB\';
					}
				},
			}
		},
		plugins: {
			tooltip: {
				callbacks: {
					label: function(tooltipItem) {
						return tooltipItem.dataset.label+" : "+ ((tooltipItem.parsed.y)/1024).toFixed(2) + "GB";
					},
					title: function(tooltipItem) {
						return "Day : "+ tooltipItem[0].label;
					}
				}
			}
		}   
	}
};
	var servers = new Array('.implode(', ', array_keys($servers)).');	
	function callserverstats(serid){
		if(serid < 0){
			if(empty(servers)){
				getserverstats(0);
			}else{
				$("#cserver").prop("disabled", true);
				servers.sort(function(a, b){return b-a});
				for(x in servers){	
					//alert(servers[x]);
					getserverstats(servers[x]);				
				}
			}
		}else{
			$("#cserver").prop("disabled", true);
			getserverstats(serid);			
		}
		
	}
	
	function hideserverstats(){
		if(!empty(servers) && $("#cserver").find("option:selected").val() >= 0){
			for(x in servers){
				$("#row_server_graphs"+servers[x]).hide();
				$("#row_server_table"+servers[x]).hide();
				$("#server_error"+servers[x]).hide();
			}
		}
	}
	
	function getserverstats(serid){
		//$_("refresh_status").src = "'.$theme['images'].'admin/vpsloading.gif";
		
		serid = serid || 0;		
		
		$("#server_error").hide();
		$("#row_server_loading"+serid).show();
		hideserverstats();
		
		$.getJSON("'.$globals['index'].'act=manageserver&changeserid="+serid+"&api=json", function(data) {
			
			$("#cserver").prop("disabled", false);
			$("#row_server_loading"+serid).hide();
			
			// Is it offline ?
			if(data["offline"]){
				//showalert(data["offline"] ,"1");
				$("#server_error"+serid).html("<b>'.$l['note'].' : </b> &nbsp;" + data["offline"]);
				$("#server_error"+serid).show();
				return false;
			}
			
			$("#row_server_graphs"+serid).show();
			$("#row_server_table"+serid).show();
			
			// Its online
			// CPU
			var cpu_per = data["usage"]["cpu"]["percent"].toFixed(2);
			$("#server_cpu"+serid+" .chart").data("easyPieChart").update(cpu_per);
			$("#server_cpu"+serid+" .value").text(cpu_per + "%");
			$("#server_cpu"+serid+" .bottom-text").text(cpu_per + " %");
			
			// RAM
			var ram_per = data["usage"]["ram"]["percent"].toFixed(2);
			var ram_used = data["usage"]["ram"]["used"];
			var ram_limit = data["usage"]["ram"]["limit"];
			$("#server_ram"+serid+" .chart").data("easyPieChart").update(ram_per);
			$("#server_ram"+serid+" .value").text(ram_per + "%");
			$("#server_ram"+serid+" .bottom-text").text(ram_used + " / " + ram_limit + " MB");

			// DISK
			var disk_per = data["usage"]["disk"]["/"]["percent"].toFixed(2);
			var disk_used = data["usage"]["disk"]["/"]["used_gb"];
			var disk_limit = data["usage"]["disk"]["/"]["limit_gb"];
			$("#server_disk"+serid+" .chart").data("easyPieChart").update(disk_per);
			$("#server_disk"+serid+" .value").text(disk_per + "%");
			$("#server_disk"+serid+" .bottom-text").text(disk_used + " / " + disk_limit + " GB");
			
			// VPS Storage DISK
			var vps_used = (data["info"]["resources"]["total_space"] - data["info"]["resources"]["space"]).toFixed(2);
			var vps_total = data["info"]["resources"]["total_space"];
			var vps_per = (vps_used / vps_total * 100).toFixed(2);
			$("#server_storage"+serid+" .chart").data("easyPieChart").update(vps_per);
			$("#server_storage"+serid+" .value").text(vps_per + "%");
			$("#server_storage"+serid+" .bottom-text").text(vps_used + " / " + vps_total + " GB");
			
			// Bandwidth
			var band_per = data["usage"]["bandwidth"]["percent"].toFixed(2);
			var band_used = data["usage"]["bandwidth"]["used_gb"];
			var band_limit = data["usage"]["bandwidth"]["limit_gb"];
			$("#server_band"+serid+" .chart").data("easyPieChart").update(band_per);
			$("#server_band"+serid+" .value").text(band_per + "%");
			$("#server_band"+serid+" .bottom-text").text(band_used + " / " + band_limit + " GB");
			
			if((data["info"]["check_kernel"]).length > 10){
				//showalert(data["info"]["check_kernel"] ,"1");
				$_("server_error"+serid).innerHTML = \'<b>NOTE : </b>&nbsp; \'+data["info"]["check_kernel"];
				$("#server_error"+serid).show();
			}else{
				$("#server_error"+serid).hide();
			}
			
			$_("server_uptime"+serid).innerHTML = data["info"]["uptime"];
			$_("server_os"+serid).innerHTML = data["info"]["os"]["name"];
			$_("server_kernel"+serid).innerHTML = data["info"]["kernel_name"];
			$_("server_poweredby"+serid).innerHTML = \'<img src="'.$theme['svg'].'\'+data["usage"]["cpu"]["manu"]+\'.svg" style="height:40px"/>\';
			$_("server_vps"+serid).innerHTML = data["info"]["numvps"] ? data["info"]["numvps"] : 0;
			$_("cpumodel"+serid).innerHTML = data["usage"]["cpu"]["cpumodel"];
		});
	}
';

if($acl_server_statistics){
echo '$(document).ready(function(){
		getserverstats('.$globals['server'].');
	});';
}

echo '
let bw_ctx = document.getElementById("bandwidth_graph");
let bwChart = new Chart(bw_ctx, bw_config );

$(document).ready(function(){
	$_("softnews").style.width = $_("softnewsholder").offsetWidth;
	//The news
	if(typeof(soft_news) == "undefined"){
		$_("softnews").innerHTML = "'.$l['conect_to_soft'].'";
	}else{
		var newsstr = "";
		for(x in soft_news){
			newsstr = newsstr+\'<div class="softnewshead">\'+soft_news[x][0]+\'</div>\'+\'<div class="softnewsblock">\'+soft_news[x][1]+\'</div><br />\';
		}
		$_("softnews").innerHTML = newsstr;
	}
	
	$(".close_pinguzo_banner").click(function(){
		 $.ajax({
			url: "'.$globals['index'].'disable_pinguzo_ban=1", 
			success: function(result){
				$("#close_pinguzo_banner_div").hide();
			}
		});
	});

});
</script>
<div class="row mx-auto w-100">
	<div class="col-sm-12">
		<div class="roundheader border-bottom">'.$l['news'].'</div>
		<div class="bgaddv">			
			<div id="softnewsholder">
			<div class="softnews scrollbar-virt" id="softnews"></div>
			</div>
		</div>
	</div>
</div>
';

if(!file_exists($globals['var'].'/disable_pinguzo_banner.txt')){
	echo '
	<div class="row mx-auto w-100 my-4">
		<div class="col-sm-12">
			<div class="clearfix"></div>
			<div class="alert alert-primary" id="close_pinguzo_banner_div">
				<div class="row mx-auto w-100">
					<div class="col-11">
						<h3 class="mb-2">Pinguzo - Server and Website Monitoring</h3>
					</div>
					<div class="col-1 p-0">
						<a title="Close this" class="close_pinguzo_banner cursor-pointer d-inline-block float-right h4 m-0"><b><i class="fas fa-times"></i></b></a>
					</div>
				</div>
				<div class="row mx-auto w-100">
					<div class="col-sm-5">
						<span class="m-0">We have been developing Pinguzo, which is a Server and Website Monitoring SaaS. As you know, downtime can happen on your Servers and Websites. Pinguzo can send notifications instantly, so that you can take corrective steps. 
						<br>You can use your <b>Softaculous Account to Sign In</b>. Since its a SaaS, you will not need to manage any storage or processes related to monitoring.
						<center class="my-3"><a href="https://cp.pinguzo.com" class="btn btn-lg btn-success" target="new">Let\'s Try Pinguzo</a></center>
						<br>If you have any feedback / questions, please do let us know - <a href="mailto:support%40pinguzo.com">support@pinguzo.com</a>.</span>
					</div>
					<div class="col-sm-7">
						<img src="https://pinguzo.com/images/servers.jpg" class="img-responsive w-100">
					</div>
				</div>
			</div>
		</div>
	</div>';
}

echo '
';
//footer start
echo softfooter();
//footer end


echo '<script type="text/javascript">




	function bar_color(v) {
		if(v <= 50) {
			return "#6BCB77";
		} else if(v <= 80) {
			return "#ffd600";
		} else {
			return "#FF6B6B";
		}
	}

    $(".chart").easyPieChart({
		barColor: bar_color,
		trackColor: "#f2f2f2",
		scaleColor: "#cccccc",
		animate: { duration: 1000, enabled: true },
		lineWidth: 10,
		size: 140,
		lineCap: "cap"
	});

    $(".chart-ram").easyPieChart({
		barColor: "#3083FF",
		trackColor: "rgba(48,131,255,0.3)",
		scaleColor: "#3083FF",
		animate: { duration: 1000, enabled: true },
		lineWidth: 4,
		size: 80,
		lineCap: "cap"
	});
	$(".chart-storage").easyPieChart({
		barColor: "#3083FF",
		trackColor: "rgba(48,131,255,0.3)",
		scaleColor: "#3083FF",
		animate: { duration: 1000, enabled: true },
		lineWidth: 4,
		size: 80,
		lineCap: "cap"
	});
	
	
</script>
';


}

?>
