/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.rfbplayer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

class LWScrollPane
extends Container
implements AdjustmentListener {
    private Point scrollPosition = new Point(0, 0);
    private Panel innerPanel = new Panel(){

        public void update(Graphics graphics) {
            if (LWScrollPane.this.needClear) {
                super.update(graphics);
                LWScrollPane.this.needClear = false;
            } else {
                this.paint(graphics);
            }
        }
    };
    private Component containedComp;
    private GridBagLayout gb;
    private GridBagConstraints gbc;
    private Scrollbar xScroller = new Scrollbar(0){

        public boolean isFocusable() {
            return false;
        }
    };
    private Scrollbar yScroller = new Scrollbar(1){

        public boolean isFocusable() {
            return false;
        }
    };
    private boolean showingXScroll = false;
    private boolean showingYScroll = false;
    private boolean needClear = false;
    private int width = 0;
    private int height = 0;

    public LWScrollPane() {
        this.xScroller.addAdjustmentListener(this);
        this.yScroller.addAdjustmentListener(this);
        this.gb = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.setLayout(this.gb);
        this.setBackground(Color.white);
        this.gbc.fill = 1;
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 100.0;
        this.gbc.weighty = 100.0;
        this.gb.setConstraints(this.innerPanel, this.gbc);
        this.add(this.innerPanel);
        this.innerPanel.setLayout(null);
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        super.setSize(n, n2);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void clearAndRepaint() {
        this.needClear = true;
        this.innerPanel.repaint();
    }

    void addComp(Component component) {
        this.containedComp = component;
        this.innerPanel.add(this.containedComp);
    }

    void setScrollPosition(int n, int n2) {
        Dimension dimension = this.getViewportSize();
        Dimension dimension2 = this.containedComp.getPreferredSize();
        if (dimension2.width <= dimension.width && dimension2.height <= dimension.height) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (dimension2.width <= dimension.width) {
            n = 0;
        } else if (n > dimension2.width - dimension.width) {
            n = dimension2.width - dimension.width;
        }
        if (dimension2.height <= dimension.height) {
            n2 = 0;
        } else if (n2 > dimension2.height - dimension.height) {
            n2 = dimension2.height - dimension.height;
        }
        this.scrollPosition = new Point(n, n2);
        this.containedComp.setLocation(-this.scrollPosition.x, -this.scrollPosition.y);
        this.xScroller.setValue(this.scrollPosition.x);
        this.yScroller.setValue(this.scrollPosition.y);
    }

    Point getScrollPosition() {
        return new Point(this.scrollPosition);
    }

    public Dimension getViewportSize() {
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.showingYScroll) {
            n -= this.yScroller.getSize().width;
        }
        if (this.showingXScroll) {
            n2 -= this.xScroller.getSize().height;
        }
        return new Dimension(n, n2);
    }

    public void doLayout() {
        boolean bl = false;
        boolean bl2 = false;
        Dimension dimension = this.containedComp.getPreferredSize();
        Dimension dimension2 = this.getSize();
        if (dimension.width > dimension2.width) {
            bl = true;
        }
        if (dimension.height > dimension2.height) {
            bl2 = true;
        }
        this.showingXScroll = false;
        this.showingYScroll = false;
        this.remove(this.yScroller);
        this.remove(this.xScroller);
        if (bl2) {
            this.gbc.gridy = 0;
            this.gbc.gridx = 1;
            this.gbc.weightx = 0.0;
            this.gb.setConstraints(this.yScroller, this.gbc);
            this.add(this.yScroller);
            this.showingYScroll = true;
        }
        if (bl) {
            this.gbc.gridy = 1;
            this.gbc.gridx = 0;
            this.gbc.weightx = 100.0;
            this.gbc.weighty = 0.0;
            this.gb.setConstraints(this.xScroller, this.gbc);
            this.add(this.xScroller);
            this.showingXScroll = true;
        }
        int n = dimension2.width;
        int n2 = dimension2.height;
        if (this.showingYScroll) {
            n -= this.yScroller.getSize().width;
        }
        if (this.showingXScroll) {
            n2 -= this.xScroller.getSize().height;
        }
        this.yScroller.setValues(0, n2, 0, dimension.height);
        this.xScroller.setValues(0, n, 0, dimension.width);
        this.containedComp.setLocation(0, 0);
        super.doLayout();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Point point = this.containedComp.getLocation();
        if (adjustmentEvent.getAdjustable() == this.xScroller) {
            point.x = -adjustmentEvent.getValue();
            this.scrollPosition.x = adjustmentEvent.getValue();
        } else {
            point.y = -adjustmentEvent.getValue();
            this.scrollPosition.y = adjustmentEvent.getValue();
        }
        this.containedComp.setLocation(point);
    }
}

