/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.rfbplayer;

import com.tightvnc.rfbplayer.RfbPlayer;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class ButtonPanel
extends Panel
implements ActionListener {
    protected RfbPlayer player;
    protected Button playButton;
    protected TextField posText;
    protected TextField timeScaleText;
    protected int lastPosSeconds = -1;

    ButtonPanel(RfbPlayer rfbPlayer) {
        this.player = rfbPlayer;
        this.setLayout(new FlowLayout(0, 0, 0));
        this.playButton = new Button("Play");
        this.playButton.setEnabled(false);
        this.add(this.playButton);
        this.playButton.addActionListener(this);
        this.add(new Label(" Position:"));
        this.posText = new TextField(5);
        this.add(this.posText);
        this.posText.addActionListener(this);
        this.add(new Label(" Speed:"));
        this.timeScaleText = new TextField(5);
        this.timeScaleText.setText(String.valueOf(rfbPlayer.getSpeed()));
        this.add(this.timeScaleText);
        this.timeScaleText.addActionListener(this);
    }

    public void setPaused(boolean bl) {
        if (bl) {
            this.playButton.setLabel("Play");
        } else {
            this.playButton.setLabel("Pause");
        }
        this.playButton.setEnabled(true);
    }

    public void setPos(long l) {
        int n = (int)(l / 1000L);
        if (n != this.lastPosSeconds) {
            this.lastPosSeconds = n;
            char[] cArray = new char[]{'0', '0', '0', '0'};
            String string = String.valueOf(n);
            if (string.length() < 4) {
                string = new String(cArray, 0, 4 - string.length()) + string;
            }
            this.posText.setText(string);
            this.posText.setCaretPosition(string.length());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.playButton) {
            this.player.setPaused(this.playButton.getLabel().equals("Pause"));
        } else if (actionEvent.getSource() == this.posText) {
            this.player.setPos(Long.parseLong(this.posText.getText()) * 1000L);
        } else if (actionEvent.getSource() == this.timeScaleText) {
            double d = Double.valueOf(this.timeScaleText.getText());
            if (d <= 0.0) {
                d = 1.0;
            }
            this.timeScaleText.setText(String.valueOf(d));
            this.player.setSpeed(d);
        }
    }
}

