/*
 * Decompiled with CFR 0.152.
 */
package com.tightvnc.decoder;

import com.tightvnc.vncviewer.RfbInputStream;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import java.io.DataOutput;
import java.io.IOException;

public class RawDecoder {
    static final int EncodingRaw = 0;
    protected int bytesPerPixel = 4;
    protected int framebufferWidth = 0;
    protected int framebufferHeight = 0;
    protected RfbInputStream rfbis = null;
    protected Graphics graphics = null;
    protected DataOutput dos = null;
    protected boolean enableEncodingRecordWritting = true;
    protected static byte[] pixels8 = null;
    protected static int[] pixels24 = null;
    protected static MemoryImageSource pixelsSource = null;
    protected static Image rawPixelsImage = null;
    private static ColorModel cm8 = null;
    private static ColorModel cm24 = null;
    private static Color[] color256 = null;

    public RawDecoder(Graphics graphics, RfbInputStream rfbInputStream) {
        this.setGraphics(graphics);
        this.setRfbInputStream(rfbInputStream);
    }

    public RawDecoder(Graphics graphics, RfbInputStream rfbInputStream, int n, int n2) {
        this.setGraphics(graphics);
        this.setRfbInputStream(rfbInputStream);
        this.setFrameBufferSize(n, n2);
        cm24 = new DirectColorModel(24, 0xFF0000, 65280, 255);
    }

    public void setRfbInputStream(RfbInputStream rfbInputStream) {
        this.rfbis = rfbInputStream;
    }

    public void setGraphics(Graphics graphics) {
        this.graphics = graphics;
    }

    public void setBPP(int n) {
        this.bytesPerPixel = n;
    }

    public void setFrameBufferSize(int n, int n2) {
        this.framebufferWidth = n;
        this.framebufferHeight = n2;
    }

    public void setDataOutputStream(DataOutput dataOutput) {
        this.dos = dataOutput;
    }

    public void handleRect(int n, int n2, int n3, int n4) throws IOException, Exception {
        if (this.dos != null && this.enableEncodingRecordWritting) {
            this.dos.writeInt(0);
        }
        if (this.bytesPerPixel == 1) {
            for (int i = n2; i < n2 + n4; ++i) {
                if (pixels8 != null) {
                    this.rfbis.readFully(pixels8, i * this.framebufferWidth + n, n3);
                }
                if (this.dos == null) continue;
                this.dos.write(pixels8, i * this.framebufferWidth + n, n3);
            }
        } else {
            byte[] byArray = new byte[n3 * 4];
            for (int i = n2; i < n2 + n4; ++i) {
                this.rfbis.readFully(byArray);
                if (this.dos != null) {
                    this.dos.write(byArray);
                }
                int n5 = i * this.framebufferWidth + n;
                if (pixels24 == null) continue;
                for (int j = 0; j < n3; ++j) {
                    RawDecoder.pixels24[n5 + j] = (byArray[j * 4 + 2] & 0xFF) << 16 | (byArray[j * 4 + 1] & 0xFF) << 8 | byArray[j * 4] & 0xFF;
                }
            }
        }
        this.handleUpdatedPixels(n, n2, n3, n4);
    }

    protected void handleUpdatedPixels(int n, int n2, int n3, int n4) {
        pixelsSource.newPixels(n, n2, n3, n4);
        this.graphics.setClip(n, n2, n3, n4);
        this.graphics.drawImage(rawPixelsImage, 0, 0, null);
        this.graphics.setClip(0, 0, this.framebufferWidth, this.framebufferHeight);
    }

    public void update() {
        int n = this.framebufferWidth;
        int n2 = this.framebufferHeight;
        if (this.bytesPerPixel == 1) {
            pixels24 = null;
            pixels8 = new byte[n * n2];
            pixelsSource = new MemoryImageSource(n, n2, this.getColorModel8(), pixels8, 0, n);
        } else {
            pixels8 = null;
            pixels24 = new int[n * n2];
            pixelsSource = new MemoryImageSource(n, n2, cm24, pixels24, 0, n);
        }
        pixelsSource.setAnimated(true);
        rawPixelsImage = Toolkit.getDefaultToolkit().createImage(pixelsSource);
    }

    protected ColorModel getColorModel8() {
        if (cm8 == null) {
            cm8 = new DirectColorModel(8, 7, 56, 192);
        }
        return cm8;
    }

    protected ColorModel getColorModel24() {
        if (cm24 == null) {
            cm24 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        }
        return cm24;
    }

    protected Color[] getColor256() {
        if (color256 == null) {
            color256 = new Color[256];
            for (int i = 0; i < 256; ++i) {
                RawDecoder.color256[i] = new Color(cm8.getRGB(i));
            }
        }
        return color256;
    }

    protected void enableEncodingRecordWritting(boolean bl) {
        this.enableEncodingRecordWritting = bl;
    }
}

