<?php
$link='https://ircdn.zhaket.com/public/zhaket-installer/zhaket.installer.zip?t='.time();

function ionCube_active($error)
{
    if (!extension_loaded('ionCube Loader')) {
        $error[] = 'به نظر میرسد ionCube روی هاست شما فعال نیست.';
    }elseif (!function_exists('ioncube_loader_version') || !version_compare(ioncube_loader_version(),'12.0','>=')) {
        $error[]= 'به نظر میرسد ionCube روی هاست شما فعال نیست یا نسخه آن کمتر از ۱۲ می‌باشد.';
    }
    return $error;
}

function php_version_status($error){
    if(version_compare(phpversion(),"7.4",'<')) {
        $error[] = 'ژاکت اینستالر با نسخه 7.4 و 8.1 php سازگار می‌باشد.';
    }
    return $error;
}

function check_functions_exists(){
    $func_list=['curl_init','file_get_contents','file_put_contents','fopen','rename','unlink','glob','mkdir','ini_set','version_compare','extension_loaded','phpversion'];
    $error=[];
    foreach ($func_list as $func){
        if (!function_exists($func)){
            $error[]= 'تابع ' . $func .' در هاست شما فعال نیست.';
        }
    }
    return $error;
}

function check_class_exists($error){
    $class_list=['ZipArchive','mysqli'];
    foreach ($class_list as $class){
        if (!class_exists($class)){
            $error[]='کلاس ' . $class .' در هاست شما فعال نیست';
        }
    }
    return $error;
}

function check_dependency(){
    $error=check_functions_exists();
    $error=check_class_exists($error);
    $error=php_version_status($error);
    return ionCube_active($error);
}
function get_request_site(){
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $path = $_SERVER['REQUEST_URI'];
    if (!empty(pathinfo($path, PATHINFO_EXTENSION)) ) {
        $path = dirname($path);
        if (in_array($path,['/','.'])){
            $path = '';
        }
    }
    $fullUrl = $protocol . '://' . $host.$path ;
    return $fullUrl;
}

function print_error($error){
    echo '<div style="border: 2px solid #ff00006b; border-radius: 4px; background: #ff000017; padding: 20px; margin-bottom: 20px;">';
    echo '<h3 style="font-family: iransans,sans-serif!important ">خطایی رخ داده!</h3>';
    echo '<ul>';
    foreach ($error as $item){
        echo '<li style="padding-top: 5px;">'.$item.'</li>';
    }
    echo '</ul>';
    echo '</div>';
    echo ' <p>برای رفع خطاهای فوق ، کافیست به پشتیبانی هاست خود تیکت ارسال فرمایید و این موارد را اعلام نمایید.</p>';
}
function start_process($link){
    $error=check_dependency();
    if (!empty($error)){
        print_error($error);
        return;
    }
    $tempFilePath=__DIR__.'/temp.zip';
    $ch = curl_init($link);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    if ($response === false) {
        echo ('Error: ' . curl_error($ch));
        return;
    }
    curl_close($ch);
    $file = fopen($tempFilePath, 'w');
    if ($file === false) {
        echo ('Error opening local file for writing.');
        return;
    }

    fwrite($file, $response);
    fclose($file);

    $zip = new ZipArchive;
    if ($zip->open($tempFilePath) === TRUE) {
        $zip->extractTo(__DIR__);
        $zip->close();
        @unlink($tempFilePath);
        echo '<script> document.location.href="'.get_request_site().'/auto/" </script>';
        return '';
    }
}


?>
<html lang="fa" dir="rtl"><head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="theme-color" content="#FEA000">
    <meta name="robots" content="noindex,nofollow">
    <link rel="shortcut icon" href="https://ircdn.zhaket.com/public/zhaket-installer/img/favicon.ico">
    <link rel="icon" type="image/x-icon" href="https://ircdn.zhaket.com/public/zhaket-installer/img/favicon.ico">
    <title>ژاکت اینستالر</title>
    <link rel="stylesheet" href="https://ircdn.zhaket.com/public/zhaket-installer/dist/bundle.css?v=1">
    <link rel="stylesheet" href="https://ircdn.zhaket.com/public/zhaket-installer/css/bootstrap.min.css">
</head>

<body>

<header>
    <div class="page-header">
        <div class="page-header__card"><img src="https://www.zhaket.com/static/site/images/logo/zhaket-logo-main-white.svg" title="ژاکت اینستالر" alt="نصب قالب خودکار ژاکت">
            <div class="page-header__card-text">
                <p class="page-header__card-title">ژاکت اینستالر</p>

            </div>
        </div>
    </div>
</header>
<main>
    <section>
            <?php start_process($link); ?>
    </section>

</main>
<footer class="footer">
    <a href="https://www.zhaket.com" class="footer__logo"><img src="https://www.zhaket.com/static/panel/images/footer-logo.svg" alt="ژاکت" title="ژاکت"></a>
    <ul class="footer__nav">
        <li><a href="https://www.zhaket.com/blog/">بلاگ</a></li>
        <li><a href="https://www.zhaket.com/landing/zhaket-affiliate/">همکاری در فروش</a></li>
        <li><a href="https://www.zhaket.com/landing/become-seller/">فروشنده شو</a></li>
        <li><a href="https://academy.zhaket.com/">ژاکت آکادمی</a></li>
        <li><a href="https://www.zhaket.com/content/about">درباره ما</a></li>
        <li><a href="https://www.zhaket.com/content/contact">تماس با ما</a></li>
    </ul>




</footer>

</body></html>