<?php

// load functions
require_once(  'functions.php' );
require_once(  'AjaxResponse.php' );

// Ajax Files
require_once(  'ajax/sms_login_send_mobile.php' );
require_once(  'ajax/sms_login_send_code.php' );
require_once(  'ajax/sms_login_send_again.php' );

register_activation_hook( __FILE__, 'sms_activate' );
function sms_activate() {
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    global $wpdb;

    // Mobile Register / Login SMS Table
    $table_name = $wpdb->prefix . 'sms_mobile_codes';
    $wpdb_collate = $wpdb->collate;
    $sql = 
        "CREATE TABLE {$table_name} (
            `mobile` varchar(20) COLLATE {$wpdb_collate} NOT NULL,
            `code` varchar(8) COLLATE {$wpdb_collate} NOT NULL,
            `send_date` int(20)  NOT NULL,
            `action` varchar(100) COLLATE {$wpdb_collate} not null,
            `data` text COLLATE {$wpdb_collate} NULL,
            PRIMARY KEY (`mobile`)
        )
        COLLATE {$wpdb_collate}";
    
    dbDelta( $sql );
}

function sms_enqueue_assets() {
    // jquery modal
    wp_register_script(
        'jquery-modal',
        get_stylesheet_directory_uri() . '/sms/assets/jquery-modal/jquery.modal.min.js',
        [ 'jquery' ],
        '0.9.1',
        true
    );

    wp_register_style(
        'jquery-modal',
        get_stylesheet_directory_uri() . '/sms/assets/jquery-modal/jquery.modal.min.css',
        [],
        '0.9.1'
    );

    wp_enqueue_script(
        'sms-main',
        get_stylesheet_directory_uri() . '/sms/assets/main.js',
        [ 'jquery-modal' ],
        filemtime( get_theme_file_path() . '/sms/assets/main.js' ),
        true
    );

    wp_enqueue_style(
        'sms-main',
        get_stylesheet_directory_uri() . '/sms/assets/main.css',
        [ 'jquery-modal' ],
        filemtime( get_theme_file_path() . '/sms/assets/main.css' )
    );

$wpurl= get_page_link(op_am['select-page-login']);

    wp_localize_script( 'sms-main', 'smsData', [
        'ajaxUrl' => admin_url( 'admin-ajax.php' ),
        'wpurl' => "a[href='$wpurl']" ,
        'popop' => op_am['active_auth_with_popop'],
    ] );
}
add_action( 'wp_enqueue_scripts', 'sms_enqueue_assets' );

function sms_render_modal(){
    require_once( get_theme_file_path() . '/sms/modal.php' );
}
add_action( 'wp_footer', 'sms_render_modal' );