window.$ = jQuery;

$(document).ready(function(){
    let $modal = $("#modal-userLogin");
    let $sectionMobile = $modal.find(".section-mobile");
    let $formMobile = $modal.find(".section-mobile form");

    let $sectionCode = $modal.find(".section-code");
    let $formCode = $modal.find(".section-code form");

 
    if(smsData.popop == true){
    $(smsData.wpurl).click(function(ev){
        ev.preventDefault();

        $modal.modal({
            showClose: false
        });
    });
    }
        
    
    $formMobile.find("[name=username]").keyup(function(){
        validateMobileForm();

        $modal.find(".mobile-text").text($(this).val());
    });

    $sectionCode.find(".goBack").click(function(ev){
        $sectionCode.hide();
        $sectionMobile.show();
    })

    $formMobile.submit(function(ev){
        ev.preventDefault();
        let $btn = $formMobile.find("button");
        
        if($btn.attr("disabled") == "disabled"){
            return;
        }

        validateMobileForm();
        $input = $formMobile.find("[name=username]");
        if($input.hasClass("input-error")){
            return;
        }

        // disable send button
        $btn.attr("disabled", "disabled");

        $.ajax( {
            "url": smsData.ajaxUrl,
            "method": "post",
            "dataType": "json",
            "data": {
                "action": "sms_login_send_mobile",
                "mobile": $input.val()
            }
        }).done(function(response){
            if(!response.status){
                alert(response.error_message);
                return;
            }

            $sectionMobile.hide();
            $sectionCode.show();
        }).fail(function(){
            alert("خطا در ارتباط سرور. لطفا دوباره تلاش کنید");
        }).always(function(){
            // enable send button
            $btn.removeAttr("disabled");
        });
    });

    $formCode.submit(function(ev){
        ev.preventDefault();
        let $btn = $formCode.find("button");
        
        if($btn.attr("disabled") == "disabled"){
            return;
        }

        validateMobileForm();
        $input = $formCode.find("[name=code]");
        if($input.hasClass("input-error")){
            return;
        }

        // disable send button
        $btn.attr("disabled", "disabled");

        $.ajax( {
            "url": smsData.ajaxUrl,
            "method": "post",
            "dataType": "json",
            "data": {
                "action": "sms_login_send_code",
                "mobile": $formMobile.find("[name=username]").val(),
                "code": $input.val()
            }
        }).done(function(response){
            if(!response.status){
                alert(response.error_message);
                return;
            }

            window.location.reload();
        }).fail(function(){
            alert("خطا در ارتباط سرور. لطفا دوباره تلاش کنید");
        }).always(function(){
            // enable send button
            $btn.removeAttr("disabled");
        });
    });

    // send again
    $sectionCode.find(".sendAgain").click(function(ev){
        ev.preventDefault();

        $link = $(this);
        let $btn = $formCode.find("button");
        
        if($link.attr("disabled") == "disabled"){
            return;
        }

        validateMobileForm();
        $input = $formCode.find("[name=code]");
        if($input.hasClass("input-error")){
            return;
        }

        // disable send button
        $btn.attr("disabled", "disabled");
        $link.attr("disabled", "disabled");

        $.ajax( {
            "url": smsData.ajaxUrl,
            "method": "post",
            "dataType": "json",
            "data": {
                "action": "sms_login_send_again",
                "mobile": $formMobile.find("[name=username]").val(),
            }
        }).done(function(response){
            if(!response.status){
                alert(response.error_message);
                return;
            }

            alert(response.success_message);
        }).fail(function(){
            alert("خطا در ارتباط سرور. لطفا دوباره تلاش کنید");
        }).always(function(){
            // enable send button
            $btn.removeAttr("disabled");
            $link.removeAttr("disabled");
        });
    });

    function validateMobileForm() {
        $el = $formMobile.find("[name=username]");
        $error_el = $formMobile.find(".error-message");

        $el.removeClass("input-error");
        $el.removeClass("input-success");

        let number = $el.val().trim();
        if(number.length < 1){
            $error_el.text("لطفا این قسمت را تکمیل کنید").show();
            $el.addClass("input-error");
            return;
        }

        if(!isMobileNumber(number)){
            $error_el.text("لطفا شماره موبایل صحیح وارد کنید").show();
            $el.addClass("input-error");
            return;
        }

        $el.addClass("input-success");
        $error_el.hide();
    }

    function validateCodeForm() {
        $el = $formMobile.find("[name=username]");
        $error_el = $formMobile.find(".error-message");

        $el.removeClass("input-error");
        $el.removeClass("input-success");

        let number = $el.val().trim();
        if(number.length < 1){
            $error_el.text("لطفا این قسمت را تکمیل کنید").show();
            $el.addClass("input-error");
            return;
        }

        if(!isMobileNumber(number)){
            $error_el.text("لطفا شماره موبایل صحیح وارد کنید").show();
            $el.addClass("input-error");
            return;
        }

        $el.addClass("input-success");
        $error_el.hide();
    }

    /**
     * Convert Persian Digit To English
     * @param string subject
     * @returns string
     */
    function convertPersianDigitToEnglish(subject) {
        var output = subject.replace('۰', '0')
            .replace('۱', '1')
            .replace('۲', '2')
            .replace('۳', '3')
            .replace('۴', '4')
            .replace('۵', '5')
            .replace('۶', '6')
            .replace('۷', '7')
            .replace('۸', '8')
            .replace('۹', '9');

        return output;
    }

    function isMobileNumber(str) {
        let regex = RegExp('^\\b09(\\d{9})\\b$');
        return regex.test(str);
    }
});

